var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/toolkit-cleaner/clean-objects.lambda.ts
var clean_objects_lambda_exports = {};
__export(clean_objects_lambda_exports, {
  handler: () => handler
});
module.exports = __toCommonJS(clean_objects_lambda_exports);
var path = __toESM(require("path"));
var import_aws_sdk = require("aws-sdk");
var s3 = new import_aws_sdk.S3();
async function handler(assetHashes) {
  var _a;
  if (!process.env.BUCKET_NAME) {
    throw new Error("Missing BUCKET_NAME");
  }
  let deleted = 0;
  let reclaimed = 0;
  let nextKeyMarker;
  let finished = false;
  while (!finished) {
    const response = await s3.listObjectVersions({
      Bucket: process.env.BUCKET_NAME,
      KeyMarker: nextKeyMarker
    }).promise();
    const toDelete = (_a = response.Versions) == null ? void 0 : _a.filter((v) => {
      if (!v.Key) {
        return false;
      }
      const hash = path.basename(v.Key, path.extname(v.Key));
      let pred = !assetHashes.includes(hash);
      if (process.env.RETAIN_MILLISECONDS) {
        if (!v.LastModified) {
          return false;
        }
        const limitDate = new Date(Date.now() - parseInt(process.env.RETAIN_MILLISECONDS));
        pred = pred && v.LastModified < limitDate;
      }
      return pred;
    });
    if (toDelete && toDelete.length !== 0) {
      if (process.env.RUN) {
        await s3.deleteObjects({
          Bucket: process.env.BUCKET_NAME,
          Delete: {
            Objects: toDelete.map((v) => ({ Key: v.Key, VersionId: v.VersionId }))
          }
        }).promise();
      }
      deleted += toDelete.length;
      reclaimed += toDelete.reduce((acc, x) => acc + (x.Size ?? 0), 0);
    }
    nextKeyMarker = response.NextKeyMarker;
    if (nextKeyMarker === void 0) {
      finished = true;
    }
  }
  return {
    Deleted: deleted,
    Reclaimed: reclaimed
  };
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  handler
});
