# Colors

"""Support module that provides a large number of different colorsets 
(r,g,b) which is especially usefull, when drawing many different curves
on the same graph. The list of colorsets can be filtered through a 
number of filter functions that allow only shades of a certain color to
pass through. This helps grouping graphs with similar colors.
"""

from Compatibility import *


########################################################################
#
#   colors
#
########################################################################

##~ BLACK  = (0.0, 0.0, 0.0)
##~ WHITE  = (1.0, 1.0, 1.0)
##~ RED    = (1.0, 0.0, 0.0)
##~ GREEN  = (0.0, 1.0, 0.0)
##~ BLUE   = (0.0, 0.0, 1.0)
##~ YELLOW = (1.0, 1.0, 0.0)
##~ TURKEY = (0.0, 1.0, 1.0)
##~ PINK   = (1.0, 0.0, 1.0)

colors=(
(0.00,0.00,0.50), (1.00,1.00,0.00), (0.33,1.00,1.00), (1.00,0.00,1.00), 
(0.00,1.00,0.00), (1.00,0.00,0.00), (1.00,0.67,0.67), (0.40,0.40,0.00), 
(0.33,0.33,1.00), (0.00,0.60,0.60), (0.40,1.00,0.40), (0.60,0.00,0.40), 
(0.50,0.50,0.50), (1.00,0.50,0.00), (0.00,0.00,1.00), (0.67,0.67,1.00), 
(0.00,0.20,0.00), (1.00,0.20,0.40), (0.60,0.80,0.00), (0.50,0.00,0.00), 
(0.00,1.00,0.50), (0.80,1.00,0.80), (0.00,0.67,1.00), (0.00,0.60,0.20), 
(0.60,0.00,0.80), (0.80,1.00,0.40), (1.00,0.40,1.00), (0.20,0.00,0.20), 
(1.00,0.80,1.00), (0.00,1.00,1.00), (0.00,0.33,1.00), (0.33,0.00,1.00), 
(0.33,0.67,1.00), (0.33,1.00,0.00), (0.67,0.33,1.00), (1.00,0.67,0.33), 
(1.00,0.00,0.67), (0.60,0.80,0.60), (0.80,0.40,0.60), (0.40,0.20,0.60), 
(0.20,0.40,0.40), (0.80,0.40,0.20), (0.33,0.67,0.33), (0.33,0.67,0.67), 
(0.67,0.67,0.33), (0.20,0.60,0.00), (0.40,0.20,0.20), (0.60,1.00,0.20), 
(0.80,0.00,0.20), (0.80,0.20,0.00), (1.00,1.00,0.60), (0.00,0.33,0.67), 
(0.80,0.20,0.80), (0.33,1.00,0.67), (0.20,0.20,0.80), (0.60,1.00,1.00), 
(0.80,0.60,0.80), (0.00,0.80,0.80), (0.20,1.00,0.20), (0.50,0.50,1.00), 
(1.00,0.50,0.50), (0.80,0.80,0.20), (0.00,0.50,0.00), (0.20,0.00,0.60), 
(0.00,0.20,0.40), (0.80,0.60,0.00), (0.00,0.80,0.40), (0.40,0.40,0.80), 
(1.00,0.33,0.67), (1.00,0.00,0.33), (1.00,1.00,0.33), (0.67,0.00,1.00), 
(0.67,1.00,0.00), (0.80,0.00,0.60), (0.40,0.80,0.80), (0.00,0.40,0.20), 
(0.20,0.40,0.60), (0.40,0.00,0.40), (0.40,0.00,0.80), (0.40,0.80,0.00), 
(0.60,0.20,0.20), (0.60,0.20,0.60), (0.60,0.40,0.00), (0.60,0.40,0.80), 
(0.00,0.00,0.20), (0.00,0.20,0.20), (0.00,0.40,0.40), (0.00,1.00,0.20), 
(0.20,0.00,0.00), (0.20,0.00,0.40), (0.20,0.20,0.00), (0.20,0.20,0.20), 
(0.20,0.20,0.40), (0.20,0.40,0.00), (0.20,0.40,0.20), (0.20,0.80,0.40), 
(0.20,0.80,0.80), (0.40,0.00,0.20), (0.40,0.20,0.00), (0.40,0.20,0.40), 
(0.40,0.40,0.20), (0.40,0.80,0.20), (0.60,0.20,0.40), (0.80,0.40,0.40), 
(1.00,0.20,0.20), (1.00,0.20,1.00), (0.00,0.00,0.80), (0.00,0.60,0.40), 
(0.00,0.60,0.80), (0.00,0.80,0.00), (0.00,0.80,0.20), (0.00,0.80,0.60), 
(0.00,1.00,0.80), (0.20,0.00,0.80), (0.20,0.20,0.60), (0.20,0.40,0.80), 
(0.20,0.60,0.80), (0.20,0.80,0.00), (0.20,0.80,0.20), (0.20,0.80,0.60), 
(0.20,1.00,0.40), (0.40,0.00,0.60), (0.40,0.20,0.80), (0.40,0.60,0.00), 
(0.40,1.00,0.20), (0.60,0.00,0.20), (0.60,0.00,0.60), (0.60,0.20,0.00), 
(0.60,0.20,0.80), (0.60,0.40,0.20), (0.60,0.60,0.00), (0.60,0.60,0.80), 
(0.60,0.80,0.20), (0.60,0.80,0.80), (0.60,1.00,0.40), (0.60,1.00,0.60), 
(0.60,1.00,0.80), (0.80,0.00,0.00), (0.80,0.00,0.40), (0.80,0.00,0.80), 
(0.80,0.20,0.20), (0.80,0.20,0.40), (0.80,0.20,0.60), (0.80,0.40,0.00), 
(0.80,0.40,0.80), (0.80,0.60,0.20), (0.80,0.60,0.60), (0.80,0.80,0.00), 
(0.80,0.80,0.40), (0.80,0.80,0.60), (0.80,0.80,0.80), (0.80,1.00,0.20), 
(0.80,1.00,0.60), (0.80,1.00,1.00), (1.00,0.20,0.00), (1.00,0.40,0.20), 
(1.00,0.60,1.00), (1.00,0.80,0.00), (0.20,0.60,0.20), (0.80,0.80,1.00), 
(1.00,0.80,0.80), (0.00,0.20,0.80), (0.20,0.80,1.00), (0.20,1.00,0.80), 
(0.80,0.20,1.00), (1.00,0.20,0.80), (1.00,0.80,0.20), (0.20,0.20,1.00), 
(0.60,0.60,0.60), (0.60,0.40,0.60), (0.40,0.40,0.60), (0.60,0.40,0.40), 
(0.40,0.40,0.40), (0.00,0.50,1.00), (0.50,0.00,1.00), (0.50,1.00,0.00), 
(1.00,0.00,0.50), (0.40,0.80,0.40), (0.40,0.60,0.80), (0.40,0.80,0.60), 
(0.60,0.80,0.40), (0.80,0.60,0.40), (0.20,0.60,0.40), (0.40,0.60,0.20), 
(0.20,0.60,0.60), (0.60,0.60,0.20), (0.00,0.40,0.80), (0.40,0.80,1.00), 
(0.40,1.00,0.80), (0.80,0.40,1.00), (1.00,0.40,0.80), (1.00,0.80,0.40), 
(0.60,0.80,1.00), (0.80,0.60,1.00), (1.00,0.60,0.80), (1.00,0.80,0.60), 
(1.00,0.33,0.33), (0.20,0.40,1.00), (0.40,0.20,1.00), (0.00,0.20,0.60), 
(0.20,0.60,1.00), (0.20,1.00,0.60), (0.60,0.20,1.00), (1.00,0.20,0.60), 
(1.00,0.60,0.20), (0.00,0.50,0.50), (0.50,0.00,0.50), (0.50,0.50,0.00), 
(0.50,1.00,0.50), (0.00,0.00,0.67), (0.00,0.67,0.00), (0.00,1.00,0.67), 
(0.67,0.00,0.00), (1.00,0.67,0.00), (0.00,0.80,1.00), (0.80,0.00,1.00), 
(0.80,1.00,0.00), (1.00,0.00,0.80), (0.00,0.00,0.33), (0.00,0.33,0.00), 
(0.00,1.00,0.33), (0.33,0.00,0.00), (1.00,0.33,0.00), (0.00,0.20,1.00), 
(0.20,0.00,1.00), (0.20,1.00,0.00), (0.20,1.00,1.00), (1.00,0.00,0.20), 
(1.00,1.00,0.20), (0.33,0.33,0.33), (0.33,0.33,0.67), (0.67,0.33,0.33), 
(0.40,0.60,0.40), (0.67,0.33,0.67), (0.40,0.60,0.60), (0.60,0.60,0.40), 
(0.67,0.67,0.67), (0.50,1.00,1.00), (1.00,1.00,0.50), (1.00,0.50,1.00), 
(0.00,0.33,0.33), (0.33,0.00,0.33), (0.33,0.33,0.00), (0.33,1.00,0.33), 
(0.40,0.40,1.00), (1.00,0.40,0.40), (0.00,0.67,0.33), (0.33,0.00,0.67), 
(0.33,0.67,0.00), (0.67,0.00,0.33), (0.67,0.33,0.00), (0.67,1.00,0.33), 
(0.00,0.40,0.60), (0.40,0.60,1.00), (0.40,1.00,0.60), (0.60,0.40,1.00), 
(1.00,0.40,0.60), (1.00,0.60,0.40), (0.00,0.67,0.67), (0.67,0.00,0.67), 
(0.67,0.67,0.00), (0.67,1.00,0.67), (0.60,0.60,1.00), (1.00,0.60,0.60), 
(1.00,0.33,1.00), (0.00,0.00,0.40), (0.00,0.40,0.00), (0.00,0.40,1.00), 
(0.00,1.00,0.40), (0.40,0.00,0.00), (0.40,0.00,1.00), (0.40,1.00,0.00), 
(0.40,1.00,1.00), (1.00,0.00,0.40), (1.00,0.40,0.00), (1.00,1.00,0.40), 
(0.67,1.00,1.00), (1.00,0.67,1.00), (1.00,1.00,0.67), (0.00,0.00,0.60), 
(0.00,0.60,0.00), (0.00,0.60,1.00), (0.00,1.00,0.60), (0.60,0.00,0.00), 
(0.60,0.00,1.00), (0.60,1.00,0.00), (1.00,0.00,0.60), (1.00,0.60,0.00)
)


########################################################################
#
#  color filters
#
########################################################################

def RedFilter(c):
    """Returns True if color can be classified as a shade of red"""
    if (c[0] > c[1]) and (c[0] > c[2]) and (c[1] == c[2]):  return True
    else:  return False
    
def GreenFilter(c):
    """Returns True if color can be classified as a shade of green"""
    if (c[1] > c[0]) and (c[1] > c[2]) and (c[0] == c[2]):  return True
    else:  return False
    
def BlueFilter(c):
    """Returns True if color can be classified as a shade of blue"""
    if (c[2] > c[1]) and (c[2] > c[0]) and (c[1] == c[0]):  return True
    else:  return False
    
def YellowFilter(c):
    """Returns True if color can be classified as a shade of yellow"""
    if (c[0] > c[2]) and (c[1] > c[2]) and (c[0] == c[1]):  return True
    else:  return False
    
def PinkFilter(c):
    """Returns True if color can be classified as a shade of pink"""
    if (c[0] > c[1]) and (c[2] > c[1]) and (c[2] == c[0]):  return True
    else:  return False
    
def TurkeyFilter(c):
    """Returns True if color can be classified as a shade of turkey"""
    if (c[2] > c[0]) and (c[1] > c[0]) and (c[2] == c[1]):  return True
    else:  return False    

