# coding: utf-8

"""
    Passage Management API

    Passage's management API to manage your Passage apps and users.

    The version of the OpenAPI document: 1
    Contact: support@passage.id
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, ClassVar, Dict, List
from pydantic import BaseModel
from pydantic import Field
from passageidentity.openapi_client.models.link import Link
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class PaginatedLinks(BaseModel):
    """
    PaginatedLinks
    """ # noqa: E501
    first: Link
    last: Link
    next: Link
    previous: Link
    var_self: Link = Field(alias="self")
    __properties: ClassVar[List[str]] = ["first", "last", "next", "previous", "self"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of PaginatedLinks from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of first
        if self.first:
            _dict['first'] = self.first.to_dict()
        # override the default output from pydantic by calling `to_dict()` of last
        if self.last:
            _dict['last'] = self.last.to_dict()
        # override the default output from pydantic by calling `to_dict()` of next
        if self.next:
            _dict['next'] = self.next.to_dict()
        # override the default output from pydantic by calling `to_dict()` of previous
        if self.previous:
            _dict['previous'] = self.previous.to_dict()
        # override the default output from pydantic by calling `to_dict()` of var_self
        if self.var_self:
            _dict['self'] = self.var_self.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of PaginatedLinks from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "first": Link.from_dict(obj.get("first")) if obj.get("first") is not None else None,
            "last": Link.from_dict(obj.get("last")) if obj.get("last") is not None else None,
            "next": Link.from_dict(obj.get("next")) if obj.get("next") is not None else None,
            "previous": Link.from_dict(obj.get("previous")) if obj.get("previous") is not None else None,
            "self": Link.from_dict(obj.get("self")) if obj.get("self") is not None else None
        })
        return _obj


