# coding: utf-8

"""
    Passage Management API

    Passage's management API to manage your Passage apps and users.

    The version of the OpenAPI document: 1
    Contact: support@passage.id
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, ClassVar, Dict, List
from pydantic import BaseModel, StrictStr, field_validator
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class Model404Error(BaseModel):
    """
    Model404Error
    """ # noqa: E501
    code: StrictStr
    error: StrictStr
    __properties: ClassVar[List[str]] = ["code", "error"]

    @field_validator('code')
    def code_validate_enum(cls, value):
        """Validates the enum"""
        if value not in ('admin_not_found', 'api_key_not_found', 'app_not_found', 'device_not_found', 'domain_not_found', 'email_provider_not_found', 'email_template_not_found', 'event_not_found', 'function_not_found', 'function_secret_key_not_found', 'function_version_not_found', 'metadata_field_not_found', 'oauth2_app_not_found', 'organization_member_not_found', 'sms_provider_not_found', 'sms_template_not_found', 'social_connection_not_found', 'user_not_found'):
            raise ValueError("must be one of enum values ('admin_not_found', 'api_key_not_found', 'app_not_found', 'device_not_found', 'domain_not_found', 'email_provider_not_found', 'email_template_not_found', 'event_not_found', 'function_not_found', 'function_secret_key_not_found', 'function_version_not_found', 'metadata_field_not_found', 'oauth2_app_not_found', 'organization_member_not_found', 'sms_provider_not_found', 'sms_template_not_found', 'social_connection_not_found', 'user_not_found')")
        return value

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of Model404Error from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of Model404Error from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "code": obj.get("code"),
            "error": obj.get("error")
        })
        return _obj


