# coding: utf-8

"""
    Passage Management API

    Passage's management API to manage your Passage apps and users.

    The version of the OpenAPI document: 1
    Contact: support@passage.id
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, ClassVar, Dict, List
from pydantic import BaseModel, StrictBool, StrictInt, StrictStr
from passageidentity.openapi_client.models.magic_link_type import MagicLinkType
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class MagicLink(BaseModel):
    """
    MagicLink
    """ # noqa: E501
    activated: StrictBool
    app_id: StrictStr
    id: StrictStr
    identifier: StrictStr
    redirect_url: StrictStr
    secret: StrictStr
    ttl: StrictInt
    type: MagicLinkType
    url: StrictStr
    user_id: StrictStr
    __properties: ClassVar[List[str]] = ["activated", "app_id", "id", "identifier", "redirect_url", "secret", "ttl", "type", "url", "user_id"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of MagicLink from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of MagicLink from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "activated": obj.get("activated"),
            "app_id": obj.get("app_id"),
            "id": obj.get("id"),
            "identifier": obj.get("identifier"),
            "redirect_url": obj.get("redirect_url"),
            "secret": obj.get("secret"),
            "ttl": obj.get("ttl"),
            "type": obj.get("type"),
            "url": obj.get("url"),
            "user_id": obj.get("user_id")
        })
        return _obj


