# coding: utf-8

"""
    Passage Management API

    Passage's management API to manage your Passage apps and users.

    The version of the OpenAPI document: 1
    Contact: support@passage.id
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, ClassVar, Dict, List
from pydantic import BaseModel, StrictInt
from pydantic import Field
from passageidentity.openapi_client.models.list_paginated_users_item import ListPaginatedUsersItem
from passageidentity.openapi_client.models.paginated_links import PaginatedLinks
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class ListPaginatedUsersResponse(BaseModel):
    """
    ListPaginatedUsersResponse
    """ # noqa: E501
    links: PaginatedLinks = Field(alias="_links")
    created_before: StrictInt = Field(description="time anchor (Unix timestamp) --> all users returned created before this timestamp")
    limit: StrictInt
    page: StrictInt
    total_users: StrictInt = Field(description="total number of users for a particular query")
    users: List[ListPaginatedUsersItem]
    __properties: ClassVar[List[str]] = ["_links", "created_before", "limit", "page", "total_users", "users"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of ListPaginatedUsersResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of links
        if self.links:
            _dict['_links'] = self.links.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in users (list)
        _items = []
        if self.users:
            for _item in self.users:
                if _item:
                    _items.append(_item.to_dict())
            _dict['users'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of ListPaginatedUsersResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "_links": PaginatedLinks.from_dict(obj.get("_links")) if obj.get("_links") is not None else None,
            "created_before": obj.get("created_before"),
            "limit": obj.get("limit"),
            "page": obj.get("page"),
            "total_users": obj.get("total_users"),
            "users": [ListPaginatedUsersItem.from_dict(_item) for _item in obj.get("users")] if obj.get("users") is not None else None
        })
        return _obj


