# coding: utf-8

"""
    Passage Management API

    Passage's management API to manage your Passage apps and users.

    The version of the OpenAPI document: 1
    Contact: support@passage.id
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, ClassVar, Dict, List, Optional
from pydantic import BaseModel, StrictInt, StrictStr
from pydantic import Field
from passageidentity.openapi_client.models.font_family import FontFamily
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class ElementCustomization(BaseModel):
    """
    ElementCustomization
    """ # noqa: E501
    passage_container_background_color: Optional[StrictStr] = Field(default=None, description="Container background color in hex. Default is `#ffffff` in light mode & `#383838` in dark mode. ")
    passage_container_max_width: Optional[StrictInt] = Field(default=300, description="Maximum width of container (px)")
    passage_input_box_background_color: Optional[StrictStr] = Field(default=None, description="Input box background color in hex. Default is `#ffffff` in light mode & `#4b4b4b` in dark mode. ")
    passage_input_box_border_radius: Optional[StrictInt] = Field(default=5, description="Input box border radius (px)")
    passage_header_font_family: Optional[FontFamily] = None
    passage_body_font_family: Optional[FontFamily] = None
    passage_header_text_color: Optional[StrictStr] = Field(default=None, description="Header text color in hex. Default is `#222222` in light mode & `#f3f3f3` in dark mode. ")
    passage_body_text_color: Optional[StrictStr] = Field(default=None, description="Body text color in hex. Default is `#222222` in light mode & `#f3f3f3` in dark mode. ")
    passage_primary_button_background_color: Optional[StrictStr] = Field(default='#121212', description="Primary button background colour (hex)")
    passage_primary_button_text_color: Optional[StrictStr] = Field(default='#f3f3f3', description="Primary button font colour (hex)")
    passage_primary_button_hover_color: Optional[StrictStr] = Field(default='#4d4d4d', description="Primary button background on hover (hex)")
    passage_primary_button_border_radius: Optional[StrictInt] = Field(default=5, description="Primary button border radius (px)")
    passage_primary_button_border_color: Optional[StrictStr] = Field(default='#121212', description="Primary button border color")
    passage_primary_button_border_width: Optional[StrictInt] = Field(default=0, description="Primary button border width (px)")
    passage_secondary_button_background_color: Optional[StrictStr] = Field(default='#ffffff', description="Secondary button background colour (hex)")
    passage_secondary_button_text_color: Optional[StrictStr] = Field(default='#222222', description="Secondary button font colour (hex)")
    passage_secondary_button_hover_color: Optional[StrictStr] = Field(default='#d7d7d7', description="Secondary button background on hover (hex)")
    passage_secondary_button_border_radius: Optional[StrictInt] = Field(default=5, description="Secondary button border radius (px)")
    passage_secondary_button_border_color: Optional[StrictStr] = Field(default='#d7d7d7', description="Secondary button border color")
    passage_secondary_button_border_width: Optional[StrictInt] = Field(default=1, description="Secondary button border width (px)")
    __properties: ClassVar[List[str]] = ["passage_container_background_color", "passage_container_max_width", "passage_input_box_background_color", "passage_input_box_border_radius", "passage_header_font_family", "passage_body_font_family", "passage_header_text_color", "passage_body_text_color", "passage_primary_button_background_color", "passage_primary_button_text_color", "passage_primary_button_hover_color", "passage_primary_button_border_radius", "passage_primary_button_border_color", "passage_primary_button_border_width", "passage_secondary_button_background_color", "passage_secondary_button_text_color", "passage_secondary_button_hover_color", "passage_secondary_button_border_radius", "passage_secondary_button_border_color", "passage_secondary_button_border_width"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of ElementCustomization from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of ElementCustomization from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "passage_container_background_color": obj.get("passage_container_background_color"),
            "passage_container_max_width": obj.get("passage_container_max_width") if obj.get("passage_container_max_width") is not None else 300,
            "passage_input_box_background_color": obj.get("passage_input_box_background_color"),
            "passage_input_box_border_radius": obj.get("passage_input_box_border_radius") if obj.get("passage_input_box_border_radius") is not None else 5,
            "passage_header_font_family": obj.get("passage_header_font_family"),
            "passage_body_font_family": obj.get("passage_body_font_family"),
            "passage_header_text_color": obj.get("passage_header_text_color"),
            "passage_body_text_color": obj.get("passage_body_text_color"),
            "passage_primary_button_background_color": obj.get("passage_primary_button_background_color") if obj.get("passage_primary_button_background_color") is not None else '#121212',
            "passage_primary_button_text_color": obj.get("passage_primary_button_text_color") if obj.get("passage_primary_button_text_color") is not None else '#f3f3f3',
            "passage_primary_button_hover_color": obj.get("passage_primary_button_hover_color") if obj.get("passage_primary_button_hover_color") is not None else '#4d4d4d',
            "passage_primary_button_border_radius": obj.get("passage_primary_button_border_radius") if obj.get("passage_primary_button_border_radius") is not None else 5,
            "passage_primary_button_border_color": obj.get("passage_primary_button_border_color") if obj.get("passage_primary_button_border_color") is not None else '#121212',
            "passage_primary_button_border_width": obj.get("passage_primary_button_border_width") if obj.get("passage_primary_button_border_width") is not None else 0,
            "passage_secondary_button_background_color": obj.get("passage_secondary_button_background_color") if obj.get("passage_secondary_button_background_color") is not None else '#ffffff',
            "passage_secondary_button_text_color": obj.get("passage_secondary_button_text_color") if obj.get("passage_secondary_button_text_color") is not None else '#222222',
            "passage_secondary_button_hover_color": obj.get("passage_secondary_button_hover_color") if obj.get("passage_secondary_button_hover_color") is not None else '#d7d7d7',
            "passage_secondary_button_border_radius": obj.get("passage_secondary_button_border_radius") if obj.get("passage_secondary_button_border_radius") is not None else 5,
            "passage_secondary_button_border_color": obj.get("passage_secondary_button_border_color") if obj.get("passage_secondary_button_border_color") is not None else '#d7d7d7',
            "passage_secondary_button_border_width": obj.get("passage_secondary_button_border_width") if obj.get("passage_secondary_button_border_width") is not None else 1
        })
        return _obj


