# coding: utf-8

"""
    Passage Management API

    Passage's management API to manage your Passage apps and users.

    The version of the OpenAPI document: 1
    Contact: support@passage.id
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, ClassVar, Dict, List, Optional
from pydantic import BaseModel, StrictBool
from pydantic import Field	
from typing_extensions import Annotated	
from passageidentity.openapi_client.models.ttl_display_unit import TtlDisplayUnit
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

@DeprecationWarning
class UpdateOtpAuthMethod(BaseModel):
    """
    the UpdateOtpAuthMethod to exchange for an authentication token
    """ # noqa: E501
    enabled: Optional[StrictBool] = None
    ttl: Optional[Annotated[int, Field(strict=True, ge=60)]] = Field(default=300, description="Maximum time (IN SECONDS) for the auth to expire.") 
    ttl_display_unit: Optional[TtlDisplayUnit] = None
    __properties: ClassVar[List[str]] = ["enabled", "ttl", "ttl_display_unit"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of UpdateOtpAuthMethod from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of UpdateOtpAuthMethod from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "enabled": obj.get("enabled"),
            "ttl": obj.get("ttl") if obj.get("ttl") is not None else 300,
            "ttl_display_unit": obj.get("ttl_display_unit")
        })
        return _obj


