# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['enex2notion']

package_data = \
{'': ['*']}

install_requires = \
['PyMuPDF>=1.19.4,<2.0.0',
 'beautifulsoup4>=4.10.0,<5.0.0',
 'notion>=0.0.28,<0.0.29',
 'pdfkit>=1.0.0,<2.0.0',
 'progress>=1.6,<2.0',
 'python-dateutil>=2.8.2,<3.0.0',
 'requests>=2.26.0,<3.0.0',
 'tinycss2>=1.1.1,<2.0.0',
 'w3lib>=1.22.0,<2.0.0']

extras_require = \
{':python_version < "3.7"': ['dataclasses>=0.6']}

entry_points = \
{'console_scripts': ['enex2notion = enex2notion.cli:main']}

setup_kwargs = {
    'name': 'enex2notion',
    'version': '0.2.7',
    'description': 'Import Evernote ENEX files to Notion',
    'long_description': '# enex2notion\n\n[![PyPI version](https://img.shields.io/pypi/v/enex2notion?label=version)](https://pypi.python.org/pypi/enex2notion)\n[![Python Version](https://img.shields.io/pypi/pyversions/enex2notion.svg)](https://pypi.org/project/enex2notion/)\n[![tests](https://github.com/vzhd1701/enex2notion/actions/workflows/test.yml/badge.svg)](https://github.com/vzhd1701/enex2notion/actions/workflows/test.yml)\n[![codecov](https://codecov.io/gh/vzhd1701/enex2notion/branch/master/graph/badge.svg)](https://codecov.io/gh/vzhd1701/enex2notion)\n\nEasy way to import [Evernote\'s](https://www.evernote.com/) `*.enex` files to [Notion.so](https://notion.so)\n\nNotion\'s native Evernote importer doesn\'t do it for me, so I decided to write my own. Thanks to **Cobertos** and [md2notion](https://github.com/Cobertos/md2notion) for inspiration and **Jamie Alexandre** for [notion-py](https://github.com/jamalex/notion-py).\n\nYou can either use Evernote native export or try out my other tool, [evernote-backup](https://github.com/vzhd1701/evernote-backup), to export `*.enex` files from Evernote.\n\n### What is preserved\n\n- Embedded files and images are uploaded to Notion\n  - nested images will appear after paragraph\n- Text formatting (**bold**, _italic_, etc) and colors\n- Tables are converted to the new format (no colspans though)\n- Web Clips\n  - as plain text or PDFs, see [below](#web-clips)\n- Everything else basically\n\n### What is lost\n\n- Paragraph alignment\n- Subscript and superscript formatting\n- Custom fonts and font sizes\n- Tasks\n- Encrypted blocks\n  - just decrypt them before export\n\n## Installation\n\n[**Download the latest binary release**](https://github.com/vzhd1701/enex2notion/releases/latest) for your OS.\n\n### With PIP\n\n```bash\n$ pip install enex2notion\n```\n\n**Python 3.6 or later required.**\n\nOr, since **enex2notion** is a standalone tool, it might be more convenient to install it using [**pipx**](https://github.com/pipxproject/pipx):\n\n```shell\n$ pipx install enex2notion\n```\n\n### From source\n\nThis project uses [poetry](https://python-poetry.org/) for dependency management and packaging. You will have to install it first. See [poetry official documentation](https://python-poetry.org/docs/) for instructions.\n\n```shell\n$ git clone https://github.com/vzhd1701/enex2notion.git\n$ cd enex2notion/\n$ poetry install --no-dev\n$ poetry run enex2notion\n```\n\n## Usage\n\n```shell\n$ enex2notion --help\nusage: enex2notion [-h] [--token TOKEN] [--mode {DB,PAGE}] [--mode-webclips {TXT,PDF}] [--add-pdf-preview] [--add-meta] [--condense-lines] [--done-file FILE] [--log FILE] [--verbose] [--version] FILE/DIR [FILE/DIR ...]\n\nUploads ENEX files to Notion\n\npositional arguments:\n  FILE/DIR              ENEX files or directories to upload\n\noptional arguments:\n  -h, --help            show this help message and exit\n  --token TOKEN         Notion token, stored in token_v2 cookie for notion.so [NEEDED FOR UPLOAD]\n  --mode {DB,PAGE}      upload each ENEX as database (DB) or page with children (PAGE) (default: DB)\n  --mode-webclips {TXT,PDF}\n                        convert web clips to text (TXT) or pdf (PDF) before upload (default: TXT)\n  --add-pdf-preview     include preview image with PDF webclips for gallery view thumbnail (works only with --mode-webclips=PDF)\n  --add-meta            include metadata (created, tags, etc) in notes, makes sense only with PAGE mode\n  --condense-lines      condense text lines together into paragraphs to avoid making block per line\n  --done-file FILE      file for uploaded notes hashes to resume interrupted upload\n  --log FILE            file to store program log\n  --verbose             output debug information\n  --version             show program\'s version number and exit\n```\n\n### Input\n\nYou can pass single `*.enex` files or directories. The program will recursively scan directories for `*.enex` files.\n\n### Token & dry run mode\n\nThe upload requires you to have a `token_v2` cookie for the Notion website. For information on how to get it, see [this article](https://vzhd1701.notion.site/Find-Your-Notion-Token-5f57951434c1414d84ac72f88226eede).\n\nThe program can run without `--token` provided though. It will not make any network requests without it. Executing a dry run with `--verbose` is an excellent way to check if your `*.enex` files are parsed correctly before uploading.\n\n### Upload continuation\n\nThe upload will take some time since each note is uploaded block-by-block, so you\'ll probably need some way of resuming it. `--done-file` is precisely for that. All uploaded note hashes will be stored there, so the next time you start, the upload will continue from where you left off.\n\nAll uploaded notebooks will appear under the automatically created `Evernote ENEX Import` page. The program will mark unfinished notes with `[UNFINISHED UPLOAD]` text in the title. After successful upload, the mark will be removed.\n\n### Upload modes\n\nThe `--mode` option allows you to choose how to upload your notebooks: as databases or pages. `DB` mode is the default since Notion itself uses this mode when importing from Evernote. `PAGE` mode makes the tree feel like the original Evernote notebooks hierarchy.\n\nSince `PAGE` mode does not benefit from having separate space for metadata, you can still preserve the note\'s original meta with the `--add-meta` option. It will attach a callout block with all meta info as a first block in each note [like this](https://imgur.com/a/lJTbprH).\n\n### Web Clips\n\nDue to Notion\'s limitations Evernote web clips cannot be uploaded as-is. `enex2notion` provides two modes with the `--mode-webclips` option:\n\n- `TXT`, converting them to text, stripping all HTML formatting \\[Default\\]\n\n  - similar to Evernote\'s "Simplify & Make Editable"\n\n- `PDF`, converting them to PDF, keeping HTML formatting as close as possible\n\n  - web clips are converted using [wkhtmltopdf](https://wkhtmltopdf.org/), see [this page](https://github.com/JazzCore/python-pdfkit/wiki/Installing-wkhtmltopdf) on how to install it\n\nSince Notion\'s gallery view does not provide thumbnails for embedded PDFs, you have the `--add-pdf-preview` option to extract the first page of generated PDF as a preview for the web clip page.\n\n### Condense lines\n\nThe `--condense-lines` option is helpful if you want to save up some space and make notes look more compact. [Example](https://imgur.com/a/sV0X8z7).\n\n## Examples\n\n### Checking notes before upload\n\n```shell\n$ enex2notion --verbose my_notebooks/\n```\n\n### Uploading notes from a single notebook\n\n```shell\n$ enex2notion --token <YOUR_TOKEN_HERE> "notebook.enex"\n```\n\n### Uploading with the option to continue later\n\n```shell\n$ enex2notion --token <YOUR_TOKEN_HERE> --done-file done.txt "notebook.enex"\n```\n\n## Getting help\n\nIf you have encountered a bug or have an idea about a new feature, please [open a new issue](https://github.com/vzhd1701/enex2notion/issues/new/choose). If you have a question about the program or have difficulty using it, you are welcome to [the discussions page](https://github.com/vzhd1701/enex2notion/discussions). You can also mail me directly, I\'m always happy to help.\n',
    'author': 'vzhd1701',
    'author_email': 'vzhd1701@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/vzhd1701/enex2notion',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'entry_points': entry_points,
    'python_requires': '>=3.6.1,<4.0.0',
}


setup(**setup_kwargs)
