# Generated by Django 3.2.3 on 2022-05-23 09:53

import datetime
from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='AppDeviceManage',
            fields=[
                ('id', models.BigAutoField(help_text='Id', primary_key=True, serialize=False, verbose_name='Id')),
                ('description', models.CharField(blank=True, help_text='描述', max_length=255, null=True, verbose_name='描述')),
                ('modifier', models.CharField(blank=True, help_text='修改人', max_length=255, null=True, verbose_name='修改人')),
                ('dept_belong_id', models.CharField(blank=True, help_text='数据归属部门', max_length=255, null=True, verbose_name='数据归属部门')),
                ('update_datetime', models.DateTimeField(auto_now=True, help_text='修改时间', null=True, verbose_name='修改时间')),
                ('create_datetime', models.DateTimeField(auto_now_add=True, help_text='创建时间', null=True, verbose_name='创建时间')),
                ('device_id', models.CharField(max_length=255, verbose_name='设备标识号')),
                ('online_ip', models.CharField(blank=True, max_length=100, null=True, verbose_name='常在设备ip')),
                ('platform_type', models.IntegerField(choices=[(0, 'Windows'), (1, 'Linux'), (2, 'Android'), (3, 'Apple')], default=0, verbose_name='版本发布平台类型')),
            ],
            options={
                'verbose_name': '应用设备管理',
                'verbose_name_plural': '应用设备管理',
                'db_table': 'upgrade_center_app_device_manage',
                'ordering': ('-create_datetime',),
            },
        ),
        migrations.CreateModel(
            name='Application',
            fields=[
                ('id', models.BigAutoField(help_text='Id', primary_key=True, serialize=False, verbose_name='Id')),
                ('description', models.CharField(blank=True, help_text='描述', max_length=255, null=True, verbose_name='描述')),
                ('modifier', models.CharField(blank=True, help_text='修改人', max_length=255, null=True, verbose_name='修改人')),
                ('dept_belong_id', models.CharField(blank=True, help_text='数据归属部门', max_length=255, null=True, verbose_name='数据归属部门')),
                ('update_datetime', models.DateTimeField(auto_now=True, help_text='修改时间', null=True, verbose_name='修改时间')),
                ('create_datetime', models.DateTimeField(auto_now_add=True, help_text='创建时间', null=True, verbose_name='创建时间')),
                ('name', models.CharField(max_length=50, verbose_name='应用名称')),
                ('app_id', models.CharField(max_length=100, unique=True, verbose_name='应用标识')),
                ('creator', models.ForeignKey(db_constraint=False, help_text='创建人', null=True, on_delete=django.db.models.deletion.SET_NULL, related_query_name='creator_query', to=settings.AUTH_USER_MODEL, verbose_name='创建人')),
            ],
            options={
                'verbose_name': '应用管理',
                'verbose_name_plural': '应用管理',
                'db_table': 'upgrade_center_application',
                'ordering': ('-create_datetime',),
            },
        ),
        migrations.CreateModel(
            name='AppVersion',
            fields=[
                ('id', models.BigAutoField(help_text='Id', primary_key=True, serialize=False, verbose_name='Id')),
                ('description', models.CharField(blank=True, help_text='描述', max_length=255, null=True, verbose_name='描述')),
                ('modifier', models.CharField(blank=True, help_text='修改人', max_length=255, null=True, verbose_name='修改人')),
                ('dept_belong_id', models.CharField(blank=True, help_text='数据归属部门', max_length=255, null=True, verbose_name='数据归属部门')),
                ('update_datetime', models.DateTimeField(auto_now=True, help_text='修改时间', null=True, verbose_name='修改时间')),
                ('create_datetime', models.DateTimeField(auto_now_add=True, help_text='创建时间', null=True, verbose_name='创建时间')),
                ('version_number', models.CharField(max_length=100, verbose_name='版本号')),
                ('title', models.CharField(blank=True, max_length=50, null=True, verbose_name='版本标题')),
                ('content', models.CharField(blank=True, max_length=1000, null=True, verbose_name='版本内容')),
                ('upgrade_type', models.IntegerField(choices=[(0, '整包'), (1, '部分')], default=0, verbose_name='升级类型')),
                ('is_coerce_upgrade', models.BooleanField(default=False, verbose_name='是否强制升级')),
                ('platform', models.IntegerField(choices=[(0, 'Windows'), (1, 'Linux'), (2, 'Android'), (3, 'Apple')], default=0, verbose_name='版本发布平台')),
                ('download_url', models.CharField(blank=True, max_length=400, null=True, verbose_name='版本文件地址')),
                ('file_size', models.CharField(blank=True, max_length=20, null=True, verbose_name='文件大小')),
                ('file_md5', models.CharField(blank=True, max_length=40, null=True, verbose_name='文件md5')),
                ('status', models.IntegerField(choices=[(0, '待上线'), (1, '正式发布'), (2, '灰度内测'), (3, '版本回滚'), (4, '下线')], default=0, verbose_name='版本状态')),
                ('release_time', models.DateTimeField(default=datetime.datetime.now, verbose_name='发布时间')),
                ('application', models.ForeignKey(db_constraint=False, on_delete=django.db.models.deletion.PROTECT, to='dvadmin_upgrade_center.application', verbose_name='所属应用')),
                ('creator', models.ForeignKey(db_constraint=False, help_text='创建人', null=True, on_delete=django.db.models.deletion.SET_NULL, related_query_name='creator_query', to=settings.AUTH_USER_MODEL, verbose_name='创建人')),
            ],
            options={
                'verbose_name': '应用版本',
                'verbose_name_plural': '应用版本',
                'db_table': 'upgrade_center_app_version',
                'ordering': ['-release_time'],
                'unique_together': {('application', 'version_number')},
            },
        ),
        migrations.CreateModel(
            name='DeviceUpgrade',
            fields=[
                ('id', models.BigAutoField(help_text='Id', primary_key=True, serialize=False, verbose_name='Id')),
                ('description', models.CharField(blank=True, help_text='描述', max_length=255, null=True, verbose_name='描述')),
                ('modifier', models.CharField(blank=True, help_text='修改人', max_length=255, null=True, verbose_name='修改人')),
                ('dept_belong_id', models.CharField(blank=True, help_text='数据归属部门', max_length=255, null=True, verbose_name='数据归属部门')),
                ('update_datetime', models.DateTimeField(auto_now=True, help_text='修改时间', null=True, verbose_name='修改时间')),
                ('create_datetime', models.DateTimeField(auto_now_add=True, help_text='创建时间', null=True, verbose_name='创建时间')),
                ('upgrade_type', models.IntegerField(choices=[(1, '手动升级'), (2, '灰度内测'), (3, '版本回滚')], default=1, verbose_name='升级类型')),
                ('status', models.IntegerField(choices=[(0, '待完成'), (1, '已完成'), (2, '已失效'), (3, '手动取消')], default=0, verbose_name='升级状态')),
                ('is_coerce_upgrade', models.BooleanField(default=False, verbose_name='是否强制')),
                ('app_device_manage', models.ForeignKey(db_constraint=False, on_delete=django.db.models.deletion.CASCADE, to='dvadmin_upgrade_center.appdevicemanage', verbose_name='所属设备')),
                ('app_version', models.ForeignKey(db_constraint=False, on_delete=django.db.models.deletion.CASCADE, to='dvadmin_upgrade_center.appversion', verbose_name='升级版本')),
                ('creator', models.ForeignKey(db_constraint=False, help_text='创建人', null=True, on_delete=django.db.models.deletion.SET_NULL, related_query_name='creator_query', to=settings.AUTH_USER_MODEL, verbose_name='创建人')),
            ],
            options={
                'verbose_name': '应用设备升级',
                'verbose_name_plural': '应用设备升级',
                'db_table': 'upgrade_center_device_upgrade',
                'ordering': ('status', '-create_datetime'),
            },
        ),
        migrations.CreateModel(
            name='UpgradeLogging',
            fields=[
                ('id', models.BigAutoField(help_text='Id', primary_key=True, serialize=False, verbose_name='Id')),
                ('description', models.CharField(blank=True, help_text='描述', max_length=255, null=True, verbose_name='描述')),
                ('modifier', models.CharField(blank=True, help_text='修改人', max_length=255, null=True, verbose_name='修改人')),
                ('dept_belong_id', models.CharField(blank=True, help_text='数据归属部门', max_length=255, null=True, verbose_name='数据归属部门')),
                ('update_datetime', models.DateTimeField(auto_now=True, help_text='修改时间', null=True, verbose_name='修改时间')),
                ('create_datetime', models.DateTimeField(auto_now_add=True, help_text='创建时间', null=True, verbose_name='创建时间')),
                ('error_content', models.TextField(blank=True, help_text='错误日志内容', null=True, verbose_name='错误日志内容')),
                ('logging_type', models.IntegerField(choices=[(-1, '无变化'), (0, '正常升级'), (1, '手动升级'), (2, '灰度内测'), (3, '版本回滚'), (4, '错误日志')], default=1, verbose_name='日志类型')),
                ('ip', models.CharField(blank=True, help_text='登录ip', max_length=32, null=True, verbose_name='日志ip')),
                ('agent', models.TextField(blank=True, help_text='agent信息', null=True, verbose_name='agent信息')),
                ('browser', models.CharField(blank=True, help_text='浏览器名', max_length=200, null=True, verbose_name='浏览器名')),
                ('os', models.CharField(blank=True, help_text='操作系统', max_length=200, null=True, verbose_name='操作系统')),
                ('continent', models.CharField(blank=True, help_text='州', max_length=50, null=True, verbose_name='州')),
                ('country', models.CharField(blank=True, help_text='国家', max_length=50, null=True, verbose_name='国家')),
                ('province', models.CharField(blank=True, help_text='省份', max_length=50, null=True, verbose_name='省份')),
                ('city', models.CharField(blank=True, help_text='城市', max_length=50, null=True, verbose_name='城市')),
                ('district', models.CharField(blank=True, help_text='县区', max_length=50, null=True, verbose_name='县区')),
                ('isp', models.CharField(blank=True, help_text='运营商', max_length=50, null=True, verbose_name='运营商')),
                ('area_code', models.CharField(blank=True, help_text='区域代码', max_length=50, null=True, verbose_name='区域代码')),
                ('country_english', models.CharField(blank=True, help_text='英文全称', max_length=50, null=True, verbose_name='英文全称')),
                ('country_code', models.CharField(blank=True, help_text='简称', max_length=50, null=True, verbose_name='简称')),
                ('longitude', models.CharField(blank=True, help_text='经度', max_length=50, null=True, verbose_name='经度')),
                ('latitude', models.CharField(blank=True, help_text='纬度', max_length=50, null=True, verbose_name='纬度')),
                ('app_device_manage', models.ForeignKey(blank=True, db_constraint=False, null=True, on_delete=django.db.models.deletion.CASCADE, to='dvadmin_upgrade_center.appdevicemanage', verbose_name='所属设备')),
                ('app_version', models.ForeignKey(db_constraint=False, on_delete=django.db.models.deletion.CASCADE, to='dvadmin_upgrade_center.appversion', verbose_name='升级版本')),
                ('before_app_version', models.ForeignKey(blank=True, db_constraint=False, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='before_app_version_logging', to='dvadmin_upgrade_center.appversion', verbose_name='升级前版本')),
                ('creator', models.ForeignKey(db_constraint=False, help_text='创建人', null=True, on_delete=django.db.models.deletion.SET_NULL, related_query_name='creator_query', to=settings.AUTH_USER_MODEL, verbose_name='创建人')),
                ('device_upgrade', models.ForeignKey(blank=True, db_constraint=False, null=True, on_delete=django.db.models.deletion.CASCADE, to='dvadmin_upgrade_center.deviceupgrade', verbose_name='关联设备升级')),
            ],
            options={
                'verbose_name': '应用升级日志',
                'verbose_name_plural': '应用升级日志',
                'db_table': 'upgrade_center_logging',
                'ordering': ('-create_datetime',),
            },
        ),
        migrations.AddField(
            model_name='appdevicemanage',
            name='app_version',
            field=models.ForeignKey(blank=True, db_constraint=False, null=True, on_delete=django.db.models.deletion.CASCADE, to='dvadmin_upgrade_center.appversion', verbose_name='当前版本号'),
        ),
        migrations.AddField(
            model_name='appdevicemanage',
            name='application',
            field=models.ForeignKey(db_constraint=False, on_delete=django.db.models.deletion.CASCADE, to='dvadmin_upgrade_center.application', verbose_name='所属应用'),
        ),
        migrations.AddField(
            model_name='appdevicemanage',
            name='before_app_version',
            field=models.ForeignKey(blank=True, db_constraint=False, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='before_app_version_device', to='dvadmin_upgrade_center.appversion', verbose_name='升级前版本'),
        ),
        migrations.AddField(
            model_name='appdevicemanage',
            name='creator',
            field=models.ForeignKey(db_constraint=False, help_text='创建人', null=True, on_delete=django.db.models.deletion.SET_NULL, related_query_name='creator_query', to=settings.AUTH_USER_MODEL, verbose_name='创建人'),
        ),
        migrations.AlterUniqueTogether(
            name='appdevicemanage',
            unique_together={('application', 'device_id', 'platform_type')},
        ),
    ]
