""" 
Geometry information vectors data module.
Many emulated from: https://en.wikipedia.org/wiki/Molecular_geometry 
Except where otherwise indicated.

Developed by Michael Taylor and Jan Janssen.
"""

#### CN 1
single = [
    [0.0, 0.0, 2.0]
]

#### CN 2
linear = [
    [0.0, 0.0, 2.0],  # 0,1 trans
    [0.0, 0.0, -2.0]
]

# 120 degrees
bent_120 = [
    [0.0, 0.0, 2.0],
    [0.0, 1.62, -1.16]
]

# 109.5 degrees
bent_109 = [
    [0.0, 0.0, 2.0],
    [1.8856, 0.0, -0.667]
]

#### CN 3
# In x-y plane
trigonal_planar = [
    [2.0, 0.0, 0.0],
    [-1.16, -1.62, 0.0],
    [-1.16, 1.62, 0.0]
]

# tetrahedron minus one coordinate (109.5)
trigonal_pyramidal = [
    [-0.9428, -1.633, -0.667],
    [-0.9428, 1.633, -0.667],
    [1.8856, 0.0, -0.667]
]

t_shaped = [
    [2.0, 0.0, 0.0],  # 0,1 trans
    [-2.0, 0.0, 0.0],
    [0.0, 0.0, 2.0]
]

#### CN 4
# From Wolfram alpha
tetrahedral = [
    [0.0, 0.0, 2.0],
    [-0.9428, -1.633, -0.667],
    [-0.9428, 1.633, -0.667],
    [1.8856, 0.0, -0.667]
]

# orient with openings on Z-axis
square_planar = [
    [2.0, 0.0, 0.0], #0,1 Trans
    [-2.0, 0.0, 0.0],
    [0.0, 2.0, 0.0],
    [0.0, -2.0, 0.0]
]

seesaw = [
    [2.0, 0.0, 0.0], #0,1 Trans
    [-2.0, 0.0, 0.0],
    [0.0, 0.0, 2.0], 
    [0.0, 2.0, 0.0]
]

#### CN 5
# Orient along the Z axis - top as first index
square_pyramidal = [
    [2.0, 0.0, 0.0], # 0,1 trans
    [-2.0, 0.0, 0.0],
    [0.0, 0.0, 2.0],
    [0.0, 2.0, 0.0],
    [0.0, -2.0, 0.0]
]

# Orient along the Z axis - top as first index
trigonal_bipyramidal = [
    [0.0, 0.0, 2.0], #0,1 trans
    [0.0, 0.0, -2.0],
    [2.0, 0.0, 0.0],
    [-1.16, -1.62, 0.0],
    [-1.16, 1.62, 0.0]
]

# orient in x-y plane
pentagonal_planar = [
    [2.0, 0.0,  0.0],
    [0.618,  1.902,  0.0],
    [-1.618, 1.176, 0.0],
    [-1.618, -1.176, 0.0],
    [0.618, -1.902,  0.0]
]

#### CN 6
# Orient along the Z axis - top as first index, bottom as second index
octahedral = [
    [0.0, 0.0, 2.0], #0,1 trans
    [0.0, 0.0, -2.0],
    [2.0, 0.0, 0.0],
    [-2.0, 0.0, 0.0],
    [0.0, 2.0, 0.0],
    [0.0, -2.0, 0.0]
]

pentagonal_pyramidal = [
    [0.0,  0.0,  2.0],
    [2.0, 0.0,  0.0],
    [0.618,  1.902,  0.0],
    [-1.618, 1.176, 0.0],
    [-1.618, -1.176, 0.0],
    [0.618, -1.902,  0.0]
]

# from 10.1021/acs.chemrev.5b00537 -> 81.8 and 135.6 -> mirror through xy plane
trigonal_prismatic = [
    [1.511, 0.0, 1.31],
    [-0.756, 1.309, 1.309],
    [-0.756, -1.309, 1.309],
    [1.511, 0.0, -1.31],
    [-0.756, 1.309, -1.309],
    [-0.756, -1.309, -1.309]
]

# From scaled CSD structure IDOCUC
hexagonal_planar = [
    [-0.65907915,  1.55021705,  1.07816593], 
    [0.65907915, -1.55021705, -1.07816593],
    [1.24376928, -1.35453923,  0.78629604],
    [0.3243255,  0.01580621,  1.97346475],
    [-1.24372377,  1.35457048, -0.78631418],
    [-0.3243255, -0.01580621, -1.97346475]
]

#### CN 7
# Orient along the Z axis - top as first index, bottom as last index
pentagonal_bipyramidal = [
    [0.0,  0.0,  2.0], # 0,1 trans
    [0.0, 0.0, -2.0],
    [2.0, 0.0,  0.0],
    [0.618,  1.902,  0.0],
    [-1.618, 1.176, 0.0],
    [-1.618, -1.176, 0.0],
    [0.618, -1.902,  0.0],
]

# Capped octahedral / Capped trigonal prismatic
# # - > Have omitted because these are harder to define precisely for each system - the angles WILL shift
# Possibly handle at building state allowing for increased flexibility for ligand angles
capped_trigonal_prismatic = [
    [1.511, 0.0, 1.31],
    [-0.756, 1.309, 1.309],
    [-0.756, -1.309, 1.309],
    [1.511, 0.0, -1.31],
    [-0.756, 1.309, -1.309],
    [-0.756, -1.309, -1.309],
    [-2.0, 0.0, 0.0]  # Cap one
]

capped_octahedral = [
    [0.0, 0.0, 2.0],
    [2.0, 0.0, 0.0],
    [-2.0, 0.0, 0.0],
    [0.0, 2.0, 0.0],
    [0.0, -2.0, 0.0],
    [0.0, 0.0, -2.0],
    [1.155, 1.155, 1.155]  # Cap at perfect [1,1,1] vector position.
]

# From americium optimized CN 7
am_c3_7H2O_c0 = [
    [-1.9903440000000001, -1.1847919999999998, -0.8867699999999998],
    [0.909675, -2.182214, -0.7568589999999997],
    [-1.1172360000000001, -0.855194, 2.013797],
    [1.985406, -0.2440799999999994, 1.4697020000000003],
    [-0.136368, 2.0799260000000004, 1.3514940000000002],
    [1.725576, 0.7672469999999993, -1.570633],
    [-1.214674, 1.5844579999999997, -1.4806229999999998]
]

# From scaled CSD structure IDOCUC
hexagonal_pyramidal = [
    [-1.67952101, -0.93602997,  0.5505062],
    [-0.65907915,  1.55021705,  1.07816593],
    [1.24376928, -1.35453923,  0.78629604],
    [0.3243255,  0.01580621,  1.97346475],
    [0.65907915, -1.55021705, -1.07816593],
    [-1.24372377,  1.35457048, -0.78631418],
    [-0.3243255, -0.01580621, -1.97346475]
]

#### CN 8
square_antiprismatic = [  # 0,3 Trans, 4,7 trans
    [-1, 1., 1.], # Top 4 planar
    [1., 1., 1.],
    [-1, -1., 1.],
    [1., -1., 1.],
    [-1.41, 0., -1.], # Bottom 4 planar
    [0., -1.41, -1.],
    [ 1.41, 0., -1.],
    [0., 1.41, -1.]
]

square_prismatic = [
    [-1, 1., 1.], # Top 4 planar
    [1., 1., 1.],
    [-1, -1., 1.],
    [1., -1., 1.],
    [-1., 1., -1.],# Bottom 4 planar
    [-1., -1., -1.], 
    [1., -1., -1.],  
    [1., 1., -1.] 
]

# bicapped trigonal prismatic not an ideal shape for same reason as capped octahedral above.
bicapped_trigonal_prismatic = [
    [1.511, 0.0, 1.31],
    [-0.756, 1.309, 1.309],
    [-0.756, -1.309, 1.309],
    [1.511, 0.0, -1.31],
    [-0.756, 1.309, -1.309],
    [-0.756, -1.309, -1.309],
    [-2.0, 0.0, 0.0],  # Cap one
    [1.16, -1.62, 0]  # Cap 2
]

# From scaled CSD structure IDOCUC
hexagonal_bipyramidal = [
    [-1.67952101, -0.93602997,  0.5505062], # 0,1 trans
    [1.67952101,  0.93602997, -0.5505062], 
    [-0.65907915,  1.55021705,  1.07816593],
    [1.24376928, -1.35453923,  0.78629604],
    [0.3243255,  0.01580621,  1.97346475],
    [0.65907915, -1.55021705, -1.07816593],
    [-1.24372377,  1.35457048, -0.78631418],
    [-0.3243255, -0.01580621, -1.97346475],
]

# Dodecahedral: -> Not set to unit length 2 b/c points are not perfectly symmetric
# https://en.wikipedia.org/wiki/Snub_disphenoid
dodecahedral = [
    [1.289, 0.411, 0.0],
    [-1.289, 0.411, 0.0],
    [0.0, -0.411, 1.289],
    [0.0, -0.411, -1.289],
    [1.0, -1.568, 0.0],
    [-1.0, -1.568, 0.0],
    [0.0, 1.568, 1.0],
    [0.0, 1.568, -1.0]
]

# From scaled version of CSD refcode AFITIS
axial_bicapped_trigonal_prismatic = [
    [-0.77660752, 0.7455247,  1.68554848], #0,1 trans
    [0.84666207, -0.75727505, -1.64611599],
    [-1.89364682,  0.64292567, -0.02735548],
    [-1.1421033,  -0.44716888, -1.57975949],
    [-0.05187737, -1.12955356,  1.64967193],
    [1.08122157, -1.67863101,  0.11470761],
    [0.73916493,  1.67714792,  0.80050613],
    [1.25857889,  1.12625782, -1.07122477]
 ]

YEMSEP_geometry = [
    [1.59269395, -1.18695901,  0.23335443],
    [0.56942771,  0.35587479,  1.8839069],
    [-1.39238403,  0.49376956, -1.34813142],
    [1.67132559,  0.28821542, -1.06000125],
    [-1.30739281,  0.6635571,  1.36029997],
    [-0.33167467, -1.12199202, -1.62207454],
    [0.16217558,  1.99133131, -0.09109713],
    [-0.94157946, -1.64095331,  0.64861418]
]
# Mainly alkaline metals! Distorted planar structure with bidentate ligand cap on one side.
ICIGOT_geomtry = [
    [-1.37760039, -0.62439749,  1.30856598],
    [-1.61045832, -1.1341014 , -0.34675351],
    [-0.58337107,  0.69980213, -1.78043679],
    [-0.91106455,  1.77522437, -0.136161  ],
    [ 0.51673372, -0.97118193, -1.67026702],
    [ 1.48031468, -1.34417343, -0.04319998],
    [ 1.2649994 , -0.26374644,  1.52650396],
    [ 0.50488469,  1.51472279,  1.2044527 ]
]

#### CN 9
tricapped_trigonal_prismatic = [
    [1.511, 0.0, 1.31],
    [-0.756, 1.309, 1.309],
    [-0.756, -1.309, 1.309],
    [1.511, 0.0, -1.31],
    [-0.756, 1.309, -1.309],
    [-0.756, -1.309, -1.309],
    [-2.0, 0.0, 0.0],  # Cap one
    [1.16, -1.62, 0.0],  # Cap 2
    [1.16, 1.62, 0.0]  # Cap 3
]

# capped square antiprismatic -> WILL NOT BE PERFECT

capped_square_antiprismatic = [  # 0,3 Trans, 4,7 trans
    [-1, 1., 1.], # Top 4 planar
    [1., 1., 1.],
    [-1, -1., 1.],
    [1., -1., 1.],
    [-1.41, 0., -1.], # Bottom 4 planar
    [0., -1.41, -1.],
    [1.41, 0., -1.],
    [0., 1.41, -1.],
    [0.0, 0.0, 1.73]  # Cap at Z = 2
]

# From americium optimized CN 9
am_c3_9H2O_c0 = [
    [-2.582474, -0.13784200000000002, 0.0],
    [1.5365360000000001, -2.005628, 0.0],
    [1.159535, 2.2418929999999997, 0.0],
    [-0.9128550000000001, -1.540181, 1.830853],
    [1.631278, 0.015179999999999999, 1.964151],
    [-0.891344, 1.5299820000000002, 1.910085],
    [-0.9128550000000001, -1.540181, -1.830853],
    [1.631278, 0.015179999999999999, -1.964151],
    [-0.891344, 1.5299820000000002, -1.910085]
]

# from CSD refcode: QIJZOA
tri_tri_mer_capped = [
    [-0.32238184,  0.16659695, -1.96680335],
    [1.82278439, -0.4760481,  0.6714427],
    [-1.5538406,  0.32203597,  1.21732174],
    [-1.5667759, -0.94884186, -0.80306439],
    [1.26907643,  1.11747728, -1.06803068],
    [0.88550201, -1.6263115, -0.75564351],
    [0.83666247,  1.1675889,  1.39166521],
    [-0.41252724, -1.36401551,  1.40331143],
    [-0.99299587,  1.7306856, -0.13669874]
]

cn9_YICLED = [
    [-0.73129978,  1.86149803,  0.00506967],
    [-0.22300553, -1.76168176,  0.92018797],
    [0.78199151, -1.3247804, -1.27806345],
    [1.8349274, -0.70560597,  0.36764335],
    [-1.65648586, -0.85120653, -0.72904185],
    [-1.39762593, -0.05925097,  1.42938136],
    [-0.28258387,  0.36209915, -1.94654323],
    [1.54815536,  1.1160205, -0.59809132],
    [0.79757419,  0.74168697,  1.67743132]
]

# CN 10!!!!!
# From TEYDAE CSD refocde
axial_bicapped_hexagonal_planar = [
    [-1.86281576,  0.06020958, -0.72546002], # 0,1 trans
    [1.86281576,  0.06020958,  0.72546002],
    [-0.65427417, -1.79359695, -0.59576447],
    [-1.23433283,  1.57281414, -0.05175061],
    [-0.00766799,  0.70251884,  1.87254065],
    [-1.23148994, -0.52774663,  1.48489596],
    [0.65420987, -1.79364224,  0.5956987],
    [1.23433412,  1.57281579,  0.0516698],
    [0.00758642,  0.70251895, -1.87254094],
    [1.23140247, -0.52774392, -1.48496947]
]

cn10_XEGBUJ = [
    [-0.90778422, -1.14672351,  1.36416751],
    [ 0.70465953, -0.0700688 ,  1.87043987],
    [ 1.73758057, -0.90317029,  0.40632153],
    [ 0.1838802 , -1.98897435, -0.10084207],
    [-1.16106015,  1.07617495, -1.22220572],
    [-0.20748992,  1.98586861,  0.11521204],
    [ 1.47760231,  1.22212455, -0.56842149],
    [ 0.37568807,  0.26515094, -1.94642068],
    [-1.78699756, -0.65455068, -0.61498222],
    [-1.88456755,  0.45635632,  0.49004496]
]

cn10_GAKDAY = [
    [ 0.95176154,  0.2296667 ,  1.74396192],
    [-0.23453734, -1.02455784,  1.70155032],
    [-0.82373775,  1.47467392, -1.07088419],
    [-0.85799219, -0.10221048, -1.80371905],
    [ 1.3795416 ,  1.44754365, -0.03850116],
    [ 1.23170122,  0.47358171, -1.50287474],
    [-0.87528158,  1.3565864 ,  1.18048951],
    [-1.95760278, -0.31097544,  0.26661888],
    [-0.14886603, -1.91187203, -0.56796502],
    [ 1.69799316, -1.05099774,  0.11055758]
]

# CN 11
cn11_YIJQOX = [
    [-1.47814381,  1.28796937,  0.39525408],
    [-0.15260552,  1.65454718,  1.11318694],
    [ 0.        , -2.        ,  0.        ],
    [-1.19667756, -0.06891997, -1.6010037 ],
    [ 0.72956186, -0.64059262, -1.7485367 ],
    [ 1.75687051, -0.94750177, -0.12508555],
    [ 1.47815353,  1.28797784, -0.39519014],
    [ 0.15260843,  1.65457864, -1.11313979],
    [ 1.19664633, -0.06891817,  1.60102712],
    [-0.72953951, -0.64057298,  1.74855322],
    [-1.75686662, -0.94749967,  0.12515618]
]

cn11_UTINUI = [
    [ 1.84171835,  0.        ,  0.77979069],
    [-1.51983183,  1.15163549, -0.60319724],
    [ 1.41417688,  0.        , -1.41425024],
    [-0.09999451,  0.        , -1.99749871],
    [-1.45980226,  0.        ,  1.36710547],
    [ 0.03091048,  0.        ,  1.99976112],
    [ 0.05646391,  1.79889661,  0.87222865],
    [ 0.71232313,  1.76380012, -0.61774177],
    [-1.51983183, -1.15163549, -0.60319724],
    [ 0.05646391, -1.79889661,  0.87222865],
    [ 0.71232313, -1.76380012, -0.61774177]
]

cn11_CABLEW = [
    [ 0.69097821, -0.88860352, -1.65315846],
    [-1.24341248, -1.09038293, -1.12471794],
    [-1.12316436, -1.41281227,  0.86166311],
    [ 0.53024113, -0.73809447,  1.78158943],
    [ 1.54547223, -1.25935655,  0.15980194],
    [-0.20323257,  1.96338273, -0.32221851],
    [-0.39266516,  0.98618816, -1.69506548],
    [ 1.28910533,  1.16062463,  0.99556913],
    [ 1.65668518,  0.93095552, -0.62347097],
    [-1.89578636,  0.62758265,  0.1101549 ],
    [-0.9665372 ,  0.8513787 ,  1.53001965]
]

# CN 12!!!!!!
# From Refcode: QERRIP
penta_bi_capped_pyramidal = [
    [1.94669217, -0.00263606,  0.45867487], #0,1 trans
    [-1.94669638, -0.00263596, -0.45865703],
    [0.80732904, -1.82239409, -0.16461956],
    [1.04605529, -0.25227919, -1.68585988],
    [-0.41002572, -0.89431687, -1.7412858],
    [-0.42780953,  1.32200287, -1.438501],
    [0.97354769,  1.61530666, -0.66557439],
    [-0.80732904, -1.82239409,  0.16461956],
    [-1.04614067, -0.25228214,  1.68580646],
    [0.41002572, -0.89431687,  1.7412858],
    [0.42774741,  1.32205074,  1.43847627],
    [-0.97360413,  1.61527759,  0.66556241]
]

senrag_comp_1 = [
    [0.9352113572155474, 0.12635521146840892, -0.3307779887928269], #0,1 trans
    [-0.9352113572155473, -0.12635521146840892, 0.3307779887928272],
    [-0.5133570498409805, 0.8578380969153261, -0.02404867687122821],
    [0.3170189131994394, 0.9481640228972545, 0.021999871752824696],
    [0.856999404660933, 0.10810525416770786, 0.5038504484786551],
    [0.09063746926257722, 0.3732996393223999, -0.923272564548217],
    [0.14521416058092582, -0.45327590663317513, -0.8794622220611016],
    [0.5133852064010931, -0.8578212597573224, 0.024048204857483078],
    [-0.3170189131994393, -0.9481640228972545, -0.021999871752824696],
    [-0.8569994046609327, -0.10810525416770782, -0.5038504484786552],
    [-0.09063746926257725, -0.3732996393224, 0.923272564548217],
    [-0.14521416058092568, 0.4532759066331752, 0.8794622220611015]
]
