"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MigrationJob = exports.MigrationJobProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const dts_generated_1 = require("./dts.generated");
Object.defineProperty(exports, "MigrationJobProperty", { enumerable: true, get: function () { return dts_generated_1.RosMigrationJob; } });
/**
 * A ROS resource type:  `ALIYUN::DTS::MigrationJob`
 */
class MigrationJob extends ros.Resource {
    /**
     * Create a new `ALIYUN::DTS::MigrationJob`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosMigrationJob = new dts_generated_1.RosMigrationJob(this, id, {
            migrationObject: props.migrationObject,
            destinationEndpoint: props.destinationEndpoint,
            migrationJobClass: props.migrationJobClass,
            sourceEndpoint: props.sourceEndpoint,
            migrationJobName: props.migrationJobName,
            migrationMode: props.migrationMode,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosMigrationJob;
        this.attrMigrationJobId = rosMigrationJob.attrMigrationJobId;
    }
}
exports.MigrationJob = MigrationJob;
//# sourceMappingURL=data:application/json;base64,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