# -*- coding: utf-8 -*-
# This file is auto-generated, don't edit it. Thanks.
from Tea.model import TeaModel


class DescribeDeploymentSetSupportedInstanceTypeFamilyRequest(TeaModel):
    def __init__(self, region_id=None):
        self.region_id = region_id

    def validate(self):
        self.validate_required(self.region_id, 'region_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        return self


class DescribeDeploymentSetSupportedInstanceTypeFamilyResponse(TeaModel):
    def __init__(self, request_id=None, instance_type_families=None):
        self.request_id = request_id
        self.instance_type_families = instance_type_families

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.instance_type_families, 'instance_type_families')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['InstanceTypeFamilies'] = self.instance_type_families
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.instance_type_families = map.get('InstanceTypeFamilies')
        return self


class DescribeNetworkInterfaceAttributeRequest(TeaModel):
    def __init__(self, region_id=None, tag=None, network_interface_id=None, attribute=None):
        self.region_id = region_id
        self.tag = tag
        self.network_interface_id = network_interface_id
        self.attribute = attribute

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()
        self.validate_required(self.network_interface_id, 'network_interface_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        else:
            result['Tag'] = None
        result['NetworkInterfaceId'] = self.network_interface_id
        result['Attribute'] = self.attribute
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.tag = []
        if map.get('Tag') is not None:
            for k in map.get('Tag'):
                temp_model = DescribeNetworkInterfaceAttributeRequestTag()
                temp_model = temp_model.from_map(k)
                self.tag.append(temp_model)
        else:
            self.tag = None
        self.network_interface_id = map.get('NetworkInterfaceId')
        self.attribute = map.get('Attribute')
        return self


class DescribeNetworkInterfaceAttributeRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key
        self.value = value

    def validate(self):
        self.validate_required(self.key, 'key')
        self.validate_required(self.value, 'value')

    def to_map(self):
        result = {}
        result['Key'] = self.key
        result['Value'] = self.value
        return result

    def from_map(self, map={}):
        self.key = map.get('Key')
        self.value = map.get('Value')
        return self
class DescribeNetworkInterfaceAttributeResponse(TeaModel):
    def __init__(self, request_id=None, network_interface_id=None, status=None, type=None, vpc_id=None,
                 v_switch_id=None, zone_id=None, private_ip_address=None, mac_address=None, network_interface_name=None,
                 description=None, instance_id=None, creation_time=None, resource_group_id=None, service_id=None,
                 service_managed=None, queue_number=None, owner_id=None, private_ip_sets=None, ipv_6sets=None, tags=None,
                 associated_public_ip=None, attachment=None, security_group_ids=None):
        self.request_id = request_id
        self.network_interface_id = network_interface_id
        self.status = status
        self.type = type
        self.vpc_id = vpc_id
        self.v_switch_id = v_switch_id
        self.zone_id = zone_id
        self.private_ip_address = private_ip_address
        self.mac_address = mac_address
        self.network_interface_name = network_interface_name
        self.description = description
        self.instance_id = instance_id
        self.creation_time = creation_time
        self.resource_group_id = resource_group_id
        self.service_id = service_id
        self.service_managed = service_managed
        self.queue_number = queue_number
        self.owner_id = owner_id
        self.private_ip_sets = private_ip_sets
        self.ipv_6sets = ipv_6sets
        self.tags = tags
        self.associated_public_ip = associated_public_ip
        self.attachment = attachment
        self.security_group_ids = security_group_ids

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.network_interface_id, 'network_interface_id')
        self.validate_required(self.status, 'status')
        self.validate_required(self.type, 'type')
        self.validate_required(self.vpc_id, 'vpc_id')
        self.validate_required(self.v_switch_id, 'v_switch_id')
        self.validate_required(self.zone_id, 'zone_id')
        self.validate_required(self.private_ip_address, 'private_ip_address')
        self.validate_required(self.mac_address, 'mac_address')
        self.validate_required(self.network_interface_name, 'network_interface_name')
        self.validate_required(self.description, 'description')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.creation_time, 'creation_time')
        self.validate_required(self.resource_group_id, 'resource_group_id')
        self.validate_required(self.service_id, 'service_id')
        self.validate_required(self.service_managed, 'service_managed')
        self.validate_required(self.queue_number, 'queue_number')
        self.validate_required(self.owner_id, 'owner_id')
        self.validate_required(self.private_ip_sets, 'private_ip_sets')
        if self.private_ip_sets:
            self.private_ip_sets.validate()
        self.validate_required(self.ipv_6sets, 'ipv_6sets')
        if self.ipv_6sets:
            self.ipv_6sets.validate()
        self.validate_required(self.tags, 'tags')
        if self.tags:
            self.tags.validate()
        self.validate_required(self.associated_public_ip, 'associated_public_ip')
        if self.associated_public_ip:
            self.associated_public_ip.validate()
        self.validate_required(self.attachment, 'attachment')
        if self.attachment:
            self.attachment.validate()
        self.validate_required(self.security_group_ids, 'security_group_ids')
        if self.security_group_ids:
            self.security_group_ids.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['NetworkInterfaceId'] = self.network_interface_id
        result['Status'] = self.status
        result['Type'] = self.type
        result['VpcId'] = self.vpc_id
        result['VSwitchId'] = self.v_switch_id
        result['ZoneId'] = self.zone_id
        result['PrivateIpAddress'] = self.private_ip_address
        result['MacAddress'] = self.mac_address
        result['NetworkInterfaceName'] = self.network_interface_name
        result['Description'] = self.description
        result['InstanceId'] = self.instance_id
        result['CreationTime'] = self.creation_time
        result['ResourceGroupId'] = self.resource_group_id
        result['ServiceID'] = self.service_id
        result['ServiceManaged'] = self.service_managed
        result['QueueNumber'] = self.queue_number
        result['OwnerId'] = self.owner_id
        if self.private_ip_sets is not None:
            result['PrivateIpSets'] = self.private_ip_sets.to_map()
        else:
            result['PrivateIpSets'] = None
        if self.ipv_6sets is not None:
            result['Ipv6Sets'] = self.ipv_6sets.to_map()
        else:
            result['Ipv6Sets'] = None
        if self.tags is not None:
            result['Tags'] = self.tags.to_map()
        else:
            result['Tags'] = None
        if self.associated_public_ip is not None:
            result['AssociatedPublicIp'] = self.associated_public_ip.to_map()
        else:
            result['AssociatedPublicIp'] = None
        if self.attachment is not None:
            result['Attachment'] = self.attachment.to_map()
        else:
            result['Attachment'] = None
        if self.security_group_ids is not None:
            result['SecurityGroupIds'] = self.security_group_ids.to_map()
        else:
            result['SecurityGroupIds'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.network_interface_id = map.get('NetworkInterfaceId')
        self.status = map.get('Status')
        self.type = map.get('Type')
        self.vpc_id = map.get('VpcId')
        self.v_switch_id = map.get('VSwitchId')
        self.zone_id = map.get('ZoneId')
        self.private_ip_address = map.get('PrivateIpAddress')
        self.mac_address = map.get('MacAddress')
        self.network_interface_name = map.get('NetworkInterfaceName')
        self.description = map.get('Description')
        self.instance_id = map.get('InstanceId')
        self.creation_time = map.get('CreationTime')
        self.resource_group_id = map.get('ResourceGroupId')
        self.service_id = map.get('ServiceID')
        self.service_managed = map.get('ServiceManaged')
        self.queue_number = map.get('QueueNumber')
        self.owner_id = map.get('OwnerId')
        if map.get('PrivateIpSets') is not None:
            temp_model = DescribeNetworkInterfaceAttributeResponsePrivateIpSets()
            self.private_ip_sets = temp_model.from_map(map['PrivateIpSets'])
        else:
            self.private_ip_sets = None
        if map.get('Ipv6Sets') is not None:
            temp_model = DescribeNetworkInterfaceAttributeResponseIpv6Sets()
            self.ipv_6sets = temp_model.from_map(map['Ipv6Sets'])
        else:
            self.ipv_6sets = None
        if map.get('Tags') is not None:
            temp_model = DescribeNetworkInterfaceAttributeResponseTags()
            self.tags = temp_model.from_map(map['Tags'])
        else:
            self.tags = None
        if map.get('AssociatedPublicIp') is not None:
            temp_model = DescribeNetworkInterfaceAttributeResponseAssociatedPublicIp()
            self.associated_public_ip = temp_model.from_map(map['AssociatedPublicIp'])
        else:
            self.associated_public_ip = None
        if map.get('Attachment') is not None:
            temp_model = DescribeNetworkInterfaceAttributeResponseAttachment()
            self.attachment = temp_model.from_map(map['Attachment'])
        else:
            self.attachment = None
        if map.get('SecurityGroupIds') is not None:
            temp_model = DescribeNetworkInterfaceAttributeResponseSecurityGroupIds()
            self.security_group_ids = temp_model.from_map(map['SecurityGroupIds'])
        else:
            self.security_group_ids = None
        return self


class DescribeNetworkInterfaceAttributeResponsePrivateIpSetsPrivateIpSetAssociatedPublicIp(TeaModel):
    def __init__(self, public_ip_address=None, allocation_id=None):
        self.public_ip_address = public_ip_address
        self.allocation_id = allocation_id

    def validate(self):
        self.validate_required(self.public_ip_address, 'public_ip_address')
        self.validate_required(self.allocation_id, 'allocation_id')

    def to_map(self):
        result = {}
        result['PublicIpAddress'] = self.public_ip_address
        result['AllocationId'] = self.allocation_id
        return result

    def from_map(self, map={}):
        self.public_ip_address = map.get('PublicIpAddress')
        self.allocation_id = map.get('AllocationId')
        return self


class DescribeNetworkInterfaceAttributeResponsePrivateIpSetsPrivateIpSet(TeaModel):
    def __init__(self, private_ip_address=None, primary=None, associated_public_ip=None):
        self.private_ip_address = private_ip_address
        self.primary = primary
        self.associated_public_ip = associated_public_ip

    def validate(self):
        self.validate_required(self.private_ip_address, 'private_ip_address')
        self.validate_required(self.primary, 'primary')
        self.validate_required(self.associated_public_ip, 'associated_public_ip')
        if self.associated_public_ip:
            self.associated_public_ip.validate()

    def to_map(self):
        result = {}
        result['PrivateIpAddress'] = self.private_ip_address
        result['Primary'] = self.primary
        if self.associated_public_ip is not None:
            result['AssociatedPublicIp'] = self.associated_public_ip.to_map()
        else:
            result['AssociatedPublicIp'] = None
        return result

    def from_map(self, map={}):
        self.private_ip_address = map.get('PrivateIpAddress')
        self.primary = map.get('Primary')
        if map.get('AssociatedPublicIp') is not None:
            temp_model = DescribeNetworkInterfaceAttributeResponsePrivateIpSetsPrivateIpSetAssociatedPublicIp()
            self.associated_public_ip = temp_model.from_map(map['AssociatedPublicIp'])
        else:
            self.associated_public_ip = None
        return self


class DescribeNetworkInterfaceAttributeResponsePrivateIpSets(TeaModel):
    def __init__(self, private_ip_set=None):
        self.private_ip_set = private_ip_set

    def validate(self):
        self.validate_required(self.private_ip_set, 'private_ip_set')
        if self.private_ip_set:
            for k in self.private_ip_set:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['PrivateIpSet'] = []
        if self.private_ip_set is not None:
            for k in self.private_ip_set:
                result['PrivateIpSet'].append(k.to_map() if k else None)
        else:
            result['PrivateIpSet'] = None
        return result

    def from_map(self, map={}):
        self.private_ip_set = []
        if map.get('PrivateIpSet') is not None:
            for k in map.get('PrivateIpSet'):
                temp_model = DescribeNetworkInterfaceAttributeResponsePrivateIpSetsPrivateIpSet()
                temp_model = temp_model.from_map(k)
                self.private_ip_set.append(temp_model)
        else:
            self.private_ip_set = None
        return self


class DescribeNetworkInterfaceAttributeResponseIpv6SetsIpv6Set(TeaModel):
    def __init__(self, ipv_6address=None):
        self.ipv_6address = ipv_6address

    def validate(self):
        self.validate_required(self.ipv_6address, 'ipv_6address')

    def to_map(self):
        result = {}
        result['Ipv6Address'] = self.ipv_6address
        return result

    def from_map(self, map={}):
        self.ipv_6address = map.get('Ipv6Address')
        return self


class DescribeNetworkInterfaceAttributeResponseIpv6Sets(TeaModel):
    def __init__(self, ipv_6set=None):
        self.ipv_6set = ipv_6set

    def validate(self):
        self.validate_required(self.ipv_6set, 'ipv_6set')
        if self.ipv_6set:
            for k in self.ipv_6set:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['Ipv6Set'] = []
        if self.ipv_6set is not None:
            for k in self.ipv_6set:
                result['Ipv6Set'].append(k.to_map() if k else None)
        else:
            result['Ipv6Set'] = None
        return result

    def from_map(self, map={}):
        self.ipv_6set = []
        if map.get('Ipv6Set') is not None:
            for k in map.get('Ipv6Set'):
                temp_model = DescribeNetworkInterfaceAttributeResponseIpv6SetsIpv6Set()
                temp_model = temp_model.from_map(k)
                self.ipv_6set.append(temp_model)
        else:
            self.ipv_6set = None
        return self


class DescribeNetworkInterfaceAttributeResponseTagsTag(TeaModel):
    def __init__(self, tag_key=None, tag_value=None):
        self.tag_key = tag_key
        self.tag_value = tag_value

    def validate(self):
        self.validate_required(self.tag_key, 'tag_key')
        self.validate_required(self.tag_value, 'tag_value')

    def to_map(self):
        result = {}
        result['TagKey'] = self.tag_key
        result['TagValue'] = self.tag_value
        return result

    def from_map(self, map={}):
        self.tag_key = map.get('TagKey')
        self.tag_value = map.get('TagValue')
        return self


class DescribeNetworkInterfaceAttributeResponseTags(TeaModel):
    def __init__(self, tag=None):
        self.tag = tag

    def validate(self):
        self.validate_required(self.tag, 'tag')
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        else:
            result['Tag'] = None
        return result

    def from_map(self, map={}):
        self.tag = []
        if map.get('Tag') is not None:
            for k in map.get('Tag'):
                temp_model = DescribeNetworkInterfaceAttributeResponseTagsTag()
                temp_model = temp_model.from_map(k)
                self.tag.append(temp_model)
        else:
            self.tag = None
        return self


class DescribeNetworkInterfaceAttributeResponseAssociatedPublicIp(TeaModel):
    def __init__(self, public_ip_address=None, allocation_id=None):
        self.public_ip_address = public_ip_address
        self.allocation_id = allocation_id

    def validate(self):
        self.validate_required(self.public_ip_address, 'public_ip_address')
        self.validate_required(self.allocation_id, 'allocation_id')

    def to_map(self):
        result = {}
        result['PublicIpAddress'] = self.public_ip_address
        result['AllocationId'] = self.allocation_id
        return result

    def from_map(self, map={}):
        self.public_ip_address = map.get('PublicIpAddress')
        self.allocation_id = map.get('AllocationId')
        return self


class DescribeNetworkInterfaceAttributeResponseAttachmentMemberNetworkInterfaceIds(TeaModel):
    def __init__(self, member_network_interface_id=None):
        # MemberNetworkInterfaceId
        self.member_network_interface_id = member_network_interface_id

    def validate(self):
        self.validate_required(self.member_network_interface_id, 'member_network_interface_id')

    def to_map(self):
        result = {}
        result['MemberNetworkInterfaceId'] = []
        if self.member_network_interface_id is not None:
            for k in self.member_network_interface_id:
                result['MemberNetworkInterfaceId'].append(k)
        else:
            result['MemberNetworkInterfaceId'] = None
        return result

    def from_map(self, map={}):
        self.member_network_interface_id = []
        if map.get('MemberNetworkInterfaceId') is not None:
            for k in map.get('MemberNetworkInterfaceId'):
                self.member_network_interface_id.append(k)
        else:
            self.member_network_interface_id = None
        return self


class DescribeNetworkInterfaceAttributeResponseAttachment(TeaModel):
    def __init__(self, instance_id=None, trunk_network_interface_id=None, device_index=None,
                 member_network_interface_ids=None):
        self.instance_id = instance_id
        self.trunk_network_interface_id = trunk_network_interface_id
        self.device_index = device_index
        self.member_network_interface_ids = member_network_interface_ids

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.trunk_network_interface_id, 'trunk_network_interface_id')
        self.validate_required(self.device_index, 'device_index')
        self.validate_required(self.member_network_interface_ids, 'member_network_interface_ids')
        if self.member_network_interface_ids:
            self.member_network_interface_ids.validate()

    def to_map(self):
        result = {}
        result['InstanceId'] = self.instance_id
        result['TrunkNetworkInterfaceId'] = self.trunk_network_interface_id
        result['DeviceIndex'] = self.device_index
        if self.member_network_interface_ids is not None:
            result['MemberNetworkInterfaceIds'] = self.member_network_interface_ids.to_map()
        else:
            result['MemberNetworkInterfaceIds'] = None
        return result

    def from_map(self, map={}):
        self.instance_id = map.get('InstanceId')
        self.trunk_network_interface_id = map.get('TrunkNetworkInterfaceId')
        self.device_index = map.get('DeviceIndex')
        if map.get('MemberNetworkInterfaceIds') is not None:
            temp_model = DescribeNetworkInterfaceAttributeResponseAttachmentMemberNetworkInterfaceIds()
            self.member_network_interface_ids = temp_model.from_map(map['MemberNetworkInterfaceIds'])
        else:
            self.member_network_interface_ids = None
        return self


class DescribeNetworkInterfaceAttributeResponseSecurityGroupIds(TeaModel):
    def __init__(self, security_group_id=None):
        self.security_group_id = security_group_id

    def validate(self):
        self.validate_required(self.security_group_id, 'security_group_id')

    def to_map(self):
        result = {}
        result['SecurityGroupId'] = []
        if self.security_group_id is not None:
            for k in self.security_group_id:
                result['SecurityGroupId'].append(k)
        else:
            result['SecurityGroupId'] = None
        return result

    def from_map(self, map={}):
        self.security_group_id = []
        if map.get('SecurityGroupId') is not None:
            for k in map.get('SecurityGroupId'):
                self.security_group_id.append(k)
        else:
            self.security_group_id = None
        return self
class CopySnapshotRequest(TeaModel):
    def __init__(self, tag=None, resource_group_id=None, region_id=None, destination_region_id=None,
                 snapshot_id=None, destination_snapshot_name=None, destination_snapshot_description=None, retention_days=None):
        self.tag = tag
        self.resource_group_id = resource_group_id
        self.region_id = region_id
        self.destination_region_id = destination_region_id
        self.snapshot_id = snapshot_id
        self.destination_snapshot_name = destination_snapshot_name
        self.destination_snapshot_description = destination_snapshot_description
        self.retention_days = retention_days

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.destination_region_id, 'destination_region_id')
        self.validate_required(self.snapshot_id, 'snapshot_id')
        self.validate_required(self.destination_snapshot_name, 'destination_snapshot_name')
        self.validate_required(self.destination_snapshot_description, 'destination_snapshot_description')

    def to_map(self):
        result = {}
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        else:
            result['Tag'] = None
        result['ResourceGroupId'] = self.resource_group_id
        result['RegionId'] = self.region_id
        result['DestinationRegionId'] = self.destination_region_id
        result['SnapshotId'] = self.snapshot_id
        result['DestinationSnapshotName'] = self.destination_snapshot_name
        result['DestinationSnapshotDescription'] = self.destination_snapshot_description
        result['RetentionDays'] = self.retention_days
        return result

    def from_map(self, map={}):
        self.tag = []
        if map.get('Tag') is not None:
            for k in map.get('Tag'):
                temp_model = CopySnapshotRequestTag()
                temp_model = temp_model.from_map(k)
                self.tag.append(temp_model)
        else:
            self.tag = None
        self.resource_group_id = map.get('ResourceGroupId')
        self.region_id = map.get('RegionId')
        self.destination_region_id = map.get('DestinationRegionId')
        self.snapshot_id = map.get('SnapshotId')
        self.destination_snapshot_name = map.get('DestinationSnapshotName')
        self.destination_snapshot_description = map.get('DestinationSnapshotDescription')
        self.retention_days = map.get('RetentionDays')
        return self


class CopySnapshotRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key
        self.value = value

    def validate(self):
        self.validate_required(self.key, 'key')
        self.validate_required(self.value, 'value')

    def to_map(self):
        result = {}
        result['Key'] = self.key
        result['Value'] = self.value
        return result

    def from_map(self, map={}):
        self.key = map.get('Key')
        self.value = map.get('Value')
        return self
class CopySnapshotResponse(TeaModel):
    def __init__(self, request_id=None, snapshot_id=None):
        self.request_id = request_id
        self.snapshot_id = snapshot_id

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.snapshot_id, 'snapshot_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['SnapshotId'] = self.snapshot_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.snapshot_id = map.get('SnapshotId')
        return self


class ModifyDedicatedHostsChargeTypeRequest(TeaModel):
    def __init__(self, dedicated_host_ids=None, region_id=None, period=None, period_unit=None, dry_run=None,
                 auto_pay=None, dedicated_host_charge_type=None, client_token=None, detail_fee=None):
        self.dedicated_host_ids = dedicated_host_ids
        self.region_id = region_id
        self.period = period
        self.period_unit = period_unit
        self.dry_run = dry_run
        self.auto_pay = auto_pay
        self.dedicated_host_charge_type = dedicated_host_charge_type
        self.client_token = client_token
        self.detail_fee = detail_fee

    def validate(self):
        self.validate_required(self.dedicated_host_ids, 'dedicated_host_ids')
        self.validate_required(self.region_id, 'region_id')

    def to_map(self):
        result = {}
        result['DedicatedHostIds'] = self.dedicated_host_ids
        result['RegionId'] = self.region_id
        result['Period'] = self.period
        result['PeriodUnit'] = self.period_unit
        result['DryRun'] = self.dry_run
        result['AutoPay'] = self.auto_pay
        result['DedicatedHostChargeType'] = self.dedicated_host_charge_type
        result['ClientToken'] = self.client_token
        result['DetailFee'] = self.detail_fee
        return result

    def from_map(self, map={}):
        self.dedicated_host_ids = map.get('DedicatedHostIds')
        self.region_id = map.get('RegionId')
        self.period = map.get('Period')
        self.period_unit = map.get('PeriodUnit')
        self.dry_run = map.get('DryRun')
        self.auto_pay = map.get('AutoPay')
        self.dedicated_host_charge_type = map.get('DedicatedHostChargeType')
        self.client_token = map.get('ClientToken')
        self.detail_fee = map.get('DetailFee')
        return self


class ModifyDedicatedHostsChargeTypeResponse(TeaModel):
    def __init__(self, request_id=None, order_id=None, fee_of_instances=None):
        self.request_id = request_id
        self.order_id = order_id
        self.fee_of_instances = fee_of_instances

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.order_id, 'order_id')
        self.validate_required(self.fee_of_instances, 'fee_of_instances')
        if self.fee_of_instances:
            self.fee_of_instances.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['OrderId'] = self.order_id
        if self.fee_of_instances is not None:
            result['FeeOfInstances'] = self.fee_of_instances.to_map()
        else:
            result['FeeOfInstances'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.order_id = map.get('OrderId')
        if map.get('FeeOfInstances') is not None:
            temp_model = ModifyDedicatedHostsChargeTypeResponseFeeOfInstances()
            self.fee_of_instances = temp_model.from_map(map['FeeOfInstances'])
        else:
            self.fee_of_instances = None
        return self


class ModifyDedicatedHostsChargeTypeResponseFeeOfInstancesFeeOfInstance(TeaModel):
    def __init__(self, instance_id=None, fee=None, currency=None):
        self.instance_id = instance_id
        self.fee = fee
        self.currency = currency

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.fee, 'fee')
        self.validate_required(self.currency, 'currency')

    def to_map(self):
        result = {}
        result['InstanceId'] = self.instance_id
        result['Fee'] = self.fee
        result['Currency'] = self.currency
        return result

    def from_map(self, map={}):
        self.instance_id = map.get('InstanceId')
        self.fee = map.get('Fee')
        self.currency = map.get('Currency')
        return self


class ModifyDedicatedHostsChargeTypeResponseFeeOfInstances(TeaModel):
    def __init__(self, fee_of_instance=None):
        self.fee_of_instance = fee_of_instance

    def validate(self):
        self.validate_required(self.fee_of_instance, 'fee_of_instance')
        if self.fee_of_instance:
            for k in self.fee_of_instance:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['FeeOfInstance'] = []
        if self.fee_of_instance is not None:
            for k in self.fee_of_instance:
                result['FeeOfInstance'].append(k.to_map() if k else None)
        else:
            result['FeeOfInstance'] = None
        return result

    def from_map(self, map={}):
        self.fee_of_instance = []
        if map.get('FeeOfInstance') is not None:
            for k in map.get('FeeOfInstance'):
                temp_model = ModifyDedicatedHostsChargeTypeResponseFeeOfInstancesFeeOfInstance()
                temp_model = temp_model.from_map(k)
                self.fee_of_instance.append(temp_model)
        else:
            self.fee_of_instance = None
        return self
class ModifyInstanceMetadataOptionsRequest(TeaModel):
    def __init__(self, region_id=None, instance_id=None, http_endpoint=None, http_tokens=None,
                 http_put_response_hop_limit=None):
        self.region_id = region_id
        self.instance_id = instance_id
        self.http_endpoint = http_endpoint
        self.http_tokens = http_tokens
        self.http_put_response_hop_limit = http_put_response_hop_limit

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.http_endpoint, 'http_endpoint')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['InstanceId'] = self.instance_id
        result['HttpEndpoint'] = self.http_endpoint
        result['HttpTokens'] = self.http_tokens
        result['HttpPutResponseHopLimit'] = self.http_put_response_hop_limit
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.instance_id = map.get('InstanceId')
        self.http_endpoint = map.get('HttpEndpoint')
        self.http_tokens = map.get('HttpTokens')
        self.http_put_response_hop_limit = map.get('HttpPutResponseHopLimit')
        return self


class ModifyInstanceMetadataOptionsResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class DescribeImageFromFamilyRequest(TeaModel):
    def __init__(self, region_id=None, image_family=None):
        self.region_id = region_id
        self.image_family = image_family

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.image_family, 'image_family')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['ImageFamily'] = self.image_family
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.image_family = map.get('ImageFamily')
        return self


class DescribeImageFromFamilyResponse(TeaModel):
    def __init__(self, request_id=None, image=None):
        self.request_id = request_id
        self.image = image

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.image, 'image')
        if self.image:
            self.image.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        if self.image is not None:
            result['Image'] = self.image.to_map()
        else:
            result['Image'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        if map.get('Image') is not None:
            temp_model = DescribeImageFromFamilyResponseImage()
            self.image = temp_model.from_map(map['Image'])
        else:
            self.image = None
        return self


class DescribeImageFromFamilyResponseImageDiskDeviceMappingsDiskDeviceMapping(TeaModel):
    def __init__(self, snapshot_id=None, size=None, device=None, type=None, format=None, import_ossbucket=None,
                 import_ossobject=None):
        self.snapshot_id = snapshot_id
        self.size = size
        self.device = device
        self.type = type
        self.format = format
        self.import_ossbucket = import_ossbucket
        self.import_ossobject = import_ossobject

    def validate(self):
        self.validate_required(self.snapshot_id, 'snapshot_id')
        self.validate_required(self.size, 'size')
        self.validate_required(self.device, 'device')
        self.validate_required(self.type, 'type')
        self.validate_required(self.format, 'format')
        self.validate_required(self.import_ossbucket, 'import_ossbucket')
        self.validate_required(self.import_ossobject, 'import_ossobject')

    def to_map(self):
        result = {}
        result['SnapshotId'] = self.snapshot_id
        result['Size'] = self.size
        result['Device'] = self.device
        result['Type'] = self.type
        result['Format'] = self.format
        result['ImportOSSBucket'] = self.import_ossbucket
        result['ImportOSSObject'] = self.import_ossobject
        return result

    def from_map(self, map={}):
        self.snapshot_id = map.get('SnapshotId')
        self.size = map.get('Size')
        self.device = map.get('Device')
        self.type = map.get('Type')
        self.format = map.get('Format')
        self.import_ossbucket = map.get('ImportOSSBucket')
        self.import_ossobject = map.get('ImportOSSObject')
        return self


class DescribeImageFromFamilyResponseImageDiskDeviceMappings(TeaModel):
    def __init__(self, disk_device_mapping=None):
        self.disk_device_mapping = disk_device_mapping

    def validate(self):
        self.validate_required(self.disk_device_mapping, 'disk_device_mapping')
        if self.disk_device_mapping:
            for k in self.disk_device_mapping:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['DiskDeviceMapping'] = []
        if self.disk_device_mapping is not None:
            for k in self.disk_device_mapping:
                result['DiskDeviceMapping'].append(k.to_map() if k else None)
        else:
            result['DiskDeviceMapping'] = None
        return result

    def from_map(self, map={}):
        self.disk_device_mapping = []
        if map.get('DiskDeviceMapping') is not None:
            for k in map.get('DiskDeviceMapping'):
                temp_model = DescribeImageFromFamilyResponseImageDiskDeviceMappingsDiskDeviceMapping()
                temp_model = temp_model.from_map(k)
                self.disk_device_mapping.append(temp_model)
        else:
            self.disk_device_mapping = None
        return self


class DescribeImageFromFamilyResponseImageTagsTag(TeaModel):
    def __init__(self, tag_key=None, tag_value=None):
        self.tag_key = tag_key
        self.tag_value = tag_value

    def validate(self):
        self.validate_required(self.tag_key, 'tag_key')
        self.validate_required(self.tag_value, 'tag_value')

    def to_map(self):
        result = {}
        result['TagKey'] = self.tag_key
        result['TagValue'] = self.tag_value
        return result

    def from_map(self, map={}):
        self.tag_key = map.get('TagKey')
        self.tag_value = map.get('TagValue')
        return self


class DescribeImageFromFamilyResponseImageTags(TeaModel):
    def __init__(self, tag=None):
        self.tag = tag

    def validate(self):
        self.validate_required(self.tag, 'tag')
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        else:
            result['Tag'] = None
        return result

    def from_map(self, map={}):
        self.tag = []
        if map.get('Tag') is not None:
            for k in map.get('Tag'):
                temp_model = DescribeImageFromFamilyResponseImageTagsTag()
                temp_model = temp_model.from_map(k)
                self.tag.append(temp_model)
        else:
            self.tag = None
        return self


class DescribeImageFromFamilyResponseImage(TeaModel):
    def __init__(self, progress=None, image_id=None, image_name=None, image_family=None, image_version=None,
                 description=None, size=None, image_owner_alias=None, is_support_io_optimized=None, is_support_cloudinit=None,
                 osname=None, architecture=None, status=None, product_code=None, is_subscribed=None, creation_time=None,
                 is_self_shared=None, ostype=None, platform=None, usage=None, is_copied=None, disk_device_mappings=None, tags=None):
        self.progress = progress
        self.image_id = image_id
        self.image_name = image_name
        self.image_family = image_family
        self.image_version = image_version
        self.description = description
        self.size = size
        self.image_owner_alias = image_owner_alias
        self.is_support_io_optimized = is_support_io_optimized
        self.is_support_cloudinit = is_support_cloudinit
        self.osname = osname
        self.architecture = architecture
        self.status = status
        self.product_code = product_code
        self.is_subscribed = is_subscribed
        self.creation_time = creation_time
        self.is_self_shared = is_self_shared
        self.ostype = ostype
        self.platform = platform
        self.usage = usage
        self.is_copied = is_copied
        self.disk_device_mappings = disk_device_mappings
        self.tags = tags

    def validate(self):
        self.validate_required(self.progress, 'progress')
        self.validate_required(self.image_id, 'image_id')
        self.validate_required(self.image_name, 'image_name')
        self.validate_required(self.image_family, 'image_family')
        self.validate_required(self.image_version, 'image_version')
        self.validate_required(self.description, 'description')
        self.validate_required(self.size, 'size')
        self.validate_required(self.image_owner_alias, 'image_owner_alias')
        self.validate_required(self.is_support_io_optimized, 'is_support_io_optimized')
        self.validate_required(self.is_support_cloudinit, 'is_support_cloudinit')
        self.validate_required(self.osname, 'osname')
        self.validate_required(self.architecture, 'architecture')
        self.validate_required(self.status, 'status')
        self.validate_required(self.product_code, 'product_code')
        self.validate_required(self.is_subscribed, 'is_subscribed')
        self.validate_required(self.creation_time, 'creation_time')
        self.validate_required(self.is_self_shared, 'is_self_shared')
        self.validate_required(self.ostype, 'ostype')
        self.validate_required(self.platform, 'platform')
        self.validate_required(self.usage, 'usage')
        self.validate_required(self.is_copied, 'is_copied')
        self.validate_required(self.disk_device_mappings, 'disk_device_mappings')
        if self.disk_device_mappings:
            self.disk_device_mappings.validate()
        self.validate_required(self.tags, 'tags')
        if self.tags:
            self.tags.validate()

    def to_map(self):
        result = {}
        result['Progress'] = self.progress
        result['ImageId'] = self.image_id
        result['ImageName'] = self.image_name
        result['ImageFamily'] = self.image_family
        result['ImageVersion'] = self.image_version
        result['Description'] = self.description
        result['Size'] = self.size
        result['ImageOwnerAlias'] = self.image_owner_alias
        result['IsSupportIoOptimized'] = self.is_support_io_optimized
        result['IsSupportCloudinit'] = self.is_support_cloudinit
        result['OSName'] = self.osname
        result['Architecture'] = self.architecture
        result['Status'] = self.status
        result['ProductCode'] = self.product_code
        result['IsSubscribed'] = self.is_subscribed
        result['CreationTime'] = self.creation_time
        result['IsSelfShared'] = self.is_self_shared
        result['OSType'] = self.ostype
        result['Platform'] = self.platform
        result['Usage'] = self.usage
        result['IsCopied'] = self.is_copied
        if self.disk_device_mappings is not None:
            result['DiskDeviceMappings'] = self.disk_device_mappings.to_map()
        else:
            result['DiskDeviceMappings'] = None
        if self.tags is not None:
            result['Tags'] = self.tags.to_map()
        else:
            result['Tags'] = None
        return result

    def from_map(self, map={}):
        self.progress = map.get('Progress')
        self.image_id = map.get('ImageId')
        self.image_name = map.get('ImageName')
        self.image_family = map.get('ImageFamily')
        self.image_version = map.get('ImageVersion')
        self.description = map.get('Description')
        self.size = map.get('Size')
        self.image_owner_alias = map.get('ImageOwnerAlias')
        self.is_support_io_optimized = map.get('IsSupportIoOptimized')
        self.is_support_cloudinit = map.get('IsSupportCloudinit')
        self.osname = map.get('OSName')
        self.architecture = map.get('Architecture')
        self.status = map.get('Status')
        self.product_code = map.get('ProductCode')
        self.is_subscribed = map.get('IsSubscribed')
        self.creation_time = map.get('CreationTime')
        self.is_self_shared = map.get('IsSelfShared')
        self.ostype = map.get('OSType')
        self.platform = map.get('Platform')
        self.usage = map.get('Usage')
        self.is_copied = map.get('IsCopied')
        if map.get('DiskDeviceMappings') is not None:
            temp_model = DescribeImageFromFamilyResponseImageDiskDeviceMappings()
            self.disk_device_mappings = temp_model.from_map(map['DiskDeviceMappings'])
        else:
            self.disk_device_mappings = None
        if map.get('Tags') is not None:
            temp_model = DescribeImageFromFamilyResponseImageTags()
            self.tags = temp_model.from_map(map['Tags'])
        else:
            self.tags = None
        return self
class StopInstancesRequest(TeaModel):
    def __init__(self, dry_run=None, instance_id=None, region_id=None, force_stop=None, stopped_mode=None,
                 batch_optimization=None):
        self.dry_run = dry_run
        self.instance_id = instance_id
        self.region_id = region_id
        self.force_stop = force_stop
        self.stopped_mode = stopped_mode
        self.batch_optimization = batch_optimization

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.region_id, 'region_id')

    def to_map(self):
        result = {}
        result['DryRun'] = self.dry_run
        result['InstanceId'] = []
        if self.instance_id is not None:
            for k in self.instance_id:
                result['InstanceId'].append(k)
        else:
            result['InstanceId'] = None
        result['RegionId'] = self.region_id
        result['ForceStop'] = self.force_stop
        result['StoppedMode'] = self.stopped_mode
        result['BatchOptimization'] = self.batch_optimization
        return result

    def from_map(self, map={}):
        self.dry_run = map.get('DryRun')
        self.instance_id = []
        if map.get('InstanceId') is not None:
            for k in map.get('InstanceId'):
                self.instance_id.append(k)
        else:
            self.instance_id = None
        self.region_id = map.get('RegionId')
        self.force_stop = map.get('ForceStop')
        self.stopped_mode = map.get('StoppedMode')
        self.batch_optimization = map.get('BatchOptimization')
        return self


class StopInstancesResponse(TeaModel):
    def __init__(self, request_id=None, instance_responses=None):
        self.request_id = request_id
        self.instance_responses = instance_responses

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.instance_responses, 'instance_responses')
        if self.instance_responses:
            self.instance_responses.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        if self.instance_responses is not None:
            result['InstanceResponses'] = self.instance_responses.to_map()
        else:
            result['InstanceResponses'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        if map.get('InstanceResponses') is not None:
            temp_model = StopInstancesResponseInstanceResponses()
            self.instance_responses = temp_model.from_map(map['InstanceResponses'])
        else:
            self.instance_responses = None
        return self


class StopInstancesResponseInstanceResponsesInstanceResponse(TeaModel):
    def __init__(self, instance_id=None, previous_status=None, current_status=None, code=None, message=None):
        self.instance_id = instance_id
        self.previous_status = previous_status
        self.current_status = current_status
        self.code = code
        self.message = message

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.previous_status, 'previous_status')
        self.validate_required(self.current_status, 'current_status')
        self.validate_required(self.code, 'code')
        self.validate_required(self.message, 'message')

    def to_map(self):
        result = {}
        result['InstanceId'] = self.instance_id
        result['PreviousStatus'] = self.previous_status
        result['CurrentStatus'] = self.current_status
        result['Code'] = self.code
        result['Message'] = self.message
        return result

    def from_map(self, map={}):
        self.instance_id = map.get('InstanceId')
        self.previous_status = map.get('PreviousStatus')
        self.current_status = map.get('CurrentStatus')
        self.code = map.get('Code')
        self.message = map.get('Message')
        return self


class StopInstancesResponseInstanceResponses(TeaModel):
    def __init__(self, instance_response=None):
        self.instance_response = instance_response

    def validate(self):
        self.validate_required(self.instance_response, 'instance_response')
        if self.instance_response:
            for k in self.instance_response:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['InstanceResponse'] = []
        if self.instance_response is not None:
            for k in self.instance_response:
                result['InstanceResponse'].append(k.to_map() if k else None)
        else:
            result['InstanceResponse'] = None
        return result

    def from_map(self, map={}):
        self.instance_response = []
        if map.get('InstanceResponse') is not None:
            for k in map.get('InstanceResponse'):
                temp_model = StopInstancesResponseInstanceResponsesInstanceResponse()
                temp_model = temp_model.from_map(k)
                self.instance_response.append(temp_model)
        else:
            self.instance_response = None
        return self
class StartInstancesRequest(TeaModel):
    def __init__(self, dry_run=None, instance_id=None, region_id=None, batch_optimization=None):
        self.dry_run = dry_run
        self.instance_id = instance_id
        self.region_id = region_id
        self.batch_optimization = batch_optimization

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.region_id, 'region_id')

    def to_map(self):
        result = {}
        result['DryRun'] = self.dry_run
        result['InstanceId'] = []
        if self.instance_id is not None:
            for k in self.instance_id:
                result['InstanceId'].append(k)
        else:
            result['InstanceId'] = None
        result['RegionId'] = self.region_id
        result['BatchOptimization'] = self.batch_optimization
        return result

    def from_map(self, map={}):
        self.dry_run = map.get('DryRun')
        self.instance_id = []
        if map.get('InstanceId') is not None:
            for k in map.get('InstanceId'):
                self.instance_id.append(k)
        else:
            self.instance_id = None
        self.region_id = map.get('RegionId')
        self.batch_optimization = map.get('BatchOptimization')
        return self


class StartInstancesResponse(TeaModel):
    def __init__(self, request_id=None, instance_responses=None):
        self.request_id = request_id
        self.instance_responses = instance_responses

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.instance_responses, 'instance_responses')
        if self.instance_responses:
            self.instance_responses.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        if self.instance_responses is not None:
            result['InstanceResponses'] = self.instance_responses.to_map()
        else:
            result['InstanceResponses'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        if map.get('InstanceResponses') is not None:
            temp_model = StartInstancesResponseInstanceResponses()
            self.instance_responses = temp_model.from_map(map['InstanceResponses'])
        else:
            self.instance_responses = None
        return self


class StartInstancesResponseInstanceResponsesInstanceResponse(TeaModel):
    def __init__(self, instance_id=None, previous_status=None, current_status=None, code=None, message=None):
        self.instance_id = instance_id
        self.previous_status = previous_status
        self.current_status = current_status
        self.code = code
        self.message = message

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.previous_status, 'previous_status')
        self.validate_required(self.current_status, 'current_status')
        self.validate_required(self.code, 'code')
        self.validate_required(self.message, 'message')

    def to_map(self):
        result = {}
        result['InstanceId'] = self.instance_id
        result['PreviousStatus'] = self.previous_status
        result['CurrentStatus'] = self.current_status
        result['Code'] = self.code
        result['Message'] = self.message
        return result

    def from_map(self, map={}):
        self.instance_id = map.get('InstanceId')
        self.previous_status = map.get('PreviousStatus')
        self.current_status = map.get('CurrentStatus')
        self.code = map.get('Code')
        self.message = map.get('Message')
        return self


class StartInstancesResponseInstanceResponses(TeaModel):
    def __init__(self, instance_response=None):
        self.instance_response = instance_response

    def validate(self):
        self.validate_required(self.instance_response, 'instance_response')
        if self.instance_response:
            for k in self.instance_response:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['InstanceResponse'] = []
        if self.instance_response is not None:
            for k in self.instance_response:
                result['InstanceResponse'].append(k.to_map() if k else None)
        else:
            result['InstanceResponse'] = None
        return result

    def from_map(self, map={}):
        self.instance_response = []
        if map.get('InstanceResponse') is not None:
            for k in map.get('InstanceResponse'):
                temp_model = StartInstancesResponseInstanceResponsesInstanceResponse()
                temp_model = temp_model.from_map(k)
                self.instance_response.append(temp_model)
        else:
            self.instance_response = None
        return self
class RebootInstancesRequest(TeaModel):
    def __init__(self, dry_run=None, instance_id=None, region_id=None, force_reboot=None, batch_optimization=None):
        self.dry_run = dry_run
        self.instance_id = instance_id
        self.region_id = region_id
        self.force_reboot = force_reboot
        self.batch_optimization = batch_optimization

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.region_id, 'region_id')

    def to_map(self):
        result = {}
        result['DryRun'] = self.dry_run
        result['InstanceId'] = []
        if self.instance_id is not None:
            for k in self.instance_id:
                result['InstanceId'].append(k)
        else:
            result['InstanceId'] = None
        result['RegionId'] = self.region_id
        result['ForceReboot'] = self.force_reboot
        result['BatchOptimization'] = self.batch_optimization
        return result

    def from_map(self, map={}):
        self.dry_run = map.get('DryRun')
        self.instance_id = []
        if map.get('InstanceId') is not None:
            for k in map.get('InstanceId'):
                self.instance_id.append(k)
        else:
            self.instance_id = None
        self.region_id = map.get('RegionId')
        self.force_reboot = map.get('ForceReboot')
        self.batch_optimization = map.get('BatchOptimization')
        return self


class RebootInstancesResponse(TeaModel):
    def __init__(self, request_id=None, instance_responses=None):
        self.request_id = request_id
        self.instance_responses = instance_responses

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.instance_responses, 'instance_responses')
        if self.instance_responses:
            self.instance_responses.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        if self.instance_responses is not None:
            result['InstanceResponses'] = self.instance_responses.to_map()
        else:
            result['InstanceResponses'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        if map.get('InstanceResponses') is not None:
            temp_model = RebootInstancesResponseInstanceResponses()
            self.instance_responses = temp_model.from_map(map['InstanceResponses'])
        else:
            self.instance_responses = None
        return self


class RebootInstancesResponseInstanceResponsesInstanceResponse(TeaModel):
    def __init__(self, instance_id=None, previous_status=None, current_status=None, code=None, message=None):
        self.instance_id = instance_id
        self.previous_status = previous_status
        self.current_status = current_status
        self.code = code
        self.message = message

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.previous_status, 'previous_status')
        self.validate_required(self.current_status, 'current_status')
        self.validate_required(self.code, 'code')
        self.validate_required(self.message, 'message')

    def to_map(self):
        result = {}
        result['InstanceId'] = self.instance_id
        result['PreviousStatus'] = self.previous_status
        result['CurrentStatus'] = self.current_status
        result['Code'] = self.code
        result['Message'] = self.message
        return result

    def from_map(self, map={}):
        self.instance_id = map.get('InstanceId')
        self.previous_status = map.get('PreviousStatus')
        self.current_status = map.get('CurrentStatus')
        self.code = map.get('Code')
        self.message = map.get('Message')
        return self


class RebootInstancesResponseInstanceResponses(TeaModel):
    def __init__(self, instance_response=None):
        self.instance_response = instance_response

    def validate(self):
        self.validate_required(self.instance_response, 'instance_response')
        if self.instance_response:
            for k in self.instance_response:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['InstanceResponse'] = []
        if self.instance_response is not None:
            for k in self.instance_response:
                result['InstanceResponse'].append(k.to_map() if k else None)
        else:
            result['InstanceResponse'] = None
        return result

    def from_map(self, map={}):
        self.instance_response = []
        if map.get('InstanceResponse') is not None:
            for k in map.get('InstanceResponse'):
                temp_model = RebootInstancesResponseInstanceResponsesInstanceResponse()
                temp_model = temp_model.from_map(k)
                self.instance_response.append(temp_model)
        else:
            self.instance_response = None
        return self
class RedeployDedicatedHostRequest(TeaModel):
    def __init__(self, region_id=None, dedicated_host_id=None):
        self.region_id = region_id
        self.dedicated_host_id = dedicated_host_id

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.dedicated_host_id, 'dedicated_host_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['DedicatedHostId'] = self.dedicated_host_id
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.dedicated_host_id = map.get('DedicatedHostId')
        return self


class RedeployDedicatedHostResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class ModifyInstanceMaintenanceAttributesRequest(TeaModel):
    def __init__(self, region_id=None, instance_id=None, maintenance_window=None, action_on_maintenance=None):
        self.region_id = region_id
        self.instance_id = instance_id
        self.maintenance_window = maintenance_window
        self.action_on_maintenance = action_on_maintenance

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        if self.maintenance_window:
            for k in self.maintenance_window:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['InstanceId'] = []
        if self.instance_id is not None:
            for k in self.instance_id:
                result['InstanceId'].append(k)
        else:
            result['InstanceId'] = None
        result['MaintenanceWindow'] = []
        if self.maintenance_window is not None:
            for k in self.maintenance_window:
                result['MaintenanceWindow'].append(k.to_map() if k else None)
        else:
            result['MaintenanceWindow'] = None
        result['ActionOnMaintenance'] = self.action_on_maintenance
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.instance_id = []
        if map.get('InstanceId') is not None:
            for k in map.get('InstanceId'):
                self.instance_id.append(k)
        else:
            self.instance_id = None
        self.maintenance_window = []
        if map.get('MaintenanceWindow') is not None:
            for k in map.get('MaintenanceWindow'):
                temp_model = ModifyInstanceMaintenanceAttributesRequestMaintenanceWindow()
                temp_model = temp_model.from_map(k)
                self.maintenance_window.append(temp_model)
        else:
            self.maintenance_window = None
        self.action_on_maintenance = map.get('ActionOnMaintenance')
        return self


class ModifyInstanceMaintenanceAttributesRequestMaintenanceWindow(TeaModel):
    def __init__(self, start_time=None, end_time=None):
        self.start_time = start_time
        self.end_time = end_time

    def validate(self):
        self.validate_required(self.start_time, 'start_time')
        self.validate_required(self.end_time, 'end_time')

    def to_map(self):
        result = {}
        result['StartTime'] = self.start_time
        result['EndTime'] = self.end_time
        return result

    def from_map(self, map={}):
        self.start_time = map.get('StartTime')
        self.end_time = map.get('EndTime')
        return self
class ModifyInstanceMaintenanceAttributesResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class DescribeInstanceMaintenanceAttributesRequest(TeaModel):
    def __init__(self, region_id=None, instance_id=None, page_number=None, page_size=None):
        self.region_id = region_id
        self.instance_id = instance_id
        self.page_number = page_number
        self.page_size = page_size

    def validate(self):
        self.validate_required(self.region_id, 'region_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['InstanceId'] = []
        if self.instance_id is not None:
            for k in self.instance_id:
                result['InstanceId'].append(k)
        else:
            result['InstanceId'] = None
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.instance_id = []
        if map.get('InstanceId') is not None:
            for k in map.get('InstanceId'):
                self.instance_id.append(k)
        else:
            self.instance_id = None
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        return self


class DescribeInstanceMaintenanceAttributesResponse(TeaModel):
    def __init__(self, request_id=None, total_count=None, page_number=None, page_size=None,
                 maintenance_attributes=None):
        self.request_id = request_id
        self.total_count = total_count
        self.page_number = page_number
        self.page_size = page_size
        self.maintenance_attributes = maintenance_attributes

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.page_number, 'page_number')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.maintenance_attributes, 'maintenance_attributes')
        if self.maintenance_attributes:
            self.maintenance_attributes.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['TotalCount'] = self.total_count
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        if self.maintenance_attributes is not None:
            result['MaintenanceAttributes'] = self.maintenance_attributes.to_map()
        else:
            result['MaintenanceAttributes'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.total_count = map.get('TotalCount')
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        if map.get('MaintenanceAttributes') is not None:
            temp_model = DescribeInstanceMaintenanceAttributesResponseMaintenanceAttributes()
            self.maintenance_attributes = temp_model.from_map(map['MaintenanceAttributes'])
        else:
            self.maintenance_attributes = None
        return self


class DescribeInstanceMaintenanceAttributesResponseMaintenanceAttributesMaintenanceAttributeMaintenanceWindowsMaintenanceWindow(TeaModel):
    def __init__(self, start_time=None, end_time=None):
        self.start_time = start_time
        self.end_time = end_time

    def validate(self):
        self.validate_required(self.start_time, 'start_time')
        self.validate_required(self.end_time, 'end_time')

    def to_map(self):
        result = {}
        result['StartTime'] = self.start_time
        result['EndTime'] = self.end_time
        return result

    def from_map(self, map={}):
        self.start_time = map.get('StartTime')
        self.end_time = map.get('EndTime')
        return self


class DescribeInstanceMaintenanceAttributesResponseMaintenanceAttributesMaintenanceAttributeMaintenanceWindows(TeaModel):
    def __init__(self, maintenance_window=None):
        self.maintenance_window = maintenance_window

    def validate(self):
        self.validate_required(self.maintenance_window, 'maintenance_window')
        if self.maintenance_window:
            for k in self.maintenance_window:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['MaintenanceWindow'] = []
        if self.maintenance_window is not None:
            for k in self.maintenance_window:
                result['MaintenanceWindow'].append(k.to_map() if k else None)
        else:
            result['MaintenanceWindow'] = None
        return result

    def from_map(self, map={}):
        self.maintenance_window = []
        if map.get('MaintenanceWindow') is not None:
            for k in map.get('MaintenanceWindow'):
                temp_model = DescribeInstanceMaintenanceAttributesResponseMaintenanceAttributesMaintenanceAttributeMaintenanceWindowsMaintenanceWindow()
                temp_model = temp_model.from_map(k)
                self.maintenance_window.append(temp_model)
        else:
            self.maintenance_window = None
        return self


class DescribeInstanceMaintenanceAttributesResponseMaintenanceAttributesMaintenanceAttributeActionOnMaintenanceSupportedValues(TeaModel):
    def __init__(self, supported_value=None):
        # SupportedValue
        self.supported_value = supported_value

    def validate(self):
        self.validate_required(self.supported_value, 'supported_value')

    def to_map(self):
        result = {}
        result['SupportedValue'] = []
        if self.supported_value is not None:
            for k in self.supported_value:
                result['SupportedValue'].append(k)
        else:
            result['SupportedValue'] = None
        return result

    def from_map(self, map={}):
        self.supported_value = []
        if map.get('SupportedValue') is not None:
            for k in map.get('SupportedValue'):
                self.supported_value.append(k)
        else:
            self.supported_value = None
        return self


class DescribeInstanceMaintenanceAttributesResponseMaintenanceAttributesMaintenanceAttributeActionOnMaintenance(TeaModel):
    def __init__(self, value=None, default_value=None, supported_values=None):
        self.value = value
        self.default_value = default_value
        self.supported_values = supported_values

    def validate(self):
        self.validate_required(self.value, 'value')
        self.validate_required(self.default_value, 'default_value')
        self.validate_required(self.supported_values, 'supported_values')
        if self.supported_values:
            self.supported_values.validate()

    def to_map(self):
        result = {}
        result['Value'] = self.value
        result['DefaultValue'] = self.default_value
        if self.supported_values is not None:
            result['SupportedValues'] = self.supported_values.to_map()
        else:
            result['SupportedValues'] = None
        return result

    def from_map(self, map={}):
        self.value = map.get('Value')
        self.default_value = map.get('DefaultValue')
        if map.get('SupportedValues') is not None:
            temp_model = DescribeInstanceMaintenanceAttributesResponseMaintenanceAttributesMaintenanceAttributeActionOnMaintenanceSupportedValues()
            self.supported_values = temp_model.from_map(map['SupportedValues'])
        else:
            self.supported_values = None
        return self


class DescribeInstanceMaintenanceAttributesResponseMaintenanceAttributesMaintenanceAttribute(TeaModel):
    def __init__(self, instance_id=None, maintenance_windows=None, action_on_maintenance=None):
        self.instance_id = instance_id
        self.maintenance_windows = maintenance_windows
        self.action_on_maintenance = action_on_maintenance

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.maintenance_windows, 'maintenance_windows')
        if self.maintenance_windows:
            self.maintenance_windows.validate()
        self.validate_required(self.action_on_maintenance, 'action_on_maintenance')
        if self.action_on_maintenance:
            self.action_on_maintenance.validate()

    def to_map(self):
        result = {}
        result['InstanceId'] = self.instance_id
        if self.maintenance_windows is not None:
            result['MaintenanceWindows'] = self.maintenance_windows.to_map()
        else:
            result['MaintenanceWindows'] = None
        if self.action_on_maintenance is not None:
            result['ActionOnMaintenance'] = self.action_on_maintenance.to_map()
        else:
            result['ActionOnMaintenance'] = None
        return result

    def from_map(self, map={}):
        self.instance_id = map.get('InstanceId')
        if map.get('MaintenanceWindows') is not None:
            temp_model = DescribeInstanceMaintenanceAttributesResponseMaintenanceAttributesMaintenanceAttributeMaintenanceWindows()
            self.maintenance_windows = temp_model.from_map(map['MaintenanceWindows'])
        else:
            self.maintenance_windows = None
        if map.get('ActionOnMaintenance') is not None:
            temp_model = DescribeInstanceMaintenanceAttributesResponseMaintenanceAttributesMaintenanceAttributeActionOnMaintenance()
            self.action_on_maintenance = temp_model.from_map(map['ActionOnMaintenance'])
        else:
            self.action_on_maintenance = None
        return self


class DescribeInstanceMaintenanceAttributesResponseMaintenanceAttributes(TeaModel):
    def __init__(self, maintenance_attribute=None):
        self.maintenance_attribute = maintenance_attribute

    def validate(self):
        self.validate_required(self.maintenance_attribute, 'maintenance_attribute')
        if self.maintenance_attribute:
            for k in self.maintenance_attribute:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['MaintenanceAttribute'] = []
        if self.maintenance_attribute is not None:
            for k in self.maintenance_attribute:
                result['MaintenanceAttribute'].append(k.to_map() if k else None)
        else:
            result['MaintenanceAttribute'] = None
        return result

    def from_map(self, map={}):
        self.maintenance_attribute = []
        if map.get('MaintenanceAttribute') is not None:
            for k in map.get('MaintenanceAttribute'):
                temp_model = DescribeInstanceMaintenanceAttributesResponseMaintenanceAttributesMaintenanceAttribute()
                temp_model = temp_model.from_map(k)
                self.maintenance_attribute.append(temp_model)
        else:
            self.maintenance_attribute = None
        return self
class ModifyDemandRequest(TeaModel):
    def __init__(self, client_token=None, region_id=None, zone_id=None, demand_id=None, demand_name=None,
                 demand_description=None, instance_type=None, amount=None, instance_charge_type=None, period=None, period_unit=None,
                 start_time=None, end_time=None):
        self.client_token = client_token
        self.region_id = region_id
        self.zone_id = zone_id
        self.demand_id = demand_id
        self.demand_name = demand_name
        self.demand_description = demand_description
        self.instance_type = instance_type
        self.amount = amount
        self.instance_charge_type = instance_charge_type
        self.period = period
        self.period_unit = period_unit
        self.start_time = start_time
        self.end_time = end_time

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.demand_id, 'demand_id')

    def to_map(self):
        result = {}
        result['ClientToken'] = self.client_token
        result['RegionId'] = self.region_id
        result['ZoneId'] = self.zone_id
        result['DemandId'] = self.demand_id
        result['DemandName'] = self.demand_name
        result['DemandDescription'] = self.demand_description
        result['InstanceType'] = self.instance_type
        result['Amount'] = self.amount
        result['InstanceChargeType'] = self.instance_charge_type
        result['Period'] = self.period
        result['PeriodUnit'] = self.period_unit
        result['StartTime'] = self.start_time
        result['EndTime'] = self.end_time
        return result

    def from_map(self, map={}):
        self.client_token = map.get('ClientToken')
        self.region_id = map.get('RegionId')
        self.zone_id = map.get('ZoneId')
        self.demand_id = map.get('DemandId')
        self.demand_name = map.get('DemandName')
        self.demand_description = map.get('DemandDescription')
        self.instance_type = map.get('InstanceType')
        self.amount = map.get('Amount')
        self.instance_charge_type = map.get('InstanceChargeType')
        self.period = map.get('Period')
        self.period_unit = map.get('PeriodUnit')
        self.start_time = map.get('StartTime')
        self.end_time = map.get('EndTime')
        return self


class ModifyDemandResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class DeleteDemandRequest(TeaModel):
    def __init__(self, client_token=None, region_id=None, demand_id=None, reason=None):
        self.client_token = client_token
        self.region_id = region_id
        self.demand_id = demand_id
        self.reason = reason

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.demand_id, 'demand_id')

    def to_map(self):
        result = {}
        result['ClientToken'] = self.client_token
        result['RegionId'] = self.region_id
        result['DemandId'] = self.demand_id
        result['Reason'] = self.reason
        return result

    def from_map(self, map={}):
        self.client_token = map.get('ClientToken')
        self.region_id = map.get('RegionId')
        self.demand_id = map.get('DemandId')
        self.reason = map.get('Reason')
        return self


class DeleteDemandResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class CreateDemandRequest(TeaModel):
    def __init__(self, client_token=None, region_id=None, zone_id=None, demand_name=None, demand_description=None,
                 instance_type=None, amount=None, instance_charge_type=None, period=None, period_unit=None, start_time=None,
                 end_time=None):
        self.client_token = client_token
        self.region_id = region_id
        self.zone_id = zone_id
        self.demand_name = demand_name
        self.demand_description = demand_description
        self.instance_type = instance_type
        self.amount = amount
        self.instance_charge_type = instance_charge_type
        self.period = period
        self.period_unit = period_unit
        self.start_time = start_time
        self.end_time = end_time

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.zone_id, 'zone_id')
        self.validate_required(self.instance_type, 'instance_type')
        self.validate_required(self.amount, 'amount')
        self.validate_required(self.period, 'period')
        self.validate_required(self.period_unit, 'period_unit')
        self.validate_required(self.start_time, 'start_time')
        self.validate_required(self.end_time, 'end_time')

    def to_map(self):
        result = {}
        result['ClientToken'] = self.client_token
        result['RegionId'] = self.region_id
        result['ZoneId'] = self.zone_id
        result['DemandName'] = self.demand_name
        result['DemandDescription'] = self.demand_description
        result['InstanceType'] = self.instance_type
        result['Amount'] = self.amount
        result['InstanceChargeType'] = self.instance_charge_type
        result['Period'] = self.period
        result['PeriodUnit'] = self.period_unit
        result['StartTime'] = self.start_time
        result['EndTime'] = self.end_time
        return result

    def from_map(self, map={}):
        self.client_token = map.get('ClientToken')
        self.region_id = map.get('RegionId')
        self.zone_id = map.get('ZoneId')
        self.demand_name = map.get('DemandName')
        self.demand_description = map.get('DemandDescription')
        self.instance_type = map.get('InstanceType')
        self.amount = map.get('Amount')
        self.instance_charge_type = map.get('InstanceChargeType')
        self.period = map.get('Period')
        self.period_unit = map.get('PeriodUnit')
        self.start_time = map.get('StartTime')
        self.end_time = map.get('EndTime')
        return self


class CreateDemandResponse(TeaModel):
    def __init__(self, request_id=None, demand_id=None):
        self.request_id = request_id
        self.demand_id = demand_id

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.demand_id, 'demand_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['DemandId'] = self.demand_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.demand_id = map.get('DemandId')
        return self


class PurchaseStorageCapacityUnitRequest(TeaModel):
    def __init__(self, region_id=None, name=None, capacity=None, description=None, start_time=None, period=None,
                 period_unit=None, from_app=None, client_token=None, amount=None):
        self.region_id = region_id
        self.name = name
        self.capacity = capacity
        self.description = description
        self.start_time = start_time
        self.period = period
        self.period_unit = period_unit
        self.from_app = from_app
        self.client_token = client_token
        self.amount = amount

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.capacity, 'capacity')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['Name'] = self.name
        result['Capacity'] = self.capacity
        result['Description'] = self.description
        result['StartTime'] = self.start_time
        result['Period'] = self.period
        result['PeriodUnit'] = self.period_unit
        result['FromApp'] = self.from_app
        result['ClientToken'] = self.client_token
        result['Amount'] = self.amount
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.name = map.get('Name')
        self.capacity = map.get('Capacity')
        self.description = map.get('Description')
        self.start_time = map.get('StartTime')
        self.period = map.get('Period')
        self.period_unit = map.get('PeriodUnit')
        self.from_app = map.get('FromApp')
        self.client_token = map.get('ClientToken')
        self.amount = map.get('Amount')
        return self


class PurchaseStorageCapacityUnitResponse(TeaModel):
    def __init__(self, request_id=None, order_id=None, storage_capacity_unit_ids=None):
        self.request_id = request_id
        self.order_id = order_id
        self.storage_capacity_unit_ids = storage_capacity_unit_ids

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.order_id, 'order_id')
        self.validate_required(self.storage_capacity_unit_ids, 'storage_capacity_unit_ids')
        if self.storage_capacity_unit_ids:
            self.storage_capacity_unit_ids.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['OrderId'] = self.order_id
        if self.storage_capacity_unit_ids is not None:
            result['StorageCapacityUnitIds'] = self.storage_capacity_unit_ids.to_map()
        else:
            result['StorageCapacityUnitIds'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.order_id = map.get('OrderId')
        if map.get('StorageCapacityUnitIds') is not None:
            temp_model = PurchaseStorageCapacityUnitResponseStorageCapacityUnitIds()
            self.storage_capacity_unit_ids = temp_model.from_map(map['StorageCapacityUnitIds'])
        else:
            self.storage_capacity_unit_ids = None
        return self


class PurchaseStorageCapacityUnitResponseStorageCapacityUnitIds(TeaModel):
    def __init__(self, storage_capacity_unit_id=None):
        self.storage_capacity_unit_id = storage_capacity_unit_id

    def validate(self):
        self.validate_required(self.storage_capacity_unit_id, 'storage_capacity_unit_id')

    def to_map(self):
        result = {}
        result['StorageCapacityUnitId'] = []
        if self.storage_capacity_unit_id is not None:
            for k in self.storage_capacity_unit_id:
                result['StorageCapacityUnitId'].append(k)
        else:
            result['StorageCapacityUnitId'] = None
        return result

    def from_map(self, map={}):
        self.storage_capacity_unit_id = []
        if map.get('StorageCapacityUnitId') is not None:
            for k in map.get('StorageCapacityUnitId'):
                self.storage_capacity_unit_id.append(k)
        else:
            self.storage_capacity_unit_id = None
        return self
class ModifyStorageCapacityUnitAttributeRequest(TeaModel):
    def __init__(self, region_id=None, storage_capacity_unit_id=None, name=None, description=None):
        self.region_id = region_id
        self.storage_capacity_unit_id = storage_capacity_unit_id
        self.name = name
        self.description = description

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.storage_capacity_unit_id, 'storage_capacity_unit_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['StorageCapacityUnitId'] = self.storage_capacity_unit_id
        result['Name'] = self.name
        result['Description'] = self.description
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.storage_capacity_unit_id = map.get('StorageCapacityUnitId')
        self.name = map.get('Name')
        self.description = map.get('Description')
        return self


class ModifyStorageCapacityUnitAttributeResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class DescribeStorageCapacityUnitsRequest(TeaModel):
    def __init__(self, region_id=None, page_number=None, page_size=None, name=None, capacity=None,
                 storage_capacity_unit_id=None, status=None, allocation_type=None):
        self.region_id = region_id
        self.page_number = page_number
        self.page_size = page_size
        self.name = name
        self.capacity = capacity
        self.storage_capacity_unit_id = storage_capacity_unit_id
        self.status = status
        self.allocation_type = allocation_type

    def validate(self):
        self.validate_required(self.region_id, 'region_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        result['Name'] = self.name
        result['Capacity'] = self.capacity
        result['StorageCapacityUnitId'] = []
        if self.storage_capacity_unit_id is not None:
            for k in self.storage_capacity_unit_id:
                result['StorageCapacityUnitId'].append(k)
        else:
            result['StorageCapacityUnitId'] = None
        result['Status'] = []
        if self.status is not None:
            for k in self.status:
                result['Status'].append(k)
        else:
            result['Status'] = None
        result['AllocationType'] = self.allocation_type
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        self.name = map.get('Name')
        self.capacity = map.get('Capacity')
        self.storage_capacity_unit_id = []
        if map.get('StorageCapacityUnitId') is not None:
            for k in map.get('StorageCapacityUnitId'):
                self.storage_capacity_unit_id.append(k)
        else:
            self.storage_capacity_unit_id = None
        self.status = []
        if map.get('Status') is not None:
            for k in map.get('Status'):
                self.status.append(k)
        else:
            self.status = None
        self.allocation_type = map.get('AllocationType')
        return self


class DescribeStorageCapacityUnitsResponse(TeaModel):
    def __init__(self, request_id=None, total_count=None, page_number=None, page_size=None,
                 storage_capacity_units=None):
        self.request_id = request_id
        self.total_count = total_count
        self.page_number = page_number
        self.page_size = page_size
        self.storage_capacity_units = storage_capacity_units

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.page_number, 'page_number')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.storage_capacity_units, 'storage_capacity_units')
        if self.storage_capacity_units:
            self.storage_capacity_units.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['TotalCount'] = self.total_count
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        if self.storage_capacity_units is not None:
            result['StorageCapacityUnits'] = self.storage_capacity_units.to_map()
        else:
            result['StorageCapacityUnits'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.total_count = map.get('TotalCount')
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        if map.get('StorageCapacityUnits') is not None:
            temp_model = DescribeStorageCapacityUnitsResponseStorageCapacityUnits()
            self.storage_capacity_units = temp_model.from_map(map['StorageCapacityUnits'])
        else:
            self.storage_capacity_units = None
        return self


class DescribeStorageCapacityUnitsResponseStorageCapacityUnitsStorageCapacityUnit(TeaModel):
    def __init__(self, region_id=None, storage_capacity_unit_id=None, name=None, capacity=None, status=None,
                 creation_time=None, expired_time=None, start_time=None, description=None, allocation_status=None):
        self.region_id = region_id
        self.storage_capacity_unit_id = storage_capacity_unit_id
        self.name = name
        self.capacity = capacity
        self.status = status
        self.creation_time = creation_time
        self.expired_time = expired_time
        self.start_time = start_time
        self.description = description
        self.allocation_status = allocation_status

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.storage_capacity_unit_id, 'storage_capacity_unit_id')
        self.validate_required(self.name, 'name')
        self.validate_required(self.capacity, 'capacity')
        self.validate_required(self.status, 'status')
        self.validate_required(self.creation_time, 'creation_time')
        self.validate_required(self.expired_time, 'expired_time')
        self.validate_required(self.start_time, 'start_time')
        self.validate_required(self.description, 'description')
        self.validate_required(self.allocation_status, 'allocation_status')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['StorageCapacityUnitId'] = self.storage_capacity_unit_id
        result['Name'] = self.name
        result['Capacity'] = self.capacity
        result['Status'] = self.status
        result['CreationTime'] = self.creation_time
        result['ExpiredTime'] = self.expired_time
        result['StartTime'] = self.start_time
        result['Description'] = self.description
        result['AllocationStatus'] = self.allocation_status
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.storage_capacity_unit_id = map.get('StorageCapacityUnitId')
        self.name = map.get('Name')
        self.capacity = map.get('Capacity')
        self.status = map.get('Status')
        self.creation_time = map.get('CreationTime')
        self.expired_time = map.get('ExpiredTime')
        self.start_time = map.get('StartTime')
        self.description = map.get('Description')
        self.allocation_status = map.get('AllocationStatus')
        return self


class DescribeStorageCapacityUnitsResponseStorageCapacityUnits(TeaModel):
    def __init__(self, storage_capacity_unit=None):
        self.storage_capacity_unit = storage_capacity_unit

    def validate(self):
        self.validate_required(self.storage_capacity_unit, 'storage_capacity_unit')
        if self.storage_capacity_unit:
            for k in self.storage_capacity_unit:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['StorageCapacityUnit'] = []
        if self.storage_capacity_unit is not None:
            for k in self.storage_capacity_unit:
                result['StorageCapacityUnit'].append(k.to_map() if k else None)
        else:
            result['StorageCapacityUnit'] = None
        return result

    def from_map(self, map={}):
        self.storage_capacity_unit = []
        if map.get('StorageCapacityUnit') is not None:
            for k in map.get('StorageCapacityUnit'):
                temp_model = DescribeStorageCapacityUnitsResponseStorageCapacityUnitsStorageCapacityUnit()
                temp_model = temp_model.from_map(k)
                self.storage_capacity_unit.append(temp_model)
        else:
            self.storage_capacity_unit = None
        return self
class RunCommandRequest(TeaModel):
    def __init__(self, region_id=None, name=None, description=None, type=None, command_content=None,
                 working_dir=None, timeout=None, enable_parameter=None, timed=None, frequency=None, instance_id=None,
                 parameters=None, keep_command=None, content_encoding=None):
        self.region_id = region_id
        self.name = name
        self.description = description
        self.type = type
        self.command_content = command_content
        self.working_dir = working_dir
        self.timeout = timeout
        self.enable_parameter = enable_parameter
        self.timed = timed
        self.frequency = frequency
        self.instance_id = instance_id
        self.parameters = parameters
        self.keep_command = keep_command
        self.content_encoding = content_encoding

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.type, 'type')
        self.validate_required(self.command_content, 'command_content')
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['Name'] = self.name
        result['Description'] = self.description
        result['Type'] = self.type
        result['CommandContent'] = self.command_content
        result['WorkingDir'] = self.working_dir
        result['Timeout'] = self.timeout
        result['EnableParameter'] = self.enable_parameter
        result['Timed'] = self.timed
        result['Frequency'] = self.frequency
        result['InstanceId'] = []
        if self.instance_id is not None:
            for k in self.instance_id:
                result['InstanceId'].append(k)
        else:
            result['InstanceId'] = None
        result['Parameters'] = self.parameters
        result['KeepCommand'] = self.keep_command
        result['ContentEncoding'] = self.content_encoding
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.name = map.get('Name')
        self.description = map.get('Description')
        self.type = map.get('Type')
        self.command_content = map.get('CommandContent')
        self.working_dir = map.get('WorkingDir')
        self.timeout = map.get('Timeout')
        self.enable_parameter = map.get('EnableParameter')
        self.timed = map.get('Timed')
        self.frequency = map.get('Frequency')
        self.instance_id = []
        if map.get('InstanceId') is not None:
            for k in map.get('InstanceId'):
                self.instance_id.append(k)
        else:
            self.instance_id = None
        self.parameters = map.get('Parameters')
        self.keep_command = map.get('KeepCommand')
        self.content_encoding = map.get('ContentEncoding')
        return self


class RunCommandResponse(TeaModel):
    def __init__(self, request_id=None, command_id=None, invoke_id=None):
        self.request_id = request_id
        self.command_id = command_id
        self.invoke_id = invoke_id

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.command_id, 'command_id')
        self.validate_required(self.invoke_id, 'invoke_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['CommandId'] = self.command_id
        result['InvokeId'] = self.invoke_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.command_id = map.get('CommandId')
        self.invoke_id = map.get('InvokeId')
        return self


class DeleteInstancesRequest(TeaModel):
    def __init__(self, instance_id=None, dry_run=None, force=None, terminate_subscription=None, client_token=None,
                 region_id=None):
        self.instance_id = instance_id
        self.dry_run = dry_run
        self.force = force
        self.terminate_subscription = terminate_subscription
        self.client_token = client_token
        self.region_id = region_id

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.region_id, 'region_id')

    def to_map(self):
        result = {}
        result['InstanceId'] = []
        if self.instance_id is not None:
            for k in self.instance_id:
                result['InstanceId'].append(k)
        else:
            result['InstanceId'] = None
        result['DryRun'] = self.dry_run
        result['Force'] = self.force
        result['TerminateSubscription'] = self.terminate_subscription
        result['ClientToken'] = self.client_token
        result['RegionId'] = self.region_id
        return result

    def from_map(self, map={}):
        self.instance_id = []
        if map.get('InstanceId') is not None:
            for k in map.get('InstanceId'):
                self.instance_id.append(k)
        else:
            self.instance_id = None
        self.dry_run = map.get('DryRun')
        self.force = map.get('Force')
        self.terminate_subscription = map.get('TerminateSubscription')
        self.client_token = map.get('ClientToken')
        self.region_id = map.get('RegionId')
        return self


class DeleteInstancesResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class ModifyStorageSetAttributeRequest(TeaModel):
    def __init__(self, client_token=None, region_id=None, storage_set_id=None, storage_set_name=None,
                 description=None):
        self.client_token = client_token
        self.region_id = region_id
        self.storage_set_id = storage_set_id
        self.storage_set_name = storage_set_name
        self.description = description

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.storage_set_id, 'storage_set_id')

    def to_map(self):
        result = {}
        result['ClientToken'] = self.client_token
        result['RegionId'] = self.region_id
        result['StorageSetId'] = self.storage_set_id
        result['StorageSetName'] = self.storage_set_name
        result['Description'] = self.description
        return result

    def from_map(self, map={}):
        self.client_token = map.get('ClientToken')
        self.region_id = map.get('RegionId')
        self.storage_set_id = map.get('StorageSetId')
        self.storage_set_name = map.get('StorageSetName')
        self.description = map.get('Description')
        return self


class ModifyStorageSetAttributeResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class DescribeStorageSetsRequest(TeaModel):
    def __init__(self, client_token=None, region_id=None, storage_set_ids=None, zone_id=None, storage_set_name=None,
                 page_number=None, page_size=None):
        self.client_token = client_token
        self.region_id = region_id
        self.storage_set_ids = storage_set_ids
        self.zone_id = zone_id
        self.storage_set_name = storage_set_name
        self.page_number = page_number
        self.page_size = page_size

    def validate(self):
        self.validate_required(self.region_id, 'region_id')

    def to_map(self):
        result = {}
        result['ClientToken'] = self.client_token
        result['RegionId'] = self.region_id
        result['StorageSetIds'] = self.storage_set_ids
        result['ZoneId'] = self.zone_id
        result['StorageSetName'] = self.storage_set_name
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        return result

    def from_map(self, map={}):
        self.client_token = map.get('ClientToken')
        self.region_id = map.get('RegionId')
        self.storage_set_ids = map.get('StorageSetIds')
        self.zone_id = map.get('ZoneId')
        self.storage_set_name = map.get('StorageSetName')
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        return self


class DescribeStorageSetsResponse(TeaModel):
    def __init__(self, request_id=None, total_count=None, page_number=None, page_size=None, storage_sets=None):
        self.request_id = request_id
        self.total_count = total_count
        self.page_number = page_number
        self.page_size = page_size
        self.storage_sets = storage_sets

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.page_number, 'page_number')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.storage_sets, 'storage_sets')
        if self.storage_sets:
            self.storage_sets.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['TotalCount'] = self.total_count
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        if self.storage_sets is not None:
            result['StorageSets'] = self.storage_sets.to_map()
        else:
            result['StorageSets'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.total_count = map.get('TotalCount')
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        if map.get('StorageSets') is not None:
            temp_model = DescribeStorageSetsResponseStorageSets()
            self.storage_sets = temp_model.from_map(map['StorageSets'])
        else:
            self.storage_sets = None
        return self


class DescribeStorageSetsResponseStorageSetsStorageSet(TeaModel):
    def __init__(self, storage_set_id=None, creation_time=None, storage_set_name=None, description=None,
                 storage_set_partition_number=None, region_id=None, zone_id=None):
        self.storage_set_id = storage_set_id
        self.creation_time = creation_time
        self.storage_set_name = storage_set_name
        self.description = description
        self.storage_set_partition_number = storage_set_partition_number
        self.region_id = region_id
        self.zone_id = zone_id

    def validate(self):
        self.validate_required(self.storage_set_id, 'storage_set_id')
        self.validate_required(self.creation_time, 'creation_time')
        self.validate_required(self.storage_set_name, 'storage_set_name')
        self.validate_required(self.description, 'description')
        self.validate_required(self.storage_set_partition_number, 'storage_set_partition_number')
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.zone_id, 'zone_id')

    def to_map(self):
        result = {}
        result['StorageSetId'] = self.storage_set_id
        result['CreationTime'] = self.creation_time
        result['StorageSetName'] = self.storage_set_name
        result['Description'] = self.description
        result['StorageSetPartitionNumber'] = self.storage_set_partition_number
        result['RegionId'] = self.region_id
        result['ZoneId'] = self.zone_id
        return result

    def from_map(self, map={}):
        self.storage_set_id = map.get('StorageSetId')
        self.creation_time = map.get('CreationTime')
        self.storage_set_name = map.get('StorageSetName')
        self.description = map.get('Description')
        self.storage_set_partition_number = map.get('StorageSetPartitionNumber')
        self.region_id = map.get('RegionId')
        self.zone_id = map.get('ZoneId')
        return self


class DescribeStorageSetsResponseStorageSets(TeaModel):
    def __init__(self, storage_set=None):
        self.storage_set = storage_set

    def validate(self):
        self.validate_required(self.storage_set, 'storage_set')
        if self.storage_set:
            for k in self.storage_set:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['StorageSet'] = []
        if self.storage_set is not None:
            for k in self.storage_set:
                result['StorageSet'].append(k.to_map() if k else None)
        else:
            result['StorageSet'] = None
        return result

    def from_map(self, map={}):
        self.storage_set = []
        if map.get('StorageSet') is not None:
            for k in map.get('StorageSet'):
                temp_model = DescribeStorageSetsResponseStorageSetsStorageSet()
                temp_model = temp_model.from_map(k)
                self.storage_set.append(temp_model)
        else:
            self.storage_set = None
        return self
class DescribeStorageSetDetailsRequest(TeaModel):
    def __init__(self, client_token=None, region_id=None, storage_set_id=None, storage_set_partition_number=None,
                 disk_ids=None, page_number=None, page_size=None):
        self.client_token = client_token
        self.region_id = region_id
        self.storage_set_id = storage_set_id
        self.storage_set_partition_number = storage_set_partition_number
        self.disk_ids = disk_ids
        self.page_number = page_number
        self.page_size = page_size

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.storage_set_id, 'storage_set_id')

    def to_map(self):
        result = {}
        result['ClientToken'] = self.client_token
        result['RegionId'] = self.region_id
        result['StorageSetId'] = self.storage_set_id
        result['StorageSetPartitionNumber'] = self.storage_set_partition_number
        result['DiskIds'] = self.disk_ids
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        return result

    def from_map(self, map={}):
        self.client_token = map.get('ClientToken')
        self.region_id = map.get('RegionId')
        self.storage_set_id = map.get('StorageSetId')
        self.storage_set_partition_number = map.get('StorageSetPartitionNumber')
        self.disk_ids = map.get('DiskIds')
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        return self


class DescribeStorageSetDetailsResponse(TeaModel):
    def __init__(self, request_id=None, total_count=None, page_number=None, page_size=None, disks=None):
        self.request_id = request_id
        self.total_count = total_count
        self.page_number = page_number
        self.page_size = page_size
        self.disks = disks

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.page_number, 'page_number')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.disks, 'disks')
        if self.disks:
            self.disks.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['TotalCount'] = self.total_count
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        if self.disks is not None:
            result['Disks'] = self.disks.to_map()
        else:
            result['Disks'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.total_count = map.get('TotalCount')
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        if map.get('Disks') is not None:
            temp_model = DescribeStorageSetDetailsResponseDisks()
            self.disks = temp_model.from_map(map['Disks'])
        else:
            self.disks = None
        return self


class DescribeStorageSetDetailsResponseDisksDisk(TeaModel):
    def __init__(self, disk_id=None, disk_name=None, category=None, storage_set_id=None, creation_time=None,
                 storage_set_partition_number=None, region_id=None, zone_id=None):
        self.disk_id = disk_id
        self.disk_name = disk_name
        self.category = category
        self.storage_set_id = storage_set_id
        self.creation_time = creation_time
        self.storage_set_partition_number = storage_set_partition_number
        self.region_id = region_id
        self.zone_id = zone_id

    def validate(self):
        self.validate_required(self.disk_id, 'disk_id')
        self.validate_required(self.disk_name, 'disk_name')
        self.validate_required(self.category, 'category')
        self.validate_required(self.storage_set_id, 'storage_set_id')
        self.validate_required(self.creation_time, 'creation_time')
        self.validate_required(self.storage_set_partition_number, 'storage_set_partition_number')
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.zone_id, 'zone_id')

    def to_map(self):
        result = {}
        result['DiskId'] = self.disk_id
        result['DiskName'] = self.disk_name
        result['Category'] = self.category
        result['StorageSetId'] = self.storage_set_id
        result['CreationTime'] = self.creation_time
        result['StorageSetPartitionNumber'] = self.storage_set_partition_number
        result['RegionId'] = self.region_id
        result['ZoneId'] = self.zone_id
        return result

    def from_map(self, map={}):
        self.disk_id = map.get('DiskId')
        self.disk_name = map.get('DiskName')
        self.category = map.get('Category')
        self.storage_set_id = map.get('StorageSetId')
        self.creation_time = map.get('CreationTime')
        self.storage_set_partition_number = map.get('StorageSetPartitionNumber')
        self.region_id = map.get('RegionId')
        self.zone_id = map.get('ZoneId')
        return self


class DescribeStorageSetDetailsResponseDisks(TeaModel):
    def __init__(self, disk=None):
        self.disk = disk

    def validate(self):
        self.validate_required(self.disk, 'disk')
        if self.disk:
            for k in self.disk:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['Disk'] = []
        if self.disk is not None:
            for k in self.disk:
                result['Disk'].append(k.to_map() if k else None)
        else:
            result['Disk'] = None
        return result

    def from_map(self, map={}):
        self.disk = []
        if map.get('Disk') is not None:
            for k in map.get('Disk'):
                temp_model = DescribeStorageSetDetailsResponseDisksDisk()
                temp_model = temp_model.from_map(k)
                self.disk.append(temp_model)
        else:
            self.disk = None
        return self
class DeleteStorageSetRequest(TeaModel):
    def __init__(self, client_token=None, region_id=None, storage_set_id=None):
        self.client_token = client_token
        self.region_id = region_id
        self.storage_set_id = storage_set_id

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.storage_set_id, 'storage_set_id')

    def to_map(self):
        result = {}
        result['ClientToken'] = self.client_token
        result['RegionId'] = self.region_id
        result['StorageSetId'] = self.storage_set_id
        return result

    def from_map(self, map={}):
        self.client_token = map.get('ClientToken')
        self.region_id = map.get('RegionId')
        self.storage_set_id = map.get('StorageSetId')
        return self


class DeleteStorageSetResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class CreateStorageSetRequest(TeaModel):
    def __init__(self, client_token=None, region_id=None, zone_id=None, storage_set_name=None, description=None,
                 max_partition_number=None):
        self.client_token = client_token
        self.region_id = region_id
        self.zone_id = zone_id
        self.storage_set_name = storage_set_name
        self.description = description
        self.max_partition_number = max_partition_number

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.zone_id, 'zone_id')

    def to_map(self):
        result = {}
        result['ClientToken'] = self.client_token
        result['RegionId'] = self.region_id
        result['ZoneId'] = self.zone_id
        result['StorageSetName'] = self.storage_set_name
        result['Description'] = self.description
        result['MaxPartitionNumber'] = self.max_partition_number
        return result

    def from_map(self, map={}):
        self.client_token = map.get('ClientToken')
        self.region_id = map.get('RegionId')
        self.zone_id = map.get('ZoneId')
        self.storage_set_name = map.get('StorageSetName')
        self.description = map.get('Description')
        self.max_partition_number = map.get('MaxPartitionNumber')
        return self


class CreateStorageSetResponse(TeaModel):
    def __init__(self, request_id=None, storage_set_id=None):
        self.request_id = request_id
        self.storage_set_id = storage_set_id

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.storage_set_id, 'storage_set_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['StorageSetId'] = self.storage_set_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.storage_set_id = map.get('StorageSetId')
        return self


class ModifyDiskSpecRequest(TeaModel):
    def __init__(self, disk_id=None, performance_level=None, disk_category=None, dry_run=None):
        self.disk_id = disk_id
        self.performance_level = performance_level
        self.disk_category = disk_category
        self.dry_run = dry_run

    def validate(self):
        self.validate_required(self.disk_id, 'disk_id')

    def to_map(self):
        result = {}
        result['DiskId'] = self.disk_id
        result['PerformanceLevel'] = self.performance_level
        result['DiskCategory'] = self.disk_category
        result['DryRun'] = self.dry_run
        return result

    def from_map(self, map={}):
        self.disk_id = map.get('DiskId')
        self.performance_level = map.get('PerformanceLevel')
        self.disk_category = map.get('DiskCategory')
        self.dry_run = map.get('DryRun')
        return self


class ModifyDiskSpecResponse(TeaModel):
    def __init__(self, request_id=None, task_id=None):
        self.request_id = request_id
        self.task_id = task_id

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.task_id, 'task_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['TaskId'] = self.task_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.task_id = map.get('TaskId')
        return self


class ModifyAutoProvisioningGroupRequest(TeaModel):
    def __init__(self, region_id=None, auto_provisioning_group_id=None, excess_capacity_termination_policy=None,
                 default_target_capacity_type=None, terminate_instances_with_expiration=None, max_spot_price=None, total_target_capacity=None,
                 pay_as_you_go_target_capacity=None, spot_target_capacity=None, auto_provisioning_group_name=None):
        self.region_id = region_id
        self.auto_provisioning_group_id = auto_provisioning_group_id
        self.excess_capacity_termination_policy = excess_capacity_termination_policy
        self.default_target_capacity_type = default_target_capacity_type
        self.terminate_instances_with_expiration = terminate_instances_with_expiration
        self.max_spot_price = max_spot_price
        self.total_target_capacity = total_target_capacity
        self.pay_as_you_go_target_capacity = pay_as_you_go_target_capacity
        self.spot_target_capacity = spot_target_capacity
        self.auto_provisioning_group_name = auto_provisioning_group_name

    def validate(self):
        self.validate_required(self.region_id, 'region_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['AutoProvisioningGroupId'] = self.auto_provisioning_group_id
        result['ExcessCapacityTerminationPolicy'] = self.excess_capacity_termination_policy
        result['DefaultTargetCapacityType'] = self.default_target_capacity_type
        result['TerminateInstancesWithExpiration'] = self.terminate_instances_with_expiration
        result['MaxSpotPrice'] = self.max_spot_price
        result['TotalTargetCapacity'] = self.total_target_capacity
        result['PayAsYouGoTargetCapacity'] = self.pay_as_you_go_target_capacity
        result['SpotTargetCapacity'] = self.spot_target_capacity
        result['AutoProvisioningGroupName'] = self.auto_provisioning_group_name
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.auto_provisioning_group_id = map.get('AutoProvisioningGroupId')
        self.excess_capacity_termination_policy = map.get('ExcessCapacityTerminationPolicy')
        self.default_target_capacity_type = map.get('DefaultTargetCapacityType')
        self.terminate_instances_with_expiration = map.get('TerminateInstancesWithExpiration')
        self.max_spot_price = map.get('MaxSpotPrice')
        self.total_target_capacity = map.get('TotalTargetCapacity')
        self.pay_as_you_go_target_capacity = map.get('PayAsYouGoTargetCapacity')
        self.spot_target_capacity = map.get('SpotTargetCapacity')
        self.auto_provisioning_group_name = map.get('AutoProvisioningGroupName')
        return self


class ModifyAutoProvisioningGroupResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class DescribeAutoProvisioningGroupsRequest(TeaModel):
    def __init__(self, region_id=None, page_number=None, page_size=None, auto_provisioning_group_name=None,
                 auto_provisioning_group_id=None, auto_provisioning_group_status=None):
        self.region_id = region_id
        self.page_number = page_number
        self.page_size = page_size
        self.auto_provisioning_group_name = auto_provisioning_group_name
        self.auto_provisioning_group_id = auto_provisioning_group_id
        self.auto_provisioning_group_status = auto_provisioning_group_status

    def validate(self):
        self.validate_required(self.region_id, 'region_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        result['AutoProvisioningGroupName'] = self.auto_provisioning_group_name
        result['AutoProvisioningGroupId'] = []
        if self.auto_provisioning_group_id is not None:
            for k in self.auto_provisioning_group_id:
                result['AutoProvisioningGroupId'].append(k)
        else:
            result['AutoProvisioningGroupId'] = None
        result['AutoProvisioningGroupStatus'] = []
        if self.auto_provisioning_group_status is not None:
            for k in self.auto_provisioning_group_status:
                result['AutoProvisioningGroupStatus'].append(k)
        else:
            result['AutoProvisioningGroupStatus'] = None
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        self.auto_provisioning_group_name = map.get('AutoProvisioningGroupName')
        self.auto_provisioning_group_id = []
        if map.get('AutoProvisioningGroupId') is not None:
            for k in map.get('AutoProvisioningGroupId'):
                self.auto_provisioning_group_id.append(k)
        else:
            self.auto_provisioning_group_id = None
        self.auto_provisioning_group_status = []
        if map.get('AutoProvisioningGroupStatus') is not None:
            for k in map.get('AutoProvisioningGroupStatus'):
                self.auto_provisioning_group_status.append(k)
        else:
            self.auto_provisioning_group_status = None
        return self


class DescribeAutoProvisioningGroupsResponse(TeaModel):
    def __init__(self, request_id=None, total_count=None, page_number=None, page_size=None,
                 auto_provisioning_groups=None):
        self.request_id = request_id
        self.total_count = total_count
        self.page_number = page_number
        self.page_size = page_size
        self.auto_provisioning_groups = auto_provisioning_groups

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.page_number, 'page_number')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.auto_provisioning_groups, 'auto_provisioning_groups')
        if self.auto_provisioning_groups:
            self.auto_provisioning_groups.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['TotalCount'] = self.total_count
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        if self.auto_provisioning_groups is not None:
            result['AutoProvisioningGroups'] = self.auto_provisioning_groups.to_map()
        else:
            result['AutoProvisioningGroups'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.total_count = map.get('TotalCount')
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        if map.get('AutoProvisioningGroups') is not None:
            temp_model = DescribeAutoProvisioningGroupsResponseAutoProvisioningGroups()
            self.auto_provisioning_groups = temp_model.from_map(map['AutoProvisioningGroups'])
        else:
            self.auto_provisioning_groups = None
        return self


class DescribeAutoProvisioningGroupsResponseAutoProvisioningGroupsAutoProvisioningGroupLaunchTemplateConfigsLaunchTemplateConfig(TeaModel):
    def __init__(self, instance_type=None, max_price=None, v_switch_id=None, weighted_capacity=None, priority=None):
        self.instance_type = instance_type
        self.max_price = max_price
        self.v_switch_id = v_switch_id
        self.weighted_capacity = weighted_capacity
        self.priority = priority

    def validate(self):
        self.validate_required(self.instance_type, 'instance_type')
        self.validate_required(self.max_price, 'max_price')
        self.validate_required(self.v_switch_id, 'v_switch_id')
        self.validate_required(self.weighted_capacity, 'weighted_capacity')
        self.validate_required(self.priority, 'priority')

    def to_map(self):
        result = {}
        result['InstanceType'] = self.instance_type
        result['MaxPrice'] = self.max_price
        result['VSwitchId'] = self.v_switch_id
        result['WeightedCapacity'] = self.weighted_capacity
        result['Priority'] = self.priority
        return result

    def from_map(self, map={}):
        self.instance_type = map.get('InstanceType')
        self.max_price = map.get('MaxPrice')
        self.v_switch_id = map.get('VSwitchId')
        self.weighted_capacity = map.get('WeightedCapacity')
        self.priority = map.get('Priority')
        return self


class DescribeAutoProvisioningGroupsResponseAutoProvisioningGroupsAutoProvisioningGroupLaunchTemplateConfigs(TeaModel):
    def __init__(self, launch_template_config=None):
        self.launch_template_config = launch_template_config

    def validate(self):
        self.validate_required(self.launch_template_config, 'launch_template_config')
        if self.launch_template_config:
            for k in self.launch_template_config:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['LaunchTemplateConfig'] = []
        if self.launch_template_config is not None:
            for k in self.launch_template_config:
                result['LaunchTemplateConfig'].append(k.to_map() if k else None)
        else:
            result['LaunchTemplateConfig'] = None
        return result

    def from_map(self, map={}):
        self.launch_template_config = []
        if map.get('LaunchTemplateConfig') is not None:
            for k in map.get('LaunchTemplateConfig'):
                temp_model = DescribeAutoProvisioningGroupsResponseAutoProvisioningGroupsAutoProvisioningGroupLaunchTemplateConfigsLaunchTemplateConfig()
                temp_model = temp_model.from_map(k)
                self.launch_template_config.append(temp_model)
        else:
            self.launch_template_config = None
        return self


class DescribeAutoProvisioningGroupsResponseAutoProvisioningGroupsAutoProvisioningGroupSpotOptions(TeaModel):
    def __init__(self, allocation_strategy=None, instance_interruption_behavior=None,
                 instance_pools_to_use_count=None):
        self.allocation_strategy = allocation_strategy
        self.instance_interruption_behavior = instance_interruption_behavior
        self.instance_pools_to_use_count = instance_pools_to_use_count

    def validate(self):
        self.validate_required(self.allocation_strategy, 'allocation_strategy')
        self.validate_required(self.instance_interruption_behavior, 'instance_interruption_behavior')
        self.validate_required(self.instance_pools_to_use_count, 'instance_pools_to_use_count')

    def to_map(self):
        result = {}
        result['AllocationStrategy'] = self.allocation_strategy
        result['InstanceInterruptionBehavior'] = self.instance_interruption_behavior
        result['InstancePoolsToUseCount'] = self.instance_pools_to_use_count
        return result

    def from_map(self, map={}):
        self.allocation_strategy = map.get('AllocationStrategy')
        self.instance_interruption_behavior = map.get('InstanceInterruptionBehavior')
        self.instance_pools_to_use_count = map.get('InstancePoolsToUseCount')
        return self


class DescribeAutoProvisioningGroupsResponseAutoProvisioningGroupsAutoProvisioningGroupPayAsYouGoOptions(TeaModel):
    def __init__(self, allocation_strategy=None):
        self.allocation_strategy = allocation_strategy

    def validate(self):
        self.validate_required(self.allocation_strategy, 'allocation_strategy')

    def to_map(self):
        result = {}
        result['AllocationStrategy'] = self.allocation_strategy
        return result

    def from_map(self, map={}):
        self.allocation_strategy = map.get('AllocationStrategy')
        return self


class DescribeAutoProvisioningGroupsResponseAutoProvisioningGroupsAutoProvisioningGroupTargetCapacitySpecification(TeaModel):
    def __init__(self, total_target_capacity=None, pay_as_you_go_target_capacity=None, spot_target_capacity=None,
                 default_target_capacity_type=None):
        self.total_target_capacity = total_target_capacity
        self.pay_as_you_go_target_capacity = pay_as_you_go_target_capacity
        self.spot_target_capacity = spot_target_capacity
        self.default_target_capacity_type = default_target_capacity_type

    def validate(self):
        self.validate_required(self.total_target_capacity, 'total_target_capacity')
        self.validate_required(self.pay_as_you_go_target_capacity, 'pay_as_you_go_target_capacity')
        self.validate_required(self.spot_target_capacity, 'spot_target_capacity')
        self.validate_required(self.default_target_capacity_type, 'default_target_capacity_type')

    def to_map(self):
        result = {}
        result['TotalTargetCapacity'] = self.total_target_capacity
        result['PayAsYouGoTargetCapacity'] = self.pay_as_you_go_target_capacity
        result['SpotTargetCapacity'] = self.spot_target_capacity
        result['DefaultTargetCapacityType'] = self.default_target_capacity_type
        return result

    def from_map(self, map={}):
        self.total_target_capacity = map.get('TotalTargetCapacity')
        self.pay_as_you_go_target_capacity = map.get('PayAsYouGoTargetCapacity')
        self.spot_target_capacity = map.get('SpotTargetCapacity')
        self.default_target_capacity_type = map.get('DefaultTargetCapacityType')
        return self


class DescribeAutoProvisioningGroupsResponseAutoProvisioningGroupsAutoProvisioningGroup(TeaModel):
    def __init__(self, auto_provisioning_group_id=None, auto_provisioning_group_name=None,
                 auto_provisioning_group_type=None, status=None, state=None, region_id=None, valid_from=None, valid_until=None,
                 excess_capacity_termination_policy=None, max_spot_price=None, launch_template_id=None, launch_template_version=None,
                 terminate_instances=None, terminate_instances_with_expiration=None, creation_time=None, launch_template_configs=None,
                 spot_options=None, pay_as_you_go_options=None, target_capacity_specification=None):
        self.auto_provisioning_group_id = auto_provisioning_group_id
        self.auto_provisioning_group_name = auto_provisioning_group_name
        self.auto_provisioning_group_type = auto_provisioning_group_type
        self.status = status
        self.state = state
        self.region_id = region_id
        self.valid_from = valid_from
        self.valid_until = valid_until
        self.excess_capacity_termination_policy = excess_capacity_termination_policy
        self.max_spot_price = max_spot_price
        self.launch_template_id = launch_template_id
        self.launch_template_version = launch_template_version
        self.terminate_instances = terminate_instances
        self.terminate_instances_with_expiration = terminate_instances_with_expiration
        self.creation_time = creation_time
        self.launch_template_configs = launch_template_configs
        self.spot_options = spot_options
        self.pay_as_you_go_options = pay_as_you_go_options
        self.target_capacity_specification = target_capacity_specification

    def validate(self):
        self.validate_required(self.auto_provisioning_group_id, 'auto_provisioning_group_id')
        self.validate_required(self.auto_provisioning_group_name, 'auto_provisioning_group_name')
        self.validate_required(self.auto_provisioning_group_type, 'auto_provisioning_group_type')
        self.validate_required(self.status, 'status')
        self.validate_required(self.state, 'state')
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.valid_from, 'valid_from')
        self.validate_required(self.valid_until, 'valid_until')
        self.validate_required(self.excess_capacity_termination_policy, 'excess_capacity_termination_policy')
        self.validate_required(self.max_spot_price, 'max_spot_price')
        self.validate_required(self.launch_template_id, 'launch_template_id')
        self.validate_required(self.launch_template_version, 'launch_template_version')
        self.validate_required(self.terminate_instances, 'terminate_instances')
        self.validate_required(self.terminate_instances_with_expiration, 'terminate_instances_with_expiration')
        self.validate_required(self.creation_time, 'creation_time')
        self.validate_required(self.launch_template_configs, 'launch_template_configs')
        if self.launch_template_configs:
            self.launch_template_configs.validate()
        self.validate_required(self.spot_options, 'spot_options')
        if self.spot_options:
            self.spot_options.validate()
        self.validate_required(self.pay_as_you_go_options, 'pay_as_you_go_options')
        if self.pay_as_you_go_options:
            self.pay_as_you_go_options.validate()
        self.validate_required(self.target_capacity_specification, 'target_capacity_specification')
        if self.target_capacity_specification:
            self.target_capacity_specification.validate()

    def to_map(self):
        result = {}
        result['AutoProvisioningGroupId'] = self.auto_provisioning_group_id
        result['AutoProvisioningGroupName'] = self.auto_provisioning_group_name
        result['AutoProvisioningGroupType'] = self.auto_provisioning_group_type
        result['Status'] = self.status
        result['State'] = self.state
        result['RegionId'] = self.region_id
        result['ValidFrom'] = self.valid_from
        result['ValidUntil'] = self.valid_until
        result['ExcessCapacityTerminationPolicy'] = self.excess_capacity_termination_policy
        result['MaxSpotPrice'] = self.max_spot_price
        result['LaunchTemplateId'] = self.launch_template_id
        result['LaunchTemplateVersion'] = self.launch_template_version
        result['TerminateInstances'] = self.terminate_instances
        result['TerminateInstancesWithExpiration'] = self.terminate_instances_with_expiration
        result['CreationTime'] = self.creation_time
        if self.launch_template_configs is not None:
            result['LaunchTemplateConfigs'] = self.launch_template_configs.to_map()
        else:
            result['LaunchTemplateConfigs'] = None
        if self.spot_options is not None:
            result['SpotOptions'] = self.spot_options.to_map()
        else:
            result['SpotOptions'] = None
        if self.pay_as_you_go_options is not None:
            result['PayAsYouGoOptions'] = self.pay_as_you_go_options.to_map()
        else:
            result['PayAsYouGoOptions'] = None
        if self.target_capacity_specification is not None:
            result['TargetCapacitySpecification'] = self.target_capacity_specification.to_map()
        else:
            result['TargetCapacitySpecification'] = None
        return result

    def from_map(self, map={}):
        self.auto_provisioning_group_id = map.get('AutoProvisioningGroupId')
        self.auto_provisioning_group_name = map.get('AutoProvisioningGroupName')
        self.auto_provisioning_group_type = map.get('AutoProvisioningGroupType')
        self.status = map.get('Status')
        self.state = map.get('State')
        self.region_id = map.get('RegionId')
        self.valid_from = map.get('ValidFrom')
        self.valid_until = map.get('ValidUntil')
        self.excess_capacity_termination_policy = map.get('ExcessCapacityTerminationPolicy')
        self.max_spot_price = map.get('MaxSpotPrice')
        self.launch_template_id = map.get('LaunchTemplateId')
        self.launch_template_version = map.get('LaunchTemplateVersion')
        self.terminate_instances = map.get('TerminateInstances')
        self.terminate_instances_with_expiration = map.get('TerminateInstancesWithExpiration')
        self.creation_time = map.get('CreationTime')
        if map.get('LaunchTemplateConfigs') is not None:
            temp_model = DescribeAutoProvisioningGroupsResponseAutoProvisioningGroupsAutoProvisioningGroupLaunchTemplateConfigs()
            self.launch_template_configs = temp_model.from_map(map['LaunchTemplateConfigs'])
        else:
            self.launch_template_configs = None
        if map.get('SpotOptions') is not None:
            temp_model = DescribeAutoProvisioningGroupsResponseAutoProvisioningGroupsAutoProvisioningGroupSpotOptions()
            self.spot_options = temp_model.from_map(map['SpotOptions'])
        else:
            self.spot_options = None
        if map.get('PayAsYouGoOptions') is not None:
            temp_model = DescribeAutoProvisioningGroupsResponseAutoProvisioningGroupsAutoProvisioningGroupPayAsYouGoOptions()
            self.pay_as_you_go_options = temp_model.from_map(map['PayAsYouGoOptions'])
        else:
            self.pay_as_you_go_options = None
        if map.get('TargetCapacitySpecification') is not None:
            temp_model = DescribeAutoProvisioningGroupsResponseAutoProvisioningGroupsAutoProvisioningGroupTargetCapacitySpecification()
            self.target_capacity_specification = temp_model.from_map(map['TargetCapacitySpecification'])
        else:
            self.target_capacity_specification = None
        return self


class DescribeAutoProvisioningGroupsResponseAutoProvisioningGroups(TeaModel):
    def __init__(self, auto_provisioning_group=None):
        self.auto_provisioning_group = auto_provisioning_group

    def validate(self):
        self.validate_required(self.auto_provisioning_group, 'auto_provisioning_group')
        if self.auto_provisioning_group:
            for k in self.auto_provisioning_group:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['AutoProvisioningGroup'] = []
        if self.auto_provisioning_group is not None:
            for k in self.auto_provisioning_group:
                result['AutoProvisioningGroup'].append(k.to_map() if k else None)
        else:
            result['AutoProvisioningGroup'] = None
        return result

    def from_map(self, map={}):
        self.auto_provisioning_group = []
        if map.get('AutoProvisioningGroup') is not None:
            for k in map.get('AutoProvisioningGroup'):
                temp_model = DescribeAutoProvisioningGroupsResponseAutoProvisioningGroupsAutoProvisioningGroup()
                temp_model = temp_model.from_map(k)
                self.auto_provisioning_group.append(temp_model)
        else:
            self.auto_provisioning_group = None
        return self
class DescribeAutoProvisioningGroupInstancesRequest(TeaModel):
    def __init__(self, region_id=None, page_number=None, page_size=None, auto_provisioning_group_id=None):
        self.region_id = region_id
        self.page_number = page_number
        self.page_size = page_size
        self.auto_provisioning_group_id = auto_provisioning_group_id

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.auto_provisioning_group_id, 'auto_provisioning_group_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        result['AutoProvisioningGroupId'] = self.auto_provisioning_group_id
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        self.auto_provisioning_group_id = map.get('AutoProvisioningGroupId')
        return self


class DescribeAutoProvisioningGroupInstancesResponse(TeaModel):
    def __init__(self, request_id=None, total_count=None, page_number=None, page_size=None, instances=None):
        self.request_id = request_id
        self.total_count = total_count
        self.page_number = page_number
        self.page_size = page_size
        self.instances = instances

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.page_number, 'page_number')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.instances, 'instances')
        if self.instances:
            self.instances.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['TotalCount'] = self.total_count
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        if self.instances is not None:
            result['Instances'] = self.instances.to_map()
        else:
            result['Instances'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.total_count = map.get('TotalCount')
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        if map.get('Instances') is not None:
            temp_model = DescribeAutoProvisioningGroupInstancesResponseInstances()
            self.instances = temp_model.from_map(map['Instances'])
        else:
            self.instances = None
        return self


class DescribeAutoProvisioningGroupInstancesResponseInstancesInstance(TeaModel):
    def __init__(self, instance_id=None, status=None, region_id=None, zone_id=None, cpu=None, memory=None,
                 instance_type=None, is_spot=None, io_optimized=None, network_type=None, os_type=None, creation_time=None):
        self.instance_id = instance_id
        self.status = status
        self.region_id = region_id
        self.zone_id = zone_id
        self.cpu = cpu
        self.memory = memory
        self.instance_type = instance_type
        self.is_spot = is_spot
        self.io_optimized = io_optimized
        self.network_type = network_type
        self.os_type = os_type
        self.creation_time = creation_time

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.status, 'status')
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.zone_id, 'zone_id')
        self.validate_required(self.cpu, 'cpu')
        self.validate_required(self.memory, 'memory')
        self.validate_required(self.instance_type, 'instance_type')
        self.validate_required(self.is_spot, 'is_spot')
        self.validate_required(self.io_optimized, 'io_optimized')
        self.validate_required(self.network_type, 'network_type')
        self.validate_required(self.os_type, 'os_type')
        self.validate_required(self.creation_time, 'creation_time')

    def to_map(self):
        result = {}
        result['InstanceId'] = self.instance_id
        result['Status'] = self.status
        result['RegionId'] = self.region_id
        result['ZoneId'] = self.zone_id
        result['CPU'] = self.cpu
        result['Memory'] = self.memory
        result['InstanceType'] = self.instance_type
        result['IsSpot'] = self.is_spot
        result['IoOptimized'] = self.io_optimized
        result['NetworkType'] = self.network_type
        result['OsType'] = self.os_type
        result['CreationTime'] = self.creation_time
        return result

    def from_map(self, map={}):
        self.instance_id = map.get('InstanceId')
        self.status = map.get('Status')
        self.region_id = map.get('RegionId')
        self.zone_id = map.get('ZoneId')
        self.cpu = map.get('CPU')
        self.memory = map.get('Memory')
        self.instance_type = map.get('InstanceType')
        self.is_spot = map.get('IsSpot')
        self.io_optimized = map.get('IoOptimized')
        self.network_type = map.get('NetworkType')
        self.os_type = map.get('OsType')
        self.creation_time = map.get('CreationTime')
        return self


class DescribeAutoProvisioningGroupInstancesResponseInstances(TeaModel):
    def __init__(self, instance=None):
        self.instance = instance

    def validate(self):
        self.validate_required(self.instance, 'instance')
        if self.instance:
            for k in self.instance:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['Instance'] = []
        if self.instance is not None:
            for k in self.instance:
                result['Instance'].append(k.to_map() if k else None)
        else:
            result['Instance'] = None
        return result

    def from_map(self, map={}):
        self.instance = []
        if map.get('Instance') is not None:
            for k in map.get('Instance'):
                temp_model = DescribeAutoProvisioningGroupInstancesResponseInstancesInstance()
                temp_model = temp_model.from_map(k)
                self.instance.append(temp_model)
        else:
            self.instance = None
        return self
class DeleteAutoProvisioningGroupRequest(TeaModel):
    def __init__(self, region_id=None, auto_provisioning_group_id=None, terminate_instances=None):
        self.region_id = region_id
        self.auto_provisioning_group_id = auto_provisioning_group_id
        self.terminate_instances = terminate_instances

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.auto_provisioning_group_id, 'auto_provisioning_group_id')
        self.validate_required(self.terminate_instances, 'terminate_instances')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['AutoProvisioningGroupId'] = self.auto_provisioning_group_id
        result['TerminateInstances'] = self.terminate_instances
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.auto_provisioning_group_id = map.get('AutoProvisioningGroupId')
        self.terminate_instances = map.get('TerminateInstances')
        return self


class DeleteAutoProvisioningGroupResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class CreateAutoProvisioningGroupRequest(TeaModel):
    def __init__(self, region_id=None, resource_group_id=None, auto_provisioning_group_name=None,
                 auto_provisioning_group_type=None, spot_allocation_strategy=None, spot_instance_interruption_behavior=None,
                 spot_instance_pools_to_use_count=None, pay_as_you_go_allocation_strategy=None, excess_capacity_termination_policy=None,
                 valid_from=None, valid_until=None, terminate_instances_with_expiration=None, terminate_instances=None,
                 max_spot_price=None, total_target_capacity=None, pay_as_you_go_target_capacity=None, spot_target_capacity=None,
                 default_target_capacity_type=None, launch_template_id=None, launch_template_version=None, launch_template_config=None,
                 description=None):
        self.region_id = region_id
        self.resource_group_id = resource_group_id
        self.auto_provisioning_group_name = auto_provisioning_group_name
        self.auto_provisioning_group_type = auto_provisioning_group_type
        self.spot_allocation_strategy = spot_allocation_strategy
        self.spot_instance_interruption_behavior = spot_instance_interruption_behavior
        self.spot_instance_pools_to_use_count = spot_instance_pools_to_use_count
        self.pay_as_you_go_allocation_strategy = pay_as_you_go_allocation_strategy
        self.excess_capacity_termination_policy = excess_capacity_termination_policy
        self.valid_from = valid_from
        self.valid_until = valid_until
        self.terminate_instances_with_expiration = terminate_instances_with_expiration
        self.terminate_instances = terminate_instances
        self.max_spot_price = max_spot_price
        self.total_target_capacity = total_target_capacity
        self.pay_as_you_go_target_capacity = pay_as_you_go_target_capacity
        self.spot_target_capacity = spot_target_capacity
        self.default_target_capacity_type = default_target_capacity_type
        self.launch_template_id = launch_template_id
        self.launch_template_version = launch_template_version
        self.launch_template_config = launch_template_config
        self.description = description

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.total_target_capacity, 'total_target_capacity')
        self.validate_required(self.launch_template_id, 'launch_template_id')
        if self.launch_template_config:
            for k in self.launch_template_config:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['ResourceGroupId'] = self.resource_group_id
        result['AutoProvisioningGroupName'] = self.auto_provisioning_group_name
        result['AutoProvisioningGroupType'] = self.auto_provisioning_group_type
        result['SpotAllocationStrategy'] = self.spot_allocation_strategy
        result['SpotInstanceInterruptionBehavior'] = self.spot_instance_interruption_behavior
        result['SpotInstancePoolsToUseCount'] = self.spot_instance_pools_to_use_count
        result['PayAsYouGoAllocationStrategy'] = self.pay_as_you_go_allocation_strategy
        result['ExcessCapacityTerminationPolicy'] = self.excess_capacity_termination_policy
        result['ValidFrom'] = self.valid_from
        result['ValidUntil'] = self.valid_until
        result['TerminateInstancesWithExpiration'] = self.terminate_instances_with_expiration
        result['TerminateInstances'] = self.terminate_instances
        result['MaxSpotPrice'] = self.max_spot_price
        result['TotalTargetCapacity'] = self.total_target_capacity
        result['PayAsYouGoTargetCapacity'] = self.pay_as_you_go_target_capacity
        result['SpotTargetCapacity'] = self.spot_target_capacity
        result['DefaultTargetCapacityType'] = self.default_target_capacity_type
        result['LaunchTemplateId'] = self.launch_template_id
        result['LaunchTemplateVersion'] = self.launch_template_version
        result['LaunchTemplateConfig'] = []
        if self.launch_template_config is not None:
            for k in self.launch_template_config:
                result['LaunchTemplateConfig'].append(k.to_map() if k else None)
        else:
            result['LaunchTemplateConfig'] = None
        result['Description'] = self.description
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.resource_group_id = map.get('ResourceGroupId')
        self.auto_provisioning_group_name = map.get('AutoProvisioningGroupName')
        self.auto_provisioning_group_type = map.get('AutoProvisioningGroupType')
        self.spot_allocation_strategy = map.get('SpotAllocationStrategy')
        self.spot_instance_interruption_behavior = map.get('SpotInstanceInterruptionBehavior')
        self.spot_instance_pools_to_use_count = map.get('SpotInstancePoolsToUseCount')
        self.pay_as_you_go_allocation_strategy = map.get('PayAsYouGoAllocationStrategy')
        self.excess_capacity_termination_policy = map.get('ExcessCapacityTerminationPolicy')
        self.valid_from = map.get('ValidFrom')
        self.valid_until = map.get('ValidUntil')
        self.terminate_instances_with_expiration = map.get('TerminateInstancesWithExpiration')
        self.terminate_instances = map.get('TerminateInstances')
        self.max_spot_price = map.get('MaxSpotPrice')
        self.total_target_capacity = map.get('TotalTargetCapacity')
        self.pay_as_you_go_target_capacity = map.get('PayAsYouGoTargetCapacity')
        self.spot_target_capacity = map.get('SpotTargetCapacity')
        self.default_target_capacity_type = map.get('DefaultTargetCapacityType')
        self.launch_template_id = map.get('LaunchTemplateId')
        self.launch_template_version = map.get('LaunchTemplateVersion')
        self.launch_template_config = []
        if map.get('LaunchTemplateConfig') is not None:
            for k in map.get('LaunchTemplateConfig'):
                temp_model = CreateAutoProvisioningGroupRequestLaunchTemplateConfig()
                temp_model = temp_model.from_map(k)
                self.launch_template_config.append(temp_model)
        else:
            self.launch_template_config = None
        self.description = map.get('Description')
        return self


class CreateAutoProvisioningGroupRequestLaunchTemplateConfig(TeaModel):
    def __init__(self, instance_type=None, max_price=None, v_switch_id=None, weighted_capacity=None, priority=None):
        self.instance_type = instance_type
        self.max_price = max_price
        self.v_switch_id = v_switch_id
        self.weighted_capacity = weighted_capacity
        self.priority = priority

    def validate(self):
        self.validate_required(self.instance_type, 'instance_type')
        self.validate_required(self.max_price, 'max_price')
        self.validate_required(self.v_switch_id, 'v_switch_id')
        self.validate_required(self.weighted_capacity, 'weighted_capacity')
        self.validate_required(self.priority, 'priority')

    def to_map(self):
        result = {}
        result['InstanceType'] = self.instance_type
        result['MaxPrice'] = self.max_price
        result['VSwitchId'] = self.v_switch_id
        result['WeightedCapacity'] = self.weighted_capacity
        result['Priority'] = self.priority
        return result

    def from_map(self, map={}):
        self.instance_type = map.get('InstanceType')
        self.max_price = map.get('MaxPrice')
        self.v_switch_id = map.get('VSwitchId')
        self.weighted_capacity = map.get('WeightedCapacity')
        self.priority = map.get('Priority')
        return self
class CreateAutoProvisioningGroupResponse(TeaModel):
    def __init__(self, request_id=None, auto_provisioning_group_id=None):
        self.request_id = request_id
        self.auto_provisioning_group_id = auto_provisioning_group_id

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.auto_provisioning_group_id, 'auto_provisioning_group_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['AutoProvisioningGroupId'] = self.auto_provisioning_group_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.auto_provisioning_group_id = map.get('AutoProvisioningGroupId')
        return self


class DescribeAutoProvisioningGroupHistoryRequest(TeaModel):
    def __init__(self, region_id=None, page_number=None, page_size=None, auto_provisioning_group_id=None,
                 start_time=None, end_time=None):
        self.region_id = region_id
        self.page_number = page_number
        self.page_size = page_size
        self.auto_provisioning_group_id = auto_provisioning_group_id
        self.start_time = start_time
        self.end_time = end_time

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.auto_provisioning_group_id, 'auto_provisioning_group_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        result['AutoProvisioningGroupId'] = self.auto_provisioning_group_id
        result['StartTime'] = self.start_time
        result['EndTime'] = self.end_time
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        self.auto_provisioning_group_id = map.get('AutoProvisioningGroupId')
        self.start_time = map.get('StartTime')
        self.end_time = map.get('EndTime')
        return self


class DescribeAutoProvisioningGroupHistoryResponse(TeaModel):
    def __init__(self, request_id=None, total_count=None, page_number=None, page_size=None,
                 auto_provisioning_group_histories=None):
        self.request_id = request_id
        self.total_count = total_count
        self.page_number = page_number
        self.page_size = page_size
        self.auto_provisioning_group_histories = auto_provisioning_group_histories

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.page_number, 'page_number')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.auto_provisioning_group_histories, 'auto_provisioning_group_histories')
        if self.auto_provisioning_group_histories:
            self.auto_provisioning_group_histories.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['TotalCount'] = self.total_count
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        if self.auto_provisioning_group_histories is not None:
            result['AutoProvisioningGroupHistories'] = self.auto_provisioning_group_histories.to_map()
        else:
            result['AutoProvisioningGroupHistories'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.total_count = map.get('TotalCount')
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        if map.get('AutoProvisioningGroupHistories') is not None:
            temp_model = DescribeAutoProvisioningGroupHistoryResponseAutoProvisioningGroupHistories()
            self.auto_provisioning_group_histories = temp_model.from_map(map['AutoProvisioningGroupHistories'])
        else:
            self.auto_provisioning_group_histories = None
        return self


class DescribeAutoProvisioningGroupHistoryResponseAutoProvisioningGroupHistoriesAutoProvisioningGroupHistoryActivityDetailsActivityDetail(TeaModel):
    def __init__(self, detail=None, status=None):
        self.detail = detail
        self.status = status

    def validate(self):
        self.validate_required(self.detail, 'detail')
        self.validate_required(self.status, 'status')

    def to_map(self):
        result = {}
        result['Detail'] = self.detail
        result['Status'] = self.status
        return result

    def from_map(self, map={}):
        self.detail = map.get('Detail')
        self.status = map.get('Status')
        return self


class DescribeAutoProvisioningGroupHistoryResponseAutoProvisioningGroupHistoriesAutoProvisioningGroupHistoryActivityDetails(TeaModel):
    def __init__(self, activity_detail=None):
        self.activity_detail = activity_detail

    def validate(self):
        self.validate_required(self.activity_detail, 'activity_detail')
        if self.activity_detail:
            for k in self.activity_detail:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['ActivityDetail'] = []
        if self.activity_detail is not None:
            for k in self.activity_detail:
                result['ActivityDetail'].append(k.to_map() if k else None)
        else:
            result['ActivityDetail'] = None
        return result

    def from_map(self, map={}):
        self.activity_detail = []
        if map.get('ActivityDetail') is not None:
            for k in map.get('ActivityDetail'):
                temp_model = DescribeAutoProvisioningGroupHistoryResponseAutoProvisioningGroupHistoriesAutoProvisioningGroupHistoryActivityDetailsActivityDetail()
                temp_model = temp_model.from_map(k)
                self.activity_detail.append(temp_model)
        else:
            self.activity_detail = None
        return self


class DescribeAutoProvisioningGroupHistoryResponseAutoProvisioningGroupHistoriesAutoProvisioningGroupHistory(TeaModel):
    def __init__(self, task_id=None, status=None, last_event_time=None, start_time=None, activity_details=None):
        self.task_id = task_id
        self.status = status
        self.last_event_time = last_event_time
        self.start_time = start_time
        self.activity_details = activity_details

    def validate(self):
        self.validate_required(self.task_id, 'task_id')
        self.validate_required(self.status, 'status')
        self.validate_required(self.last_event_time, 'last_event_time')
        self.validate_required(self.start_time, 'start_time')
        self.validate_required(self.activity_details, 'activity_details')
        if self.activity_details:
            self.activity_details.validate()

    def to_map(self):
        result = {}
        result['TaskId'] = self.task_id
        result['Status'] = self.status
        result['LastEventTime'] = self.last_event_time
        result['StartTime'] = self.start_time
        if self.activity_details is not None:
            result['ActivityDetails'] = self.activity_details.to_map()
        else:
            result['ActivityDetails'] = None
        return result

    def from_map(self, map={}):
        self.task_id = map.get('TaskId')
        self.status = map.get('Status')
        self.last_event_time = map.get('LastEventTime')
        self.start_time = map.get('StartTime')
        if map.get('ActivityDetails') is not None:
            temp_model = DescribeAutoProvisioningGroupHistoryResponseAutoProvisioningGroupHistoriesAutoProvisioningGroupHistoryActivityDetails()
            self.activity_details = temp_model.from_map(map['ActivityDetails'])
        else:
            self.activity_details = None
        return self


class DescribeAutoProvisioningGroupHistoryResponseAutoProvisioningGroupHistories(TeaModel):
    def __init__(self, auto_provisioning_group_history=None):
        self.auto_provisioning_group_history = auto_provisioning_group_history

    def validate(self):
        self.validate_required(self.auto_provisioning_group_history, 'auto_provisioning_group_history')
        if self.auto_provisioning_group_history:
            for k in self.auto_provisioning_group_history:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['AutoProvisioningGroupHistory'] = []
        if self.auto_provisioning_group_history is not None:
            for k in self.auto_provisioning_group_history:
                result['AutoProvisioningGroupHistory'].append(k.to_map() if k else None)
        else:
            result['AutoProvisioningGroupHistory'] = None
        return result

    def from_map(self, map={}):
        self.auto_provisioning_group_history = []
        if map.get('AutoProvisioningGroupHistory') is not None:
            for k in map.get('AutoProvisioningGroupHistory'):
                temp_model = DescribeAutoProvisioningGroupHistoryResponseAutoProvisioningGroupHistoriesAutoProvisioningGroupHistory()
                temp_model = temp_model.from_map(k)
                self.auto_provisioning_group_history.append(temp_model)
        else:
            self.auto_provisioning_group_history = None
        return self
class ReportInstancesStatusRequest(TeaModel):
    def __init__(self, region_id=None, instance_id=None, disk_id=None, device=None, reason=None, description=None,
                 start_time=None, end_time=None):
        self.region_id = region_id
        self.instance_id = instance_id
        self.disk_id = disk_id
        self.device = device
        self.reason = reason
        self.description = description
        self.start_time = start_time
        self.end_time = end_time

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.reason, 'reason')
        self.validate_required(self.description, 'description')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['InstanceId'] = []
        if self.instance_id is not None:
            for k in self.instance_id:
                result['InstanceId'].append(k)
        else:
            result['InstanceId'] = None
        result['DiskId'] = []
        if self.disk_id is not None:
            for k in self.disk_id:
                result['DiskId'].append(k)
        else:
            result['DiskId'] = None
        result['Device'] = []
        if self.device is not None:
            for k in self.device:
                result['Device'].append(k)
        else:
            result['Device'] = None
        result['Reason'] = self.reason
        result['Description'] = self.description
        result['StartTime'] = self.start_time
        result['EndTime'] = self.end_time
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.instance_id = []
        if map.get('InstanceId') is not None:
            for k in map.get('InstanceId'):
                self.instance_id.append(k)
        else:
            self.instance_id = None
        self.disk_id = []
        if map.get('DiskId') is not None:
            for k in map.get('DiskId'):
                self.disk_id.append(k)
        else:
            self.disk_id = None
        self.device = []
        if map.get('Device') is not None:
            for k in map.get('Device'):
                self.device.append(k)
        else:
            self.device = None
        self.reason = map.get('Reason')
        self.description = map.get('Description')
        self.start_time = map.get('StartTime')
        self.end_time = map.get('EndTime')
        return self


class ReportInstancesStatusResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class ModifyReservedInstanceAttributeRequest(TeaModel):
    def __init__(self, region_id=None, reserved_instance_id=None, reserved_instance_name=None, description=None):
        self.region_id = region_id
        self.reserved_instance_id = reserved_instance_id
        self.reserved_instance_name = reserved_instance_name
        self.description = description

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.reserved_instance_id, 'reserved_instance_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['ReservedInstanceId'] = self.reserved_instance_id
        result['ReservedInstanceName'] = self.reserved_instance_name
        result['Description'] = self.description
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.reserved_instance_id = map.get('ReservedInstanceId')
        self.reserved_instance_name = map.get('ReservedInstanceName')
        self.description = map.get('Description')
        return self


class ModifyReservedInstanceAttributeResponse(TeaModel):
    def __init__(self, request_id=None, code=None, message=None, http_status_code=None):
        self.request_id = request_id
        self.code = code
        self.message = message
        self.http_status_code = http_status_code

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.code, 'code')
        self.validate_required(self.message, 'message')
        self.validate_required(self.http_status_code, 'http_status_code')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['Code'] = self.code
        result['Message'] = self.message
        result['HttpStatusCode'] = self.http_status_code
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.code = map.get('Code')
        self.message = map.get('Message')
        self.http_status_code = map.get('HttpStatusCode')
        return self


class PurchaseReservedInstancesOfferingRequest(TeaModel):
    def __init__(self, region_id=None, resource_group_id=None, zone_id=None, reserved_instance_name=None,
                 instance_type=None, scope=None, instance_amount=None, offering_type=None, description=None, platform=None,
                 period=None, period_unit=None, client_token=None):
        self.region_id = region_id
        self.resource_group_id = resource_group_id
        self.zone_id = zone_id
        self.reserved_instance_name = reserved_instance_name
        self.instance_type = instance_type
        self.scope = scope
        self.instance_amount = instance_amount
        self.offering_type = offering_type
        self.description = description
        self.platform = platform
        self.period = period
        self.period_unit = period_unit
        self.client_token = client_token

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.instance_type, 'instance_type')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['ResourceGroupId'] = self.resource_group_id
        result['ZoneId'] = self.zone_id
        result['ReservedInstanceName'] = self.reserved_instance_name
        result['InstanceType'] = self.instance_type
        result['Scope'] = self.scope
        result['InstanceAmount'] = self.instance_amount
        result['OfferingType'] = self.offering_type
        result['Description'] = self.description
        result['Platform'] = self.platform
        result['Period'] = self.period
        result['PeriodUnit'] = self.period_unit
        result['ClientToken'] = self.client_token
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.resource_group_id = map.get('ResourceGroupId')
        self.zone_id = map.get('ZoneId')
        self.reserved_instance_name = map.get('ReservedInstanceName')
        self.instance_type = map.get('InstanceType')
        self.scope = map.get('Scope')
        self.instance_amount = map.get('InstanceAmount')
        self.offering_type = map.get('OfferingType')
        self.description = map.get('Description')
        self.platform = map.get('Platform')
        self.period = map.get('Period')
        self.period_unit = map.get('PeriodUnit')
        self.client_token = map.get('ClientToken')
        return self


class PurchaseReservedInstancesOfferingResponse(TeaModel):
    def __init__(self, request_id=None, reserved_instance_id_sets=None):
        self.request_id = request_id
        self.reserved_instance_id_sets = reserved_instance_id_sets

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.reserved_instance_id_sets, 'reserved_instance_id_sets')
        if self.reserved_instance_id_sets:
            self.reserved_instance_id_sets.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        if self.reserved_instance_id_sets is not None:
            result['ReservedInstanceIdSets'] = self.reserved_instance_id_sets.to_map()
        else:
            result['ReservedInstanceIdSets'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        if map.get('ReservedInstanceIdSets') is not None:
            temp_model = PurchaseReservedInstancesOfferingResponseReservedInstanceIdSets()
            self.reserved_instance_id_sets = temp_model.from_map(map['ReservedInstanceIdSets'])
        else:
            self.reserved_instance_id_sets = None
        return self


class PurchaseReservedInstancesOfferingResponseReservedInstanceIdSets(TeaModel):
    def __init__(self, reserved_instance_id=None):
        self.reserved_instance_id = reserved_instance_id

    def validate(self):
        self.validate_required(self.reserved_instance_id, 'reserved_instance_id')

    def to_map(self):
        result = {}
        result['ReservedInstanceId'] = []
        if self.reserved_instance_id is not None:
            for k in self.reserved_instance_id:
                result['ReservedInstanceId'].append(k)
        else:
            result['ReservedInstanceId'] = None
        return result

    def from_map(self, map={}):
        self.reserved_instance_id = []
        if map.get('ReservedInstanceId') is not None:
            for k in map.get('ReservedInstanceId'):
                self.reserved_instance_id.append(k)
        else:
            self.reserved_instance_id = None
        return self
class ModifyReservedInstancesRequest(TeaModel):
    def __init__(self, region_id=None, reserved_instance_id=None, configuration=None):
        self.region_id = region_id
        self.reserved_instance_id = reserved_instance_id
        self.configuration = configuration

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.reserved_instance_id, 'reserved_instance_id')
        if self.configuration:
            for k in self.configuration:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['ReservedInstanceId'] = []
        if self.reserved_instance_id is not None:
            for k in self.reserved_instance_id:
                result['ReservedInstanceId'].append(k)
        else:
            result['ReservedInstanceId'] = None
        result['Configuration'] = []
        if self.configuration is not None:
            for k in self.configuration:
                result['Configuration'].append(k.to_map() if k else None)
        else:
            result['Configuration'] = None
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.reserved_instance_id = []
        if map.get('ReservedInstanceId') is not None:
            for k in map.get('ReservedInstanceId'):
                self.reserved_instance_id.append(k)
        else:
            self.reserved_instance_id = None
        self.configuration = []
        if map.get('Configuration') is not None:
            for k in map.get('Configuration'):
                temp_model = ModifyReservedInstancesRequestConfiguration()
                temp_model = temp_model.from_map(k)
                self.configuration.append(temp_model)
        else:
            self.configuration = None
        return self


class ModifyReservedInstancesRequestConfiguration(TeaModel):
    def __init__(self, zone_id=None, reserved_instance_name=None, instance_type=None, scope=None,
                 instance_amount=None):
        self.zone_id = zone_id
        self.reserved_instance_name = reserved_instance_name
        self.instance_type = instance_type
        self.scope = scope
        self.instance_amount = instance_amount

    def validate(self):
        self.validate_required(self.zone_id, 'zone_id')
        self.validate_required(self.reserved_instance_name, 'reserved_instance_name')
        self.validate_required(self.instance_type, 'instance_type')
        self.validate_required(self.scope, 'scope')
        self.validate_required(self.instance_amount, 'instance_amount')

    def to_map(self):
        result = {}
        result['ZoneId'] = self.zone_id
        result['ReservedInstanceName'] = self.reserved_instance_name
        result['InstanceType'] = self.instance_type
        result['Scope'] = self.scope
        result['InstanceAmount'] = self.instance_amount
        return result

    def from_map(self, map={}):
        self.zone_id = map.get('ZoneId')
        self.reserved_instance_name = map.get('ReservedInstanceName')
        self.instance_type = map.get('InstanceType')
        self.scope = map.get('Scope')
        self.instance_amount = map.get('InstanceAmount')
        return self
class ModifyReservedInstancesResponse(TeaModel):
    def __init__(self, request_id=None, reserved_instance_id_sets=None):
        self.request_id = request_id
        self.reserved_instance_id_sets = reserved_instance_id_sets

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.reserved_instance_id_sets, 'reserved_instance_id_sets')
        if self.reserved_instance_id_sets:
            self.reserved_instance_id_sets.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        if self.reserved_instance_id_sets is not None:
            result['ReservedInstanceIdSets'] = self.reserved_instance_id_sets.to_map()
        else:
            result['ReservedInstanceIdSets'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        if map.get('ReservedInstanceIdSets') is not None:
            temp_model = ModifyReservedInstancesResponseReservedInstanceIdSets()
            self.reserved_instance_id_sets = temp_model.from_map(map['ReservedInstanceIdSets'])
        else:
            self.reserved_instance_id_sets = None
        return self


class ModifyReservedInstancesResponseReservedInstanceIdSets(TeaModel):
    def __init__(self, reserved_instance_id=None):
        self.reserved_instance_id = reserved_instance_id

    def validate(self):
        self.validate_required(self.reserved_instance_id, 'reserved_instance_id')

    def to_map(self):
        result = {}
        result['ReservedInstanceId'] = []
        if self.reserved_instance_id is not None:
            for k in self.reserved_instance_id:
                result['ReservedInstanceId'].append(k)
        else:
            result['ReservedInstanceId'] = None
        return result

    def from_map(self, map={}):
        self.reserved_instance_id = []
        if map.get('ReservedInstanceId') is not None:
            for k in map.get('ReservedInstanceId'):
                self.reserved_instance_id.append(k)
        else:
            self.reserved_instance_id = None
        return self
class DescribeReservedInstancesRequest(TeaModel):
    def __init__(self, region_id=None, page_number=None, page_size=None, zone_id=None, reserved_instance_id=None,
                 reserved_instance_name=None, status=None, lock_reason=None, instance_type=None, instance_type_family=None, scope=None,
                 offering_type=None, allocation_type=None):
        self.region_id = region_id
        self.page_number = page_number
        self.page_size = page_size
        self.zone_id = zone_id
        self.reserved_instance_id = reserved_instance_id
        self.reserved_instance_name = reserved_instance_name
        self.status = status
        self.lock_reason = lock_reason
        self.instance_type = instance_type
        self.instance_type_family = instance_type_family
        self.scope = scope
        self.offering_type = offering_type
        self.allocation_type = allocation_type

    def validate(self):
        self.validate_required(self.region_id, 'region_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        result['ZoneId'] = self.zone_id
        result['ReservedInstanceId'] = []
        if self.reserved_instance_id is not None:
            for k in self.reserved_instance_id:
                result['ReservedInstanceId'].append(k)
        else:
            result['ReservedInstanceId'] = None
        result['ReservedInstanceName'] = self.reserved_instance_name
        result['Status'] = []
        if self.status is not None:
            for k in self.status:
                result['Status'].append(k)
        else:
            result['Status'] = None
        result['LockReason'] = self.lock_reason
        result['InstanceType'] = self.instance_type
        result['InstanceTypeFamily'] = self.instance_type_family
        result['Scope'] = self.scope
        result['OfferingType'] = self.offering_type
        result['AllocationType'] = self.allocation_type
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        self.zone_id = map.get('ZoneId')
        self.reserved_instance_id = []
        if map.get('ReservedInstanceId') is not None:
            for k in map.get('ReservedInstanceId'):
                self.reserved_instance_id.append(k)
        else:
            self.reserved_instance_id = None
        self.reserved_instance_name = map.get('ReservedInstanceName')
        self.status = []
        if map.get('Status') is not None:
            for k in map.get('Status'):
                self.status.append(k)
        else:
            self.status = None
        self.lock_reason = map.get('LockReason')
        self.instance_type = map.get('InstanceType')
        self.instance_type_family = map.get('InstanceTypeFamily')
        self.scope = map.get('Scope')
        self.offering_type = map.get('OfferingType')
        self.allocation_type = map.get('AllocationType')
        return self


class DescribeReservedInstancesResponse(TeaModel):
    def __init__(self, request_id=None, total_count=None, page_number=None, page_size=None, reserved_instances=None):
        self.request_id = request_id
        self.total_count = total_count
        self.page_number = page_number
        self.page_size = page_size
        self.reserved_instances = reserved_instances

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.page_number, 'page_number')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.reserved_instances, 'reserved_instances')
        if self.reserved_instances:
            self.reserved_instances.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['TotalCount'] = self.total_count
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        if self.reserved_instances is not None:
            result['ReservedInstances'] = self.reserved_instances.to_map()
        else:
            result['ReservedInstances'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.total_count = map.get('TotalCount')
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        if map.get('ReservedInstances') is not None:
            temp_model = DescribeReservedInstancesResponseReservedInstances()
            self.reserved_instances = temp_model.from_map(map['ReservedInstances'])
        else:
            self.reserved_instances = None
        return self


class DescribeReservedInstancesResponseReservedInstancesReservedInstanceOperationLocksOperationLock(TeaModel):
    def __init__(self, lock_reason=None):
        self.lock_reason = lock_reason

    def validate(self):
        self.validate_required(self.lock_reason, 'lock_reason')

    def to_map(self):
        result = {}
        result['LockReason'] = self.lock_reason
        return result

    def from_map(self, map={}):
        self.lock_reason = map.get('LockReason')
        return self


class DescribeReservedInstancesResponseReservedInstancesReservedInstanceOperationLocks(TeaModel):
    def __init__(self, operation_lock=None):
        self.operation_lock = operation_lock

    def validate(self):
        self.validate_required(self.operation_lock, 'operation_lock')
        if self.operation_lock:
            for k in self.operation_lock:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['OperationLock'] = []
        if self.operation_lock is not None:
            for k in self.operation_lock:
                result['OperationLock'].append(k.to_map() if k else None)
        else:
            result['OperationLock'] = None
        return result

    def from_map(self, map={}):
        self.operation_lock = []
        if map.get('OperationLock') is not None:
            for k in map.get('OperationLock'):
                temp_model = DescribeReservedInstancesResponseReservedInstancesReservedInstanceOperationLocksOperationLock()
                temp_model = temp_model.from_map(k)
                self.operation_lock.append(temp_model)
        else:
            self.operation_lock = None
        return self


class DescribeReservedInstancesResponseReservedInstancesReservedInstance(TeaModel):
    def __init__(self, reserved_instance_id=None, region_id=None, zone_id=None, reserved_instance_name=None,
                 description=None, instance_type=None, scope=None, offering_type=None, platform=None, instance_amount=None,
                 status=None, creation_time=None, expired_time=None, start_time=None, resource_group_id=None,
                 allocation_status=None, operation_locks=None):
        self.reserved_instance_id = reserved_instance_id
        self.region_id = region_id
        self.zone_id = zone_id
        self.reserved_instance_name = reserved_instance_name
        self.description = description
        self.instance_type = instance_type
        self.scope = scope
        self.offering_type = offering_type
        self.platform = platform
        self.instance_amount = instance_amount
        self.status = status
        self.creation_time = creation_time
        self.expired_time = expired_time
        self.start_time = start_time
        self.resource_group_id = resource_group_id
        self.allocation_status = allocation_status
        self.operation_locks = operation_locks

    def validate(self):
        self.validate_required(self.reserved_instance_id, 'reserved_instance_id')
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.zone_id, 'zone_id')
        self.validate_required(self.reserved_instance_name, 'reserved_instance_name')
        self.validate_required(self.description, 'description')
        self.validate_required(self.instance_type, 'instance_type')
        self.validate_required(self.scope, 'scope')
        self.validate_required(self.offering_type, 'offering_type')
        self.validate_required(self.platform, 'platform')
        self.validate_required(self.instance_amount, 'instance_amount')
        self.validate_required(self.status, 'status')
        self.validate_required(self.creation_time, 'creation_time')
        self.validate_required(self.expired_time, 'expired_time')
        self.validate_required(self.start_time, 'start_time')
        self.validate_required(self.resource_group_id, 'resource_group_id')
        self.validate_required(self.allocation_status, 'allocation_status')
        self.validate_required(self.operation_locks, 'operation_locks')
        if self.operation_locks:
            self.operation_locks.validate()

    def to_map(self):
        result = {}
        result['ReservedInstanceId'] = self.reserved_instance_id
        result['RegionId'] = self.region_id
        result['ZoneId'] = self.zone_id
        result['ReservedInstanceName'] = self.reserved_instance_name
        result['Description'] = self.description
        result['InstanceType'] = self.instance_type
        result['Scope'] = self.scope
        result['OfferingType'] = self.offering_type
        result['Platform'] = self.platform
        result['InstanceAmount'] = self.instance_amount
        result['Status'] = self.status
        result['CreationTime'] = self.creation_time
        result['ExpiredTime'] = self.expired_time
        result['StartTime'] = self.start_time
        result['ResourceGroupId'] = self.resource_group_id
        result['AllocationStatus'] = self.allocation_status
        if self.operation_locks is not None:
            result['OperationLocks'] = self.operation_locks.to_map()
        else:
            result['OperationLocks'] = None
        return result

    def from_map(self, map={}):
        self.reserved_instance_id = map.get('ReservedInstanceId')
        self.region_id = map.get('RegionId')
        self.zone_id = map.get('ZoneId')
        self.reserved_instance_name = map.get('ReservedInstanceName')
        self.description = map.get('Description')
        self.instance_type = map.get('InstanceType')
        self.scope = map.get('Scope')
        self.offering_type = map.get('OfferingType')
        self.platform = map.get('Platform')
        self.instance_amount = map.get('InstanceAmount')
        self.status = map.get('Status')
        self.creation_time = map.get('CreationTime')
        self.expired_time = map.get('ExpiredTime')
        self.start_time = map.get('StartTime')
        self.resource_group_id = map.get('ResourceGroupId')
        self.allocation_status = map.get('AllocationStatus')
        if map.get('OperationLocks') is not None:
            temp_model = DescribeReservedInstancesResponseReservedInstancesReservedInstanceOperationLocks()
            self.operation_locks = temp_model.from_map(map['OperationLocks'])
        else:
            self.operation_locks = None
        return self


class DescribeReservedInstancesResponseReservedInstances(TeaModel):
    def __init__(self, reserved_instance=None):
        self.reserved_instance = reserved_instance

    def validate(self):
        self.validate_required(self.reserved_instance, 'reserved_instance')
        if self.reserved_instance:
            for k in self.reserved_instance:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['ReservedInstance'] = []
        if self.reserved_instance is not None:
            for k in self.reserved_instance:
                result['ReservedInstance'].append(k.to_map() if k else None)
        else:
            result['ReservedInstance'] = None
        return result

    def from_map(self, map={}):
        self.reserved_instance = []
        if map.get('ReservedInstance') is not None:
            for k in map.get('ReservedInstance'):
                temp_model = DescribeReservedInstancesResponseReservedInstancesReservedInstance()
                temp_model = temp_model.from_map(k)
                self.reserved_instance.append(temp_model)
        else:
            self.reserved_instance = None
        return self
class DescribeDemandsRequest(TeaModel):
    def __init__(self, region_id=None, tag=None, page_number=None, page_size=None, dry_run=None, zone_id=None,
                 demand_id=None, instance_type_family=None, instance_type=None, instance_charge_type=None, demand_type=None,
                 demand_status=None):
        self.region_id = region_id
        self.tag = tag
        self.page_number = page_number
        self.page_size = page_size
        self.dry_run = dry_run
        self.zone_id = zone_id
        self.demand_id = demand_id
        self.instance_type_family = instance_type_family
        self.instance_type = instance_type
        self.instance_charge_type = instance_charge_type
        self.demand_type = demand_type
        self.demand_status = demand_status

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        else:
            result['Tag'] = None
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        result['DryRun'] = self.dry_run
        result['ZoneId'] = self.zone_id
        result['DemandId'] = self.demand_id
        result['InstanceTypeFamily'] = self.instance_type_family
        result['InstanceType'] = self.instance_type
        result['InstanceChargeType'] = self.instance_charge_type
        result['DemandType'] = self.demand_type
        result['DemandStatus'] = []
        if self.demand_status is not None:
            for k in self.demand_status:
                result['DemandStatus'].append(k)
        else:
            result['DemandStatus'] = None
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.tag = []
        if map.get('Tag') is not None:
            for k in map.get('Tag'):
                temp_model = DescribeDemandsRequestTag()
                temp_model = temp_model.from_map(k)
                self.tag.append(temp_model)
        else:
            self.tag = None
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        self.dry_run = map.get('DryRun')
        self.zone_id = map.get('ZoneId')
        self.demand_id = map.get('DemandId')
        self.instance_type_family = map.get('InstanceTypeFamily')
        self.instance_type = map.get('InstanceType')
        self.instance_charge_type = map.get('InstanceChargeType')
        self.demand_type = map.get('DemandType')
        self.demand_status = []
        if map.get('DemandStatus') is not None:
            for k in map.get('DemandStatus'):
                self.demand_status.append(k)
        else:
            self.demand_status = None
        return self


class DescribeDemandsRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key
        self.value = value

    def validate(self):
        self.validate_required(self.key, 'key')
        self.validate_required(self.value, 'value')

    def to_map(self):
        result = {}
        result['Key'] = self.key
        result['Value'] = self.value
        return result

    def from_map(self, map={}):
        self.key = map.get('Key')
        self.value = map.get('Value')
        return self
class DescribeDemandsResponse(TeaModel):
    def __init__(self, request_id=None, total_count=None, page_number=None, page_size=None, region_id=None,
                 demands=None):
        self.request_id = request_id
        self.total_count = total_count
        self.page_number = page_number
        self.page_size = page_size
        self.region_id = region_id
        self.demands = demands

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.page_number, 'page_number')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.demands, 'demands')
        if self.demands:
            self.demands.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['TotalCount'] = self.total_count
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        result['RegionId'] = self.region_id
        if self.demands is not None:
            result['Demands'] = self.demands.to_map()
        else:
            result['Demands'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.total_count = map.get('TotalCount')
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        self.region_id = map.get('RegionId')
        if map.get('Demands') is not None:
            temp_model = DescribeDemandsResponseDemands()
            self.demands = temp_model.from_map(map['Demands'])
        else:
            self.demands = None
        return self


class DescribeDemandsResponseDemandsDemandSupplyInfosSupplyInfo(TeaModel):
    def __init__(self, amount=None, supply_status=None, supply_start_time=None, supply_end_time=None):
        self.amount = amount
        self.supply_status = supply_status
        self.supply_start_time = supply_start_time
        self.supply_end_time = supply_end_time

    def validate(self):
        self.validate_required(self.amount, 'amount')
        self.validate_required(self.supply_status, 'supply_status')
        self.validate_required(self.supply_start_time, 'supply_start_time')
        self.validate_required(self.supply_end_time, 'supply_end_time')

    def to_map(self):
        result = {}
        result['Amount'] = self.amount
        result['SupplyStatus'] = self.supply_status
        result['SupplyStartTime'] = self.supply_start_time
        result['SupplyEndTime'] = self.supply_end_time
        return result

    def from_map(self, map={}):
        self.amount = map.get('Amount')
        self.supply_status = map.get('SupplyStatus')
        self.supply_start_time = map.get('SupplyStartTime')
        self.supply_end_time = map.get('SupplyEndTime')
        return self


class DescribeDemandsResponseDemandsDemandSupplyInfos(TeaModel):
    def __init__(self, supply_info=None):
        self.supply_info = supply_info

    def validate(self):
        self.validate_required(self.supply_info, 'supply_info')
        if self.supply_info:
            for k in self.supply_info:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['SupplyInfo'] = []
        if self.supply_info is not None:
            for k in self.supply_info:
                result['SupplyInfo'].append(k.to_map() if k else None)
        else:
            result['SupplyInfo'] = None
        return result

    def from_map(self, map={}):
        self.supply_info = []
        if map.get('SupplyInfo') is not None:
            for k in map.get('SupplyInfo'):
                temp_model = DescribeDemandsResponseDemandsDemandSupplyInfosSupplyInfo()
                temp_model = temp_model.from_map(k)
                self.supply_info.append(temp_model)
        else:
            self.supply_info = None
        return self


class DescribeDemandsResponseDemandsDemand(TeaModel):
    def __init__(self, zone_id=None, demand_time=None, instance_type_family=None, demand_id=None, demand_name=None,
                 comment=None, demand_description=None, instance_type=None, instance_charge_type=None, period=None,
                 period_unit=None, start_time=None, end_time=None, demand_status=None, total_amount=None, available_amount=None,
                 used_amount=None, delivering_amount=None, supply_infos=None):
        self.zone_id = zone_id
        self.demand_time = demand_time
        self.instance_type_family = instance_type_family
        self.demand_id = demand_id
        self.demand_name = demand_name
        self.comment = comment
        self.demand_description = demand_description
        self.instance_type = instance_type
        self.instance_charge_type = instance_charge_type
        self.period = period
        self.period_unit = period_unit
        self.start_time = start_time
        self.end_time = end_time
        self.demand_status = demand_status
        self.total_amount = total_amount
        self.available_amount = available_amount
        self.used_amount = used_amount
        self.delivering_amount = delivering_amount
        self.supply_infos = supply_infos

    def validate(self):
        self.validate_required(self.zone_id, 'zone_id')
        self.validate_required(self.demand_time, 'demand_time')
        self.validate_required(self.instance_type_family, 'instance_type_family')
        self.validate_required(self.demand_id, 'demand_id')
        self.validate_required(self.demand_name, 'demand_name')
        self.validate_required(self.comment, 'comment')
        self.validate_required(self.demand_description, 'demand_description')
        self.validate_required(self.instance_type, 'instance_type')
        self.validate_required(self.instance_charge_type, 'instance_charge_type')
        self.validate_required(self.period, 'period')
        self.validate_required(self.period_unit, 'period_unit')
        self.validate_required(self.start_time, 'start_time')
        self.validate_required(self.end_time, 'end_time')
        self.validate_required(self.demand_status, 'demand_status')
        self.validate_required(self.total_amount, 'total_amount')
        self.validate_required(self.available_amount, 'available_amount')
        self.validate_required(self.used_amount, 'used_amount')
        self.validate_required(self.delivering_amount, 'delivering_amount')
        self.validate_required(self.supply_infos, 'supply_infos')
        if self.supply_infos:
            self.supply_infos.validate()

    def to_map(self):
        result = {}
        result['ZoneId'] = self.zone_id
        result['DemandTime'] = self.demand_time
        result['InstanceTypeFamily'] = self.instance_type_family
        result['DemandId'] = self.demand_id
        result['DemandName'] = self.demand_name
        result['Comment'] = self.comment
        result['DemandDescription'] = self.demand_description
        result['InstanceType'] = self.instance_type
        result['InstanceChargeType'] = self.instance_charge_type
        result['Period'] = self.period
        result['PeriodUnit'] = self.period_unit
        result['StartTime'] = self.start_time
        result['EndTime'] = self.end_time
        result['DemandStatus'] = self.demand_status
        result['TotalAmount'] = self.total_amount
        result['AvailableAmount'] = self.available_amount
        result['UsedAmount'] = self.used_amount
        result['DeliveringAmount'] = self.delivering_amount
        if self.supply_infos is not None:
            result['SupplyInfos'] = self.supply_infos.to_map()
        else:
            result['SupplyInfos'] = None
        return result

    def from_map(self, map={}):
        self.zone_id = map.get('ZoneId')
        self.demand_time = map.get('DemandTime')
        self.instance_type_family = map.get('InstanceTypeFamily')
        self.demand_id = map.get('DemandId')
        self.demand_name = map.get('DemandName')
        self.comment = map.get('Comment')
        self.demand_description = map.get('DemandDescription')
        self.instance_type = map.get('InstanceType')
        self.instance_charge_type = map.get('InstanceChargeType')
        self.period = map.get('Period')
        self.period_unit = map.get('PeriodUnit')
        self.start_time = map.get('StartTime')
        self.end_time = map.get('EndTime')
        self.demand_status = map.get('DemandStatus')
        self.total_amount = map.get('TotalAmount')
        self.available_amount = map.get('AvailableAmount')
        self.used_amount = map.get('UsedAmount')
        self.delivering_amount = map.get('DeliveringAmount')
        if map.get('SupplyInfos') is not None:
            temp_model = DescribeDemandsResponseDemandsDemandSupplyInfos()
            self.supply_infos = temp_model.from_map(map['SupplyInfos'])
        else:
            self.supply_infos = None
        return self


class DescribeDemandsResponseDemands(TeaModel):
    def __init__(self, demand=None):
        self.demand = demand

    def validate(self):
        self.validate_required(self.demand, 'demand')
        if self.demand:
            for k in self.demand:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['Demand'] = []
        if self.demand is not None:
            for k in self.demand:
                result['Demand'].append(k.to_map() if k else None)
        else:
            result['Demand'] = None
        return result

    def from_map(self, map={}):
        self.demand = []
        if map.get('Demand') is not None:
            for k in map.get('Demand'):
                temp_model = DescribeDemandsResponseDemandsDemand()
                temp_model = temp_model.from_map(k)
                self.demand.append(temp_model)
        else:
            self.demand = None
        return self
class ImportSnapshotRequest(TeaModel):
    def __init__(self, snapshot_name=None, region_id=None, oss_bucket=None, oss_object=None, role_name=None):
        self.snapshot_name = snapshot_name
        self.region_id = region_id
        self.oss_bucket = oss_bucket
        self.oss_object = oss_object
        self.role_name = role_name

    def validate(self):
        self.validate_required(self.snapshot_name, 'snapshot_name')
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.oss_bucket, 'oss_bucket')
        self.validate_required(self.oss_object, 'oss_object')

    def to_map(self):
        result = {}
        result['SnapshotName'] = self.snapshot_name
        result['RegionId'] = self.region_id
        result['OssBucket'] = self.oss_bucket
        result['OssObject'] = self.oss_object
        result['RoleName'] = self.role_name
        return result

    def from_map(self, map={}):
        self.snapshot_name = map.get('SnapshotName')
        self.region_id = map.get('RegionId')
        self.oss_bucket = map.get('OssBucket')
        self.oss_object = map.get('OssObject')
        self.role_name = map.get('RoleName')
        return self


class ImportSnapshotResponse(TeaModel):
    def __init__(self, request_id=None, task_id=None, snapshot_id=None):
        self.request_id = request_id
        self.task_id = task_id
        self.snapshot_id = snapshot_id

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.task_id, 'task_id')
        self.validate_required(self.snapshot_id, 'snapshot_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['TaskId'] = self.task_id
        result['SnapshotId'] = self.snapshot_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.task_id = map.get('TaskId')
        self.snapshot_id = map.get('SnapshotId')
        return self


class ExportSnapshotRequest(TeaModel):
    def __init__(self, snapshot_id=None, region_id=None, oss_bucket=None, role_name=None):
        self.snapshot_id = snapshot_id
        self.region_id = region_id
        self.oss_bucket = oss_bucket
        self.role_name = role_name

    def validate(self):
        self.validate_required(self.snapshot_id, 'snapshot_id')
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.oss_bucket, 'oss_bucket')

    def to_map(self):
        result = {}
        result['SnapshotId'] = self.snapshot_id
        result['RegionId'] = self.region_id
        result['OssBucket'] = self.oss_bucket
        result['RoleName'] = self.role_name
        return result

    def from_map(self, map={}):
        self.snapshot_id = map.get('SnapshotId')
        self.region_id = map.get('RegionId')
        self.oss_bucket = map.get('OssBucket')
        self.role_name = map.get('RoleName')
        return self


class ExportSnapshotResponse(TeaModel):
    def __init__(self, request_id=None, task_id=None):
        self.request_id = request_id
        self.task_id = task_id

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.task_id, 'task_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['TaskId'] = self.task_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.task_id = map.get('TaskId')
        return self


class UntagResourcesRequest(TeaModel):
    def __init__(self, region_id=None, resource_id=None, resource_type=None, tag_key=None, all=None):
        self.region_id = region_id
        self.resource_id = resource_id
        self.resource_type = resource_type
        self.tag_key = tag_key
        self.all = all

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.resource_id, 'resource_id')
        self.validate_required(self.resource_type, 'resource_type')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['ResourceId'] = []
        if self.resource_id is not None:
            for k in self.resource_id:
                result['ResourceId'].append(k)
        else:
            result['ResourceId'] = None
        result['ResourceType'] = self.resource_type
        result['TagKey'] = []
        if self.tag_key is not None:
            for k in self.tag_key:
                result['TagKey'].append(k)
        else:
            result['TagKey'] = None
        result['All'] = self.all
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.resource_id = []
        if map.get('ResourceId') is not None:
            for k in map.get('ResourceId'):
                self.resource_id.append(k)
        else:
            self.resource_id = None
        self.resource_type = map.get('ResourceType')
        self.tag_key = []
        if map.get('TagKey') is not None:
            for k in map.get('TagKey'):
                self.tag_key.append(k)
        else:
            self.tag_key = None
        self.all = map.get('All')
        return self


class UntagResourcesResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class TagResourcesRequest(TeaModel):
    def __init__(self, region_id=None, resource_type=None, resource_id=None, tag=None):
        self.region_id = region_id
        self.resource_type = resource_type
        self.resource_id = resource_id
        self.tag = tag

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.resource_type, 'resource_type')
        self.validate_required(self.resource_id, 'resource_id')
        self.validate_required(self.tag, 'tag')
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['ResourceType'] = self.resource_type
        result['ResourceId'] = []
        if self.resource_id is not None:
            for k in self.resource_id:
                result['ResourceId'].append(k)
        else:
            result['ResourceId'] = None
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        else:
            result['Tag'] = None
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.resource_type = map.get('ResourceType')
        self.resource_id = []
        if map.get('ResourceId') is not None:
            for k in map.get('ResourceId'):
                self.resource_id.append(k)
        else:
            self.resource_id = None
        self.tag = []
        if map.get('Tag') is not None:
            for k in map.get('Tag'):
                temp_model = TagResourcesRequestTag()
                temp_model = temp_model.from_map(k)
                self.tag.append(temp_model)
        else:
            self.tag = None
        return self


class TagResourcesRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key
        self.value = value

    def validate(self):
        self.validate_required(self.key, 'key')
        self.validate_required(self.value, 'value')

    def to_map(self):
        result = {}
        result['Key'] = self.key
        result['Value'] = self.value
        return result

    def from_map(self, map={}):
        self.key = map.get('Key')
        self.value = map.get('Value')
        return self
class TagResourcesResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class ListTagResourcesRequest(TeaModel):
    def __init__(self, region_id=None, resource_id=None, tag=None, tag_filter=None, next_token=None,
                 resource_type=None):
        self.region_id = region_id
        self.resource_id = resource_id
        self.tag = tag
        self.tag_filter = tag_filter
        self.next_token = next_token
        self.resource_type = resource_type

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()
        if self.tag_filter:
            for k in self.tag_filter:
                if k:
                    k.validate()
        self.validate_required(self.resource_type, 'resource_type')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['ResourceId'] = []
        if self.resource_id is not None:
            for k in self.resource_id:
                result['ResourceId'].append(k)
        else:
            result['ResourceId'] = None
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        else:
            result['Tag'] = None
        result['TagFilter'] = []
        if self.tag_filter is not None:
            for k in self.tag_filter:
                result['TagFilter'].append(k.to_map() if k else None)
        else:
            result['TagFilter'] = None
        result['NextToken'] = self.next_token
        result['ResourceType'] = self.resource_type
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.resource_id = []
        if map.get('ResourceId') is not None:
            for k in map.get('ResourceId'):
                self.resource_id.append(k)
        else:
            self.resource_id = None
        self.tag = []
        if map.get('Tag') is not None:
            for k in map.get('Tag'):
                temp_model = ListTagResourcesRequestTag()
                temp_model = temp_model.from_map(k)
                self.tag.append(temp_model)
        else:
            self.tag = None
        self.tag_filter = []
        if map.get('TagFilter') is not None:
            for k in map.get('TagFilter'):
                temp_model = ListTagResourcesRequestTagFilter()
                temp_model = temp_model.from_map(k)
                self.tag_filter.append(temp_model)
        else:
            self.tag_filter = None
        self.next_token = map.get('NextToken')
        self.resource_type = map.get('ResourceType')
        return self


class ListTagResourcesRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key
        self.value = value

    def validate(self):
        self.validate_required(self.key, 'key')
        self.validate_required(self.value, 'value')

    def to_map(self):
        result = {}
        result['Key'] = self.key
        result['Value'] = self.value
        return result

    def from_map(self, map={}):
        self.key = map.get('Key')
        self.value = map.get('Value')
        return self


class ListTagResourcesRequestTagFilter(TeaModel):
    def __init__(self, tag_key=None, tag_values=None):
        self.tag_key = tag_key
        self.tag_values = tag_values

    def validate(self):
        self.validate_required(self.tag_key, 'tag_key')

    def to_map(self):
        result = {}
        result['TagKey'] = self.tag_key
        result['TagValues'] = []
        if self.tag_values is not None:
            for k in self.tag_values:
                result['TagValues'].append(k)
        else:
            result['TagValues'] = None
        return result

    def from_map(self, map={}):
        self.tag_key = map.get('TagKey')
        self.tag_values = []
        if map.get('TagValues') is not None:
            for k in map.get('TagValues'):
                self.tag_values.append(k)
        else:
            self.tag_values = None
        return self
class ListTagResourcesResponse(TeaModel):
    def __init__(self, request_id=None, next_token=None, tag_resources=None):
        self.request_id = request_id
        self.next_token = next_token
        self.tag_resources = tag_resources

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.next_token, 'next_token')
        self.validate_required(self.tag_resources, 'tag_resources')
        if self.tag_resources:
            self.tag_resources.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['NextToken'] = self.next_token
        if self.tag_resources is not None:
            result['TagResources'] = self.tag_resources.to_map()
        else:
            result['TagResources'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.next_token = map.get('NextToken')
        if map.get('TagResources') is not None:
            temp_model = ListTagResourcesResponseTagResources()
            self.tag_resources = temp_model.from_map(map['TagResources'])
        else:
            self.tag_resources = None
        return self


class ListTagResourcesResponseTagResourcesTagResource(TeaModel):
    def __init__(self, resource_type=None, resource_id=None, tag_key=None, tag_value=None):
        self.resource_type = resource_type
        self.resource_id = resource_id
        self.tag_key = tag_key
        self.tag_value = tag_value

    def validate(self):
        self.validate_required(self.resource_type, 'resource_type')
        self.validate_required(self.resource_id, 'resource_id')
        self.validate_required(self.tag_key, 'tag_key')
        self.validate_required(self.tag_value, 'tag_value')

    def to_map(self):
        result = {}
        result['ResourceType'] = self.resource_type
        result['ResourceId'] = self.resource_id
        result['TagKey'] = self.tag_key
        result['TagValue'] = self.tag_value
        return result

    def from_map(self, map={}):
        self.resource_type = map.get('ResourceType')
        self.resource_id = map.get('ResourceId')
        self.tag_key = map.get('TagKey')
        self.tag_value = map.get('TagValue')
        return self


class ListTagResourcesResponseTagResources(TeaModel):
    def __init__(self, tag_resource=None):
        self.tag_resource = tag_resource

    def validate(self):
        self.validate_required(self.tag_resource, 'tag_resource')
        if self.tag_resource:
            for k in self.tag_resource:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['TagResource'] = []
        if self.tag_resource is not None:
            for k in self.tag_resource:
                result['TagResource'].append(k.to_map() if k else None)
        else:
            result['TagResource'] = None
        return result

    def from_map(self, map={}):
        self.tag_resource = []
        if map.get('TagResource') is not None:
            for k in map.get('TagResource'):
                temp_model = ListTagResourcesResponseTagResourcesTagResource()
                temp_model = temp_model.from_map(k)
                self.tag_resource.append(temp_model)
        else:
            self.tag_resource = None
        return self
class AcceptInquiredSystemEventRequest(TeaModel):
    def __init__(self, region_id=None, event_id=None):
        self.region_id = region_id
        self.event_id = event_id

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.event_id, 'event_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['EventId'] = self.event_id
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.event_id = map.get('EventId')
        return self


class AcceptInquiredSystemEventResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class RedeployInstanceRequest(TeaModel):
    def __init__(self, instance_id=None, force_stop=None):
        self.instance_id = instance_id
        self.force_stop = force_stop

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = {}
        result['InstanceId'] = self.instance_id
        result['ForceStop'] = self.force_stop
        return result

    def from_map(self, map={}):
        self.instance_id = map.get('InstanceId')
        self.force_stop = map.get('ForceStop')
        return self


class RedeployInstanceResponse(TeaModel):
    def __init__(self, request_id=None, task_id=None):
        self.request_id = request_id
        self.task_id = task_id

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.task_id, 'task_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['TaskId'] = self.task_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.task_id = map.get('TaskId')
        return self


class UnassignIpv6AddressesRequest(TeaModel):
    def __init__(self, region_id=None, network_interface_id=None, ipv_6address=None):
        self.region_id = region_id
        self.network_interface_id = network_interface_id
        self.ipv_6address = ipv_6address

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.network_interface_id, 'network_interface_id')
        self.validate_required(self.ipv_6address, 'ipv_6address')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['NetworkInterfaceId'] = self.network_interface_id
        result['Ipv6Address'] = []
        if self.ipv_6address is not None:
            for k in self.ipv_6address:
                result['Ipv6Address'].append(k)
        else:
            result['Ipv6Address'] = None
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.network_interface_id = map.get('NetworkInterfaceId')
        self.ipv_6address = []
        if map.get('Ipv6Address') is not None:
            for k in map.get('Ipv6Address'):
                self.ipv_6address.append(k)
        else:
            self.ipv_6address = None
        return self


class UnassignIpv6AddressesResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class AssignIpv6AddressesRequest(TeaModel):
    def __init__(self, region_id=None, network_interface_id=None, ipv_6address=None, ipv_6address_count=None):
        self.region_id = region_id
        self.network_interface_id = network_interface_id
        self.ipv_6address = ipv_6address
        self.ipv_6address_count = ipv_6address_count

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.network_interface_id, 'network_interface_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['NetworkInterfaceId'] = self.network_interface_id
        result['Ipv6Address'] = []
        if self.ipv_6address is not None:
            for k in self.ipv_6address:
                result['Ipv6Address'].append(k)
        else:
            result['Ipv6Address'] = None
        result['Ipv6AddressCount'] = self.ipv_6address_count
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.network_interface_id = map.get('NetworkInterfaceId')
        self.ipv_6address = []
        if map.get('Ipv6Address') is not None:
            for k in map.get('Ipv6Address'):
                self.ipv_6address.append(k)
        else:
            self.ipv_6address = None
        self.ipv_6address_count = map.get('Ipv6AddressCount')
        return self


class AssignIpv6AddressesResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class DescribeInstanceTopologyRequest(TeaModel):
    def __init__(self, region_id=None, instance_ids=None):
        self.region_id = region_id
        self.instance_ids = instance_ids

    def validate(self):
        self.validate_required(self.region_id, 'region_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['InstanceIds'] = self.instance_ids
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.instance_ids = map.get('InstanceIds')
        return self


class DescribeInstanceTopologyResponse(TeaModel):
    def __init__(self, request_id=None, topologys=None):
        self.request_id = request_id
        self.topologys = topologys

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.topologys, 'topologys')
        if self.topologys:
            self.topologys.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        if self.topologys is not None:
            result['Topologys'] = self.topologys.to_map()
        else:
            result['Topologys'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        if map.get('Topologys') is not None:
            temp_model = DescribeInstanceTopologyResponseTopologys()
            self.topologys = temp_model.from_map(map['Topologys'])
        else:
            self.topologys = None
        return self


class DescribeInstanceTopologyResponseTopologysTopology(TeaModel):
    def __init__(self, instance_id=None, host_id=None):
        self.instance_id = instance_id
        self.host_id = host_id

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.host_id, 'host_id')

    def to_map(self):
        result = {}
        result['InstanceId'] = self.instance_id
        result['HostId'] = self.host_id
        return result

    def from_map(self, map={}):
        self.instance_id = map.get('InstanceId')
        self.host_id = map.get('HostId')
        return self


class DescribeInstanceTopologyResponseTopologys(TeaModel):
    def __init__(self, topology=None):
        self.topology = topology

    def validate(self):
        self.validate_required(self.topology, 'topology')
        if self.topology:
            for k in self.topology:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['Topology'] = []
        if self.topology is not None:
            for k in self.topology:
                result['Topology'].append(k.to_map() if k else None)
        else:
            result['Topology'] = None
        return result

    def from_map(self, map={}):
        self.topology = []
        if map.get('Topology') is not None:
            for k in map.get('Topology'):
                temp_model = DescribeInstanceTopologyResponseTopologysTopology()
                temp_model = temp_model.from_map(k)
                self.topology.append(temp_model)
        else:
            self.topology = None
        return self
class RenewDedicatedHostsRequest(TeaModel):
    def __init__(self, dedicated_host_ids=None, region_id=None, period=None, period_unit=None, client_token=None):
        self.dedicated_host_ids = dedicated_host_ids
        self.region_id = region_id
        self.period = period
        self.period_unit = period_unit
        self.client_token = client_token

    def validate(self):
        self.validate_required(self.dedicated_host_ids, 'dedicated_host_ids')
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.period, 'period')

    def to_map(self):
        result = {}
        result['DedicatedHostIds'] = self.dedicated_host_ids
        result['RegionId'] = self.region_id
        result['Period'] = self.period
        result['PeriodUnit'] = self.period_unit
        result['ClientToken'] = self.client_token
        return result

    def from_map(self, map={}):
        self.dedicated_host_ids = map.get('DedicatedHostIds')
        self.region_id = map.get('RegionId')
        self.period = map.get('Period')
        self.period_unit = map.get('PeriodUnit')
        self.client_token = map.get('ClientToken')
        return self


class RenewDedicatedHostsResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class ReleaseDedicatedHostRequest(TeaModel):
    def __init__(self, region_id=None, dedicated_host_id=None):
        self.region_id = region_id
        self.dedicated_host_id = dedicated_host_id

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.dedicated_host_id, 'dedicated_host_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['DedicatedHostId'] = self.dedicated_host_id
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.dedicated_host_id = map.get('DedicatedHostId')
        return self


class ReleaseDedicatedHostResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class ModifyInstanceDeploymentRequest(TeaModel):
    def __init__(self, region_id=None, instance_id=None, dedicated_host_id=None, deployment_set_id=None,
                 deployment_set_group_no=None, force=None, affinity=None, tenancy=None, migration_type=None, instance_type=None):
        self.region_id = region_id
        self.instance_id = instance_id
        self.dedicated_host_id = dedicated_host_id
        self.deployment_set_id = deployment_set_id
        self.deployment_set_group_no = deployment_set_group_no
        self.force = force
        self.affinity = affinity
        self.tenancy = tenancy
        self.migration_type = migration_type
        self.instance_type = instance_type

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['InstanceId'] = self.instance_id
        result['DedicatedHostId'] = self.dedicated_host_id
        result['DeploymentSetId'] = self.deployment_set_id
        result['DeploymentSetGroupNo'] = self.deployment_set_group_no
        result['Force'] = self.force
        result['Affinity'] = self.affinity
        result['Tenancy'] = self.tenancy
        result['MigrationType'] = self.migration_type
        result['InstanceType'] = self.instance_type
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.instance_id = map.get('InstanceId')
        self.dedicated_host_id = map.get('DedicatedHostId')
        self.deployment_set_id = map.get('DeploymentSetId')
        self.deployment_set_group_no = map.get('DeploymentSetGroupNo')
        self.force = map.get('Force')
        self.affinity = map.get('Affinity')
        self.tenancy = map.get('Tenancy')
        self.migration_type = map.get('MigrationType')
        self.instance_type = map.get('InstanceType')
        return self


class ModifyInstanceDeploymentResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class ModifyDedicatedHostAutoRenewAttributeRequest(TeaModel):
    def __init__(self, dedicated_host_ids=None, region_id=None, duration=None, period_unit=None, auto_renew=None,
                 renewal_status=None):
        self.dedicated_host_ids = dedicated_host_ids
        self.region_id = region_id
        self.duration = duration
        self.period_unit = period_unit
        self.auto_renew = auto_renew
        self.renewal_status = renewal_status

    def validate(self):
        self.validate_required(self.dedicated_host_ids, 'dedicated_host_ids')
        self.validate_required(self.region_id, 'region_id')

    def to_map(self):
        result = {}
        result['DedicatedHostIds'] = self.dedicated_host_ids
        result['RegionId'] = self.region_id
        result['Duration'] = self.duration
        result['PeriodUnit'] = self.period_unit
        result['AutoRenew'] = self.auto_renew
        result['RenewalStatus'] = self.renewal_status
        return result

    def from_map(self, map={}):
        self.dedicated_host_ids = map.get('DedicatedHostIds')
        self.region_id = map.get('RegionId')
        self.duration = map.get('Duration')
        self.period_unit = map.get('PeriodUnit')
        self.auto_renew = map.get('AutoRenew')
        self.renewal_status = map.get('RenewalStatus')
        return self


class ModifyDedicatedHostAutoRenewAttributeResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class ModifyDedicatedHostAutoReleaseTimeRequest(TeaModel):
    def __init__(self, region_id=None, dedicated_host_id=None, auto_release_time=None):
        self.region_id = region_id
        self.dedicated_host_id = dedicated_host_id
        self.auto_release_time = auto_release_time

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.dedicated_host_id, 'dedicated_host_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['DedicatedHostId'] = self.dedicated_host_id
        result['AutoReleaseTime'] = self.auto_release_time
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.dedicated_host_id = map.get('DedicatedHostId')
        self.auto_release_time = map.get('AutoReleaseTime')
        return self


class ModifyDedicatedHostAutoReleaseTimeResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class ModifyDedicatedHostAttributeRequest(TeaModel):
    def __init__(self, region_id=None, dedicated_host_id=None, dedicated_host_name=None, description=None,
                 action_on_maintenance=None, network_attributes=None, auto_placement=None):
        self.region_id = region_id
        self.dedicated_host_id = dedicated_host_id
        self.dedicated_host_name = dedicated_host_name
        self.description = description
        self.action_on_maintenance = action_on_maintenance
        self.network_attributes = network_attributes
        self.auto_placement = auto_placement

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.dedicated_host_id, 'dedicated_host_id')
        if self.network_attributes:
            self.network_attributes.validate()

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['DedicatedHostId'] = self.dedicated_host_id
        result['DedicatedHostName'] = self.dedicated_host_name
        result['Description'] = self.description
        result['ActionOnMaintenance'] = self.action_on_maintenance
        if self.network_attributes is not None:
            result['NetworkAttributes'] = self.network_attributes.to_map()
        else:
            result['NetworkAttributes'] = None
        result['AutoPlacement'] = self.auto_placement
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.dedicated_host_id = map.get('DedicatedHostId')
        self.dedicated_host_name = map.get('DedicatedHostName')
        self.description = map.get('Description')
        self.action_on_maintenance = map.get('ActionOnMaintenance')
        if map.get('NetworkAttributes') is not None:
            temp_model = ModifyDedicatedHostAttributeRequestNetworkAttributes()
            self.network_attributes = temp_model.from_map(map['NetworkAttributes'])
        else:
            self.network_attributes = None
        self.auto_placement = map.get('AutoPlacement')
        return self


class ModifyDedicatedHostAttributeRequestNetworkAttributes(TeaModel):
    def __init__(self, slb_udp_timeout=None, udp_timeout=None):
        self.slb_udp_timeout = slb_udp_timeout
        self.udp_timeout = udp_timeout

    def validate(self):
        pass

    def to_map(self):
        result = {}
        result['SlbUdpTimeout'] = self.slb_udp_timeout
        result['UdpTimeout'] = self.udp_timeout
        return result

    def from_map(self, map={}):
        self.slb_udp_timeout = map.get('SlbUdpTimeout')
        self.udp_timeout = map.get('UdpTimeout')
        return self
class ModifyDedicatedHostAttributeResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class DescribeDedicatedHostsRequest(TeaModel):
    def __init__(self, region_id=None, zone_id=None, dedicated_host_ids=None, dedicated_host_name=None, status=None,
                 dedicated_host_type=None, lock_reason=None, page_number=None, page_size=None, tag=None, resource_group_id=None):
        self.region_id = region_id
        self.zone_id = zone_id
        self.dedicated_host_ids = dedicated_host_ids
        self.dedicated_host_name = dedicated_host_name
        self.status = status
        self.dedicated_host_type = dedicated_host_type
        self.lock_reason = lock_reason
        self.page_number = page_number
        self.page_size = page_size
        self.tag = tag
        self.resource_group_id = resource_group_id

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['ZoneId'] = self.zone_id
        result['DedicatedHostIds'] = self.dedicated_host_ids
        result['DedicatedHostName'] = self.dedicated_host_name
        result['Status'] = self.status
        result['DedicatedHostType'] = self.dedicated_host_type
        result['LockReason'] = self.lock_reason
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        else:
            result['Tag'] = None
        result['ResourceGroupId'] = self.resource_group_id
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.zone_id = map.get('ZoneId')
        self.dedicated_host_ids = map.get('DedicatedHostIds')
        self.dedicated_host_name = map.get('DedicatedHostName')
        self.status = map.get('Status')
        self.dedicated_host_type = map.get('DedicatedHostType')
        self.lock_reason = map.get('LockReason')
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        self.tag = []
        if map.get('Tag') is not None:
            for k in map.get('Tag'):
                temp_model = DescribeDedicatedHostsRequestTag()
                temp_model = temp_model.from_map(k)
                self.tag.append(temp_model)
        else:
            self.tag = None
        self.resource_group_id = map.get('ResourceGroupId')
        return self


class DescribeDedicatedHostsRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key
        self.value = value

    def validate(self):
        self.validate_required(self.key, 'key')
        self.validate_required(self.value, 'value')

    def to_map(self):
        result = {}
        result['Key'] = self.key
        result['Value'] = self.value
        return result

    def from_map(self, map={}):
        self.key = map.get('Key')
        self.value = map.get('Value')
        return self
class DescribeDedicatedHostsResponse(TeaModel):
    def __init__(self, request_id=None, total_count=None, page_number=None, page_size=None, dedicated_hosts=None):
        self.request_id = request_id
        self.total_count = total_count
        self.page_number = page_number
        self.page_size = page_size
        self.dedicated_hosts = dedicated_hosts

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.page_number, 'page_number')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.dedicated_hosts, 'dedicated_hosts')
        if self.dedicated_hosts:
            self.dedicated_hosts.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['TotalCount'] = self.total_count
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        if self.dedicated_hosts is not None:
            result['DedicatedHosts'] = self.dedicated_hosts.to_map()
        else:
            result['DedicatedHosts'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.total_count = map.get('TotalCount')
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        if map.get('DedicatedHosts') is not None:
            temp_model = DescribeDedicatedHostsResponseDedicatedHosts()
            self.dedicated_hosts = temp_model.from_map(map['DedicatedHosts'])
        else:
            self.dedicated_hosts = None
        return self


class DescribeDedicatedHostsResponseDedicatedHostsDedicatedHostInstancesInstance(TeaModel):
    def __init__(self, instance_id=None, instance_type=None):
        self.instance_id = instance_id
        self.instance_type = instance_type

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.instance_type, 'instance_type')

    def to_map(self):
        result = {}
        result['InstanceId'] = self.instance_id
        result['InstanceType'] = self.instance_type
        return result

    def from_map(self, map={}):
        self.instance_id = map.get('InstanceId')
        self.instance_type = map.get('InstanceType')
        return self


class DescribeDedicatedHostsResponseDedicatedHostsDedicatedHostInstances(TeaModel):
    def __init__(self, instance=None):
        self.instance = instance

    def validate(self):
        self.validate_required(self.instance, 'instance')
        if self.instance:
            for k in self.instance:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['Instance'] = []
        if self.instance is not None:
            for k in self.instance:
                result['Instance'].append(k.to_map() if k else None)
        else:
            result['Instance'] = None
        return result

    def from_map(self, map={}):
        self.instance = []
        if map.get('Instance') is not None:
            for k in map.get('Instance'):
                temp_model = DescribeDedicatedHostsResponseDedicatedHostsDedicatedHostInstancesInstance()
                temp_model = temp_model.from_map(k)
                self.instance.append(temp_model)
        else:
            self.instance = None
        return self


class DescribeDedicatedHostsResponseDedicatedHostsDedicatedHostOperationLocksOperationLock(TeaModel):
    def __init__(self, lock_reason=None):
        self.lock_reason = lock_reason

    def validate(self):
        self.validate_required(self.lock_reason, 'lock_reason')

    def to_map(self):
        result = {}
        result['LockReason'] = self.lock_reason
        return result

    def from_map(self, map={}):
        self.lock_reason = map.get('LockReason')
        return self


class DescribeDedicatedHostsResponseDedicatedHostsDedicatedHostOperationLocks(TeaModel):
    def __init__(self, operation_lock=None):
        self.operation_lock = operation_lock

    def validate(self):
        self.validate_required(self.operation_lock, 'operation_lock')
        if self.operation_lock:
            for k in self.operation_lock:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['OperationLock'] = []
        if self.operation_lock is not None:
            for k in self.operation_lock:
                result['OperationLock'].append(k.to_map() if k else None)
        else:
            result['OperationLock'] = None
        return result

    def from_map(self, map={}):
        self.operation_lock = []
        if map.get('OperationLock') is not None:
            for k in map.get('OperationLock'):
                temp_model = DescribeDedicatedHostsResponseDedicatedHostsDedicatedHostOperationLocksOperationLock()
                temp_model = temp_model.from_map(k)
                self.operation_lock.append(temp_model)
        else:
            self.operation_lock = None
        return self


class DescribeDedicatedHostsResponseDedicatedHostsDedicatedHostTagsTag(TeaModel):
    def __init__(self, tag_key=None, tag_value=None):
        self.tag_key = tag_key
        self.tag_value = tag_value

    def validate(self):
        self.validate_required(self.tag_key, 'tag_key')
        self.validate_required(self.tag_value, 'tag_value')

    def to_map(self):
        result = {}
        result['TagKey'] = self.tag_key
        result['TagValue'] = self.tag_value
        return result

    def from_map(self, map={}):
        self.tag_key = map.get('TagKey')
        self.tag_value = map.get('TagValue')
        return self


class DescribeDedicatedHostsResponseDedicatedHostsDedicatedHostTags(TeaModel):
    def __init__(self, tag=None):
        self.tag = tag

    def validate(self):
        self.validate_required(self.tag, 'tag')
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        else:
            result['Tag'] = None
        return result

    def from_map(self, map={}):
        self.tag = []
        if map.get('Tag') is not None:
            for k in map.get('Tag'):
                temp_model = DescribeDedicatedHostsResponseDedicatedHostsDedicatedHostTagsTag()
                temp_model = temp_model.from_map(k)
                self.tag.append(temp_model)
        else:
            self.tag = None
        return self


class DescribeDedicatedHostsResponseDedicatedHostsDedicatedHostCapacity(TeaModel):
    def __init__(self, total_vcpus=None, available_vcpus=None, total_vgpus=None, available_vgpus=None,
                 total_memory=None, available_memory=None, total_local_storage=None, available_local_storage=None,
                 local_storage_category=None):
        self.total_vcpus = total_vcpus
        self.available_vcpus = available_vcpus
        self.total_vgpus = total_vgpus
        self.available_vgpus = available_vgpus
        self.total_memory = total_memory
        self.available_memory = available_memory
        self.total_local_storage = total_local_storage
        self.available_local_storage = available_local_storage
        self.local_storage_category = local_storage_category

    def validate(self):
        self.validate_required(self.total_vcpus, 'total_vcpus')
        self.validate_required(self.available_vcpus, 'available_vcpus')
        self.validate_required(self.total_vgpus, 'total_vgpus')
        self.validate_required(self.available_vgpus, 'available_vgpus')
        self.validate_required(self.total_memory, 'total_memory')
        self.validate_required(self.available_memory, 'available_memory')
        self.validate_required(self.total_local_storage, 'total_local_storage')
        self.validate_required(self.available_local_storage, 'available_local_storage')
        self.validate_required(self.local_storage_category, 'local_storage_category')

    def to_map(self):
        result = {}
        result['TotalVcpus'] = self.total_vcpus
        result['AvailableVcpus'] = self.available_vcpus
        result['TotalVgpus'] = self.total_vgpus
        result['AvailableVgpus'] = self.available_vgpus
        result['TotalMemory'] = self.total_memory
        result['AvailableMemory'] = self.available_memory
        result['TotalLocalStorage'] = self.total_local_storage
        result['AvailableLocalStorage'] = self.available_local_storage
        result['LocalStorageCategory'] = self.local_storage_category
        return result

    def from_map(self, map={}):
        self.total_vcpus = map.get('TotalVcpus')
        self.available_vcpus = map.get('AvailableVcpus')
        self.total_vgpus = map.get('TotalVgpus')
        self.available_vgpus = map.get('AvailableVgpus')
        self.total_memory = map.get('TotalMemory')
        self.available_memory = map.get('AvailableMemory')
        self.total_local_storage = map.get('TotalLocalStorage')
        self.available_local_storage = map.get('AvailableLocalStorage')
        self.local_storage_category = map.get('LocalStorageCategory')
        return self


class DescribeDedicatedHostsResponseDedicatedHostsDedicatedHostNetworkAttributes(TeaModel):
    def __init__(self, slb_udp_timeout=None, udp_timeout=None):
        self.slb_udp_timeout = slb_udp_timeout
        self.udp_timeout = udp_timeout

    def validate(self):
        self.validate_required(self.slb_udp_timeout, 'slb_udp_timeout')
        self.validate_required(self.udp_timeout, 'udp_timeout')

    def to_map(self):
        result = {}
        result['SlbUdpTimeout'] = self.slb_udp_timeout
        result['UdpTimeout'] = self.udp_timeout
        return result

    def from_map(self, map={}):
        self.slb_udp_timeout = map.get('SlbUdpTimeout')
        self.udp_timeout = map.get('UdpTimeout')
        return self


class DescribeDedicatedHostsResponseDedicatedHostsDedicatedHostSupportedInstanceTypeFamilies(TeaModel):
    def __init__(self, supported_instance_type_family=None):
        # SupportedInstanceTypeFamily
        self.supported_instance_type_family = supported_instance_type_family

    def validate(self):
        self.validate_required(self.supported_instance_type_family, 'supported_instance_type_family')

    def to_map(self):
        result = {}
        result['SupportedInstanceTypeFamily'] = []
        if self.supported_instance_type_family is not None:
            for k in self.supported_instance_type_family:
                result['SupportedInstanceTypeFamily'].append(k)
        else:
            result['SupportedInstanceTypeFamily'] = None
        return result

    def from_map(self, map={}):
        self.supported_instance_type_family = []
        if map.get('SupportedInstanceTypeFamily') is not None:
            for k in map.get('SupportedInstanceTypeFamily'):
                self.supported_instance_type_family.append(k)
        else:
            self.supported_instance_type_family = None
        return self


class DescribeDedicatedHostsResponseDedicatedHostsDedicatedHostSupportedCustomInstanceTypeFamilies(TeaModel):
    def __init__(self, supported_custom_instance_type_family=None):
        # SupportedCustomInstanceTypeFamily
        self.supported_custom_instance_type_family = supported_custom_instance_type_family

    def validate(self):
        self.validate_required(self.supported_custom_instance_type_family, 'supported_custom_instance_type_family')

    def to_map(self):
        result = {}
        result['SupportedCustomInstanceTypeFamily'] = []
        if self.supported_custom_instance_type_family is not None:
            for k in self.supported_custom_instance_type_family:
                result['SupportedCustomInstanceTypeFamily'].append(k)
        else:
            result['SupportedCustomInstanceTypeFamily'] = None
        return result

    def from_map(self, map={}):
        self.supported_custom_instance_type_family = []
        if map.get('SupportedCustomInstanceTypeFamily') is not None:
            for k in map.get('SupportedCustomInstanceTypeFamily'):
                self.supported_custom_instance_type_family.append(k)
        else:
            self.supported_custom_instance_type_family = None
        return self


class DescribeDedicatedHostsResponseDedicatedHostsDedicatedHostSupportedInstanceTypesList(TeaModel):
    def __init__(self, supported_instance_types_list=None):
        # SupportedInstanceTypesList
        self.supported_instance_types_list = supported_instance_types_list

    def validate(self):
        self.validate_required(self.supported_instance_types_list, 'supported_instance_types_list')

    def to_map(self):
        result = {}
        result['SupportedInstanceTypesList'] = []
        if self.supported_instance_types_list is not None:
            for k in self.supported_instance_types_list:
                result['SupportedInstanceTypesList'].append(k)
        else:
            result['SupportedInstanceTypesList'] = None
        return result

    def from_map(self, map={}):
        self.supported_instance_types_list = []
        if map.get('SupportedInstanceTypesList') is not None:
            for k in map.get('SupportedInstanceTypesList'):
                self.supported_instance_types_list.append(k)
        else:
            self.supported_instance_types_list = None
        return self


class DescribeDedicatedHostsResponseDedicatedHostsDedicatedHost(TeaModel):
    def __init__(self, dedicated_host_id=None, auto_placement=None, region_id=None, zone_id=None,
                 dedicated_host_name=None, machine_id=None, description=None, dedicated_host_type=None, sockets=None, cores=None,
                 physical_gpus=None, gpuspec=None, action_on_maintenance=None, status=None, creation_time=None, charge_type=None,
                 sale_cycle=None, expired_time=None, auto_release_time=None, resource_group_id=None, instances=None,
                 operation_locks=None, tags=None, capacity=None, network_attributes=None, supported_instance_type_families=None,
                 supported_custom_instance_type_families=None, supported_instance_types_list=None):
        self.dedicated_host_id = dedicated_host_id
        self.auto_placement = auto_placement
        self.region_id = region_id
        self.zone_id = zone_id
        self.dedicated_host_name = dedicated_host_name
        self.machine_id = machine_id
        self.description = description
        self.dedicated_host_type = dedicated_host_type
        self.sockets = sockets
        self.cores = cores
        self.physical_gpus = physical_gpus
        self.gpuspec = gpuspec
        self.action_on_maintenance = action_on_maintenance
        self.status = status
        self.creation_time = creation_time
        self.charge_type = charge_type
        self.sale_cycle = sale_cycle
        self.expired_time = expired_time
        self.auto_release_time = auto_release_time
        self.resource_group_id = resource_group_id
        self.instances = instances
        self.operation_locks = operation_locks
        self.tags = tags
        self.capacity = capacity
        self.network_attributes = network_attributes
        self.supported_instance_type_families = supported_instance_type_families
        self.supported_custom_instance_type_families = supported_custom_instance_type_families
        self.supported_instance_types_list = supported_instance_types_list

    def validate(self):
        self.validate_required(self.dedicated_host_id, 'dedicated_host_id')
        self.validate_required(self.auto_placement, 'auto_placement')
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.zone_id, 'zone_id')
        self.validate_required(self.dedicated_host_name, 'dedicated_host_name')
        self.validate_required(self.machine_id, 'machine_id')
        self.validate_required(self.description, 'description')
        self.validate_required(self.dedicated_host_type, 'dedicated_host_type')
        self.validate_required(self.sockets, 'sockets')
        self.validate_required(self.cores, 'cores')
        self.validate_required(self.physical_gpus, 'physical_gpus')
        self.validate_required(self.gpuspec, 'gpuspec')
        self.validate_required(self.action_on_maintenance, 'action_on_maintenance')
        self.validate_required(self.status, 'status')
        self.validate_required(self.creation_time, 'creation_time')
        self.validate_required(self.charge_type, 'charge_type')
        self.validate_required(self.sale_cycle, 'sale_cycle')
        self.validate_required(self.expired_time, 'expired_time')
        self.validate_required(self.auto_release_time, 'auto_release_time')
        self.validate_required(self.resource_group_id, 'resource_group_id')
        self.validate_required(self.instances, 'instances')
        if self.instances:
            self.instances.validate()
        self.validate_required(self.operation_locks, 'operation_locks')
        if self.operation_locks:
            self.operation_locks.validate()
        self.validate_required(self.tags, 'tags')
        if self.tags:
            self.tags.validate()
        self.validate_required(self.capacity, 'capacity')
        if self.capacity:
            self.capacity.validate()
        self.validate_required(self.network_attributes, 'network_attributes')
        if self.network_attributes:
            self.network_attributes.validate()
        self.validate_required(self.supported_instance_type_families, 'supported_instance_type_families')
        if self.supported_instance_type_families:
            self.supported_instance_type_families.validate()
        self.validate_required(self.supported_custom_instance_type_families, 'supported_custom_instance_type_families')
        if self.supported_custom_instance_type_families:
            self.supported_custom_instance_type_families.validate()
        self.validate_required(self.supported_instance_types_list, 'supported_instance_types_list')
        if self.supported_instance_types_list:
            self.supported_instance_types_list.validate()

    def to_map(self):
        result = {}
        result['DedicatedHostId'] = self.dedicated_host_id
        result['AutoPlacement'] = self.auto_placement
        result['RegionId'] = self.region_id
        result['ZoneId'] = self.zone_id
        result['DedicatedHostName'] = self.dedicated_host_name
        result['MachineId'] = self.machine_id
        result['Description'] = self.description
        result['DedicatedHostType'] = self.dedicated_host_type
        result['Sockets'] = self.sockets
        result['Cores'] = self.cores
        result['PhysicalGpus'] = self.physical_gpus
        result['GPUSpec'] = self.gpuspec
        result['ActionOnMaintenance'] = self.action_on_maintenance
        result['Status'] = self.status
        result['CreationTime'] = self.creation_time
        result['ChargeType'] = self.charge_type
        result['SaleCycle'] = self.sale_cycle
        result['ExpiredTime'] = self.expired_time
        result['AutoReleaseTime'] = self.auto_release_time
        result['ResourceGroupId'] = self.resource_group_id
        if self.instances is not None:
            result['Instances'] = self.instances.to_map()
        else:
            result['Instances'] = None
        if self.operation_locks is not None:
            result['OperationLocks'] = self.operation_locks.to_map()
        else:
            result['OperationLocks'] = None
        if self.tags is not None:
            result['Tags'] = self.tags.to_map()
        else:
            result['Tags'] = None
        if self.capacity is not None:
            result['Capacity'] = self.capacity.to_map()
        else:
            result['Capacity'] = None
        if self.network_attributes is not None:
            result['NetworkAttributes'] = self.network_attributes.to_map()
        else:
            result['NetworkAttributes'] = None
        if self.supported_instance_type_families is not None:
            result['SupportedInstanceTypeFamilies'] = self.supported_instance_type_families.to_map()
        else:
            result['SupportedInstanceTypeFamilies'] = None
        if self.supported_custom_instance_type_families is not None:
            result['SupportedCustomInstanceTypeFamilies'] = self.supported_custom_instance_type_families.to_map()
        else:
            result['SupportedCustomInstanceTypeFamilies'] = None
        if self.supported_instance_types_list is not None:
            result['SupportedInstanceTypesList'] = self.supported_instance_types_list.to_map()
        else:
            result['SupportedInstanceTypesList'] = None
        return result

    def from_map(self, map={}):
        self.dedicated_host_id = map.get('DedicatedHostId')
        self.auto_placement = map.get('AutoPlacement')
        self.region_id = map.get('RegionId')
        self.zone_id = map.get('ZoneId')
        self.dedicated_host_name = map.get('DedicatedHostName')
        self.machine_id = map.get('MachineId')
        self.description = map.get('Description')
        self.dedicated_host_type = map.get('DedicatedHostType')
        self.sockets = map.get('Sockets')
        self.cores = map.get('Cores')
        self.physical_gpus = map.get('PhysicalGpus')
        self.gpuspec = map.get('GPUSpec')
        self.action_on_maintenance = map.get('ActionOnMaintenance')
        self.status = map.get('Status')
        self.creation_time = map.get('CreationTime')
        self.charge_type = map.get('ChargeType')
        self.sale_cycle = map.get('SaleCycle')
        self.expired_time = map.get('ExpiredTime')
        self.auto_release_time = map.get('AutoReleaseTime')
        self.resource_group_id = map.get('ResourceGroupId')
        if map.get('Instances') is not None:
            temp_model = DescribeDedicatedHostsResponseDedicatedHostsDedicatedHostInstances()
            self.instances = temp_model.from_map(map['Instances'])
        else:
            self.instances = None
        if map.get('OperationLocks') is not None:
            temp_model = DescribeDedicatedHostsResponseDedicatedHostsDedicatedHostOperationLocks()
            self.operation_locks = temp_model.from_map(map['OperationLocks'])
        else:
            self.operation_locks = None
        if map.get('Tags') is not None:
            temp_model = DescribeDedicatedHostsResponseDedicatedHostsDedicatedHostTags()
            self.tags = temp_model.from_map(map['Tags'])
        else:
            self.tags = None
        if map.get('Capacity') is not None:
            temp_model = DescribeDedicatedHostsResponseDedicatedHostsDedicatedHostCapacity()
            self.capacity = temp_model.from_map(map['Capacity'])
        else:
            self.capacity = None
        if map.get('NetworkAttributes') is not None:
            temp_model = DescribeDedicatedHostsResponseDedicatedHostsDedicatedHostNetworkAttributes()
            self.network_attributes = temp_model.from_map(map['NetworkAttributes'])
        else:
            self.network_attributes = None
        if map.get('SupportedInstanceTypeFamilies') is not None:
            temp_model = DescribeDedicatedHostsResponseDedicatedHostsDedicatedHostSupportedInstanceTypeFamilies()
            self.supported_instance_type_families = temp_model.from_map(map['SupportedInstanceTypeFamilies'])
        else:
            self.supported_instance_type_families = None
        if map.get('SupportedCustomInstanceTypeFamilies') is not None:
            temp_model = DescribeDedicatedHostsResponseDedicatedHostsDedicatedHostSupportedCustomInstanceTypeFamilies()
            self.supported_custom_instance_type_families = temp_model.from_map(map['SupportedCustomInstanceTypeFamilies'])
        else:
            self.supported_custom_instance_type_families = None
        if map.get('SupportedInstanceTypesList') is not None:
            temp_model = DescribeDedicatedHostsResponseDedicatedHostsDedicatedHostSupportedInstanceTypesList()
            self.supported_instance_types_list = temp_model.from_map(map['SupportedInstanceTypesList'])
        else:
            self.supported_instance_types_list = None
        return self


class DescribeDedicatedHostsResponseDedicatedHosts(TeaModel):
    def __init__(self, dedicated_host=None):
        self.dedicated_host = dedicated_host

    def validate(self):
        self.validate_required(self.dedicated_host, 'dedicated_host')
        if self.dedicated_host:
            for k in self.dedicated_host:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['DedicatedHost'] = []
        if self.dedicated_host is not None:
            for k in self.dedicated_host:
                result['DedicatedHost'].append(k.to_map() if k else None)
        else:
            result['DedicatedHost'] = None
        return result

    def from_map(self, map={}):
        self.dedicated_host = []
        if map.get('DedicatedHost') is not None:
            for k in map.get('DedicatedHost'):
                temp_model = DescribeDedicatedHostsResponseDedicatedHostsDedicatedHost()
                temp_model = temp_model.from_map(k)
                self.dedicated_host.append(temp_model)
        else:
            self.dedicated_host = None
        return self
class DescribeDedicatedHostTypesRequest(TeaModel):
    def __init__(self, region_id=None, dedicated_host_type=None, supported_instance_type_family=None):
        self.region_id = region_id
        self.dedicated_host_type = dedicated_host_type
        self.supported_instance_type_family = supported_instance_type_family

    def validate(self):
        self.validate_required(self.region_id, 'region_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['DedicatedHostType'] = self.dedicated_host_type
        result['SupportedInstanceTypeFamily'] = self.supported_instance_type_family
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.dedicated_host_type = map.get('DedicatedHostType')
        self.supported_instance_type_family = map.get('SupportedInstanceTypeFamily')
        return self


class DescribeDedicatedHostTypesResponse(TeaModel):
    def __init__(self, request_id=None, dedicated_host_types=None):
        self.request_id = request_id
        self.dedicated_host_types = dedicated_host_types

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.dedicated_host_types, 'dedicated_host_types')
        if self.dedicated_host_types:
            self.dedicated_host_types.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        if self.dedicated_host_types is not None:
            result['DedicatedHostTypes'] = self.dedicated_host_types.to_map()
        else:
            result['DedicatedHostTypes'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        if map.get('DedicatedHostTypes') is not None:
            temp_model = DescribeDedicatedHostTypesResponseDedicatedHostTypes()
            self.dedicated_host_types = temp_model.from_map(map['DedicatedHostTypes'])
        else:
            self.dedicated_host_types = None
        return self


class DescribeDedicatedHostTypesResponseDedicatedHostTypesDedicatedHostTypeSupportedInstanceTypeFamilies(TeaModel):
    def __init__(self, supported_instance_type_family=None):
        # SupportedInstanceTypeFamily
        self.supported_instance_type_family = supported_instance_type_family

    def validate(self):
        self.validate_required(self.supported_instance_type_family, 'supported_instance_type_family')

    def to_map(self):
        result = {}
        result['SupportedInstanceTypeFamily'] = []
        if self.supported_instance_type_family is not None:
            for k in self.supported_instance_type_family:
                result['SupportedInstanceTypeFamily'].append(k)
        else:
            result['SupportedInstanceTypeFamily'] = None
        return result

    def from_map(self, map={}):
        self.supported_instance_type_family = []
        if map.get('SupportedInstanceTypeFamily') is not None:
            for k in map.get('SupportedInstanceTypeFamily'):
                self.supported_instance_type_family.append(k)
        else:
            self.supported_instance_type_family = None
        return self


class DescribeDedicatedHostTypesResponseDedicatedHostTypesDedicatedHostTypeSupportedInstanceTypesList(TeaModel):
    def __init__(self, supported_instance_types_list=None):
        # SupportedInstanceTypesList
        self.supported_instance_types_list = supported_instance_types_list

    def validate(self):
        self.validate_required(self.supported_instance_types_list, 'supported_instance_types_list')

    def to_map(self):
        result = {}
        result['SupportedInstanceTypesList'] = []
        if self.supported_instance_types_list is not None:
            for k in self.supported_instance_types_list:
                result['SupportedInstanceTypesList'].append(k)
        else:
            result['SupportedInstanceTypesList'] = None
        return result

    def from_map(self, map={}):
        self.supported_instance_types_list = []
        if map.get('SupportedInstanceTypesList') is not None:
            for k in map.get('SupportedInstanceTypesList'):
                self.supported_instance_types_list.append(k)
        else:
            self.supported_instance_types_list = None
        return self


class DescribeDedicatedHostTypesResponseDedicatedHostTypesDedicatedHostType(TeaModel):
    def __init__(self, dedicated_host_type=None, sockets=None, total_vcpus=None, total_vgpus=None, cores=None,
                 physical_gpus=None, memory_size=None, local_storage_capacity=None, local_storage_amount=None,
                 local_storage_category=None, gpuspec=None, supported_instance_type_families=None, supported_instance_types_list=None):
        self.dedicated_host_type = dedicated_host_type
        self.sockets = sockets
        self.total_vcpus = total_vcpus
        self.total_vgpus = total_vgpus
        self.cores = cores
        self.physical_gpus = physical_gpus
        self.memory_size = memory_size
        self.local_storage_capacity = local_storage_capacity
        self.local_storage_amount = local_storage_amount
        self.local_storage_category = local_storage_category
        self.gpuspec = gpuspec
        self.supported_instance_type_families = supported_instance_type_families
        self.supported_instance_types_list = supported_instance_types_list

    def validate(self):
        self.validate_required(self.dedicated_host_type, 'dedicated_host_type')
        self.validate_required(self.sockets, 'sockets')
        self.validate_required(self.total_vcpus, 'total_vcpus')
        self.validate_required(self.total_vgpus, 'total_vgpus')
        self.validate_required(self.cores, 'cores')
        self.validate_required(self.physical_gpus, 'physical_gpus')
        self.validate_required(self.memory_size, 'memory_size')
        self.validate_required(self.local_storage_capacity, 'local_storage_capacity')
        self.validate_required(self.local_storage_amount, 'local_storage_amount')
        self.validate_required(self.local_storage_category, 'local_storage_category')
        self.validate_required(self.gpuspec, 'gpuspec')
        self.validate_required(self.supported_instance_type_families, 'supported_instance_type_families')
        if self.supported_instance_type_families:
            self.supported_instance_type_families.validate()
        self.validate_required(self.supported_instance_types_list, 'supported_instance_types_list')
        if self.supported_instance_types_list:
            self.supported_instance_types_list.validate()

    def to_map(self):
        result = {}
        result['DedicatedHostType'] = self.dedicated_host_type
        result['Sockets'] = self.sockets
        result['TotalVcpus'] = self.total_vcpus
        result['TotalVgpus'] = self.total_vgpus
        result['Cores'] = self.cores
        result['PhysicalGpus'] = self.physical_gpus
        result['MemorySize'] = self.memory_size
        result['LocalStorageCapacity'] = self.local_storage_capacity
        result['LocalStorageAmount'] = self.local_storage_amount
        result['LocalStorageCategory'] = self.local_storage_category
        result['GPUSpec'] = self.gpuspec
        if self.supported_instance_type_families is not None:
            result['SupportedInstanceTypeFamilies'] = self.supported_instance_type_families.to_map()
        else:
            result['SupportedInstanceTypeFamilies'] = None
        if self.supported_instance_types_list is not None:
            result['SupportedInstanceTypesList'] = self.supported_instance_types_list.to_map()
        else:
            result['SupportedInstanceTypesList'] = None
        return result

    def from_map(self, map={}):
        self.dedicated_host_type = map.get('DedicatedHostType')
        self.sockets = map.get('Sockets')
        self.total_vcpus = map.get('TotalVcpus')
        self.total_vgpus = map.get('TotalVgpus')
        self.cores = map.get('Cores')
        self.physical_gpus = map.get('PhysicalGpus')
        self.memory_size = map.get('MemorySize')
        self.local_storage_capacity = map.get('LocalStorageCapacity')
        self.local_storage_amount = map.get('LocalStorageAmount')
        self.local_storage_category = map.get('LocalStorageCategory')
        self.gpuspec = map.get('GPUSpec')
        if map.get('SupportedInstanceTypeFamilies') is not None:
            temp_model = DescribeDedicatedHostTypesResponseDedicatedHostTypesDedicatedHostTypeSupportedInstanceTypeFamilies()
            self.supported_instance_type_families = temp_model.from_map(map['SupportedInstanceTypeFamilies'])
        else:
            self.supported_instance_type_families = None
        if map.get('SupportedInstanceTypesList') is not None:
            temp_model = DescribeDedicatedHostTypesResponseDedicatedHostTypesDedicatedHostTypeSupportedInstanceTypesList()
            self.supported_instance_types_list = temp_model.from_map(map['SupportedInstanceTypesList'])
        else:
            self.supported_instance_types_list = None
        return self


class DescribeDedicatedHostTypesResponseDedicatedHostTypes(TeaModel):
    def __init__(self, dedicated_host_type=None):
        self.dedicated_host_type = dedicated_host_type

    def validate(self):
        self.validate_required(self.dedicated_host_type, 'dedicated_host_type')
        if self.dedicated_host_type:
            for k in self.dedicated_host_type:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['DedicatedHostType'] = []
        if self.dedicated_host_type is not None:
            for k in self.dedicated_host_type:
                result['DedicatedHostType'].append(k.to_map() if k else None)
        else:
            result['DedicatedHostType'] = None
        return result

    def from_map(self, map={}):
        self.dedicated_host_type = []
        if map.get('DedicatedHostType') is not None:
            for k in map.get('DedicatedHostType'):
                temp_model = DescribeDedicatedHostTypesResponseDedicatedHostTypesDedicatedHostType()
                temp_model = temp_model.from_map(k)
                self.dedicated_host_type.append(temp_model)
        else:
            self.dedicated_host_type = None
        return self
class DescribeDedicatedHostAutoRenewRequest(TeaModel):
    def __init__(self, dedicated_host_ids=None, region_id=None):
        self.dedicated_host_ids = dedicated_host_ids
        self.region_id = region_id

    def validate(self):
        self.validate_required(self.dedicated_host_ids, 'dedicated_host_ids')
        self.validate_required(self.region_id, 'region_id')

    def to_map(self):
        result = {}
        result['DedicatedHostIds'] = self.dedicated_host_ids
        result['RegionId'] = self.region_id
        return result

    def from_map(self, map={}):
        self.dedicated_host_ids = map.get('DedicatedHostIds')
        self.region_id = map.get('RegionId')
        return self


class DescribeDedicatedHostAutoRenewResponse(TeaModel):
    def __init__(self, request_id=None, dedicated_host_renew_attributes=None):
        self.request_id = request_id
        self.dedicated_host_renew_attributes = dedicated_host_renew_attributes

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.dedicated_host_renew_attributes, 'dedicated_host_renew_attributes')
        if self.dedicated_host_renew_attributes:
            self.dedicated_host_renew_attributes.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        if self.dedicated_host_renew_attributes is not None:
            result['DedicatedHostRenewAttributes'] = self.dedicated_host_renew_attributes.to_map()
        else:
            result['DedicatedHostRenewAttributes'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        if map.get('DedicatedHostRenewAttributes') is not None:
            temp_model = DescribeDedicatedHostAutoRenewResponseDedicatedHostRenewAttributes()
            self.dedicated_host_renew_attributes = temp_model.from_map(map['DedicatedHostRenewAttributes'])
        else:
            self.dedicated_host_renew_attributes = None
        return self


class DescribeDedicatedHostAutoRenewResponseDedicatedHostRenewAttributesDedicatedHostRenewAttribute(TeaModel):
    def __init__(self, dedicated_host_id=None, auto_renew_enabled=None, duration=None, period_unit=None,
                 renewal_status=None):
        self.dedicated_host_id = dedicated_host_id
        self.auto_renew_enabled = auto_renew_enabled
        self.duration = duration
        self.period_unit = period_unit
        self.renewal_status = renewal_status

    def validate(self):
        self.validate_required(self.dedicated_host_id, 'dedicated_host_id')
        self.validate_required(self.auto_renew_enabled, 'auto_renew_enabled')
        self.validate_required(self.duration, 'duration')
        self.validate_required(self.period_unit, 'period_unit')
        self.validate_required(self.renewal_status, 'renewal_status')

    def to_map(self):
        result = {}
        result['DedicatedHostId'] = self.dedicated_host_id
        result['AutoRenewEnabled'] = self.auto_renew_enabled
        result['Duration'] = self.duration
        result['PeriodUnit'] = self.period_unit
        result['RenewalStatus'] = self.renewal_status
        return result

    def from_map(self, map={}):
        self.dedicated_host_id = map.get('DedicatedHostId')
        self.auto_renew_enabled = map.get('AutoRenewEnabled')
        self.duration = map.get('Duration')
        self.period_unit = map.get('PeriodUnit')
        self.renewal_status = map.get('RenewalStatus')
        return self


class DescribeDedicatedHostAutoRenewResponseDedicatedHostRenewAttributes(TeaModel):
    def __init__(self, dedicated_host_renew_attribute=None):
        self.dedicated_host_renew_attribute = dedicated_host_renew_attribute

    def validate(self):
        self.validate_required(self.dedicated_host_renew_attribute, 'dedicated_host_renew_attribute')
        if self.dedicated_host_renew_attribute:
            for k in self.dedicated_host_renew_attribute:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['DedicatedHostRenewAttribute'] = []
        if self.dedicated_host_renew_attribute is not None:
            for k in self.dedicated_host_renew_attribute:
                result['DedicatedHostRenewAttribute'].append(k.to_map() if k else None)
        else:
            result['DedicatedHostRenewAttribute'] = None
        return result

    def from_map(self, map={}):
        self.dedicated_host_renew_attribute = []
        if map.get('DedicatedHostRenewAttribute') is not None:
            for k in map.get('DedicatedHostRenewAttribute'):
                temp_model = DescribeDedicatedHostAutoRenewResponseDedicatedHostRenewAttributesDedicatedHostRenewAttribute()
                temp_model = temp_model.from_map(k)
                self.dedicated_host_renew_attribute.append(temp_model)
        else:
            self.dedicated_host_renew_attribute = None
        return self
class AllocateDedicatedHostsRequest(TeaModel):
    def __init__(self, region_id=None, tag=None, resource_group_id=None, zone_id=None, dedicated_host_name=None,
                 dedicated_host_type=None, action_on_maintenance=None, network_attributes=None, description=None, auto_placement=None,
                 charge_type=None, quantity=None, period=None, period_unit=None, auto_renew=None, auto_renew_period=None,
                 auto_release_time=None, client_token=None):
        self.region_id = region_id
        self.tag = tag
        self.resource_group_id = resource_group_id
        self.zone_id = zone_id
        self.dedicated_host_name = dedicated_host_name
        self.dedicated_host_type = dedicated_host_type
        self.action_on_maintenance = action_on_maintenance
        self.network_attributes = network_attributes
        self.description = description
        self.auto_placement = auto_placement
        self.charge_type = charge_type
        self.quantity = quantity
        self.period = period
        self.period_unit = period_unit
        self.auto_renew = auto_renew
        self.auto_renew_period = auto_renew_period
        self.auto_release_time = auto_release_time
        self.client_token = client_token

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()
        self.validate_required(self.dedicated_host_type, 'dedicated_host_type')
        if self.network_attributes:
            self.network_attributes.validate()

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        else:
            result['Tag'] = None
        result['ResourceGroupId'] = self.resource_group_id
        result['ZoneId'] = self.zone_id
        result['DedicatedHostName'] = self.dedicated_host_name
        result['DedicatedHostType'] = self.dedicated_host_type
        result['ActionOnMaintenance'] = self.action_on_maintenance
        if self.network_attributes is not None:
            result['NetworkAttributes'] = self.network_attributes.to_map()
        else:
            result['NetworkAttributes'] = None
        result['Description'] = self.description
        result['AutoPlacement'] = self.auto_placement
        result['ChargeType'] = self.charge_type
        result['Quantity'] = self.quantity
        result['Period'] = self.period
        result['PeriodUnit'] = self.period_unit
        result['AutoRenew'] = self.auto_renew
        result['AutoRenewPeriod'] = self.auto_renew_period
        result['AutoReleaseTime'] = self.auto_release_time
        result['ClientToken'] = self.client_token
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.tag = []
        if map.get('Tag') is not None:
            for k in map.get('Tag'):
                temp_model = AllocateDedicatedHostsRequestTag()
                temp_model = temp_model.from_map(k)
                self.tag.append(temp_model)
        else:
            self.tag = None
        self.resource_group_id = map.get('ResourceGroupId')
        self.zone_id = map.get('ZoneId')
        self.dedicated_host_name = map.get('DedicatedHostName')
        self.dedicated_host_type = map.get('DedicatedHostType')
        self.action_on_maintenance = map.get('ActionOnMaintenance')
        if map.get('NetworkAttributes') is not None:
            temp_model = AllocateDedicatedHostsRequestNetworkAttributes()
            self.network_attributes = temp_model.from_map(map['NetworkAttributes'])
        else:
            self.network_attributes = None
        self.description = map.get('Description')
        self.auto_placement = map.get('AutoPlacement')
        self.charge_type = map.get('ChargeType')
        self.quantity = map.get('Quantity')
        self.period = map.get('Period')
        self.period_unit = map.get('PeriodUnit')
        self.auto_renew = map.get('AutoRenew')
        self.auto_renew_period = map.get('AutoRenewPeriod')
        self.auto_release_time = map.get('AutoReleaseTime')
        self.client_token = map.get('ClientToken')
        return self


class AllocateDedicatedHostsRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key
        self.value = value

    def validate(self):
        self.validate_required(self.key, 'key')
        self.validate_required(self.value, 'value')

    def to_map(self):
        result = {}
        result['Key'] = self.key
        result['Value'] = self.value
        return result

    def from_map(self, map={}):
        self.key = map.get('Key')
        self.value = map.get('Value')
        return self


class AllocateDedicatedHostsRequestNetworkAttributes(TeaModel):
    def __init__(self, slb_udp_timeout=None, udp_timeout=None):
        self.slb_udp_timeout = slb_udp_timeout
        self.udp_timeout = udp_timeout

    def validate(self):
        pass

    def to_map(self):
        result = {}
        result['SlbUdpTimeout'] = self.slb_udp_timeout
        result['UdpTimeout'] = self.udp_timeout
        return result

    def from_map(self, map={}):
        self.slb_udp_timeout = map.get('SlbUdpTimeout')
        self.udp_timeout = map.get('UdpTimeout')
        return self
class AllocateDedicatedHostsResponse(TeaModel):
    def __init__(self, request_id=None, dedicated_host_id_sets=None):
        self.request_id = request_id
        self.dedicated_host_id_sets = dedicated_host_id_sets

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.dedicated_host_id_sets, 'dedicated_host_id_sets')
        if self.dedicated_host_id_sets:
            self.dedicated_host_id_sets.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        if self.dedicated_host_id_sets is not None:
            result['DedicatedHostIdSets'] = self.dedicated_host_id_sets.to_map()
        else:
            result['DedicatedHostIdSets'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        if map.get('DedicatedHostIdSets') is not None:
            temp_model = AllocateDedicatedHostsResponseDedicatedHostIdSets()
            self.dedicated_host_id_sets = temp_model.from_map(map['DedicatedHostIdSets'])
        else:
            self.dedicated_host_id_sets = None
        return self


class AllocateDedicatedHostsResponseDedicatedHostIdSets(TeaModel):
    def __init__(self, dedicated_host_id=None):
        self.dedicated_host_id = dedicated_host_id

    def validate(self):
        self.validate_required(self.dedicated_host_id, 'dedicated_host_id')

    def to_map(self):
        result = {}
        result['DedicatedHostId'] = []
        if self.dedicated_host_id is not None:
            for k in self.dedicated_host_id:
                result['DedicatedHostId'].append(k)
        else:
            result['DedicatedHostId'] = None
        return result

    def from_map(self, map={}):
        self.dedicated_host_id = []
        if map.get('DedicatedHostId') is not None:
            for k in map.get('DedicatedHostId'):
                self.dedicated_host_id.append(k)
        else:
            self.dedicated_host_id = None
        return self
class CreateSimulatedSystemEventsRequest(TeaModel):
    def __init__(self, region_id=None, instance_id=None, event_type=None, not_before=None):
        self.region_id = region_id
        self.instance_id = instance_id
        self.event_type = event_type
        self.not_before = not_before

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.event_type, 'event_type')
        self.validate_required(self.not_before, 'not_before')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['InstanceId'] = []
        if self.instance_id is not None:
            for k in self.instance_id:
                result['InstanceId'].append(k)
        else:
            result['InstanceId'] = None
        result['EventType'] = self.event_type
        result['NotBefore'] = self.not_before
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.instance_id = []
        if map.get('InstanceId') is not None:
            for k in map.get('InstanceId'):
                self.instance_id.append(k)
        else:
            self.instance_id = None
        self.event_type = map.get('EventType')
        self.not_before = map.get('NotBefore')
        return self


class CreateSimulatedSystemEventsResponse(TeaModel):
    def __init__(self, request_id=None, event_id_set=None):
        self.request_id = request_id
        self.event_id_set = event_id_set

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.event_id_set, 'event_id_set')
        if self.event_id_set:
            self.event_id_set.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        if self.event_id_set is not None:
            result['EventIdSet'] = self.event_id_set.to_map()
        else:
            result['EventIdSet'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        if map.get('EventIdSet') is not None:
            temp_model = CreateSimulatedSystemEventsResponseEventIdSet()
            self.event_id_set = temp_model.from_map(map['EventIdSet'])
        else:
            self.event_id_set = None
        return self


class CreateSimulatedSystemEventsResponseEventIdSet(TeaModel):
    def __init__(self, event_id=None):
        self.event_id = event_id

    def validate(self):
        self.validate_required(self.event_id, 'event_id')

    def to_map(self):
        result = {}
        result['EventId'] = []
        if self.event_id is not None:
            for k in self.event_id:
                result['EventId'].append(k)
        else:
            result['EventId'] = None
        return result

    def from_map(self, map={}):
        self.event_id = []
        if map.get('EventId') is not None:
            for k in map.get('EventId'):
                self.event_id.append(k)
        else:
            self.event_id = None
        return self
class CancelSimulatedSystemEventsRequest(TeaModel):
    def __init__(self, region_id=None, event_id=None):
        self.region_id = region_id
        self.event_id = event_id

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.event_id, 'event_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['EventId'] = []
        if self.event_id is not None:
            for k in self.event_id:
                result['EventId'].append(k)
        else:
            result['EventId'] = None
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.event_id = []
        if map.get('EventId') is not None:
            for k in map.get('EventId'):
                self.event_id.append(k)
        else:
            self.event_id = None
        return self


class CancelSimulatedSystemEventsResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class DescribeEniMonitorDataRequest(TeaModel):
    def __init__(self, eni_id=None, region_id=None, instance_id=None, start_time=None, end_time=None, period=None):
        self.eni_id = eni_id
        self.region_id = region_id
        self.instance_id = instance_id
        self.start_time = start_time
        self.end_time = end_time
        self.period = period

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.start_time, 'start_time')
        self.validate_required(self.end_time, 'end_time')

    def to_map(self):
        result = {}
        result['EniId'] = self.eni_id
        result['RegionId'] = self.region_id
        result['InstanceId'] = self.instance_id
        result['StartTime'] = self.start_time
        result['EndTime'] = self.end_time
        result['Period'] = self.period
        return result

    def from_map(self, map={}):
        self.eni_id = map.get('EniId')
        self.region_id = map.get('RegionId')
        self.instance_id = map.get('InstanceId')
        self.start_time = map.get('StartTime')
        self.end_time = map.get('EndTime')
        self.period = map.get('Period')
        return self


class DescribeEniMonitorDataResponse(TeaModel):
    def __init__(self, request_id=None, total_count=None, monitor_data=None):
        self.request_id = request_id
        self.total_count = total_count
        self.monitor_data = monitor_data

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.monitor_data, 'monitor_data')
        if self.monitor_data:
            self.monitor_data.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['TotalCount'] = self.total_count
        if self.monitor_data is not None:
            result['MonitorData'] = self.monitor_data.to_map()
        else:
            result['MonitorData'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.total_count = map.get('TotalCount')
        if map.get('MonitorData') is not None:
            temp_model = DescribeEniMonitorDataResponseMonitorData()
            self.monitor_data = temp_model.from_map(map['MonitorData'])
        else:
            self.monitor_data = None
        return self


class DescribeEniMonitorDataResponseMonitorDataEniMonitorData(TeaModel):
    def __init__(self, eni_id=None, time_stamp=None, packet_tx=None, packet_rx=None, intranet_tx=None,
                 intranet_rx=None, drop_packet_tx=None, drop_packet_rx=None):
        self.eni_id = eni_id
        self.time_stamp = time_stamp
        self.packet_tx = packet_tx
        self.packet_rx = packet_rx
        self.intranet_tx = intranet_tx
        self.intranet_rx = intranet_rx
        self.drop_packet_tx = drop_packet_tx
        self.drop_packet_rx = drop_packet_rx

    def validate(self):
        self.validate_required(self.eni_id, 'eni_id')
        self.validate_required(self.time_stamp, 'time_stamp')
        self.validate_required(self.packet_tx, 'packet_tx')
        self.validate_required(self.packet_rx, 'packet_rx')
        self.validate_required(self.intranet_tx, 'intranet_tx')
        self.validate_required(self.intranet_rx, 'intranet_rx')
        self.validate_required(self.drop_packet_tx, 'drop_packet_tx')
        self.validate_required(self.drop_packet_rx, 'drop_packet_rx')

    def to_map(self):
        result = {}
        result['EniId'] = self.eni_id
        result['TimeStamp'] = self.time_stamp
        result['PacketTx'] = self.packet_tx
        result['PacketRx'] = self.packet_rx
        result['IntranetTx'] = self.intranet_tx
        result['IntranetRx'] = self.intranet_rx
        result['DropPacketTx'] = self.drop_packet_tx
        result['DropPacketRx'] = self.drop_packet_rx
        return result

    def from_map(self, map={}):
        self.eni_id = map.get('EniId')
        self.time_stamp = map.get('TimeStamp')
        self.packet_tx = map.get('PacketTx')
        self.packet_rx = map.get('PacketRx')
        self.intranet_tx = map.get('IntranetTx')
        self.intranet_rx = map.get('IntranetRx')
        self.drop_packet_tx = map.get('DropPacketTx')
        self.drop_packet_rx = map.get('DropPacketRx')
        return self


class DescribeEniMonitorDataResponseMonitorData(TeaModel):
    def __init__(self, eni_monitor_data=None):
        self.eni_monitor_data = eni_monitor_data

    def validate(self):
        self.validate_required(self.eni_monitor_data, 'eni_monitor_data')
        if self.eni_monitor_data:
            for k in self.eni_monitor_data:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['EniMonitorData'] = []
        if self.eni_monitor_data is not None:
            for k in self.eni_monitor_data:
                result['EniMonitorData'].append(k.to_map() if k else None)
        else:
            result['EniMonitorData'] = None
        return result

    def from_map(self, map={}):
        self.eni_monitor_data = []
        if map.get('EniMonitorData') is not None:
            for k in map.get('EniMonitorData'):
                temp_model = DescribeEniMonitorDataResponseMonitorDataEniMonitorData()
                temp_model = temp_model.from_map(k)
                self.eni_monitor_data.append(temp_model)
        else:
            self.eni_monitor_data = None
        return self
class DescribeAccountAttributesRequest(TeaModel):
    def __init__(self, region_id=None, zone_id=None, attribute_name=None):
        self.region_id = region_id
        self.zone_id = zone_id
        self.attribute_name = attribute_name

    def validate(self):
        self.validate_required(self.region_id, 'region_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['ZoneId'] = self.zone_id
        result['AttributeName'] = []
        if self.attribute_name is not None:
            for k in self.attribute_name:
                result['AttributeName'].append(k)
        else:
            result['AttributeName'] = None
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.zone_id = map.get('ZoneId')
        self.attribute_name = []
        if map.get('AttributeName') is not None:
            for k in map.get('AttributeName'):
                self.attribute_name.append(k)
        else:
            self.attribute_name = None
        return self


class DescribeAccountAttributesResponse(TeaModel):
    def __init__(self, request_id=None, account_attribute_items=None):
        self.request_id = request_id
        self.account_attribute_items = account_attribute_items

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.account_attribute_items, 'account_attribute_items')
        if self.account_attribute_items:
            self.account_attribute_items.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        if self.account_attribute_items is not None:
            result['AccountAttributeItems'] = self.account_attribute_items.to_map()
        else:
            result['AccountAttributeItems'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        if map.get('AccountAttributeItems') is not None:
            temp_model = DescribeAccountAttributesResponseAccountAttributeItems()
            self.account_attribute_items = temp_model.from_map(map['AccountAttributeItems'])
        else:
            self.account_attribute_items = None
        return self


class DescribeAccountAttributesResponseAccountAttributeItemsAccountAttributeItemAttributeValuesValueItem(TeaModel):
    def __init__(self, value=None, expired_time=None, zone_id=None, instance_charge_type=None, instance_type=None,
                 count=None, disk_category=None):
        self.value = value
        self.expired_time = expired_time
        self.zone_id = zone_id
        self.instance_charge_type = instance_charge_type
        self.instance_type = instance_type
        self.count = count
        self.disk_category = disk_category

    def validate(self):
        self.validate_required(self.value, 'value')
        self.validate_required(self.expired_time, 'expired_time')
        self.validate_required(self.zone_id, 'zone_id')
        self.validate_required(self.instance_charge_type, 'instance_charge_type')
        self.validate_required(self.instance_type, 'instance_type')
        self.validate_required(self.count, 'count')
        self.validate_required(self.disk_category, 'disk_category')

    def to_map(self):
        result = {}
        result['Value'] = self.value
        result['ExpiredTime'] = self.expired_time
        result['ZoneId'] = self.zone_id
        result['InstanceChargeType'] = self.instance_charge_type
        result['InstanceType'] = self.instance_type
        result['Count'] = self.count
        result['DiskCategory'] = self.disk_category
        return result

    def from_map(self, map={}):
        self.value = map.get('Value')
        self.expired_time = map.get('ExpiredTime')
        self.zone_id = map.get('ZoneId')
        self.instance_charge_type = map.get('InstanceChargeType')
        self.instance_type = map.get('InstanceType')
        self.count = map.get('Count')
        self.disk_category = map.get('DiskCategory')
        return self


class DescribeAccountAttributesResponseAccountAttributeItemsAccountAttributeItemAttributeValues(TeaModel):
    def __init__(self, value_item=None):
        self.value_item = value_item

    def validate(self):
        self.validate_required(self.value_item, 'value_item')
        if self.value_item:
            for k in self.value_item:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['ValueItem'] = []
        if self.value_item is not None:
            for k in self.value_item:
                result['ValueItem'].append(k.to_map() if k else None)
        else:
            result['ValueItem'] = None
        return result

    def from_map(self, map={}):
        self.value_item = []
        if map.get('ValueItem') is not None:
            for k in map.get('ValueItem'):
                temp_model = DescribeAccountAttributesResponseAccountAttributeItemsAccountAttributeItemAttributeValuesValueItem()
                temp_model = temp_model.from_map(k)
                self.value_item.append(temp_model)
        else:
            self.value_item = None
        return self


class DescribeAccountAttributesResponseAccountAttributeItemsAccountAttributeItem(TeaModel):
    def __init__(self, attribute_name=None, attribute_values=None):
        self.attribute_name = attribute_name
        self.attribute_values = attribute_values

    def validate(self):
        self.validate_required(self.attribute_name, 'attribute_name')
        self.validate_required(self.attribute_values, 'attribute_values')
        if self.attribute_values:
            self.attribute_values.validate()

    def to_map(self):
        result = {}
        result['AttributeName'] = self.attribute_name
        if self.attribute_values is not None:
            result['AttributeValues'] = self.attribute_values.to_map()
        else:
            result['AttributeValues'] = None
        return result

    def from_map(self, map={}):
        self.attribute_name = map.get('AttributeName')
        if map.get('AttributeValues') is not None:
            temp_model = DescribeAccountAttributesResponseAccountAttributeItemsAccountAttributeItemAttributeValues()
            self.attribute_values = temp_model.from_map(map['AttributeValues'])
        else:
            self.attribute_values = None
        return self


class DescribeAccountAttributesResponseAccountAttributeItems(TeaModel):
    def __init__(self, account_attribute_item=None):
        self.account_attribute_item = account_attribute_item

    def validate(self):
        self.validate_required(self.account_attribute_item, 'account_attribute_item')
        if self.account_attribute_item:
            for k in self.account_attribute_item:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['AccountAttributeItem'] = []
        if self.account_attribute_item is not None:
            for k in self.account_attribute_item:
                result['AccountAttributeItem'].append(k.to_map() if k else None)
        else:
            result['AccountAttributeItem'] = None
        return result

    def from_map(self, map={}):
        self.account_attribute_item = []
        if map.get('AccountAttributeItem') is not None:
            for k in map.get('AccountAttributeItem'):
                temp_model = DescribeAccountAttributesResponseAccountAttributeItemsAccountAttributeItem()
                temp_model = temp_model.from_map(k)
                self.account_attribute_item.append(temp_model)
        else:
            self.account_attribute_item = None
        return self
class ModifyLaunchTemplateDefaultVersionRequest(TeaModel):
    def __init__(self, region_id=None, launch_template_id=None, launch_template_name=None,
                 default_version_number=None):
        self.region_id = region_id
        self.launch_template_id = launch_template_id
        self.launch_template_name = launch_template_name
        self.default_version_number = default_version_number

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.default_version_number, 'default_version_number')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['LaunchTemplateId'] = self.launch_template_id
        result['LaunchTemplateName'] = self.launch_template_name
        result['DefaultVersionNumber'] = self.default_version_number
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.launch_template_id = map.get('LaunchTemplateId')
        self.launch_template_name = map.get('LaunchTemplateName')
        self.default_version_number = map.get('DefaultVersionNumber')
        return self


class ModifyLaunchTemplateDefaultVersionResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class DescribeLaunchTemplatesRequest(TeaModel):
    def __init__(self, region_id=None, template_tag=None, launch_template_id=None, launch_template_name=None,
                 page_number=None, page_size=None, template_resource_group_id=None):
        self.region_id = region_id
        self.template_tag = template_tag
        self.launch_template_id = launch_template_id
        self.launch_template_name = launch_template_name
        self.page_number = page_number
        self.page_size = page_size
        self.template_resource_group_id = template_resource_group_id

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        if self.template_tag:
            for k in self.template_tag:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['TemplateTag'] = []
        if self.template_tag is not None:
            for k in self.template_tag:
                result['TemplateTag'].append(k.to_map() if k else None)
        else:
            result['TemplateTag'] = None
        result['LaunchTemplateId'] = []
        if self.launch_template_id is not None:
            for k in self.launch_template_id:
                result['LaunchTemplateId'].append(k)
        else:
            result['LaunchTemplateId'] = None
        result['LaunchTemplateName'] = []
        if self.launch_template_name is not None:
            for k in self.launch_template_name:
                result['LaunchTemplateName'].append(k)
        else:
            result['LaunchTemplateName'] = None
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        result['TemplateResourceGroupId'] = self.template_resource_group_id
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.template_tag = []
        if map.get('TemplateTag') is not None:
            for k in map.get('TemplateTag'):
                temp_model = DescribeLaunchTemplatesRequestTemplateTag()
                temp_model = temp_model.from_map(k)
                self.template_tag.append(temp_model)
        else:
            self.template_tag = None
        self.launch_template_id = []
        if map.get('LaunchTemplateId') is not None:
            for k in map.get('LaunchTemplateId'):
                self.launch_template_id.append(k)
        else:
            self.launch_template_id = None
        self.launch_template_name = []
        if map.get('LaunchTemplateName') is not None:
            for k in map.get('LaunchTemplateName'):
                self.launch_template_name.append(k)
        else:
            self.launch_template_name = None
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        self.template_resource_group_id = map.get('TemplateResourceGroupId')
        return self


class DescribeLaunchTemplatesRequestTemplateTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key
        self.value = value

    def validate(self):
        self.validate_required(self.key, 'key')
        self.validate_required(self.value, 'value')

    def to_map(self):
        result = {}
        result['Key'] = self.key
        result['Value'] = self.value
        return result

    def from_map(self, map={}):
        self.key = map.get('Key')
        self.value = map.get('Value')
        return self
class DescribeLaunchTemplatesResponse(TeaModel):
    def __init__(self, request_id=None, total_count=None, page_number=None, page_size=None,
                 launch_template_sets=None):
        self.request_id = request_id
        self.total_count = total_count
        self.page_number = page_number
        self.page_size = page_size
        self.launch_template_sets = launch_template_sets

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.page_number, 'page_number')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.launch_template_sets, 'launch_template_sets')
        if self.launch_template_sets:
            self.launch_template_sets.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['TotalCount'] = self.total_count
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        if self.launch_template_sets is not None:
            result['LaunchTemplateSets'] = self.launch_template_sets.to_map()
        else:
            result['LaunchTemplateSets'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.total_count = map.get('TotalCount')
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        if map.get('LaunchTemplateSets') is not None:
            temp_model = DescribeLaunchTemplatesResponseLaunchTemplateSets()
            self.launch_template_sets = temp_model.from_map(map['LaunchTemplateSets'])
        else:
            self.launch_template_sets = None
        return self


class DescribeLaunchTemplatesResponseLaunchTemplateSetsLaunchTemplateSetTagsTag(TeaModel):
    def __init__(self, tag_key=None, tag_value=None):
        self.tag_key = tag_key
        self.tag_value = tag_value

    def validate(self):
        self.validate_required(self.tag_key, 'tag_key')
        self.validate_required(self.tag_value, 'tag_value')

    def to_map(self):
        result = {}
        result['TagKey'] = self.tag_key
        result['TagValue'] = self.tag_value
        return result

    def from_map(self, map={}):
        self.tag_key = map.get('TagKey')
        self.tag_value = map.get('TagValue')
        return self


class DescribeLaunchTemplatesResponseLaunchTemplateSetsLaunchTemplateSetTags(TeaModel):
    def __init__(self, tag=None):
        self.tag = tag

    def validate(self):
        self.validate_required(self.tag, 'tag')
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        else:
            result['Tag'] = None
        return result

    def from_map(self, map={}):
        self.tag = []
        if map.get('Tag') is not None:
            for k in map.get('Tag'):
                temp_model = DescribeLaunchTemplatesResponseLaunchTemplateSetsLaunchTemplateSetTagsTag()
                temp_model = temp_model.from_map(k)
                self.tag.append(temp_model)
        else:
            self.tag = None
        return self


class DescribeLaunchTemplatesResponseLaunchTemplateSetsLaunchTemplateSet(TeaModel):
    def __init__(self, create_time=None, modified_time=None, launch_template_id=None, launch_template_name=None,
                 default_version_number=None, latest_version_number=None, created_by=None, resource_group_id=None, tags=None):
        self.create_time = create_time
        self.modified_time = modified_time
        self.launch_template_id = launch_template_id
        self.launch_template_name = launch_template_name
        self.default_version_number = default_version_number
        self.latest_version_number = latest_version_number
        self.created_by = created_by
        self.resource_group_id = resource_group_id
        self.tags = tags

    def validate(self):
        self.validate_required(self.create_time, 'create_time')
        self.validate_required(self.modified_time, 'modified_time')
        self.validate_required(self.launch_template_id, 'launch_template_id')
        self.validate_required(self.launch_template_name, 'launch_template_name')
        self.validate_required(self.default_version_number, 'default_version_number')
        self.validate_required(self.latest_version_number, 'latest_version_number')
        self.validate_required(self.created_by, 'created_by')
        self.validate_required(self.resource_group_id, 'resource_group_id')
        self.validate_required(self.tags, 'tags')
        if self.tags:
            self.tags.validate()

    def to_map(self):
        result = {}
        result['CreateTime'] = self.create_time
        result['ModifiedTime'] = self.modified_time
        result['LaunchTemplateId'] = self.launch_template_id
        result['LaunchTemplateName'] = self.launch_template_name
        result['DefaultVersionNumber'] = self.default_version_number
        result['LatestVersionNumber'] = self.latest_version_number
        result['CreatedBy'] = self.created_by
        result['ResourceGroupId'] = self.resource_group_id
        if self.tags is not None:
            result['Tags'] = self.tags.to_map()
        else:
            result['Tags'] = None
        return result

    def from_map(self, map={}):
        self.create_time = map.get('CreateTime')
        self.modified_time = map.get('ModifiedTime')
        self.launch_template_id = map.get('LaunchTemplateId')
        self.launch_template_name = map.get('LaunchTemplateName')
        self.default_version_number = map.get('DefaultVersionNumber')
        self.latest_version_number = map.get('LatestVersionNumber')
        self.created_by = map.get('CreatedBy')
        self.resource_group_id = map.get('ResourceGroupId')
        if map.get('Tags') is not None:
            temp_model = DescribeLaunchTemplatesResponseLaunchTemplateSetsLaunchTemplateSetTags()
            self.tags = temp_model.from_map(map['Tags'])
        else:
            self.tags = None
        return self


class DescribeLaunchTemplatesResponseLaunchTemplateSets(TeaModel):
    def __init__(self, launch_template_set=None):
        self.launch_template_set = launch_template_set

    def validate(self):
        self.validate_required(self.launch_template_set, 'launch_template_set')
        if self.launch_template_set:
            for k in self.launch_template_set:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['LaunchTemplateSet'] = []
        if self.launch_template_set is not None:
            for k in self.launch_template_set:
                result['LaunchTemplateSet'].append(k.to_map() if k else None)
        else:
            result['LaunchTemplateSet'] = None
        return result

    def from_map(self, map={}):
        self.launch_template_set = []
        if map.get('LaunchTemplateSet') is not None:
            for k in map.get('LaunchTemplateSet'):
                temp_model = DescribeLaunchTemplatesResponseLaunchTemplateSetsLaunchTemplateSet()
                temp_model = temp_model.from_map(k)
                self.launch_template_set.append(temp_model)
        else:
            self.launch_template_set = None
        return self
class DescribeLaunchTemplateVersionsRequest(TeaModel):
    def __init__(self, region_id=None, launch_template_id=None, launch_template_name=None,
                 launch_template_version=None, min_version=None, max_version=None, default_version=None, detail_flag=None, page_number=None,
                 page_size=None):
        self.region_id = region_id
        self.launch_template_id = launch_template_id
        self.launch_template_name = launch_template_name
        self.launch_template_version = launch_template_version
        self.min_version = min_version
        self.max_version = max_version
        self.default_version = default_version
        self.detail_flag = detail_flag
        self.page_number = page_number
        self.page_size = page_size

    def validate(self):
        self.validate_required(self.region_id, 'region_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['LaunchTemplateId'] = self.launch_template_id
        result['LaunchTemplateName'] = self.launch_template_name
        result['LaunchTemplateVersion'] = []
        if self.launch_template_version is not None:
            for k in self.launch_template_version:
                result['LaunchTemplateVersion'].append(k)
        else:
            result['LaunchTemplateVersion'] = None
        result['MinVersion'] = self.min_version
        result['MaxVersion'] = self.max_version
        result['DefaultVersion'] = self.default_version
        result['DetailFlag'] = self.detail_flag
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.launch_template_id = map.get('LaunchTemplateId')
        self.launch_template_name = map.get('LaunchTemplateName')
        self.launch_template_version = []
        if map.get('LaunchTemplateVersion') is not None:
            for k in map.get('LaunchTemplateVersion'):
                self.launch_template_version.append(k)
        else:
            self.launch_template_version = None
        self.min_version = map.get('MinVersion')
        self.max_version = map.get('MaxVersion')
        self.default_version = map.get('DefaultVersion')
        self.detail_flag = map.get('DetailFlag')
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        return self


class DescribeLaunchTemplateVersionsResponse(TeaModel):
    def __init__(self, request_id=None, total_count=None, page_number=None, page_size=None,
                 launch_template_version_sets=None):
        self.request_id = request_id
        self.total_count = total_count
        self.page_number = page_number
        self.page_size = page_size
        self.launch_template_version_sets = launch_template_version_sets

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.page_number, 'page_number')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.launch_template_version_sets, 'launch_template_version_sets')
        if self.launch_template_version_sets:
            self.launch_template_version_sets.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['TotalCount'] = self.total_count
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        if self.launch_template_version_sets is not None:
            result['LaunchTemplateVersionSets'] = self.launch_template_version_sets.to_map()
        else:
            result['LaunchTemplateVersionSets'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.total_count = map.get('TotalCount')
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        if map.get('LaunchTemplateVersionSets') is not None:
            temp_model = DescribeLaunchTemplateVersionsResponseLaunchTemplateVersionSets()
            self.launch_template_version_sets = temp_model.from_map(map['LaunchTemplateVersionSets'])
        else:
            self.launch_template_version_sets = None
        return self


class DescribeLaunchTemplateVersionsResponseLaunchTemplateVersionSetsLaunchTemplateVersionSetLaunchTemplateDataSystemDisk(TeaModel):
    def __init__(self, size=None, category=None, disk_name=None, description=None, iops=None):
        self.size = size
        self.category = category
        self.disk_name = disk_name
        self.description = description
        self.iops = iops

    def validate(self):
        self.validate_required(self.size, 'size')
        self.validate_required(self.category, 'category')
        self.validate_required(self.disk_name, 'disk_name')
        self.validate_required(self.description, 'description')
        self.validate_required(self.iops, 'iops')

    def to_map(self):
        result = {}
        result['Size'] = self.size
        result['Category'] = self.category
        result['DiskName'] = self.disk_name
        result['Description'] = self.description
        result['Iops'] = self.iops
        return result

    def from_map(self, map={}):
        self.size = map.get('Size')
        self.category = map.get('Category')
        self.disk_name = map.get('DiskName')
        self.description = map.get('Description')
        self.iops = map.get('Iops')
        return self


class DescribeLaunchTemplateVersionsResponseLaunchTemplateVersionSetsLaunchTemplateVersionSetLaunchTemplateDataDataDisksDataDisk(TeaModel):
    def __init__(self, size=None, snapshot_id=None, category=None, encrypted=None, disk_name=None, description=None,
                 delete_with_instance=None, device=None):
        self.size = size
        self.snapshot_id = snapshot_id
        self.category = category
        self.encrypted = encrypted
        self.disk_name = disk_name
        self.description = description
        self.delete_with_instance = delete_with_instance
        self.device = device

    def validate(self):
        self.validate_required(self.size, 'size')
        self.validate_required(self.snapshot_id, 'snapshot_id')
        self.validate_required(self.category, 'category')
        self.validate_required(self.encrypted, 'encrypted')
        self.validate_required(self.disk_name, 'disk_name')
        self.validate_required(self.description, 'description')
        self.validate_required(self.delete_with_instance, 'delete_with_instance')
        self.validate_required(self.device, 'device')

    def to_map(self):
        result = {}
        result['Size'] = self.size
        result['SnapshotId'] = self.snapshot_id
        result['Category'] = self.category
        result['Encrypted'] = self.encrypted
        result['DiskName'] = self.disk_name
        result['Description'] = self.description
        result['DeleteWithInstance'] = self.delete_with_instance
        result['Device'] = self.device
        return result

    def from_map(self, map={}):
        self.size = map.get('Size')
        self.snapshot_id = map.get('SnapshotId')
        self.category = map.get('Category')
        self.encrypted = map.get('Encrypted')
        self.disk_name = map.get('DiskName')
        self.description = map.get('Description')
        self.delete_with_instance = map.get('DeleteWithInstance')
        self.device = map.get('Device')
        return self


class DescribeLaunchTemplateVersionsResponseLaunchTemplateVersionSetsLaunchTemplateVersionSetLaunchTemplateDataDataDisks(TeaModel):
    def __init__(self, data_disk=None):
        self.data_disk = data_disk

    def validate(self):
        self.validate_required(self.data_disk, 'data_disk')
        if self.data_disk:
            for k in self.data_disk:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['DataDisk'] = []
        if self.data_disk is not None:
            for k in self.data_disk:
                result['DataDisk'].append(k.to_map() if k else None)
        else:
            result['DataDisk'] = None
        return result

    def from_map(self, map={}):
        self.data_disk = []
        if map.get('DataDisk') is not None:
            for k in map.get('DataDisk'):
                temp_model = DescribeLaunchTemplateVersionsResponseLaunchTemplateVersionSetsLaunchTemplateVersionSetLaunchTemplateDataDataDisksDataDisk()
                temp_model = temp_model.from_map(k)
                self.data_disk.append(temp_model)
        else:
            self.data_disk = None
        return self


class DescribeLaunchTemplateVersionsResponseLaunchTemplateVersionSetsLaunchTemplateVersionSetLaunchTemplateDataNetworkInterfacesNetworkInterface(TeaModel):
    def __init__(self, primary_ip_address=None, v_switch_id=None, security_group_id=None,
                 network_interface_name=None, description=None):
        self.primary_ip_address = primary_ip_address
        self.v_switch_id = v_switch_id
        self.security_group_id = security_group_id
        self.network_interface_name = network_interface_name
        self.description = description

    def validate(self):
        self.validate_required(self.primary_ip_address, 'primary_ip_address')
        self.validate_required(self.v_switch_id, 'v_switch_id')
        self.validate_required(self.security_group_id, 'security_group_id')
        self.validate_required(self.network_interface_name, 'network_interface_name')
        self.validate_required(self.description, 'description')

    def to_map(self):
        result = {}
        result['PrimaryIpAddress'] = self.primary_ip_address
        result['VSwitchId'] = self.v_switch_id
        result['SecurityGroupId'] = self.security_group_id
        result['NetworkInterfaceName'] = self.network_interface_name
        result['Description'] = self.description
        return result

    def from_map(self, map={}):
        self.primary_ip_address = map.get('PrimaryIpAddress')
        self.v_switch_id = map.get('VSwitchId')
        self.security_group_id = map.get('SecurityGroupId')
        self.network_interface_name = map.get('NetworkInterfaceName')
        self.description = map.get('Description')
        return self


class DescribeLaunchTemplateVersionsResponseLaunchTemplateVersionSetsLaunchTemplateVersionSetLaunchTemplateDataNetworkInterfaces(TeaModel):
    def __init__(self, network_interface=None):
        self.network_interface = network_interface

    def validate(self):
        self.validate_required(self.network_interface, 'network_interface')
        if self.network_interface:
            for k in self.network_interface:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['NetworkInterface'] = []
        if self.network_interface is not None:
            for k in self.network_interface:
                result['NetworkInterface'].append(k.to_map() if k else None)
        else:
            result['NetworkInterface'] = None
        return result

    def from_map(self, map={}):
        self.network_interface = []
        if map.get('NetworkInterface') is not None:
            for k in map.get('NetworkInterface'):
                temp_model = DescribeLaunchTemplateVersionsResponseLaunchTemplateVersionSetsLaunchTemplateVersionSetLaunchTemplateDataNetworkInterfacesNetworkInterface()
                temp_model = temp_model.from_map(k)
                self.network_interface.append(temp_model)
        else:
            self.network_interface = None
        return self


class DescribeLaunchTemplateVersionsResponseLaunchTemplateVersionSetsLaunchTemplateVersionSetLaunchTemplateDataTagsInstanceTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key
        self.value = value

    def validate(self):
        self.validate_required(self.key, 'key')
        self.validate_required(self.value, 'value')

    def to_map(self):
        result = {}
        result['Key'] = self.key
        result['Value'] = self.value
        return result

    def from_map(self, map={}):
        self.key = map.get('Key')
        self.value = map.get('Value')
        return self


class DescribeLaunchTemplateVersionsResponseLaunchTemplateVersionSetsLaunchTemplateVersionSetLaunchTemplateDataTags(TeaModel):
    def __init__(self, instance_tag=None):
        self.instance_tag = instance_tag

    def validate(self):
        self.validate_required(self.instance_tag, 'instance_tag')
        if self.instance_tag:
            for k in self.instance_tag:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['InstanceTag'] = []
        if self.instance_tag is not None:
            for k in self.instance_tag:
                result['InstanceTag'].append(k.to_map() if k else None)
        else:
            result['InstanceTag'] = None
        return result

    def from_map(self, map={}):
        self.instance_tag = []
        if map.get('InstanceTag') is not None:
            for k in map.get('InstanceTag'):
                temp_model = DescribeLaunchTemplateVersionsResponseLaunchTemplateVersionSetsLaunchTemplateVersionSetLaunchTemplateDataTagsInstanceTag()
                temp_model = temp_model.from_map(k)
                self.instance_tag.append(temp_model)
        else:
            self.instance_tag = None
        return self


class DescribeLaunchTemplateVersionsResponseLaunchTemplateVersionSetsLaunchTemplateVersionSetLaunchTemplateData(TeaModel):
    def __init__(self, image_id=None, image_owner_alias=None, password_inherit=None, instance_type=None,
                 security_group_id=None, vpc_id=None, v_switch_id=None, instance_name=None, description=None,
                 internet_max_bandwidth_in=None, internet_max_bandwidth_out=None, host_name=None, zone_id=None, io_optimized=None,
                 instance_charge_type=None, period=None, internet_charge_type=None, enable_vm_os_config=None, network_type=None,
                 user_data=None, key_pair_name=None, ram_role_name=None, auto_release_time=None, spot_strategy=None,
                 spot_price_limit=None, spot_duration=None, resource_group_id=None, security_enhancement_strategy=None,
                 system_disk=None, data_disks=None, network_interfaces=None, tags=None):
        self.image_id = image_id
        self.image_owner_alias = image_owner_alias
        self.password_inherit = password_inherit
        self.instance_type = instance_type
        self.security_group_id = security_group_id
        self.vpc_id = vpc_id
        self.v_switch_id = v_switch_id
        self.instance_name = instance_name
        self.description = description
        self.internet_max_bandwidth_in = internet_max_bandwidth_in
        self.internet_max_bandwidth_out = internet_max_bandwidth_out
        self.host_name = host_name
        self.zone_id = zone_id
        self.io_optimized = io_optimized
        self.instance_charge_type = instance_charge_type
        self.period = period
        self.internet_charge_type = internet_charge_type
        self.enable_vm_os_config = enable_vm_os_config
        self.network_type = network_type
        self.user_data = user_data
        self.key_pair_name = key_pair_name
        self.ram_role_name = ram_role_name
        self.auto_release_time = auto_release_time
        self.spot_strategy = spot_strategy
        self.spot_price_limit = spot_price_limit
        self.spot_duration = spot_duration
        self.resource_group_id = resource_group_id
        self.security_enhancement_strategy = security_enhancement_strategy
        self.system_disk = system_disk
        self.data_disks = data_disks
        self.network_interfaces = network_interfaces
        self.tags = tags

    def validate(self):
        self.validate_required(self.image_id, 'image_id')
        self.validate_required(self.image_owner_alias, 'image_owner_alias')
        self.validate_required(self.password_inherit, 'password_inherit')
        self.validate_required(self.instance_type, 'instance_type')
        self.validate_required(self.security_group_id, 'security_group_id')
        self.validate_required(self.vpc_id, 'vpc_id')
        self.validate_required(self.v_switch_id, 'v_switch_id')
        self.validate_required(self.instance_name, 'instance_name')
        self.validate_required(self.description, 'description')
        self.validate_required(self.internet_max_bandwidth_in, 'internet_max_bandwidth_in')
        self.validate_required(self.internet_max_bandwidth_out, 'internet_max_bandwidth_out')
        self.validate_required(self.host_name, 'host_name')
        self.validate_required(self.zone_id, 'zone_id')
        self.validate_required(self.io_optimized, 'io_optimized')
        self.validate_required(self.instance_charge_type, 'instance_charge_type')
        self.validate_required(self.period, 'period')
        self.validate_required(self.internet_charge_type, 'internet_charge_type')
        self.validate_required(self.enable_vm_os_config, 'enable_vm_os_config')
        self.validate_required(self.network_type, 'network_type')
        self.validate_required(self.user_data, 'user_data')
        self.validate_required(self.key_pair_name, 'key_pair_name')
        self.validate_required(self.ram_role_name, 'ram_role_name')
        self.validate_required(self.auto_release_time, 'auto_release_time')
        self.validate_required(self.spot_strategy, 'spot_strategy')
        self.validate_required(self.spot_price_limit, 'spot_price_limit')
        self.validate_required(self.spot_duration, 'spot_duration')
        self.validate_required(self.resource_group_id, 'resource_group_id')
        self.validate_required(self.security_enhancement_strategy, 'security_enhancement_strategy')
        self.validate_required(self.system_disk, 'system_disk')
        if self.system_disk:
            self.system_disk.validate()
        self.validate_required(self.data_disks, 'data_disks')
        if self.data_disks:
            self.data_disks.validate()
        self.validate_required(self.network_interfaces, 'network_interfaces')
        if self.network_interfaces:
            self.network_interfaces.validate()
        self.validate_required(self.tags, 'tags')
        if self.tags:
            self.tags.validate()

    def to_map(self):
        result = {}
        result['ImageId'] = self.image_id
        result['ImageOwnerAlias'] = self.image_owner_alias
        result['PasswordInherit'] = self.password_inherit
        result['InstanceType'] = self.instance_type
        result['SecurityGroupId'] = self.security_group_id
        result['VpcId'] = self.vpc_id
        result['VSwitchId'] = self.v_switch_id
        result['InstanceName'] = self.instance_name
        result['Description'] = self.description
        result['InternetMaxBandwidthIn'] = self.internet_max_bandwidth_in
        result['InternetMaxBandwidthOut'] = self.internet_max_bandwidth_out
        result['HostName'] = self.host_name
        result['ZoneId'] = self.zone_id
        result['IoOptimized'] = self.io_optimized
        result['InstanceChargeType'] = self.instance_charge_type
        result['Period'] = self.period
        result['InternetChargeType'] = self.internet_charge_type
        result['EnableVmOsConfig'] = self.enable_vm_os_config
        result['NetworkType'] = self.network_type
        result['UserData'] = self.user_data
        result['KeyPairName'] = self.key_pair_name
        result['RamRoleName'] = self.ram_role_name
        result['AutoReleaseTime'] = self.auto_release_time
        result['SpotStrategy'] = self.spot_strategy
        result['SpotPriceLimit'] = self.spot_price_limit
        result['SpotDuration'] = self.spot_duration
        result['ResourceGroupId'] = self.resource_group_id
        result['SecurityEnhancementStrategy'] = self.security_enhancement_strategy
        if self.system_disk is not None:
            result['SystemDisk'] = self.system_disk.to_map()
        else:
            result['SystemDisk'] = None
        if self.data_disks is not None:
            result['DataDisks'] = self.data_disks.to_map()
        else:
            result['DataDisks'] = None
        if self.network_interfaces is not None:
            result['NetworkInterfaces'] = self.network_interfaces.to_map()
        else:
            result['NetworkInterfaces'] = None
        if self.tags is not None:
            result['Tags'] = self.tags.to_map()
        else:
            result['Tags'] = None
        return result

    def from_map(self, map={}):
        self.image_id = map.get('ImageId')
        self.image_owner_alias = map.get('ImageOwnerAlias')
        self.password_inherit = map.get('PasswordInherit')
        self.instance_type = map.get('InstanceType')
        self.security_group_id = map.get('SecurityGroupId')
        self.vpc_id = map.get('VpcId')
        self.v_switch_id = map.get('VSwitchId')
        self.instance_name = map.get('InstanceName')
        self.description = map.get('Description')
        self.internet_max_bandwidth_in = map.get('InternetMaxBandwidthIn')
        self.internet_max_bandwidth_out = map.get('InternetMaxBandwidthOut')
        self.host_name = map.get('HostName')
        self.zone_id = map.get('ZoneId')
        self.io_optimized = map.get('IoOptimized')
        self.instance_charge_type = map.get('InstanceChargeType')
        self.period = map.get('Period')
        self.internet_charge_type = map.get('InternetChargeType')
        self.enable_vm_os_config = map.get('EnableVmOsConfig')
        self.network_type = map.get('NetworkType')
        self.user_data = map.get('UserData')
        self.key_pair_name = map.get('KeyPairName')
        self.ram_role_name = map.get('RamRoleName')
        self.auto_release_time = map.get('AutoReleaseTime')
        self.spot_strategy = map.get('SpotStrategy')
        self.spot_price_limit = map.get('SpotPriceLimit')
        self.spot_duration = map.get('SpotDuration')
        self.resource_group_id = map.get('ResourceGroupId')
        self.security_enhancement_strategy = map.get('SecurityEnhancementStrategy')
        if map.get('SystemDisk') is not None:
            temp_model = DescribeLaunchTemplateVersionsResponseLaunchTemplateVersionSetsLaunchTemplateVersionSetLaunchTemplateDataSystemDisk()
            self.system_disk = temp_model.from_map(map['SystemDisk'])
        else:
            self.system_disk = None
        if map.get('DataDisks') is not None:
            temp_model = DescribeLaunchTemplateVersionsResponseLaunchTemplateVersionSetsLaunchTemplateVersionSetLaunchTemplateDataDataDisks()
            self.data_disks = temp_model.from_map(map['DataDisks'])
        else:
            self.data_disks = None
        if map.get('NetworkInterfaces') is not None:
            temp_model = DescribeLaunchTemplateVersionsResponseLaunchTemplateVersionSetsLaunchTemplateVersionSetLaunchTemplateDataNetworkInterfaces()
            self.network_interfaces = temp_model.from_map(map['NetworkInterfaces'])
        else:
            self.network_interfaces = None
        if map.get('Tags') is not None:
            temp_model = DescribeLaunchTemplateVersionsResponseLaunchTemplateVersionSetsLaunchTemplateVersionSetLaunchTemplateDataTags()
            self.tags = temp_model.from_map(map['Tags'])
        else:
            self.tags = None
        return self


class DescribeLaunchTemplateVersionsResponseLaunchTemplateVersionSetsLaunchTemplateVersionSet(TeaModel):
    def __init__(self, create_time=None, modified_time=None, launch_template_id=None, launch_template_name=None,
                 default_version=None, version_number=None, version_description=None, created_by=None, launch_template_data=None):
        self.create_time = create_time
        self.modified_time = modified_time
        self.launch_template_id = launch_template_id
        self.launch_template_name = launch_template_name
        self.default_version = default_version
        self.version_number = version_number
        self.version_description = version_description
        self.created_by = created_by
        self.launch_template_data = launch_template_data

    def validate(self):
        self.validate_required(self.create_time, 'create_time')
        self.validate_required(self.modified_time, 'modified_time')
        self.validate_required(self.launch_template_id, 'launch_template_id')
        self.validate_required(self.launch_template_name, 'launch_template_name')
        self.validate_required(self.default_version, 'default_version')
        self.validate_required(self.version_number, 'version_number')
        self.validate_required(self.version_description, 'version_description')
        self.validate_required(self.created_by, 'created_by')
        self.validate_required(self.launch_template_data, 'launch_template_data')
        if self.launch_template_data:
            self.launch_template_data.validate()

    def to_map(self):
        result = {}
        result['CreateTime'] = self.create_time
        result['ModifiedTime'] = self.modified_time
        result['LaunchTemplateId'] = self.launch_template_id
        result['LaunchTemplateName'] = self.launch_template_name
        result['DefaultVersion'] = self.default_version
        result['VersionNumber'] = self.version_number
        result['VersionDescription'] = self.version_description
        result['CreatedBy'] = self.created_by
        if self.launch_template_data is not None:
            result['LaunchTemplateData'] = self.launch_template_data.to_map()
        else:
            result['LaunchTemplateData'] = None
        return result

    def from_map(self, map={}):
        self.create_time = map.get('CreateTime')
        self.modified_time = map.get('ModifiedTime')
        self.launch_template_id = map.get('LaunchTemplateId')
        self.launch_template_name = map.get('LaunchTemplateName')
        self.default_version = map.get('DefaultVersion')
        self.version_number = map.get('VersionNumber')
        self.version_description = map.get('VersionDescription')
        self.created_by = map.get('CreatedBy')
        if map.get('LaunchTemplateData') is not None:
            temp_model = DescribeLaunchTemplateVersionsResponseLaunchTemplateVersionSetsLaunchTemplateVersionSetLaunchTemplateData()
            self.launch_template_data = temp_model.from_map(map['LaunchTemplateData'])
        else:
            self.launch_template_data = None
        return self


class DescribeLaunchTemplateVersionsResponseLaunchTemplateVersionSets(TeaModel):
    def __init__(self, launch_template_version_set=None):
        self.launch_template_version_set = launch_template_version_set

    def validate(self):
        self.validate_required(self.launch_template_version_set, 'launch_template_version_set')
        if self.launch_template_version_set:
            for k in self.launch_template_version_set:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['LaunchTemplateVersionSet'] = []
        if self.launch_template_version_set is not None:
            for k in self.launch_template_version_set:
                result['LaunchTemplateVersionSet'].append(k.to_map() if k else None)
        else:
            result['LaunchTemplateVersionSet'] = None
        return result

    def from_map(self, map={}):
        self.launch_template_version_set = []
        if map.get('LaunchTemplateVersionSet') is not None:
            for k in map.get('LaunchTemplateVersionSet'):
                temp_model = DescribeLaunchTemplateVersionsResponseLaunchTemplateVersionSetsLaunchTemplateVersionSet()
                temp_model = temp_model.from_map(k)
                self.launch_template_version_set.append(temp_model)
        else:
            self.launch_template_version_set = None
        return self
class DeleteLaunchTemplateVersionRequest(TeaModel):
    def __init__(self, region_id=None, launch_template_id=None, launch_template_name=None, delete_version=None):
        self.region_id = region_id
        self.launch_template_id = launch_template_id
        self.launch_template_name = launch_template_name
        self.delete_version = delete_version

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.delete_version, 'delete_version')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['LaunchTemplateId'] = self.launch_template_id
        result['LaunchTemplateName'] = self.launch_template_name
        result['DeleteVersion'] = []
        if self.delete_version is not None:
            for k in self.delete_version:
                result['DeleteVersion'].append(k)
        else:
            result['DeleteVersion'] = None
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.launch_template_id = map.get('LaunchTemplateId')
        self.launch_template_name = map.get('LaunchTemplateName')
        self.delete_version = []
        if map.get('DeleteVersion') is not None:
            for k in map.get('DeleteVersion'):
                self.delete_version.append(k)
        else:
            self.delete_version = None
        return self


class DeleteLaunchTemplateVersionResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class DeleteLaunchTemplateRequest(TeaModel):
    def __init__(self, region_id=None, launch_template_id=None, launch_template_name=None):
        self.region_id = region_id
        self.launch_template_id = launch_template_id
        self.launch_template_name = launch_template_name

    def validate(self):
        self.validate_required(self.region_id, 'region_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['LaunchTemplateId'] = self.launch_template_id
        result['LaunchTemplateName'] = self.launch_template_name
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.launch_template_id = map.get('LaunchTemplateId')
        self.launch_template_name = map.get('LaunchTemplateName')
        return self


class DeleteLaunchTemplateResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class CreateLaunchTemplateVersionRequest(TeaModel):
    def __init__(self, region_id=None, launch_template_id=None, launch_template_name=None,
                 version_description=None, image_id=None, image_owner_alias=None, password_inherit=None, instance_type=None,
                 security_group_id=None, vpc_id=None, v_switch_id=None, instance_name=None, description=None,
                 internet_max_bandwidth_in=None, internet_max_bandwidth_out=None, host_name=None, zone_id=None, system_disk=None,
                 data_disk=None, io_optimized=None, network_interface=None, instance_charge_type=None, period=None,
                 internet_charge_type=None, enable_vm_os_config=None, network_type=None, user_data=None, key_pair_name=None,
                 ram_role_name=None, auto_release_time=None, spot_strategy=None, spot_price_limit=None, spot_duration=None,
                 resource_group_id=None, security_enhancement_strategy=None, tag=None):
        self.region_id = region_id
        self.launch_template_id = launch_template_id
        self.launch_template_name = launch_template_name
        self.version_description = version_description
        self.image_id = image_id
        self.image_owner_alias = image_owner_alias
        self.password_inherit = password_inherit
        self.instance_type = instance_type
        self.security_group_id = security_group_id
        self.vpc_id = vpc_id
        self.v_switch_id = v_switch_id
        self.instance_name = instance_name
        self.description = description
        self.internet_max_bandwidth_in = internet_max_bandwidth_in
        self.internet_max_bandwidth_out = internet_max_bandwidth_out
        self.host_name = host_name
        self.zone_id = zone_id
        self.system_disk = system_disk
        self.data_disk = data_disk
        self.io_optimized = io_optimized
        self.network_interface = network_interface
        self.instance_charge_type = instance_charge_type
        self.period = period
        self.internet_charge_type = internet_charge_type
        self.enable_vm_os_config = enable_vm_os_config
        self.network_type = network_type
        self.user_data = user_data
        self.key_pair_name = key_pair_name
        self.ram_role_name = ram_role_name
        self.auto_release_time = auto_release_time
        self.spot_strategy = spot_strategy
        self.spot_price_limit = spot_price_limit
        self.spot_duration = spot_duration
        self.resource_group_id = resource_group_id
        self.security_enhancement_strategy = security_enhancement_strategy
        self.tag = tag

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        if self.system_disk:
            self.system_disk.validate()
        if self.data_disk:
            for k in self.data_disk:
                if k:
                    k.validate()
        if self.network_interface:
            for k in self.network_interface:
                if k:
                    k.validate()
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['LaunchTemplateId'] = self.launch_template_id
        result['LaunchTemplateName'] = self.launch_template_name
        result['VersionDescription'] = self.version_description
        result['ImageId'] = self.image_id
        result['ImageOwnerAlias'] = self.image_owner_alias
        result['PasswordInherit'] = self.password_inherit
        result['InstanceType'] = self.instance_type
        result['SecurityGroupId'] = self.security_group_id
        result['VpcId'] = self.vpc_id
        result['VSwitchId'] = self.v_switch_id
        result['InstanceName'] = self.instance_name
        result['Description'] = self.description
        result['InternetMaxBandwidthIn'] = self.internet_max_bandwidth_in
        result['InternetMaxBandwidthOut'] = self.internet_max_bandwidth_out
        result['HostName'] = self.host_name
        result['ZoneId'] = self.zone_id
        if self.system_disk is not None:
            result['SystemDisk'] = self.system_disk.to_map()
        else:
            result['SystemDisk'] = None
        result['DataDisk'] = []
        if self.data_disk is not None:
            for k in self.data_disk:
                result['DataDisk'].append(k.to_map() if k else None)
        else:
            result['DataDisk'] = None
        result['IoOptimized'] = self.io_optimized
        result['NetworkInterface'] = []
        if self.network_interface is not None:
            for k in self.network_interface:
                result['NetworkInterface'].append(k.to_map() if k else None)
        else:
            result['NetworkInterface'] = None
        result['InstanceChargeType'] = self.instance_charge_type
        result['Period'] = self.period
        result['InternetChargeType'] = self.internet_charge_type
        result['EnableVmOsConfig'] = self.enable_vm_os_config
        result['NetworkType'] = self.network_type
        result['UserData'] = self.user_data
        result['KeyPairName'] = self.key_pair_name
        result['RamRoleName'] = self.ram_role_name
        result['AutoReleaseTime'] = self.auto_release_time
        result['SpotStrategy'] = self.spot_strategy
        result['SpotPriceLimit'] = self.spot_price_limit
        result['SpotDuration'] = self.spot_duration
        result['ResourceGroupId'] = self.resource_group_id
        result['SecurityEnhancementStrategy'] = self.security_enhancement_strategy
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        else:
            result['Tag'] = None
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.launch_template_id = map.get('LaunchTemplateId')
        self.launch_template_name = map.get('LaunchTemplateName')
        self.version_description = map.get('VersionDescription')
        self.image_id = map.get('ImageId')
        self.image_owner_alias = map.get('ImageOwnerAlias')
        self.password_inherit = map.get('PasswordInherit')
        self.instance_type = map.get('InstanceType')
        self.security_group_id = map.get('SecurityGroupId')
        self.vpc_id = map.get('VpcId')
        self.v_switch_id = map.get('VSwitchId')
        self.instance_name = map.get('InstanceName')
        self.description = map.get('Description')
        self.internet_max_bandwidth_in = map.get('InternetMaxBandwidthIn')
        self.internet_max_bandwidth_out = map.get('InternetMaxBandwidthOut')
        self.host_name = map.get('HostName')
        self.zone_id = map.get('ZoneId')
        if map.get('SystemDisk') is not None:
            temp_model = CreateLaunchTemplateVersionRequestSystemDisk()
            self.system_disk = temp_model.from_map(map['SystemDisk'])
        else:
            self.system_disk = None
        self.data_disk = []
        if map.get('DataDisk') is not None:
            for k in map.get('DataDisk'):
                temp_model = CreateLaunchTemplateVersionRequestDataDisk()
                temp_model = temp_model.from_map(k)
                self.data_disk.append(temp_model)
        else:
            self.data_disk = None
        self.io_optimized = map.get('IoOptimized')
        self.network_interface = []
        if map.get('NetworkInterface') is not None:
            for k in map.get('NetworkInterface'):
                temp_model = CreateLaunchTemplateVersionRequestNetworkInterface()
                temp_model = temp_model.from_map(k)
                self.network_interface.append(temp_model)
        else:
            self.network_interface = None
        self.instance_charge_type = map.get('InstanceChargeType')
        self.period = map.get('Period')
        self.internet_charge_type = map.get('InternetChargeType')
        self.enable_vm_os_config = map.get('EnableVmOsConfig')
        self.network_type = map.get('NetworkType')
        self.user_data = map.get('UserData')
        self.key_pair_name = map.get('KeyPairName')
        self.ram_role_name = map.get('RamRoleName')
        self.auto_release_time = map.get('AutoReleaseTime')
        self.spot_strategy = map.get('SpotStrategy')
        self.spot_price_limit = map.get('SpotPriceLimit')
        self.spot_duration = map.get('SpotDuration')
        self.resource_group_id = map.get('ResourceGroupId')
        self.security_enhancement_strategy = map.get('SecurityEnhancementStrategy')
        self.tag = []
        if map.get('Tag') is not None:
            for k in map.get('Tag'):
                temp_model = CreateLaunchTemplateVersionRequestTag()
                temp_model = temp_model.from_map(k)
                self.tag.append(temp_model)
        else:
            self.tag = None
        return self


class CreateLaunchTemplateVersionRequestSystemDisk(TeaModel):
    def __init__(self, category=None, size=None, disk_name=None, description=None, iops=None):
        self.category = category
        self.size = size
        self.disk_name = disk_name
        self.description = description
        self.iops = iops

    def validate(self):
        pass

    def to_map(self):
        result = {}
        result['Category'] = self.category
        result['Size'] = self.size
        result['DiskName'] = self.disk_name
        result['Description'] = self.description
        result['Iops'] = self.iops
        return result

    def from_map(self, map={}):
        self.category = map.get('Category')
        self.size = map.get('Size')
        self.disk_name = map.get('DiskName')
        self.description = map.get('Description')
        self.iops = map.get('Iops')
        return self


class CreateLaunchTemplateVersionRequestDataDisk(TeaModel):
    def __init__(self, size=None, snapshot_id=None, category=None, encrypted=None, disk_name=None, description=None,
                 delete_with_instance=None, device=None):
        self.size = size
        self.snapshot_id = snapshot_id
        self.category = category
        self.encrypted = encrypted
        self.disk_name = disk_name
        self.description = description
        self.delete_with_instance = delete_with_instance
        self.device = device

    def validate(self):
        self.validate_required(self.size, 'size')
        self.validate_required(self.snapshot_id, 'snapshot_id')
        self.validate_required(self.category, 'category')
        self.validate_required(self.encrypted, 'encrypted')
        self.validate_required(self.disk_name, 'disk_name')
        self.validate_required(self.description, 'description')
        self.validate_required(self.delete_with_instance, 'delete_with_instance')
        self.validate_required(self.device, 'device')

    def to_map(self):
        result = {}
        result['Size'] = self.size
        result['SnapshotId'] = self.snapshot_id
        result['Category'] = self.category
        result['Encrypted'] = self.encrypted
        result['DiskName'] = self.disk_name
        result['Description'] = self.description
        result['DeleteWithInstance'] = self.delete_with_instance
        result['Device'] = self.device
        return result

    def from_map(self, map={}):
        self.size = map.get('Size')
        self.snapshot_id = map.get('SnapshotId')
        self.category = map.get('Category')
        self.encrypted = map.get('Encrypted')
        self.disk_name = map.get('DiskName')
        self.description = map.get('Description')
        self.delete_with_instance = map.get('DeleteWithInstance')
        self.device = map.get('Device')
        return self


class CreateLaunchTemplateVersionRequestNetworkInterface(TeaModel):
    def __init__(self, primary_ip_address=None, v_switch_id=None, security_group_id=None,
                 network_interface_name=None, description=None):
        self.primary_ip_address = primary_ip_address
        self.v_switch_id = v_switch_id
        self.security_group_id = security_group_id
        self.network_interface_name = network_interface_name
        self.description = description

    def validate(self):
        self.validate_required(self.primary_ip_address, 'primary_ip_address')
        self.validate_required(self.v_switch_id, 'v_switch_id')
        self.validate_required(self.security_group_id, 'security_group_id')
        self.validate_required(self.network_interface_name, 'network_interface_name')
        self.validate_required(self.description, 'description')

    def to_map(self):
        result = {}
        result['PrimaryIpAddress'] = self.primary_ip_address
        result['VSwitchId'] = self.v_switch_id
        result['SecurityGroupId'] = self.security_group_id
        result['NetworkInterfaceName'] = self.network_interface_name
        result['Description'] = self.description
        return result

    def from_map(self, map={}):
        self.primary_ip_address = map.get('PrimaryIpAddress')
        self.v_switch_id = map.get('VSwitchId')
        self.security_group_id = map.get('SecurityGroupId')
        self.network_interface_name = map.get('NetworkInterfaceName')
        self.description = map.get('Description')
        return self


class CreateLaunchTemplateVersionRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key
        self.value = value

    def validate(self):
        self.validate_required(self.key, 'key')
        self.validate_required(self.value, 'value')

    def to_map(self):
        result = {}
        result['Key'] = self.key
        result['Value'] = self.value
        return result

    def from_map(self, map={}):
        self.key = map.get('Key')
        self.value = map.get('Value')
        return self
class CreateLaunchTemplateVersionResponse(TeaModel):
    def __init__(self, request_id=None, launch_template_version_number=None):
        self.request_id = request_id
        self.launch_template_version_number = launch_template_version_number

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.launch_template_version_number, 'launch_template_version_number')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['LaunchTemplateVersionNumber'] = self.launch_template_version_number
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.launch_template_version_number = map.get('LaunchTemplateVersionNumber')
        return self


class CreateLaunchTemplateRequest(TeaModel):
    def __init__(self, region_id=None, template_tag=None, launch_template_name=None, version_description=None,
                 image_id=None, image_owner_alias=None, password_inherit=None, instance_type=None, security_group_id=None,
                 vpc_id=None, v_switch_id=None, instance_name=None, description=None, internet_max_bandwidth_in=None,
                 internet_max_bandwidth_out=None, host_name=None, zone_id=None, system_disk=None, data_disk=None, io_optimized=None,
                 network_interface=None, instance_charge_type=None, period=None, internet_charge_type=None, enable_vm_os_config=None,
                 network_type=None, user_data=None, key_pair_name=None, ram_role_name=None, auto_release_time=None,
                 spot_strategy=None, spot_price_limit=None, spot_duration=None, resource_group_id=None,
                 template_resource_group_id=None, security_enhancement_strategy=None, tag=None):
        self.region_id = region_id
        self.template_tag = template_tag
        self.launch_template_name = launch_template_name
        self.version_description = version_description
        self.image_id = image_id
        self.image_owner_alias = image_owner_alias
        self.password_inherit = password_inherit
        self.instance_type = instance_type
        self.security_group_id = security_group_id
        self.vpc_id = vpc_id
        self.v_switch_id = v_switch_id
        self.instance_name = instance_name
        self.description = description
        self.internet_max_bandwidth_in = internet_max_bandwidth_in
        self.internet_max_bandwidth_out = internet_max_bandwidth_out
        self.host_name = host_name
        self.zone_id = zone_id
        self.system_disk = system_disk
        self.data_disk = data_disk
        self.io_optimized = io_optimized
        self.network_interface = network_interface
        self.instance_charge_type = instance_charge_type
        self.period = period
        self.internet_charge_type = internet_charge_type
        self.enable_vm_os_config = enable_vm_os_config
        self.network_type = network_type
        self.user_data = user_data
        self.key_pair_name = key_pair_name
        self.ram_role_name = ram_role_name
        self.auto_release_time = auto_release_time
        self.spot_strategy = spot_strategy
        self.spot_price_limit = spot_price_limit
        self.spot_duration = spot_duration
        self.resource_group_id = resource_group_id
        self.template_resource_group_id = template_resource_group_id
        self.security_enhancement_strategy = security_enhancement_strategy
        self.tag = tag

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        if self.template_tag:
            for k in self.template_tag:
                if k:
                    k.validate()
        self.validate_required(self.launch_template_name, 'launch_template_name')
        if self.system_disk:
            self.system_disk.validate()
        if self.data_disk:
            for k in self.data_disk:
                if k:
                    k.validate()
        if self.network_interface:
            for k in self.network_interface:
                if k:
                    k.validate()
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['TemplateTag'] = []
        if self.template_tag is not None:
            for k in self.template_tag:
                result['TemplateTag'].append(k.to_map() if k else None)
        else:
            result['TemplateTag'] = None
        result['LaunchTemplateName'] = self.launch_template_name
        result['VersionDescription'] = self.version_description
        result['ImageId'] = self.image_id
        result['ImageOwnerAlias'] = self.image_owner_alias
        result['PasswordInherit'] = self.password_inherit
        result['InstanceType'] = self.instance_type
        result['SecurityGroupId'] = self.security_group_id
        result['VpcId'] = self.vpc_id
        result['VSwitchId'] = self.v_switch_id
        result['InstanceName'] = self.instance_name
        result['Description'] = self.description
        result['InternetMaxBandwidthIn'] = self.internet_max_bandwidth_in
        result['InternetMaxBandwidthOut'] = self.internet_max_bandwidth_out
        result['HostName'] = self.host_name
        result['ZoneId'] = self.zone_id
        if self.system_disk is not None:
            result['SystemDisk'] = self.system_disk.to_map()
        else:
            result['SystemDisk'] = None
        result['DataDisk'] = []
        if self.data_disk is not None:
            for k in self.data_disk:
                result['DataDisk'].append(k.to_map() if k else None)
        else:
            result['DataDisk'] = None
        result['IoOptimized'] = self.io_optimized
        result['NetworkInterface'] = []
        if self.network_interface is not None:
            for k in self.network_interface:
                result['NetworkInterface'].append(k.to_map() if k else None)
        else:
            result['NetworkInterface'] = None
        result['InstanceChargeType'] = self.instance_charge_type
        result['Period'] = self.period
        result['InternetChargeType'] = self.internet_charge_type
        result['EnableVmOsConfig'] = self.enable_vm_os_config
        result['NetworkType'] = self.network_type
        result['UserData'] = self.user_data
        result['KeyPairName'] = self.key_pair_name
        result['RamRoleName'] = self.ram_role_name
        result['AutoReleaseTime'] = self.auto_release_time
        result['SpotStrategy'] = self.spot_strategy
        result['SpotPriceLimit'] = self.spot_price_limit
        result['SpotDuration'] = self.spot_duration
        result['ResourceGroupId'] = self.resource_group_id
        result['TemplateResourceGroupId'] = self.template_resource_group_id
        result['SecurityEnhancementStrategy'] = self.security_enhancement_strategy
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        else:
            result['Tag'] = None
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.template_tag = []
        if map.get('TemplateTag') is not None:
            for k in map.get('TemplateTag'):
                temp_model = CreateLaunchTemplateRequestTemplateTag()
                temp_model = temp_model.from_map(k)
                self.template_tag.append(temp_model)
        else:
            self.template_tag = None
        self.launch_template_name = map.get('LaunchTemplateName')
        self.version_description = map.get('VersionDescription')
        self.image_id = map.get('ImageId')
        self.image_owner_alias = map.get('ImageOwnerAlias')
        self.password_inherit = map.get('PasswordInherit')
        self.instance_type = map.get('InstanceType')
        self.security_group_id = map.get('SecurityGroupId')
        self.vpc_id = map.get('VpcId')
        self.v_switch_id = map.get('VSwitchId')
        self.instance_name = map.get('InstanceName')
        self.description = map.get('Description')
        self.internet_max_bandwidth_in = map.get('InternetMaxBandwidthIn')
        self.internet_max_bandwidth_out = map.get('InternetMaxBandwidthOut')
        self.host_name = map.get('HostName')
        self.zone_id = map.get('ZoneId')
        if map.get('SystemDisk') is not None:
            temp_model = CreateLaunchTemplateRequestSystemDisk()
            self.system_disk = temp_model.from_map(map['SystemDisk'])
        else:
            self.system_disk = None
        self.data_disk = []
        if map.get('DataDisk') is not None:
            for k in map.get('DataDisk'):
                temp_model = CreateLaunchTemplateRequestDataDisk()
                temp_model = temp_model.from_map(k)
                self.data_disk.append(temp_model)
        else:
            self.data_disk = None
        self.io_optimized = map.get('IoOptimized')
        self.network_interface = []
        if map.get('NetworkInterface') is not None:
            for k in map.get('NetworkInterface'):
                temp_model = CreateLaunchTemplateRequestNetworkInterface()
                temp_model = temp_model.from_map(k)
                self.network_interface.append(temp_model)
        else:
            self.network_interface = None
        self.instance_charge_type = map.get('InstanceChargeType')
        self.period = map.get('Period')
        self.internet_charge_type = map.get('InternetChargeType')
        self.enable_vm_os_config = map.get('EnableVmOsConfig')
        self.network_type = map.get('NetworkType')
        self.user_data = map.get('UserData')
        self.key_pair_name = map.get('KeyPairName')
        self.ram_role_name = map.get('RamRoleName')
        self.auto_release_time = map.get('AutoReleaseTime')
        self.spot_strategy = map.get('SpotStrategy')
        self.spot_price_limit = map.get('SpotPriceLimit')
        self.spot_duration = map.get('SpotDuration')
        self.resource_group_id = map.get('ResourceGroupId')
        self.template_resource_group_id = map.get('TemplateResourceGroupId')
        self.security_enhancement_strategy = map.get('SecurityEnhancementStrategy')
        self.tag = []
        if map.get('Tag') is not None:
            for k in map.get('Tag'):
                temp_model = CreateLaunchTemplateRequestTag()
                temp_model = temp_model.from_map(k)
                self.tag.append(temp_model)
        else:
            self.tag = None
        return self


class CreateLaunchTemplateRequestTemplateTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key
        self.value = value

    def validate(self):
        self.validate_required(self.key, 'key')
        self.validate_required(self.value, 'value')

    def to_map(self):
        result = {}
        result['Key'] = self.key
        result['Value'] = self.value
        return result

    def from_map(self, map={}):
        self.key = map.get('Key')
        self.value = map.get('Value')
        return self


class CreateLaunchTemplateRequestSystemDisk(TeaModel):
    def __init__(self, category=None, size=None, disk_name=None, description=None, iops=None):
        self.category = category
        self.size = size
        self.disk_name = disk_name
        self.description = description
        self.iops = iops

    def validate(self):
        pass

    def to_map(self):
        result = {}
        result['Category'] = self.category
        result['Size'] = self.size
        result['DiskName'] = self.disk_name
        result['Description'] = self.description
        result['Iops'] = self.iops
        return result

    def from_map(self, map={}):
        self.category = map.get('Category')
        self.size = map.get('Size')
        self.disk_name = map.get('DiskName')
        self.description = map.get('Description')
        self.iops = map.get('Iops')
        return self


class CreateLaunchTemplateRequestDataDisk(TeaModel):
    def __init__(self, size=None, snapshot_id=None, category=None, encrypted=None, disk_name=None, description=None,
                 delete_with_instance=None, device=None):
        self.size = size
        self.snapshot_id = snapshot_id
        self.category = category
        self.encrypted = encrypted
        self.disk_name = disk_name
        self.description = description
        self.delete_with_instance = delete_with_instance
        self.device = device

    def validate(self):
        self.validate_required(self.size, 'size')
        self.validate_required(self.snapshot_id, 'snapshot_id')
        self.validate_required(self.category, 'category')
        self.validate_required(self.encrypted, 'encrypted')
        self.validate_required(self.disk_name, 'disk_name')
        self.validate_required(self.description, 'description')
        self.validate_required(self.delete_with_instance, 'delete_with_instance')
        self.validate_required(self.device, 'device')

    def to_map(self):
        result = {}
        result['Size'] = self.size
        result['SnapshotId'] = self.snapshot_id
        result['Category'] = self.category
        result['Encrypted'] = self.encrypted
        result['DiskName'] = self.disk_name
        result['Description'] = self.description
        result['DeleteWithInstance'] = self.delete_with_instance
        result['Device'] = self.device
        return result

    def from_map(self, map={}):
        self.size = map.get('Size')
        self.snapshot_id = map.get('SnapshotId')
        self.category = map.get('Category')
        self.encrypted = map.get('Encrypted')
        self.disk_name = map.get('DiskName')
        self.description = map.get('Description')
        self.delete_with_instance = map.get('DeleteWithInstance')
        self.device = map.get('Device')
        return self


class CreateLaunchTemplateRequestNetworkInterface(TeaModel):
    def __init__(self, primary_ip_address=None, v_switch_id=None, security_group_id=None,
                 network_interface_name=None, description=None):
        self.primary_ip_address = primary_ip_address
        self.v_switch_id = v_switch_id
        self.security_group_id = security_group_id
        self.network_interface_name = network_interface_name
        self.description = description

    def validate(self):
        self.validate_required(self.primary_ip_address, 'primary_ip_address')
        self.validate_required(self.v_switch_id, 'v_switch_id')
        self.validate_required(self.security_group_id, 'security_group_id')
        self.validate_required(self.network_interface_name, 'network_interface_name')
        self.validate_required(self.description, 'description')

    def to_map(self):
        result = {}
        result['PrimaryIpAddress'] = self.primary_ip_address
        result['VSwitchId'] = self.v_switch_id
        result['SecurityGroupId'] = self.security_group_id
        result['NetworkInterfaceName'] = self.network_interface_name
        result['Description'] = self.description
        return result

    def from_map(self, map={}):
        self.primary_ip_address = map.get('PrimaryIpAddress')
        self.v_switch_id = map.get('VSwitchId')
        self.security_group_id = map.get('SecurityGroupId')
        self.network_interface_name = map.get('NetworkInterfaceName')
        self.description = map.get('Description')
        return self


class CreateLaunchTemplateRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key
        self.value = value

    def validate(self):
        self.validate_required(self.key, 'key')
        self.validate_required(self.value, 'value')

    def to_map(self):
        result = {}
        result['Key'] = self.key
        result['Value'] = self.value
        return result

    def from_map(self, map={}):
        self.key = map.get('Key')
        self.value = map.get('Value')
        return self
class CreateLaunchTemplateResponse(TeaModel):
    def __init__(self, request_id=None, launch_template_id=None):
        self.request_id = request_id
        self.launch_template_id = launch_template_id

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.launch_template_id, 'launch_template_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['LaunchTemplateId'] = self.launch_template_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.launch_template_id = map.get('LaunchTemplateId')
        return self


class InstallCloudAssistantRequest(TeaModel):
    def __init__(self, region_id=None, instance_id=None):
        self.region_id = region_id
        self.instance_id = instance_id

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['InstanceId'] = []
        if self.instance_id is not None:
            for k in self.instance_id:
                result['InstanceId'].append(k)
        else:
            result['InstanceId'] = None
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.instance_id = []
        if map.get('InstanceId') is not None:
            for k in map.get('InstanceId'):
                self.instance_id.append(k)
        else:
            self.instance_id = None
        return self


class InstallCloudAssistantResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class DescribeCloudAssistantStatusRequest(TeaModel):
    def __init__(self, region_id=None, instance_id=None):
        self.region_id = region_id
        self.instance_id = instance_id

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['InstanceId'] = []
        if self.instance_id is not None:
            for k in self.instance_id:
                result['InstanceId'].append(k)
        else:
            result['InstanceId'] = None
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.instance_id = []
        if map.get('InstanceId') is not None:
            for k in map.get('InstanceId'):
                self.instance_id.append(k)
        else:
            self.instance_id = None
        return self


class DescribeCloudAssistantStatusResponse(TeaModel):
    def __init__(self, request_id=None, instance_cloud_assistant_status_set=None):
        self.request_id = request_id
        self.instance_cloud_assistant_status_set = instance_cloud_assistant_status_set

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.instance_cloud_assistant_status_set, 'instance_cloud_assistant_status_set')
        if self.instance_cloud_assistant_status_set:
            self.instance_cloud_assistant_status_set.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        if self.instance_cloud_assistant_status_set is not None:
            result['InstanceCloudAssistantStatusSet'] = self.instance_cloud_assistant_status_set.to_map()
        else:
            result['InstanceCloudAssistantStatusSet'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        if map.get('InstanceCloudAssistantStatusSet') is not None:
            temp_model = DescribeCloudAssistantStatusResponseInstanceCloudAssistantStatusSet()
            self.instance_cloud_assistant_status_set = temp_model.from_map(map['InstanceCloudAssistantStatusSet'])
        else:
            self.instance_cloud_assistant_status_set = None
        return self


class DescribeCloudAssistantStatusResponseInstanceCloudAssistantStatusSetInstanceCloudAssistantStatus(TeaModel):
    def __init__(self, instance_id=None, cloud_assistant_status=None, cloud_assistant_version=None):
        self.instance_id = instance_id
        self.cloud_assistant_status = cloud_assistant_status
        self.cloud_assistant_version = cloud_assistant_version

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.cloud_assistant_status, 'cloud_assistant_status')
        self.validate_required(self.cloud_assistant_version, 'cloud_assistant_version')

    def to_map(self):
        result = {}
        result['InstanceId'] = self.instance_id
        result['CloudAssistantStatus'] = self.cloud_assistant_status
        result['CloudAssistantVersion'] = self.cloud_assistant_version
        return result

    def from_map(self, map={}):
        self.instance_id = map.get('InstanceId')
        self.cloud_assistant_status = map.get('CloudAssistantStatus')
        self.cloud_assistant_version = map.get('CloudAssistantVersion')
        return self


class DescribeCloudAssistantStatusResponseInstanceCloudAssistantStatusSet(TeaModel):
    def __init__(self, instance_cloud_assistant_status=None):
        self.instance_cloud_assistant_status = instance_cloud_assistant_status

    def validate(self):
        self.validate_required(self.instance_cloud_assistant_status, 'instance_cloud_assistant_status')
        if self.instance_cloud_assistant_status:
            for k in self.instance_cloud_assistant_status:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['InstanceCloudAssistantStatus'] = []
        if self.instance_cloud_assistant_status is not None:
            for k in self.instance_cloud_assistant_status:
                result['InstanceCloudAssistantStatus'].append(k.to_map() if k else None)
        else:
            result['InstanceCloudAssistantStatus'] = None
        return result

    def from_map(self, map={}):
        self.instance_cloud_assistant_status = []
        if map.get('InstanceCloudAssistantStatus') is not None:
            for k in map.get('InstanceCloudAssistantStatus'):
                temp_model = DescribeCloudAssistantStatusResponseInstanceCloudAssistantStatusSetInstanceCloudAssistantStatus()
                temp_model = temp_model.from_map(k)
                self.instance_cloud_assistant_status.append(temp_model)
        else:
            self.instance_cloud_assistant_status = None
        return self
class UnassignPrivateIpAddressesRequest(TeaModel):
    def __init__(self, region_id=None, network_interface_id=None, private_ip_address=None):
        self.region_id = region_id
        self.network_interface_id = network_interface_id
        self.private_ip_address = private_ip_address

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.network_interface_id, 'network_interface_id')
        self.validate_required(self.private_ip_address, 'private_ip_address')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['NetworkInterfaceId'] = self.network_interface_id
        result['PrivateIpAddress'] = []
        if self.private_ip_address is not None:
            for k in self.private_ip_address:
                result['PrivateIpAddress'].append(k)
        else:
            result['PrivateIpAddress'] = None
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.network_interface_id = map.get('NetworkInterfaceId')
        self.private_ip_address = []
        if map.get('PrivateIpAddress') is not None:
            for k in map.get('PrivateIpAddress'):
                self.private_ip_address.append(k)
        else:
            self.private_ip_address = None
        return self


class UnassignPrivateIpAddressesResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class AssignPrivateIpAddressesRequest(TeaModel):
    def __init__(self, region_id=None, network_interface_id=None, private_ip_address=None,
                 secondary_private_ip_address_count=None, client_token=None):
        self.region_id = region_id
        self.network_interface_id = network_interface_id
        self.private_ip_address = private_ip_address
        self.secondary_private_ip_address_count = secondary_private_ip_address_count
        self.client_token = client_token

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.network_interface_id, 'network_interface_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['NetworkInterfaceId'] = self.network_interface_id
        result['PrivateIpAddress'] = []
        if self.private_ip_address is not None:
            for k in self.private_ip_address:
                result['PrivateIpAddress'].append(k)
        else:
            result['PrivateIpAddress'] = None
        result['SecondaryPrivateIpAddressCount'] = self.secondary_private_ip_address_count
        result['ClientToken'] = self.client_token
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.network_interface_id = map.get('NetworkInterfaceId')
        self.private_ip_address = []
        if map.get('PrivateIpAddress') is not None:
            for k in map.get('PrivateIpAddress'):
                self.private_ip_address.append(k)
        else:
            self.private_ip_address = None
        self.secondary_private_ip_address_count = map.get('SecondaryPrivateIpAddressCount')
        self.client_token = map.get('ClientToken')
        return self


class AssignPrivateIpAddressesResponse(TeaModel):
    def __init__(self, request_id=None, assigned_private_ip_addresses_set=None):
        self.request_id = request_id
        self.assigned_private_ip_addresses_set = assigned_private_ip_addresses_set

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.assigned_private_ip_addresses_set, 'assigned_private_ip_addresses_set')
        if self.assigned_private_ip_addresses_set:
            self.assigned_private_ip_addresses_set.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        if self.assigned_private_ip_addresses_set is not None:
            result['AssignedPrivateIpAddressesSet'] = self.assigned_private_ip_addresses_set.to_map()
        else:
            result['AssignedPrivateIpAddressesSet'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        if map.get('AssignedPrivateIpAddressesSet') is not None:
            temp_model = AssignPrivateIpAddressesResponseAssignedPrivateIpAddressesSet()
            self.assigned_private_ip_addresses_set = temp_model.from_map(map['AssignedPrivateIpAddressesSet'])
        else:
            self.assigned_private_ip_addresses_set = None
        return self


class AssignPrivateIpAddressesResponseAssignedPrivateIpAddressesSetPrivateIpSet(TeaModel):
    def __init__(self, private_ip_address=None):
        # PrivateIpAddress
        self.private_ip_address = private_ip_address

    def validate(self):
        self.validate_required(self.private_ip_address, 'private_ip_address')

    def to_map(self):
        result = {}
        result['PrivateIpAddress'] = []
        if self.private_ip_address is not None:
            for k in self.private_ip_address:
                result['PrivateIpAddress'].append(k)
        else:
            result['PrivateIpAddress'] = None
        return result

    def from_map(self, map={}):
        self.private_ip_address = []
        if map.get('PrivateIpAddress') is not None:
            for k in map.get('PrivateIpAddress'):
                self.private_ip_address.append(k)
        else:
            self.private_ip_address = None
        return self


class AssignPrivateIpAddressesResponseAssignedPrivateIpAddressesSet(TeaModel):
    def __init__(self, network_interface_id=None, private_ip_set=None):
        self.network_interface_id = network_interface_id
        self.private_ip_set = private_ip_set

    def validate(self):
        self.validate_required(self.network_interface_id, 'network_interface_id')
        self.validate_required(self.private_ip_set, 'private_ip_set')
        if self.private_ip_set:
            self.private_ip_set.validate()

    def to_map(self):
        result = {}
        result['NetworkInterfaceId'] = self.network_interface_id
        if self.private_ip_set is not None:
            result['PrivateIpSet'] = self.private_ip_set.to_map()
        else:
            result['PrivateIpSet'] = None
        return result

    def from_map(self, map={}):
        self.network_interface_id = map.get('NetworkInterfaceId')
        if map.get('PrivateIpSet') is not None:
            temp_model = AssignPrivateIpAddressesResponseAssignedPrivateIpAddressesSetPrivateIpSet()
            self.private_ip_set = temp_model.from_map(map['PrivateIpSet'])
        else:
            self.private_ip_set = None
        return self
class DescribeNetworkInterfacePermissionsRequest(TeaModel):
    def __init__(self, region_id=None, network_interface_id=None, network_interface_permission_id=None,
                 page_number=None, page_size=None):
        self.region_id = region_id
        self.network_interface_id = network_interface_id
        self.network_interface_permission_id = network_interface_permission_id
        self.page_number = page_number
        self.page_size = page_size

    def validate(self):
        self.validate_required(self.region_id, 'region_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['NetworkInterfaceId'] = self.network_interface_id
        result['NetworkInterfacePermissionId'] = []
        if self.network_interface_permission_id is not None:
            for k in self.network_interface_permission_id:
                result['NetworkInterfacePermissionId'].append(k)
        else:
            result['NetworkInterfacePermissionId'] = None
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.network_interface_id = map.get('NetworkInterfaceId')
        self.network_interface_permission_id = []
        if map.get('NetworkInterfacePermissionId') is not None:
            for k in map.get('NetworkInterfacePermissionId'):
                self.network_interface_permission_id.append(k)
        else:
            self.network_interface_permission_id = None
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        return self


class DescribeNetworkInterfacePermissionsResponse(TeaModel):
    def __init__(self, request_id=None, total_count=None, page_number=None, page_size=None,
                 network_interface_permissions=None):
        self.request_id = request_id
        self.total_count = total_count
        self.page_number = page_number
        self.page_size = page_size
        self.network_interface_permissions = network_interface_permissions

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.page_number, 'page_number')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.network_interface_permissions, 'network_interface_permissions')
        if self.network_interface_permissions:
            self.network_interface_permissions.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['TotalCount'] = self.total_count
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        if self.network_interface_permissions is not None:
            result['NetworkInterfacePermissions'] = self.network_interface_permissions.to_map()
        else:
            result['NetworkInterfacePermissions'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.total_count = map.get('TotalCount')
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        if map.get('NetworkInterfacePermissions') is not None:
            temp_model = DescribeNetworkInterfacePermissionsResponseNetworkInterfacePermissions()
            self.network_interface_permissions = temp_model.from_map(map['NetworkInterfacePermissions'])
        else:
            self.network_interface_permissions = None
        return self


class DescribeNetworkInterfacePermissionsResponseNetworkInterfacePermissionsNetworkInterfacePermission(TeaModel):
    def __init__(self, account_id=None, service_name=None, network_interface_id=None,
                 network_interface_permission_id=None, permission=None, permission_state=None):
        self.account_id = account_id
        self.service_name = service_name
        self.network_interface_id = network_interface_id
        self.network_interface_permission_id = network_interface_permission_id
        self.permission = permission
        self.permission_state = permission_state

    def validate(self):
        self.validate_required(self.account_id, 'account_id')
        self.validate_required(self.service_name, 'service_name')
        self.validate_required(self.network_interface_id, 'network_interface_id')
        self.validate_required(self.network_interface_permission_id, 'network_interface_permission_id')
        self.validate_required(self.permission, 'permission')
        self.validate_required(self.permission_state, 'permission_state')

    def to_map(self):
        result = {}
        result['AccountId'] = self.account_id
        result['ServiceName'] = self.service_name
        result['NetworkInterfaceId'] = self.network_interface_id
        result['NetworkInterfacePermissionId'] = self.network_interface_permission_id
        result['Permission'] = self.permission
        result['PermissionState'] = self.permission_state
        return result

    def from_map(self, map={}):
        self.account_id = map.get('AccountId')
        self.service_name = map.get('ServiceName')
        self.network_interface_id = map.get('NetworkInterfaceId')
        self.network_interface_permission_id = map.get('NetworkInterfacePermissionId')
        self.permission = map.get('Permission')
        self.permission_state = map.get('PermissionState')
        return self


class DescribeNetworkInterfacePermissionsResponseNetworkInterfacePermissions(TeaModel):
    def __init__(self, network_interface_permission=None):
        self.network_interface_permission = network_interface_permission

    def validate(self):
        self.validate_required(self.network_interface_permission, 'network_interface_permission')
        if self.network_interface_permission:
            for k in self.network_interface_permission:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['NetworkInterfacePermission'] = []
        if self.network_interface_permission is not None:
            for k in self.network_interface_permission:
                result['NetworkInterfacePermission'].append(k.to_map() if k else None)
        else:
            result['NetworkInterfacePermission'] = None
        return result

    def from_map(self, map={}):
        self.network_interface_permission = []
        if map.get('NetworkInterfacePermission') is not None:
            for k in map.get('NetworkInterfacePermission'):
                temp_model = DescribeNetworkInterfacePermissionsResponseNetworkInterfacePermissionsNetworkInterfacePermission()
                temp_model = temp_model.from_map(k)
                self.network_interface_permission.append(temp_model)
        else:
            self.network_interface_permission = None
        return self
class DeleteNetworkInterfacePermissionRequest(TeaModel):
    def __init__(self, region_id=None, network_interface_permission_id=None, force=None):
        self.region_id = region_id
        self.network_interface_permission_id = network_interface_permission_id
        self.force = force

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.network_interface_permission_id, 'network_interface_permission_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['NetworkInterfacePermissionId'] = self.network_interface_permission_id
        result['Force'] = self.force
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.network_interface_permission_id = map.get('NetworkInterfacePermissionId')
        self.force = map.get('Force')
        return self


class DeleteNetworkInterfacePermissionResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class CreateNetworkInterfacePermissionRequest(TeaModel):
    def __init__(self, region_id=None, account_id=None, network_interface_id=None, permission=None):
        self.region_id = region_id
        self.account_id = account_id
        self.network_interface_id = network_interface_id
        self.permission = permission

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.account_id, 'account_id')
        self.validate_required(self.network_interface_id, 'network_interface_id')
        self.validate_required(self.permission, 'permission')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['AccountId'] = self.account_id
        result['NetworkInterfaceId'] = self.network_interface_id
        result['Permission'] = self.permission
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.account_id = map.get('AccountId')
        self.network_interface_id = map.get('NetworkInterfaceId')
        self.permission = map.get('Permission')
        return self


class CreateNetworkInterfacePermissionResponse(TeaModel):
    def __init__(self, request_id=None, network_interface_permission=None):
        self.request_id = request_id
        self.network_interface_permission = network_interface_permission

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.network_interface_permission, 'network_interface_permission')
        if self.network_interface_permission:
            self.network_interface_permission.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        if self.network_interface_permission is not None:
            result['NetworkInterfacePermission'] = self.network_interface_permission.to_map()
        else:
            result['NetworkInterfacePermission'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        if map.get('NetworkInterfacePermission') is not None:
            temp_model = CreateNetworkInterfacePermissionResponseNetworkInterfacePermission()
            self.network_interface_permission = temp_model.from_map(map['NetworkInterfacePermission'])
        else:
            self.network_interface_permission = None
        return self


class CreateNetworkInterfacePermissionResponseNetworkInterfacePermission(TeaModel):
    def __init__(self, account_id=None, service_name=None, network_interface_id=None,
                 network_interface_permission_id=None, permission=None, permission_state=None):
        self.account_id = account_id
        self.service_name = service_name
        self.network_interface_id = network_interface_id
        self.network_interface_permission_id = network_interface_permission_id
        self.permission = permission
        self.permission_state = permission_state

    def validate(self):
        self.validate_required(self.account_id, 'account_id')
        self.validate_required(self.service_name, 'service_name')
        self.validate_required(self.network_interface_id, 'network_interface_id')
        self.validate_required(self.network_interface_permission_id, 'network_interface_permission_id')
        self.validate_required(self.permission, 'permission')
        self.validate_required(self.permission_state, 'permission_state')

    def to_map(self):
        result = {}
        result['AccountId'] = self.account_id
        result['ServiceName'] = self.service_name
        result['NetworkInterfaceId'] = self.network_interface_id
        result['NetworkInterfacePermissionId'] = self.network_interface_permission_id
        result['Permission'] = self.permission
        result['PermissionState'] = self.permission_state
        return result

    def from_map(self, map={}):
        self.account_id = map.get('AccountId')
        self.service_name = map.get('ServiceName')
        self.network_interface_id = map.get('NetworkInterfaceId')
        self.network_interface_permission_id = map.get('NetworkInterfacePermissionId')
        self.permission = map.get('Permission')
        self.permission_state = map.get('PermissionState')
        return self
class GetInstanceScreenshotRequest(TeaModel):
    def __init__(self, region_id=None, instance_id=None, wake_up=None):
        self.region_id = region_id
        self.instance_id = instance_id
        self.wake_up = wake_up

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['InstanceId'] = self.instance_id
        result['WakeUp'] = self.wake_up
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.instance_id = map.get('InstanceId')
        self.wake_up = map.get('WakeUp')
        return self


class GetInstanceScreenshotResponse(TeaModel):
    def __init__(self, request_id=None, instance_id=None, screenshot=None):
        self.request_id = request_id
        self.instance_id = instance_id
        self.screenshot = screenshot

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.screenshot, 'screenshot')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['InstanceId'] = self.instance_id
        result['Screenshot'] = self.screenshot
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.instance_id = map.get('InstanceId')
        self.screenshot = map.get('Screenshot')
        return self


class GetInstanceConsoleOutputRequest(TeaModel):
    def __init__(self, region_id=None, instance_id=None, remove_symbols=None):
        self.region_id = region_id
        self.instance_id = instance_id
        self.remove_symbols = remove_symbols

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['InstanceId'] = self.instance_id
        result['RemoveSymbols'] = self.remove_symbols
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.instance_id = map.get('InstanceId')
        self.remove_symbols = map.get('RemoveSymbols')
        return self


class GetInstanceConsoleOutputResponse(TeaModel):
    def __init__(self, request_id=None, instance_id=None, console_output=None, last_update_time=None):
        self.request_id = request_id
        self.instance_id = instance_id
        self.console_output = console_output
        self.last_update_time = last_update_time

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.console_output, 'console_output')
        self.validate_required(self.last_update_time, 'last_update_time')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['InstanceId'] = self.instance_id
        result['ConsoleOutput'] = self.console_output
        result['LastUpdateTime'] = self.last_update_time
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.instance_id = map.get('InstanceId')
        self.console_output = map.get('ConsoleOutput')
        self.last_update_time = map.get('LastUpdateTime')
        return self


class DescribeResourcesModificationRequest(TeaModel):
    def __init__(self, region_id=None, resource_id=None, migrate_across_zone=None, destination_resource=None,
                 operation_type=None, instance_type=None, cores=None, memory=None):
        self.region_id = region_id
        self.resource_id = resource_id
        self.migrate_across_zone = migrate_across_zone
        self.destination_resource = destination_resource
        self.operation_type = operation_type
        self.instance_type = instance_type
        self.cores = cores
        self.memory = memory

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.resource_id, 'resource_id')
        self.validate_required(self.destination_resource, 'destination_resource')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['ResourceId'] = self.resource_id
        result['MigrateAcrossZone'] = self.migrate_across_zone
        result['DestinationResource'] = self.destination_resource
        result['OperationType'] = self.operation_type
        result['InstanceType'] = self.instance_type
        result['Cores'] = self.cores
        result['Memory'] = self.memory
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.resource_id = map.get('ResourceId')
        self.migrate_across_zone = map.get('MigrateAcrossZone')
        self.destination_resource = map.get('DestinationResource')
        self.operation_type = map.get('OperationType')
        self.instance_type = map.get('InstanceType')
        self.cores = map.get('Cores')
        self.memory = map.get('Memory')
        return self


class DescribeResourcesModificationResponse(TeaModel):
    def __init__(self, request_id=None, available_zones=None):
        self.request_id = request_id
        self.available_zones = available_zones

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.available_zones, 'available_zones')
        if self.available_zones:
            self.available_zones.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        if self.available_zones is not None:
            result['AvailableZones'] = self.available_zones.to_map()
        else:
            result['AvailableZones'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        if map.get('AvailableZones') is not None:
            temp_model = DescribeResourcesModificationResponseAvailableZones()
            self.available_zones = temp_model.from_map(map['AvailableZones'])
        else:
            self.available_zones = None
        return self


class DescribeResourcesModificationResponseAvailableZonesAvailableZoneAvailableResourcesAvailableResourceSupportedResourcesSupportedResource(TeaModel):
    def __init__(self, value=None, status=None, status_category=None, min=None, max=None, unit=None):
        self.value = value
        self.status = status
        self.status_category = status_category
        self.min = min
        self.max = max
        self.unit = unit

    def validate(self):
        self.validate_required(self.value, 'value')
        self.validate_required(self.status, 'status')
        self.validate_required(self.status_category, 'status_category')
        self.validate_required(self.min, 'min')
        self.validate_required(self.max, 'max')
        self.validate_required(self.unit, 'unit')

    def to_map(self):
        result = {}
        result['Value'] = self.value
        result['Status'] = self.status
        result['StatusCategory'] = self.status_category
        result['Min'] = self.min
        result['Max'] = self.max
        result['Unit'] = self.unit
        return result

    def from_map(self, map={}):
        self.value = map.get('Value')
        self.status = map.get('Status')
        self.status_category = map.get('StatusCategory')
        self.min = map.get('Min')
        self.max = map.get('Max')
        self.unit = map.get('Unit')
        return self


class DescribeResourcesModificationResponseAvailableZonesAvailableZoneAvailableResourcesAvailableResourceSupportedResources(TeaModel):
    def __init__(self, supported_resource=None):
        self.supported_resource = supported_resource

    def validate(self):
        self.validate_required(self.supported_resource, 'supported_resource')
        if self.supported_resource:
            for k in self.supported_resource:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['SupportedResource'] = []
        if self.supported_resource is not None:
            for k in self.supported_resource:
                result['SupportedResource'].append(k.to_map() if k else None)
        else:
            result['SupportedResource'] = None
        return result

    def from_map(self, map={}):
        self.supported_resource = []
        if map.get('SupportedResource') is not None:
            for k in map.get('SupportedResource'):
                temp_model = DescribeResourcesModificationResponseAvailableZonesAvailableZoneAvailableResourcesAvailableResourceSupportedResourcesSupportedResource()
                temp_model = temp_model.from_map(k)
                self.supported_resource.append(temp_model)
        else:
            self.supported_resource = None
        return self


class DescribeResourcesModificationResponseAvailableZonesAvailableZoneAvailableResourcesAvailableResource(TeaModel):
    def __init__(self, type=None, supported_resources=None):
        self.type = type
        self.supported_resources = supported_resources

    def validate(self):
        self.validate_required(self.type, 'type')
        self.validate_required(self.supported_resources, 'supported_resources')
        if self.supported_resources:
            self.supported_resources.validate()

    def to_map(self):
        result = {}
        result['Type'] = self.type
        if self.supported_resources is not None:
            result['SupportedResources'] = self.supported_resources.to_map()
        else:
            result['SupportedResources'] = None
        return result

    def from_map(self, map={}):
        self.type = map.get('Type')
        if map.get('SupportedResources') is not None:
            temp_model = DescribeResourcesModificationResponseAvailableZonesAvailableZoneAvailableResourcesAvailableResourceSupportedResources()
            self.supported_resources = temp_model.from_map(map['SupportedResources'])
        else:
            self.supported_resources = None
        return self


class DescribeResourcesModificationResponseAvailableZonesAvailableZoneAvailableResources(TeaModel):
    def __init__(self, available_resource=None):
        self.available_resource = available_resource

    def validate(self):
        self.validate_required(self.available_resource, 'available_resource')
        if self.available_resource:
            for k in self.available_resource:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['AvailableResource'] = []
        if self.available_resource is not None:
            for k in self.available_resource:
                result['AvailableResource'].append(k.to_map() if k else None)
        else:
            result['AvailableResource'] = None
        return result

    def from_map(self, map={}):
        self.available_resource = []
        if map.get('AvailableResource') is not None:
            for k in map.get('AvailableResource'):
                temp_model = DescribeResourcesModificationResponseAvailableZonesAvailableZoneAvailableResourcesAvailableResource()
                temp_model = temp_model.from_map(k)
                self.available_resource.append(temp_model)
        else:
            self.available_resource = None
        return self


class DescribeResourcesModificationResponseAvailableZonesAvailableZone(TeaModel):
    def __init__(self, region_id=None, zone_id=None, status=None, status_category=None, available_resources=None):
        self.region_id = region_id
        self.zone_id = zone_id
        self.status = status
        self.status_category = status_category
        self.available_resources = available_resources

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.zone_id, 'zone_id')
        self.validate_required(self.status, 'status')
        self.validate_required(self.status_category, 'status_category')
        self.validate_required(self.available_resources, 'available_resources')
        if self.available_resources:
            self.available_resources.validate()

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['ZoneId'] = self.zone_id
        result['Status'] = self.status
        result['StatusCategory'] = self.status_category
        if self.available_resources is not None:
            result['AvailableResources'] = self.available_resources.to_map()
        else:
            result['AvailableResources'] = None
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.zone_id = map.get('ZoneId')
        self.status = map.get('Status')
        self.status_category = map.get('StatusCategory')
        if map.get('AvailableResources') is not None:
            temp_model = DescribeResourcesModificationResponseAvailableZonesAvailableZoneAvailableResources()
            self.available_resources = temp_model.from_map(map['AvailableResources'])
        else:
            self.available_resources = None
        return self


class DescribeResourcesModificationResponseAvailableZones(TeaModel):
    def __init__(self, available_zone=None):
        self.available_zone = available_zone

    def validate(self):
        self.validate_required(self.available_zone, 'available_zone')
        if self.available_zone:
            for k in self.available_zone:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['AvailableZone'] = []
        if self.available_zone is not None:
            for k in self.available_zone:
                result['AvailableZone'].append(k.to_map() if k else None)
        else:
            result['AvailableZone'] = None
        return result

    def from_map(self, map={}):
        self.available_zone = []
        if map.get('AvailableZone') is not None:
            for k in map.get('AvailableZone'):
                temp_model = DescribeResourcesModificationResponseAvailableZonesAvailableZone()
                temp_model = temp_model.from_map(k)
                self.available_zone.append(temp_model)
        else:
            self.available_zone = None
        return self
class DescribeBandwidthLimitationRequest(TeaModel):
    def __init__(self, region_id=None, instance_charge_type=None, spot_strategy=None, instance_type=None,
                 resource_id=None, operation_type=None):
        self.region_id = region_id
        self.instance_charge_type = instance_charge_type
        self.spot_strategy = spot_strategy
        self.instance_type = instance_type
        self.resource_id = resource_id
        self.operation_type = operation_type

    def validate(self):
        self.validate_required(self.region_id, 'region_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['InstanceChargeType'] = self.instance_charge_type
        result['SpotStrategy'] = self.spot_strategy
        result['InstanceType'] = self.instance_type
        result['ResourceId'] = self.resource_id
        result['OperationType'] = self.operation_type
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.instance_charge_type = map.get('InstanceChargeType')
        self.spot_strategy = map.get('SpotStrategy')
        self.instance_type = map.get('InstanceType')
        self.resource_id = map.get('ResourceId')
        self.operation_type = map.get('OperationType')
        return self


class DescribeBandwidthLimitationResponse(TeaModel):
    def __init__(self, request_id=None, bandwidths=None):
        self.request_id = request_id
        self.bandwidths = bandwidths

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.bandwidths, 'bandwidths')
        if self.bandwidths:
            self.bandwidths.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        if self.bandwidths is not None:
            result['Bandwidths'] = self.bandwidths.to_map()
        else:
            result['Bandwidths'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        if map.get('Bandwidths') is not None:
            temp_model = DescribeBandwidthLimitationResponseBandwidths()
            self.bandwidths = temp_model.from_map(map['Bandwidths'])
        else:
            self.bandwidths = None
        return self


class DescribeBandwidthLimitationResponseBandwidthsBandwidth(TeaModel):
    def __init__(self, internet_charge_type=None, min=None, max=None, unit=None):
        self.internet_charge_type = internet_charge_type
        self.min = min
        self.max = max
        self.unit = unit

    def validate(self):
        self.validate_required(self.internet_charge_type, 'internet_charge_type')
        self.validate_required(self.min, 'min')
        self.validate_required(self.max, 'max')
        self.validate_required(self.unit, 'unit')

    def to_map(self):
        result = {}
        result['InternetChargeType'] = self.internet_charge_type
        result['Min'] = self.min
        result['Max'] = self.max
        result['Unit'] = self.unit
        return result

    def from_map(self, map={}):
        self.internet_charge_type = map.get('InternetChargeType')
        self.min = map.get('Min')
        self.max = map.get('Max')
        self.unit = map.get('Unit')
        return self


class DescribeBandwidthLimitationResponseBandwidths(TeaModel):
    def __init__(self, bandwidth=None):
        self.bandwidth = bandwidth

    def validate(self):
        self.validate_required(self.bandwidth, 'bandwidth')
        if self.bandwidth:
            for k in self.bandwidth:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['Bandwidth'] = []
        if self.bandwidth is not None:
            for k in self.bandwidth:
                result['Bandwidth'].append(k.to_map() if k else None)
        else:
            result['Bandwidth'] = None
        return result

    def from_map(self, map={}):
        self.bandwidth = []
        if map.get('Bandwidth') is not None:
            for k in map.get('Bandwidth'):
                temp_model = DescribeBandwidthLimitationResponseBandwidthsBandwidth()
                temp_model = temp_model.from_map(k)
                self.bandwidth.append(temp_model)
        else:
            self.bandwidth = None
        return self
class DescribeAvailableResourceRequest(TeaModel):
    def __init__(self, region_id=None, instance_charge_type=None, spot_strategy=None, spot_duration=None,
                 destination_resource=None, zone_id=None, io_optimized=None, dedicated_host_id=None, instance_type=None,
                 system_disk_category=None, data_disk_category=None, network_category=None, cores=None, memory=None, resource_type=None,
                 scope=None):
        self.region_id = region_id
        self.instance_charge_type = instance_charge_type
        self.spot_strategy = spot_strategy
        self.spot_duration = spot_duration
        self.destination_resource = destination_resource
        self.zone_id = zone_id
        self.io_optimized = io_optimized
        self.dedicated_host_id = dedicated_host_id
        self.instance_type = instance_type
        self.system_disk_category = system_disk_category
        self.data_disk_category = data_disk_category
        self.network_category = network_category
        self.cores = cores
        self.memory = memory
        self.resource_type = resource_type
        self.scope = scope

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.destination_resource, 'destination_resource')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['InstanceChargeType'] = self.instance_charge_type
        result['SpotStrategy'] = self.spot_strategy
        result['SpotDuration'] = self.spot_duration
        result['DestinationResource'] = self.destination_resource
        result['ZoneId'] = self.zone_id
        result['IoOptimized'] = self.io_optimized
        result['DedicatedHostId'] = self.dedicated_host_id
        result['InstanceType'] = self.instance_type
        result['SystemDiskCategory'] = self.system_disk_category
        result['DataDiskCategory'] = self.data_disk_category
        result['NetworkCategory'] = self.network_category
        result['Cores'] = self.cores
        result['Memory'] = self.memory
        result['ResourceType'] = self.resource_type
        result['Scope'] = self.scope
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.instance_charge_type = map.get('InstanceChargeType')
        self.spot_strategy = map.get('SpotStrategy')
        self.spot_duration = map.get('SpotDuration')
        self.destination_resource = map.get('DestinationResource')
        self.zone_id = map.get('ZoneId')
        self.io_optimized = map.get('IoOptimized')
        self.dedicated_host_id = map.get('DedicatedHostId')
        self.instance_type = map.get('InstanceType')
        self.system_disk_category = map.get('SystemDiskCategory')
        self.data_disk_category = map.get('DataDiskCategory')
        self.network_category = map.get('NetworkCategory')
        self.cores = map.get('Cores')
        self.memory = map.get('Memory')
        self.resource_type = map.get('ResourceType')
        self.scope = map.get('Scope')
        return self


class DescribeAvailableResourceResponse(TeaModel):
    def __init__(self, request_id=None, available_zones=None):
        self.request_id = request_id
        self.available_zones = available_zones

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.available_zones, 'available_zones')
        if self.available_zones:
            self.available_zones.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        if self.available_zones is not None:
            result['AvailableZones'] = self.available_zones.to_map()
        else:
            result['AvailableZones'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        if map.get('AvailableZones') is not None:
            temp_model = DescribeAvailableResourceResponseAvailableZones()
            self.available_zones = temp_model.from_map(map['AvailableZones'])
        else:
            self.available_zones = None
        return self


class DescribeAvailableResourceResponseAvailableZonesAvailableZoneAvailableResourcesAvailableResourceSupportedResourcesSupportedResource(TeaModel):
    def __init__(self, value=None, status=None, status_category=None, min=None, max=None, unit=None):
        self.value = value
        self.status = status
        self.status_category = status_category
        self.min = min
        self.max = max
        self.unit = unit

    def validate(self):
        self.validate_required(self.value, 'value')
        self.validate_required(self.status, 'status')
        self.validate_required(self.status_category, 'status_category')
        self.validate_required(self.min, 'min')
        self.validate_required(self.max, 'max')
        self.validate_required(self.unit, 'unit')

    def to_map(self):
        result = {}
        result['Value'] = self.value
        result['Status'] = self.status
        result['StatusCategory'] = self.status_category
        result['Min'] = self.min
        result['Max'] = self.max
        result['Unit'] = self.unit
        return result

    def from_map(self, map={}):
        self.value = map.get('Value')
        self.status = map.get('Status')
        self.status_category = map.get('StatusCategory')
        self.min = map.get('Min')
        self.max = map.get('Max')
        self.unit = map.get('Unit')
        return self


class DescribeAvailableResourceResponseAvailableZonesAvailableZoneAvailableResourcesAvailableResourceSupportedResources(TeaModel):
    def __init__(self, supported_resource=None):
        self.supported_resource = supported_resource

    def validate(self):
        self.validate_required(self.supported_resource, 'supported_resource')
        if self.supported_resource:
            for k in self.supported_resource:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['SupportedResource'] = []
        if self.supported_resource is not None:
            for k in self.supported_resource:
                result['SupportedResource'].append(k.to_map() if k else None)
        else:
            result['SupportedResource'] = None
        return result

    def from_map(self, map={}):
        self.supported_resource = []
        if map.get('SupportedResource') is not None:
            for k in map.get('SupportedResource'):
                temp_model = DescribeAvailableResourceResponseAvailableZonesAvailableZoneAvailableResourcesAvailableResourceSupportedResourcesSupportedResource()
                temp_model = temp_model.from_map(k)
                self.supported_resource.append(temp_model)
        else:
            self.supported_resource = None
        return self


class DescribeAvailableResourceResponseAvailableZonesAvailableZoneAvailableResourcesAvailableResource(TeaModel):
    def __init__(self, type=None, supported_resources=None):
        self.type = type
        self.supported_resources = supported_resources

    def validate(self):
        self.validate_required(self.type, 'type')
        self.validate_required(self.supported_resources, 'supported_resources')
        if self.supported_resources:
            self.supported_resources.validate()

    def to_map(self):
        result = {}
        result['Type'] = self.type
        if self.supported_resources is not None:
            result['SupportedResources'] = self.supported_resources.to_map()
        else:
            result['SupportedResources'] = None
        return result

    def from_map(self, map={}):
        self.type = map.get('Type')
        if map.get('SupportedResources') is not None:
            temp_model = DescribeAvailableResourceResponseAvailableZonesAvailableZoneAvailableResourcesAvailableResourceSupportedResources()
            self.supported_resources = temp_model.from_map(map['SupportedResources'])
        else:
            self.supported_resources = None
        return self


class DescribeAvailableResourceResponseAvailableZonesAvailableZoneAvailableResources(TeaModel):
    def __init__(self, available_resource=None):
        self.available_resource = available_resource

    def validate(self):
        self.validate_required(self.available_resource, 'available_resource')
        if self.available_resource:
            for k in self.available_resource:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['AvailableResource'] = []
        if self.available_resource is not None:
            for k in self.available_resource:
                result['AvailableResource'].append(k.to_map() if k else None)
        else:
            result['AvailableResource'] = None
        return result

    def from_map(self, map={}):
        self.available_resource = []
        if map.get('AvailableResource') is not None:
            for k in map.get('AvailableResource'):
                temp_model = DescribeAvailableResourceResponseAvailableZonesAvailableZoneAvailableResourcesAvailableResource()
                temp_model = temp_model.from_map(k)
                self.available_resource.append(temp_model)
        else:
            self.available_resource = None
        return self


class DescribeAvailableResourceResponseAvailableZonesAvailableZone(TeaModel):
    def __init__(self, region_id=None, zone_id=None, status=None, status_category=None, available_resources=None):
        self.region_id = region_id
        self.zone_id = zone_id
        self.status = status
        self.status_category = status_category
        self.available_resources = available_resources

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.zone_id, 'zone_id')
        self.validate_required(self.status, 'status')
        self.validate_required(self.status_category, 'status_category')
        self.validate_required(self.available_resources, 'available_resources')
        if self.available_resources:
            self.available_resources.validate()

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['ZoneId'] = self.zone_id
        result['Status'] = self.status
        result['StatusCategory'] = self.status_category
        if self.available_resources is not None:
            result['AvailableResources'] = self.available_resources.to_map()
        else:
            result['AvailableResources'] = None
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.zone_id = map.get('ZoneId')
        self.status = map.get('Status')
        self.status_category = map.get('StatusCategory')
        if map.get('AvailableResources') is not None:
            temp_model = DescribeAvailableResourceResponseAvailableZonesAvailableZoneAvailableResources()
            self.available_resources = temp_model.from_map(map['AvailableResources'])
        else:
            self.available_resources = None
        return self


class DescribeAvailableResourceResponseAvailableZones(TeaModel):
    def __init__(self, available_zone=None):
        self.available_zone = available_zone

    def validate(self):
        self.validate_required(self.available_zone, 'available_zone')
        if self.available_zone:
            for k in self.available_zone:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['AvailableZone'] = []
        if self.available_zone is not None:
            for k in self.available_zone:
                result['AvailableZone'].append(k.to_map() if k else None)
        else:
            result['AvailableZone'] = None
        return result

    def from_map(self, map={}):
        self.available_zone = []
        if map.get('AvailableZone') is not None:
            for k in map.get('AvailableZone'):
                temp_model = DescribeAvailableResourceResponseAvailableZonesAvailableZone()
                temp_model = temp_model.from_map(k)
                self.available_zone.append(temp_model)
        else:
            self.available_zone = None
        return self
class ReActivateInstancesRequest(TeaModel):
    def __init__(self, region_id=None, instance_id=None):
        self.region_id = region_id
        self.instance_id = instance_id

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['InstanceId'] = self.instance_id
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.instance_id = map.get('InstanceId')
        return self


class ReActivateInstancesResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class DescribeInstancesFullStatusRequest(TeaModel):
    def __init__(self, region_id=None, instance_id=None, event_id=None, status=None, health_status=None,
                 instance_event_type=None, event_type=None, not_before=None, event_publish_time=None, page_number=None, page_size=None):
        self.region_id = region_id
        self.instance_id = instance_id
        self.event_id = event_id
        self.status = status
        self.health_status = health_status
        self.instance_event_type = instance_event_type
        self.event_type = event_type
        self.not_before = not_before
        self.event_publish_time = event_publish_time
        self.page_number = page_number
        self.page_size = page_size

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        if self.not_before:
            self.not_before.validate()
        if self.event_publish_time:
            self.event_publish_time.validate()

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['InstanceId'] = []
        if self.instance_id is not None:
            for k in self.instance_id:
                result['InstanceId'].append(k)
        else:
            result['InstanceId'] = None
        result['EventId'] = []
        if self.event_id is not None:
            for k in self.event_id:
                result['EventId'].append(k)
        else:
            result['EventId'] = None
        result['Status'] = self.status
        result['HealthStatus'] = self.health_status
        result['InstanceEventType'] = []
        if self.instance_event_type is not None:
            for k in self.instance_event_type:
                result['InstanceEventType'].append(k)
        else:
            result['InstanceEventType'] = None
        result['EventType'] = self.event_type
        if self.not_before is not None:
            result['NotBefore'] = self.not_before.to_map()
        else:
            result['NotBefore'] = None
        if self.event_publish_time is not None:
            result['EventPublishTime'] = self.event_publish_time.to_map()
        else:
            result['EventPublishTime'] = None
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.instance_id = []
        if map.get('InstanceId') is not None:
            for k in map.get('InstanceId'):
                self.instance_id.append(k)
        else:
            self.instance_id = None
        self.event_id = []
        if map.get('EventId') is not None:
            for k in map.get('EventId'):
                self.event_id.append(k)
        else:
            self.event_id = None
        self.status = map.get('Status')
        self.health_status = map.get('HealthStatus')
        self.instance_event_type = []
        if map.get('InstanceEventType') is not None:
            for k in map.get('InstanceEventType'):
                self.instance_event_type.append(k)
        else:
            self.instance_event_type = None
        self.event_type = map.get('EventType')
        if map.get('NotBefore') is not None:
            temp_model = DescribeInstancesFullStatusRequestNotBefore()
            self.not_before = temp_model.from_map(map['NotBefore'])
        else:
            self.not_before = None
        if map.get('EventPublishTime') is not None:
            temp_model = DescribeInstancesFullStatusRequestEventPublishTime()
            self.event_publish_time = temp_model.from_map(map['EventPublishTime'])
        else:
            self.event_publish_time = None
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        return self


class DescribeInstancesFullStatusRequestNotBefore(TeaModel):
    def __init__(self, start=None, end=None):
        self.start = start
        self.end = end

    def validate(self):
        pass

    def to_map(self):
        result = {}
        result['Start'] = self.start
        result['End'] = self.end
        return result

    def from_map(self, map={}):
        self.start = map.get('Start')
        self.end = map.get('End')
        return self


class DescribeInstancesFullStatusRequestEventPublishTime(TeaModel):
    def __init__(self, start=None, end=None):
        self.start = start
        self.end = end

    def validate(self):
        pass

    def to_map(self):
        result = {}
        result['Start'] = self.start
        result['End'] = self.end
        return result

    def from_map(self, map={}):
        self.start = map.get('Start')
        self.end = map.get('End')
        return self
class DescribeInstancesFullStatusResponse(TeaModel):
    def __init__(self, request_id=None, total_count=None, page_number=None, page_size=None,
                 instance_full_status_set=None):
        self.request_id = request_id
        self.total_count = total_count
        self.page_number = page_number
        self.page_size = page_size
        self.instance_full_status_set = instance_full_status_set

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.page_number, 'page_number')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.instance_full_status_set, 'instance_full_status_set')
        if self.instance_full_status_set:
            self.instance_full_status_set.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['TotalCount'] = self.total_count
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        if self.instance_full_status_set is not None:
            result['InstanceFullStatusSet'] = self.instance_full_status_set.to_map()
        else:
            result['InstanceFullStatusSet'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.total_count = map.get('TotalCount')
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        if map.get('InstanceFullStatusSet') is not None:
            temp_model = DescribeInstancesFullStatusResponseInstanceFullStatusSet()
            self.instance_full_status_set = temp_model.from_map(map['InstanceFullStatusSet'])
        else:
            self.instance_full_status_set = None
        return self


class DescribeInstancesFullStatusResponseInstanceFullStatusSetInstanceFullStatusTypeScheduledSystemEventSetScheduledSystemEventTypeEventCycleStatus(TeaModel):
    def __init__(self, code=None, name=None):
        self.code = code
        self.name = name

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.name, 'name')

    def to_map(self):
        result = {}
        result['Code'] = self.code
        result['Name'] = self.name
        return result

    def from_map(self, map={}):
        self.code = map.get('Code')
        self.name = map.get('Name')
        return self


class DescribeInstancesFullStatusResponseInstanceFullStatusSetInstanceFullStatusTypeScheduledSystemEventSetScheduledSystemEventTypeEventType(TeaModel):
    def __init__(self, code=None, name=None):
        self.code = code
        self.name = name

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.name, 'name')

    def to_map(self):
        result = {}
        result['Code'] = self.code
        result['Name'] = self.name
        return result

    def from_map(self, map={}):
        self.code = map.get('Code')
        self.name = map.get('Name')
        return self


class DescribeInstancesFullStatusResponseInstanceFullStatusSetInstanceFullStatusTypeScheduledSystemEventSetScheduledSystemEventTypeExtendedAttributeInactiveDisksInactiveDisk(TeaModel):
    def __init__(self, creation_time=None, release_time=None, device_type=None, device_category=None,
                 device_size=None):
        self.creation_time = creation_time
        self.release_time = release_time
        self.device_type = device_type
        self.device_category = device_category
        self.device_size = device_size

    def validate(self):
        self.validate_required(self.creation_time, 'creation_time')
        self.validate_required(self.release_time, 'release_time')
        self.validate_required(self.device_type, 'device_type')
        self.validate_required(self.device_category, 'device_category')
        self.validate_required(self.device_size, 'device_size')

    def to_map(self):
        result = {}
        result['CreationTime'] = self.creation_time
        result['ReleaseTime'] = self.release_time
        result['DeviceType'] = self.device_type
        result['DeviceCategory'] = self.device_category
        result['DeviceSize'] = self.device_size
        return result

    def from_map(self, map={}):
        self.creation_time = map.get('CreationTime')
        self.release_time = map.get('ReleaseTime')
        self.device_type = map.get('DeviceType')
        self.device_category = map.get('DeviceCategory')
        self.device_size = map.get('DeviceSize')
        return self


class DescribeInstancesFullStatusResponseInstanceFullStatusSetInstanceFullStatusTypeScheduledSystemEventSetScheduledSystemEventTypeExtendedAttributeInactiveDisks(TeaModel):
    def __init__(self, inactive_disk=None):
        self.inactive_disk = inactive_disk

    def validate(self):
        self.validate_required(self.inactive_disk, 'inactive_disk')
        if self.inactive_disk:
            for k in self.inactive_disk:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['InactiveDisk'] = []
        if self.inactive_disk is not None:
            for k in self.inactive_disk:
                result['InactiveDisk'].append(k.to_map() if k else None)
        else:
            result['InactiveDisk'] = None
        return result

    def from_map(self, map={}):
        self.inactive_disk = []
        if map.get('InactiveDisk') is not None:
            for k in map.get('InactiveDisk'):
                temp_model = DescribeInstancesFullStatusResponseInstanceFullStatusSetInstanceFullStatusTypeScheduledSystemEventSetScheduledSystemEventTypeExtendedAttributeInactiveDisksInactiveDisk()
                temp_model = temp_model.from_map(k)
                self.inactive_disk.append(temp_model)
        else:
            self.inactive_disk = None
        return self


class DescribeInstancesFullStatusResponseInstanceFullStatusSetInstanceFullStatusTypeScheduledSystemEventSetScheduledSystemEventTypeExtendedAttribute(TeaModel):
    def __init__(self, disk_id=None, device=None, inactive_disks=None):
        self.disk_id = disk_id
        self.device = device
        self.inactive_disks = inactive_disks

    def validate(self):
        self.validate_required(self.disk_id, 'disk_id')
        self.validate_required(self.device, 'device')
        self.validate_required(self.inactive_disks, 'inactive_disks')
        if self.inactive_disks:
            self.inactive_disks.validate()

    def to_map(self):
        result = {}
        result['DiskId'] = self.disk_id
        result['Device'] = self.device
        if self.inactive_disks is not None:
            result['InactiveDisks'] = self.inactive_disks.to_map()
        else:
            result['InactiveDisks'] = None
        return result

    def from_map(self, map={}):
        self.disk_id = map.get('DiskId')
        self.device = map.get('Device')
        if map.get('InactiveDisks') is not None:
            temp_model = DescribeInstancesFullStatusResponseInstanceFullStatusSetInstanceFullStatusTypeScheduledSystemEventSetScheduledSystemEventTypeExtendedAttributeInactiveDisks()
            self.inactive_disks = temp_model.from_map(map['InactiveDisks'])
        else:
            self.inactive_disks = None
        return self


class DescribeInstancesFullStatusResponseInstanceFullStatusSetInstanceFullStatusTypeScheduledSystemEventSetScheduledSystemEventType(TeaModel):
    def __init__(self, event_id=None, event_publish_time=None, not_before=None, reason=None, impact_level=None,
                 event_cycle_status=None, event_type=None, extended_attribute=None):
        self.event_id = event_id
        self.event_publish_time = event_publish_time
        self.not_before = not_before
        self.reason = reason
        self.impact_level = impact_level
        self.event_cycle_status = event_cycle_status
        self.event_type = event_type
        self.extended_attribute = extended_attribute

    def validate(self):
        self.validate_required(self.event_id, 'event_id')
        self.validate_required(self.event_publish_time, 'event_publish_time')
        self.validate_required(self.not_before, 'not_before')
        self.validate_required(self.reason, 'reason')
        self.validate_required(self.impact_level, 'impact_level')
        self.validate_required(self.event_cycle_status, 'event_cycle_status')
        if self.event_cycle_status:
            self.event_cycle_status.validate()
        self.validate_required(self.event_type, 'event_type')
        if self.event_type:
            self.event_type.validate()
        self.validate_required(self.extended_attribute, 'extended_attribute')
        if self.extended_attribute:
            self.extended_attribute.validate()

    def to_map(self):
        result = {}
        result['EventId'] = self.event_id
        result['EventPublishTime'] = self.event_publish_time
        result['NotBefore'] = self.not_before
        result['Reason'] = self.reason
        result['ImpactLevel'] = self.impact_level
        if self.event_cycle_status is not None:
            result['EventCycleStatus'] = self.event_cycle_status.to_map()
        else:
            result['EventCycleStatus'] = None
        if self.event_type is not None:
            result['EventType'] = self.event_type.to_map()
        else:
            result['EventType'] = None
        if self.extended_attribute is not None:
            result['ExtendedAttribute'] = self.extended_attribute.to_map()
        else:
            result['ExtendedAttribute'] = None
        return result

    def from_map(self, map={}):
        self.event_id = map.get('EventId')
        self.event_publish_time = map.get('EventPublishTime')
        self.not_before = map.get('NotBefore')
        self.reason = map.get('Reason')
        self.impact_level = map.get('ImpactLevel')
        if map.get('EventCycleStatus') is not None:
            temp_model = DescribeInstancesFullStatusResponseInstanceFullStatusSetInstanceFullStatusTypeScheduledSystemEventSetScheduledSystemEventTypeEventCycleStatus()
            self.event_cycle_status = temp_model.from_map(map['EventCycleStatus'])
        else:
            self.event_cycle_status = None
        if map.get('EventType') is not None:
            temp_model = DescribeInstancesFullStatusResponseInstanceFullStatusSetInstanceFullStatusTypeScheduledSystemEventSetScheduledSystemEventTypeEventType()
            self.event_type = temp_model.from_map(map['EventType'])
        else:
            self.event_type = None
        if map.get('ExtendedAttribute') is not None:
            temp_model = DescribeInstancesFullStatusResponseInstanceFullStatusSetInstanceFullStatusTypeScheduledSystemEventSetScheduledSystemEventTypeExtendedAttribute()
            self.extended_attribute = temp_model.from_map(map['ExtendedAttribute'])
        else:
            self.extended_attribute = None
        return self


class DescribeInstancesFullStatusResponseInstanceFullStatusSetInstanceFullStatusTypeScheduledSystemEventSet(TeaModel):
    def __init__(self, scheduled_system_event_type=None):
        self.scheduled_system_event_type = scheduled_system_event_type

    def validate(self):
        self.validate_required(self.scheduled_system_event_type, 'scheduled_system_event_type')
        if self.scheduled_system_event_type:
            for k in self.scheduled_system_event_type:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['ScheduledSystemEventType'] = []
        if self.scheduled_system_event_type is not None:
            for k in self.scheduled_system_event_type:
                result['ScheduledSystemEventType'].append(k.to_map() if k else None)
        else:
            result['ScheduledSystemEventType'] = None
        return result

    def from_map(self, map={}):
        self.scheduled_system_event_type = []
        if map.get('ScheduledSystemEventType') is not None:
            for k in map.get('ScheduledSystemEventType'):
                temp_model = DescribeInstancesFullStatusResponseInstanceFullStatusSetInstanceFullStatusTypeScheduledSystemEventSetScheduledSystemEventType()
                temp_model = temp_model.from_map(k)
                self.scheduled_system_event_type.append(temp_model)
        else:
            self.scheduled_system_event_type = None
        return self


class DescribeInstancesFullStatusResponseInstanceFullStatusSetInstanceFullStatusTypeStatus(TeaModel):
    def __init__(self, code=None, name=None):
        self.code = code
        self.name = name

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.name, 'name')

    def to_map(self):
        result = {}
        result['Code'] = self.code
        result['Name'] = self.name
        return result

    def from_map(self, map={}):
        self.code = map.get('Code')
        self.name = map.get('Name')
        return self


class DescribeInstancesFullStatusResponseInstanceFullStatusSetInstanceFullStatusTypeHealthStatus(TeaModel):
    def __init__(self, code=None, name=None):
        self.code = code
        self.name = name

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.name, 'name')

    def to_map(self):
        result = {}
        result['Code'] = self.code
        result['Name'] = self.name
        return result

    def from_map(self, map={}):
        self.code = map.get('Code')
        self.name = map.get('Name')
        return self


class DescribeInstancesFullStatusResponseInstanceFullStatusSetInstanceFullStatusType(TeaModel):
    def __init__(self, instance_id=None, scheduled_system_event_set=None, status=None, health_status=None):
        self.instance_id = instance_id
        self.scheduled_system_event_set = scheduled_system_event_set
        self.status = status
        self.health_status = health_status

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.scheduled_system_event_set, 'scheduled_system_event_set')
        if self.scheduled_system_event_set:
            self.scheduled_system_event_set.validate()
        self.validate_required(self.status, 'status')
        if self.status:
            self.status.validate()
        self.validate_required(self.health_status, 'health_status')
        if self.health_status:
            self.health_status.validate()

    def to_map(self):
        result = {}
        result['InstanceId'] = self.instance_id
        if self.scheduled_system_event_set is not None:
            result['ScheduledSystemEventSet'] = self.scheduled_system_event_set.to_map()
        else:
            result['ScheduledSystemEventSet'] = None
        if self.status is not None:
            result['Status'] = self.status.to_map()
        else:
            result['Status'] = None
        if self.health_status is not None:
            result['HealthStatus'] = self.health_status.to_map()
        else:
            result['HealthStatus'] = None
        return result

    def from_map(self, map={}):
        self.instance_id = map.get('InstanceId')
        if map.get('ScheduledSystemEventSet') is not None:
            temp_model = DescribeInstancesFullStatusResponseInstanceFullStatusSetInstanceFullStatusTypeScheduledSystemEventSet()
            self.scheduled_system_event_set = temp_model.from_map(map['ScheduledSystemEventSet'])
        else:
            self.scheduled_system_event_set = None
        if map.get('Status') is not None:
            temp_model = DescribeInstancesFullStatusResponseInstanceFullStatusSetInstanceFullStatusTypeStatus()
            self.status = temp_model.from_map(map['Status'])
        else:
            self.status = None
        if map.get('HealthStatus') is not None:
            temp_model = DescribeInstancesFullStatusResponseInstanceFullStatusSetInstanceFullStatusTypeHealthStatus()
            self.health_status = temp_model.from_map(map['HealthStatus'])
        else:
            self.health_status = None
        return self


class DescribeInstancesFullStatusResponseInstanceFullStatusSet(TeaModel):
    def __init__(self, instance_full_status_type=None):
        self.instance_full_status_type = instance_full_status_type

    def validate(self):
        self.validate_required(self.instance_full_status_type, 'instance_full_status_type')
        if self.instance_full_status_type:
            for k in self.instance_full_status_type:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['InstanceFullStatusType'] = []
        if self.instance_full_status_type is not None:
            for k in self.instance_full_status_type:
                result['InstanceFullStatusType'].append(k.to_map() if k else None)
        else:
            result['InstanceFullStatusType'] = None
        return result

    def from_map(self, map={}):
        self.instance_full_status_type = []
        if map.get('InstanceFullStatusType') is not None:
            for k in map.get('InstanceFullStatusType'):
                temp_model = DescribeInstancesFullStatusResponseInstanceFullStatusSetInstanceFullStatusType()
                temp_model = temp_model.from_map(k)
                self.instance_full_status_type.append(temp_model)
        else:
            self.instance_full_status_type = None
        return self
class DescribeInstanceHistoryEventsRequest(TeaModel):
    def __init__(self, region_id=None, instance_id=None, event_id=None, instance_event_cycle_status=None,
                 event_cycle_status=None, instance_event_type=None, event_type=None, not_before=None, event_publish_time=None,
                 impact_level=None, page_number=None, page_size=None):
        self.region_id = region_id
        self.instance_id = instance_id
        self.event_id = event_id
        self.instance_event_cycle_status = instance_event_cycle_status
        self.event_cycle_status = event_cycle_status
        self.instance_event_type = instance_event_type
        self.event_type = event_type
        self.not_before = not_before
        self.event_publish_time = event_publish_time
        self.impact_level = impact_level
        self.page_number = page_number
        self.page_size = page_size

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        if self.not_before:
            self.not_before.validate()
        if self.event_publish_time:
            self.event_publish_time.validate()

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['InstanceId'] = self.instance_id
        result['EventId'] = []
        if self.event_id is not None:
            for k in self.event_id:
                result['EventId'].append(k)
        else:
            result['EventId'] = None
        result['InstanceEventCycleStatus'] = []
        if self.instance_event_cycle_status is not None:
            for k in self.instance_event_cycle_status:
                result['InstanceEventCycleStatus'].append(k)
        else:
            result['InstanceEventCycleStatus'] = None
        result['EventCycleStatus'] = self.event_cycle_status
        result['InstanceEventType'] = []
        if self.instance_event_type is not None:
            for k in self.instance_event_type:
                result['InstanceEventType'].append(k)
        else:
            result['InstanceEventType'] = None
        result['EventType'] = self.event_type
        if self.not_before is not None:
            result['NotBefore'] = self.not_before.to_map()
        else:
            result['NotBefore'] = None
        if self.event_publish_time is not None:
            result['EventPublishTime'] = self.event_publish_time.to_map()
        else:
            result['EventPublishTime'] = None
        result['ImpactLevel'] = self.impact_level
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.instance_id = map.get('InstanceId')
        self.event_id = []
        if map.get('EventId') is not None:
            for k in map.get('EventId'):
                self.event_id.append(k)
        else:
            self.event_id = None
        self.instance_event_cycle_status = []
        if map.get('InstanceEventCycleStatus') is not None:
            for k in map.get('InstanceEventCycleStatus'):
                self.instance_event_cycle_status.append(k)
        else:
            self.instance_event_cycle_status = None
        self.event_cycle_status = map.get('EventCycleStatus')
        self.instance_event_type = []
        if map.get('InstanceEventType') is not None:
            for k in map.get('InstanceEventType'):
                self.instance_event_type.append(k)
        else:
            self.instance_event_type = None
        self.event_type = map.get('EventType')
        if map.get('NotBefore') is not None:
            temp_model = DescribeInstanceHistoryEventsRequestNotBefore()
            self.not_before = temp_model.from_map(map['NotBefore'])
        else:
            self.not_before = None
        if map.get('EventPublishTime') is not None:
            temp_model = DescribeInstanceHistoryEventsRequestEventPublishTime()
            self.event_publish_time = temp_model.from_map(map['EventPublishTime'])
        else:
            self.event_publish_time = None
        self.impact_level = map.get('ImpactLevel')
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        return self


class DescribeInstanceHistoryEventsRequestNotBefore(TeaModel):
    def __init__(self, start=None, end=None):
        self.start = start
        self.end = end

    def validate(self):
        pass

    def to_map(self):
        result = {}
        result['Start'] = self.start
        result['End'] = self.end
        return result

    def from_map(self, map={}):
        self.start = map.get('Start')
        self.end = map.get('End')
        return self


class DescribeInstanceHistoryEventsRequestEventPublishTime(TeaModel):
    def __init__(self, start=None, end=None):
        self.start = start
        self.end = end

    def validate(self):
        pass

    def to_map(self):
        result = {}
        result['Start'] = self.start
        result['End'] = self.end
        return result

    def from_map(self, map={}):
        self.start = map.get('Start')
        self.end = map.get('End')
        return self
class DescribeInstanceHistoryEventsResponse(TeaModel):
    def __init__(self, request_id=None, total_count=None, page_number=None, page_size=None,
                 instance_system_event_set=None):
        self.request_id = request_id
        self.total_count = total_count
        self.page_number = page_number
        self.page_size = page_size
        self.instance_system_event_set = instance_system_event_set

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.page_number, 'page_number')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.instance_system_event_set, 'instance_system_event_set')
        if self.instance_system_event_set:
            self.instance_system_event_set.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['TotalCount'] = self.total_count
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        if self.instance_system_event_set is not None:
            result['InstanceSystemEventSet'] = self.instance_system_event_set.to_map()
        else:
            result['InstanceSystemEventSet'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.total_count = map.get('TotalCount')
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        if map.get('InstanceSystemEventSet') is not None:
            temp_model = DescribeInstanceHistoryEventsResponseInstanceSystemEventSet()
            self.instance_system_event_set = temp_model.from_map(map['InstanceSystemEventSet'])
        else:
            self.instance_system_event_set = None
        return self


class DescribeInstanceHistoryEventsResponseInstanceSystemEventSetInstanceSystemEventTypeEventType(TeaModel):
    def __init__(self, code=None, name=None):
        self.code = code
        self.name = name

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.name, 'name')

    def to_map(self):
        result = {}
        result['Code'] = self.code
        result['Name'] = self.name
        return result

    def from_map(self, map={}):
        self.code = map.get('Code')
        self.name = map.get('Name')
        return self


class DescribeInstanceHistoryEventsResponseInstanceSystemEventSetInstanceSystemEventTypeEventCycleStatus(TeaModel):
    def __init__(self, code=None, name=None):
        self.code = code
        self.name = name

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.name, 'name')

    def to_map(self):
        result = {}
        result['Code'] = self.code
        result['Name'] = self.name
        return result

    def from_map(self, map={}):
        self.code = map.get('Code')
        self.name = map.get('Name')
        return self


class DescribeInstanceHistoryEventsResponseInstanceSystemEventSetInstanceSystemEventTypeExtendedAttributeInactiveDisksInactiveDisk(TeaModel):
    def __init__(self, creation_time=None, release_time=None, device_type=None, device_category=None,
                 device_size=None):
        self.creation_time = creation_time
        self.release_time = release_time
        self.device_type = device_type
        self.device_category = device_category
        self.device_size = device_size

    def validate(self):
        self.validate_required(self.creation_time, 'creation_time')
        self.validate_required(self.release_time, 'release_time')
        self.validate_required(self.device_type, 'device_type')
        self.validate_required(self.device_category, 'device_category')
        self.validate_required(self.device_size, 'device_size')

    def to_map(self):
        result = {}
        result['CreationTime'] = self.creation_time
        result['ReleaseTime'] = self.release_time
        result['DeviceType'] = self.device_type
        result['DeviceCategory'] = self.device_category
        result['DeviceSize'] = self.device_size
        return result

    def from_map(self, map={}):
        self.creation_time = map.get('CreationTime')
        self.release_time = map.get('ReleaseTime')
        self.device_type = map.get('DeviceType')
        self.device_category = map.get('DeviceCategory')
        self.device_size = map.get('DeviceSize')
        return self


class DescribeInstanceHistoryEventsResponseInstanceSystemEventSetInstanceSystemEventTypeExtendedAttributeInactiveDisks(TeaModel):
    def __init__(self, inactive_disk=None):
        self.inactive_disk = inactive_disk

    def validate(self):
        self.validate_required(self.inactive_disk, 'inactive_disk')
        if self.inactive_disk:
            for k in self.inactive_disk:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['InactiveDisk'] = []
        if self.inactive_disk is not None:
            for k in self.inactive_disk:
                result['InactiveDisk'].append(k.to_map() if k else None)
        else:
            result['InactiveDisk'] = None
        return result

    def from_map(self, map={}):
        self.inactive_disk = []
        if map.get('InactiveDisk') is not None:
            for k in map.get('InactiveDisk'):
                temp_model = DescribeInstanceHistoryEventsResponseInstanceSystemEventSetInstanceSystemEventTypeExtendedAttributeInactiveDisksInactiveDisk()
                temp_model = temp_model.from_map(k)
                self.inactive_disk.append(temp_model)
        else:
            self.inactive_disk = None
        return self


class DescribeInstanceHistoryEventsResponseInstanceSystemEventSetInstanceSystemEventTypeExtendedAttribute(TeaModel):
    def __init__(self, disk_id=None, device=None, inactive_disks=None):
        self.disk_id = disk_id
        self.device = device
        self.inactive_disks = inactive_disks

    def validate(self):
        self.validate_required(self.disk_id, 'disk_id')
        self.validate_required(self.device, 'device')
        self.validate_required(self.inactive_disks, 'inactive_disks')
        if self.inactive_disks:
            self.inactive_disks.validate()

    def to_map(self):
        result = {}
        result['DiskId'] = self.disk_id
        result['Device'] = self.device
        if self.inactive_disks is not None:
            result['InactiveDisks'] = self.inactive_disks.to_map()
        else:
            result['InactiveDisks'] = None
        return result

    def from_map(self, map={}):
        self.disk_id = map.get('DiskId')
        self.device = map.get('Device')
        if map.get('InactiveDisks') is not None:
            temp_model = DescribeInstanceHistoryEventsResponseInstanceSystemEventSetInstanceSystemEventTypeExtendedAttributeInactiveDisks()
            self.inactive_disks = temp_model.from_map(map['InactiveDisks'])
        else:
            self.inactive_disks = None
        return self


class DescribeInstanceHistoryEventsResponseInstanceSystemEventSetInstanceSystemEventType(TeaModel):
    def __init__(self, instance_id=None, event_id=None, event_publish_time=None, not_before=None,
                 event_finish_time=None, reason=None, impact_level=None, event_type=None, event_cycle_status=None,
                 extended_attribute=None):
        self.instance_id = instance_id
        self.event_id = event_id
        self.event_publish_time = event_publish_time
        self.not_before = not_before
        self.event_finish_time = event_finish_time
        self.reason = reason
        self.impact_level = impact_level
        self.event_type = event_type
        self.event_cycle_status = event_cycle_status
        self.extended_attribute = extended_attribute

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.event_id, 'event_id')
        self.validate_required(self.event_publish_time, 'event_publish_time')
        self.validate_required(self.not_before, 'not_before')
        self.validate_required(self.event_finish_time, 'event_finish_time')
        self.validate_required(self.reason, 'reason')
        self.validate_required(self.impact_level, 'impact_level')
        self.validate_required(self.event_type, 'event_type')
        if self.event_type:
            self.event_type.validate()
        self.validate_required(self.event_cycle_status, 'event_cycle_status')
        if self.event_cycle_status:
            self.event_cycle_status.validate()
        self.validate_required(self.extended_attribute, 'extended_attribute')
        if self.extended_attribute:
            self.extended_attribute.validate()

    def to_map(self):
        result = {}
        result['InstanceId'] = self.instance_id
        result['EventId'] = self.event_id
        result['EventPublishTime'] = self.event_publish_time
        result['NotBefore'] = self.not_before
        result['EventFinishTime'] = self.event_finish_time
        result['Reason'] = self.reason
        result['ImpactLevel'] = self.impact_level
        if self.event_type is not None:
            result['EventType'] = self.event_type.to_map()
        else:
            result['EventType'] = None
        if self.event_cycle_status is not None:
            result['EventCycleStatus'] = self.event_cycle_status.to_map()
        else:
            result['EventCycleStatus'] = None
        if self.extended_attribute is not None:
            result['ExtendedAttribute'] = self.extended_attribute.to_map()
        else:
            result['ExtendedAttribute'] = None
        return result

    def from_map(self, map={}):
        self.instance_id = map.get('InstanceId')
        self.event_id = map.get('EventId')
        self.event_publish_time = map.get('EventPublishTime')
        self.not_before = map.get('NotBefore')
        self.event_finish_time = map.get('EventFinishTime')
        self.reason = map.get('Reason')
        self.impact_level = map.get('ImpactLevel')
        if map.get('EventType') is not None:
            temp_model = DescribeInstanceHistoryEventsResponseInstanceSystemEventSetInstanceSystemEventTypeEventType()
            self.event_type = temp_model.from_map(map['EventType'])
        else:
            self.event_type = None
        if map.get('EventCycleStatus') is not None:
            temp_model = DescribeInstanceHistoryEventsResponseInstanceSystemEventSetInstanceSystemEventTypeEventCycleStatus()
            self.event_cycle_status = temp_model.from_map(map['EventCycleStatus'])
        else:
            self.event_cycle_status = None
        if map.get('ExtendedAttribute') is not None:
            temp_model = DescribeInstanceHistoryEventsResponseInstanceSystemEventSetInstanceSystemEventTypeExtendedAttribute()
            self.extended_attribute = temp_model.from_map(map['ExtendedAttribute'])
        else:
            self.extended_attribute = None
        return self


class DescribeInstanceHistoryEventsResponseInstanceSystemEventSet(TeaModel):
    def __init__(self, instance_system_event_type=None):
        self.instance_system_event_type = instance_system_event_type

    def validate(self):
        self.validate_required(self.instance_system_event_type, 'instance_system_event_type')
        if self.instance_system_event_type:
            for k in self.instance_system_event_type:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['InstanceSystemEventType'] = []
        if self.instance_system_event_type is not None:
            for k in self.instance_system_event_type:
                result['InstanceSystemEventType'].append(k.to_map() if k else None)
        else:
            result['InstanceSystemEventType'] = None
        return result

    def from_map(self, map={}):
        self.instance_system_event_type = []
        if map.get('InstanceSystemEventType') is not None:
            for k in map.get('InstanceSystemEventType'):
                temp_model = DescribeInstanceHistoryEventsResponseInstanceSystemEventSetInstanceSystemEventType()
                temp_model = temp_model.from_map(k)
                self.instance_system_event_type.append(temp_model)
        else:
            self.instance_system_event_type = None
        return self
class DescribeDisksFullStatusRequest(TeaModel):
    def __init__(self, region_id=None, disk_id=None, event_id=None, status=None, health_status=None, event_type=None,
                 event_time=None, page_number=None, page_size=None):
        self.region_id = region_id
        self.disk_id = disk_id
        self.event_id = event_id
        self.status = status
        self.health_status = health_status
        self.event_type = event_type
        self.event_time = event_time
        self.page_number = page_number
        self.page_size = page_size

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        if self.event_time:
            self.event_time.validate()

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['DiskId'] = []
        if self.disk_id is not None:
            for k in self.disk_id:
                result['DiskId'].append(k)
        else:
            result['DiskId'] = None
        result['EventId'] = []
        if self.event_id is not None:
            for k in self.event_id:
                result['EventId'].append(k)
        else:
            result['EventId'] = None
        result['Status'] = self.status
        result['HealthStatus'] = self.health_status
        result['EventType'] = self.event_type
        if self.event_time is not None:
            result['EventTime'] = self.event_time.to_map()
        else:
            result['EventTime'] = None
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.disk_id = []
        if map.get('DiskId') is not None:
            for k in map.get('DiskId'):
                self.disk_id.append(k)
        else:
            self.disk_id = None
        self.event_id = []
        if map.get('EventId') is not None:
            for k in map.get('EventId'):
                self.event_id.append(k)
        else:
            self.event_id = None
        self.status = map.get('Status')
        self.health_status = map.get('HealthStatus')
        self.event_type = map.get('EventType')
        if map.get('EventTime') is not None:
            temp_model = DescribeDisksFullStatusRequestEventTime()
            self.event_time = temp_model.from_map(map['EventTime'])
        else:
            self.event_time = None
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        return self


class DescribeDisksFullStatusRequestEventTime(TeaModel):
    def __init__(self, start=None, end=None):
        self.start = start
        self.end = end

    def validate(self):
        pass

    def to_map(self):
        result = {}
        result['Start'] = self.start
        result['End'] = self.end
        return result

    def from_map(self, map={}):
        self.start = map.get('Start')
        self.end = map.get('End')
        return self
class DescribeDisksFullStatusResponse(TeaModel):
    def __init__(self, request_id=None, total_count=None, page_number=None, page_size=None,
                 disk_full_status_set=None):
        self.request_id = request_id
        self.total_count = total_count
        self.page_number = page_number
        self.page_size = page_size
        self.disk_full_status_set = disk_full_status_set

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.page_number, 'page_number')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.disk_full_status_set, 'disk_full_status_set')
        if self.disk_full_status_set:
            self.disk_full_status_set.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['TotalCount'] = self.total_count
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        if self.disk_full_status_set is not None:
            result['DiskFullStatusSet'] = self.disk_full_status_set.to_map()
        else:
            result['DiskFullStatusSet'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.total_count = map.get('TotalCount')
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        if map.get('DiskFullStatusSet') is not None:
            temp_model = DescribeDisksFullStatusResponseDiskFullStatusSet()
            self.disk_full_status_set = temp_model.from_map(map['DiskFullStatusSet'])
        else:
            self.disk_full_status_set = None
        return self


class DescribeDisksFullStatusResponseDiskFullStatusSetDiskFullStatusTypeDiskEventSetDiskEventTypeEventType(TeaModel):
    def __init__(self, code=None, name=None):
        self.code = code
        self.name = name

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.name, 'name')

    def to_map(self):
        result = {}
        result['Code'] = self.code
        result['Name'] = self.name
        return result

    def from_map(self, map={}):
        self.code = map.get('Code')
        self.name = map.get('Name')
        return self


class DescribeDisksFullStatusResponseDiskFullStatusSetDiskFullStatusTypeDiskEventSetDiskEventType(TeaModel):
    def __init__(self, event_id=None, event_time=None, event_end_time=None, impact_level=None, event_type=None):
        self.event_id = event_id
        self.event_time = event_time
        self.event_end_time = event_end_time
        self.impact_level = impact_level
        self.event_type = event_type

    def validate(self):
        self.validate_required(self.event_id, 'event_id')
        self.validate_required(self.event_time, 'event_time')
        self.validate_required(self.event_end_time, 'event_end_time')
        self.validate_required(self.impact_level, 'impact_level')
        self.validate_required(self.event_type, 'event_type')
        if self.event_type:
            self.event_type.validate()

    def to_map(self):
        result = {}
        result['EventId'] = self.event_id
        result['EventTime'] = self.event_time
        result['EventEndTime'] = self.event_end_time
        result['ImpactLevel'] = self.impact_level
        if self.event_type is not None:
            result['EventType'] = self.event_type.to_map()
        else:
            result['EventType'] = None
        return result

    def from_map(self, map={}):
        self.event_id = map.get('EventId')
        self.event_time = map.get('EventTime')
        self.event_end_time = map.get('EventEndTime')
        self.impact_level = map.get('ImpactLevel')
        if map.get('EventType') is not None:
            temp_model = DescribeDisksFullStatusResponseDiskFullStatusSetDiskFullStatusTypeDiskEventSetDiskEventTypeEventType()
            self.event_type = temp_model.from_map(map['EventType'])
        else:
            self.event_type = None
        return self


class DescribeDisksFullStatusResponseDiskFullStatusSetDiskFullStatusTypeDiskEventSet(TeaModel):
    def __init__(self, disk_event_type=None):
        self.disk_event_type = disk_event_type

    def validate(self):
        self.validate_required(self.disk_event_type, 'disk_event_type')
        if self.disk_event_type:
            for k in self.disk_event_type:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['DiskEventType'] = []
        if self.disk_event_type is not None:
            for k in self.disk_event_type:
                result['DiskEventType'].append(k.to_map() if k else None)
        else:
            result['DiskEventType'] = None
        return result

    def from_map(self, map={}):
        self.disk_event_type = []
        if map.get('DiskEventType') is not None:
            for k in map.get('DiskEventType'):
                temp_model = DescribeDisksFullStatusResponseDiskFullStatusSetDiskFullStatusTypeDiskEventSetDiskEventType()
                temp_model = temp_model.from_map(k)
                self.disk_event_type.append(temp_model)
        else:
            self.disk_event_type = None
        return self


class DescribeDisksFullStatusResponseDiskFullStatusSetDiskFullStatusTypeStatus(TeaModel):
    def __init__(self, code=None, name=None):
        self.code = code
        self.name = name

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.name, 'name')

    def to_map(self):
        result = {}
        result['Code'] = self.code
        result['Name'] = self.name
        return result

    def from_map(self, map={}):
        self.code = map.get('Code')
        self.name = map.get('Name')
        return self


class DescribeDisksFullStatusResponseDiskFullStatusSetDiskFullStatusTypeHealthStatus(TeaModel):
    def __init__(self, code=None, name=None):
        self.code = code
        self.name = name

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.name, 'name')

    def to_map(self):
        result = {}
        result['Code'] = self.code
        result['Name'] = self.name
        return result

    def from_map(self, map={}):
        self.code = map.get('Code')
        self.name = map.get('Name')
        return self


class DescribeDisksFullStatusResponseDiskFullStatusSetDiskFullStatusType(TeaModel):
    def __init__(self, disk_id=None, instance_id=None, device=None, disk_event_set=None, status=None,
                 health_status=None):
        self.disk_id = disk_id
        self.instance_id = instance_id
        self.device = device
        self.disk_event_set = disk_event_set
        self.status = status
        self.health_status = health_status

    def validate(self):
        self.validate_required(self.disk_id, 'disk_id')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.device, 'device')
        self.validate_required(self.disk_event_set, 'disk_event_set')
        if self.disk_event_set:
            self.disk_event_set.validate()
        self.validate_required(self.status, 'status')
        if self.status:
            self.status.validate()
        self.validate_required(self.health_status, 'health_status')
        if self.health_status:
            self.health_status.validate()

    def to_map(self):
        result = {}
        result['DiskId'] = self.disk_id
        result['InstanceId'] = self.instance_id
        result['Device'] = self.device
        if self.disk_event_set is not None:
            result['DiskEventSet'] = self.disk_event_set.to_map()
        else:
            result['DiskEventSet'] = None
        if self.status is not None:
            result['Status'] = self.status.to_map()
        else:
            result['Status'] = None
        if self.health_status is not None:
            result['HealthStatus'] = self.health_status.to_map()
        else:
            result['HealthStatus'] = None
        return result

    def from_map(self, map={}):
        self.disk_id = map.get('DiskId')
        self.instance_id = map.get('InstanceId')
        self.device = map.get('Device')
        if map.get('DiskEventSet') is not None:
            temp_model = DescribeDisksFullStatusResponseDiskFullStatusSetDiskFullStatusTypeDiskEventSet()
            self.disk_event_set = temp_model.from_map(map['DiskEventSet'])
        else:
            self.disk_event_set = None
        if map.get('Status') is not None:
            temp_model = DescribeDisksFullStatusResponseDiskFullStatusSetDiskFullStatusTypeStatus()
            self.status = temp_model.from_map(map['Status'])
        else:
            self.status = None
        if map.get('HealthStatus') is not None:
            temp_model = DescribeDisksFullStatusResponseDiskFullStatusSetDiskFullStatusTypeHealthStatus()
            self.health_status = temp_model.from_map(map['HealthStatus'])
        else:
            self.health_status = None
        return self


class DescribeDisksFullStatusResponseDiskFullStatusSet(TeaModel):
    def __init__(self, disk_full_status_type=None):
        self.disk_full_status_type = disk_full_status_type

    def validate(self):
        self.validate_required(self.disk_full_status_type, 'disk_full_status_type')
        if self.disk_full_status_type:
            for k in self.disk_full_status_type:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['DiskFullStatusType'] = []
        if self.disk_full_status_type is not None:
            for k in self.disk_full_status_type:
                result['DiskFullStatusType'].append(k.to_map() if k else None)
        else:
            result['DiskFullStatusType'] = None
        return result

    def from_map(self, map={}):
        self.disk_full_status_type = []
        if map.get('DiskFullStatusType') is not None:
            for k in map.get('DiskFullStatusType'):
                temp_model = DescribeDisksFullStatusResponseDiskFullStatusSetDiskFullStatusType()
                temp_model = temp_model.from_map(k)
                self.disk_full_status_type.append(temp_model)
        else:
            self.disk_full_status_type = None
        return self
class ModifyUserBusinessBehaviorRequest(TeaModel):
    def __init__(self, region_id=None, status_key=None, status_value=None):
        self.region_id = region_id
        self.status_key = status_key
        self.status_value = status_value

    def validate(self):
        self.validate_required(self.status_key, 'status_key')
        self.validate_required(self.status_value, 'status_value')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['statusKey'] = self.status_key
        result['statusValue'] = self.status_value
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.status_key = map.get('statusKey')
        self.status_value = map.get('statusValue')
        return self


class ModifyUserBusinessBehaviorResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class DescribeUserBusinessBehaviorRequest(TeaModel):
    def __init__(self, region_id=None, status_key=None):
        self.region_id = region_id
        self.status_key = status_key

    def validate(self):
        self.validate_required(self.status_key, 'status_key')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['statusKey'] = self.status_key
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.status_key = map.get('statusKey')
        return self


class DescribeUserBusinessBehaviorResponse(TeaModel):
    def __init__(self, request_id=None, status_value=None):
        self.request_id = request_id
        self.status_value = status_value

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.status_value, 'status_value')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['StatusValue'] = self.status_value
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.status_value = map.get('StatusValue')
        return self


class RunInstancesRequest(TeaModel):
    def __init__(self, region_id=None, image_id=None, image_family=None, instance_type=None, security_group_id=None,
                 security_group_ids=None, v_switch_id=None, instance_name=None, description=None, internet_max_bandwidth_in=None,
                 internet_max_bandwidth_out=None, host_name=None, unique_suffix=None, password=None, password_inherit=None, zone_id=None,
                 internet_charge_type=None, system_disk=None, data_disk=None, arn=None, io_optimized=None, network_interface=None,
                 user_data=None, key_pair_name=None, ram_role_name=None, amount=None, min_amount=None, auto_release_time=None,
                 spot_strategy=None, spot_duration=None, spot_price_limit=None, spot_interruption_behavior=None,
                 security_enhancement_strategy=None, client_token=None, tag=None, hpc_cluster_id=None, dry_run=None, dedicated_host_id=None,
                 launch_template_id=None, launch_template_name=None, launch_template_version=None, resource_group_id=None,
                 period=None, period_unit=None, auto_renew=None, auto_renew_period=None, instance_charge_type=None,
                 deployment_set_id=None, deployment_set_group_no=None, private_ip_address=None, credit_specification=None,
                 ipv_6address=None, ipv_6address_count=None, deletion_protection=None, affinity=None, tenancy=None,
                 storage_set_id=None, storage_set_partition_number=None, cpu_options=None, http_endpoint=None, http_tokens=None,
                 http_put_response_hop_limit=None):
        self.region_id = region_id
        self.image_id = image_id
        self.image_family = image_family
        self.instance_type = instance_type
        self.security_group_id = security_group_id
        self.security_group_ids = security_group_ids
        self.v_switch_id = v_switch_id
        self.instance_name = instance_name
        self.description = description
        self.internet_max_bandwidth_in = internet_max_bandwidth_in
        self.internet_max_bandwidth_out = internet_max_bandwidth_out
        self.host_name = host_name
        self.unique_suffix = unique_suffix
        self.password = password
        self.password_inherit = password_inherit
        self.zone_id = zone_id
        self.internet_charge_type = internet_charge_type
        self.system_disk = system_disk
        self.data_disk = data_disk
        self.arn = arn
        self.io_optimized = io_optimized
        self.network_interface = network_interface
        self.user_data = user_data
        self.key_pair_name = key_pair_name
        self.ram_role_name = ram_role_name
        self.amount = amount
        self.min_amount = min_amount
        self.auto_release_time = auto_release_time
        self.spot_strategy = spot_strategy
        self.spot_duration = spot_duration
        self.spot_price_limit = spot_price_limit
        self.spot_interruption_behavior = spot_interruption_behavior
        self.security_enhancement_strategy = security_enhancement_strategy
        self.client_token = client_token
        self.tag = tag
        self.hpc_cluster_id = hpc_cluster_id
        self.dry_run = dry_run
        self.dedicated_host_id = dedicated_host_id
        self.launch_template_id = launch_template_id
        self.launch_template_name = launch_template_name
        self.launch_template_version = launch_template_version
        self.resource_group_id = resource_group_id
        self.period = period
        self.period_unit = period_unit
        self.auto_renew = auto_renew
        self.auto_renew_period = auto_renew_period
        self.instance_charge_type = instance_charge_type
        self.deployment_set_id = deployment_set_id
        self.deployment_set_group_no = deployment_set_group_no
        self.private_ip_address = private_ip_address
        self.credit_specification = credit_specification
        self.ipv_6address = ipv_6address
        self.ipv_6address_count = ipv_6address_count
        self.deletion_protection = deletion_protection
        self.affinity = affinity
        self.tenancy = tenancy
        self.storage_set_id = storage_set_id
        self.storage_set_partition_number = storage_set_partition_number
        self.cpu_options = cpu_options
        self.http_endpoint = http_endpoint
        self.http_tokens = http_tokens
        self.http_put_response_hop_limit = http_put_response_hop_limit

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        if self.system_disk:
            self.system_disk.validate()
        if self.data_disk:
            for k in self.data_disk:
                if k:
                    k.validate()
        if self.arn:
            for k in self.arn:
                if k:
                    k.validate()
        if self.network_interface:
            for k in self.network_interface:
                if k:
                    k.validate()
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()
        if self.cpu_options:
            self.cpu_options.validate()

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['ImageId'] = self.image_id
        result['ImageFamily'] = self.image_family
        result['InstanceType'] = self.instance_type
        result['SecurityGroupId'] = self.security_group_id
        result['SecurityGroupIds'] = []
        if self.security_group_ids is not None:
            for k in self.security_group_ids:
                result['SecurityGroupIds'].append(k)
        else:
            result['SecurityGroupIds'] = None
        result['VSwitchId'] = self.v_switch_id
        result['InstanceName'] = self.instance_name
        result['Description'] = self.description
        result['InternetMaxBandwidthIn'] = self.internet_max_bandwidth_in
        result['InternetMaxBandwidthOut'] = self.internet_max_bandwidth_out
        result['HostName'] = self.host_name
        result['UniqueSuffix'] = self.unique_suffix
        result['Password'] = self.password
        result['PasswordInherit'] = self.password_inherit
        result['ZoneId'] = self.zone_id
        result['InternetChargeType'] = self.internet_charge_type
        if self.system_disk is not None:
            result['SystemDisk'] = self.system_disk.to_map()
        else:
            result['SystemDisk'] = None
        result['DataDisk'] = []
        if self.data_disk is not None:
            for k in self.data_disk:
                result['DataDisk'].append(k.to_map() if k else None)
        else:
            result['DataDisk'] = None
        result['Arn'] = []
        if self.arn is not None:
            for k in self.arn:
                result['Arn'].append(k.to_map() if k else None)
        else:
            result['Arn'] = None
        result['IoOptimized'] = self.io_optimized
        result['NetworkInterface'] = []
        if self.network_interface is not None:
            for k in self.network_interface:
                result['NetworkInterface'].append(k.to_map() if k else None)
        else:
            result['NetworkInterface'] = None
        result['UserData'] = self.user_data
        result['KeyPairName'] = self.key_pair_name
        result['RamRoleName'] = self.ram_role_name
        result['Amount'] = self.amount
        result['MinAmount'] = self.min_amount
        result['AutoReleaseTime'] = self.auto_release_time
        result['SpotStrategy'] = self.spot_strategy
        result['SpotDuration'] = self.spot_duration
        result['SpotPriceLimit'] = self.spot_price_limit
        result['SpotInterruptionBehavior'] = self.spot_interruption_behavior
        result['SecurityEnhancementStrategy'] = self.security_enhancement_strategy
        result['ClientToken'] = self.client_token
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        else:
            result['Tag'] = None
        result['HpcClusterId'] = self.hpc_cluster_id
        result['DryRun'] = self.dry_run
        result['DedicatedHostId'] = self.dedicated_host_id
        result['LaunchTemplateId'] = self.launch_template_id
        result['LaunchTemplateName'] = self.launch_template_name
        result['LaunchTemplateVersion'] = self.launch_template_version
        result['ResourceGroupId'] = self.resource_group_id
        result['Period'] = self.period
        result['PeriodUnit'] = self.period_unit
        result['AutoRenew'] = self.auto_renew
        result['AutoRenewPeriod'] = self.auto_renew_period
        result['InstanceChargeType'] = self.instance_charge_type
        result['DeploymentSetId'] = self.deployment_set_id
        result['DeploymentSetGroupNo'] = self.deployment_set_group_no
        result['PrivateIpAddress'] = self.private_ip_address
        result['CreditSpecification'] = self.credit_specification
        result['Ipv6Address'] = []
        if self.ipv_6address is not None:
            for k in self.ipv_6address:
                result['Ipv6Address'].append(k)
        else:
            result['Ipv6Address'] = None
        result['Ipv6AddressCount'] = self.ipv_6address_count
        result['DeletionProtection'] = self.deletion_protection
        result['Affinity'] = self.affinity
        result['Tenancy'] = self.tenancy
        result['StorageSetId'] = self.storage_set_id
        result['StorageSetPartitionNumber'] = self.storage_set_partition_number
        if self.cpu_options is not None:
            result['CpuOptions'] = self.cpu_options.to_map()
        else:
            result['CpuOptions'] = None
        result['HttpEndpoint'] = self.http_endpoint
        result['HttpTokens'] = self.http_tokens
        result['HttpPutResponseHopLimit'] = self.http_put_response_hop_limit
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.image_id = map.get('ImageId')
        self.image_family = map.get('ImageFamily')
        self.instance_type = map.get('InstanceType')
        self.security_group_id = map.get('SecurityGroupId')
        self.security_group_ids = []
        if map.get('SecurityGroupIds') is not None:
            for k in map.get('SecurityGroupIds'):
                self.security_group_ids.append(k)
        else:
            self.security_group_ids = None
        self.v_switch_id = map.get('VSwitchId')
        self.instance_name = map.get('InstanceName')
        self.description = map.get('Description')
        self.internet_max_bandwidth_in = map.get('InternetMaxBandwidthIn')
        self.internet_max_bandwidth_out = map.get('InternetMaxBandwidthOut')
        self.host_name = map.get('HostName')
        self.unique_suffix = map.get('UniqueSuffix')
        self.password = map.get('Password')
        self.password_inherit = map.get('PasswordInherit')
        self.zone_id = map.get('ZoneId')
        self.internet_charge_type = map.get('InternetChargeType')
        if map.get('SystemDisk') is not None:
            temp_model = RunInstancesRequestSystemDisk()
            self.system_disk = temp_model.from_map(map['SystemDisk'])
        else:
            self.system_disk = None
        self.data_disk = []
        if map.get('DataDisk') is not None:
            for k in map.get('DataDisk'):
                temp_model = RunInstancesRequestDataDisk()
                temp_model = temp_model.from_map(k)
                self.data_disk.append(temp_model)
        else:
            self.data_disk = None
        self.arn = []
        if map.get('Arn') is not None:
            for k in map.get('Arn'):
                temp_model = RunInstancesRequestArn()
                temp_model = temp_model.from_map(k)
                self.arn.append(temp_model)
        else:
            self.arn = None
        self.io_optimized = map.get('IoOptimized')
        self.network_interface = []
        if map.get('NetworkInterface') is not None:
            for k in map.get('NetworkInterface'):
                temp_model = RunInstancesRequestNetworkInterface()
                temp_model = temp_model.from_map(k)
                self.network_interface.append(temp_model)
        else:
            self.network_interface = None
        self.user_data = map.get('UserData')
        self.key_pair_name = map.get('KeyPairName')
        self.ram_role_name = map.get('RamRoleName')
        self.amount = map.get('Amount')
        self.min_amount = map.get('MinAmount')
        self.auto_release_time = map.get('AutoReleaseTime')
        self.spot_strategy = map.get('SpotStrategy')
        self.spot_duration = map.get('SpotDuration')
        self.spot_price_limit = map.get('SpotPriceLimit')
        self.spot_interruption_behavior = map.get('SpotInterruptionBehavior')
        self.security_enhancement_strategy = map.get('SecurityEnhancementStrategy')
        self.client_token = map.get('ClientToken')
        self.tag = []
        if map.get('Tag') is not None:
            for k in map.get('Tag'):
                temp_model = RunInstancesRequestTag()
                temp_model = temp_model.from_map(k)
                self.tag.append(temp_model)
        else:
            self.tag = None
        self.hpc_cluster_id = map.get('HpcClusterId')
        self.dry_run = map.get('DryRun')
        self.dedicated_host_id = map.get('DedicatedHostId')
        self.launch_template_id = map.get('LaunchTemplateId')
        self.launch_template_name = map.get('LaunchTemplateName')
        self.launch_template_version = map.get('LaunchTemplateVersion')
        self.resource_group_id = map.get('ResourceGroupId')
        self.period = map.get('Period')
        self.period_unit = map.get('PeriodUnit')
        self.auto_renew = map.get('AutoRenew')
        self.auto_renew_period = map.get('AutoRenewPeriod')
        self.instance_charge_type = map.get('InstanceChargeType')
        self.deployment_set_id = map.get('DeploymentSetId')
        self.deployment_set_group_no = map.get('DeploymentSetGroupNo')
        self.private_ip_address = map.get('PrivateIpAddress')
        self.credit_specification = map.get('CreditSpecification')
        self.ipv_6address = []
        if map.get('Ipv6Address') is not None:
            for k in map.get('Ipv6Address'):
                self.ipv_6address.append(k)
        else:
            self.ipv_6address = None
        self.ipv_6address_count = map.get('Ipv6AddressCount')
        self.deletion_protection = map.get('DeletionProtection')
        self.affinity = map.get('Affinity')
        self.tenancy = map.get('Tenancy')
        self.storage_set_id = map.get('StorageSetId')
        self.storage_set_partition_number = map.get('StorageSetPartitionNumber')
        if map.get('CpuOptions') is not None:
            temp_model = RunInstancesRequestCpuOptions()
            self.cpu_options = temp_model.from_map(map['CpuOptions'])
        else:
            self.cpu_options = None
        self.http_endpoint = map.get('HttpEndpoint')
        self.http_tokens = map.get('HttpTokens')
        self.http_put_response_hop_limit = map.get('HttpPutResponseHopLimit')
        return self


class RunInstancesRequestSystemDisk(TeaModel):
    def __init__(self, size=None, category=None, disk_name=None, description=None, performance_level=None,
                 auto_snapshot_policy_id=None):
        self.size = size
        self.category = category
        self.disk_name = disk_name
        self.description = description
        self.performance_level = performance_level
        self.auto_snapshot_policy_id = auto_snapshot_policy_id

    def validate(self):
        pass

    def to_map(self):
        result = {}
        result['Size'] = self.size
        result['Category'] = self.category
        result['DiskName'] = self.disk_name
        result['Description'] = self.description
        result['PerformanceLevel'] = self.performance_level
        result['AutoSnapshotPolicyId'] = self.auto_snapshot_policy_id
        return result

    def from_map(self, map={}):
        self.size = map.get('Size')
        self.category = map.get('Category')
        self.disk_name = map.get('DiskName')
        self.description = map.get('Description')
        self.performance_level = map.get('PerformanceLevel')
        self.auto_snapshot_policy_id = map.get('AutoSnapshotPolicyId')
        return self


class RunInstancesRequestDataDisk(TeaModel):
    def __init__(self, size=None, snapshot_id=None, category=None, encrypted=None, kmskey_id=None, disk_name=None,
                 description=None, device=None, delete_with_instance=None, performance_level=None,
                 auto_snapshot_policy_id=None, encrypt_algorithm=None):
        self.size = size
        self.snapshot_id = snapshot_id
        self.category = category
        self.encrypted = encrypted
        self.kmskey_id = kmskey_id
        self.disk_name = disk_name
        self.description = description
        self.device = device
        self.delete_with_instance = delete_with_instance
        self.performance_level = performance_level
        self.auto_snapshot_policy_id = auto_snapshot_policy_id
        self.encrypt_algorithm = encrypt_algorithm

    def validate(self):
        self.validate_required(self.size, 'size')
        self.validate_required(self.snapshot_id, 'snapshot_id')
        self.validate_required(self.category, 'category')
        self.validate_required(self.encrypted, 'encrypted')
        self.validate_required(self.kmskey_id, 'kmskey_id')
        self.validate_required(self.disk_name, 'disk_name')
        self.validate_required(self.description, 'description')
        self.validate_required(self.device, 'device')
        self.validate_required(self.delete_with_instance, 'delete_with_instance')
        self.validate_required(self.performance_level, 'performance_level')
        self.validate_required(self.auto_snapshot_policy_id, 'auto_snapshot_policy_id')
        self.validate_required(self.encrypt_algorithm, 'encrypt_algorithm')

    def to_map(self):
        result = {}
        result['Size'] = self.size
        result['SnapshotId'] = self.snapshot_id
        result['Category'] = self.category
        result['Encrypted'] = self.encrypted
        result['KMSKeyId'] = self.kmskey_id
        result['DiskName'] = self.disk_name
        result['Description'] = self.description
        result['Device'] = self.device
        result['DeleteWithInstance'] = self.delete_with_instance
        result['PerformanceLevel'] = self.performance_level
        result['AutoSnapshotPolicyId'] = self.auto_snapshot_policy_id
        result['EncryptAlgorithm'] = self.encrypt_algorithm
        return result

    def from_map(self, map={}):
        self.size = map.get('Size')
        self.snapshot_id = map.get('SnapshotId')
        self.category = map.get('Category')
        self.encrypted = map.get('Encrypted')
        self.kmskey_id = map.get('KMSKeyId')
        self.disk_name = map.get('DiskName')
        self.description = map.get('Description')
        self.device = map.get('Device')
        self.delete_with_instance = map.get('DeleteWithInstance')
        self.performance_level = map.get('PerformanceLevel')
        self.auto_snapshot_policy_id = map.get('AutoSnapshotPolicyId')
        self.encrypt_algorithm = map.get('EncryptAlgorithm')
        return self


class RunInstancesRequestArn(TeaModel):
    def __init__(self, assume_role_for=None, rolearn=None, role_type=None):
        self.assume_role_for = assume_role_for
        self.rolearn = rolearn
        self.role_type = role_type

    def validate(self):
        self.validate_required(self.assume_role_for, 'assume_role_for')
        self.validate_required(self.rolearn, 'rolearn')
        self.validate_required(self.role_type, 'role_type')

    def to_map(self):
        result = {}
        result['AssumeRoleFor'] = self.assume_role_for
        result['Rolearn'] = self.rolearn
        result['RoleType'] = self.role_type
        return result

    def from_map(self, map={}):
        self.assume_role_for = map.get('AssumeRoleFor')
        self.rolearn = map.get('Rolearn')
        self.role_type = map.get('RoleType')
        return self


class RunInstancesRequestNetworkInterface(TeaModel):
    def __init__(self, primary_ip_address=None, v_switch_id=None, security_group_id=None, security_group_ids=None,
                 network_interface_name=None, description=None):
        self.primary_ip_address = primary_ip_address
        self.v_switch_id = v_switch_id
        self.security_group_id = security_group_id
        self.security_group_ids = security_group_ids
        self.network_interface_name = network_interface_name
        self.description = description

    def validate(self):
        self.validate_required(self.primary_ip_address, 'primary_ip_address')
        self.validate_required(self.v_switch_id, 'v_switch_id')
        self.validate_required(self.security_group_id, 'security_group_id')
        self.validate_required(self.network_interface_name, 'network_interface_name')
        self.validate_required(self.description, 'description')

    def to_map(self):
        result = {}
        result['PrimaryIpAddress'] = self.primary_ip_address
        result['VSwitchId'] = self.v_switch_id
        result['SecurityGroupId'] = self.security_group_id
        result['SecurityGroupIds'] = []
        if self.security_group_ids is not None:
            for k in self.security_group_ids:
                result['SecurityGroupIds'].append(k)
        else:
            result['SecurityGroupIds'] = None
        result['NetworkInterfaceName'] = self.network_interface_name
        result['Description'] = self.description
        return result

    def from_map(self, map={}):
        self.primary_ip_address = map.get('PrimaryIpAddress')
        self.v_switch_id = map.get('VSwitchId')
        self.security_group_id = map.get('SecurityGroupId')
        self.security_group_ids = []
        if map.get('SecurityGroupIds') is not None:
            for k in map.get('SecurityGroupIds'):
                self.security_group_ids.append(k)
        else:
            self.security_group_ids = None
        self.network_interface_name = map.get('NetworkInterfaceName')
        self.description = map.get('Description')
        return self


class RunInstancesRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key
        self.value = value

    def validate(self):
        self.validate_required(self.key, 'key')
        self.validate_required(self.value, 'value')

    def to_map(self):
        result = {}
        result['Key'] = self.key
        result['Value'] = self.value
        return result

    def from_map(self, map={}):
        self.key = map.get('Key')
        self.value = map.get('Value')
        return self


class RunInstancesRequestCpuOptions(TeaModel):
    def __init__(self, core=None, threads_per_core=None, numa=None):
        self.core = core
        self.threads_per_core = threads_per_core
        self.numa = numa

    def validate(self):
        pass

    def to_map(self):
        result = {}
        result['Core'] = self.core
        result['ThreadsPerCore'] = self.threads_per_core
        result['Numa'] = self.numa
        return result

    def from_map(self, map={}):
        self.core = map.get('Core')
        self.threads_per_core = map.get('ThreadsPerCore')
        self.numa = map.get('Numa')
        return self
class RunInstancesResponse(TeaModel):
    def __init__(self, request_id=None, trade_price=None, instance_id_sets=None):
        self.request_id = request_id
        self.trade_price = trade_price
        self.instance_id_sets = instance_id_sets

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.trade_price, 'trade_price')
        self.validate_required(self.instance_id_sets, 'instance_id_sets')
        if self.instance_id_sets:
            self.instance_id_sets.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['TradePrice'] = self.trade_price
        if self.instance_id_sets is not None:
            result['InstanceIdSets'] = self.instance_id_sets.to_map()
        else:
            result['InstanceIdSets'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.trade_price = map.get('TradePrice')
        if map.get('InstanceIdSets') is not None:
            temp_model = RunInstancesResponseInstanceIdSets()
            self.instance_id_sets = temp_model.from_map(map['InstanceIdSets'])
        else:
            self.instance_id_sets = None
        return self


class RunInstancesResponseInstanceIdSets(TeaModel):
    def __init__(self, instance_id_set=None):
        self.instance_id_set = instance_id_set

    def validate(self):
        self.validate_required(self.instance_id_set, 'instance_id_set')

    def to_map(self):
        result = {}
        result['InstanceIdSet'] = []
        if self.instance_id_set is not None:
            for k in self.instance_id_set:
                result['InstanceIdSet'].append(k)
        else:
            result['InstanceIdSet'] = None
        return result

    def from_map(self, map={}):
        self.instance_id_set = []
        if map.get('InstanceIdSet') is not None:
            for k in map.get('InstanceIdSet'):
                self.instance_id_set.append(k)
        else:
            self.instance_id_set = None
        return self
class ConvertNatPublicIpToEipRequest(TeaModel):
    def __init__(self, instance_id=None, region_id=None):
        self.instance_id = instance_id
        self.region_id = region_id

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.region_id, 'region_id')

    def to_map(self):
        result = {}
        result['InstanceId'] = self.instance_id
        result['RegionId'] = self.region_id
        return result

    def from_map(self, map={}):
        self.instance_id = map.get('InstanceId')
        self.region_id = map.get('RegionId')
        return self


class ConvertNatPublicIpToEipResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class ModifyHpcClusterAttributeRequest(TeaModel):
    def __init__(self, region_id=None, client_token=None, hpc_cluster_id=None, description=None, name=None):
        self.region_id = region_id
        self.client_token = client_token
        self.hpc_cluster_id = hpc_cluster_id
        self.description = description
        self.name = name

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.hpc_cluster_id, 'hpc_cluster_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['ClientToken'] = self.client_token
        result['HpcClusterId'] = self.hpc_cluster_id
        result['Description'] = self.description
        result['Name'] = self.name
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.client_token = map.get('ClientToken')
        self.hpc_cluster_id = map.get('HpcClusterId')
        self.description = map.get('Description')
        self.name = map.get('Name')
        return self


class ModifyHpcClusterAttributeResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class DescribeHpcClustersRequest(TeaModel):
    def __init__(self, region_id=None, client_token=None, hpc_cluster_ids=None, page_number=None, page_size=None):
        self.region_id = region_id
        self.client_token = client_token
        self.hpc_cluster_ids = hpc_cluster_ids
        self.page_number = page_number
        self.page_size = page_size

    def validate(self):
        self.validate_required(self.region_id, 'region_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['ClientToken'] = self.client_token
        result['HpcClusterIds'] = self.hpc_cluster_ids
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.client_token = map.get('ClientToken')
        self.hpc_cluster_ids = map.get('HpcClusterIds')
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        return self


class DescribeHpcClustersResponse(TeaModel):
    def __init__(self, request_id=None, total_count=None, page_number=None, page_size=None, hpc_clusters=None):
        self.request_id = request_id
        self.total_count = total_count
        self.page_number = page_number
        self.page_size = page_size
        self.hpc_clusters = hpc_clusters

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.page_number, 'page_number')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.hpc_clusters, 'hpc_clusters')
        if self.hpc_clusters:
            self.hpc_clusters.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['TotalCount'] = self.total_count
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        if self.hpc_clusters is not None:
            result['HpcClusters'] = self.hpc_clusters.to_map()
        else:
            result['HpcClusters'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.total_count = map.get('TotalCount')
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        if map.get('HpcClusters') is not None:
            temp_model = DescribeHpcClustersResponseHpcClusters()
            self.hpc_clusters = temp_model.from_map(map['HpcClusters'])
        else:
            self.hpc_clusters = None
        return self


class DescribeHpcClustersResponseHpcClustersHpcCluster(TeaModel):
    def __init__(self, hpc_cluster_id=None, name=None, description=None):
        self.hpc_cluster_id = hpc_cluster_id
        self.name = name
        self.description = description

    def validate(self):
        self.validate_required(self.hpc_cluster_id, 'hpc_cluster_id')
        self.validate_required(self.name, 'name')
        self.validate_required(self.description, 'description')

    def to_map(self):
        result = {}
        result['HpcClusterId'] = self.hpc_cluster_id
        result['Name'] = self.name
        result['Description'] = self.description
        return result

    def from_map(self, map={}):
        self.hpc_cluster_id = map.get('HpcClusterId')
        self.name = map.get('Name')
        self.description = map.get('Description')
        return self


class DescribeHpcClustersResponseHpcClusters(TeaModel):
    def __init__(self, hpc_cluster=None):
        self.hpc_cluster = hpc_cluster

    def validate(self):
        self.validate_required(self.hpc_cluster, 'hpc_cluster')
        if self.hpc_cluster:
            for k in self.hpc_cluster:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['HpcCluster'] = []
        if self.hpc_cluster is not None:
            for k in self.hpc_cluster:
                result['HpcCluster'].append(k.to_map() if k else None)
        else:
            result['HpcCluster'] = None
        return result

    def from_map(self, map={}):
        self.hpc_cluster = []
        if map.get('HpcCluster') is not None:
            for k in map.get('HpcCluster'):
                temp_model = DescribeHpcClustersResponseHpcClustersHpcCluster()
                temp_model = temp_model.from_map(k)
                self.hpc_cluster.append(temp_model)
        else:
            self.hpc_cluster = None
        return self
class DeleteHpcClusterRequest(TeaModel):
    def __init__(self, region_id=None, client_token=None, hpc_cluster_id=None):
        self.region_id = region_id
        self.client_token = client_token
        self.hpc_cluster_id = hpc_cluster_id

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.hpc_cluster_id, 'hpc_cluster_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['ClientToken'] = self.client_token
        result['HpcClusterId'] = self.hpc_cluster_id
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.client_token = map.get('ClientToken')
        self.hpc_cluster_id = map.get('HpcClusterId')
        return self


class DeleteHpcClusterResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class CreateHpcClusterRequest(TeaModel):
    def __init__(self, region_id=None, client_token=None, description=None, name=None):
        self.region_id = region_id
        self.client_token = client_token
        self.description = description
        self.name = name

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.name, 'name')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['ClientToken'] = self.client_token
        result['Description'] = self.description
        result['Name'] = self.name
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.client_token = map.get('ClientToken')
        self.description = map.get('Description')
        self.name = map.get('Name')
        return self


class CreateHpcClusterResponse(TeaModel):
    def __init__(self, request_id=None, hpc_cluster_id=None):
        self.request_id = request_id
        self.hpc_cluster_id = hpc_cluster_id

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.hpc_cluster_id, 'hpc_cluster_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['HpcClusterId'] = self.hpc_cluster_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.hpc_cluster_id = map.get('HpcClusterId')
        return self


class DescribeSnapshotsUsageRequest(TeaModel):
    def __init__(self, region_id=None):
        self.region_id = region_id

    def validate(self):
        self.validate_required(self.region_id, 'region_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        return self


class DescribeSnapshotsUsageResponse(TeaModel):
    def __init__(self, request_id=None, snapshot_count=None, snapshot_size=None):
        self.request_id = request_id
        self.snapshot_count = snapshot_count
        self.snapshot_size = snapshot_size

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.snapshot_count, 'snapshot_count')
        self.validate_required(self.snapshot_size, 'snapshot_size')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['SnapshotCount'] = self.snapshot_count
        result['SnapshotSize'] = self.snapshot_size
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.snapshot_count = map.get('SnapshotCount')
        self.snapshot_size = map.get('SnapshotSize')
        return self


class DescribeSpotPriceHistoryRequest(TeaModel):
    def __init__(self, region_id=None, zone_id=None, network_type=None, instance_type=None, spot_duration=None,
                 io_optimized=None, start_time=None, end_time=None, ostype=None, offset=None):
        self.region_id = region_id
        self.zone_id = zone_id
        self.network_type = network_type
        self.instance_type = instance_type
        self.spot_duration = spot_duration
        self.io_optimized = io_optimized
        self.start_time = start_time
        self.end_time = end_time
        self.ostype = ostype
        self.offset = offset

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.network_type, 'network_type')
        self.validate_required(self.instance_type, 'instance_type')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['ZoneId'] = self.zone_id
        result['NetworkType'] = self.network_type
        result['InstanceType'] = self.instance_type
        result['SpotDuration'] = self.spot_duration
        result['IoOptimized'] = self.io_optimized
        result['StartTime'] = self.start_time
        result['EndTime'] = self.end_time
        result['OSType'] = self.ostype
        result['Offset'] = self.offset
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.zone_id = map.get('ZoneId')
        self.network_type = map.get('NetworkType')
        self.instance_type = map.get('InstanceType')
        self.spot_duration = map.get('SpotDuration')
        self.io_optimized = map.get('IoOptimized')
        self.start_time = map.get('StartTime')
        self.end_time = map.get('EndTime')
        self.ostype = map.get('OSType')
        self.offset = map.get('Offset')
        return self


class DescribeSpotPriceHistoryResponse(TeaModel):
    def __init__(self, request_id=None, next_offset=None, currency=None, spot_prices=None):
        self.request_id = request_id
        self.next_offset = next_offset
        self.currency = currency
        self.spot_prices = spot_prices

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.next_offset, 'next_offset')
        self.validate_required(self.currency, 'currency')
        self.validate_required(self.spot_prices, 'spot_prices')
        if self.spot_prices:
            self.spot_prices.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['NextOffset'] = self.next_offset
        result['Currency'] = self.currency
        if self.spot_prices is not None:
            result['SpotPrices'] = self.spot_prices.to_map()
        else:
            result['SpotPrices'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.next_offset = map.get('NextOffset')
        self.currency = map.get('Currency')
        if map.get('SpotPrices') is not None:
            temp_model = DescribeSpotPriceHistoryResponseSpotPrices()
            self.spot_prices = temp_model.from_map(map['SpotPrices'])
        else:
            self.spot_prices = None
        return self


class DescribeSpotPriceHistoryResponseSpotPricesSpotPriceType(TeaModel):
    def __init__(self, zone_id=None, instance_type=None, io_optimized=None, timestamp=None, network_type=None,
                 spot_price=None, origin_price=None):
        self.zone_id = zone_id
        self.instance_type = instance_type
        self.io_optimized = io_optimized
        self.timestamp = timestamp
        self.network_type = network_type
        self.spot_price = spot_price
        self.origin_price = origin_price

    def validate(self):
        self.validate_required(self.zone_id, 'zone_id')
        self.validate_required(self.instance_type, 'instance_type')
        self.validate_required(self.io_optimized, 'io_optimized')
        self.validate_required(self.timestamp, 'timestamp')
        self.validate_required(self.network_type, 'network_type')
        self.validate_required(self.spot_price, 'spot_price')
        self.validate_required(self.origin_price, 'origin_price')

    def to_map(self):
        result = {}
        result['ZoneId'] = self.zone_id
        result['InstanceType'] = self.instance_type
        result['IoOptimized'] = self.io_optimized
        result['Timestamp'] = self.timestamp
        result['NetworkType'] = self.network_type
        result['SpotPrice'] = self.spot_price
        result['OriginPrice'] = self.origin_price
        return result

    def from_map(self, map={}):
        self.zone_id = map.get('ZoneId')
        self.instance_type = map.get('InstanceType')
        self.io_optimized = map.get('IoOptimized')
        self.timestamp = map.get('Timestamp')
        self.network_type = map.get('NetworkType')
        self.spot_price = map.get('SpotPrice')
        self.origin_price = map.get('OriginPrice')
        return self


class DescribeSpotPriceHistoryResponseSpotPrices(TeaModel):
    def __init__(self, spot_price_type=None):
        self.spot_price_type = spot_price_type

    def validate(self):
        self.validate_required(self.spot_price_type, 'spot_price_type')
        if self.spot_price_type:
            for k in self.spot_price_type:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['SpotPriceType'] = []
        if self.spot_price_type is not None:
            for k in self.spot_price_type:
                result['SpotPriceType'].append(k.to_map() if k else None)
        else:
            result['SpotPriceType'] = None
        return result

    def from_map(self, map={}):
        self.spot_price_type = []
        if map.get('SpotPriceType') is not None:
            for k in map.get('SpotPriceType'):
                temp_model = DescribeSpotPriceHistoryResponseSpotPricesSpotPriceType()
                temp_model = temp_model.from_map(k)
                self.spot_price_type.append(temp_model)
        else:
            self.spot_price_type = None
        return self
class StopInvocationRequest(TeaModel):
    def __init__(self, region_id=None, invoke_id=None, instance_id=None):
        self.region_id = region_id
        self.invoke_id = invoke_id
        self.instance_id = instance_id

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.invoke_id, 'invoke_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['InvokeId'] = self.invoke_id
        result['InstanceId'] = []
        if self.instance_id is not None:
            for k in self.instance_id:
                result['InstanceId'].append(k)
        else:
            result['InstanceId'] = None
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.invoke_id = map.get('InvokeId')
        self.instance_id = []
        if map.get('InstanceId') is not None:
            for k in map.get('InstanceId'):
                self.instance_id.append(k)
        else:
            self.instance_id = None
        return self


class StopInvocationResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class ModifyCommandRequest(TeaModel):
    def __init__(self, region_id=None, command_id=None, name=None, description=None, command_content=None,
                 working_dir=None, timeout=None):
        self.region_id = region_id
        self.command_id = command_id
        self.name = name
        self.description = description
        self.command_content = command_content
        self.working_dir = working_dir
        self.timeout = timeout

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.command_id, 'command_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['CommandId'] = self.command_id
        result['Name'] = self.name
        result['Description'] = self.description
        result['CommandContent'] = self.command_content
        result['WorkingDir'] = self.working_dir
        result['Timeout'] = self.timeout
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.command_id = map.get('CommandId')
        self.name = map.get('Name')
        self.description = map.get('Description')
        self.command_content = map.get('CommandContent')
        self.working_dir = map.get('WorkingDir')
        self.timeout = map.get('Timeout')
        return self


class ModifyCommandResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class InvokeCommandRequest(TeaModel):
    def __init__(self, region_id=None, command_id=None, timed=None, frequency=None, instance_id=None,
                 parameters=None):
        self.region_id = region_id
        self.command_id = command_id
        self.timed = timed
        self.frequency = frequency
        self.instance_id = instance_id
        self.parameters = parameters

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.command_id, 'command_id')
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['CommandId'] = self.command_id
        result['Timed'] = self.timed
        result['Frequency'] = self.frequency
        result['InstanceId'] = []
        if self.instance_id is not None:
            for k in self.instance_id:
                result['InstanceId'].append(k)
        else:
            result['InstanceId'] = None
        result['Parameters'] = self.parameters
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.command_id = map.get('CommandId')
        self.timed = map.get('Timed')
        self.frequency = map.get('Frequency')
        self.instance_id = []
        if map.get('InstanceId') is not None:
            for k in map.get('InstanceId'):
                self.instance_id.append(k)
        else:
            self.instance_id = None
        self.parameters = map.get('Parameters')
        return self


class InvokeCommandResponse(TeaModel):
    def __init__(self, request_id=None, invoke_id=None):
        self.request_id = request_id
        self.invoke_id = invoke_id

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.invoke_id, 'invoke_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['InvokeId'] = self.invoke_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.invoke_id = map.get('InvokeId')
        return self


class DescribeInvocationsRequest(TeaModel):
    def __init__(self, region_id=None, invoke_id=None, command_id=None, command_name=None, command_type=None,
                 timed=None, invoke_status=None, instance_id=None, content_encoding=None, include_output=None,
                 page_number=None, page_size=None):
        self.region_id = region_id
        self.invoke_id = invoke_id
        self.command_id = command_id
        self.command_name = command_name
        self.command_type = command_type
        self.timed = timed
        self.invoke_status = invoke_status
        self.instance_id = instance_id
        self.content_encoding = content_encoding
        self.include_output = include_output
        self.page_number = page_number
        self.page_size = page_size

    def validate(self):
        self.validate_required(self.region_id, 'region_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['InvokeId'] = self.invoke_id
        result['CommandId'] = self.command_id
        result['CommandName'] = self.command_name
        result['CommandType'] = self.command_type
        result['Timed'] = self.timed
        result['InvokeStatus'] = self.invoke_status
        result['InstanceId'] = self.instance_id
        result['ContentEncoding'] = self.content_encoding
        result['IncludeOutput'] = self.include_output
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.invoke_id = map.get('InvokeId')
        self.command_id = map.get('CommandId')
        self.command_name = map.get('CommandName')
        self.command_type = map.get('CommandType')
        self.timed = map.get('Timed')
        self.invoke_status = map.get('InvokeStatus')
        self.instance_id = map.get('InstanceId')
        self.content_encoding = map.get('ContentEncoding')
        self.include_output = map.get('IncludeOutput')
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        return self


class DescribeInvocationsResponse(TeaModel):
    def __init__(self, request_id=None, total_count=None, page_number=None, page_size=None, invocations=None):
        self.request_id = request_id
        self.total_count = total_count
        self.page_number = page_number
        self.page_size = page_size
        self.invocations = invocations

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.page_number, 'page_number')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.invocations, 'invocations')
        if self.invocations:
            self.invocations.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['TotalCount'] = self.total_count
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        if self.invocations is not None:
            result['Invocations'] = self.invocations.to_map()
        else:
            result['Invocations'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.total_count = map.get('TotalCount')
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        if map.get('Invocations') is not None:
            temp_model = DescribeInvocationsResponseInvocations()
            self.invocations = temp_model.from_map(map['Invocations'])
        else:
            self.invocations = None
        return self


class DescribeInvocationsResponseInvocationsInvocationInvokeInstancesInvokeInstance(TeaModel):
    def __init__(self, instance_id=None, repeats=None, instance_invoke_status=None, invocation_status=None,
                 output=None, exit_code=None, dropped=None, error_code=None, error_info=None, creation_time=None,
                 start_time=None, stop_time=None, finish_time=None, update_time=None):
        self.instance_id = instance_id
        self.repeats = repeats
        self.instance_invoke_status = instance_invoke_status
        self.invocation_status = invocation_status
        self.output = output
        self.exit_code = exit_code
        self.dropped = dropped
        self.error_code = error_code
        self.error_info = error_info
        self.creation_time = creation_time
        self.start_time = start_time
        self.stop_time = stop_time
        self.finish_time = finish_time
        self.update_time = update_time

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.repeats, 'repeats')
        self.validate_required(self.instance_invoke_status, 'instance_invoke_status')
        self.validate_required(self.invocation_status, 'invocation_status')
        self.validate_required(self.output, 'output')
        self.validate_required(self.exit_code, 'exit_code')
        self.validate_required(self.dropped, 'dropped')
        self.validate_required(self.error_code, 'error_code')
        self.validate_required(self.error_info, 'error_info')
        self.validate_required(self.creation_time, 'creation_time')
        self.validate_required(self.start_time, 'start_time')
        self.validate_required(self.stop_time, 'stop_time')
        self.validate_required(self.finish_time, 'finish_time')
        self.validate_required(self.update_time, 'update_time')

    def to_map(self):
        result = {}
        result['InstanceId'] = self.instance_id
        result['Repeats'] = self.repeats
        result['InstanceInvokeStatus'] = self.instance_invoke_status
        result['InvocationStatus'] = self.invocation_status
        result['Output'] = self.output
        result['ExitCode'] = self.exit_code
        result['Dropped'] = self.dropped
        result['ErrorCode'] = self.error_code
        result['ErrorInfo'] = self.error_info
        result['CreationTime'] = self.creation_time
        result['StartTime'] = self.start_time
        result['StopTime'] = self.stop_time
        result['FinishTime'] = self.finish_time
        result['UpdateTime'] = self.update_time
        return result

    def from_map(self, map={}):
        self.instance_id = map.get('InstanceId')
        self.repeats = map.get('Repeats')
        self.instance_invoke_status = map.get('InstanceInvokeStatus')
        self.invocation_status = map.get('InvocationStatus')
        self.output = map.get('Output')
        self.exit_code = map.get('ExitCode')
        self.dropped = map.get('Dropped')
        self.error_code = map.get('ErrorCode')
        self.error_info = map.get('ErrorInfo')
        self.creation_time = map.get('CreationTime')
        self.start_time = map.get('StartTime')
        self.stop_time = map.get('StopTime')
        self.finish_time = map.get('FinishTime')
        self.update_time = map.get('UpdateTime')
        return self


class DescribeInvocationsResponseInvocationsInvocationInvokeInstances(TeaModel):
    def __init__(self, invoke_instance=None):
        self.invoke_instance = invoke_instance

    def validate(self):
        self.validate_required(self.invoke_instance, 'invoke_instance')
        if self.invoke_instance:
            for k in self.invoke_instance:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['InvokeInstance'] = []
        if self.invoke_instance is not None:
            for k in self.invoke_instance:
                result['InvokeInstance'].append(k.to_map() if k else None)
        else:
            result['InvokeInstance'] = None
        return result

    def from_map(self, map={}):
        self.invoke_instance = []
        if map.get('InvokeInstance') is not None:
            for k in map.get('InvokeInstance'):
                temp_model = DescribeInvocationsResponseInvocationsInvocationInvokeInstancesInvokeInstance()
                temp_model = temp_model.from_map(k)
                self.invoke_instance.append(temp_model)
        else:
            self.invoke_instance = None
        return self


class DescribeInvocationsResponseInvocationsInvocation(TeaModel):
    def __init__(self, invoke_id=None, creation_time=None, command_id=None, command_type=None, command_name=None,
                 command_content=None, frequency=None, timed=None, invoke_status=None, invocation_status=None, parameters=None,
                 invoke_instances=None):
        self.invoke_id = invoke_id
        self.creation_time = creation_time
        self.command_id = command_id
        self.command_type = command_type
        self.command_name = command_name
        self.command_content = command_content
        self.frequency = frequency
        self.timed = timed
        self.invoke_status = invoke_status
        self.invocation_status = invocation_status
        self.parameters = parameters
        self.invoke_instances = invoke_instances

    def validate(self):
        self.validate_required(self.invoke_id, 'invoke_id')
        self.validate_required(self.creation_time, 'creation_time')
        self.validate_required(self.command_id, 'command_id')
        self.validate_required(self.command_type, 'command_type')
        self.validate_required(self.command_name, 'command_name')
        self.validate_required(self.command_content, 'command_content')
        self.validate_required(self.frequency, 'frequency')
        self.validate_required(self.timed, 'timed')
        self.validate_required(self.invoke_status, 'invoke_status')
        self.validate_required(self.invocation_status, 'invocation_status')
        self.validate_required(self.parameters, 'parameters')
        self.validate_required(self.invoke_instances, 'invoke_instances')
        if self.invoke_instances:
            self.invoke_instances.validate()

    def to_map(self):
        result = {}
        result['InvokeId'] = self.invoke_id
        result['CreationTime'] = self.creation_time
        result['CommandId'] = self.command_id
        result['CommandType'] = self.command_type
        result['CommandName'] = self.command_name
        result['CommandContent'] = self.command_content
        result['Frequency'] = self.frequency
        result['Timed'] = self.timed
        result['InvokeStatus'] = self.invoke_status
        result['InvocationStatus'] = self.invocation_status
        result['Parameters'] = self.parameters
        if self.invoke_instances is not None:
            result['InvokeInstances'] = self.invoke_instances.to_map()
        else:
            result['InvokeInstances'] = None
        return result

    def from_map(self, map={}):
        self.invoke_id = map.get('InvokeId')
        self.creation_time = map.get('CreationTime')
        self.command_id = map.get('CommandId')
        self.command_type = map.get('CommandType')
        self.command_name = map.get('CommandName')
        self.command_content = map.get('CommandContent')
        self.frequency = map.get('Frequency')
        self.timed = map.get('Timed')
        self.invoke_status = map.get('InvokeStatus')
        self.invocation_status = map.get('InvocationStatus')
        self.parameters = map.get('Parameters')
        if map.get('InvokeInstances') is not None:
            temp_model = DescribeInvocationsResponseInvocationsInvocationInvokeInstances()
            self.invoke_instances = temp_model.from_map(map['InvokeInstances'])
        else:
            self.invoke_instances = None
        return self


class DescribeInvocationsResponseInvocations(TeaModel):
    def __init__(self, invocation=None):
        self.invocation = invocation

    def validate(self):
        self.validate_required(self.invocation, 'invocation')
        if self.invocation:
            for k in self.invocation:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['Invocation'] = []
        if self.invocation is not None:
            for k in self.invocation:
                result['Invocation'].append(k.to_map() if k else None)
        else:
            result['Invocation'] = None
        return result

    def from_map(self, map={}):
        self.invocation = []
        if map.get('Invocation') is not None:
            for k in map.get('Invocation'):
                temp_model = DescribeInvocationsResponseInvocationsInvocation()
                temp_model = temp_model.from_map(k)
                self.invocation.append(temp_model)
        else:
            self.invocation = None
        return self
class DescribeInvocationResultsRequest(TeaModel):
    def __init__(self, region_id=None, invoke_id=None, instance_id=None, command_id=None, invoke_record_status=None,
                 include_history=None, content_encoding=None, page_number=None, page_size=None):
        self.region_id = region_id
        self.invoke_id = invoke_id
        self.instance_id = instance_id
        self.command_id = command_id
        self.invoke_record_status = invoke_record_status
        self.include_history = include_history
        self.content_encoding = content_encoding
        self.page_number = page_number
        self.page_size = page_size

    def validate(self):
        self.validate_required(self.region_id, 'region_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['InvokeId'] = self.invoke_id
        result['InstanceId'] = self.instance_id
        result['CommandId'] = self.command_id
        result['InvokeRecordStatus'] = self.invoke_record_status
        result['IncludeHistory'] = self.include_history
        result['ContentEncoding'] = self.content_encoding
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.invoke_id = map.get('InvokeId')
        self.instance_id = map.get('InstanceId')
        self.command_id = map.get('CommandId')
        self.invoke_record_status = map.get('InvokeRecordStatus')
        self.include_history = map.get('IncludeHistory')
        self.content_encoding = map.get('ContentEncoding')
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        return self


class DescribeInvocationResultsResponse(TeaModel):
    def __init__(self, request_id=None, invocation=None):
        self.request_id = request_id
        self.invocation = invocation

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.invocation, 'invocation')
        if self.invocation:
            self.invocation.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        if self.invocation is not None:
            result['Invocation'] = self.invocation.to_map()
        else:
            result['Invocation'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        if map.get('Invocation') is not None:
            temp_model = DescribeInvocationResultsResponseInvocation()
            self.invocation = temp_model.from_map(map['Invocation'])
        else:
            self.invocation = None
        return self


class DescribeInvocationResultsResponseInvocationInvocationResultsInvocationResult(TeaModel):
    def __init__(self, command_id=None, invoke_id=None, instance_id=None, start_time=None, stop_time=None,
                 finished_time=None, repeats=None, output=None, dropped=None, invoke_record_status=None, invocation_status=None,
                 exit_code=None, error_code=None, error_info=None):
        self.command_id = command_id
        self.invoke_id = invoke_id
        self.instance_id = instance_id
        self.start_time = start_time
        self.stop_time = stop_time
        self.finished_time = finished_time
        self.repeats = repeats
        self.output = output
        self.dropped = dropped
        self.invoke_record_status = invoke_record_status
        self.invocation_status = invocation_status
        self.exit_code = exit_code
        self.error_code = error_code
        self.error_info = error_info

    def validate(self):
        self.validate_required(self.command_id, 'command_id')
        self.validate_required(self.invoke_id, 'invoke_id')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.start_time, 'start_time')
        self.validate_required(self.stop_time, 'stop_time')
        self.validate_required(self.finished_time, 'finished_time')
        self.validate_required(self.repeats, 'repeats')
        self.validate_required(self.output, 'output')
        self.validate_required(self.dropped, 'dropped')
        self.validate_required(self.invoke_record_status, 'invoke_record_status')
        self.validate_required(self.invocation_status, 'invocation_status')
        self.validate_required(self.exit_code, 'exit_code')
        self.validate_required(self.error_code, 'error_code')
        self.validate_required(self.error_info, 'error_info')

    def to_map(self):
        result = {}
        result['CommandId'] = self.command_id
        result['InvokeId'] = self.invoke_id
        result['InstanceId'] = self.instance_id
        result['StartTime'] = self.start_time
        result['StopTime'] = self.stop_time
        result['FinishedTime'] = self.finished_time
        result['Repeats'] = self.repeats
        result['Output'] = self.output
        result['Dropped'] = self.dropped
        result['InvokeRecordStatus'] = self.invoke_record_status
        result['InvocationStatus'] = self.invocation_status
        result['ExitCode'] = self.exit_code
        result['ErrorCode'] = self.error_code
        result['ErrorInfo'] = self.error_info
        return result

    def from_map(self, map={}):
        self.command_id = map.get('CommandId')
        self.invoke_id = map.get('InvokeId')
        self.instance_id = map.get('InstanceId')
        self.start_time = map.get('StartTime')
        self.stop_time = map.get('StopTime')
        self.finished_time = map.get('FinishedTime')
        self.repeats = map.get('Repeats')
        self.output = map.get('Output')
        self.dropped = map.get('Dropped')
        self.invoke_record_status = map.get('InvokeRecordStatus')
        self.invocation_status = map.get('InvocationStatus')
        self.exit_code = map.get('ExitCode')
        self.error_code = map.get('ErrorCode')
        self.error_info = map.get('ErrorInfo')
        return self


class DescribeInvocationResultsResponseInvocationInvocationResults(TeaModel):
    def __init__(self, invocation_result=None):
        self.invocation_result = invocation_result

    def validate(self):
        self.validate_required(self.invocation_result, 'invocation_result')
        if self.invocation_result:
            for k in self.invocation_result:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['InvocationResult'] = []
        if self.invocation_result is not None:
            for k in self.invocation_result:
                result['InvocationResult'].append(k.to_map() if k else None)
        else:
            result['InvocationResult'] = None
        return result

    def from_map(self, map={}):
        self.invocation_result = []
        if map.get('InvocationResult') is not None:
            for k in map.get('InvocationResult'):
                temp_model = DescribeInvocationResultsResponseInvocationInvocationResultsInvocationResult()
                temp_model = temp_model.from_map(k)
                self.invocation_result.append(temp_model)
        else:
            self.invocation_result = None
        return self


class DescribeInvocationResultsResponseInvocation(TeaModel):
    def __init__(self, page_size=None, page_number=None, total_count=None, invocation_results=None):
        self.page_size = page_size
        self.page_number = page_number
        self.total_count = total_count
        self.invocation_results = invocation_results

    def validate(self):
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.page_number, 'page_number')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.invocation_results, 'invocation_results')
        if self.invocation_results:
            self.invocation_results.validate()

    def to_map(self):
        result = {}
        result['PageSize'] = self.page_size
        result['PageNumber'] = self.page_number
        result['TotalCount'] = self.total_count
        if self.invocation_results is not None:
            result['InvocationResults'] = self.invocation_results.to_map()
        else:
            result['InvocationResults'] = None
        return result

    def from_map(self, map={}):
        self.page_size = map.get('PageSize')
        self.page_number = map.get('PageNumber')
        self.total_count = map.get('TotalCount')
        if map.get('InvocationResults') is not None:
            temp_model = DescribeInvocationResultsResponseInvocationInvocationResults()
            self.invocation_results = temp_model.from_map(map['InvocationResults'])
        else:
            self.invocation_results = None
        return self
class DescribeCommandsRequest(TeaModel):
    def __init__(self, region_id=None, command_id=None, name=None, description=None, type=None,
                 content_encoding=None, page_number=None, page_size=None):
        self.region_id = region_id
        self.command_id = command_id
        self.name = name
        self.description = description
        self.type = type
        self.content_encoding = content_encoding
        self.page_number = page_number
        self.page_size = page_size

    def validate(self):
        self.validate_required(self.region_id, 'region_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['CommandId'] = self.command_id
        result['Name'] = self.name
        result['Description'] = self.description
        result['Type'] = self.type
        result['ContentEncoding'] = self.content_encoding
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.command_id = map.get('CommandId')
        self.name = map.get('Name')
        self.description = map.get('Description')
        self.type = map.get('Type')
        self.content_encoding = map.get('ContentEncoding')
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        return self


class DescribeCommandsResponse(TeaModel):
    def __init__(self, request_id=None, total_count=None, page_number=None, page_size=None, commands=None):
        self.request_id = request_id
        self.total_count = total_count
        self.page_number = page_number
        self.page_size = page_size
        self.commands = commands

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.page_number, 'page_number')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.commands, 'commands')
        if self.commands:
            self.commands.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['TotalCount'] = self.total_count
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        if self.commands is not None:
            result['Commands'] = self.commands.to_map()
        else:
            result['Commands'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.total_count = map.get('TotalCount')
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        if map.get('Commands') is not None:
            temp_model = DescribeCommandsResponseCommands()
            self.commands = temp_model.from_map(map['Commands'])
        else:
            self.commands = None
        return self


class DescribeCommandsResponseCommandsCommandParameterNames(TeaModel):
    def __init__(self, parameter_name=None):
        # ParameterName
        self.parameter_name = parameter_name

    def validate(self):
        self.validate_required(self.parameter_name, 'parameter_name')

    def to_map(self):
        result = {}
        result['ParameterName'] = []
        if self.parameter_name is not None:
            for k in self.parameter_name:
                result['ParameterName'].append(k)
        else:
            result['ParameterName'] = None
        return result

    def from_map(self, map={}):
        self.parameter_name = []
        if map.get('ParameterName') is not None:
            for k in map.get('ParameterName'):
                self.parameter_name.append(k)
        else:
            self.parameter_name = None
        return self


class DescribeCommandsResponseCommandsCommand(TeaModel):
    def __init__(self, command_id=None, name=None, type=None, description=None, command_content=None,
                 working_dir=None, timeout=None, invoke_times=None, creation_time=None, enable_parameter=None,
                 parameter_names=None):
        self.command_id = command_id
        self.name = name
        self.type = type
        self.description = description
        self.command_content = command_content
        self.working_dir = working_dir
        self.timeout = timeout
        self.invoke_times = invoke_times
        self.creation_time = creation_time
        self.enable_parameter = enable_parameter
        self.parameter_names = parameter_names

    def validate(self):
        self.validate_required(self.command_id, 'command_id')
        self.validate_required(self.name, 'name')
        self.validate_required(self.type, 'type')
        self.validate_required(self.description, 'description')
        self.validate_required(self.command_content, 'command_content')
        self.validate_required(self.working_dir, 'working_dir')
        self.validate_required(self.timeout, 'timeout')
        self.validate_required(self.invoke_times, 'invoke_times')
        self.validate_required(self.creation_time, 'creation_time')
        self.validate_required(self.enable_parameter, 'enable_parameter')
        self.validate_required(self.parameter_names, 'parameter_names')
        if self.parameter_names:
            self.parameter_names.validate()

    def to_map(self):
        result = {}
        result['CommandId'] = self.command_id
        result['Name'] = self.name
        result['Type'] = self.type
        result['Description'] = self.description
        result['CommandContent'] = self.command_content
        result['WorkingDir'] = self.working_dir
        result['Timeout'] = self.timeout
        result['InvokeTimes'] = self.invoke_times
        result['CreationTime'] = self.creation_time
        result['EnableParameter'] = self.enable_parameter
        if self.parameter_names is not None:
            result['ParameterNames'] = self.parameter_names.to_map()
        else:
            result['ParameterNames'] = None
        return result

    def from_map(self, map={}):
        self.command_id = map.get('CommandId')
        self.name = map.get('Name')
        self.type = map.get('Type')
        self.description = map.get('Description')
        self.command_content = map.get('CommandContent')
        self.working_dir = map.get('WorkingDir')
        self.timeout = map.get('Timeout')
        self.invoke_times = map.get('InvokeTimes')
        self.creation_time = map.get('CreationTime')
        self.enable_parameter = map.get('EnableParameter')
        if map.get('ParameterNames') is not None:
            temp_model = DescribeCommandsResponseCommandsCommandParameterNames()
            self.parameter_names = temp_model.from_map(map['ParameterNames'])
        else:
            self.parameter_names = None
        return self


class DescribeCommandsResponseCommands(TeaModel):
    def __init__(self, command=None):
        self.command = command

    def validate(self):
        self.validate_required(self.command, 'command')
        if self.command:
            for k in self.command:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['Command'] = []
        if self.command is not None:
            for k in self.command:
                result['Command'].append(k.to_map() if k else None)
        else:
            result['Command'] = None
        return result

    def from_map(self, map={}):
        self.command = []
        if map.get('Command') is not None:
            for k in map.get('Command'):
                temp_model = DescribeCommandsResponseCommandsCommand()
                temp_model = temp_model.from_map(k)
                self.command.append(temp_model)
        else:
            self.command = None
        return self
class DeleteCommandRequest(TeaModel):
    def __init__(self, region_id=None, command_id=None):
        self.region_id = region_id
        self.command_id = command_id

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.command_id, 'command_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['CommandId'] = self.command_id
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.command_id = map.get('CommandId')
        return self


class DeleteCommandResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class CreateCommandRequest(TeaModel):
    def __init__(self, region_id=None, name=None, description=None, type=None, command_content=None,
                 working_dir=None, timeout=None, enable_parameter=None):
        self.region_id = region_id
        self.name = name
        self.description = description
        self.type = type
        self.command_content = command_content
        self.working_dir = working_dir
        self.timeout = timeout
        self.enable_parameter = enable_parameter

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.name, 'name')
        self.validate_required(self.type, 'type')
        self.validate_required(self.command_content, 'command_content')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['Name'] = self.name
        result['Description'] = self.description
        result['Type'] = self.type
        result['CommandContent'] = self.command_content
        result['WorkingDir'] = self.working_dir
        result['Timeout'] = self.timeout
        result['EnableParameter'] = self.enable_parameter
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.name = map.get('Name')
        self.description = map.get('Description')
        self.type = map.get('Type')
        self.command_content = map.get('CommandContent')
        self.working_dir = map.get('WorkingDir')
        self.timeout = map.get('Timeout')
        self.enable_parameter = map.get('EnableParameter')
        return self


class CreateCommandResponse(TeaModel):
    def __init__(self, request_id=None, command_id=None):
        self.request_id = request_id
        self.command_id = command_id

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.command_id, 'command_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['CommandId'] = self.command_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.command_id = map.get('CommandId')
        return self


class ModifySecurityGroupEgressRuleRequest(TeaModel):
    def __init__(self, region_id=None, security_group_id=None, ip_protocol=None, port_range=None,
                 dest_group_id=None, dest_group_owner_id=None, dest_group_owner_account=None, dest_cidr_ip=None,
                 ipv_6dest_cidr_ip=None, source_cidr_ip=None, ipv_6source_cidr_ip=None, source_port_range=None, policy=None,
                 priority=None, nic_type=None, client_token=None, description=None):
        self.region_id = region_id
        self.security_group_id = security_group_id
        self.ip_protocol = ip_protocol
        self.port_range = port_range
        self.dest_group_id = dest_group_id
        self.dest_group_owner_id = dest_group_owner_id
        self.dest_group_owner_account = dest_group_owner_account
        self.dest_cidr_ip = dest_cidr_ip
        self.ipv_6dest_cidr_ip = ipv_6dest_cidr_ip
        self.source_cidr_ip = source_cidr_ip
        self.ipv_6source_cidr_ip = ipv_6source_cidr_ip
        self.source_port_range = source_port_range
        self.policy = policy
        self.priority = priority
        self.nic_type = nic_type
        self.client_token = client_token
        self.description = description

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.security_group_id, 'security_group_id')
        self.validate_required(self.ip_protocol, 'ip_protocol')
        self.validate_required(self.port_range, 'port_range')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['SecurityGroupId'] = self.security_group_id
        result['IpProtocol'] = self.ip_protocol
        result['PortRange'] = self.port_range
        result['DestGroupId'] = self.dest_group_id
        result['DestGroupOwnerId'] = self.dest_group_owner_id
        result['DestGroupOwnerAccount'] = self.dest_group_owner_account
        result['DestCidrIp'] = self.dest_cidr_ip
        result['Ipv6DestCidrIp'] = self.ipv_6dest_cidr_ip
        result['SourceCidrIp'] = self.source_cidr_ip
        result['Ipv6SourceCidrIp'] = self.ipv_6source_cidr_ip
        result['SourcePortRange'] = self.source_port_range
        result['Policy'] = self.policy
        result['Priority'] = self.priority
        result['NicType'] = self.nic_type
        result['ClientToken'] = self.client_token
        result['Description'] = self.description
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.security_group_id = map.get('SecurityGroupId')
        self.ip_protocol = map.get('IpProtocol')
        self.port_range = map.get('PortRange')
        self.dest_group_id = map.get('DestGroupId')
        self.dest_group_owner_id = map.get('DestGroupOwnerId')
        self.dest_group_owner_account = map.get('DestGroupOwnerAccount')
        self.dest_cidr_ip = map.get('DestCidrIp')
        self.ipv_6dest_cidr_ip = map.get('Ipv6DestCidrIp')
        self.source_cidr_ip = map.get('SourceCidrIp')
        self.ipv_6source_cidr_ip = map.get('Ipv6SourceCidrIp')
        self.source_port_range = map.get('SourcePortRange')
        self.policy = map.get('Policy')
        self.priority = map.get('Priority')
        self.nic_type = map.get('NicType')
        self.client_token = map.get('ClientToken')
        self.description = map.get('Description')
        return self


class ModifySecurityGroupEgressRuleResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class ModifyDiskChargeTypeRequest(TeaModel):
    def __init__(self, instance_id=None, region_id=None, disk_ids=None, auto_pay=None, client_token=None,
                 disk_charge_type=None):
        self.instance_id = instance_id
        self.region_id = region_id
        self.disk_ids = disk_ids
        self.auto_pay = auto_pay
        self.client_token = client_token
        self.disk_charge_type = disk_charge_type

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.disk_ids, 'disk_ids')

    def to_map(self):
        result = {}
        result['InstanceId'] = self.instance_id
        result['RegionId'] = self.region_id
        result['DiskIds'] = self.disk_ids
        result['AutoPay'] = self.auto_pay
        result['ClientToken'] = self.client_token
        result['DiskChargeType'] = self.disk_charge_type
        return result

    def from_map(self, map={}):
        self.instance_id = map.get('InstanceId')
        self.region_id = map.get('RegionId')
        self.disk_ids = map.get('DiskIds')
        self.auto_pay = map.get('AutoPay')
        self.client_token = map.get('ClientToken')
        self.disk_charge_type = map.get('DiskChargeType')
        return self


class ModifyDiskChargeTypeResponse(TeaModel):
    def __init__(self, request_id=None, order_id=None):
        self.request_id = request_id
        self.order_id = order_id

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.order_id, 'order_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['OrderId'] = self.order_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.order_id = map.get('OrderId')
        return self


class ModifyNetworkInterfaceAttributeRequest(TeaModel):
    def __init__(self, region_id=None, security_group_id=None, network_interface_name=None,
                 network_interface_id=None, queue_number=None, description=None):
        self.region_id = region_id
        self.security_group_id = security_group_id
        self.network_interface_name = network_interface_name
        self.network_interface_id = network_interface_id
        self.queue_number = queue_number
        self.description = description

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.network_interface_id, 'network_interface_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['SecurityGroupId'] = []
        if self.security_group_id is not None:
            for k in self.security_group_id:
                result['SecurityGroupId'].append(k)
        else:
            result['SecurityGroupId'] = None
        result['NetworkInterfaceName'] = self.network_interface_name
        result['NetworkInterfaceId'] = self.network_interface_id
        result['QueueNumber'] = self.queue_number
        result['Description'] = self.description
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.security_group_id = []
        if map.get('SecurityGroupId') is not None:
            for k in map.get('SecurityGroupId'):
                self.security_group_id.append(k)
        else:
            self.security_group_id = None
        self.network_interface_name = map.get('NetworkInterfaceName')
        self.network_interface_id = map.get('NetworkInterfaceId')
        self.queue_number = map.get('QueueNumber')
        self.description = map.get('Description')
        return self


class ModifyNetworkInterfaceAttributeResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class DetachNetworkInterfaceRequest(TeaModel):
    def __init__(self, region_id=None, network_interface_id=None, instance_id=None, trunk_network_instance_id=None):
        self.region_id = region_id
        self.network_interface_id = network_interface_id
        self.instance_id = instance_id
        self.trunk_network_instance_id = trunk_network_instance_id

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.network_interface_id, 'network_interface_id')
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['NetworkInterfaceId'] = self.network_interface_id
        result['InstanceId'] = self.instance_id
        result['TrunkNetworkInstanceId'] = self.trunk_network_instance_id
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.network_interface_id = map.get('NetworkInterfaceId')
        self.instance_id = map.get('InstanceId')
        self.trunk_network_instance_id = map.get('TrunkNetworkInstanceId')
        return self


class DetachNetworkInterfaceResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class DescribeNetworkInterfacesRequest(TeaModel):
    def __init__(self, region_id=None, tag=None, resource_group_id=None, v_switch_id=None, vpc_id=None,
                 primary_ip_address=None, private_ip_address=None, security_group_id=None, network_interface_name=None, type=None,
                 instance_id=None, network_interface_id=None, service_managed=None, status=None, page_number=None,
                 page_size=None, next_token=None, max_results=None):
        self.region_id = region_id
        self.tag = tag
        self.resource_group_id = resource_group_id
        self.v_switch_id = v_switch_id
        self.vpc_id = vpc_id
        self.primary_ip_address = primary_ip_address
        self.private_ip_address = private_ip_address
        self.security_group_id = security_group_id
        self.network_interface_name = network_interface_name
        self.type = type
        self.instance_id = instance_id
        self.network_interface_id = network_interface_id
        self.service_managed = service_managed
        self.status = status
        self.page_number = page_number
        self.page_size = page_size
        self.next_token = next_token
        self.max_results = max_results

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        else:
            result['Tag'] = None
        result['ResourceGroupId'] = self.resource_group_id
        result['VSwitchId'] = self.v_switch_id
        result['VpcId'] = self.vpc_id
        result['PrimaryIpAddress'] = self.primary_ip_address
        result['PrivateIpAddress'] = []
        if self.private_ip_address is not None:
            for k in self.private_ip_address:
                result['PrivateIpAddress'].append(k)
        else:
            result['PrivateIpAddress'] = None
        result['SecurityGroupId'] = self.security_group_id
        result['NetworkInterfaceName'] = self.network_interface_name
        result['Type'] = self.type
        result['InstanceId'] = self.instance_id
        result['NetworkInterfaceId'] = []
        if self.network_interface_id is not None:
            for k in self.network_interface_id:
                result['NetworkInterfaceId'].append(k)
        else:
            result['NetworkInterfaceId'] = None
        result['ServiceManaged'] = self.service_managed
        result['Status'] = self.status
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        result['NextToken'] = self.next_token
        result['MaxResults'] = self.max_results
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.tag = []
        if map.get('Tag') is not None:
            for k in map.get('Tag'):
                temp_model = DescribeNetworkInterfacesRequestTag()
                temp_model = temp_model.from_map(k)
                self.tag.append(temp_model)
        else:
            self.tag = None
        self.resource_group_id = map.get('ResourceGroupId')
        self.v_switch_id = map.get('VSwitchId')
        self.vpc_id = map.get('VpcId')
        self.primary_ip_address = map.get('PrimaryIpAddress')
        self.private_ip_address = []
        if map.get('PrivateIpAddress') is not None:
            for k in map.get('PrivateIpAddress'):
                self.private_ip_address.append(k)
        else:
            self.private_ip_address = None
        self.security_group_id = map.get('SecurityGroupId')
        self.network_interface_name = map.get('NetworkInterfaceName')
        self.type = map.get('Type')
        self.instance_id = map.get('InstanceId')
        self.network_interface_id = []
        if map.get('NetworkInterfaceId') is not None:
            for k in map.get('NetworkInterfaceId'):
                self.network_interface_id.append(k)
        else:
            self.network_interface_id = None
        self.service_managed = map.get('ServiceManaged')
        self.status = map.get('Status')
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        self.next_token = map.get('NextToken')
        self.max_results = map.get('MaxResults')
        return self


class DescribeNetworkInterfacesRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key
        self.value = value

    def validate(self):
        self.validate_required(self.key, 'key')
        self.validate_required(self.value, 'value')

    def to_map(self):
        result = {}
        result['Key'] = self.key
        result['Value'] = self.value
        return result

    def from_map(self, map={}):
        self.key = map.get('Key')
        self.value = map.get('Value')
        return self
class DescribeNetworkInterfacesResponse(TeaModel):
    def __init__(self, request_id=None, total_count=None, page_number=None, page_size=None, next_token=None,
                 network_interface_sets=None):
        self.request_id = request_id
        self.total_count = total_count
        self.page_number = page_number
        self.page_size = page_size
        self.next_token = next_token
        self.network_interface_sets = network_interface_sets

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.page_number, 'page_number')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.next_token, 'next_token')
        self.validate_required(self.network_interface_sets, 'network_interface_sets')
        if self.network_interface_sets:
            self.network_interface_sets.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['TotalCount'] = self.total_count
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        result['NextToken'] = self.next_token
        if self.network_interface_sets is not None:
            result['NetworkInterfaceSets'] = self.network_interface_sets.to_map()
        else:
            result['NetworkInterfaceSets'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.total_count = map.get('TotalCount')
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        self.next_token = map.get('NextToken')
        if map.get('NetworkInterfaceSets') is not None:
            temp_model = DescribeNetworkInterfacesResponseNetworkInterfaceSets()
            self.network_interface_sets = temp_model.from_map(map['NetworkInterfaceSets'])
        else:
            self.network_interface_sets = None
        return self


class DescribeNetworkInterfacesResponseNetworkInterfaceSetsNetworkInterfaceSetPrivateIpSetsPrivateIpSetAssociatedPublicIp(TeaModel):
    def __init__(self, public_ip_address=None, allocation_id=None):
        self.public_ip_address = public_ip_address
        self.allocation_id = allocation_id

    def validate(self):
        self.validate_required(self.public_ip_address, 'public_ip_address')
        self.validate_required(self.allocation_id, 'allocation_id')

    def to_map(self):
        result = {}
        result['PublicIpAddress'] = self.public_ip_address
        result['AllocationId'] = self.allocation_id
        return result

    def from_map(self, map={}):
        self.public_ip_address = map.get('PublicIpAddress')
        self.allocation_id = map.get('AllocationId')
        return self


class DescribeNetworkInterfacesResponseNetworkInterfaceSetsNetworkInterfaceSetPrivateIpSetsPrivateIpSet(TeaModel):
    def __init__(self, private_ip_address=None, primary=None, associated_public_ip=None):
        self.private_ip_address = private_ip_address
        self.primary = primary
        self.associated_public_ip = associated_public_ip

    def validate(self):
        self.validate_required(self.private_ip_address, 'private_ip_address')
        self.validate_required(self.primary, 'primary')
        self.validate_required(self.associated_public_ip, 'associated_public_ip')
        if self.associated_public_ip:
            self.associated_public_ip.validate()

    def to_map(self):
        result = {}
        result['PrivateIpAddress'] = self.private_ip_address
        result['Primary'] = self.primary
        if self.associated_public_ip is not None:
            result['AssociatedPublicIp'] = self.associated_public_ip.to_map()
        else:
            result['AssociatedPublicIp'] = None
        return result

    def from_map(self, map={}):
        self.private_ip_address = map.get('PrivateIpAddress')
        self.primary = map.get('Primary')
        if map.get('AssociatedPublicIp') is not None:
            temp_model = DescribeNetworkInterfacesResponseNetworkInterfaceSetsNetworkInterfaceSetPrivateIpSetsPrivateIpSetAssociatedPublicIp()
            self.associated_public_ip = temp_model.from_map(map['AssociatedPublicIp'])
        else:
            self.associated_public_ip = None
        return self


class DescribeNetworkInterfacesResponseNetworkInterfaceSetsNetworkInterfaceSetPrivateIpSets(TeaModel):
    def __init__(self, private_ip_set=None):
        self.private_ip_set = private_ip_set

    def validate(self):
        self.validate_required(self.private_ip_set, 'private_ip_set')
        if self.private_ip_set:
            for k in self.private_ip_set:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['PrivateIpSet'] = []
        if self.private_ip_set is not None:
            for k in self.private_ip_set:
                result['PrivateIpSet'].append(k.to_map() if k else None)
        else:
            result['PrivateIpSet'] = None
        return result

    def from_map(self, map={}):
        self.private_ip_set = []
        if map.get('PrivateIpSet') is not None:
            for k in map.get('PrivateIpSet'):
                temp_model = DescribeNetworkInterfacesResponseNetworkInterfaceSetsNetworkInterfaceSetPrivateIpSetsPrivateIpSet()
                temp_model = temp_model.from_map(k)
                self.private_ip_set.append(temp_model)
        else:
            self.private_ip_set = None
        return self


class DescribeNetworkInterfacesResponseNetworkInterfaceSetsNetworkInterfaceSetIpv6SetsIpv6Set(TeaModel):
    def __init__(self, ipv_6address=None):
        self.ipv_6address = ipv_6address

    def validate(self):
        self.validate_required(self.ipv_6address, 'ipv_6address')

    def to_map(self):
        result = {}
        result['Ipv6Address'] = self.ipv_6address
        return result

    def from_map(self, map={}):
        self.ipv_6address = map.get('Ipv6Address')
        return self


class DescribeNetworkInterfacesResponseNetworkInterfaceSetsNetworkInterfaceSetIpv6Sets(TeaModel):
    def __init__(self, ipv_6set=None):
        self.ipv_6set = ipv_6set

    def validate(self):
        self.validate_required(self.ipv_6set, 'ipv_6set')
        if self.ipv_6set:
            for k in self.ipv_6set:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['Ipv6Set'] = []
        if self.ipv_6set is not None:
            for k in self.ipv_6set:
                result['Ipv6Set'].append(k.to_map() if k else None)
        else:
            result['Ipv6Set'] = None
        return result

    def from_map(self, map={}):
        self.ipv_6set = []
        if map.get('Ipv6Set') is not None:
            for k in map.get('Ipv6Set'):
                temp_model = DescribeNetworkInterfacesResponseNetworkInterfaceSetsNetworkInterfaceSetIpv6SetsIpv6Set()
                temp_model = temp_model.from_map(k)
                self.ipv_6set.append(temp_model)
        else:
            self.ipv_6set = None
        return self


class DescribeNetworkInterfacesResponseNetworkInterfaceSetsNetworkInterfaceSetTagsTag(TeaModel):
    def __init__(self, tag_key=None, tag_value=None):
        self.tag_key = tag_key
        self.tag_value = tag_value

    def validate(self):
        self.validate_required(self.tag_key, 'tag_key')
        self.validate_required(self.tag_value, 'tag_value')

    def to_map(self):
        result = {}
        result['TagKey'] = self.tag_key
        result['TagValue'] = self.tag_value
        return result

    def from_map(self, map={}):
        self.tag_key = map.get('TagKey')
        self.tag_value = map.get('TagValue')
        return self


class DescribeNetworkInterfacesResponseNetworkInterfaceSetsNetworkInterfaceSetTags(TeaModel):
    def __init__(self, tag=None):
        self.tag = tag

    def validate(self):
        self.validate_required(self.tag, 'tag')
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        else:
            result['Tag'] = None
        return result

    def from_map(self, map={}):
        self.tag = []
        if map.get('Tag') is not None:
            for k in map.get('Tag'):
                temp_model = DescribeNetworkInterfacesResponseNetworkInterfaceSetsNetworkInterfaceSetTagsTag()
                temp_model = temp_model.from_map(k)
                self.tag.append(temp_model)
        else:
            self.tag = None
        return self


class DescribeNetworkInterfacesResponseNetworkInterfaceSetsNetworkInterfaceSetAssociatedPublicIp(TeaModel):
    def __init__(self, public_ip_address=None, allocation_id=None):
        self.public_ip_address = public_ip_address
        self.allocation_id = allocation_id

    def validate(self):
        self.validate_required(self.public_ip_address, 'public_ip_address')
        self.validate_required(self.allocation_id, 'allocation_id')

    def to_map(self):
        result = {}
        result['PublicIpAddress'] = self.public_ip_address
        result['AllocationId'] = self.allocation_id
        return result

    def from_map(self, map={}):
        self.public_ip_address = map.get('PublicIpAddress')
        self.allocation_id = map.get('AllocationId')
        return self


class DescribeNetworkInterfacesResponseNetworkInterfaceSetsNetworkInterfaceSetAttachment(TeaModel):
    def __init__(self, instance_id=None, trunk_network_interface_id=None, device_index=None):
        self.instance_id = instance_id
        self.trunk_network_interface_id = trunk_network_interface_id
        self.device_index = device_index

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.trunk_network_interface_id, 'trunk_network_interface_id')
        self.validate_required(self.device_index, 'device_index')

    def to_map(self):
        result = {}
        result['InstanceId'] = self.instance_id
        result['TrunkNetworkInterfaceId'] = self.trunk_network_interface_id
        result['DeviceIndex'] = self.device_index
        return result

    def from_map(self, map={}):
        self.instance_id = map.get('InstanceId')
        self.trunk_network_interface_id = map.get('TrunkNetworkInterfaceId')
        self.device_index = map.get('DeviceIndex')
        return self


class DescribeNetworkInterfacesResponseNetworkInterfaceSetsNetworkInterfaceSetSecurityGroupIds(TeaModel):
    def __init__(self, security_group_id=None):
        # SecurityGroupId
        self.security_group_id = security_group_id

    def validate(self):
        self.validate_required(self.security_group_id, 'security_group_id')

    def to_map(self):
        result = {}
        result['SecurityGroupId'] = []
        if self.security_group_id is not None:
            for k in self.security_group_id:
                result['SecurityGroupId'].append(k)
        else:
            result['SecurityGroupId'] = None
        return result

    def from_map(self, map={}):
        self.security_group_id = []
        if map.get('SecurityGroupId') is not None:
            for k in map.get('SecurityGroupId'):
                self.security_group_id.append(k)
        else:
            self.security_group_id = None
        return self


class DescribeNetworkInterfacesResponseNetworkInterfaceSetsNetworkInterfaceSet(TeaModel):
    def __init__(self, network_interface_id=None, status=None, type=None, vpc_id=None, v_switch_id=None,
                 zone_id=None, private_ip_address=None, mac_address=None, network_interface_name=None, description=None,
                 instance_id=None, creation_time=None, resource_group_id=None, service_id=None, service_managed=None,
                 queue_number=None, owner_id=None, private_ip_sets=None, ipv_6sets=None, tags=None, associated_public_ip=None,
                 attachment=None, security_group_ids=None):
        self.network_interface_id = network_interface_id
        self.status = status
        self.type = type
        self.vpc_id = vpc_id
        self.v_switch_id = v_switch_id
        self.zone_id = zone_id
        self.private_ip_address = private_ip_address
        self.mac_address = mac_address
        self.network_interface_name = network_interface_name
        self.description = description
        self.instance_id = instance_id
        self.creation_time = creation_time
        self.resource_group_id = resource_group_id
        self.service_id = service_id
        self.service_managed = service_managed
        self.queue_number = queue_number
        self.owner_id = owner_id
        self.private_ip_sets = private_ip_sets
        self.ipv_6sets = ipv_6sets
        self.tags = tags
        self.associated_public_ip = associated_public_ip
        self.attachment = attachment
        self.security_group_ids = security_group_ids

    def validate(self):
        self.validate_required(self.network_interface_id, 'network_interface_id')
        self.validate_required(self.status, 'status')
        self.validate_required(self.type, 'type')
        self.validate_required(self.vpc_id, 'vpc_id')
        self.validate_required(self.v_switch_id, 'v_switch_id')
        self.validate_required(self.zone_id, 'zone_id')
        self.validate_required(self.private_ip_address, 'private_ip_address')
        self.validate_required(self.mac_address, 'mac_address')
        self.validate_required(self.network_interface_name, 'network_interface_name')
        self.validate_required(self.description, 'description')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.creation_time, 'creation_time')
        self.validate_required(self.resource_group_id, 'resource_group_id')
        self.validate_required(self.service_id, 'service_id')
        self.validate_required(self.service_managed, 'service_managed')
        self.validate_required(self.queue_number, 'queue_number')
        self.validate_required(self.owner_id, 'owner_id')
        self.validate_required(self.private_ip_sets, 'private_ip_sets')
        if self.private_ip_sets:
            self.private_ip_sets.validate()
        self.validate_required(self.ipv_6sets, 'ipv_6sets')
        if self.ipv_6sets:
            self.ipv_6sets.validate()
        self.validate_required(self.tags, 'tags')
        if self.tags:
            self.tags.validate()
        self.validate_required(self.associated_public_ip, 'associated_public_ip')
        if self.associated_public_ip:
            self.associated_public_ip.validate()
        self.validate_required(self.attachment, 'attachment')
        if self.attachment:
            self.attachment.validate()
        self.validate_required(self.security_group_ids, 'security_group_ids')
        if self.security_group_ids:
            self.security_group_ids.validate()

    def to_map(self):
        result = {}
        result['NetworkInterfaceId'] = self.network_interface_id
        result['Status'] = self.status
        result['Type'] = self.type
        result['VpcId'] = self.vpc_id
        result['VSwitchId'] = self.v_switch_id
        result['ZoneId'] = self.zone_id
        result['PrivateIpAddress'] = self.private_ip_address
        result['MacAddress'] = self.mac_address
        result['NetworkInterfaceName'] = self.network_interface_name
        result['Description'] = self.description
        result['InstanceId'] = self.instance_id
        result['CreationTime'] = self.creation_time
        result['ResourceGroupId'] = self.resource_group_id
        result['ServiceID'] = self.service_id
        result['ServiceManaged'] = self.service_managed
        result['QueueNumber'] = self.queue_number
        result['OwnerId'] = self.owner_id
        if self.private_ip_sets is not None:
            result['PrivateIpSets'] = self.private_ip_sets.to_map()
        else:
            result['PrivateIpSets'] = None
        if self.ipv_6sets is not None:
            result['Ipv6Sets'] = self.ipv_6sets.to_map()
        else:
            result['Ipv6Sets'] = None
        if self.tags is not None:
            result['Tags'] = self.tags.to_map()
        else:
            result['Tags'] = None
        if self.associated_public_ip is not None:
            result['AssociatedPublicIp'] = self.associated_public_ip.to_map()
        else:
            result['AssociatedPublicIp'] = None
        if self.attachment is not None:
            result['Attachment'] = self.attachment.to_map()
        else:
            result['Attachment'] = None
        if self.security_group_ids is not None:
            result['SecurityGroupIds'] = self.security_group_ids.to_map()
        else:
            result['SecurityGroupIds'] = None
        return result

    def from_map(self, map={}):
        self.network_interface_id = map.get('NetworkInterfaceId')
        self.status = map.get('Status')
        self.type = map.get('Type')
        self.vpc_id = map.get('VpcId')
        self.v_switch_id = map.get('VSwitchId')
        self.zone_id = map.get('ZoneId')
        self.private_ip_address = map.get('PrivateIpAddress')
        self.mac_address = map.get('MacAddress')
        self.network_interface_name = map.get('NetworkInterfaceName')
        self.description = map.get('Description')
        self.instance_id = map.get('InstanceId')
        self.creation_time = map.get('CreationTime')
        self.resource_group_id = map.get('ResourceGroupId')
        self.service_id = map.get('ServiceID')
        self.service_managed = map.get('ServiceManaged')
        self.queue_number = map.get('QueueNumber')
        self.owner_id = map.get('OwnerId')
        if map.get('PrivateIpSets') is not None:
            temp_model = DescribeNetworkInterfacesResponseNetworkInterfaceSetsNetworkInterfaceSetPrivateIpSets()
            self.private_ip_sets = temp_model.from_map(map['PrivateIpSets'])
        else:
            self.private_ip_sets = None
        if map.get('Ipv6Sets') is not None:
            temp_model = DescribeNetworkInterfacesResponseNetworkInterfaceSetsNetworkInterfaceSetIpv6Sets()
            self.ipv_6sets = temp_model.from_map(map['Ipv6Sets'])
        else:
            self.ipv_6sets = None
        if map.get('Tags') is not None:
            temp_model = DescribeNetworkInterfacesResponseNetworkInterfaceSetsNetworkInterfaceSetTags()
            self.tags = temp_model.from_map(map['Tags'])
        else:
            self.tags = None
        if map.get('AssociatedPublicIp') is not None:
            temp_model = DescribeNetworkInterfacesResponseNetworkInterfaceSetsNetworkInterfaceSetAssociatedPublicIp()
            self.associated_public_ip = temp_model.from_map(map['AssociatedPublicIp'])
        else:
            self.associated_public_ip = None
        if map.get('Attachment') is not None:
            temp_model = DescribeNetworkInterfacesResponseNetworkInterfaceSetsNetworkInterfaceSetAttachment()
            self.attachment = temp_model.from_map(map['Attachment'])
        else:
            self.attachment = None
        if map.get('SecurityGroupIds') is not None:
            temp_model = DescribeNetworkInterfacesResponseNetworkInterfaceSetsNetworkInterfaceSetSecurityGroupIds()
            self.security_group_ids = temp_model.from_map(map['SecurityGroupIds'])
        else:
            self.security_group_ids = None
        return self


class DescribeNetworkInterfacesResponseNetworkInterfaceSets(TeaModel):
    def __init__(self, network_interface_set=None):
        self.network_interface_set = network_interface_set

    def validate(self):
        self.validate_required(self.network_interface_set, 'network_interface_set')
        if self.network_interface_set:
            for k in self.network_interface_set:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['NetworkInterfaceSet'] = []
        if self.network_interface_set is not None:
            for k in self.network_interface_set:
                result['NetworkInterfaceSet'].append(k.to_map() if k else None)
        else:
            result['NetworkInterfaceSet'] = None
        return result

    def from_map(self, map={}):
        self.network_interface_set = []
        if map.get('NetworkInterfaceSet') is not None:
            for k in map.get('NetworkInterfaceSet'):
                temp_model = DescribeNetworkInterfacesResponseNetworkInterfaceSetsNetworkInterfaceSet()
                temp_model = temp_model.from_map(k)
                self.network_interface_set.append(temp_model)
        else:
            self.network_interface_set = None
        return self
class DeleteNetworkInterfaceRequest(TeaModel):
    def __init__(self, region_id=None, network_interface_id=None):
        self.region_id = region_id
        self.network_interface_id = network_interface_id

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.network_interface_id, 'network_interface_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['NetworkInterfaceId'] = self.network_interface_id
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.network_interface_id = map.get('NetworkInterfaceId')
        return self


class DeleteNetworkInterfaceResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class CreateNetworkInterfaceRequest(TeaModel):
    def __init__(self, region_id=None, tag=None, resource_group_id=None, v_switch_id=None, primary_ip_address=None,
                 security_group_id=None, security_group_ids=None, network_interface_name=None, description=None, visible=None,
                 instance_type=None, business_type=None, private_ip_address=None, secondary_private_ip_address_count=None,
                 client_token=None):
        self.region_id = region_id
        self.tag = tag
        self.resource_group_id = resource_group_id
        self.v_switch_id = v_switch_id
        self.primary_ip_address = primary_ip_address
        self.security_group_id = security_group_id
        self.security_group_ids = security_group_ids
        self.network_interface_name = network_interface_name
        self.description = description
        self.visible = visible
        self.instance_type = instance_type
        self.business_type = business_type
        self.private_ip_address = private_ip_address
        self.secondary_private_ip_address_count = secondary_private_ip_address_count
        self.client_token = client_token

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()
        self.validate_required(self.v_switch_id, 'v_switch_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        else:
            result['Tag'] = None
        result['ResourceGroupId'] = self.resource_group_id
        result['VSwitchId'] = self.v_switch_id
        result['PrimaryIpAddress'] = self.primary_ip_address
        result['SecurityGroupId'] = self.security_group_id
        result['SecurityGroupIds'] = []
        if self.security_group_ids is not None:
            for k in self.security_group_ids:
                result['SecurityGroupIds'].append(k)
        else:
            result['SecurityGroupIds'] = None
        result['NetworkInterfaceName'] = self.network_interface_name
        result['Description'] = self.description
        result['Visible'] = self.visible
        result['InstanceType'] = self.instance_type
        result['BusinessType'] = self.business_type
        result['PrivateIpAddress'] = []
        if self.private_ip_address is not None:
            for k in self.private_ip_address:
                result['PrivateIpAddress'].append(k)
        else:
            result['PrivateIpAddress'] = None
        result['SecondaryPrivateIpAddressCount'] = self.secondary_private_ip_address_count
        result['ClientToken'] = self.client_token
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.tag = []
        if map.get('Tag') is not None:
            for k in map.get('Tag'):
                temp_model = CreateNetworkInterfaceRequestTag()
                temp_model = temp_model.from_map(k)
                self.tag.append(temp_model)
        else:
            self.tag = None
        self.resource_group_id = map.get('ResourceGroupId')
        self.v_switch_id = map.get('VSwitchId')
        self.primary_ip_address = map.get('PrimaryIpAddress')
        self.security_group_id = map.get('SecurityGroupId')
        self.security_group_ids = []
        if map.get('SecurityGroupIds') is not None:
            for k in map.get('SecurityGroupIds'):
                self.security_group_ids.append(k)
        else:
            self.security_group_ids = None
        self.network_interface_name = map.get('NetworkInterfaceName')
        self.description = map.get('Description')
        self.visible = map.get('Visible')
        self.instance_type = map.get('InstanceType')
        self.business_type = map.get('BusinessType')
        self.private_ip_address = []
        if map.get('PrivateIpAddress') is not None:
            for k in map.get('PrivateIpAddress'):
                self.private_ip_address.append(k)
        else:
            self.private_ip_address = None
        self.secondary_private_ip_address_count = map.get('SecondaryPrivateIpAddressCount')
        self.client_token = map.get('ClientToken')
        return self


class CreateNetworkInterfaceRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key
        self.value = value

    def validate(self):
        self.validate_required(self.key, 'key')
        self.validate_required(self.value, 'value')

    def to_map(self):
        result = {}
        result['Key'] = self.key
        result['Value'] = self.value
        return result

    def from_map(self, map={}):
        self.key = map.get('Key')
        self.value = map.get('Value')
        return self
class CreateNetworkInterfaceResponse(TeaModel):
    def __init__(self, request_id=None, network_interface_id=None, status=None, type=None, vpc_id=None,
                 v_switch_id=None, zone_id=None, private_ip_address=None, mac_address=None, network_interface_name=None,
                 description=None, resource_group_id=None, service_id=None, service_managed=None, owner_id=None,
                 private_ip_sets=None, tags=None, security_group_ids=None):
        self.request_id = request_id
        self.network_interface_id = network_interface_id
        self.status = status
        self.type = type
        self.vpc_id = vpc_id
        self.v_switch_id = v_switch_id
        self.zone_id = zone_id
        self.private_ip_address = private_ip_address
        self.mac_address = mac_address
        self.network_interface_name = network_interface_name
        self.description = description
        self.resource_group_id = resource_group_id
        self.service_id = service_id
        self.service_managed = service_managed
        self.owner_id = owner_id
        self.private_ip_sets = private_ip_sets
        self.tags = tags
        self.security_group_ids = security_group_ids

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.network_interface_id, 'network_interface_id')
        self.validate_required(self.status, 'status')
        self.validate_required(self.type, 'type')
        self.validate_required(self.vpc_id, 'vpc_id')
        self.validate_required(self.v_switch_id, 'v_switch_id')
        self.validate_required(self.zone_id, 'zone_id')
        self.validate_required(self.private_ip_address, 'private_ip_address')
        self.validate_required(self.mac_address, 'mac_address')
        self.validate_required(self.network_interface_name, 'network_interface_name')
        self.validate_required(self.description, 'description')
        self.validate_required(self.resource_group_id, 'resource_group_id')
        self.validate_required(self.service_id, 'service_id')
        self.validate_required(self.service_managed, 'service_managed')
        self.validate_required(self.owner_id, 'owner_id')
        self.validate_required(self.private_ip_sets, 'private_ip_sets')
        if self.private_ip_sets:
            self.private_ip_sets.validate()
        self.validate_required(self.tags, 'tags')
        if self.tags:
            self.tags.validate()
        self.validate_required(self.security_group_ids, 'security_group_ids')
        if self.security_group_ids:
            self.security_group_ids.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['NetworkInterfaceId'] = self.network_interface_id
        result['Status'] = self.status
        result['Type'] = self.type
        result['VpcId'] = self.vpc_id
        result['VSwitchId'] = self.v_switch_id
        result['ZoneId'] = self.zone_id
        result['PrivateIpAddress'] = self.private_ip_address
        result['MacAddress'] = self.mac_address
        result['NetworkInterfaceName'] = self.network_interface_name
        result['Description'] = self.description
        result['ResourceGroupId'] = self.resource_group_id
        result['ServiceID'] = self.service_id
        result['ServiceManaged'] = self.service_managed
        result['OwnerId'] = self.owner_id
        if self.private_ip_sets is not None:
            result['PrivateIpSets'] = self.private_ip_sets.to_map()
        else:
            result['PrivateIpSets'] = None
        if self.tags is not None:
            result['Tags'] = self.tags.to_map()
        else:
            result['Tags'] = None
        if self.security_group_ids is not None:
            result['SecurityGroupIds'] = self.security_group_ids.to_map()
        else:
            result['SecurityGroupIds'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.network_interface_id = map.get('NetworkInterfaceId')
        self.status = map.get('Status')
        self.type = map.get('Type')
        self.vpc_id = map.get('VpcId')
        self.v_switch_id = map.get('VSwitchId')
        self.zone_id = map.get('ZoneId')
        self.private_ip_address = map.get('PrivateIpAddress')
        self.mac_address = map.get('MacAddress')
        self.network_interface_name = map.get('NetworkInterfaceName')
        self.description = map.get('Description')
        self.resource_group_id = map.get('ResourceGroupId')
        self.service_id = map.get('ServiceID')
        self.service_managed = map.get('ServiceManaged')
        self.owner_id = map.get('OwnerId')
        if map.get('PrivateIpSets') is not None:
            temp_model = CreateNetworkInterfaceResponsePrivateIpSets()
            self.private_ip_sets = temp_model.from_map(map['PrivateIpSets'])
        else:
            self.private_ip_sets = None
        if map.get('Tags') is not None:
            temp_model = CreateNetworkInterfaceResponseTags()
            self.tags = temp_model.from_map(map['Tags'])
        else:
            self.tags = None
        if map.get('SecurityGroupIds') is not None:
            temp_model = CreateNetworkInterfaceResponseSecurityGroupIds()
            self.security_group_ids = temp_model.from_map(map['SecurityGroupIds'])
        else:
            self.security_group_ids = None
        return self


class CreateNetworkInterfaceResponsePrivateIpSetsPrivateIpSet(TeaModel):
    def __init__(self, private_ip_address=None, primary=None):
        self.private_ip_address = private_ip_address
        self.primary = primary

    def validate(self):
        self.validate_required(self.private_ip_address, 'private_ip_address')
        self.validate_required(self.primary, 'primary')

    def to_map(self):
        result = {}
        result['PrivateIpAddress'] = self.private_ip_address
        result['Primary'] = self.primary
        return result

    def from_map(self, map={}):
        self.private_ip_address = map.get('PrivateIpAddress')
        self.primary = map.get('Primary')
        return self


class CreateNetworkInterfaceResponsePrivateIpSets(TeaModel):
    def __init__(self, private_ip_set=None):
        self.private_ip_set = private_ip_set

    def validate(self):
        self.validate_required(self.private_ip_set, 'private_ip_set')
        if self.private_ip_set:
            for k in self.private_ip_set:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['PrivateIpSet'] = []
        if self.private_ip_set is not None:
            for k in self.private_ip_set:
                result['PrivateIpSet'].append(k.to_map() if k else None)
        else:
            result['PrivateIpSet'] = None
        return result

    def from_map(self, map={}):
        self.private_ip_set = []
        if map.get('PrivateIpSet') is not None:
            for k in map.get('PrivateIpSet'):
                temp_model = CreateNetworkInterfaceResponsePrivateIpSetsPrivateIpSet()
                temp_model = temp_model.from_map(k)
                self.private_ip_set.append(temp_model)
        else:
            self.private_ip_set = None
        return self


class CreateNetworkInterfaceResponseTagsTag(TeaModel):
    def __init__(self, tag_key=None, tag_value=None):
        self.tag_key = tag_key
        self.tag_value = tag_value

    def validate(self):
        self.validate_required(self.tag_key, 'tag_key')
        self.validate_required(self.tag_value, 'tag_value')

    def to_map(self):
        result = {}
        result['TagKey'] = self.tag_key
        result['TagValue'] = self.tag_value
        return result

    def from_map(self, map={}):
        self.tag_key = map.get('TagKey')
        self.tag_value = map.get('TagValue')
        return self


class CreateNetworkInterfaceResponseTags(TeaModel):
    def __init__(self, tag=None):
        self.tag = tag

    def validate(self):
        self.validate_required(self.tag, 'tag')
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        else:
            result['Tag'] = None
        return result

    def from_map(self, map={}):
        self.tag = []
        if map.get('Tag') is not None:
            for k in map.get('Tag'):
                temp_model = CreateNetworkInterfaceResponseTagsTag()
                temp_model = temp_model.from_map(k)
                self.tag.append(temp_model)
        else:
            self.tag = None
        return self


class CreateNetworkInterfaceResponseSecurityGroupIds(TeaModel):
    def __init__(self, security_group_id=None):
        self.security_group_id = security_group_id

    def validate(self):
        self.validate_required(self.security_group_id, 'security_group_id')

    def to_map(self):
        result = {}
        result['SecurityGroupId'] = []
        if self.security_group_id is not None:
            for k in self.security_group_id:
                result['SecurityGroupId'].append(k)
        else:
            result['SecurityGroupId'] = None
        return result

    def from_map(self, map={}):
        self.security_group_id = []
        if map.get('SecurityGroupId') is not None:
            for k in map.get('SecurityGroupId'):
                self.security_group_id.append(k)
        else:
            self.security_group_id = None
        return self
class AttachNetworkInterfaceRequest(TeaModel):
    def __init__(self, region_id=None, network_interface_id=None, instance_id=None, trunk_network_instance_id=None):
        self.region_id = region_id
        self.network_interface_id = network_interface_id
        self.instance_id = instance_id
        self.trunk_network_instance_id = trunk_network_instance_id

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.network_interface_id, 'network_interface_id')
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['NetworkInterfaceId'] = self.network_interface_id
        result['InstanceId'] = self.instance_id
        result['TrunkNetworkInstanceId'] = self.trunk_network_instance_id
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.network_interface_id = map.get('NetworkInterfaceId')
        self.instance_id = map.get('InstanceId')
        self.trunk_network_instance_id = map.get('TrunkNetworkInstanceId')
        return self


class AttachNetworkInterfaceResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class DescribeRecommendInstanceTypeRequest(TeaModel):
    def __init__(self, cores=None, memory=None, instance_family_level=None, instance_type=None, network_type=None,
                 instance_charge_type=None, spot_strategy=None, io_optimized=None, instance_type_family=None, priority_strategy=None,
                 max_price=None, region_id=None, zone_id=None, system_disk_category=None, scene=None):
        self.cores = cores
        self.memory = memory
        self.instance_family_level = instance_family_level
        self.instance_type = instance_type
        self.network_type = network_type
        self.instance_charge_type = instance_charge_type
        self.spot_strategy = spot_strategy
        self.io_optimized = io_optimized
        self.instance_type_family = instance_type_family
        self.priority_strategy = priority_strategy
        self.max_price = max_price
        self.region_id = region_id
        self.zone_id = zone_id
        self.system_disk_category = system_disk_category
        self.scene = scene

    def validate(self):
        self.validate_required(self.network_type, 'network_type')
        self.validate_required(self.region_id, 'region_id')

    def to_map(self):
        result = {}
        result['Cores'] = self.cores
        result['Memory'] = self.memory
        result['InstanceFamilyLevel'] = self.instance_family_level
        result['InstanceType'] = self.instance_type
        result['NetworkType'] = self.network_type
        result['InstanceChargeType'] = self.instance_charge_type
        result['SpotStrategy'] = self.spot_strategy
        result['IoOptimized'] = self.io_optimized
        result['InstanceTypeFamily'] = []
        if self.instance_type_family is not None:
            for k in self.instance_type_family:
                result['InstanceTypeFamily'].append(k)
        else:
            result['InstanceTypeFamily'] = None
        result['PriorityStrategy'] = self.priority_strategy
        result['MaxPrice'] = self.max_price
        result['RegionId'] = self.region_id
        result['ZoneId'] = self.zone_id
        result['SystemDiskCategory'] = self.system_disk_category
        result['Scene'] = self.scene
        return result

    def from_map(self, map={}):
        self.cores = map.get('Cores')
        self.memory = map.get('Memory')
        self.instance_family_level = map.get('InstanceFamilyLevel')
        self.instance_type = map.get('InstanceType')
        self.network_type = map.get('NetworkType')
        self.instance_charge_type = map.get('InstanceChargeType')
        self.spot_strategy = map.get('SpotStrategy')
        self.io_optimized = map.get('IoOptimized')
        self.instance_type_family = []
        if map.get('InstanceTypeFamily') is not None:
            for k in map.get('InstanceTypeFamily'):
                self.instance_type_family.append(k)
        else:
            self.instance_type_family = None
        self.priority_strategy = map.get('PriorityStrategy')
        self.max_price = map.get('MaxPrice')
        self.region_id = map.get('RegionId')
        self.zone_id = map.get('ZoneId')
        self.system_disk_category = map.get('SystemDiskCategory')
        self.scene = map.get('Scene')
        return self


class DescribeRecommendInstanceTypeResponse(TeaModel):
    def __init__(self, request_id=None, data=None):
        self.request_id = request_id
        self.data = data

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data.to_map()
        else:
            result['Data'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        if map.get('Data') is not None:
            temp_model = DescribeRecommendInstanceTypeResponseData()
            self.data = temp_model.from_map(map['Data'])
        else:
            self.data = None
        return self


class DescribeRecommendInstanceTypeResponseDataRecommendInstanceTypeZonesZoneNetworkTypes(TeaModel):
    def __init__(self, network_type=None):
        # NetworkType
        self.network_type = network_type

    def validate(self):
        self.validate_required(self.network_type, 'network_type')

    def to_map(self):
        result = {}
        result['NetworkType'] = []
        if self.network_type is not None:
            for k in self.network_type:
                result['NetworkType'].append(k)
        else:
            result['NetworkType'] = None
        return result

    def from_map(self, map={}):
        self.network_type = []
        if map.get('NetworkType') is not None:
            for k in map.get('NetworkType'):
                self.network_type.append(k)
        else:
            self.network_type = None
        return self


class DescribeRecommendInstanceTypeResponseDataRecommendInstanceTypeZonesZone(TeaModel):
    def __init__(self, zone_no=None, network_types=None):
        self.zone_no = zone_no
        self.network_types = network_types

    def validate(self):
        self.validate_required(self.zone_no, 'zone_no')
        self.validate_required(self.network_types, 'network_types')
        if self.network_types:
            self.network_types.validate()

    def to_map(self):
        result = {}
        result['ZoneNo'] = self.zone_no
        if self.network_types is not None:
            result['NetworkTypes'] = self.network_types.to_map()
        else:
            result['NetworkTypes'] = None
        return result

    def from_map(self, map={}):
        self.zone_no = map.get('ZoneNo')
        if map.get('NetworkTypes') is not None:
            temp_model = DescribeRecommendInstanceTypeResponseDataRecommendInstanceTypeZonesZoneNetworkTypes()
            self.network_types = temp_model.from_map(map['NetworkTypes'])
        else:
            self.network_types = None
        return self


class DescribeRecommendInstanceTypeResponseDataRecommendInstanceTypeZones(TeaModel):
    def __init__(self, zone=None):
        self.zone = zone

    def validate(self):
        self.validate_required(self.zone, 'zone')
        if self.zone:
            for k in self.zone:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['zone'] = []
        if self.zone is not None:
            for k in self.zone:
                result['zone'].append(k.to_map() if k else None)
        else:
            result['zone'] = None
        return result

    def from_map(self, map={}):
        self.zone = []
        if map.get('zone') is not None:
            for k in map.get('zone'):
                temp_model = DescribeRecommendInstanceTypeResponseDataRecommendInstanceTypeZonesZone()
                temp_model = temp_model.from_map(k)
                self.zone.append(temp_model)
        else:
            self.zone = None
        return self


class DescribeRecommendInstanceTypeResponseDataRecommendInstanceTypeInstanceType(TeaModel):
    def __init__(self, generation=None, instance_type_family=None, instance_type=None, support_io_optimized=None,
                 cores=None, memory=None):
        self.generation = generation
        self.instance_type_family = instance_type_family
        self.instance_type = instance_type
        self.support_io_optimized = support_io_optimized
        self.cores = cores
        self.memory = memory

    def validate(self):
        self.validate_required(self.generation, 'generation')
        self.validate_required(self.instance_type_family, 'instance_type_family')
        self.validate_required(self.instance_type, 'instance_type')
        self.validate_required(self.support_io_optimized, 'support_io_optimized')
        self.validate_required(self.cores, 'cores')
        self.validate_required(self.memory, 'memory')

    def to_map(self):
        result = {}
        result['Generation'] = self.generation
        result['InstanceTypeFamily'] = self.instance_type_family
        result['InstanceType'] = self.instance_type
        result['SupportIoOptimized'] = self.support_io_optimized
        result['Cores'] = self.cores
        result['Memory'] = self.memory
        return result

    def from_map(self, map={}):
        self.generation = map.get('Generation')
        self.instance_type_family = map.get('InstanceTypeFamily')
        self.instance_type = map.get('InstanceType')
        self.support_io_optimized = map.get('SupportIoOptimized')
        self.cores = map.get('Cores')
        self.memory = map.get('Memory')
        return self


class DescribeRecommendInstanceTypeResponseDataRecommendInstanceType(TeaModel):
    def __init__(self, region_id=None, commodity_code=None, scene=None, instance_charge_type=None,
                 spot_strategy=None, priority=None, zones=None, instance_type=None):
        self.region_id = region_id
        self.commodity_code = commodity_code
        self.scene = scene
        self.instance_charge_type = instance_charge_type
        self.spot_strategy = spot_strategy
        self.priority = priority
        self.zones = zones
        self.instance_type = instance_type

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.commodity_code, 'commodity_code')
        self.validate_required(self.scene, 'scene')
        self.validate_required(self.instance_charge_type, 'instance_charge_type')
        self.validate_required(self.spot_strategy, 'spot_strategy')
        self.validate_required(self.priority, 'priority')
        self.validate_required(self.zones, 'zones')
        if self.zones:
            self.zones.validate()
        self.validate_required(self.instance_type, 'instance_type')
        if self.instance_type:
            self.instance_type.validate()

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['CommodityCode'] = self.commodity_code
        result['Scene'] = self.scene
        result['InstanceChargeType'] = self.instance_charge_type
        result['SpotStrategy'] = self.spot_strategy
        result['Priority'] = self.priority
        if self.zones is not None:
            result['Zones'] = self.zones.to_map()
        else:
            result['Zones'] = None
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type.to_map()
        else:
            result['InstanceType'] = None
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.commodity_code = map.get('CommodityCode')
        self.scene = map.get('Scene')
        self.instance_charge_type = map.get('InstanceChargeType')
        self.spot_strategy = map.get('SpotStrategy')
        self.priority = map.get('Priority')
        if map.get('Zones') is not None:
            temp_model = DescribeRecommendInstanceTypeResponseDataRecommendInstanceTypeZones()
            self.zones = temp_model.from_map(map['Zones'])
        else:
            self.zones = None
        if map.get('InstanceType') is not None:
            temp_model = DescribeRecommendInstanceTypeResponseDataRecommendInstanceTypeInstanceType()
            self.instance_type = temp_model.from_map(map['InstanceType'])
        else:
            self.instance_type = None
        return self


class DescribeRecommendInstanceTypeResponseData(TeaModel):
    def __init__(self, recommend_instance_type=None):
        self.recommend_instance_type = recommend_instance_type

    def validate(self):
        self.validate_required(self.recommend_instance_type, 'recommend_instance_type')
        if self.recommend_instance_type:
            for k in self.recommend_instance_type:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['RecommendInstanceType'] = []
        if self.recommend_instance_type is not None:
            for k in self.recommend_instance_type:
                result['RecommendInstanceType'].append(k.to_map() if k else None)
        else:
            result['RecommendInstanceType'] = None
        return result

    def from_map(self, map={}):
        self.recommend_instance_type = []
        if map.get('RecommendInstanceType') is not None:
            for k in map.get('RecommendInstanceType'):
                temp_model = DescribeRecommendInstanceTypeResponseDataRecommendInstanceType()
                temp_model = temp_model.from_map(k)
                self.recommend_instance_type.append(temp_model)
        else:
            self.recommend_instance_type = None
        return self
class ModifyPrepayInstanceSpecRequest(TeaModel):
    def __init__(self, instance_id=None, region_id=None, instance_type=None, operator_type=None, client_token=None,
                 auto_pay=None, migrate_across_zone=None, system_disk=None, reboot_time=None, end_time=None,
                 reboot_when_finished=None):
        self.instance_id = instance_id
        self.region_id = region_id
        self.instance_type = instance_type
        self.operator_type = operator_type
        self.client_token = client_token
        self.auto_pay = auto_pay
        self.migrate_across_zone = migrate_across_zone
        self.system_disk = system_disk
        self.reboot_time = reboot_time
        self.end_time = end_time
        self.reboot_when_finished = reboot_when_finished

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.instance_type, 'instance_type')
        if self.system_disk:
            self.system_disk.validate()

    def to_map(self):
        result = {}
        result['InstanceId'] = self.instance_id
        result['RegionId'] = self.region_id
        result['InstanceType'] = self.instance_type
        result['OperatorType'] = self.operator_type
        result['ClientToken'] = self.client_token
        result['AutoPay'] = self.auto_pay
        result['MigrateAcrossZone'] = self.migrate_across_zone
        if self.system_disk is not None:
            result['SystemDisk'] = self.system_disk.to_map()
        else:
            result['SystemDisk'] = None
        result['RebootTime'] = self.reboot_time
        result['EndTime'] = self.end_time
        result['RebootWhenFinished'] = self.reboot_when_finished
        return result

    def from_map(self, map={}):
        self.instance_id = map.get('InstanceId')
        self.region_id = map.get('RegionId')
        self.instance_type = map.get('InstanceType')
        self.operator_type = map.get('OperatorType')
        self.client_token = map.get('ClientToken')
        self.auto_pay = map.get('AutoPay')
        self.migrate_across_zone = map.get('MigrateAcrossZone')
        if map.get('SystemDisk') is not None:
            temp_model = ModifyPrepayInstanceSpecRequestSystemDisk()
            self.system_disk = temp_model.from_map(map['SystemDisk'])
        else:
            self.system_disk = None
        self.reboot_time = map.get('RebootTime')
        self.end_time = map.get('EndTime')
        self.reboot_when_finished = map.get('RebootWhenFinished')
        return self


class ModifyPrepayInstanceSpecRequestSystemDisk(TeaModel):
    def __init__(self, category=None):
        self.category = category

    def validate(self):
        pass

    def to_map(self):
        result = {}
        result['Category'] = self.category
        return result

    def from_map(self, map={}):
        self.category = map.get('Category')
        return self
class ModifyPrepayInstanceSpecResponse(TeaModel):
    def __init__(self, request_id=None, order_id=None):
        self.request_id = request_id
        self.order_id = order_id

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.order_id, 'order_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['OrderId'] = self.order_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.order_id = map.get('OrderId')
        return self


class ModifyInstanceChargeTypeRequest(TeaModel):
    def __init__(self, instance_ids=None, region_id=None, period=None, period_unit=None, include_data_disks=None,
                 dry_run=None, auto_pay=None, instance_charge_type=None, client_token=None, is_detail_fee=None):
        self.instance_ids = instance_ids
        self.region_id = region_id
        self.period = period
        self.period_unit = period_unit
        self.include_data_disks = include_data_disks
        self.dry_run = dry_run
        self.auto_pay = auto_pay
        self.instance_charge_type = instance_charge_type
        self.client_token = client_token
        self.is_detail_fee = is_detail_fee

    def validate(self):
        self.validate_required(self.instance_ids, 'instance_ids')
        self.validate_required(self.region_id, 'region_id')

    def to_map(self):
        result = {}
        result['InstanceIds'] = self.instance_ids
        result['RegionId'] = self.region_id
        result['Period'] = self.period
        result['PeriodUnit'] = self.period_unit
        result['IncludeDataDisks'] = self.include_data_disks
        result['DryRun'] = self.dry_run
        result['AutoPay'] = self.auto_pay
        result['InstanceChargeType'] = self.instance_charge_type
        result['ClientToken'] = self.client_token
        result['IsDetailFee'] = self.is_detail_fee
        return result

    def from_map(self, map={}):
        self.instance_ids = map.get('InstanceIds')
        self.region_id = map.get('RegionId')
        self.period = map.get('Period')
        self.period_unit = map.get('PeriodUnit')
        self.include_data_disks = map.get('IncludeDataDisks')
        self.dry_run = map.get('DryRun')
        self.auto_pay = map.get('AutoPay')
        self.instance_charge_type = map.get('InstanceChargeType')
        self.client_token = map.get('ClientToken')
        self.is_detail_fee = map.get('IsDetailFee')
        return self


class ModifyInstanceChargeTypeResponse(TeaModel):
    def __init__(self, request_id=None, order_id=None, fee_of_instances=None):
        self.request_id = request_id
        self.order_id = order_id
        self.fee_of_instances = fee_of_instances

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.order_id, 'order_id')
        self.validate_required(self.fee_of_instances, 'fee_of_instances')
        if self.fee_of_instances:
            self.fee_of_instances.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['OrderId'] = self.order_id
        if self.fee_of_instances is not None:
            result['FeeOfInstances'] = self.fee_of_instances.to_map()
        else:
            result['FeeOfInstances'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.order_id = map.get('OrderId')
        if map.get('FeeOfInstances') is not None:
            temp_model = ModifyInstanceChargeTypeResponseFeeOfInstances()
            self.fee_of_instances = temp_model.from_map(map['FeeOfInstances'])
        else:
            self.fee_of_instances = None
        return self


class ModifyInstanceChargeTypeResponseFeeOfInstancesFeeOfInstance(TeaModel):
    def __init__(self, instance_id=None, fee=None, currency=None):
        self.instance_id = instance_id
        self.fee = fee
        self.currency = currency

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.fee, 'fee')
        self.validate_required(self.currency, 'currency')

    def to_map(self):
        result = {}
        result['InstanceId'] = self.instance_id
        result['Fee'] = self.fee
        result['Currency'] = self.currency
        return result

    def from_map(self, map={}):
        self.instance_id = map.get('InstanceId')
        self.fee = map.get('Fee')
        self.currency = map.get('Currency')
        return self


class ModifyInstanceChargeTypeResponseFeeOfInstances(TeaModel):
    def __init__(self, fee_of_instance=None):
        self.fee_of_instance = fee_of_instance

    def validate(self):
        self.validate_required(self.fee_of_instance, 'fee_of_instance')
        if self.fee_of_instance:
            for k in self.fee_of_instance:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['FeeOfInstance'] = []
        if self.fee_of_instance is not None:
            for k in self.fee_of_instance:
                result['FeeOfInstance'].append(k.to_map() if k else None)
        else:
            result['FeeOfInstance'] = None
        return result

    def from_map(self, map={}):
        self.fee_of_instance = []
        if map.get('FeeOfInstance') is not None:
            for k in map.get('FeeOfInstance'):
                temp_model = ModifyInstanceChargeTypeResponseFeeOfInstancesFeeOfInstance()
                temp_model = temp_model.from_map(k)
                self.fee_of_instance.append(temp_model)
        else:
            self.fee_of_instance = None
        return self
class JoinResourceGroupRequest(TeaModel):
    def __init__(self, resource_type=None, resource_id=None, region_id=None, resource_group_id=None):
        self.resource_type = resource_type
        self.resource_id = resource_id
        self.region_id = region_id
        self.resource_group_id = resource_group_id

    def validate(self):
        pass

    def to_map(self):
        result = {}
        result['ResourceType'] = self.resource_type
        result['ResourceId'] = self.resource_id
        result['RegionId'] = self.region_id
        result['ResourceGroupId'] = self.resource_group_id
        return result

    def from_map(self, map={}):
        self.resource_type = map.get('ResourceType')
        self.resource_id = map.get('ResourceId')
        self.region_id = map.get('RegionId')
        self.resource_group_id = map.get('ResourceGroupId')
        return self


class JoinResourceGroupResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class ModifySecurityGroupPolicyRequest(TeaModel):
    def __init__(self, security_group_id=None, region_id=None, inner_access_policy=None, client_token=None):
        self.security_group_id = security_group_id
        self.region_id = region_id
        self.inner_access_policy = inner_access_policy
        self.client_token = client_token

    def validate(self):
        self.validate_required(self.security_group_id, 'security_group_id')
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.inner_access_policy, 'inner_access_policy')

    def to_map(self):
        result = {}
        result['SecurityGroupId'] = self.security_group_id
        result['RegionId'] = self.region_id
        result['InnerAccessPolicy'] = self.inner_access_policy
        result['ClientToken'] = self.client_token
        return result

    def from_map(self, map={}):
        self.security_group_id = map.get('SecurityGroupId')
        self.region_id = map.get('RegionId')
        self.inner_access_policy = map.get('InnerAccessPolicy')
        self.client_token = map.get('ClientToken')
        return self


class ModifySecurityGroupPolicyResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class DescribeSecurityGroupReferencesRequest(TeaModel):
    def __init__(self, region_id=None, security_group_id=None):
        self.region_id = region_id
        self.security_group_id = security_group_id

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.security_group_id, 'security_group_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['SecurityGroupId'] = []
        if self.security_group_id is not None:
            for k in self.security_group_id:
                result['SecurityGroupId'].append(k)
        else:
            result['SecurityGroupId'] = None
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.security_group_id = []
        if map.get('SecurityGroupId') is not None:
            for k in map.get('SecurityGroupId'):
                self.security_group_id.append(k)
        else:
            self.security_group_id = None
        return self


class DescribeSecurityGroupReferencesResponse(TeaModel):
    def __init__(self, request_id=None, security_group_references=None):
        self.request_id = request_id
        self.security_group_references = security_group_references

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.security_group_references, 'security_group_references')
        if self.security_group_references:
            self.security_group_references.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        if self.security_group_references is not None:
            result['SecurityGroupReferences'] = self.security_group_references.to_map()
        else:
            result['SecurityGroupReferences'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        if map.get('SecurityGroupReferences') is not None:
            temp_model = DescribeSecurityGroupReferencesResponseSecurityGroupReferences()
            self.security_group_references = temp_model.from_map(map['SecurityGroupReferences'])
        else:
            self.security_group_references = None
        return self


class DescribeSecurityGroupReferencesResponseSecurityGroupReferencesSecurityGroupReferenceReferencingSecurityGroupsReferencingSecurityGroup(TeaModel):
    def __init__(self, ali_uid=None, security_group_id=None):
        self.ali_uid = ali_uid
        self.security_group_id = security_group_id

    def validate(self):
        self.validate_required(self.ali_uid, 'ali_uid')
        self.validate_required(self.security_group_id, 'security_group_id')

    def to_map(self):
        result = {}
        result['AliUid'] = self.ali_uid
        result['SecurityGroupId'] = self.security_group_id
        return result

    def from_map(self, map={}):
        self.ali_uid = map.get('AliUid')
        self.security_group_id = map.get('SecurityGroupId')
        return self


class DescribeSecurityGroupReferencesResponseSecurityGroupReferencesSecurityGroupReferenceReferencingSecurityGroups(TeaModel):
    def __init__(self, referencing_security_group=None):
        self.referencing_security_group = referencing_security_group

    def validate(self):
        self.validate_required(self.referencing_security_group, 'referencing_security_group')
        if self.referencing_security_group:
            for k in self.referencing_security_group:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['ReferencingSecurityGroup'] = []
        if self.referencing_security_group is not None:
            for k in self.referencing_security_group:
                result['ReferencingSecurityGroup'].append(k.to_map() if k else None)
        else:
            result['ReferencingSecurityGroup'] = None
        return result

    def from_map(self, map={}):
        self.referencing_security_group = []
        if map.get('ReferencingSecurityGroup') is not None:
            for k in map.get('ReferencingSecurityGroup'):
                temp_model = DescribeSecurityGroupReferencesResponseSecurityGroupReferencesSecurityGroupReferenceReferencingSecurityGroupsReferencingSecurityGroup()
                temp_model = temp_model.from_map(k)
                self.referencing_security_group.append(temp_model)
        else:
            self.referencing_security_group = None
        return self


class DescribeSecurityGroupReferencesResponseSecurityGroupReferencesSecurityGroupReference(TeaModel):
    def __init__(self, security_group_id=None, referencing_security_groups=None):
        self.security_group_id = security_group_id
        self.referencing_security_groups = referencing_security_groups

    def validate(self):
        self.validate_required(self.security_group_id, 'security_group_id')
        self.validate_required(self.referencing_security_groups, 'referencing_security_groups')
        if self.referencing_security_groups:
            self.referencing_security_groups.validate()

    def to_map(self):
        result = {}
        result['SecurityGroupId'] = self.security_group_id
        if self.referencing_security_groups is not None:
            result['ReferencingSecurityGroups'] = self.referencing_security_groups.to_map()
        else:
            result['ReferencingSecurityGroups'] = None
        return result

    def from_map(self, map={}):
        self.security_group_id = map.get('SecurityGroupId')
        if map.get('ReferencingSecurityGroups') is not None:
            temp_model = DescribeSecurityGroupReferencesResponseSecurityGroupReferencesSecurityGroupReferenceReferencingSecurityGroups()
            self.referencing_security_groups = temp_model.from_map(map['ReferencingSecurityGroups'])
        else:
            self.referencing_security_groups = None
        return self


class DescribeSecurityGroupReferencesResponseSecurityGroupReferences(TeaModel):
    def __init__(self, security_group_reference=None):
        self.security_group_reference = security_group_reference

    def validate(self):
        self.validate_required(self.security_group_reference, 'security_group_reference')
        if self.security_group_reference:
            for k in self.security_group_reference:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['SecurityGroupReference'] = []
        if self.security_group_reference is not None:
            for k in self.security_group_reference:
                result['SecurityGroupReference'].append(k.to_map() if k else None)
        else:
            result['SecurityGroupReference'] = None
        return result

    def from_map(self, map={}):
        self.security_group_reference = []
        if map.get('SecurityGroupReference') is not None:
            for k in map.get('SecurityGroupReference'):
                temp_model = DescribeSecurityGroupReferencesResponseSecurityGroupReferencesSecurityGroupReference()
                temp_model = temp_model.from_map(k)
                self.security_group_reference.append(temp_model)
        else:
            self.security_group_reference = None
        return self
class DetachClassicLinkVpcRequest(TeaModel):
    def __init__(self, region_id=None, instance_id=None, vpc_id=None):
        self.region_id = region_id
        self.instance_id = instance_id
        self.vpc_id = vpc_id

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.vpc_id, 'vpc_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['InstanceId'] = self.instance_id
        result['VpcId'] = self.vpc_id
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.instance_id = map.get('InstanceId')
        self.vpc_id = map.get('VpcId')
        return self


class DetachClassicLinkVpcResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class DescribeClassicLinkInstancesRequest(TeaModel):
    def __init__(self, region_id=None, vpc_id=None, instance_id=None, page_number=None, page_size=None):
        self.region_id = region_id
        self.vpc_id = vpc_id
        self.instance_id = instance_id
        self.page_number = page_number
        self.page_size = page_size

    def validate(self):
        self.validate_required(self.region_id, 'region_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['VpcId'] = self.vpc_id
        result['InstanceId'] = self.instance_id
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.vpc_id = map.get('VpcId')
        self.instance_id = map.get('InstanceId')
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        return self


class DescribeClassicLinkInstancesResponse(TeaModel):
    def __init__(self, request_id=None, total_count=None, page_number=None, page_size=None, links=None):
        self.request_id = request_id
        self.total_count = total_count
        self.page_number = page_number
        self.page_size = page_size
        self.links = links

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.page_number, 'page_number')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.links, 'links')
        if self.links:
            self.links.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['TotalCount'] = self.total_count
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        if self.links is not None:
            result['Links'] = self.links.to_map()
        else:
            result['Links'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.total_count = map.get('TotalCount')
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        if map.get('Links') is not None:
            temp_model = DescribeClassicLinkInstancesResponseLinks()
            self.links = temp_model.from_map(map['Links'])
        else:
            self.links = None
        return self


class DescribeClassicLinkInstancesResponseLinksLink(TeaModel):
    def __init__(self, instance_id=None, vpc_id=None):
        self.instance_id = instance_id
        self.vpc_id = vpc_id

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.vpc_id, 'vpc_id')

    def to_map(self):
        result = {}
        result['InstanceId'] = self.instance_id
        result['VpcId'] = self.vpc_id
        return result

    def from_map(self, map={}):
        self.instance_id = map.get('InstanceId')
        self.vpc_id = map.get('VpcId')
        return self


class DescribeClassicLinkInstancesResponseLinks(TeaModel):
    def __init__(self, link=None):
        self.link = link

    def validate(self):
        self.validate_required(self.link, 'link')
        if self.link:
            for k in self.link:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['Link'] = []
        if self.link is not None:
            for k in self.link:
                result['Link'].append(k.to_map() if k else None)
        else:
            result['Link'] = None
        return result

    def from_map(self, map={}):
        self.link = []
        if map.get('Link') is not None:
            for k in map.get('Link'):
                temp_model = DescribeClassicLinkInstancesResponseLinksLink()
                temp_model = temp_model.from_map(k)
                self.link.append(temp_model)
        else:
            self.link = None
        return self
class AttachClassicLinkVpcRequest(TeaModel):
    def __init__(self, region_id=None, instance_id=None, vpc_id=None):
        self.region_id = region_id
        self.instance_id = instance_id
        self.vpc_id = vpc_id

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.vpc_id, 'vpc_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['InstanceId'] = self.instance_id
        result['VpcId'] = self.vpc_id
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.instance_id = map.get('InstanceId')
        self.vpc_id = map.get('VpcId')
        return self


class AttachClassicLinkVpcResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class DetachInstanceRamRoleRequest(TeaModel):
    def __init__(self, region_id=None, ram_role_name=None, instance_ids=None):
        self.region_id = region_id
        self.ram_role_name = ram_role_name
        self.instance_ids = instance_ids

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.instance_ids, 'instance_ids')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['RamRoleName'] = self.ram_role_name
        result['InstanceIds'] = self.instance_ids
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.ram_role_name = map.get('RamRoleName')
        self.instance_ids = map.get('InstanceIds')
        return self


class DetachInstanceRamRoleResponse(TeaModel):
    def __init__(self, request_id=None, total_count=None, fail_count=None, ram_role_name=None,
                 detach_instance_ram_role_results=None):
        self.request_id = request_id
        self.total_count = total_count
        self.fail_count = fail_count
        self.ram_role_name = ram_role_name
        self.detach_instance_ram_role_results = detach_instance_ram_role_results

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.fail_count, 'fail_count')
        self.validate_required(self.ram_role_name, 'ram_role_name')
        self.validate_required(self.detach_instance_ram_role_results, 'detach_instance_ram_role_results')
        if self.detach_instance_ram_role_results:
            self.detach_instance_ram_role_results.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['TotalCount'] = self.total_count
        result['FailCount'] = self.fail_count
        result['RamRoleName'] = self.ram_role_name
        if self.detach_instance_ram_role_results is not None:
            result['DetachInstanceRamRoleResults'] = self.detach_instance_ram_role_results.to_map()
        else:
            result['DetachInstanceRamRoleResults'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.total_count = map.get('TotalCount')
        self.fail_count = map.get('FailCount')
        self.ram_role_name = map.get('RamRoleName')
        if map.get('DetachInstanceRamRoleResults') is not None:
            temp_model = DetachInstanceRamRoleResponseDetachInstanceRamRoleResults()
            self.detach_instance_ram_role_results = temp_model.from_map(map['DetachInstanceRamRoleResults'])
        else:
            self.detach_instance_ram_role_results = None
        return self


class DetachInstanceRamRoleResponseDetachInstanceRamRoleResultsDetachInstanceRamRoleResultInstanceRamRoleSetsInstanceRamRoleSet(TeaModel):
    def __init__(self, instance_id=None, ram_role_name=None):
        self.instance_id = instance_id
        self.ram_role_name = ram_role_name

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.ram_role_name, 'ram_role_name')

    def to_map(self):
        result = {}
        result['InstanceId'] = self.instance_id
        result['RamRoleName'] = self.ram_role_name
        return result

    def from_map(self, map={}):
        self.instance_id = map.get('InstanceId')
        self.ram_role_name = map.get('RamRoleName')
        return self


class DetachInstanceRamRoleResponseDetachInstanceRamRoleResultsDetachInstanceRamRoleResultInstanceRamRoleSets(TeaModel):
    def __init__(self, instance_ram_role_set=None):
        self.instance_ram_role_set = instance_ram_role_set

    def validate(self):
        self.validate_required(self.instance_ram_role_set, 'instance_ram_role_set')
        if self.instance_ram_role_set:
            for k in self.instance_ram_role_set:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['InstanceRamRoleSet'] = []
        if self.instance_ram_role_set is not None:
            for k in self.instance_ram_role_set:
                result['InstanceRamRoleSet'].append(k.to_map() if k else None)
        else:
            result['InstanceRamRoleSet'] = None
        return result

    def from_map(self, map={}):
        self.instance_ram_role_set = []
        if map.get('InstanceRamRoleSet') is not None:
            for k in map.get('InstanceRamRoleSet'):
                temp_model = DetachInstanceRamRoleResponseDetachInstanceRamRoleResultsDetachInstanceRamRoleResultInstanceRamRoleSetsInstanceRamRoleSet()
                temp_model = temp_model.from_map(k)
                self.instance_ram_role_set.append(temp_model)
        else:
            self.instance_ram_role_set = None
        return self


class DetachInstanceRamRoleResponseDetachInstanceRamRoleResultsDetachInstanceRamRoleResult(TeaModel):
    def __init__(self, instance_id=None, success=None, code=None, message=None, instance_ram_role_sets=None):
        self.instance_id = instance_id
        self.success = success
        self.code = code
        self.message = message
        self.instance_ram_role_sets = instance_ram_role_sets

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.message, 'message')
        self.validate_required(self.instance_ram_role_sets, 'instance_ram_role_sets')
        if self.instance_ram_role_sets:
            self.instance_ram_role_sets.validate()

    def to_map(self):
        result = {}
        result['InstanceId'] = self.instance_id
        result['Success'] = self.success
        result['Code'] = self.code
        result['Message'] = self.message
        if self.instance_ram_role_sets is not None:
            result['InstanceRamRoleSets'] = self.instance_ram_role_sets.to_map()
        else:
            result['InstanceRamRoleSets'] = None
        return result

    def from_map(self, map={}):
        self.instance_id = map.get('InstanceId')
        self.success = map.get('Success')
        self.code = map.get('Code')
        self.message = map.get('Message')
        if map.get('InstanceRamRoleSets') is not None:
            temp_model = DetachInstanceRamRoleResponseDetachInstanceRamRoleResultsDetachInstanceRamRoleResultInstanceRamRoleSets()
            self.instance_ram_role_sets = temp_model.from_map(map['InstanceRamRoleSets'])
        else:
            self.instance_ram_role_sets = None
        return self


class DetachInstanceRamRoleResponseDetachInstanceRamRoleResults(TeaModel):
    def __init__(self, detach_instance_ram_role_result=None):
        self.detach_instance_ram_role_result = detach_instance_ram_role_result

    def validate(self):
        self.validate_required(self.detach_instance_ram_role_result, 'detach_instance_ram_role_result')
        if self.detach_instance_ram_role_result:
            for k in self.detach_instance_ram_role_result:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['DetachInstanceRamRoleResult'] = []
        if self.detach_instance_ram_role_result is not None:
            for k in self.detach_instance_ram_role_result:
                result['DetachInstanceRamRoleResult'].append(k.to_map() if k else None)
        else:
            result['DetachInstanceRamRoleResult'] = None
        return result

    def from_map(self, map={}):
        self.detach_instance_ram_role_result = []
        if map.get('DetachInstanceRamRoleResult') is not None:
            for k in map.get('DetachInstanceRamRoleResult'):
                temp_model = DetachInstanceRamRoleResponseDetachInstanceRamRoleResultsDetachInstanceRamRoleResult()
                temp_model = temp_model.from_map(k)
                self.detach_instance_ram_role_result.append(temp_model)
        else:
            self.detach_instance_ram_role_result = None
        return self
class DescribeInstanceRamRoleRequest(TeaModel):
    def __init__(self, page_number=None, page_size=None, region_id=None, instance_ids=None, ram_role_name=None):
        self.page_number = page_number
        self.page_size = page_size
        self.region_id = region_id
        self.instance_ids = instance_ids
        self.ram_role_name = ram_role_name

    def validate(self):
        self.validate_required(self.region_id, 'region_id')

    def to_map(self):
        result = {}
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        result['RegionId'] = self.region_id
        result['InstanceIds'] = self.instance_ids
        result['RamRoleName'] = self.ram_role_name
        return result

    def from_map(self, map={}):
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        self.region_id = map.get('RegionId')
        self.instance_ids = map.get('InstanceIds')
        self.ram_role_name = map.get('RamRoleName')
        return self


class DescribeInstanceRamRoleResponse(TeaModel):
    def __init__(self, request_id=None, region_id=None, total_count=None, instance_ram_role_sets=None):
        self.request_id = request_id
        self.region_id = region_id
        self.total_count = total_count
        self.instance_ram_role_sets = instance_ram_role_sets

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.instance_ram_role_sets, 'instance_ram_role_sets')
        if self.instance_ram_role_sets:
            self.instance_ram_role_sets.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['RegionId'] = self.region_id
        result['TotalCount'] = self.total_count
        if self.instance_ram_role_sets is not None:
            result['InstanceRamRoleSets'] = self.instance_ram_role_sets.to_map()
        else:
            result['InstanceRamRoleSets'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.region_id = map.get('RegionId')
        self.total_count = map.get('TotalCount')
        if map.get('InstanceRamRoleSets') is not None:
            temp_model = DescribeInstanceRamRoleResponseInstanceRamRoleSets()
            self.instance_ram_role_sets = temp_model.from_map(map['InstanceRamRoleSets'])
        else:
            self.instance_ram_role_sets = None
        return self


class DescribeInstanceRamRoleResponseInstanceRamRoleSetsInstanceRamRoleSet(TeaModel):
    def __init__(self, instance_id=None, ram_role_name=None):
        self.instance_id = instance_id
        self.ram_role_name = ram_role_name

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.ram_role_name, 'ram_role_name')

    def to_map(self):
        result = {}
        result['InstanceId'] = self.instance_id
        result['RamRoleName'] = self.ram_role_name
        return result

    def from_map(self, map={}):
        self.instance_id = map.get('InstanceId')
        self.ram_role_name = map.get('RamRoleName')
        return self


class DescribeInstanceRamRoleResponseInstanceRamRoleSets(TeaModel):
    def __init__(self, instance_ram_role_set=None):
        self.instance_ram_role_set = instance_ram_role_set

    def validate(self):
        self.validate_required(self.instance_ram_role_set, 'instance_ram_role_set')
        if self.instance_ram_role_set:
            for k in self.instance_ram_role_set:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['InstanceRamRoleSet'] = []
        if self.instance_ram_role_set is not None:
            for k in self.instance_ram_role_set:
                result['InstanceRamRoleSet'].append(k.to_map() if k else None)
        else:
            result['InstanceRamRoleSet'] = None
        return result

    def from_map(self, map={}):
        self.instance_ram_role_set = []
        if map.get('InstanceRamRoleSet') is not None:
            for k in map.get('InstanceRamRoleSet'):
                temp_model = DescribeInstanceRamRoleResponseInstanceRamRoleSetsInstanceRamRoleSet()
                temp_model = temp_model.from_map(k)
                self.instance_ram_role_set.append(temp_model)
        else:
            self.instance_ram_role_set = None
        return self
class AttachInstanceRamRoleRequest(TeaModel):
    def __init__(self, region_id=None, ram_role_name=None, instance_ids=None):
        self.region_id = region_id
        self.ram_role_name = ram_role_name
        self.instance_ids = instance_ids

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.ram_role_name, 'ram_role_name')
        self.validate_required(self.instance_ids, 'instance_ids')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['RamRoleName'] = self.ram_role_name
        result['InstanceIds'] = self.instance_ids
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.ram_role_name = map.get('RamRoleName')
        self.instance_ids = map.get('InstanceIds')
        return self


class AttachInstanceRamRoleResponse(TeaModel):
    def __init__(self, request_id=None, total_count=None, fail_count=None, ram_role_name=None,
                 attach_instance_ram_role_results=None):
        self.request_id = request_id
        self.total_count = total_count
        self.fail_count = fail_count
        self.ram_role_name = ram_role_name
        self.attach_instance_ram_role_results = attach_instance_ram_role_results

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.fail_count, 'fail_count')
        self.validate_required(self.ram_role_name, 'ram_role_name')
        self.validate_required(self.attach_instance_ram_role_results, 'attach_instance_ram_role_results')
        if self.attach_instance_ram_role_results:
            self.attach_instance_ram_role_results.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['TotalCount'] = self.total_count
        result['FailCount'] = self.fail_count
        result['RamRoleName'] = self.ram_role_name
        if self.attach_instance_ram_role_results is not None:
            result['AttachInstanceRamRoleResults'] = self.attach_instance_ram_role_results.to_map()
        else:
            result['AttachInstanceRamRoleResults'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.total_count = map.get('TotalCount')
        self.fail_count = map.get('FailCount')
        self.ram_role_name = map.get('RamRoleName')
        if map.get('AttachInstanceRamRoleResults') is not None:
            temp_model = AttachInstanceRamRoleResponseAttachInstanceRamRoleResults()
            self.attach_instance_ram_role_results = temp_model.from_map(map['AttachInstanceRamRoleResults'])
        else:
            self.attach_instance_ram_role_results = None
        return self


class AttachInstanceRamRoleResponseAttachInstanceRamRoleResultsAttachInstanceRamRoleResult(TeaModel):
    def __init__(self, instance_id=None, success=None, code=None, message=None):
        self.instance_id = instance_id
        self.success = success
        self.code = code
        self.message = message

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.message, 'message')

    def to_map(self):
        result = {}
        result['InstanceId'] = self.instance_id
        result['Success'] = self.success
        result['Code'] = self.code
        result['Message'] = self.message
        return result

    def from_map(self, map={}):
        self.instance_id = map.get('InstanceId')
        self.success = map.get('Success')
        self.code = map.get('Code')
        self.message = map.get('Message')
        return self


class AttachInstanceRamRoleResponseAttachInstanceRamRoleResults(TeaModel):
    def __init__(self, attach_instance_ram_role_result=None):
        self.attach_instance_ram_role_result = attach_instance_ram_role_result

    def validate(self):
        self.validate_required(self.attach_instance_ram_role_result, 'attach_instance_ram_role_result')
        if self.attach_instance_ram_role_result:
            for k in self.attach_instance_ram_role_result:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['AttachInstanceRamRoleResult'] = []
        if self.attach_instance_ram_role_result is not None:
            for k in self.attach_instance_ram_role_result:
                result['AttachInstanceRamRoleResult'].append(k.to_map() if k else None)
        else:
            result['AttachInstanceRamRoleResult'] = None
        return result

    def from_map(self, map={}):
        self.attach_instance_ram_role_result = []
        if map.get('AttachInstanceRamRoleResult') is not None:
            for k in map.get('AttachInstanceRamRoleResult'):
                temp_model = AttachInstanceRamRoleResponseAttachInstanceRamRoleResultsAttachInstanceRamRoleResult()
                temp_model = temp_model.from_map(k)
                self.attach_instance_ram_role_result.append(temp_model)
        else:
            self.attach_instance_ram_role_result = None
        return self
class DescribeSnapshotPackageRequest(TeaModel):
    def __init__(self, page_number=None, page_size=None, region_id=None):
        self.page_number = page_number
        self.page_size = page_size
        self.region_id = region_id

    def validate(self):
        self.validate_required(self.region_id, 'region_id')

    def to_map(self):
        result = {}
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        result['RegionId'] = self.region_id
        return result

    def from_map(self, map={}):
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        self.region_id = map.get('RegionId')
        return self


class DescribeSnapshotPackageResponse(TeaModel):
    def __init__(self, request_id=None, total_count=None, page_number=None, page_size=None, snapshot_packages=None):
        self.request_id = request_id
        self.total_count = total_count
        self.page_number = page_number
        self.page_size = page_size
        self.snapshot_packages = snapshot_packages

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.page_number, 'page_number')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.snapshot_packages, 'snapshot_packages')
        if self.snapshot_packages:
            self.snapshot_packages.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['TotalCount'] = self.total_count
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        if self.snapshot_packages is not None:
            result['SnapshotPackages'] = self.snapshot_packages.to_map()
        else:
            result['SnapshotPackages'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.total_count = map.get('TotalCount')
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        if map.get('SnapshotPackages') is not None:
            temp_model = DescribeSnapshotPackageResponseSnapshotPackages()
            self.snapshot_packages = temp_model.from_map(map['SnapshotPackages'])
        else:
            self.snapshot_packages = None
        return self


class DescribeSnapshotPackageResponseSnapshotPackagesSnapshotPackage(TeaModel):
    def __init__(self, start_time=None, end_time=None, init_capacity=None, display_name=None):
        self.start_time = start_time
        self.end_time = end_time
        self.init_capacity = init_capacity
        self.display_name = display_name

    def validate(self):
        self.validate_required(self.start_time, 'start_time')
        self.validate_required(self.end_time, 'end_time')
        self.validate_required(self.init_capacity, 'init_capacity')
        self.validate_required(self.display_name, 'display_name')

    def to_map(self):
        result = {}
        result['StartTime'] = self.start_time
        result['EndTime'] = self.end_time
        result['InitCapacity'] = self.init_capacity
        result['DisplayName'] = self.display_name
        return result

    def from_map(self, map={}):
        self.start_time = map.get('StartTime')
        self.end_time = map.get('EndTime')
        self.init_capacity = map.get('InitCapacity')
        self.display_name = map.get('DisplayName')
        return self


class DescribeSnapshotPackageResponseSnapshotPackages(TeaModel):
    def __init__(self, snapshot_package=None):
        self.snapshot_package = snapshot_package

    def validate(self):
        self.validate_required(self.snapshot_package, 'snapshot_package')
        if self.snapshot_package:
            for k in self.snapshot_package:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['SnapshotPackage'] = []
        if self.snapshot_package is not None:
            for k in self.snapshot_package:
                result['SnapshotPackage'].append(k.to_map() if k else None)
        else:
            result['SnapshotPackage'] = None
        return result

    def from_map(self, map={}):
        self.snapshot_package = []
        if map.get('SnapshotPackage') is not None:
            for k in map.get('SnapshotPackage'):
                temp_model = DescribeSnapshotPackageResponseSnapshotPackagesSnapshotPackage()
                temp_model = temp_model.from_map(k)
                self.snapshot_package.append(temp_model)
        else:
            self.snapshot_package = None
        return self
class ModifySecurityGroupRuleRequest(TeaModel):
    def __init__(self, region_id=None, security_group_id=None, ip_protocol=None, port_range=None,
                 source_group_id=None, source_group_owner_id=None, source_group_owner_account=None, source_cidr_ip=None,
                 ipv_6source_cidr_ip=None, source_port_range=None, dest_cidr_ip=None, ipv_6dest_cidr_ip=None, policy=None,
                 priority=None, nic_type=None, client_token=None, description=None):
        self.region_id = region_id
        self.security_group_id = security_group_id
        self.ip_protocol = ip_protocol
        self.port_range = port_range
        self.source_group_id = source_group_id
        self.source_group_owner_id = source_group_owner_id
        self.source_group_owner_account = source_group_owner_account
        self.source_cidr_ip = source_cidr_ip
        self.ipv_6source_cidr_ip = ipv_6source_cidr_ip
        self.source_port_range = source_port_range
        self.dest_cidr_ip = dest_cidr_ip
        self.ipv_6dest_cidr_ip = ipv_6dest_cidr_ip
        self.policy = policy
        self.priority = priority
        self.nic_type = nic_type
        self.client_token = client_token
        self.description = description

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.security_group_id, 'security_group_id')
        self.validate_required(self.ip_protocol, 'ip_protocol')
        self.validate_required(self.port_range, 'port_range')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['SecurityGroupId'] = self.security_group_id
        result['IpProtocol'] = self.ip_protocol
        result['PortRange'] = self.port_range
        result['SourceGroupId'] = self.source_group_id
        result['SourceGroupOwnerId'] = self.source_group_owner_id
        result['SourceGroupOwnerAccount'] = self.source_group_owner_account
        result['SourceCidrIp'] = self.source_cidr_ip
        result['Ipv6SourceCidrIp'] = self.ipv_6source_cidr_ip
        result['SourcePortRange'] = self.source_port_range
        result['DestCidrIp'] = self.dest_cidr_ip
        result['Ipv6DestCidrIp'] = self.ipv_6dest_cidr_ip
        result['Policy'] = self.policy
        result['Priority'] = self.priority
        result['NicType'] = self.nic_type
        result['ClientToken'] = self.client_token
        result['Description'] = self.description
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.security_group_id = map.get('SecurityGroupId')
        self.ip_protocol = map.get('IpProtocol')
        self.port_range = map.get('PortRange')
        self.source_group_id = map.get('SourceGroupId')
        self.source_group_owner_id = map.get('SourceGroupOwnerId')
        self.source_group_owner_account = map.get('SourceGroupOwnerAccount')
        self.source_cidr_ip = map.get('SourceCidrIp')
        self.ipv_6source_cidr_ip = map.get('Ipv6SourceCidrIp')
        self.source_port_range = map.get('SourcePortRange')
        self.dest_cidr_ip = map.get('DestCidrIp')
        self.ipv_6dest_cidr_ip = map.get('Ipv6DestCidrIp')
        self.policy = map.get('Policy')
        self.priority = map.get('Priority')
        self.nic_type = map.get('NicType')
        self.client_token = map.get('ClientToken')
        self.description = map.get('Description')
        return self


class ModifySecurityGroupRuleResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class DescribeSnapshotMonitorDataRequest(TeaModel):
    def __init__(self, region_id=None, start_time=None, end_time=None, period=None, category=None):
        self.region_id = region_id
        self.start_time = start_time
        self.end_time = end_time
        self.period = period
        self.category = category

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.start_time, 'start_time')
        self.validate_required(self.end_time, 'end_time')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['StartTime'] = self.start_time
        result['EndTime'] = self.end_time
        result['Period'] = self.period
        result['Category'] = self.category
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.start_time = map.get('StartTime')
        self.end_time = map.get('EndTime')
        self.period = map.get('Period')
        self.category = map.get('Category')
        return self


class DescribeSnapshotMonitorDataResponse(TeaModel):
    def __init__(self, request_id=None, monitor_data=None):
        self.request_id = request_id
        self.monitor_data = monitor_data

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.monitor_data, 'monitor_data')
        if self.monitor_data:
            self.monitor_data.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        if self.monitor_data is not None:
            result['MonitorData'] = self.monitor_data.to_map()
        else:
            result['MonitorData'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        if map.get('MonitorData') is not None:
            temp_model = DescribeSnapshotMonitorDataResponseMonitorData()
            self.monitor_data = temp_model.from_map(map['MonitorData'])
        else:
            self.monitor_data = None
        return self


class DescribeSnapshotMonitorDataResponseMonitorDataDataPoint(TeaModel):
    def __init__(self, time_stamp=None, size=None):
        self.time_stamp = time_stamp
        self.size = size

    def validate(self):
        self.validate_required(self.time_stamp, 'time_stamp')
        self.validate_required(self.size, 'size')

    def to_map(self):
        result = {}
        result['TimeStamp'] = self.time_stamp
        result['Size'] = self.size
        return result

    def from_map(self, map={}):
        self.time_stamp = map.get('TimeStamp')
        self.size = map.get('Size')
        return self


class DescribeSnapshotMonitorDataResponseMonitorData(TeaModel):
    def __init__(self, data_point=None):
        self.data_point = data_point

    def validate(self):
        self.validate_required(self.data_point, 'data_point')
        if self.data_point:
            for k in self.data_point:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['DataPoint'] = []
        if self.data_point is not None:
            for k in self.data_point:
                result['DataPoint'].append(k.to_map() if k else None)
        else:
            result['DataPoint'] = None
        return result

    def from_map(self, map={}):
        self.data_point = []
        if map.get('DataPoint') is not None:
            for k in map.get('DataPoint'):
                temp_model = DescribeSnapshotMonitorDataResponseMonitorDataDataPoint()
                temp_model = temp_model.from_map(k)
                self.data_point.append(temp_model)
        else:
            self.data_point = None
        return self
class DescribeRenewalPriceRequest(TeaModel):
    def __init__(self, region_id=None, resource_type=None, resource_id=None, period=None, price_unit=None):
        self.region_id = region_id
        self.resource_type = resource_type
        self.resource_id = resource_id
        self.period = period
        self.price_unit = price_unit

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.resource_id, 'resource_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['ResourceType'] = self.resource_type
        result['ResourceId'] = self.resource_id
        result['Period'] = self.period
        result['PriceUnit'] = self.price_unit
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.resource_type = map.get('ResourceType')
        self.resource_id = map.get('ResourceId')
        self.period = map.get('Period')
        self.price_unit = map.get('PriceUnit')
        return self


class DescribeRenewalPriceResponse(TeaModel):
    def __init__(self, request_id=None, price_info=None):
        self.request_id = request_id
        self.price_info = price_info

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.price_info, 'price_info')
        if self.price_info:
            self.price_info.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        if self.price_info is not None:
            result['PriceInfo'] = self.price_info.to_map()
        else:
            result['PriceInfo'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        if map.get('PriceInfo') is not None:
            temp_model = DescribeRenewalPriceResponsePriceInfo()
            self.price_info = temp_model.from_map(map['PriceInfo'])
        else:
            self.price_info = None
        return self


class DescribeRenewalPriceResponsePriceInfoRulesRule(TeaModel):
    def __init__(self, rule_id=None, description=None):
        self.rule_id = rule_id
        self.description = description

    def validate(self):
        self.validate_required(self.rule_id, 'rule_id')
        self.validate_required(self.description, 'description')

    def to_map(self):
        result = {}
        result['RuleId'] = self.rule_id
        result['Description'] = self.description
        return result

    def from_map(self, map={}):
        self.rule_id = map.get('RuleId')
        self.description = map.get('Description')
        return self


class DescribeRenewalPriceResponsePriceInfoRules(TeaModel):
    def __init__(self, rule=None):
        self.rule = rule

    def validate(self):
        self.validate_required(self.rule, 'rule')
        if self.rule:
            for k in self.rule:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['Rule'] = []
        if self.rule is not None:
            for k in self.rule:
                result['Rule'].append(k.to_map() if k else None)
        else:
            result['Rule'] = None
        return result

    def from_map(self, map={}):
        self.rule = []
        if map.get('Rule') is not None:
            for k in map.get('Rule'):
                temp_model = DescribeRenewalPriceResponsePriceInfoRulesRule()
                temp_model = temp_model.from_map(k)
                self.rule.append(temp_model)
        else:
            self.rule = None
        return self


class DescribeRenewalPriceResponsePriceInfoPriceDetailInfosResourcePriceModelSubRulesRule(TeaModel):
    def __init__(self, rule_id=None, description=None):
        self.rule_id = rule_id
        self.description = description

    def validate(self):
        self.validate_required(self.rule_id, 'rule_id')
        self.validate_required(self.description, 'description')

    def to_map(self):
        result = {}
        result['RuleId'] = self.rule_id
        result['Description'] = self.description
        return result

    def from_map(self, map={}):
        self.rule_id = map.get('RuleId')
        self.description = map.get('Description')
        return self


class DescribeRenewalPriceResponsePriceInfoPriceDetailInfosResourcePriceModelSubRules(TeaModel):
    def __init__(self, rule=None):
        self.rule = rule

    def validate(self):
        self.validate_required(self.rule, 'rule')
        if self.rule:
            for k in self.rule:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['Rule'] = []
        if self.rule is not None:
            for k in self.rule:
                result['Rule'].append(k.to_map() if k else None)
        else:
            result['Rule'] = None
        return result

    def from_map(self, map={}):
        self.rule = []
        if map.get('Rule') is not None:
            for k in map.get('Rule'):
                temp_model = DescribeRenewalPriceResponsePriceInfoPriceDetailInfosResourcePriceModelSubRulesRule()
                temp_model = temp_model.from_map(k)
                self.rule.append(temp_model)
        else:
            self.rule = None
        return self


class DescribeRenewalPriceResponsePriceInfoPriceDetailInfosResourcePriceModel(TeaModel):
    def __init__(self, resource=None, original_price=None, discount_price=None, trade_price=None, sub_rules=None):
        self.resource = resource
        self.original_price = original_price
        self.discount_price = discount_price
        self.trade_price = trade_price
        self.sub_rules = sub_rules

    def validate(self):
        self.validate_required(self.resource, 'resource')
        self.validate_required(self.original_price, 'original_price')
        self.validate_required(self.discount_price, 'discount_price')
        self.validate_required(self.trade_price, 'trade_price')
        self.validate_required(self.sub_rules, 'sub_rules')
        if self.sub_rules:
            self.sub_rules.validate()

    def to_map(self):
        result = {}
        result['Resource'] = self.resource
        result['OriginalPrice'] = self.original_price
        result['DiscountPrice'] = self.discount_price
        result['TradePrice'] = self.trade_price
        if self.sub_rules is not None:
            result['SubRules'] = self.sub_rules.to_map()
        else:
            result['SubRules'] = None
        return result

    def from_map(self, map={}):
        self.resource = map.get('Resource')
        self.original_price = map.get('OriginalPrice')
        self.discount_price = map.get('DiscountPrice')
        self.trade_price = map.get('TradePrice')
        if map.get('SubRules') is not None:
            temp_model = DescribeRenewalPriceResponsePriceInfoPriceDetailInfosResourcePriceModelSubRules()
            self.sub_rules = temp_model.from_map(map['SubRules'])
        else:
            self.sub_rules = None
        return self


class DescribeRenewalPriceResponsePriceInfoPriceDetailInfos(TeaModel):
    def __init__(self, resource_price_model=None):
        self.resource_price_model = resource_price_model

    def validate(self):
        self.validate_required(self.resource_price_model, 'resource_price_model')
        if self.resource_price_model:
            for k in self.resource_price_model:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['ResourcePriceModel'] = []
        if self.resource_price_model is not None:
            for k in self.resource_price_model:
                result['ResourcePriceModel'].append(k.to_map() if k else None)
        else:
            result['ResourcePriceModel'] = None
        return result

    def from_map(self, map={}):
        self.resource_price_model = []
        if map.get('ResourcePriceModel') is not None:
            for k in map.get('ResourcePriceModel'):
                temp_model = DescribeRenewalPriceResponsePriceInfoPriceDetailInfosResourcePriceModel()
                temp_model = temp_model.from_map(k)
                self.resource_price_model.append(temp_model)
        else:
            self.resource_price_model = None
        return self


class DescribeRenewalPriceResponsePriceInfoPrice(TeaModel):
    def __init__(self, original_price=None, discount_price=None, trade_price=None, currency=None, detail_infos=None):
        self.original_price = original_price
        self.discount_price = discount_price
        self.trade_price = trade_price
        self.currency = currency
        self.detail_infos = detail_infos

    def validate(self):
        self.validate_required(self.original_price, 'original_price')
        self.validate_required(self.discount_price, 'discount_price')
        self.validate_required(self.trade_price, 'trade_price')
        self.validate_required(self.currency, 'currency')
        self.validate_required(self.detail_infos, 'detail_infos')
        if self.detail_infos:
            self.detail_infos.validate()

    def to_map(self):
        result = {}
        result['OriginalPrice'] = self.original_price
        result['DiscountPrice'] = self.discount_price
        result['TradePrice'] = self.trade_price
        result['Currency'] = self.currency
        if self.detail_infos is not None:
            result['DetailInfos'] = self.detail_infos.to_map()
        else:
            result['DetailInfos'] = None
        return result

    def from_map(self, map={}):
        self.original_price = map.get('OriginalPrice')
        self.discount_price = map.get('DiscountPrice')
        self.trade_price = map.get('TradePrice')
        self.currency = map.get('Currency')
        if map.get('DetailInfos') is not None:
            temp_model = DescribeRenewalPriceResponsePriceInfoPriceDetailInfos()
            self.detail_infos = temp_model.from_map(map['DetailInfos'])
        else:
            self.detail_infos = None
        return self


class DescribeRenewalPriceResponsePriceInfo(TeaModel):
    def __init__(self, rules=None, price=None):
        self.rules = rules
        self.price = price

    def validate(self):
        self.validate_required(self.rules, 'rules')
        if self.rules:
            self.rules.validate()
        self.validate_required(self.price, 'price')
        if self.price:
            self.price.validate()

    def to_map(self):
        result = {}
        if self.rules is not None:
            result['Rules'] = self.rules.to_map()
        else:
            result['Rules'] = None
        if self.price is not None:
            result['Price'] = self.price.to_map()
        else:
            result['Price'] = None
        return result

    def from_map(self, map={}):
        if map.get('Rules') is not None:
            temp_model = DescribeRenewalPriceResponsePriceInfoRules()
            self.rules = temp_model.from_map(map['Rules'])
        else:
            self.rules = None
        if map.get('Price') is not None:
            temp_model = DescribeRenewalPriceResponsePriceInfoPrice()
            self.price = temp_model.from_map(map['Price'])
        else:
            self.price = None
        return self
class DescribePriceRequest(TeaModel):
    def __init__(self, region_id=None, resource_type=None, image_id=None, instance_type=None, io_optimized=None,
                 instance_network_type=None, internet_charge_type=None, internet_max_bandwidth_out=None, system_disk=None,
                 data_disk=None, period=None, price_unit=None, amount=None, offering_type=None, instance_amount=None,
                 scope=None, platform=None, capacity=None):
        self.region_id = region_id
        self.resource_type = resource_type
        self.image_id = image_id
        self.instance_type = instance_type
        self.io_optimized = io_optimized
        self.instance_network_type = instance_network_type
        self.internet_charge_type = internet_charge_type
        self.internet_max_bandwidth_out = internet_max_bandwidth_out
        self.system_disk = system_disk
        self.data_disk = data_disk
        self.period = period
        self.price_unit = price_unit
        self.amount = amount
        self.offering_type = offering_type
        self.instance_amount = instance_amount
        self.scope = scope
        self.platform = platform
        self.capacity = capacity

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        if self.system_disk:
            self.system_disk.validate()
        if self.data_disk:
            for k in self.data_disk:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['ResourceType'] = self.resource_type
        result['ImageId'] = self.image_id
        result['InstanceType'] = self.instance_type
        result['IoOptimized'] = self.io_optimized
        result['InstanceNetworkType'] = self.instance_network_type
        result['InternetChargeType'] = self.internet_charge_type
        result['InternetMaxBandwidthOut'] = self.internet_max_bandwidth_out
        if self.system_disk is not None:
            result['SystemDisk'] = self.system_disk.to_map()
        else:
            result['SystemDisk'] = None
        result['DataDisk'] = []
        if self.data_disk is not None:
            for k in self.data_disk:
                result['DataDisk'].append(k.to_map() if k else None)
        else:
            result['DataDisk'] = None
        result['Period'] = self.period
        result['PriceUnit'] = self.price_unit
        result['Amount'] = self.amount
        result['OfferingType'] = self.offering_type
        result['InstanceAmount'] = self.instance_amount
        result['Scope'] = self.scope
        result['Platform'] = self.platform
        result['Capacity'] = self.capacity
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.resource_type = map.get('ResourceType')
        self.image_id = map.get('ImageId')
        self.instance_type = map.get('InstanceType')
        self.io_optimized = map.get('IoOptimized')
        self.instance_network_type = map.get('InstanceNetworkType')
        self.internet_charge_type = map.get('InternetChargeType')
        self.internet_max_bandwidth_out = map.get('InternetMaxBandwidthOut')
        if map.get('SystemDisk') is not None:
            temp_model = DescribePriceRequestSystemDisk()
            self.system_disk = temp_model.from_map(map['SystemDisk'])
        else:
            self.system_disk = None
        self.data_disk = []
        if map.get('DataDisk') is not None:
            for k in map.get('DataDisk'):
                temp_model = DescribePriceRequestDataDisk()
                temp_model = temp_model.from_map(k)
                self.data_disk.append(temp_model)
        else:
            self.data_disk = None
        self.period = map.get('Period')
        self.price_unit = map.get('PriceUnit')
        self.amount = map.get('Amount')
        self.offering_type = map.get('OfferingType')
        self.instance_amount = map.get('InstanceAmount')
        self.scope = map.get('Scope')
        self.platform = map.get('Platform')
        self.capacity = map.get('Capacity')
        return self


class DescribePriceRequestSystemDisk(TeaModel):
    def __init__(self, category=None, size=None, performance_level=None):
        self.category = category
        self.size = size
        self.performance_level = performance_level

    def validate(self):
        pass

    def to_map(self):
        result = {}
        result['Category'] = self.category
        result['Size'] = self.size
        result['PerformanceLevel'] = self.performance_level
        return result

    def from_map(self, map={}):
        self.category = map.get('Category')
        self.size = map.get('Size')
        self.performance_level = map.get('PerformanceLevel')
        return self


class DescribePriceRequestDataDisk(TeaModel):
    def __init__(self, size=None, category=None, performance_level=None):
        self.size = size
        self.category = category
        self.performance_level = performance_level

    def validate(self):
        pass

    def to_map(self):
        result = {}
        result['Size'] = self.size
        result['Category'] = self.category
        result['PerformanceLevel'] = self.performance_level
        return result

    def from_map(self, map={}):
        self.size = map.get('Size')
        self.category = map.get('Category')
        self.performance_level = map.get('PerformanceLevel')
        return self
class DescribePriceResponse(TeaModel):
    def __init__(self, request_id=None, price_info=None):
        self.request_id = request_id
        self.price_info = price_info

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.price_info, 'price_info')
        if self.price_info:
            self.price_info.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        if self.price_info is not None:
            result['PriceInfo'] = self.price_info.to_map()
        else:
            result['PriceInfo'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        if map.get('PriceInfo') is not None:
            temp_model = DescribePriceResponsePriceInfo()
            self.price_info = temp_model.from_map(map['PriceInfo'])
        else:
            self.price_info = None
        return self


class DescribePriceResponsePriceInfoRulesRule(TeaModel):
    def __init__(self, rule_id=None, description=None):
        self.rule_id = rule_id
        self.description = description

    def validate(self):
        self.validate_required(self.rule_id, 'rule_id')
        self.validate_required(self.description, 'description')

    def to_map(self):
        result = {}
        result['RuleId'] = self.rule_id
        result['Description'] = self.description
        return result

    def from_map(self, map={}):
        self.rule_id = map.get('RuleId')
        self.description = map.get('Description')
        return self


class DescribePriceResponsePriceInfoRules(TeaModel):
    def __init__(self, rule=None):
        self.rule = rule

    def validate(self):
        self.validate_required(self.rule, 'rule')
        if self.rule:
            for k in self.rule:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['Rule'] = []
        if self.rule is not None:
            for k in self.rule:
                result['Rule'].append(k.to_map() if k else None)
        else:
            result['Rule'] = None
        return result

    def from_map(self, map={}):
        self.rule = []
        if map.get('Rule') is not None:
            for k in map.get('Rule'):
                temp_model = DescribePriceResponsePriceInfoRulesRule()
                temp_model = temp_model.from_map(k)
                self.rule.append(temp_model)
        else:
            self.rule = None
        return self


class DescribePriceResponsePriceInfoPriceDetailInfosResourcePriceModelSubRulesRule(TeaModel):
    def __init__(self, rule_id=None, description=None):
        self.rule_id = rule_id
        self.description = description

    def validate(self):
        self.validate_required(self.rule_id, 'rule_id')
        self.validate_required(self.description, 'description')

    def to_map(self):
        result = {}
        result['RuleId'] = self.rule_id
        result['Description'] = self.description
        return result

    def from_map(self, map={}):
        self.rule_id = map.get('RuleId')
        self.description = map.get('Description')
        return self


class DescribePriceResponsePriceInfoPriceDetailInfosResourcePriceModelSubRules(TeaModel):
    def __init__(self, rule=None):
        self.rule = rule

    def validate(self):
        self.validate_required(self.rule, 'rule')
        if self.rule:
            for k in self.rule:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['Rule'] = []
        if self.rule is not None:
            for k in self.rule:
                result['Rule'].append(k.to_map() if k else None)
        else:
            result['Rule'] = None
        return result

    def from_map(self, map={}):
        self.rule = []
        if map.get('Rule') is not None:
            for k in map.get('Rule'):
                temp_model = DescribePriceResponsePriceInfoPriceDetailInfosResourcePriceModelSubRulesRule()
                temp_model = temp_model.from_map(k)
                self.rule.append(temp_model)
        else:
            self.rule = None
        return self


class DescribePriceResponsePriceInfoPriceDetailInfosResourcePriceModel(TeaModel):
    def __init__(self, resource=None, original_price=None, discount_price=None, trade_price=None, sub_rules=None):
        self.resource = resource
        self.original_price = original_price
        self.discount_price = discount_price
        self.trade_price = trade_price
        self.sub_rules = sub_rules

    def validate(self):
        self.validate_required(self.resource, 'resource')
        self.validate_required(self.original_price, 'original_price')
        self.validate_required(self.discount_price, 'discount_price')
        self.validate_required(self.trade_price, 'trade_price')
        self.validate_required(self.sub_rules, 'sub_rules')
        if self.sub_rules:
            self.sub_rules.validate()

    def to_map(self):
        result = {}
        result['Resource'] = self.resource
        result['OriginalPrice'] = self.original_price
        result['DiscountPrice'] = self.discount_price
        result['TradePrice'] = self.trade_price
        if self.sub_rules is not None:
            result['SubRules'] = self.sub_rules.to_map()
        else:
            result['SubRules'] = None
        return result

    def from_map(self, map={}):
        self.resource = map.get('Resource')
        self.original_price = map.get('OriginalPrice')
        self.discount_price = map.get('DiscountPrice')
        self.trade_price = map.get('TradePrice')
        if map.get('SubRules') is not None:
            temp_model = DescribePriceResponsePriceInfoPriceDetailInfosResourcePriceModelSubRules()
            self.sub_rules = temp_model.from_map(map['SubRules'])
        else:
            self.sub_rules = None
        return self


class DescribePriceResponsePriceInfoPriceDetailInfos(TeaModel):
    def __init__(self, resource_price_model=None):
        self.resource_price_model = resource_price_model

    def validate(self):
        self.validate_required(self.resource_price_model, 'resource_price_model')
        if self.resource_price_model:
            for k in self.resource_price_model:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['ResourcePriceModel'] = []
        if self.resource_price_model is not None:
            for k in self.resource_price_model:
                result['ResourcePriceModel'].append(k.to_map() if k else None)
        else:
            result['ResourcePriceModel'] = None
        return result

    def from_map(self, map={}):
        self.resource_price_model = []
        if map.get('ResourcePriceModel') is not None:
            for k in map.get('ResourcePriceModel'):
                temp_model = DescribePriceResponsePriceInfoPriceDetailInfosResourcePriceModel()
                temp_model = temp_model.from_map(k)
                self.resource_price_model.append(temp_model)
        else:
            self.resource_price_model = None
        return self


class DescribePriceResponsePriceInfoPrice(TeaModel):
    def __init__(self, original_price=None, discount_price=None, trade_price=None,
                 reserved_instance_hour_price=None, currency=None, detail_infos=None):
        self.original_price = original_price
        self.discount_price = discount_price
        self.trade_price = trade_price
        self.reserved_instance_hour_price = reserved_instance_hour_price
        self.currency = currency
        self.detail_infos = detail_infos

    def validate(self):
        self.validate_required(self.original_price, 'original_price')
        self.validate_required(self.discount_price, 'discount_price')
        self.validate_required(self.trade_price, 'trade_price')
        self.validate_required(self.reserved_instance_hour_price, 'reserved_instance_hour_price')
        self.validate_required(self.currency, 'currency')
        self.validate_required(self.detail_infos, 'detail_infos')
        if self.detail_infos:
            self.detail_infos.validate()

    def to_map(self):
        result = {}
        result['OriginalPrice'] = self.original_price
        result['DiscountPrice'] = self.discount_price
        result['TradePrice'] = self.trade_price
        result['ReservedInstanceHourPrice'] = self.reserved_instance_hour_price
        result['Currency'] = self.currency
        if self.detail_infos is not None:
            result['DetailInfos'] = self.detail_infos.to_map()
        else:
            result['DetailInfos'] = None
        return result

    def from_map(self, map={}):
        self.original_price = map.get('OriginalPrice')
        self.discount_price = map.get('DiscountPrice')
        self.trade_price = map.get('TradePrice')
        self.reserved_instance_hour_price = map.get('ReservedInstanceHourPrice')
        self.currency = map.get('Currency')
        if map.get('DetailInfos') is not None:
            temp_model = DescribePriceResponsePriceInfoPriceDetailInfos()
            self.detail_infos = temp_model.from_map(map['DetailInfos'])
        else:
            self.detail_infos = None
        return self


class DescribePriceResponsePriceInfo(TeaModel):
    def __init__(self, rules=None, price=None):
        self.rules = rules
        self.price = price

    def validate(self):
        self.validate_required(self.rules, 'rules')
        if self.rules:
            self.rules.validate()
        self.validate_required(self.price, 'price')
        if self.price:
            self.price.validate()

    def to_map(self):
        result = {}
        if self.rules is not None:
            result['Rules'] = self.rules.to_map()
        else:
            result['Rules'] = None
        if self.price is not None:
            result['Price'] = self.price.to_map()
        else:
            result['Price'] = None
        return result

    def from_map(self, map={}):
        if map.get('Rules') is not None:
            temp_model = DescribePriceResponsePriceInfoRules()
            self.rules = temp_model.from_map(map['Rules'])
        else:
            self.rules = None
        if map.get('Price') is not None:
            temp_model = DescribePriceResponsePriceInfoPrice()
            self.price = temp_model.from_map(map['Price'])
        else:
            self.price = None
        return self
class ModifyDeploymentSetAttributeRequest(TeaModel):
    def __init__(self, deployment_set_id=None, description=None, deployment_set_name=None, region_id=None):
        self.deployment_set_id = deployment_set_id
        self.description = description
        self.deployment_set_name = deployment_set_name
        self.region_id = region_id

    def validate(self):
        self.validate_required(self.deployment_set_id, 'deployment_set_id')
        self.validate_required(self.region_id, 'region_id')

    def to_map(self):
        result = {}
        result['DeploymentSetId'] = self.deployment_set_id
        result['Description'] = self.description
        result['DeploymentSetName'] = self.deployment_set_name
        result['RegionId'] = self.region_id
        return result

    def from_map(self, map={}):
        self.deployment_set_id = map.get('DeploymentSetId')
        self.description = map.get('Description')
        self.deployment_set_name = map.get('DeploymentSetName')
        self.region_id = map.get('RegionId')
        return self


class ModifyDeploymentSetAttributeResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class DescribeDeploymentSetsRequest(TeaModel):
    def __init__(self, region_id=None, page_number=None, page_size=None, deployment_set_ids=None, network_type=None,
                 strategy=None, deployment_set_name=None, granularity=None, domain=None):
        self.region_id = region_id
        self.page_number = page_number
        self.page_size = page_size
        self.deployment_set_ids = deployment_set_ids
        self.network_type = network_type
        self.strategy = strategy
        self.deployment_set_name = deployment_set_name
        self.granularity = granularity
        self.domain = domain

    def validate(self):
        self.validate_required(self.region_id, 'region_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        result['DeploymentSetIds'] = self.deployment_set_ids
        result['NetworkType'] = self.network_type
        result['Strategy'] = self.strategy
        result['DeploymentSetName'] = self.deployment_set_name
        result['Granularity'] = self.granularity
        result['Domain'] = self.domain
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        self.deployment_set_ids = map.get('DeploymentSetIds')
        self.network_type = map.get('NetworkType')
        self.strategy = map.get('Strategy')
        self.deployment_set_name = map.get('DeploymentSetName')
        self.granularity = map.get('Granularity')
        self.domain = map.get('Domain')
        return self


class DescribeDeploymentSetsResponse(TeaModel):
    def __init__(self, request_id=None, region_id=None, total_count=None, page_number=None, page_size=None,
                 deployment_sets=None):
        self.request_id = request_id
        self.region_id = region_id
        self.total_count = total_count
        self.page_number = page_number
        self.page_size = page_size
        self.deployment_sets = deployment_sets

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.page_number, 'page_number')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.deployment_sets, 'deployment_sets')
        if self.deployment_sets:
            self.deployment_sets.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['RegionId'] = self.region_id
        result['TotalCount'] = self.total_count
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        if self.deployment_sets is not None:
            result['DeploymentSets'] = self.deployment_sets.to_map()
        else:
            result['DeploymentSets'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.region_id = map.get('RegionId')
        self.total_count = map.get('TotalCount')
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        if map.get('DeploymentSets') is not None:
            temp_model = DescribeDeploymentSetsResponseDeploymentSets()
            self.deployment_sets = temp_model.from_map(map['DeploymentSets'])
        else:
            self.deployment_sets = None
        return self


class DescribeDeploymentSetsResponseDeploymentSetsDeploymentSetInstanceIds(TeaModel):
    def __init__(self, instance_id=None):
        # InstanceId
        self.instance_id = instance_id

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = {}
        result['InstanceId'] = []
        if self.instance_id is not None:
            for k in self.instance_id:
                result['InstanceId'].append(k)
        else:
            result['InstanceId'] = None
        return result

    def from_map(self, map={}):
        self.instance_id = []
        if map.get('InstanceId') is not None:
            for k in map.get('InstanceId'):
                self.instance_id.append(k)
        else:
            self.instance_id = None
        return self


class DescribeDeploymentSetsResponseDeploymentSetsDeploymentSet(TeaModel):
    def __init__(self, deployment_set_id=None, deployment_set_description=None, deployment_set_name=None,
                 strategy=None, deployment_strategy=None, domain=None, granularity=None, group_count=None,
                 instance_amount=None, creation_time=None, instance_ids=None):
        self.deployment_set_id = deployment_set_id
        self.deployment_set_description = deployment_set_description
        self.deployment_set_name = deployment_set_name
        self.strategy = strategy
        self.deployment_strategy = deployment_strategy
        self.domain = domain
        self.granularity = granularity
        self.group_count = group_count
        self.instance_amount = instance_amount
        self.creation_time = creation_time
        self.instance_ids = instance_ids

    def validate(self):
        self.validate_required(self.deployment_set_id, 'deployment_set_id')
        self.validate_required(self.deployment_set_description, 'deployment_set_description')
        self.validate_required(self.deployment_set_name, 'deployment_set_name')
        self.validate_required(self.strategy, 'strategy')
        self.validate_required(self.deployment_strategy, 'deployment_strategy')
        self.validate_required(self.domain, 'domain')
        self.validate_required(self.granularity, 'granularity')
        self.validate_required(self.group_count, 'group_count')
        self.validate_required(self.instance_amount, 'instance_amount')
        self.validate_required(self.creation_time, 'creation_time')
        self.validate_required(self.instance_ids, 'instance_ids')
        if self.instance_ids:
            self.instance_ids.validate()

    def to_map(self):
        result = {}
        result['DeploymentSetId'] = self.deployment_set_id
        result['DeploymentSetDescription'] = self.deployment_set_description
        result['DeploymentSetName'] = self.deployment_set_name
        result['Strategy'] = self.strategy
        result['DeploymentStrategy'] = self.deployment_strategy
        result['Domain'] = self.domain
        result['Granularity'] = self.granularity
        result['GroupCount'] = self.group_count
        result['InstanceAmount'] = self.instance_amount
        result['CreationTime'] = self.creation_time
        if self.instance_ids is not None:
            result['InstanceIds'] = self.instance_ids.to_map()
        else:
            result['InstanceIds'] = None
        return result

    def from_map(self, map={}):
        self.deployment_set_id = map.get('DeploymentSetId')
        self.deployment_set_description = map.get('DeploymentSetDescription')
        self.deployment_set_name = map.get('DeploymentSetName')
        self.strategy = map.get('Strategy')
        self.deployment_strategy = map.get('DeploymentStrategy')
        self.domain = map.get('Domain')
        self.granularity = map.get('Granularity')
        self.group_count = map.get('GroupCount')
        self.instance_amount = map.get('InstanceAmount')
        self.creation_time = map.get('CreationTime')
        if map.get('InstanceIds') is not None:
            temp_model = DescribeDeploymentSetsResponseDeploymentSetsDeploymentSetInstanceIds()
            self.instance_ids = temp_model.from_map(map['InstanceIds'])
        else:
            self.instance_ids = None
        return self


class DescribeDeploymentSetsResponseDeploymentSets(TeaModel):
    def __init__(self, deployment_set=None):
        self.deployment_set = deployment_set

    def validate(self):
        self.validate_required(self.deployment_set, 'deployment_set')
        if self.deployment_set:
            for k in self.deployment_set:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['DeploymentSet'] = []
        if self.deployment_set is not None:
            for k in self.deployment_set:
                result['DeploymentSet'].append(k.to_map() if k else None)
        else:
            result['DeploymentSet'] = None
        return result

    def from_map(self, map={}):
        self.deployment_set = []
        if map.get('DeploymentSet') is not None:
            for k in map.get('DeploymentSet'):
                temp_model = DescribeDeploymentSetsResponseDeploymentSetsDeploymentSet()
                temp_model = temp_model.from_map(k)
                self.deployment_set.append(temp_model)
        else:
            self.deployment_set = None
        return self
class DeleteDeploymentSetRequest(TeaModel):
    def __init__(self, region_id=None, deployment_set_id=None):
        self.region_id = region_id
        self.deployment_set_id = deployment_set_id

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.deployment_set_id, 'deployment_set_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['DeploymentSetId'] = self.deployment_set_id
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.deployment_set_id = map.get('DeploymentSetId')
        return self


class DeleteDeploymentSetResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class CreateDeploymentSetRequest(TeaModel):
    def __init__(self, region_id=None, on_unable_to_redeploy_failed_instance=None, description=None,
                 client_token=None, deployment_set_name=None, domain=None, granularity=None, strategy=None, group_count=None):
        self.region_id = region_id
        self.on_unable_to_redeploy_failed_instance = on_unable_to_redeploy_failed_instance
        self.description = description
        self.client_token = client_token
        self.deployment_set_name = deployment_set_name
        self.domain = domain
        self.granularity = granularity
        self.strategy = strategy
        self.group_count = group_count

    def validate(self):
        self.validate_required(self.region_id, 'region_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['OnUnableToRedeployFailedInstance'] = self.on_unable_to_redeploy_failed_instance
        result['Description'] = self.description
        result['ClientToken'] = self.client_token
        result['DeploymentSetName'] = self.deployment_set_name
        result['Domain'] = self.domain
        result['Granularity'] = self.granularity
        result['Strategy'] = self.strategy
        result['GroupCount'] = self.group_count
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.on_unable_to_redeploy_failed_instance = map.get('OnUnableToRedeployFailedInstance')
        self.description = map.get('Description')
        self.client_token = map.get('ClientToken')
        self.deployment_set_name = map.get('DeploymentSetName')
        self.domain = map.get('Domain')
        self.granularity = map.get('Granularity')
        self.strategy = map.get('Strategy')
        self.group_count = map.get('GroupCount')
        return self


class CreateDeploymentSetResponse(TeaModel):
    def __init__(self, request_id=None, deployment_set_id=None):
        self.request_id = request_id
        self.deployment_set_id = deployment_set_id

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.deployment_set_id, 'deployment_set_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['DeploymentSetId'] = self.deployment_set_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.deployment_set_id = map.get('DeploymentSetId')
        return self


class ImportKeyPairRequest(TeaModel):
    def __init__(self, region_id=None, key_pair_name=None, public_key_body=None, tag=None, resource_group_id=None):
        self.region_id = region_id
        self.key_pair_name = key_pair_name
        self.public_key_body = public_key_body
        self.tag = tag
        self.resource_group_id = resource_group_id

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.key_pair_name, 'key_pair_name')
        self.validate_required(self.public_key_body, 'public_key_body')
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['KeyPairName'] = self.key_pair_name
        result['PublicKeyBody'] = self.public_key_body
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        else:
            result['Tag'] = None
        result['ResourceGroupId'] = self.resource_group_id
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.key_pair_name = map.get('KeyPairName')
        self.public_key_body = map.get('PublicKeyBody')
        self.tag = []
        if map.get('Tag') is not None:
            for k in map.get('Tag'):
                temp_model = ImportKeyPairRequestTag()
                temp_model = temp_model.from_map(k)
                self.tag.append(temp_model)
        else:
            self.tag = None
        self.resource_group_id = map.get('ResourceGroupId')
        return self


class ImportKeyPairRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key
        self.value = value

    def validate(self):
        self.validate_required(self.key, 'key')
        self.validate_required(self.value, 'value')

    def to_map(self):
        result = {}
        result['Key'] = self.key
        result['Value'] = self.value
        return result

    def from_map(self, map={}):
        self.key = map.get('Key')
        self.value = map.get('Value')
        return self
class ImportKeyPairResponse(TeaModel):
    def __init__(self, request_id=None, key_pair_name=None, key_pair_finger_print=None):
        self.request_id = request_id
        self.key_pair_name = key_pair_name
        self.key_pair_finger_print = key_pair_finger_print

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.key_pair_name, 'key_pair_name')
        self.validate_required(self.key_pair_finger_print, 'key_pair_finger_print')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['KeyPairName'] = self.key_pair_name
        result['KeyPairFingerPrint'] = self.key_pair_finger_print
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.key_pair_name = map.get('KeyPairName')
        self.key_pair_finger_print = map.get('KeyPairFingerPrint')
        return self


class DetachKeyPairRequest(TeaModel):
    def __init__(self, region_id=None, key_pair_name=None, instance_ids=None):
        self.region_id = region_id
        self.key_pair_name = key_pair_name
        self.instance_ids = instance_ids

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.key_pair_name, 'key_pair_name')
        self.validate_required(self.instance_ids, 'instance_ids')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['KeyPairName'] = self.key_pair_name
        result['InstanceIds'] = self.instance_ids
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.key_pair_name = map.get('KeyPairName')
        self.instance_ids = map.get('InstanceIds')
        return self


class DetachKeyPairResponse(TeaModel):
    def __init__(self, request_id=None, total_count=None, fail_count=None, key_pair_name=None, results=None):
        self.request_id = request_id
        self.total_count = total_count
        self.fail_count = fail_count
        self.key_pair_name = key_pair_name
        self.results = results

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.fail_count, 'fail_count')
        self.validate_required(self.key_pair_name, 'key_pair_name')
        self.validate_required(self.results, 'results')
        if self.results:
            self.results.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['TotalCount'] = self.total_count
        result['FailCount'] = self.fail_count
        result['KeyPairName'] = self.key_pair_name
        if self.results is not None:
            result['Results'] = self.results.to_map()
        else:
            result['Results'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.total_count = map.get('TotalCount')
        self.fail_count = map.get('FailCount')
        self.key_pair_name = map.get('KeyPairName')
        if map.get('Results') is not None:
            temp_model = DetachKeyPairResponseResults()
            self.results = temp_model.from_map(map['Results'])
        else:
            self.results = None
        return self


class DetachKeyPairResponseResultsResult(TeaModel):
    def __init__(self, instance_id=None, success=None, code=None, message=None):
        self.instance_id = instance_id
        self.success = success
        self.code = code
        self.message = message

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.message, 'message')

    def to_map(self):
        result = {}
        result['InstanceId'] = self.instance_id
        result['Success'] = self.success
        result['Code'] = self.code
        result['Message'] = self.message
        return result

    def from_map(self, map={}):
        self.instance_id = map.get('InstanceId')
        self.success = map.get('Success')
        self.code = map.get('Code')
        self.message = map.get('Message')
        return self


class DetachKeyPairResponseResults(TeaModel):
    def __init__(self, result=None):
        self.result = result

    def validate(self):
        self.validate_required(self.result, 'result')
        if self.result:
            for k in self.result:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['Result'] = []
        if self.result is not None:
            for k in self.result:
                result['Result'].append(k.to_map() if k else None)
        else:
            result['Result'] = None
        return result

    def from_map(self, map={}):
        self.result = []
        if map.get('Result') is not None:
            for k in map.get('Result'):
                temp_model = DetachKeyPairResponseResultsResult()
                temp_model = temp_model.from_map(k)
                self.result.append(temp_model)
        else:
            self.result = None
        return self
class DescribeKeyPairsRequest(TeaModel):
    def __init__(self, region_id=None, key_pair_name=None, key_pair_finger_print=None, page_number=None,
                 page_size=None, tag=None, resource_group_id=None):
        self.region_id = region_id
        self.key_pair_name = key_pair_name
        self.key_pair_finger_print = key_pair_finger_print
        self.page_number = page_number
        self.page_size = page_size
        self.tag = tag
        self.resource_group_id = resource_group_id

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['KeyPairName'] = self.key_pair_name
        result['KeyPairFingerPrint'] = self.key_pair_finger_print
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        else:
            result['Tag'] = None
        result['ResourceGroupId'] = self.resource_group_id
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.key_pair_name = map.get('KeyPairName')
        self.key_pair_finger_print = map.get('KeyPairFingerPrint')
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        self.tag = []
        if map.get('Tag') is not None:
            for k in map.get('Tag'):
                temp_model = DescribeKeyPairsRequestTag()
                temp_model = temp_model.from_map(k)
                self.tag.append(temp_model)
        else:
            self.tag = None
        self.resource_group_id = map.get('ResourceGroupId')
        return self


class DescribeKeyPairsRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key
        self.value = value

    def validate(self):
        self.validate_required(self.key, 'key')
        self.validate_required(self.value, 'value')

    def to_map(self):
        result = {}
        result['Key'] = self.key
        result['Value'] = self.value
        return result

    def from_map(self, map={}):
        self.key = map.get('Key')
        self.value = map.get('Value')
        return self
class DescribeKeyPairsResponse(TeaModel):
    def __init__(self, request_id=None, total_count=None, page_number=None, page_size=None, key_pairs=None):
        self.request_id = request_id
        self.total_count = total_count
        self.page_number = page_number
        self.page_size = page_size
        self.key_pairs = key_pairs

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.page_number, 'page_number')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.key_pairs, 'key_pairs')
        if self.key_pairs:
            self.key_pairs.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['TotalCount'] = self.total_count
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        if self.key_pairs is not None:
            result['KeyPairs'] = self.key_pairs.to_map()
        else:
            result['KeyPairs'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.total_count = map.get('TotalCount')
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        if map.get('KeyPairs') is not None:
            temp_model = DescribeKeyPairsResponseKeyPairs()
            self.key_pairs = temp_model.from_map(map['KeyPairs'])
        else:
            self.key_pairs = None
        return self


class DescribeKeyPairsResponseKeyPairsKeyPairTagsTag(TeaModel):
    def __init__(self, tag_key=None, tag_value=None):
        self.tag_key = tag_key
        self.tag_value = tag_value

    def validate(self):
        self.validate_required(self.tag_key, 'tag_key')
        self.validate_required(self.tag_value, 'tag_value')

    def to_map(self):
        result = {}
        result['TagKey'] = self.tag_key
        result['TagValue'] = self.tag_value
        return result

    def from_map(self, map={}):
        self.tag_key = map.get('TagKey')
        self.tag_value = map.get('TagValue')
        return self


class DescribeKeyPairsResponseKeyPairsKeyPairTags(TeaModel):
    def __init__(self, tag=None):
        self.tag = tag

    def validate(self):
        self.validate_required(self.tag, 'tag')
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        else:
            result['Tag'] = None
        return result

    def from_map(self, map={}):
        self.tag = []
        if map.get('Tag') is not None:
            for k in map.get('Tag'):
                temp_model = DescribeKeyPairsResponseKeyPairsKeyPairTagsTag()
                temp_model = temp_model.from_map(k)
                self.tag.append(temp_model)
        else:
            self.tag = None
        return self


class DescribeKeyPairsResponseKeyPairsKeyPair(TeaModel):
    def __init__(self, key_pair_name=None, key_pair_finger_print=None, creation_time=None, resource_group_id=None,
                 tags=None):
        self.key_pair_name = key_pair_name
        self.key_pair_finger_print = key_pair_finger_print
        self.creation_time = creation_time
        self.resource_group_id = resource_group_id
        self.tags = tags

    def validate(self):
        self.validate_required(self.key_pair_name, 'key_pair_name')
        self.validate_required(self.key_pair_finger_print, 'key_pair_finger_print')
        self.validate_required(self.creation_time, 'creation_time')
        self.validate_required(self.resource_group_id, 'resource_group_id')
        self.validate_required(self.tags, 'tags')
        if self.tags:
            self.tags.validate()

    def to_map(self):
        result = {}
        result['KeyPairName'] = self.key_pair_name
        result['KeyPairFingerPrint'] = self.key_pair_finger_print
        result['CreationTime'] = self.creation_time
        result['ResourceGroupId'] = self.resource_group_id
        if self.tags is not None:
            result['Tags'] = self.tags.to_map()
        else:
            result['Tags'] = None
        return result

    def from_map(self, map={}):
        self.key_pair_name = map.get('KeyPairName')
        self.key_pair_finger_print = map.get('KeyPairFingerPrint')
        self.creation_time = map.get('CreationTime')
        self.resource_group_id = map.get('ResourceGroupId')
        if map.get('Tags') is not None:
            temp_model = DescribeKeyPairsResponseKeyPairsKeyPairTags()
            self.tags = temp_model.from_map(map['Tags'])
        else:
            self.tags = None
        return self


class DescribeKeyPairsResponseKeyPairs(TeaModel):
    def __init__(self, key_pair=None):
        self.key_pair = key_pair

    def validate(self):
        self.validate_required(self.key_pair, 'key_pair')
        if self.key_pair:
            for k in self.key_pair:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['KeyPair'] = []
        if self.key_pair is not None:
            for k in self.key_pair:
                result['KeyPair'].append(k.to_map() if k else None)
        else:
            result['KeyPair'] = None
        return result

    def from_map(self, map={}):
        self.key_pair = []
        if map.get('KeyPair') is not None:
            for k in map.get('KeyPair'):
                temp_model = DescribeKeyPairsResponseKeyPairsKeyPair()
                temp_model = temp_model.from_map(k)
                self.key_pair.append(temp_model)
        else:
            self.key_pair = None
        return self
class DeleteKeyPairsRequest(TeaModel):
    def __init__(self, region_id=None, key_pair_names=None):
        self.region_id = region_id
        self.key_pair_names = key_pair_names

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.key_pair_names, 'key_pair_names')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['KeyPairNames'] = self.key_pair_names
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.key_pair_names = map.get('KeyPairNames')
        return self


class DeleteKeyPairsResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class CreateKeyPairRequest(TeaModel):
    def __init__(self, region_id=None, key_pair_name=None, tag=None, resource_group_id=None):
        self.region_id = region_id
        self.key_pair_name = key_pair_name
        self.tag = tag
        self.resource_group_id = resource_group_id

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.key_pair_name, 'key_pair_name')
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['KeyPairName'] = self.key_pair_name
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        else:
            result['Tag'] = None
        result['ResourceGroupId'] = self.resource_group_id
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.key_pair_name = map.get('KeyPairName')
        self.tag = []
        if map.get('Tag') is not None:
            for k in map.get('Tag'):
                temp_model = CreateKeyPairRequestTag()
                temp_model = temp_model.from_map(k)
                self.tag.append(temp_model)
        else:
            self.tag = None
        self.resource_group_id = map.get('ResourceGroupId')
        return self


class CreateKeyPairRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key
        self.value = value

    def validate(self):
        self.validate_required(self.key, 'key')
        self.validate_required(self.value, 'value')

    def to_map(self):
        result = {}
        result['Key'] = self.key
        result['Value'] = self.value
        return result

    def from_map(self, map={}):
        self.key = map.get('Key')
        self.value = map.get('Value')
        return self
class CreateKeyPairResponse(TeaModel):
    def __init__(self, request_id=None, key_pair_id=None, key_pair_name=None, key_pair_finger_print=None,
                 private_key_body=None):
        self.request_id = request_id
        self.key_pair_id = key_pair_id
        self.key_pair_name = key_pair_name
        self.key_pair_finger_print = key_pair_finger_print
        self.private_key_body = private_key_body

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.key_pair_id, 'key_pair_id')
        self.validate_required(self.key_pair_name, 'key_pair_name')
        self.validate_required(self.key_pair_finger_print, 'key_pair_finger_print')
        self.validate_required(self.private_key_body, 'private_key_body')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['KeyPairId'] = self.key_pair_id
        result['KeyPairName'] = self.key_pair_name
        result['KeyPairFingerPrint'] = self.key_pair_finger_print
        result['PrivateKeyBody'] = self.private_key_body
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.key_pair_id = map.get('KeyPairId')
        self.key_pair_name = map.get('KeyPairName')
        self.key_pair_finger_print = map.get('KeyPairFingerPrint')
        self.private_key_body = map.get('PrivateKeyBody')
        return self


class AttachKeyPairRequest(TeaModel):
    def __init__(self, region_id=None, key_pair_name=None, instance_ids=None):
        self.region_id = region_id
        self.key_pair_name = key_pair_name
        self.instance_ids = instance_ids

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.key_pair_name, 'key_pair_name')
        self.validate_required(self.instance_ids, 'instance_ids')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['KeyPairName'] = self.key_pair_name
        result['InstanceIds'] = self.instance_ids
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.key_pair_name = map.get('KeyPairName')
        self.instance_ids = map.get('InstanceIds')
        return self


class AttachKeyPairResponse(TeaModel):
    def __init__(self, request_id=None, total_count=None, fail_count=None, key_pair_name=None, results=None):
        self.request_id = request_id
        self.total_count = total_count
        self.fail_count = fail_count
        self.key_pair_name = key_pair_name
        self.results = results

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.fail_count, 'fail_count')
        self.validate_required(self.key_pair_name, 'key_pair_name')
        self.validate_required(self.results, 'results')
        if self.results:
            self.results.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['TotalCount'] = self.total_count
        result['FailCount'] = self.fail_count
        result['KeyPairName'] = self.key_pair_name
        if self.results is not None:
            result['Results'] = self.results.to_map()
        else:
            result['Results'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.total_count = map.get('TotalCount')
        self.fail_count = map.get('FailCount')
        self.key_pair_name = map.get('KeyPairName')
        if map.get('Results') is not None:
            temp_model = AttachKeyPairResponseResults()
            self.results = temp_model.from_map(map['Results'])
        else:
            self.results = None
        return self


class AttachKeyPairResponseResultsResult(TeaModel):
    def __init__(self, instance_id=None, success=None, code=None, message=None):
        self.instance_id = instance_id
        self.success = success
        self.code = code
        self.message = message

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.message, 'message')

    def to_map(self):
        result = {}
        result['InstanceId'] = self.instance_id
        result['Success'] = self.success
        result['Code'] = self.code
        result['Message'] = self.message
        return result

    def from_map(self, map={}):
        self.instance_id = map.get('InstanceId')
        self.success = map.get('Success')
        self.code = map.get('Code')
        self.message = map.get('Message')
        return self


class AttachKeyPairResponseResults(TeaModel):
    def __init__(self, result=None):
        self.result = result

    def validate(self):
        self.validate_required(self.result, 'result')
        if self.result:
            for k in self.result:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['Result'] = []
        if self.result is not None:
            for k in self.result:
                result['Result'].append(k.to_map() if k else None)
        else:
            result['Result'] = None
        return result

    def from_map(self, map={}):
        self.result = []
        if map.get('Result') is not None:
            for k in map.get('Result'):
                temp_model = AttachKeyPairResponseResultsResult()
                temp_model = temp_model.from_map(k)
                self.result.append(temp_model)
        else:
            self.result = None
        return self
class ModifyInstanceAutoRenewAttributeRequest(TeaModel):
    def __init__(self, instance_id=None, region_id=None, duration=None, auto_renew=None, renewal_status=None,
                 period_unit=None):
        self.instance_id = instance_id
        self.region_id = region_id
        self.duration = duration
        self.auto_renew = auto_renew
        self.renewal_status = renewal_status
        self.period_unit = period_unit

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.region_id, 'region_id')

    def to_map(self):
        result = {}
        result['InstanceId'] = self.instance_id
        result['RegionId'] = self.region_id
        result['Duration'] = self.duration
        result['AutoRenew'] = self.auto_renew
        result['RenewalStatus'] = self.renewal_status
        result['PeriodUnit'] = self.period_unit
        return result

    def from_map(self, map={}):
        self.instance_id = map.get('InstanceId')
        self.region_id = map.get('RegionId')
        self.duration = map.get('Duration')
        self.auto_renew = map.get('AutoRenew')
        self.renewal_status = map.get('RenewalStatus')
        self.period_unit = map.get('PeriodUnit')
        return self


class ModifyInstanceAutoRenewAttributeResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class DescribeInstanceAutoRenewAttributeRequest(TeaModel):
    def __init__(self, instance_id=None, region_id=None, renewal_status=None, page_size=None, page_number=None):
        self.instance_id = instance_id
        self.region_id = region_id
        self.renewal_status = renewal_status
        self.page_size = page_size
        self.page_number = page_number

    def validate(self):
        self.validate_required(self.region_id, 'region_id')

    def to_map(self):
        result = {}
        result['InstanceId'] = self.instance_id
        result['RegionId'] = self.region_id
        result['RenewalStatus'] = self.renewal_status
        result['PageSize'] = self.page_size
        result['PageNumber'] = self.page_number
        return result

    def from_map(self, map={}):
        self.instance_id = map.get('InstanceId')
        self.region_id = map.get('RegionId')
        self.renewal_status = map.get('RenewalStatus')
        self.page_size = map.get('PageSize')
        self.page_number = map.get('PageNumber')
        return self


class DescribeInstanceAutoRenewAttributeResponse(TeaModel):
    def __init__(self, request_id=None, page_number=None, page_size=None, total_count=None,
                 instance_renew_attributes=None):
        self.request_id = request_id
        self.page_number = page_number
        self.page_size = page_size
        self.total_count = total_count
        self.instance_renew_attributes = instance_renew_attributes

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.page_number, 'page_number')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.instance_renew_attributes, 'instance_renew_attributes')
        if self.instance_renew_attributes:
            self.instance_renew_attributes.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        result['TotalCount'] = self.total_count
        if self.instance_renew_attributes is not None:
            result['InstanceRenewAttributes'] = self.instance_renew_attributes.to_map()
        else:
            result['InstanceRenewAttributes'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        self.total_count = map.get('TotalCount')
        if map.get('InstanceRenewAttributes') is not None:
            temp_model = DescribeInstanceAutoRenewAttributeResponseInstanceRenewAttributes()
            self.instance_renew_attributes = temp_model.from_map(map['InstanceRenewAttributes'])
        else:
            self.instance_renew_attributes = None
        return self


class DescribeInstanceAutoRenewAttributeResponseInstanceRenewAttributesInstanceRenewAttribute(TeaModel):
    def __init__(self, instance_id=None, auto_renew_enabled=None, duration=None, period_unit=None,
                 renewal_status=None):
        self.instance_id = instance_id
        self.auto_renew_enabled = auto_renew_enabled
        self.duration = duration
        self.period_unit = period_unit
        self.renewal_status = renewal_status

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.auto_renew_enabled, 'auto_renew_enabled')
        self.validate_required(self.duration, 'duration')
        self.validate_required(self.period_unit, 'period_unit')
        self.validate_required(self.renewal_status, 'renewal_status')

    def to_map(self):
        result = {}
        result['InstanceId'] = self.instance_id
        result['AutoRenewEnabled'] = self.auto_renew_enabled
        result['Duration'] = self.duration
        result['PeriodUnit'] = self.period_unit
        result['RenewalStatus'] = self.renewal_status
        return result

    def from_map(self, map={}):
        self.instance_id = map.get('InstanceId')
        self.auto_renew_enabled = map.get('AutoRenewEnabled')
        self.duration = map.get('Duration')
        self.period_unit = map.get('PeriodUnit')
        self.renewal_status = map.get('RenewalStatus')
        return self


class DescribeInstanceAutoRenewAttributeResponseInstanceRenewAttributes(TeaModel):
    def __init__(self, instance_renew_attribute=None):
        self.instance_renew_attribute = instance_renew_attribute

    def validate(self):
        self.validate_required(self.instance_renew_attribute, 'instance_renew_attribute')
        if self.instance_renew_attribute:
            for k in self.instance_renew_attribute:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['InstanceRenewAttribute'] = []
        if self.instance_renew_attribute is not None:
            for k in self.instance_renew_attribute:
                result['InstanceRenewAttribute'].append(k.to_map() if k else None)
        else:
            result['InstanceRenewAttribute'] = None
        return result

    def from_map(self, map={}):
        self.instance_renew_attribute = []
        if map.get('InstanceRenewAttribute') is not None:
            for k in map.get('InstanceRenewAttribute'):
                temp_model = DescribeInstanceAutoRenewAttributeResponseInstanceRenewAttributesInstanceRenewAttribute()
                temp_model = temp_model.from_map(k)
                self.instance_renew_attribute.append(temp_model)
        else:
            self.instance_renew_attribute = None
        return self
class DescribeSnapshotLinksRequest(TeaModel):
    def __init__(self, region_id=None, instance_id=None, disk_ids=None, snapshot_link_ids=None, page_number=None,
                 page_size=None):
        self.region_id = region_id
        self.instance_id = instance_id
        self.disk_ids = disk_ids
        self.snapshot_link_ids = snapshot_link_ids
        self.page_number = page_number
        self.page_size = page_size

    def validate(self):
        self.validate_required(self.region_id, 'region_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['InstanceId'] = self.instance_id
        result['DiskIds'] = self.disk_ids
        result['SnapshotLinkIds'] = self.snapshot_link_ids
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.instance_id = map.get('InstanceId')
        self.disk_ids = map.get('DiskIds')
        self.snapshot_link_ids = map.get('SnapshotLinkIds')
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        return self


class DescribeSnapshotLinksResponse(TeaModel):
    def __init__(self, request_id=None, total_count=None, page_number=None, page_size=None, snapshot_links=None):
        self.request_id = request_id
        self.total_count = total_count
        self.page_number = page_number
        self.page_size = page_size
        self.snapshot_links = snapshot_links

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.page_number, 'page_number')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.snapshot_links, 'snapshot_links')
        if self.snapshot_links:
            self.snapshot_links.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['TotalCount'] = self.total_count
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        if self.snapshot_links is not None:
            result['SnapshotLinks'] = self.snapshot_links.to_map()
        else:
            result['SnapshotLinks'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.total_count = map.get('TotalCount')
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        if map.get('SnapshotLinks') is not None:
            temp_model = DescribeSnapshotLinksResponseSnapshotLinks()
            self.snapshot_links = temp_model.from_map(map['SnapshotLinks'])
        else:
            self.snapshot_links = None
        return self


class DescribeSnapshotLinksResponseSnapshotLinksSnapshotLink(TeaModel):
    def __init__(self, snapshot_link_id=None, region_id=None, instance_id=None, instance_name=None,
                 source_disk_id=None, source_disk_name=None, source_disk_size=None, source_disk_type=None, category=None,
                 total_size=None, total_count=None):
        self.snapshot_link_id = snapshot_link_id
        self.region_id = region_id
        self.instance_id = instance_id
        self.instance_name = instance_name
        self.source_disk_id = source_disk_id
        self.source_disk_name = source_disk_name
        self.source_disk_size = source_disk_size
        self.source_disk_type = source_disk_type
        self.category = category
        self.total_size = total_size
        self.total_count = total_count

    def validate(self):
        self.validate_required(self.snapshot_link_id, 'snapshot_link_id')
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.instance_name, 'instance_name')
        self.validate_required(self.source_disk_id, 'source_disk_id')
        self.validate_required(self.source_disk_name, 'source_disk_name')
        self.validate_required(self.source_disk_size, 'source_disk_size')
        self.validate_required(self.source_disk_type, 'source_disk_type')
        self.validate_required(self.category, 'category')
        self.validate_required(self.total_size, 'total_size')
        self.validate_required(self.total_count, 'total_count')

    def to_map(self):
        result = {}
        result['SnapshotLinkId'] = self.snapshot_link_id
        result['RegionId'] = self.region_id
        result['InstanceId'] = self.instance_id
        result['InstanceName'] = self.instance_name
        result['SourceDiskId'] = self.source_disk_id
        result['SourceDiskName'] = self.source_disk_name
        result['SourceDiskSize'] = self.source_disk_size
        result['SourceDiskType'] = self.source_disk_type
        result['Category'] = self.category
        result['TotalSize'] = self.total_size
        result['TotalCount'] = self.total_count
        return result

    def from_map(self, map={}):
        self.snapshot_link_id = map.get('SnapshotLinkId')
        self.region_id = map.get('RegionId')
        self.instance_id = map.get('InstanceId')
        self.instance_name = map.get('InstanceName')
        self.source_disk_id = map.get('SourceDiskId')
        self.source_disk_name = map.get('SourceDiskName')
        self.source_disk_size = map.get('SourceDiskSize')
        self.source_disk_type = map.get('SourceDiskType')
        self.category = map.get('Category')
        self.total_size = map.get('TotalSize')
        self.total_count = map.get('TotalCount')
        return self


class DescribeSnapshotLinksResponseSnapshotLinks(TeaModel):
    def __init__(self, snapshot_link=None):
        self.snapshot_link = snapshot_link

    def validate(self):
        self.validate_required(self.snapshot_link, 'snapshot_link')
        if self.snapshot_link:
            for k in self.snapshot_link:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['SnapshotLink'] = []
        if self.snapshot_link is not None:
            for k in self.snapshot_link:
                result['SnapshotLink'].append(k.to_map() if k else None)
        else:
            result['SnapshotLink'] = None
        return result

    def from_map(self, map={}):
        self.snapshot_link = []
        if map.get('SnapshotLink') is not None:
            for k in map.get('SnapshotLink'):
                temp_model = DescribeSnapshotLinksResponseSnapshotLinksSnapshotLink()
                temp_model = temp_model.from_map(k)
                self.snapshot_link.append(temp_model)
        else:
            self.snapshot_link = None
        return self
class ModifyInstanceAutoReleaseTimeRequest(TeaModel):
    def __init__(self, region_id=None, instance_id=None, auto_release_time=None):
        self.region_id = region_id
        self.instance_id = instance_id
        self.auto_release_time = auto_release_time

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['InstanceId'] = self.instance_id
        result['AutoReleaseTime'] = self.auto_release_time
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.instance_id = map.get('InstanceId')
        self.auto_release_time = map.get('AutoReleaseTime')
        return self


class ModifyInstanceAutoReleaseTimeResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class DescribeNewProjectEipMonitorDataRequest(TeaModel):
    def __init__(self, region_id=None, allocation_id=None, start_time=None, end_time=None, period=None):
        self.region_id = region_id
        self.allocation_id = allocation_id
        self.start_time = start_time
        self.end_time = end_time
        self.period = period

    def validate(self):
        self.validate_required(self.allocation_id, 'allocation_id')
        self.validate_required(self.start_time, 'start_time')
        self.validate_required(self.end_time, 'end_time')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['AllocationId'] = self.allocation_id
        result['StartTime'] = self.start_time
        result['EndTime'] = self.end_time
        result['Period'] = self.period
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.allocation_id = map.get('AllocationId')
        self.start_time = map.get('StartTime')
        self.end_time = map.get('EndTime')
        self.period = map.get('Period')
        return self


class DescribeNewProjectEipMonitorDataResponse(TeaModel):
    def __init__(self, request_id=None, eip_monitor_datas=None):
        self.request_id = request_id
        self.eip_monitor_datas = eip_monitor_datas

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.eip_monitor_datas, 'eip_monitor_datas')
        if self.eip_monitor_datas:
            self.eip_monitor_datas.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        if self.eip_monitor_datas is not None:
            result['EipMonitorDatas'] = self.eip_monitor_datas.to_map()
        else:
            result['EipMonitorDatas'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        if map.get('EipMonitorDatas') is not None:
            temp_model = DescribeNewProjectEipMonitorDataResponseEipMonitorDatas()
            self.eip_monitor_datas = temp_model.from_map(map['EipMonitorDatas'])
        else:
            self.eip_monitor_datas = None
        return self


class DescribeNewProjectEipMonitorDataResponseEipMonitorDatasEipMonitorData(TeaModel):
    def __init__(self, eip_rx=None, eip_tx=None, eip_flow=None, eip_bandwidth=None, eip_packets=None,
                 time_stamp=None):
        self.eip_rx = eip_rx
        self.eip_tx = eip_tx
        self.eip_flow = eip_flow
        self.eip_bandwidth = eip_bandwidth
        self.eip_packets = eip_packets
        self.time_stamp = time_stamp

    def validate(self):
        self.validate_required(self.eip_rx, 'eip_rx')
        self.validate_required(self.eip_tx, 'eip_tx')
        self.validate_required(self.eip_flow, 'eip_flow')
        self.validate_required(self.eip_bandwidth, 'eip_bandwidth')
        self.validate_required(self.eip_packets, 'eip_packets')
        self.validate_required(self.time_stamp, 'time_stamp')

    def to_map(self):
        result = {}
        result['EipRX'] = self.eip_rx
        result['EipTX'] = self.eip_tx
        result['EipFlow'] = self.eip_flow
        result['EipBandwidth'] = self.eip_bandwidth
        result['EipPackets'] = self.eip_packets
        result['TimeStamp'] = self.time_stamp
        return result

    def from_map(self, map={}):
        self.eip_rx = map.get('EipRX')
        self.eip_tx = map.get('EipTX')
        self.eip_flow = map.get('EipFlow')
        self.eip_bandwidth = map.get('EipBandwidth')
        self.eip_packets = map.get('EipPackets')
        self.time_stamp = map.get('TimeStamp')
        return self


class DescribeNewProjectEipMonitorDataResponseEipMonitorDatas(TeaModel):
    def __init__(self, eip_monitor_data=None):
        self.eip_monitor_data = eip_monitor_data

    def validate(self):
        self.validate_required(self.eip_monitor_data, 'eip_monitor_data')
        if self.eip_monitor_data:
            for k in self.eip_monitor_data:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['EipMonitorData'] = []
        if self.eip_monitor_data is not None:
            for k in self.eip_monitor_data:
                result['EipMonitorData'].append(k.to_map() if k else None)
        else:
            result['EipMonitorData'] = None
        return result

    def from_map(self, map={}):
        self.eip_monitor_data = []
        if map.get('EipMonitorData') is not None:
            for k in map.get('EipMonitorData'):
                temp_model = DescribeNewProjectEipMonitorDataResponseEipMonitorDatasEipMonitorData()
                temp_model = temp_model.from_map(k)
                self.eip_monitor_data.append(temp_model)
        else:
            self.eip_monitor_data = None
        return self
class DescribeUserDataRequest(TeaModel):
    def __init__(self, region_id=None, instance_id=None):
        self.region_id = region_id
        self.instance_id = instance_id

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['InstanceId'] = self.instance_id
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.instance_id = map.get('InstanceId')
        return self


class DescribeUserDataResponse(TeaModel):
    def __init__(self, request_id=None, region_id=None, instance_id=None, user_data=None):
        self.request_id = request_id
        self.region_id = region_id
        self.instance_id = instance_id
        self.user_data = user_data

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.user_data, 'user_data')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['RegionId'] = self.region_id
        result['InstanceId'] = self.instance_id
        result['UserData'] = self.user_data
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.region_id = map.get('RegionId')
        self.instance_id = map.get('InstanceId')
        self.user_data = map.get('UserData')
        return self


class RemoveBandwidthPackageIpsRequest(TeaModel):
    def __init__(self, region_id=None, bandwidth_package_id=None, client_token=None, removed_ip_addresses=None):
        self.region_id = region_id
        self.bandwidth_package_id = bandwidth_package_id
        self.client_token = client_token
        self.removed_ip_addresses = removed_ip_addresses

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.bandwidth_package_id, 'bandwidth_package_id')
        self.validate_required(self.removed_ip_addresses, 'removed_ip_addresses')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['BandwidthPackageId'] = self.bandwidth_package_id
        result['ClientToken'] = self.client_token
        result['RemovedIpAddresses'] = []
        if self.removed_ip_addresses is not None:
            for k in self.removed_ip_addresses:
                result['RemovedIpAddresses'].append(k)
        else:
            result['RemovedIpAddresses'] = None
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.bandwidth_package_id = map.get('BandwidthPackageId')
        self.client_token = map.get('ClientToken')
        self.removed_ip_addresses = []
        if map.get('RemovedIpAddresses') is not None:
            for k in map.get('RemovedIpAddresses'):
                self.removed_ip_addresses.append(k)
        else:
            self.removed_ip_addresses = None
        return self


class RemoveBandwidthPackageIpsResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class ModifyForwardEntryRequest(TeaModel):
    def __init__(self, forward_table_id=None, forward_entry_id=None, external_ip=None, external_port=None,
                 internal_ip=None, internal_port=None, ip_protocol=None, region_id=None):
        self.forward_table_id = forward_table_id
        self.forward_entry_id = forward_entry_id
        self.external_ip = external_ip
        self.external_port = external_port
        self.internal_ip = internal_ip
        self.internal_port = internal_port
        self.ip_protocol = ip_protocol
        self.region_id = region_id

    def validate(self):
        self.validate_required(self.forward_table_id, 'forward_table_id')
        self.validate_required(self.forward_entry_id, 'forward_entry_id')
        self.validate_required(self.region_id, 'region_id')

    def to_map(self):
        result = {}
        result['ForwardTableId'] = self.forward_table_id
        result['ForwardEntryId'] = self.forward_entry_id
        result['ExternalIp'] = self.external_ip
        result['ExternalPort'] = self.external_port
        result['InternalIp'] = self.internal_ip
        result['InternalPort'] = self.internal_port
        result['IpProtocol'] = self.ip_protocol
        result['RegionId'] = self.region_id
        return result

    def from_map(self, map={}):
        self.forward_table_id = map.get('ForwardTableId')
        self.forward_entry_id = map.get('ForwardEntryId')
        self.external_ip = map.get('ExternalIp')
        self.external_port = map.get('ExternalPort')
        self.internal_ip = map.get('InternalIp')
        self.internal_port = map.get('InternalPort')
        self.ip_protocol = map.get('IpProtocol')
        self.region_id = map.get('RegionId')
        return self


class ModifyForwardEntryResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class ModifyBandwidthPackageSpecRequest(TeaModel):
    def __init__(self, region_id=None, bandwidth_package_id=None, bandwidth=None):
        self.region_id = region_id
        self.bandwidth_package_id = bandwidth_package_id
        self.bandwidth = bandwidth

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.bandwidth_package_id, 'bandwidth_package_id')
        self.validate_required(self.bandwidth, 'bandwidth')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['BandwidthPackageId'] = self.bandwidth_package_id
        result['Bandwidth'] = self.bandwidth
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.bandwidth_package_id = map.get('BandwidthPackageId')
        self.bandwidth = map.get('Bandwidth')
        return self


class ModifyBandwidthPackageSpecResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class DescribeNatGatewaysRequest(TeaModel):
    def __init__(self, region_id=None, nat_gateway_id=None, vpc_id=None, page_number=None, page_size=None):
        self.region_id = region_id
        self.nat_gateway_id = nat_gateway_id
        self.vpc_id = vpc_id
        self.page_number = page_number
        self.page_size = page_size

    def validate(self):
        self.validate_required(self.region_id, 'region_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['NatGatewayId'] = self.nat_gateway_id
        result['VpcId'] = self.vpc_id
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.nat_gateway_id = map.get('NatGatewayId')
        self.vpc_id = map.get('VpcId')
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        return self


class DescribeNatGatewaysResponse(TeaModel):
    def __init__(self, request_id=None, total_count=None, page_number=None, page_size=None, nat_gateways=None):
        self.request_id = request_id
        self.total_count = total_count
        self.page_number = page_number
        self.page_size = page_size
        self.nat_gateways = nat_gateways

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.page_number, 'page_number')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.nat_gateways, 'nat_gateways')
        if self.nat_gateways:
            self.nat_gateways.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['TotalCount'] = self.total_count
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        if self.nat_gateways is not None:
            result['NatGateways'] = self.nat_gateways.to_map()
        else:
            result['NatGateways'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.total_count = map.get('TotalCount')
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        if map.get('NatGateways') is not None:
            temp_model = DescribeNatGatewaysResponseNatGateways()
            self.nat_gateways = temp_model.from_map(map['NatGateways'])
        else:
            self.nat_gateways = None
        return self


class DescribeNatGatewaysResponseNatGatewaysNatGatewayForwardTableIds(TeaModel):
    def __init__(self, forward_table_id=None):
        # ForwardTableId
        self.forward_table_id = forward_table_id

    def validate(self):
        self.validate_required(self.forward_table_id, 'forward_table_id')

    def to_map(self):
        result = {}
        result['ForwardTableId'] = []
        if self.forward_table_id is not None:
            for k in self.forward_table_id:
                result['ForwardTableId'].append(k)
        else:
            result['ForwardTableId'] = None
        return result

    def from_map(self, map={}):
        self.forward_table_id = []
        if map.get('ForwardTableId') is not None:
            for k in map.get('ForwardTableId'):
                self.forward_table_id.append(k)
        else:
            self.forward_table_id = None
        return self


class DescribeNatGatewaysResponseNatGatewaysNatGatewayBandwidthPackageIds(TeaModel):
    def __init__(self, bandwidth_package_id=None):
        # BandwidthPackageId
        self.bandwidth_package_id = bandwidth_package_id

    def validate(self):
        self.validate_required(self.bandwidth_package_id, 'bandwidth_package_id')

    def to_map(self):
        result = {}
        result['BandwidthPackageId'] = []
        if self.bandwidth_package_id is not None:
            for k in self.bandwidth_package_id:
                result['BandwidthPackageId'].append(k)
        else:
            result['BandwidthPackageId'] = None
        return result

    def from_map(self, map={}):
        self.bandwidth_package_id = []
        if map.get('BandwidthPackageId') is not None:
            for k in map.get('BandwidthPackageId'):
                self.bandwidth_package_id.append(k)
        else:
            self.bandwidth_package_id = None
        return self


class DescribeNatGatewaysResponseNatGatewaysNatGateway(TeaModel):
    def __init__(self, nat_gateway_id=None, region_id=None, name=None, description=None, vpc_id=None, spec=None,
                 instance_charge_type=None, business_status=None, creation_time=None, status=None, forward_table_ids=None,
                 bandwidth_package_ids=None):
        self.nat_gateway_id = nat_gateway_id
        self.region_id = region_id
        self.name = name
        self.description = description
        self.vpc_id = vpc_id
        self.spec = spec
        self.instance_charge_type = instance_charge_type
        self.business_status = business_status
        self.creation_time = creation_time
        self.status = status
        self.forward_table_ids = forward_table_ids
        self.bandwidth_package_ids = bandwidth_package_ids

    def validate(self):
        self.validate_required(self.nat_gateway_id, 'nat_gateway_id')
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.name, 'name')
        self.validate_required(self.description, 'description')
        self.validate_required(self.vpc_id, 'vpc_id')
        self.validate_required(self.spec, 'spec')
        self.validate_required(self.instance_charge_type, 'instance_charge_type')
        self.validate_required(self.business_status, 'business_status')
        self.validate_required(self.creation_time, 'creation_time')
        self.validate_required(self.status, 'status')
        self.validate_required(self.forward_table_ids, 'forward_table_ids')
        if self.forward_table_ids:
            self.forward_table_ids.validate()
        self.validate_required(self.bandwidth_package_ids, 'bandwidth_package_ids')
        if self.bandwidth_package_ids:
            self.bandwidth_package_ids.validate()

    def to_map(self):
        result = {}
        result['NatGatewayId'] = self.nat_gateway_id
        result['RegionId'] = self.region_id
        result['Name'] = self.name
        result['Description'] = self.description
        result['VpcId'] = self.vpc_id
        result['Spec'] = self.spec
        result['InstanceChargeType'] = self.instance_charge_type
        result['BusinessStatus'] = self.business_status
        result['CreationTime'] = self.creation_time
        result['Status'] = self.status
        if self.forward_table_ids is not None:
            result['ForwardTableIds'] = self.forward_table_ids.to_map()
        else:
            result['ForwardTableIds'] = None
        if self.bandwidth_package_ids is not None:
            result['BandwidthPackageIds'] = self.bandwidth_package_ids.to_map()
        else:
            result['BandwidthPackageIds'] = None
        return result

    def from_map(self, map={}):
        self.nat_gateway_id = map.get('NatGatewayId')
        self.region_id = map.get('RegionId')
        self.name = map.get('Name')
        self.description = map.get('Description')
        self.vpc_id = map.get('VpcId')
        self.spec = map.get('Spec')
        self.instance_charge_type = map.get('InstanceChargeType')
        self.business_status = map.get('BusinessStatus')
        self.creation_time = map.get('CreationTime')
        self.status = map.get('Status')
        if map.get('ForwardTableIds') is not None:
            temp_model = DescribeNatGatewaysResponseNatGatewaysNatGatewayForwardTableIds()
            self.forward_table_ids = temp_model.from_map(map['ForwardTableIds'])
        else:
            self.forward_table_ids = None
        if map.get('BandwidthPackageIds') is not None:
            temp_model = DescribeNatGatewaysResponseNatGatewaysNatGatewayBandwidthPackageIds()
            self.bandwidth_package_ids = temp_model.from_map(map['BandwidthPackageIds'])
        else:
            self.bandwidth_package_ids = None
        return self


class DescribeNatGatewaysResponseNatGateways(TeaModel):
    def __init__(self, nat_gateway=None):
        self.nat_gateway = nat_gateway

    def validate(self):
        self.validate_required(self.nat_gateway, 'nat_gateway')
        if self.nat_gateway:
            for k in self.nat_gateway:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['NatGateway'] = []
        if self.nat_gateway is not None:
            for k in self.nat_gateway:
                result['NatGateway'].append(k.to_map() if k else None)
        else:
            result['NatGateway'] = None
        return result

    def from_map(self, map={}):
        self.nat_gateway = []
        if map.get('NatGateway') is not None:
            for k in map.get('NatGateway'):
                temp_model = DescribeNatGatewaysResponseNatGatewaysNatGateway()
                temp_model = temp_model.from_map(k)
                self.nat_gateway.append(temp_model)
        else:
            self.nat_gateway = None
        return self
class DescribeForwardTableEntriesRequest(TeaModel):
    def __init__(self, region_id=None, forward_table_id=None, forward_entry_id=None, page_number=None,
                 page_size=None):
        self.region_id = region_id
        self.forward_table_id = forward_table_id
        self.forward_entry_id = forward_entry_id
        self.page_number = page_number
        self.page_size = page_size

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.forward_table_id, 'forward_table_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['ForwardTableId'] = self.forward_table_id
        result['ForwardEntryId'] = self.forward_entry_id
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.forward_table_id = map.get('ForwardTableId')
        self.forward_entry_id = map.get('ForwardEntryId')
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        return self


class DescribeForwardTableEntriesResponse(TeaModel):
    def __init__(self, request_id=None, total_count=None, page_number=None, page_size=None,
                 forward_table_entries=None):
        self.request_id = request_id
        self.total_count = total_count
        self.page_number = page_number
        self.page_size = page_size
        self.forward_table_entries = forward_table_entries

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.page_number, 'page_number')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.forward_table_entries, 'forward_table_entries')
        if self.forward_table_entries:
            self.forward_table_entries.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['TotalCount'] = self.total_count
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        if self.forward_table_entries is not None:
            result['ForwardTableEntries'] = self.forward_table_entries.to_map()
        else:
            result['ForwardTableEntries'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.total_count = map.get('TotalCount')
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        if map.get('ForwardTableEntries') is not None:
            temp_model = DescribeForwardTableEntriesResponseForwardTableEntries()
            self.forward_table_entries = temp_model.from_map(map['ForwardTableEntries'])
        else:
            self.forward_table_entries = None
        return self


class DescribeForwardTableEntriesResponseForwardTableEntriesForwardTableEntry(TeaModel):
    def __init__(self, forward_table_id=None, forward_entry_id=None, external_ip=None, external_port=None,
                 ip_protocol=None, internal_ip=None, internal_port=None, status=None):
        self.forward_table_id = forward_table_id
        self.forward_entry_id = forward_entry_id
        self.external_ip = external_ip
        self.external_port = external_port
        self.ip_protocol = ip_protocol
        self.internal_ip = internal_ip
        self.internal_port = internal_port
        self.status = status

    def validate(self):
        self.validate_required(self.forward_table_id, 'forward_table_id')
        self.validate_required(self.forward_entry_id, 'forward_entry_id')
        self.validate_required(self.external_ip, 'external_ip')
        self.validate_required(self.external_port, 'external_port')
        self.validate_required(self.ip_protocol, 'ip_protocol')
        self.validate_required(self.internal_ip, 'internal_ip')
        self.validate_required(self.internal_port, 'internal_port')
        self.validate_required(self.status, 'status')

    def to_map(self):
        result = {}
        result['ForwardTableId'] = self.forward_table_id
        result['ForwardEntryId'] = self.forward_entry_id
        result['ExternalIp'] = self.external_ip
        result['ExternalPort'] = self.external_port
        result['IpProtocol'] = self.ip_protocol
        result['InternalIp'] = self.internal_ip
        result['InternalPort'] = self.internal_port
        result['Status'] = self.status
        return result

    def from_map(self, map={}):
        self.forward_table_id = map.get('ForwardTableId')
        self.forward_entry_id = map.get('ForwardEntryId')
        self.external_ip = map.get('ExternalIp')
        self.external_port = map.get('ExternalPort')
        self.ip_protocol = map.get('IpProtocol')
        self.internal_ip = map.get('InternalIp')
        self.internal_port = map.get('InternalPort')
        self.status = map.get('Status')
        return self


class DescribeForwardTableEntriesResponseForwardTableEntries(TeaModel):
    def __init__(self, forward_table_entry=None):
        self.forward_table_entry = forward_table_entry

    def validate(self):
        self.validate_required(self.forward_table_entry, 'forward_table_entry')
        if self.forward_table_entry:
            for k in self.forward_table_entry:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['ForwardTableEntry'] = []
        if self.forward_table_entry is not None:
            for k in self.forward_table_entry:
                result['ForwardTableEntry'].append(k.to_map() if k else None)
        else:
            result['ForwardTableEntry'] = None
        return result

    def from_map(self, map={}):
        self.forward_table_entry = []
        if map.get('ForwardTableEntry') is not None:
            for k in map.get('ForwardTableEntry'):
                temp_model = DescribeForwardTableEntriesResponseForwardTableEntriesForwardTableEntry()
                temp_model = temp_model.from_map(k)
                self.forward_table_entry.append(temp_model)
        else:
            self.forward_table_entry = None
        return self
class DescribeBandwidthPackagesRequest(TeaModel):
    def __init__(self, region_id=None, bandwidth_package_id=None, nat_gateway_id=None, page_number=None,
                 page_size=None):
        self.region_id = region_id
        self.bandwidth_package_id = bandwidth_package_id
        self.nat_gateway_id = nat_gateway_id
        self.page_number = page_number
        self.page_size = page_size

    def validate(self):
        self.validate_required(self.region_id, 'region_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['BandwidthPackageId'] = self.bandwidth_package_id
        result['NatGatewayId'] = self.nat_gateway_id
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.bandwidth_package_id = map.get('BandwidthPackageId')
        self.nat_gateway_id = map.get('NatGatewayId')
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        return self


class DescribeBandwidthPackagesResponse(TeaModel):
    def __init__(self, request_id=None, total_count=None, page_number=None, page_size=None, bandwidth_packages=None):
        self.request_id = request_id
        self.total_count = total_count
        self.page_number = page_number
        self.page_size = page_size
        self.bandwidth_packages = bandwidth_packages

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.page_number, 'page_number')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.bandwidth_packages, 'bandwidth_packages')
        if self.bandwidth_packages:
            self.bandwidth_packages.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['TotalCount'] = self.total_count
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        if self.bandwidth_packages is not None:
            result['BandwidthPackages'] = self.bandwidth_packages.to_map()
        else:
            result['BandwidthPackages'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.total_count = map.get('TotalCount')
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        if map.get('BandwidthPackages') is not None:
            temp_model = DescribeBandwidthPackagesResponseBandwidthPackages()
            self.bandwidth_packages = temp_model.from_map(map['BandwidthPackages'])
        else:
            self.bandwidth_packages = None
        return self


class DescribeBandwidthPackagesResponseBandwidthPackagesBandwidthPackagePublicIpAddressesPublicIpAddresse(TeaModel):
    def __init__(self, allocation_id=None, ip_address=None):
        self.allocation_id = allocation_id
        self.ip_address = ip_address

    def validate(self):
        self.validate_required(self.allocation_id, 'allocation_id')
        self.validate_required(self.ip_address, 'ip_address')

    def to_map(self):
        result = {}
        result['AllocationId'] = self.allocation_id
        result['IpAddress'] = self.ip_address
        return result

    def from_map(self, map={}):
        self.allocation_id = map.get('AllocationId')
        self.ip_address = map.get('IpAddress')
        return self


class DescribeBandwidthPackagesResponseBandwidthPackagesBandwidthPackagePublicIpAddresses(TeaModel):
    def __init__(self, public_ip_addresse=None):
        self.public_ip_addresse = public_ip_addresse

    def validate(self):
        self.validate_required(self.public_ip_addresse, 'public_ip_addresse')
        if self.public_ip_addresse:
            for k in self.public_ip_addresse:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['PublicIpAddresse'] = []
        if self.public_ip_addresse is not None:
            for k in self.public_ip_addresse:
                result['PublicIpAddresse'].append(k.to_map() if k else None)
        else:
            result['PublicIpAddresse'] = None
        return result

    def from_map(self, map={}):
        self.public_ip_addresse = []
        if map.get('PublicIpAddresse') is not None:
            for k in map.get('PublicIpAddresse'):
                temp_model = DescribeBandwidthPackagesResponseBandwidthPackagesBandwidthPackagePublicIpAddressesPublicIpAddresse()
                temp_model = temp_model.from_map(k)
                self.public_ip_addresse.append(temp_model)
        else:
            self.public_ip_addresse = None
        return self


class DescribeBandwidthPackagesResponseBandwidthPackagesBandwidthPackage(TeaModel):
    def __init__(self, bandwidth_package_id=None, region_id=None, name=None, description=None, zone_id=None,
                 nat_gateway_id=None, bandwidth=None, instance_charge_type=None, internet_charge_type=None, business_status=None,
                 ip_count=None, isp=None, creation_time=None, status=None, public_ip_addresses=None):
        self.bandwidth_package_id = bandwidth_package_id
        self.region_id = region_id
        self.name = name
        self.description = description
        self.zone_id = zone_id
        self.nat_gateway_id = nat_gateway_id
        self.bandwidth = bandwidth
        self.instance_charge_type = instance_charge_type
        self.internet_charge_type = internet_charge_type
        self.business_status = business_status
        self.ip_count = ip_count
        self.isp = isp
        self.creation_time = creation_time
        self.status = status
        self.public_ip_addresses = public_ip_addresses

    def validate(self):
        self.validate_required(self.bandwidth_package_id, 'bandwidth_package_id')
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.name, 'name')
        self.validate_required(self.description, 'description')
        self.validate_required(self.zone_id, 'zone_id')
        self.validate_required(self.nat_gateway_id, 'nat_gateway_id')
        self.validate_required(self.bandwidth, 'bandwidth')
        self.validate_required(self.instance_charge_type, 'instance_charge_type')
        self.validate_required(self.internet_charge_type, 'internet_charge_type')
        self.validate_required(self.business_status, 'business_status')
        self.validate_required(self.ip_count, 'ip_count')
        self.validate_required(self.isp, 'isp')
        self.validate_required(self.creation_time, 'creation_time')
        self.validate_required(self.status, 'status')
        self.validate_required(self.public_ip_addresses, 'public_ip_addresses')
        if self.public_ip_addresses:
            self.public_ip_addresses.validate()

    def to_map(self):
        result = {}
        result['BandwidthPackageId'] = self.bandwidth_package_id
        result['RegionId'] = self.region_id
        result['Name'] = self.name
        result['Description'] = self.description
        result['ZoneId'] = self.zone_id
        result['NatGatewayId'] = self.nat_gateway_id
        result['Bandwidth'] = self.bandwidth
        result['InstanceChargeType'] = self.instance_charge_type
        result['InternetChargeType'] = self.internet_charge_type
        result['BusinessStatus'] = self.business_status
        result['IpCount'] = self.ip_count
        result['ISP'] = self.isp
        result['CreationTime'] = self.creation_time
        result['Status'] = self.status
        if self.public_ip_addresses is not None:
            result['PublicIpAddresses'] = self.public_ip_addresses.to_map()
        else:
            result['PublicIpAddresses'] = None
        return result

    def from_map(self, map={}):
        self.bandwidth_package_id = map.get('BandwidthPackageId')
        self.region_id = map.get('RegionId')
        self.name = map.get('Name')
        self.description = map.get('Description')
        self.zone_id = map.get('ZoneId')
        self.nat_gateway_id = map.get('NatGatewayId')
        self.bandwidth = map.get('Bandwidth')
        self.instance_charge_type = map.get('InstanceChargeType')
        self.internet_charge_type = map.get('InternetChargeType')
        self.business_status = map.get('BusinessStatus')
        self.ip_count = map.get('IpCount')
        self.isp = map.get('ISP')
        self.creation_time = map.get('CreationTime')
        self.status = map.get('Status')
        if map.get('PublicIpAddresses') is not None:
            temp_model = DescribeBandwidthPackagesResponseBandwidthPackagesBandwidthPackagePublicIpAddresses()
            self.public_ip_addresses = temp_model.from_map(map['PublicIpAddresses'])
        else:
            self.public_ip_addresses = None
        return self


class DescribeBandwidthPackagesResponseBandwidthPackages(TeaModel):
    def __init__(self, bandwidth_package=None):
        self.bandwidth_package = bandwidth_package

    def validate(self):
        self.validate_required(self.bandwidth_package, 'bandwidth_package')
        if self.bandwidth_package:
            for k in self.bandwidth_package:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['BandwidthPackage'] = []
        if self.bandwidth_package is not None:
            for k in self.bandwidth_package:
                result['BandwidthPackage'].append(k.to_map() if k else None)
        else:
            result['BandwidthPackage'] = None
        return result

    def from_map(self, map={}):
        self.bandwidth_package = []
        if map.get('BandwidthPackage') is not None:
            for k in map.get('BandwidthPackage'):
                temp_model = DescribeBandwidthPackagesResponseBandwidthPackagesBandwidthPackage()
                temp_model = temp_model.from_map(k)
                self.bandwidth_package.append(temp_model)
        else:
            self.bandwidth_package = None
        return self
class DeleteNatGatewayRequest(TeaModel):
    def __init__(self, region_id=None, nat_gateway_id=None):
        self.region_id = region_id
        self.nat_gateway_id = nat_gateway_id

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.nat_gateway_id, 'nat_gateway_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['NatGatewayId'] = self.nat_gateway_id
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.nat_gateway_id = map.get('NatGatewayId')
        return self


class DeleteNatGatewayResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class DeleteForwardEntryRequest(TeaModel):
    def __init__(self, region_id=None, forward_table_id=None, forward_entry_id=None):
        self.region_id = region_id
        self.forward_table_id = forward_table_id
        self.forward_entry_id = forward_entry_id

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.forward_table_id, 'forward_table_id')
        self.validate_required(self.forward_entry_id, 'forward_entry_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['ForwardTableId'] = self.forward_table_id
        result['ForwardEntryId'] = self.forward_entry_id
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.forward_table_id = map.get('ForwardTableId')
        self.forward_entry_id = map.get('ForwardEntryId')
        return self


class DeleteForwardEntryResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class DeleteBandwidthPackageRequest(TeaModel):
    def __init__(self, region_id=None, bandwidth_package_id=None):
        self.region_id = region_id
        self.bandwidth_package_id = bandwidth_package_id

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.bandwidth_package_id, 'bandwidth_package_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['BandwidthPackageId'] = self.bandwidth_package_id
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.bandwidth_package_id = map.get('BandwidthPackageId')
        return self


class DeleteBandwidthPackageResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class CreateNatGatewayRequest(TeaModel):
    def __init__(self, region_id=None, vpc_id=None, name=None, description=None, client_token=None,
                 bandwidth_package=None):
        self.region_id = region_id
        self.vpc_id = vpc_id
        self.name = name
        self.description = description
        self.client_token = client_token
        self.bandwidth_package = bandwidth_package

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.vpc_id, 'vpc_id')
        self.validate_required(self.bandwidth_package, 'bandwidth_package')
        if self.bandwidth_package:
            for k in self.bandwidth_package:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['VpcId'] = self.vpc_id
        result['Name'] = self.name
        result['Description'] = self.description
        result['ClientToken'] = self.client_token
        result['BandwidthPackage'] = []
        if self.bandwidth_package is not None:
            for k in self.bandwidth_package:
                result['BandwidthPackage'].append(k.to_map() if k else None)
        else:
            result['BandwidthPackage'] = None
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.vpc_id = map.get('VpcId')
        self.name = map.get('Name')
        self.description = map.get('Description')
        self.client_token = map.get('ClientToken')
        self.bandwidth_package = []
        if map.get('BandwidthPackage') is not None:
            for k in map.get('BandwidthPackage'):
                temp_model = CreateNatGatewayRequestBandwidthPackage()
                temp_model = temp_model.from_map(k)
                self.bandwidth_package.append(temp_model)
        else:
            self.bandwidth_package = None
        return self


class CreateNatGatewayRequestBandwidthPackage(TeaModel):
    def __init__(self, ip_count=None, bandwidth=None, zone=None):
        self.ip_count = ip_count
        self.bandwidth = bandwidth
        self.zone = zone

    def validate(self):
        self.validate_required(self.ip_count, 'ip_count')
        self.validate_required(self.bandwidth, 'bandwidth')
        self.validate_required(self.zone, 'zone')

    def to_map(self):
        result = {}
        result['IpCount'] = self.ip_count
        result['Bandwidth'] = self.bandwidth
        result['Zone'] = self.zone
        return result

    def from_map(self, map={}):
        self.ip_count = map.get('IpCount')
        self.bandwidth = map.get('Bandwidth')
        self.zone = map.get('Zone')
        return self
class CreateNatGatewayResponse(TeaModel):
    def __init__(self, request_id=None, nat_gateway_id=None, forward_table_ids=None, bandwidth_package_ids=None):
        self.request_id = request_id
        self.nat_gateway_id = nat_gateway_id
        self.forward_table_ids = forward_table_ids
        self.bandwidth_package_ids = bandwidth_package_ids

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.nat_gateway_id, 'nat_gateway_id')
        self.validate_required(self.forward_table_ids, 'forward_table_ids')
        if self.forward_table_ids:
            self.forward_table_ids.validate()
        self.validate_required(self.bandwidth_package_ids, 'bandwidth_package_ids')
        if self.bandwidth_package_ids:
            self.bandwidth_package_ids.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['NatGatewayId'] = self.nat_gateway_id
        if self.forward_table_ids is not None:
            result['ForwardTableIds'] = self.forward_table_ids.to_map()
        else:
            result['ForwardTableIds'] = None
        if self.bandwidth_package_ids is not None:
            result['BandwidthPackageIds'] = self.bandwidth_package_ids.to_map()
        else:
            result['BandwidthPackageIds'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.nat_gateway_id = map.get('NatGatewayId')
        if map.get('ForwardTableIds') is not None:
            temp_model = CreateNatGatewayResponseForwardTableIds()
            self.forward_table_ids = temp_model.from_map(map['ForwardTableIds'])
        else:
            self.forward_table_ids = None
        if map.get('BandwidthPackageIds') is not None:
            temp_model = CreateNatGatewayResponseBandwidthPackageIds()
            self.bandwidth_package_ids = temp_model.from_map(map['BandwidthPackageIds'])
        else:
            self.bandwidth_package_ids = None
        return self


class CreateNatGatewayResponseForwardTableIds(TeaModel):
    def __init__(self, forward_table_id=None):
        self.forward_table_id = forward_table_id

    def validate(self):
        self.validate_required(self.forward_table_id, 'forward_table_id')

    def to_map(self):
        result = {}
        result['ForwardTableId'] = []
        if self.forward_table_id is not None:
            for k in self.forward_table_id:
                result['ForwardTableId'].append(k)
        else:
            result['ForwardTableId'] = None
        return result

    def from_map(self, map={}):
        self.forward_table_id = []
        if map.get('ForwardTableId') is not None:
            for k in map.get('ForwardTableId'):
                self.forward_table_id.append(k)
        else:
            self.forward_table_id = None
        return self


class CreateNatGatewayResponseBandwidthPackageIds(TeaModel):
    def __init__(self, bandwidth_package_id=None):
        self.bandwidth_package_id = bandwidth_package_id

    def validate(self):
        self.validate_required(self.bandwidth_package_id, 'bandwidth_package_id')

    def to_map(self):
        result = {}
        result['BandwidthPackageId'] = []
        if self.bandwidth_package_id is not None:
            for k in self.bandwidth_package_id:
                result['BandwidthPackageId'].append(k)
        else:
            result['BandwidthPackageId'] = None
        return result

    def from_map(self, map={}):
        self.bandwidth_package_id = []
        if map.get('BandwidthPackageId') is not None:
            for k in map.get('BandwidthPackageId'):
                self.bandwidth_package_id.append(k)
        else:
            self.bandwidth_package_id = None
        return self
class CreateForwardEntryRequest(TeaModel):
    def __init__(self, region_id=None, forward_table_id=None, external_ip=None, external_port=None,
                 internal_ip=None, internal_port=None, ip_protocol=None):
        self.region_id = region_id
        self.forward_table_id = forward_table_id
        self.external_ip = external_ip
        self.external_port = external_port
        self.internal_ip = internal_ip
        self.internal_port = internal_port
        self.ip_protocol = ip_protocol

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.forward_table_id, 'forward_table_id')
        self.validate_required(self.external_ip, 'external_ip')
        self.validate_required(self.external_port, 'external_port')
        self.validate_required(self.internal_ip, 'internal_ip')
        self.validate_required(self.internal_port, 'internal_port')
        self.validate_required(self.ip_protocol, 'ip_protocol')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['ForwardTableId'] = self.forward_table_id
        result['ExternalIp'] = self.external_ip
        result['ExternalPort'] = self.external_port
        result['InternalIp'] = self.internal_ip
        result['InternalPort'] = self.internal_port
        result['IpProtocol'] = self.ip_protocol
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.forward_table_id = map.get('ForwardTableId')
        self.external_ip = map.get('ExternalIp')
        self.external_port = map.get('ExternalPort')
        self.internal_ip = map.get('InternalIp')
        self.internal_port = map.get('InternalPort')
        self.ip_protocol = map.get('IpProtocol')
        return self


class CreateForwardEntryResponse(TeaModel):
    def __init__(self, request_id=None, forward_entry_id=None):
        self.request_id = request_id
        self.forward_entry_id = forward_entry_id

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.forward_entry_id, 'forward_entry_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['ForwardEntryId'] = self.forward_entry_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.forward_entry_id = map.get('ForwardEntryId')
        return self


class AddBandwidthPackageIpsRequest(TeaModel):
    def __init__(self, region_id=None, bandwidth_package_id=None, ip_count=None, client_token=None):
        self.region_id = region_id
        self.bandwidth_package_id = bandwidth_package_id
        self.ip_count = ip_count
        self.client_token = client_token

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.bandwidth_package_id, 'bandwidth_package_id')
        self.validate_required(self.ip_count, 'ip_count')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['BandwidthPackageId'] = self.bandwidth_package_id
        result['IpCount'] = self.ip_count
        result['ClientToken'] = self.client_token
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.bandwidth_package_id = map.get('BandwidthPackageId')
        self.ip_count = map.get('IpCount')
        self.client_token = map.get('ClientToken')
        return self


class AddBandwidthPackageIpsResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class EipFillProductRequest(TeaModel):
    def __init__(self, data=None, client_token=None, user_cidr=None):
        self.data = data
        self.client_token = client_token
        self.user_cidr = user_cidr

    def validate(self):
        self.validate_required(self.data, 'data')

    def to_map(self):
        result = {}
        result['data'] = self.data
        result['ClientToken'] = self.client_token
        result['UserCidr'] = self.user_cidr
        return result

    def from_map(self, map={}):
        self.data = map.get('data')
        self.client_token = map.get('ClientToken')
        self.user_cidr = map.get('UserCidr')
        return self


class EipFillProductResponse(TeaModel):
    def __init__(self, request_id=None, data=None, code=None, success=None, message=None):
        self.request_id = request_id
        self.data = data
        self.code = code
        self.success = success
        self.message = message

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.data, 'data')
        self.validate_required(self.code, 'code')
        self.validate_required(self.success, 'success')
        self.validate_required(self.message, 'message')

    def to_map(self):
        result = {}
        result['requestId'] = self.request_id
        result['data'] = self.data
        result['code'] = self.code
        result['success'] = self.success
        result['message'] = self.message
        return result

    def from_map(self, map={}):
        self.request_id = map.get('requestId')
        self.data = map.get('data')
        self.code = map.get('code')
        self.success = map.get('success')
        self.message = map.get('message')
        return self


class EipNotifyPaidRequest(TeaModel):
    def __init__(self, data=None, client_token=None, user_cidr=None):
        self.data = data
        self.client_token = client_token
        self.user_cidr = user_cidr

    def validate(self):
        self.validate_required(self.data, 'data')

    def to_map(self):
        result = {}
        result['data'] = self.data
        result['ClientToken'] = self.client_token
        result['UserCidr'] = self.user_cidr
        return result

    def from_map(self, map={}):
        self.data = map.get('data')
        self.client_token = map.get('ClientToken')
        self.user_cidr = map.get('UserCidr')
        return self


class EipNotifyPaidResponse(TeaModel):
    def __init__(self, request_id=None, data=None, code=None, message=None, success=None):
        self.request_id = request_id
        self.data = data
        self.code = code
        self.message = message
        self.success = success

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.data, 'data')
        self.validate_required(self.code, 'code')
        self.validate_required(self.message, 'message')
        self.validate_required(self.success, 'success')

    def to_map(self):
        result = {}
        result['requestId'] = self.request_id
        result['data'] = self.data
        result['code'] = self.code
        result['message'] = self.message
        result['success'] = self.success
        return result

    def from_map(self, map={}):
        self.request_id = map.get('requestId')
        self.data = map.get('data')
        self.code = map.get('code')
        self.message = map.get('message')
        self.success = map.get('success')
        return self


class EipFillParamsRequest(TeaModel):
    def __init__(self, data=None, client_token=None, user_cidr=None):
        self.data = data
        self.client_token = client_token
        self.user_cidr = user_cidr

    def validate(self):
        self.validate_required(self.data, 'data')

    def to_map(self):
        result = {}
        result['data'] = self.data
        result['ClientToken'] = self.client_token
        result['UserCidr'] = self.user_cidr
        return result

    def from_map(self, map={}):
        self.data = map.get('data')
        self.client_token = map.get('ClientToken')
        self.user_cidr = map.get('UserCidr')
        return self


class EipFillParamsResponse(TeaModel):
    def __init__(self, request_id=None, data=None, code=None, success=None, message=None):
        self.request_id = request_id
        self.data = data
        self.code = code
        self.success = success
        self.message = message

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.data, 'data')
        self.validate_required(self.code, 'code')
        self.validate_required(self.success, 'success')
        self.validate_required(self.message, 'message')

    def to_map(self):
        result = {}
        result['requestId'] = self.request_id
        result['data'] = self.data
        result['code'] = self.code
        result['success'] = self.success
        result['message'] = self.message
        return result

    def from_map(self, map={}):
        self.request_id = map.get('requestId')
        self.data = map.get('data')
        self.code = map.get('code')
        self.success = map.get('success')
        self.message = map.get('message')
        return self


class ModifyAutoSnapshotPolicyExRequest(TeaModel):
    def __init__(self, region_id=None, auto_snapshot_policy_id=None, auto_snapshot_policy_name=None,
                 time_points=None, repeat_weekdays=None, retention_days=None, enable_cross_region_copy=None,
                 target_copy_regions=None, copied_snapshots_retention_days=None):
        self.region_id = region_id
        self.auto_snapshot_policy_id = auto_snapshot_policy_id
        self.auto_snapshot_policy_name = auto_snapshot_policy_name
        self.time_points = time_points
        self.repeat_weekdays = repeat_weekdays
        self.retention_days = retention_days
        self.enable_cross_region_copy = enable_cross_region_copy
        self.target_copy_regions = target_copy_regions
        self.copied_snapshots_retention_days = copied_snapshots_retention_days

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.auto_snapshot_policy_id, 'auto_snapshot_policy_id')

    def to_map(self):
        result = {}
        result['regionId'] = self.region_id
        result['autoSnapshotPolicyId'] = self.auto_snapshot_policy_id
        result['autoSnapshotPolicyName'] = self.auto_snapshot_policy_name
        result['timePoints'] = self.time_points
        result['repeatWeekdays'] = self.repeat_weekdays
        result['retentionDays'] = self.retention_days
        result['EnableCrossRegionCopy'] = self.enable_cross_region_copy
        result['TargetCopyRegions'] = self.target_copy_regions
        result['CopiedSnapshotsRetentionDays'] = self.copied_snapshots_retention_days
        return result

    def from_map(self, map={}):
        self.region_id = map.get('regionId')
        self.auto_snapshot_policy_id = map.get('autoSnapshotPolicyId')
        self.auto_snapshot_policy_name = map.get('autoSnapshotPolicyName')
        self.time_points = map.get('timePoints')
        self.repeat_weekdays = map.get('repeatWeekdays')
        self.retention_days = map.get('retentionDays')
        self.enable_cross_region_copy = map.get('EnableCrossRegionCopy')
        self.target_copy_regions = map.get('TargetCopyRegions')
        self.copied_snapshots_retention_days = map.get('CopiedSnapshotsRetentionDays')
        return self


class ModifyAutoSnapshotPolicyExResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class DescribeAutoSnapshotPolicyExRequest(TeaModel):
    def __init__(self, region_id=None, auto_snapshot_policy_id=None, page_number=None, page_size=None, tag=None):
        self.region_id = region_id
        self.auto_snapshot_policy_id = auto_snapshot_policy_id
        self.page_number = page_number
        self.page_size = page_size
        self.tag = tag

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['AutoSnapshotPolicyId'] = self.auto_snapshot_policy_id
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        else:
            result['Tag'] = None
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.auto_snapshot_policy_id = map.get('AutoSnapshotPolicyId')
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        self.tag = []
        if map.get('Tag') is not None:
            for k in map.get('Tag'):
                temp_model = DescribeAutoSnapshotPolicyExRequestTag()
                temp_model = temp_model.from_map(k)
                self.tag.append(temp_model)
        else:
            self.tag = None
        return self


class DescribeAutoSnapshotPolicyExRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key
        self.value = value

    def validate(self):
        self.validate_required(self.key, 'key')
        self.validate_required(self.value, 'value')

    def to_map(self):
        result = {}
        result['Key'] = self.key
        result['Value'] = self.value
        return result

    def from_map(self, map={}):
        self.key = map.get('Key')
        self.value = map.get('Value')
        return self
class DescribeAutoSnapshotPolicyExResponse(TeaModel):
    def __init__(self, request_id=None, total_count=None, page_number=None, page_size=None,
                 auto_snapshot_policies=None):
        self.request_id = request_id
        self.total_count = total_count
        self.page_number = page_number
        self.page_size = page_size
        self.auto_snapshot_policies = auto_snapshot_policies

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.page_number, 'page_number')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.auto_snapshot_policies, 'auto_snapshot_policies')
        if self.auto_snapshot_policies:
            self.auto_snapshot_policies.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['TotalCount'] = self.total_count
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        if self.auto_snapshot_policies is not None:
            result['AutoSnapshotPolicies'] = self.auto_snapshot_policies.to_map()
        else:
            result['AutoSnapshotPolicies'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.total_count = map.get('TotalCount')
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        if map.get('AutoSnapshotPolicies') is not None:
            temp_model = DescribeAutoSnapshotPolicyExResponseAutoSnapshotPolicies()
            self.auto_snapshot_policies = temp_model.from_map(map['AutoSnapshotPolicies'])
        else:
            self.auto_snapshot_policies = None
        return self


class DescribeAutoSnapshotPolicyExResponseAutoSnapshotPoliciesAutoSnapshotPolicyTagsTag(TeaModel):
    def __init__(self, tag_key=None, tag_value=None):
        self.tag_key = tag_key
        self.tag_value = tag_value

    def validate(self):
        self.validate_required(self.tag_key, 'tag_key')
        self.validate_required(self.tag_value, 'tag_value')

    def to_map(self):
        result = {}
        result['TagKey'] = self.tag_key
        result['TagValue'] = self.tag_value
        return result

    def from_map(self, map={}):
        self.tag_key = map.get('TagKey')
        self.tag_value = map.get('TagValue')
        return self


class DescribeAutoSnapshotPolicyExResponseAutoSnapshotPoliciesAutoSnapshotPolicyTags(TeaModel):
    def __init__(self, tag=None):
        self.tag = tag

    def validate(self):
        self.validate_required(self.tag, 'tag')
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        else:
            result['Tag'] = None
        return result

    def from_map(self, map={}):
        self.tag = []
        if map.get('Tag') is not None:
            for k in map.get('Tag'):
                temp_model = DescribeAutoSnapshotPolicyExResponseAutoSnapshotPoliciesAutoSnapshotPolicyTagsTag()
                temp_model = temp_model.from_map(k)
                self.tag.append(temp_model)
        else:
            self.tag = None
        return self


class DescribeAutoSnapshotPolicyExResponseAutoSnapshotPoliciesAutoSnapshotPolicy(TeaModel):
    def __init__(self, auto_snapshot_policy_id=None, region_id=None, auto_snapshot_policy_name=None,
                 time_points=None, repeat_weekdays=None, retention_days=None, disk_nums=None, volume_nums=None,
                 creation_time=None, status=None, enable_cross_region_copy=None, target_copy_regions=None,
                 copied_snapshots_retention_days=None, tags=None):
        self.auto_snapshot_policy_id = auto_snapshot_policy_id
        self.region_id = region_id
        self.auto_snapshot_policy_name = auto_snapshot_policy_name
        self.time_points = time_points
        self.repeat_weekdays = repeat_weekdays
        self.retention_days = retention_days
        self.disk_nums = disk_nums
        self.volume_nums = volume_nums
        self.creation_time = creation_time
        self.status = status
        self.enable_cross_region_copy = enable_cross_region_copy
        self.target_copy_regions = target_copy_regions
        self.copied_snapshots_retention_days = copied_snapshots_retention_days
        self.tags = tags

    def validate(self):
        self.validate_required(self.auto_snapshot_policy_id, 'auto_snapshot_policy_id')
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.auto_snapshot_policy_name, 'auto_snapshot_policy_name')
        self.validate_required(self.time_points, 'time_points')
        self.validate_required(self.repeat_weekdays, 'repeat_weekdays')
        self.validate_required(self.retention_days, 'retention_days')
        self.validate_required(self.disk_nums, 'disk_nums')
        self.validate_required(self.volume_nums, 'volume_nums')
        self.validate_required(self.creation_time, 'creation_time')
        self.validate_required(self.status, 'status')
        self.validate_required(self.enable_cross_region_copy, 'enable_cross_region_copy')
        self.validate_required(self.target_copy_regions, 'target_copy_regions')
        self.validate_required(self.copied_snapshots_retention_days, 'copied_snapshots_retention_days')
        self.validate_required(self.tags, 'tags')
        if self.tags:
            self.tags.validate()

    def to_map(self):
        result = {}
        result['AutoSnapshotPolicyId'] = self.auto_snapshot_policy_id
        result['RegionId'] = self.region_id
        result['AutoSnapshotPolicyName'] = self.auto_snapshot_policy_name
        result['TimePoints'] = self.time_points
        result['RepeatWeekdays'] = self.repeat_weekdays
        result['RetentionDays'] = self.retention_days
        result['DiskNums'] = self.disk_nums
        result['VolumeNums'] = self.volume_nums
        result['CreationTime'] = self.creation_time
        result['Status'] = self.status
        result['EnableCrossRegionCopy'] = self.enable_cross_region_copy
        result['TargetCopyRegions'] = self.target_copy_regions
        result['CopiedSnapshotsRetentionDays'] = self.copied_snapshots_retention_days
        if self.tags is not None:
            result['Tags'] = self.tags.to_map()
        else:
            result['Tags'] = None
        return result

    def from_map(self, map={}):
        self.auto_snapshot_policy_id = map.get('AutoSnapshotPolicyId')
        self.region_id = map.get('RegionId')
        self.auto_snapshot_policy_name = map.get('AutoSnapshotPolicyName')
        self.time_points = map.get('TimePoints')
        self.repeat_weekdays = map.get('RepeatWeekdays')
        self.retention_days = map.get('RetentionDays')
        self.disk_nums = map.get('DiskNums')
        self.volume_nums = map.get('VolumeNums')
        self.creation_time = map.get('CreationTime')
        self.status = map.get('Status')
        self.enable_cross_region_copy = map.get('EnableCrossRegionCopy')
        self.target_copy_regions = map.get('TargetCopyRegions')
        self.copied_snapshots_retention_days = map.get('CopiedSnapshotsRetentionDays')
        if map.get('Tags') is not None:
            temp_model = DescribeAutoSnapshotPolicyExResponseAutoSnapshotPoliciesAutoSnapshotPolicyTags()
            self.tags = temp_model.from_map(map['Tags'])
        else:
            self.tags = None
        return self


class DescribeAutoSnapshotPolicyExResponseAutoSnapshotPolicies(TeaModel):
    def __init__(self, auto_snapshot_policy=None):
        self.auto_snapshot_policy = auto_snapshot_policy

    def validate(self):
        self.validate_required(self.auto_snapshot_policy, 'auto_snapshot_policy')
        if self.auto_snapshot_policy:
            for k in self.auto_snapshot_policy:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['AutoSnapshotPolicy'] = []
        if self.auto_snapshot_policy is not None:
            for k in self.auto_snapshot_policy:
                result['AutoSnapshotPolicy'].append(k.to_map() if k else None)
        else:
            result['AutoSnapshotPolicy'] = None
        return result

    def from_map(self, map={}):
        self.auto_snapshot_policy = []
        if map.get('AutoSnapshotPolicy') is not None:
            for k in map.get('AutoSnapshotPolicy'):
                temp_model = DescribeAutoSnapshotPolicyExResponseAutoSnapshotPoliciesAutoSnapshotPolicy()
                temp_model = temp_model.from_map(k)
                self.auto_snapshot_policy.append(temp_model)
        else:
            self.auto_snapshot_policy = None
        return self
class DeleteAutoSnapshotPolicyRequest(TeaModel):
    def __init__(self, region_id=None, auto_snapshot_policy_id=None):
        self.region_id = region_id
        self.auto_snapshot_policy_id = auto_snapshot_policy_id

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.auto_snapshot_policy_id, 'auto_snapshot_policy_id')

    def to_map(self):
        result = {}
        result['regionId'] = self.region_id
        result['autoSnapshotPolicyId'] = self.auto_snapshot_policy_id
        return result

    def from_map(self, map={}):
        self.region_id = map.get('regionId')
        self.auto_snapshot_policy_id = map.get('autoSnapshotPolicyId')
        return self


class DeleteAutoSnapshotPolicyResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class CreateAutoSnapshotPolicyRequest(TeaModel):
    def __init__(self, region_id=None, auto_snapshot_policy_name=None, time_points=None, repeat_weekdays=None,
                 retention_days=None, enable_cross_region_copy=None, target_copy_regions=None,
                 copied_snapshots_retention_days=None, tag=None):
        self.region_id = region_id
        self.auto_snapshot_policy_name = auto_snapshot_policy_name
        self.time_points = time_points
        self.repeat_weekdays = repeat_weekdays
        self.retention_days = retention_days
        self.enable_cross_region_copy = enable_cross_region_copy
        self.target_copy_regions = target_copy_regions
        self.copied_snapshots_retention_days = copied_snapshots_retention_days
        self.tag = tag

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.time_points, 'time_points')
        self.validate_required(self.repeat_weekdays, 'repeat_weekdays')
        self.validate_required(self.retention_days, 'retention_days')
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['regionId'] = self.region_id
        result['autoSnapshotPolicyName'] = self.auto_snapshot_policy_name
        result['timePoints'] = self.time_points
        result['repeatWeekdays'] = self.repeat_weekdays
        result['retentionDays'] = self.retention_days
        result['EnableCrossRegionCopy'] = self.enable_cross_region_copy
        result['TargetCopyRegions'] = self.target_copy_regions
        result['CopiedSnapshotsRetentionDays'] = self.copied_snapshots_retention_days
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        else:
            result['Tag'] = None
        return result

    def from_map(self, map={}):
        self.region_id = map.get('regionId')
        self.auto_snapshot_policy_name = map.get('autoSnapshotPolicyName')
        self.time_points = map.get('timePoints')
        self.repeat_weekdays = map.get('repeatWeekdays')
        self.retention_days = map.get('retentionDays')
        self.enable_cross_region_copy = map.get('EnableCrossRegionCopy')
        self.target_copy_regions = map.get('TargetCopyRegions')
        self.copied_snapshots_retention_days = map.get('CopiedSnapshotsRetentionDays')
        self.tag = []
        if map.get('Tag') is not None:
            for k in map.get('Tag'):
                temp_model = CreateAutoSnapshotPolicyRequestTag()
                temp_model = temp_model.from_map(k)
                self.tag.append(temp_model)
        else:
            self.tag = None
        return self


class CreateAutoSnapshotPolicyRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key
        self.value = value

    def validate(self):
        self.validate_required(self.key, 'key')
        self.validate_required(self.value, 'value')

    def to_map(self):
        result = {}
        result['Key'] = self.key
        result['Value'] = self.value
        return result

    def from_map(self, map={}):
        self.key = map.get('Key')
        self.value = map.get('Value')
        return self
class CreateAutoSnapshotPolicyResponse(TeaModel):
    def __init__(self, request_id=None, auto_snapshot_policy_id=None):
        self.request_id = request_id
        self.auto_snapshot_policy_id = auto_snapshot_policy_id

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.auto_snapshot_policy_id, 'auto_snapshot_policy_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['AutoSnapshotPolicyId'] = self.auto_snapshot_policy_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.auto_snapshot_policy_id = map.get('AutoSnapshotPolicyId')
        return self


class CancelAutoSnapshotPolicyRequest(TeaModel):
    def __init__(self, region_id=None, disk_ids=None):
        self.region_id = region_id
        self.disk_ids = disk_ids

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.disk_ids, 'disk_ids')

    def to_map(self):
        result = {}
        result['regionId'] = self.region_id
        result['diskIds'] = self.disk_ids
        return result

    def from_map(self, map={}):
        self.region_id = map.get('regionId')
        self.disk_ids = map.get('diskIds')
        return self


class CancelAutoSnapshotPolicyResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class ApplyAutoSnapshotPolicyRequest(TeaModel):
    def __init__(self, region_id=None, auto_snapshot_policy_id=None, disk_ids=None):
        self.region_id = region_id
        self.auto_snapshot_policy_id = auto_snapshot_policy_id
        self.disk_ids = disk_ids

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.auto_snapshot_policy_id, 'auto_snapshot_policy_id')
        self.validate_required(self.disk_ids, 'disk_ids')

    def to_map(self):
        result = {}
        result['regionId'] = self.region_id
        result['autoSnapshotPolicyId'] = self.auto_snapshot_policy_id
        result['diskIds'] = self.disk_ids
        return result

    def from_map(self, map={}):
        self.region_id = map.get('regionId')
        self.auto_snapshot_policy_id = map.get('autoSnapshotPolicyId')
        self.disk_ids = map.get('diskIds')
        return self


class ApplyAutoSnapshotPolicyResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class DescribeImageSupportInstanceTypesRequest(TeaModel):
    def __init__(self, region_id=None, image_id=None, action_type=None, filter=None):
        self.region_id = region_id
        self.image_id = image_id
        self.action_type = action_type
        self.filter = filter

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        if self.filter:
            for k in self.filter:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['ImageId'] = self.image_id
        result['ActionType'] = self.action_type
        result['Filter'] = []
        if self.filter is not None:
            for k in self.filter:
                result['Filter'].append(k.to_map() if k else None)
        else:
            result['Filter'] = None
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.image_id = map.get('ImageId')
        self.action_type = map.get('ActionType')
        self.filter = []
        if map.get('Filter') is not None:
            for k in map.get('Filter'):
                temp_model = DescribeImageSupportInstanceTypesRequestFilter()
                temp_model = temp_model.from_map(k)
                self.filter.append(temp_model)
        else:
            self.filter = None
        return self


class DescribeImageSupportInstanceTypesRequestFilter(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key
        self.value = value

    def validate(self):
        self.validate_required(self.key, 'key')
        self.validate_required(self.value, 'value')

    def to_map(self):
        result = {}
        result['Key'] = self.key
        result['Value'] = self.value
        return result

    def from_map(self, map={}):
        self.key = map.get('Key')
        self.value = map.get('Value')
        return self
class DescribeImageSupportInstanceTypesResponse(TeaModel):
    def __init__(self, request_id=None, region_id=None, image_id=None, instance_types=None):
        self.request_id = request_id
        self.region_id = region_id
        self.image_id = image_id
        self.instance_types = instance_types

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.image_id, 'image_id')
        self.validate_required(self.instance_types, 'instance_types')
        if self.instance_types:
            self.instance_types.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['RegionId'] = self.region_id
        result['ImageId'] = self.image_id
        if self.instance_types is not None:
            result['InstanceTypes'] = self.instance_types.to_map()
        else:
            result['InstanceTypes'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.region_id = map.get('RegionId')
        self.image_id = map.get('ImageId')
        if map.get('InstanceTypes') is not None:
            temp_model = DescribeImageSupportInstanceTypesResponseInstanceTypes()
            self.instance_types = temp_model.from_map(map['InstanceTypes'])
        else:
            self.instance_types = None
        return self


class DescribeImageSupportInstanceTypesResponseInstanceTypesInstanceType(TeaModel):
    def __init__(self, instance_type_id=None, cpu_core_count=None, memory_size=None, instance_type_family=None):
        self.instance_type_id = instance_type_id
        self.cpu_core_count = cpu_core_count
        self.memory_size = memory_size
        self.instance_type_family = instance_type_family

    def validate(self):
        self.validate_required(self.instance_type_id, 'instance_type_id')
        self.validate_required(self.cpu_core_count, 'cpu_core_count')
        self.validate_required(self.memory_size, 'memory_size')
        self.validate_required(self.instance_type_family, 'instance_type_family')

    def to_map(self):
        result = {}
        result['InstanceTypeId'] = self.instance_type_id
        result['CpuCoreCount'] = self.cpu_core_count
        result['MemorySize'] = self.memory_size
        result['InstanceTypeFamily'] = self.instance_type_family
        return result

    def from_map(self, map={}):
        self.instance_type_id = map.get('InstanceTypeId')
        self.cpu_core_count = map.get('CpuCoreCount')
        self.memory_size = map.get('MemorySize')
        self.instance_type_family = map.get('InstanceTypeFamily')
        return self


class DescribeImageSupportInstanceTypesResponseInstanceTypes(TeaModel):
    def __init__(self, instance_type=None):
        self.instance_type = instance_type

    def validate(self):
        self.validate_required(self.instance_type, 'instance_type')
        if self.instance_type:
            for k in self.instance_type:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['InstanceType'] = []
        if self.instance_type is not None:
            for k in self.instance_type:
                result['InstanceType'].append(k.to_map() if k else None)
        else:
            result['InstanceType'] = None
        return result

    def from_map(self, map={}):
        self.instance_type = []
        if map.get('InstanceType') is not None:
            for k in map.get('InstanceType'):
                temp_model = DescribeImageSupportInstanceTypesResponseInstanceTypesInstanceType()
                temp_model = temp_model.from_map(k)
                self.instance_type.append(temp_model)
        else:
            self.instance_type = None
        return self
class TerminateVirtualBorderRouterRequest(TeaModel):
    def __init__(self, region_id=None, vbr_id=None, client_token=None, user_cidr=None):
        self.region_id = region_id
        self.vbr_id = vbr_id
        self.client_token = client_token
        self.user_cidr = user_cidr

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.vbr_id, 'vbr_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['VbrId'] = self.vbr_id
        result['ClientToken'] = self.client_token
        result['UserCidr'] = self.user_cidr
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.vbr_id = map.get('VbrId')
        self.client_token = map.get('ClientToken')
        self.user_cidr = map.get('UserCidr')
        return self


class TerminateVirtualBorderRouterResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class TerminatePhysicalConnectionRequest(TeaModel):
    def __init__(self, region_id=None, physical_connection_id=None, client_token=None, user_cidr=None):
        self.region_id = region_id
        self.physical_connection_id = physical_connection_id
        self.client_token = client_token
        self.user_cidr = user_cidr

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.physical_connection_id, 'physical_connection_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['PhysicalConnectionId'] = self.physical_connection_id
        result['ClientToken'] = self.client_token
        result['UserCidr'] = self.user_cidr
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.physical_connection_id = map.get('PhysicalConnectionId')
        self.client_token = map.get('ClientToken')
        self.user_cidr = map.get('UserCidr')
        return self


class TerminatePhysicalConnectionResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class RecoverVirtualBorderRouterRequest(TeaModel):
    def __init__(self, region_id=None, vbr_id=None, client_token=None, user_cidr=None):
        self.region_id = region_id
        self.vbr_id = vbr_id
        self.client_token = client_token
        self.user_cidr = user_cidr

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.vbr_id, 'vbr_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['VbrId'] = self.vbr_id
        result['ClientToken'] = self.client_token
        result['UserCidr'] = self.user_cidr
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.vbr_id = map.get('VbrId')
        self.client_token = map.get('ClientToken')
        self.user_cidr = map.get('UserCidr')
        return self


class RecoverVirtualBorderRouterResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class ModifyVirtualBorderRouterAttributeRequest(TeaModel):
    def __init__(self, region_id=None, vbr_id=None, vlan_id=None, circuit_code=None, local_gateway_ip=None,
                 peer_gateway_ip=None, peering_subnet_mask=None, description=None, name=None, client_token=None, user_cidr=None):
        self.region_id = region_id
        self.vbr_id = vbr_id
        self.vlan_id = vlan_id
        self.circuit_code = circuit_code
        self.local_gateway_ip = local_gateway_ip
        self.peer_gateway_ip = peer_gateway_ip
        self.peering_subnet_mask = peering_subnet_mask
        self.description = description
        self.name = name
        self.client_token = client_token
        self.user_cidr = user_cidr

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.vbr_id, 'vbr_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['VbrId'] = self.vbr_id
        result['VlanId'] = self.vlan_id
        result['CircuitCode'] = self.circuit_code
        result['LocalGatewayIp'] = self.local_gateway_ip
        result['PeerGatewayIp'] = self.peer_gateway_ip
        result['PeeringSubnetMask'] = self.peering_subnet_mask
        result['Description'] = self.description
        result['Name'] = self.name
        result['ClientToken'] = self.client_token
        result['UserCidr'] = self.user_cidr
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.vbr_id = map.get('VbrId')
        self.vlan_id = map.get('VlanId')
        self.circuit_code = map.get('CircuitCode')
        self.local_gateway_ip = map.get('LocalGatewayIp')
        self.peer_gateway_ip = map.get('PeerGatewayIp')
        self.peering_subnet_mask = map.get('PeeringSubnetMask')
        self.description = map.get('Description')
        self.name = map.get('Name')
        self.client_token = map.get('ClientToken')
        self.user_cidr = map.get('UserCidr')
        return self


class ModifyVirtualBorderRouterAttributeResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class ModifyPhysicalConnectionAttributeRequest(TeaModel):
    def __init__(self, region_id=None, physical_connection_id=None, line_operator=None, bandwidth=None,
                 peer_location=None, port_type=None, redundant_physical_connection_id=None, description=None, name=None,
                 client_token=None, user_cidr=None, circuit_code=None):
        self.region_id = region_id
        self.physical_connection_id = physical_connection_id
        self.line_operator = line_operator
        self.bandwidth = bandwidth
        self.peer_location = peer_location
        self.port_type = port_type
        self.redundant_physical_connection_id = redundant_physical_connection_id
        self.description = description
        self.name = name
        self.client_token = client_token
        self.user_cidr = user_cidr
        self.circuit_code = circuit_code

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.physical_connection_id, 'physical_connection_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['PhysicalConnectionId'] = self.physical_connection_id
        result['LineOperator'] = self.line_operator
        result['bandwidth'] = self.bandwidth
        result['PeerLocation'] = self.peer_location
        result['PortType'] = self.port_type
        result['RedundantPhysicalConnectionId'] = self.redundant_physical_connection_id
        result['Description'] = self.description
        result['Name'] = self.name
        result['ClientToken'] = self.client_token
        result['UserCidr'] = self.user_cidr
        result['CircuitCode'] = self.circuit_code
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.physical_connection_id = map.get('PhysicalConnectionId')
        self.line_operator = map.get('LineOperator')
        self.bandwidth = map.get('bandwidth')
        self.peer_location = map.get('PeerLocation')
        self.port_type = map.get('PortType')
        self.redundant_physical_connection_id = map.get('RedundantPhysicalConnectionId')
        self.description = map.get('Description')
        self.name = map.get('Name')
        self.client_token = map.get('ClientToken')
        self.user_cidr = map.get('UserCidr')
        self.circuit_code = map.get('CircuitCode')
        return self


class ModifyPhysicalConnectionAttributeResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class EnablePhysicalConnectionRequest(TeaModel):
    def __init__(self, region_id=None, physical_connection_id=None, client_token=None, user_cidr=None):
        self.region_id = region_id
        self.physical_connection_id = physical_connection_id
        self.client_token = client_token
        self.user_cidr = user_cidr

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.physical_connection_id, 'physical_connection_id')
        self.validate_required(self.client_token, 'client_token')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['PhysicalConnectionId'] = self.physical_connection_id
        result['ClientToken'] = self.client_token
        result['UserCidr'] = self.user_cidr
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.physical_connection_id = map.get('PhysicalConnectionId')
        self.client_token = map.get('ClientToken')
        self.user_cidr = map.get('UserCidr')
        return self


class EnablePhysicalConnectionResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class DescribeVirtualBorderRoutersForPhysicalConnectionRequest(TeaModel):
    def __init__(self, filter=None, region_id=None, physical_connection_id=None, page_number=None, page_size=None):
        self.filter = filter
        self.region_id = region_id
        self.physical_connection_id = physical_connection_id
        self.page_number = page_number
        self.page_size = page_size

    def validate(self):
        if self.filter:
            for k in self.filter:
                if k:
                    k.validate()
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.physical_connection_id, 'physical_connection_id')

    def to_map(self):
        result = {}
        result['Filter'] = []
        if self.filter is not None:
            for k in self.filter:
                result['Filter'].append(k.to_map() if k else None)
        else:
            result['Filter'] = None
        result['RegionId'] = self.region_id
        result['PhysicalConnectionId'] = self.physical_connection_id
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        return result

    def from_map(self, map={}):
        self.filter = []
        if map.get('Filter') is not None:
            for k in map.get('Filter'):
                temp_model = DescribeVirtualBorderRoutersForPhysicalConnectionRequestFilter()
                temp_model = temp_model.from_map(k)
                self.filter.append(temp_model)
        else:
            self.filter = None
        self.region_id = map.get('RegionId')
        self.physical_connection_id = map.get('PhysicalConnectionId')
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        return self


class DescribeVirtualBorderRoutersForPhysicalConnectionRequestFilter(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key
        self.value = value

    def validate(self):
        self.validate_required(self.key, 'key')
        self.validate_required(self.value, 'value')

    def to_map(self):
        result = {}
        result['Key'] = self.key
        result['Value'] = []
        if self.value is not None:
            for k in self.value:
                result['Value'].append(k)
        else:
            result['Value'] = None
        return result

    def from_map(self, map={}):
        self.key = map.get('Key')
        self.value = []
        if map.get('Value') is not None:
            for k in map.get('Value'):
                self.value.append(k)
        else:
            self.value = None
        return self
class DescribeVirtualBorderRoutersForPhysicalConnectionResponse(TeaModel):
    def __init__(self, request_id=None, page_number=None, page_size=None, total_count=None,
                 virtual_border_router_for_physical_connection_set=None):
        self.request_id = request_id
        self.page_number = page_number
        self.page_size = page_size
        self.total_count = total_count
        self.virtual_border_router_for_physical_connection_set = virtual_border_router_for_physical_connection_set

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.page_number, 'page_number')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.virtual_border_router_for_physical_connection_set, 'virtual_border_router_for_physical_connection_set')
        if self.virtual_border_router_for_physical_connection_set:
            self.virtual_border_router_for_physical_connection_set.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        result['TotalCount'] = self.total_count
        if self.virtual_border_router_for_physical_connection_set is not None:
            result['VirtualBorderRouterForPhysicalConnectionSet'] = self.virtual_border_router_for_physical_connection_set.to_map()
        else:
            result['VirtualBorderRouterForPhysicalConnectionSet'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        self.total_count = map.get('TotalCount')
        if map.get('VirtualBorderRouterForPhysicalConnectionSet') is not None:
            temp_model = DescribeVirtualBorderRoutersForPhysicalConnectionResponseVirtualBorderRouterForPhysicalConnectionSet()
            self.virtual_border_router_for_physical_connection_set = temp_model.from_map(map['VirtualBorderRouterForPhysicalConnectionSet'])
        else:
            self.virtual_border_router_for_physical_connection_set = None
        return self


class DescribeVirtualBorderRoutersForPhysicalConnectionResponseVirtualBorderRouterForPhysicalConnectionSetVirtualBorderRouterForPhysicalConnectionType(TeaModel):
    def __init__(self, vbr_id=None, vbr_owner_uid=None, creation_time=None, activation_time=None,
                 termination_time=None, recovery_time=None, vlan_id=None, circuit_code=None):
        self.vbr_id = vbr_id
        self.vbr_owner_uid = vbr_owner_uid
        self.creation_time = creation_time
        self.activation_time = activation_time
        self.termination_time = termination_time
        self.recovery_time = recovery_time
        self.vlan_id = vlan_id
        self.circuit_code = circuit_code

    def validate(self):
        self.validate_required(self.vbr_id, 'vbr_id')
        self.validate_required(self.vbr_owner_uid, 'vbr_owner_uid')
        self.validate_required(self.creation_time, 'creation_time')
        self.validate_required(self.activation_time, 'activation_time')
        self.validate_required(self.termination_time, 'termination_time')
        self.validate_required(self.recovery_time, 'recovery_time')
        self.validate_required(self.vlan_id, 'vlan_id')
        self.validate_required(self.circuit_code, 'circuit_code')

    def to_map(self):
        result = {}
        result['VbrId'] = self.vbr_id
        result['VbrOwnerUid'] = self.vbr_owner_uid
        result['CreationTime'] = self.creation_time
        result['ActivationTime'] = self.activation_time
        result['TerminationTime'] = self.termination_time
        result['RecoveryTime'] = self.recovery_time
        result['VlanId'] = self.vlan_id
        result['CircuitCode'] = self.circuit_code
        return result

    def from_map(self, map={}):
        self.vbr_id = map.get('VbrId')
        self.vbr_owner_uid = map.get('VbrOwnerUid')
        self.creation_time = map.get('CreationTime')
        self.activation_time = map.get('ActivationTime')
        self.termination_time = map.get('TerminationTime')
        self.recovery_time = map.get('RecoveryTime')
        self.vlan_id = map.get('VlanId')
        self.circuit_code = map.get('CircuitCode')
        return self


class DescribeVirtualBorderRoutersForPhysicalConnectionResponseVirtualBorderRouterForPhysicalConnectionSet(TeaModel):
    def __init__(self, virtual_border_router_for_physical_connection_type=None):
        self.virtual_border_router_for_physical_connection_type = virtual_border_router_for_physical_connection_type

    def validate(self):
        self.validate_required(self.virtual_border_router_for_physical_connection_type, 'virtual_border_router_for_physical_connection_type')
        if self.virtual_border_router_for_physical_connection_type:
            for k in self.virtual_border_router_for_physical_connection_type:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['VirtualBorderRouterForPhysicalConnectionType'] = []
        if self.virtual_border_router_for_physical_connection_type is not None:
            for k in self.virtual_border_router_for_physical_connection_type:
                result['VirtualBorderRouterForPhysicalConnectionType'].append(k.to_map() if k else None)
        else:
            result['VirtualBorderRouterForPhysicalConnectionType'] = None
        return result

    def from_map(self, map={}):
        self.virtual_border_router_for_physical_connection_type = []
        if map.get('VirtualBorderRouterForPhysicalConnectionType') is not None:
            for k in map.get('VirtualBorderRouterForPhysicalConnectionType'):
                temp_model = DescribeVirtualBorderRoutersForPhysicalConnectionResponseVirtualBorderRouterForPhysicalConnectionSetVirtualBorderRouterForPhysicalConnectionType()
                temp_model = temp_model.from_map(k)
                self.virtual_border_router_for_physical_connection_type.append(temp_model)
        else:
            self.virtual_border_router_for_physical_connection_type = None
        return self
class DescribeVirtualBorderRoutersRequest(TeaModel):
    def __init__(self, region_id=None, page_number=None, page_size=None, filter=None):
        self.region_id = region_id
        self.page_number = page_number
        self.page_size = page_size
        self.filter = filter

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        if self.filter:
            for k in self.filter:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        result['Filter'] = []
        if self.filter is not None:
            for k in self.filter:
                result['Filter'].append(k.to_map() if k else None)
        else:
            result['Filter'] = None
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        self.filter = []
        if map.get('Filter') is not None:
            for k in map.get('Filter'):
                temp_model = DescribeVirtualBorderRoutersRequestFilter()
                temp_model = temp_model.from_map(k)
                self.filter.append(temp_model)
        else:
            self.filter = None
        return self


class DescribeVirtualBorderRoutersRequestFilter(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key
        self.value = value

    def validate(self):
        self.validate_required(self.key, 'key')
        self.validate_required(self.value, 'value')

    def to_map(self):
        result = {}
        result['Key'] = self.key
        result['Value'] = []
        if self.value is not None:
            for k in self.value:
                result['Value'].append(k)
        else:
            result['Value'] = None
        return result

    def from_map(self, map={}):
        self.key = map.get('Key')
        self.value = []
        if map.get('Value') is not None:
            for k in map.get('Value'):
                self.value.append(k)
        else:
            self.value = None
        return self
class DescribeVirtualBorderRoutersResponse(TeaModel):
    def __init__(self, request_id=None, page_number=None, page_size=None, total_count=None,
                 virtual_border_router_set=None):
        self.request_id = request_id
        self.page_number = page_number
        self.page_size = page_size
        self.total_count = total_count
        self.virtual_border_router_set = virtual_border_router_set

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.page_number, 'page_number')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.virtual_border_router_set, 'virtual_border_router_set')
        if self.virtual_border_router_set:
            self.virtual_border_router_set.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        result['TotalCount'] = self.total_count
        if self.virtual_border_router_set is not None:
            result['VirtualBorderRouterSet'] = self.virtual_border_router_set.to_map()
        else:
            result['VirtualBorderRouterSet'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        self.total_count = map.get('TotalCount')
        if map.get('VirtualBorderRouterSet') is not None:
            temp_model = DescribeVirtualBorderRoutersResponseVirtualBorderRouterSet()
            self.virtual_border_router_set = temp_model.from_map(map['VirtualBorderRouterSet'])
        else:
            self.virtual_border_router_set = None
        return self


class DescribeVirtualBorderRoutersResponseVirtualBorderRouterSetVirtualBorderRouterType(TeaModel):
    def __init__(self, vbr_id=None, creation_time=None, activation_time=None, termination_time=None,
                 recovery_time=None, status=None, vlan_id=None, circuit_code=None, route_table_id=None, vlan_interface_id=None,
                 local_gateway_ip=None, peer_gateway_ip=None, peering_subnet_mask=None, physical_connection_id=None,
                 physical_connection_status=None, physical_connection_business_status=None, physical_connection_owner_uid=None,
                 access_point_id=None, name=None, description=None):
        self.vbr_id = vbr_id
        self.creation_time = creation_time
        self.activation_time = activation_time
        self.termination_time = termination_time
        self.recovery_time = recovery_time
        self.status = status
        self.vlan_id = vlan_id
        self.circuit_code = circuit_code
        self.route_table_id = route_table_id
        self.vlan_interface_id = vlan_interface_id
        self.local_gateway_ip = local_gateway_ip
        self.peer_gateway_ip = peer_gateway_ip
        self.peering_subnet_mask = peering_subnet_mask
        self.physical_connection_id = physical_connection_id
        self.physical_connection_status = physical_connection_status
        self.physical_connection_business_status = physical_connection_business_status
        self.physical_connection_owner_uid = physical_connection_owner_uid
        self.access_point_id = access_point_id
        self.name = name
        self.description = description

    def validate(self):
        self.validate_required(self.vbr_id, 'vbr_id')
        self.validate_required(self.creation_time, 'creation_time')
        self.validate_required(self.activation_time, 'activation_time')
        self.validate_required(self.termination_time, 'termination_time')
        self.validate_required(self.recovery_time, 'recovery_time')
        self.validate_required(self.status, 'status')
        self.validate_required(self.vlan_id, 'vlan_id')
        self.validate_required(self.circuit_code, 'circuit_code')
        self.validate_required(self.route_table_id, 'route_table_id')
        self.validate_required(self.vlan_interface_id, 'vlan_interface_id')
        self.validate_required(self.local_gateway_ip, 'local_gateway_ip')
        self.validate_required(self.peer_gateway_ip, 'peer_gateway_ip')
        self.validate_required(self.peering_subnet_mask, 'peering_subnet_mask')
        self.validate_required(self.physical_connection_id, 'physical_connection_id')
        self.validate_required(self.physical_connection_status, 'physical_connection_status')
        self.validate_required(self.physical_connection_business_status, 'physical_connection_business_status')
        self.validate_required(self.physical_connection_owner_uid, 'physical_connection_owner_uid')
        self.validate_required(self.access_point_id, 'access_point_id')
        self.validate_required(self.name, 'name')
        self.validate_required(self.description, 'description')

    def to_map(self):
        result = {}
        result['VbrId'] = self.vbr_id
        result['CreationTime'] = self.creation_time
        result['ActivationTime'] = self.activation_time
        result['TerminationTime'] = self.termination_time
        result['RecoveryTime'] = self.recovery_time
        result['Status'] = self.status
        result['VlanId'] = self.vlan_id
        result['CircuitCode'] = self.circuit_code
        result['RouteTableId'] = self.route_table_id
        result['VlanInterfaceId'] = self.vlan_interface_id
        result['LocalGatewayIp'] = self.local_gateway_ip
        result['PeerGatewayIp'] = self.peer_gateway_ip
        result['PeeringSubnetMask'] = self.peering_subnet_mask
        result['PhysicalConnectionId'] = self.physical_connection_id
        result['PhysicalConnectionStatus'] = self.physical_connection_status
        result['PhysicalConnectionBusinessStatus'] = self.physical_connection_business_status
        result['PhysicalConnectionOwnerUid'] = self.physical_connection_owner_uid
        result['AccessPointId'] = self.access_point_id
        result['Name'] = self.name
        result['Description'] = self.description
        return result

    def from_map(self, map={}):
        self.vbr_id = map.get('VbrId')
        self.creation_time = map.get('CreationTime')
        self.activation_time = map.get('ActivationTime')
        self.termination_time = map.get('TerminationTime')
        self.recovery_time = map.get('RecoveryTime')
        self.status = map.get('Status')
        self.vlan_id = map.get('VlanId')
        self.circuit_code = map.get('CircuitCode')
        self.route_table_id = map.get('RouteTableId')
        self.vlan_interface_id = map.get('VlanInterfaceId')
        self.local_gateway_ip = map.get('LocalGatewayIp')
        self.peer_gateway_ip = map.get('PeerGatewayIp')
        self.peering_subnet_mask = map.get('PeeringSubnetMask')
        self.physical_connection_id = map.get('PhysicalConnectionId')
        self.physical_connection_status = map.get('PhysicalConnectionStatus')
        self.physical_connection_business_status = map.get('PhysicalConnectionBusinessStatus')
        self.physical_connection_owner_uid = map.get('PhysicalConnectionOwnerUid')
        self.access_point_id = map.get('AccessPointId')
        self.name = map.get('Name')
        self.description = map.get('Description')
        return self


class DescribeVirtualBorderRoutersResponseVirtualBorderRouterSet(TeaModel):
    def __init__(self, virtual_border_router_type=None):
        self.virtual_border_router_type = virtual_border_router_type

    def validate(self):
        self.validate_required(self.virtual_border_router_type, 'virtual_border_router_type')
        if self.virtual_border_router_type:
            for k in self.virtual_border_router_type:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['VirtualBorderRouterType'] = []
        if self.virtual_border_router_type is not None:
            for k in self.virtual_border_router_type:
                result['VirtualBorderRouterType'].append(k.to_map() if k else None)
        else:
            result['VirtualBorderRouterType'] = None
        return result

    def from_map(self, map={}):
        self.virtual_border_router_type = []
        if map.get('VirtualBorderRouterType') is not None:
            for k in map.get('VirtualBorderRouterType'):
                temp_model = DescribeVirtualBorderRoutersResponseVirtualBorderRouterSetVirtualBorderRouterType()
                temp_model = temp_model.from_map(k)
                self.virtual_border_router_type.append(temp_model)
        else:
            self.virtual_border_router_type = None
        return self
class DescribePhysicalConnectionsRequest(TeaModel):
    def __init__(self, region_id=None, page_number=None, page_size=None, filter=None, client_token=None,
                 user_cidr=None):
        self.region_id = region_id
        self.page_number = page_number
        self.page_size = page_size
        self.filter = filter
        self.client_token = client_token
        self.user_cidr = user_cidr

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        if self.filter:
            for k in self.filter:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        result['Filter'] = []
        if self.filter is not None:
            for k in self.filter:
                result['Filter'].append(k.to_map() if k else None)
        else:
            result['Filter'] = None
        result['ClientToken'] = self.client_token
        result['UserCidr'] = self.user_cidr
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        self.filter = []
        if map.get('Filter') is not None:
            for k in map.get('Filter'):
                temp_model = DescribePhysicalConnectionsRequestFilter()
                temp_model = temp_model.from_map(k)
                self.filter.append(temp_model)
        else:
            self.filter = None
        self.client_token = map.get('ClientToken')
        self.user_cidr = map.get('UserCidr')
        return self


class DescribePhysicalConnectionsRequestFilter(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key
        self.value = value

    def validate(self):
        self.validate_required(self.key, 'key')
        self.validate_required(self.value, 'value')

    def to_map(self):
        result = {}
        result['Key'] = self.key
        result['Value'] = []
        if self.value is not None:
            for k in self.value:
                result['Value'].append(k)
        else:
            result['Value'] = None
        return result

    def from_map(self, map={}):
        self.key = map.get('Key')
        self.value = []
        if map.get('Value') is not None:
            for k in map.get('Value'):
                self.value.append(k)
        else:
            self.value = None
        return self
class DescribePhysicalConnectionsResponse(TeaModel):
    def __init__(self, request_id=None, page_number=None, page_size=None, total_count=None,
                 physical_connection_set=None):
        self.request_id = request_id
        self.page_number = page_number
        self.page_size = page_size
        self.total_count = total_count
        self.physical_connection_set = physical_connection_set

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.page_number, 'page_number')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.physical_connection_set, 'physical_connection_set')
        if self.physical_connection_set:
            self.physical_connection_set.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        result['TotalCount'] = self.total_count
        if self.physical_connection_set is not None:
            result['PhysicalConnectionSet'] = self.physical_connection_set.to_map()
        else:
            result['PhysicalConnectionSet'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        self.total_count = map.get('TotalCount')
        if map.get('PhysicalConnectionSet') is not None:
            temp_model = DescribePhysicalConnectionsResponsePhysicalConnectionSet()
            self.physical_connection_set = temp_model.from_map(map['PhysicalConnectionSet'])
        else:
            self.physical_connection_set = None
        return self


class DescribePhysicalConnectionsResponsePhysicalConnectionSetPhysicalConnectionType(TeaModel):
    def __init__(self, physical_connection_id=None, access_point_id=None, type=None, status=None,
                 business_status=None, creation_time=None, enabled_time=None, line_operator=None, spec=None, peer_location=None,
                 port_type=None, redundant_physical_connection_id=None, name=None, description=None, ad_location=None,
                 port_number=None, circuit_code=None, bandwidth=None):
        self.physical_connection_id = physical_connection_id
        self.access_point_id = access_point_id
        self.type = type
        self.status = status
        self.business_status = business_status
        self.creation_time = creation_time
        self.enabled_time = enabled_time
        self.line_operator = line_operator
        self.spec = spec
        self.peer_location = peer_location
        self.port_type = port_type
        self.redundant_physical_connection_id = redundant_physical_connection_id
        self.name = name
        self.description = description
        self.ad_location = ad_location
        self.port_number = port_number
        self.circuit_code = circuit_code
        self.bandwidth = bandwidth

    def validate(self):
        self.validate_required(self.physical_connection_id, 'physical_connection_id')
        self.validate_required(self.access_point_id, 'access_point_id')
        self.validate_required(self.type, 'type')
        self.validate_required(self.status, 'status')
        self.validate_required(self.business_status, 'business_status')
        self.validate_required(self.creation_time, 'creation_time')
        self.validate_required(self.enabled_time, 'enabled_time')
        self.validate_required(self.line_operator, 'line_operator')
        self.validate_required(self.spec, 'spec')
        self.validate_required(self.peer_location, 'peer_location')
        self.validate_required(self.port_type, 'port_type')
        self.validate_required(self.redundant_physical_connection_id, 'redundant_physical_connection_id')
        self.validate_required(self.name, 'name')
        self.validate_required(self.description, 'description')
        self.validate_required(self.ad_location, 'ad_location')
        self.validate_required(self.port_number, 'port_number')
        self.validate_required(self.circuit_code, 'circuit_code')
        self.validate_required(self.bandwidth, 'bandwidth')

    def to_map(self):
        result = {}
        result['PhysicalConnectionId'] = self.physical_connection_id
        result['AccessPointId'] = self.access_point_id
        result['Type'] = self.type
        result['Status'] = self.status
        result['BusinessStatus'] = self.business_status
        result['CreationTime'] = self.creation_time
        result['EnabledTime'] = self.enabled_time
        result['LineOperator'] = self.line_operator
        result['Spec'] = self.spec
        result['PeerLocation'] = self.peer_location
        result['PortType'] = self.port_type
        result['RedundantPhysicalConnectionId'] = self.redundant_physical_connection_id
        result['Name'] = self.name
        result['Description'] = self.description
        result['AdLocation'] = self.ad_location
        result['PortNumber'] = self.port_number
        result['CircuitCode'] = self.circuit_code
        result['Bandwidth'] = self.bandwidth
        return result

    def from_map(self, map={}):
        self.physical_connection_id = map.get('PhysicalConnectionId')
        self.access_point_id = map.get('AccessPointId')
        self.type = map.get('Type')
        self.status = map.get('Status')
        self.business_status = map.get('BusinessStatus')
        self.creation_time = map.get('CreationTime')
        self.enabled_time = map.get('EnabledTime')
        self.line_operator = map.get('LineOperator')
        self.spec = map.get('Spec')
        self.peer_location = map.get('PeerLocation')
        self.port_type = map.get('PortType')
        self.redundant_physical_connection_id = map.get('RedundantPhysicalConnectionId')
        self.name = map.get('Name')
        self.description = map.get('Description')
        self.ad_location = map.get('AdLocation')
        self.port_number = map.get('PortNumber')
        self.circuit_code = map.get('CircuitCode')
        self.bandwidth = map.get('Bandwidth')
        return self


class DescribePhysicalConnectionsResponsePhysicalConnectionSet(TeaModel):
    def __init__(self, physical_connection_type=None):
        self.physical_connection_type = physical_connection_type

    def validate(self):
        self.validate_required(self.physical_connection_type, 'physical_connection_type')
        if self.physical_connection_type:
            for k in self.physical_connection_type:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['PhysicalConnectionType'] = []
        if self.physical_connection_type is not None:
            for k in self.physical_connection_type:
                result['PhysicalConnectionType'].append(k.to_map() if k else None)
        else:
            result['PhysicalConnectionType'] = None
        return result

    def from_map(self, map={}):
        self.physical_connection_type = []
        if map.get('PhysicalConnectionType') is not None:
            for k in map.get('PhysicalConnectionType'):
                temp_model = DescribePhysicalConnectionsResponsePhysicalConnectionSetPhysicalConnectionType()
                temp_model = temp_model.from_map(k)
                self.physical_connection_type.append(temp_model)
        else:
            self.physical_connection_type = None
        return self
class DescribeAccessPointsRequest(TeaModel):
    def __init__(self, filter=None, region_id=None, type=None, page_number=None, page_size=None):
        self.filter = filter
        self.region_id = region_id
        self.type = type
        self.page_number = page_number
        self.page_size = page_size

    def validate(self):
        if self.filter:
            for k in self.filter:
                if k:
                    k.validate()
        self.validate_required(self.region_id, 'region_id')

    def to_map(self):
        result = {}
        result['Filter'] = []
        if self.filter is not None:
            for k in self.filter:
                result['Filter'].append(k.to_map() if k else None)
        else:
            result['Filter'] = None
        result['RegionId'] = self.region_id
        result['Type'] = self.type
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        return result

    def from_map(self, map={}):
        self.filter = []
        if map.get('Filter') is not None:
            for k in map.get('Filter'):
                temp_model = DescribeAccessPointsRequestFilter()
                temp_model = temp_model.from_map(k)
                self.filter.append(temp_model)
        else:
            self.filter = None
        self.region_id = map.get('RegionId')
        self.type = map.get('Type')
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        return self


class DescribeAccessPointsRequestFilter(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key
        self.value = value

    def validate(self):
        self.validate_required(self.key, 'key')
        self.validate_required(self.value, 'value')

    def to_map(self):
        result = {}
        result['Key'] = self.key
        result['Value'] = []
        if self.value is not None:
            for k in self.value:
                result['Value'].append(k)
        else:
            result['Value'] = None
        return result

    def from_map(self, map={}):
        self.key = map.get('Key')
        self.value = []
        if map.get('Value') is not None:
            for k in map.get('Value'):
                self.value.append(k)
        else:
            self.value = None
        return self
class DescribeAccessPointsResponse(TeaModel):
    def __init__(self, request_id=None, page_number=None, page_size=None, total_count=None, access_point_set=None):
        self.request_id = request_id
        self.page_number = page_number
        self.page_size = page_size
        self.total_count = total_count
        self.access_point_set = access_point_set

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.page_number, 'page_number')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.access_point_set, 'access_point_set')
        if self.access_point_set:
            self.access_point_set.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        result['TotalCount'] = self.total_count
        if self.access_point_set is not None:
            result['AccessPointSet'] = self.access_point_set.to_map()
        else:
            result['AccessPointSet'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        self.total_count = map.get('TotalCount')
        if map.get('AccessPointSet') is not None:
            temp_model = DescribeAccessPointsResponseAccessPointSet()
            self.access_point_set = temp_model.from_map(map['AccessPointSet'])
        else:
            self.access_point_set = None
        return self


class DescribeAccessPointsResponseAccessPointSetAccessPointType(TeaModel):
    def __init__(self, access_point_id=None, status=None, type=None, attached_region_no=None, location=None,
                 host_operator=None, name=None, description=None):
        self.access_point_id = access_point_id
        self.status = status
        self.type = type
        self.attached_region_no = attached_region_no
        self.location = location
        self.host_operator = host_operator
        self.name = name
        self.description = description

    def validate(self):
        self.validate_required(self.access_point_id, 'access_point_id')
        self.validate_required(self.status, 'status')
        self.validate_required(self.type, 'type')
        self.validate_required(self.attached_region_no, 'attached_region_no')
        self.validate_required(self.location, 'location')
        self.validate_required(self.host_operator, 'host_operator')
        self.validate_required(self.name, 'name')
        self.validate_required(self.description, 'description')

    def to_map(self):
        result = {}
        result['AccessPointId'] = self.access_point_id
        result['Status'] = self.status
        result['Type'] = self.type
        result['AttachedRegionNo'] = self.attached_region_no
        result['Location'] = self.location
        result['HostOperator'] = self.host_operator
        result['Name'] = self.name
        result['Description'] = self.description
        return result

    def from_map(self, map={}):
        self.access_point_id = map.get('AccessPointId')
        self.status = map.get('Status')
        self.type = map.get('Type')
        self.attached_region_no = map.get('AttachedRegionNo')
        self.location = map.get('Location')
        self.host_operator = map.get('HostOperator')
        self.name = map.get('Name')
        self.description = map.get('Description')
        return self


class DescribeAccessPointsResponseAccessPointSet(TeaModel):
    def __init__(self, access_point_type=None):
        self.access_point_type = access_point_type

    def validate(self):
        self.validate_required(self.access_point_type, 'access_point_type')
        if self.access_point_type:
            for k in self.access_point_type:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['AccessPointType'] = []
        if self.access_point_type is not None:
            for k in self.access_point_type:
                result['AccessPointType'].append(k.to_map() if k else None)
        else:
            result['AccessPointType'] = None
        return result

    def from_map(self, map={}):
        self.access_point_type = []
        if map.get('AccessPointType') is not None:
            for k in map.get('AccessPointType'):
                temp_model = DescribeAccessPointsResponseAccessPointSetAccessPointType()
                temp_model = temp_model.from_map(k)
                self.access_point_type.append(temp_model)
        else:
            self.access_point_type = None
        return self
class DeleteVirtualBorderRouterRequest(TeaModel):
    def __init__(self, region_id=None, vbr_id=None, client_token=None, user_cidr=None):
        self.region_id = region_id
        self.vbr_id = vbr_id
        self.client_token = client_token
        self.user_cidr = user_cidr

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.vbr_id, 'vbr_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['VbrId'] = self.vbr_id
        result['ClientToken'] = self.client_token
        result['UserCidr'] = self.user_cidr
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.vbr_id = map.get('VbrId')
        self.client_token = map.get('ClientToken')
        self.user_cidr = map.get('UserCidr')
        return self


class DeleteVirtualBorderRouterResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class DeletePhysicalConnectionRequest(TeaModel):
    def __init__(self, region_id=None, physical_connection_id=None, client_token=None):
        self.region_id = region_id
        self.physical_connection_id = physical_connection_id
        self.client_token = client_token

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.physical_connection_id, 'physical_connection_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['PhysicalConnectionId'] = self.physical_connection_id
        result['ClientToken'] = self.client_token
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.physical_connection_id = map.get('PhysicalConnectionId')
        self.client_token = map.get('ClientToken')
        return self


class DeletePhysicalConnectionResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class CreateVirtualBorderRouterRequest(TeaModel):
    def __init__(self, region_id=None, physical_connection_id=None, vbr_owner_id=None, vlan_id=None,
                 circuit_code=None, local_gateway_ip=None, peer_gateway_ip=None, peering_subnet_mask=None, description=None,
                 name=None, client_token=None, user_cidr=None):
        self.region_id = region_id
        self.physical_connection_id = physical_connection_id
        self.vbr_owner_id = vbr_owner_id
        self.vlan_id = vlan_id
        self.circuit_code = circuit_code
        self.local_gateway_ip = local_gateway_ip
        self.peer_gateway_ip = peer_gateway_ip
        self.peering_subnet_mask = peering_subnet_mask
        self.description = description
        self.name = name
        self.client_token = client_token
        self.user_cidr = user_cidr

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.physical_connection_id, 'physical_connection_id')
        self.validate_required(self.vlan_id, 'vlan_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['PhysicalConnectionId'] = self.physical_connection_id
        result['VbrOwnerId'] = self.vbr_owner_id
        result['VlanId'] = self.vlan_id
        result['CircuitCode'] = self.circuit_code
        result['LocalGatewayIp'] = self.local_gateway_ip
        result['PeerGatewayIp'] = self.peer_gateway_ip
        result['PeeringSubnetMask'] = self.peering_subnet_mask
        result['Description'] = self.description
        result['Name'] = self.name
        result['ClientToken'] = self.client_token
        result['UserCidr'] = self.user_cidr
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.physical_connection_id = map.get('PhysicalConnectionId')
        self.vbr_owner_id = map.get('VbrOwnerId')
        self.vlan_id = map.get('VlanId')
        self.circuit_code = map.get('CircuitCode')
        self.local_gateway_ip = map.get('LocalGatewayIp')
        self.peer_gateway_ip = map.get('PeerGatewayIp')
        self.peering_subnet_mask = map.get('PeeringSubnetMask')
        self.description = map.get('Description')
        self.name = map.get('Name')
        self.client_token = map.get('ClientToken')
        self.user_cidr = map.get('UserCidr')
        return self


class CreateVirtualBorderRouterResponse(TeaModel):
    def __init__(self, request_id=None, vbr_id=None):
        self.request_id = request_id
        self.vbr_id = vbr_id

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.vbr_id, 'vbr_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['VbrId'] = self.vbr_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.vbr_id = map.get('VbrId')
        return self


class CreatePhysicalConnectionRequest(TeaModel):
    def __init__(self, region_id=None, access_point_id=None, type=None, line_operator=None, bandwidth=None,
                 peer_location=None, port_type=None, redundant_physical_connection_id=None, description=None, name=None,
                 circuit_code=None, client_token=None, user_cidr=None):
        self.region_id = region_id
        self.access_point_id = access_point_id
        self.type = type
        self.line_operator = line_operator
        self.bandwidth = bandwidth
        self.peer_location = peer_location
        self.port_type = port_type
        self.redundant_physical_connection_id = redundant_physical_connection_id
        self.description = description
        self.name = name
        self.circuit_code = circuit_code
        self.client_token = client_token
        self.user_cidr = user_cidr

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.access_point_id, 'access_point_id')
        self.validate_required(self.line_operator, 'line_operator')
        self.validate_required(self.peer_location, 'peer_location')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['AccessPointId'] = self.access_point_id
        result['Type'] = self.type
        result['LineOperator'] = self.line_operator
        result['bandwidth'] = self.bandwidth
        result['PeerLocation'] = self.peer_location
        result['PortType'] = self.port_type
        result['RedundantPhysicalConnectionId'] = self.redundant_physical_connection_id
        result['Description'] = self.description
        result['Name'] = self.name
        result['CircuitCode'] = self.circuit_code
        result['ClientToken'] = self.client_token
        result['UserCidr'] = self.user_cidr
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.access_point_id = map.get('AccessPointId')
        self.type = map.get('Type')
        self.line_operator = map.get('LineOperator')
        self.bandwidth = map.get('bandwidth')
        self.peer_location = map.get('PeerLocation')
        self.port_type = map.get('PortType')
        self.redundant_physical_connection_id = map.get('RedundantPhysicalConnectionId')
        self.description = map.get('Description')
        self.name = map.get('Name')
        self.circuit_code = map.get('CircuitCode')
        self.client_token = map.get('ClientToken')
        self.user_cidr = map.get('UserCidr')
        return self


class CreatePhysicalConnectionResponse(TeaModel):
    def __init__(self, request_id=None, physical_connection_id=None):
        self.request_id = request_id
        self.physical_connection_id = physical_connection_id

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.physical_connection_id, 'physical_connection_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['PhysicalConnectionId'] = self.physical_connection_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.physical_connection_id = map.get('PhysicalConnectionId')
        return self


class CancelPhysicalConnectionRequest(TeaModel):
    def __init__(self, region_id=None, physical_connection_id=None, client_token=None, user_cidr=None):
        self.region_id = region_id
        self.physical_connection_id = physical_connection_id
        self.client_token = client_token
        self.user_cidr = user_cidr

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.physical_connection_id, 'physical_connection_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['PhysicalConnectionId'] = self.physical_connection_id
        result['ClientToken'] = self.client_token
        result['UserCidr'] = self.user_cidr
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.physical_connection_id = map.get('PhysicalConnectionId')
        self.client_token = map.get('ClientToken')
        self.user_cidr = map.get('UserCidr')
        return self


class CancelPhysicalConnectionResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class ImportImageRequest(TeaModel):
    def __init__(self, disk_device_mapping=None, region_id=None, image_name=None, description=None,
                 architecture=None, ostype=None, platform=None, boot_mode=None, role_name=None, license_type=None, tag=None,
                 resource_group_id=None):
        self.disk_device_mapping = disk_device_mapping
        self.region_id = region_id
        self.image_name = image_name
        self.description = description
        self.architecture = architecture
        self.ostype = ostype
        self.platform = platform
        self.boot_mode = boot_mode
        self.role_name = role_name
        self.license_type = license_type
        self.tag = tag
        self.resource_group_id = resource_group_id

    def validate(self):
        if self.disk_device_mapping:
            for k in self.disk_device_mapping:
                if k:
                    k.validate()
        self.validate_required(self.region_id, 'region_id')
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['DiskDeviceMapping'] = []
        if self.disk_device_mapping is not None:
            for k in self.disk_device_mapping:
                result['DiskDeviceMapping'].append(k.to_map() if k else None)
        else:
            result['DiskDeviceMapping'] = None
        result['RegionId'] = self.region_id
        result['ImageName'] = self.image_name
        result['Description'] = self.description
        result['Architecture'] = self.architecture
        result['OSType'] = self.ostype
        result['Platform'] = self.platform
        result['BootMode'] = self.boot_mode
        result['RoleName'] = self.role_name
        result['LicenseType'] = self.license_type
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        else:
            result['Tag'] = None
        result['ResourceGroupId'] = self.resource_group_id
        return result

    def from_map(self, map={}):
        self.disk_device_mapping = []
        if map.get('DiskDeviceMapping') is not None:
            for k in map.get('DiskDeviceMapping'):
                temp_model = ImportImageRequestDiskDeviceMapping()
                temp_model = temp_model.from_map(k)
                self.disk_device_mapping.append(temp_model)
        else:
            self.disk_device_mapping = None
        self.region_id = map.get('RegionId')
        self.image_name = map.get('ImageName')
        self.description = map.get('Description')
        self.architecture = map.get('Architecture')
        self.ostype = map.get('OSType')
        self.platform = map.get('Platform')
        self.boot_mode = map.get('BootMode')
        self.role_name = map.get('RoleName')
        self.license_type = map.get('LicenseType')
        self.tag = []
        if map.get('Tag') is not None:
            for k in map.get('Tag'):
                temp_model = ImportImageRequestTag()
                temp_model = temp_model.from_map(k)
                self.tag.append(temp_model)
        else:
            self.tag = None
        self.resource_group_id = map.get('ResourceGroupId')
        return self


class ImportImageRequestDiskDeviceMapping(TeaModel):
    def __init__(self, format=None, ossbucket=None, ossobject=None, disk_im_size=None, disk_image_size=None,
                 device=None):
        self.format = format
        self.ossbucket = ossbucket
        self.ossobject = ossobject
        self.disk_im_size = disk_im_size
        self.disk_image_size = disk_image_size
        self.device = device

    def validate(self):
        pass

    def to_map(self):
        result = {}
        result['Format'] = self.format
        result['OSSBucket'] = self.ossbucket
        result['OSSObject'] = self.ossobject
        result['DiskImSize'] = self.disk_im_size
        result['DiskImageSize'] = self.disk_image_size
        result['Device'] = self.device
        return result

    def from_map(self, map={}):
        self.format = map.get('Format')
        self.ossbucket = map.get('OSSBucket')
        self.ossobject = map.get('OSSObject')
        self.disk_im_size = map.get('DiskImSize')
        self.disk_image_size = map.get('DiskImageSize')
        self.device = map.get('Device')
        return self


class ImportImageRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key
        self.value = value

    def validate(self):
        self.validate_required(self.key, 'key')
        self.validate_required(self.value, 'value')

    def to_map(self):
        result = {}
        result['Key'] = self.key
        result['Value'] = self.value
        return result

    def from_map(self, map={}):
        self.key = map.get('Key')
        self.value = map.get('Value')
        return self
class ImportImageResponse(TeaModel):
    def __init__(self, request_id=None, task_id=None, region_id=None, image_id=None):
        self.request_id = request_id
        self.task_id = task_id
        self.region_id = region_id
        self.image_id = image_id

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.task_id, 'task_id')
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.image_id, 'image_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['TaskId'] = self.task_id
        result['RegionId'] = self.region_id
        result['ImageId'] = self.image_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.task_id = map.get('TaskId')
        self.region_id = map.get('RegionId')
        self.image_id = map.get('ImageId')
        return self


class ExportImageRequest(TeaModel):
    def __init__(self, region_id=None, image_id=None, ossbucket=None, ossprefix=None, image_format=None,
                 role_name=None):
        self.region_id = region_id
        self.image_id = image_id
        self.ossbucket = ossbucket
        self.ossprefix = ossprefix
        self.image_format = image_format
        self.role_name = role_name

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.image_id, 'image_id')
        self.validate_required(self.ossbucket, 'ossbucket')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['ImageId'] = self.image_id
        result['OSSBucket'] = self.ossbucket
        result['OSSPrefix'] = self.ossprefix
        result['ImageFormat'] = self.image_format
        result['RoleName'] = self.role_name
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.image_id = map.get('ImageId')
        self.ossbucket = map.get('OSSBucket')
        self.ossprefix = map.get('OSSPrefix')
        self.image_format = map.get('ImageFormat')
        self.role_name = map.get('RoleName')
        return self


class ExportImageResponse(TeaModel):
    def __init__(self, request_id=None, task_id=None, region_id=None):
        self.request_id = request_id
        self.task_id = task_id
        self.region_id = region_id

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.task_id, 'task_id')
        self.validate_required(self.region_id, 'region_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['TaskId'] = self.task_id
        result['RegionId'] = self.region_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.task_id = map.get('TaskId')
        self.region_id = map.get('RegionId')
        return self


class DescribeTasksRequest(TeaModel):
    def __init__(self, page_number=None, page_size=None, region_id=None, task_ids=None, task_action=None,
                 task_status=None, start_time=None, end_time=None):
        self.page_number = page_number
        self.page_size = page_size
        self.region_id = region_id
        self.task_ids = task_ids
        self.task_action = task_action
        self.task_status = task_status
        self.start_time = start_time
        self.end_time = end_time

    def validate(self):
        self.validate_required(self.region_id, 'region_id')

    def to_map(self):
        result = {}
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        result['RegionId'] = self.region_id
        result['TaskIds'] = self.task_ids
        result['TaskAction'] = self.task_action
        result['TaskStatus'] = self.task_status
        result['StartTime'] = self.start_time
        result['EndTime'] = self.end_time
        return result

    def from_map(self, map={}):
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        self.region_id = map.get('RegionId')
        self.task_ids = map.get('TaskIds')
        self.task_action = map.get('TaskAction')
        self.task_status = map.get('TaskStatus')
        self.start_time = map.get('StartTime')
        self.end_time = map.get('EndTime')
        return self


class DescribeTasksResponse(TeaModel):
    def __init__(self, request_id=None, region_id=None, total_count=None, page_number=None, page_size=None,
                 task_set=None):
        self.request_id = request_id
        self.region_id = region_id
        self.total_count = total_count
        self.page_number = page_number
        self.page_size = page_size
        self.task_set = task_set

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.page_number, 'page_number')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.task_set, 'task_set')
        if self.task_set:
            self.task_set.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['RegionId'] = self.region_id
        result['TotalCount'] = self.total_count
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        if self.task_set is not None:
            result['TaskSet'] = self.task_set.to_map()
        else:
            result['TaskSet'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.region_id = map.get('RegionId')
        self.total_count = map.get('TotalCount')
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        if map.get('TaskSet') is not None:
            temp_model = DescribeTasksResponseTaskSet()
            self.task_set = temp_model.from_map(map['TaskSet'])
        else:
            self.task_set = None
        return self


class DescribeTasksResponseTaskSetTask(TeaModel):
    def __init__(self, task_id=None, task_action=None, task_status=None, support_cancel=None, creation_time=None,
                 finished_time=None):
        self.task_id = task_id
        self.task_action = task_action
        self.task_status = task_status
        self.support_cancel = support_cancel
        self.creation_time = creation_time
        self.finished_time = finished_time

    def validate(self):
        self.validate_required(self.task_id, 'task_id')
        self.validate_required(self.task_action, 'task_action')
        self.validate_required(self.task_status, 'task_status')
        self.validate_required(self.support_cancel, 'support_cancel')
        self.validate_required(self.creation_time, 'creation_time')
        self.validate_required(self.finished_time, 'finished_time')

    def to_map(self):
        result = {}
        result['TaskId'] = self.task_id
        result['TaskAction'] = self.task_action
        result['TaskStatus'] = self.task_status
        result['SupportCancel'] = self.support_cancel
        result['CreationTime'] = self.creation_time
        result['FinishedTime'] = self.finished_time
        return result

    def from_map(self, map={}):
        self.task_id = map.get('TaskId')
        self.task_action = map.get('TaskAction')
        self.task_status = map.get('TaskStatus')
        self.support_cancel = map.get('SupportCancel')
        self.creation_time = map.get('CreationTime')
        self.finished_time = map.get('FinishedTime')
        return self


class DescribeTasksResponseTaskSet(TeaModel):
    def __init__(self, task=None):
        self.task = task

    def validate(self):
        self.validate_required(self.task, 'task')
        if self.task:
            for k in self.task:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['Task'] = []
        if self.task is not None:
            for k in self.task:
                result['Task'].append(k.to_map() if k else None)
        else:
            result['Task'] = None
        return result

    def from_map(self, map={}):
        self.task = []
        if map.get('Task') is not None:
            for k in map.get('Task'):
                temp_model = DescribeTasksResponseTaskSetTask()
                temp_model = temp_model.from_map(k)
                self.task.append(temp_model)
        else:
            self.task = None
        return self
class DescribeTaskAttributeRequest(TeaModel):
    def __init__(self, region_id=None, task_id=None):
        self.region_id = region_id
        self.task_id = task_id

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.task_id, 'task_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['TaskId'] = self.task_id
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.task_id = map.get('TaskId')
        return self


class DescribeTaskAttributeResponse(TeaModel):
    def __init__(self, request_id=None, task_id=None, region_id=None, task_action=None, task_status=None,
                 task_process=None, support_cancel=None, total_count=None, success_count=None, failed_count=None,
                 creation_time=None, finished_time=None, operation_progress_set=None):
        self.request_id = request_id
        self.task_id = task_id
        self.region_id = region_id
        self.task_action = task_action
        self.task_status = task_status
        self.task_process = task_process
        self.support_cancel = support_cancel
        self.total_count = total_count
        self.success_count = success_count
        self.failed_count = failed_count
        self.creation_time = creation_time
        self.finished_time = finished_time
        self.operation_progress_set = operation_progress_set

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.task_id, 'task_id')
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.task_action, 'task_action')
        self.validate_required(self.task_status, 'task_status')
        self.validate_required(self.task_process, 'task_process')
        self.validate_required(self.support_cancel, 'support_cancel')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.success_count, 'success_count')
        self.validate_required(self.failed_count, 'failed_count')
        self.validate_required(self.creation_time, 'creation_time')
        self.validate_required(self.finished_time, 'finished_time')
        self.validate_required(self.operation_progress_set, 'operation_progress_set')
        if self.operation_progress_set:
            self.operation_progress_set.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['TaskId'] = self.task_id
        result['RegionId'] = self.region_id
        result['TaskAction'] = self.task_action
        result['TaskStatus'] = self.task_status
        result['TaskProcess'] = self.task_process
        result['SupportCancel'] = self.support_cancel
        result['TotalCount'] = self.total_count
        result['SuccessCount'] = self.success_count
        result['FailedCount'] = self.failed_count
        result['CreationTime'] = self.creation_time
        result['FinishedTime'] = self.finished_time
        if self.operation_progress_set is not None:
            result['OperationProgressSet'] = self.operation_progress_set.to_map()
        else:
            result['OperationProgressSet'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.task_id = map.get('TaskId')
        self.region_id = map.get('RegionId')
        self.task_action = map.get('TaskAction')
        self.task_status = map.get('TaskStatus')
        self.task_process = map.get('TaskProcess')
        self.support_cancel = map.get('SupportCancel')
        self.total_count = map.get('TotalCount')
        self.success_count = map.get('SuccessCount')
        self.failed_count = map.get('FailedCount')
        self.creation_time = map.get('CreationTime')
        self.finished_time = map.get('FinishedTime')
        if map.get('OperationProgressSet') is not None:
            temp_model = DescribeTaskAttributeResponseOperationProgressSet()
            self.operation_progress_set = temp_model.from_map(map['OperationProgressSet'])
        else:
            self.operation_progress_set = None
        return self


class DescribeTaskAttributeResponseOperationProgressSetOperationProgressRelatedItemSetRelatedItem(TeaModel):
    def __init__(self, name=None, value=None):
        self.name = name
        self.value = value

    def validate(self):
        self.validate_required(self.name, 'name')
        self.validate_required(self.value, 'value')

    def to_map(self):
        result = {}
        result['Name'] = self.name
        result['Value'] = self.value
        return result

    def from_map(self, map={}):
        self.name = map.get('Name')
        self.value = map.get('Value')
        return self


class DescribeTaskAttributeResponseOperationProgressSetOperationProgressRelatedItemSet(TeaModel):
    def __init__(self, related_item=None):
        self.related_item = related_item

    def validate(self):
        self.validate_required(self.related_item, 'related_item')
        if self.related_item:
            for k in self.related_item:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['RelatedItem'] = []
        if self.related_item is not None:
            for k in self.related_item:
                result['RelatedItem'].append(k.to_map() if k else None)
        else:
            result['RelatedItem'] = None
        return result

    def from_map(self, map={}):
        self.related_item = []
        if map.get('RelatedItem') is not None:
            for k in map.get('RelatedItem'):
                temp_model = DescribeTaskAttributeResponseOperationProgressSetOperationProgressRelatedItemSetRelatedItem()
                temp_model = temp_model.from_map(k)
                self.related_item.append(temp_model)
        else:
            self.related_item = None
        return self


class DescribeTaskAttributeResponseOperationProgressSetOperationProgress(TeaModel):
    def __init__(self, operation_status=None, error_code=None, error_msg=None, related_item_set=None):
        self.operation_status = operation_status
        self.error_code = error_code
        self.error_msg = error_msg
        self.related_item_set = related_item_set

    def validate(self):
        self.validate_required(self.operation_status, 'operation_status')
        self.validate_required(self.error_code, 'error_code')
        self.validate_required(self.error_msg, 'error_msg')
        self.validate_required(self.related_item_set, 'related_item_set')
        if self.related_item_set:
            self.related_item_set.validate()

    def to_map(self):
        result = {}
        result['OperationStatus'] = self.operation_status
        result['ErrorCode'] = self.error_code
        result['ErrorMsg'] = self.error_msg
        if self.related_item_set is not None:
            result['RelatedItemSet'] = self.related_item_set.to_map()
        else:
            result['RelatedItemSet'] = None
        return result

    def from_map(self, map={}):
        self.operation_status = map.get('OperationStatus')
        self.error_code = map.get('ErrorCode')
        self.error_msg = map.get('ErrorMsg')
        if map.get('RelatedItemSet') is not None:
            temp_model = DescribeTaskAttributeResponseOperationProgressSetOperationProgressRelatedItemSet()
            self.related_item_set = temp_model.from_map(map['RelatedItemSet'])
        else:
            self.related_item_set = None
        return self


class DescribeTaskAttributeResponseOperationProgressSet(TeaModel):
    def __init__(self, operation_progress=None):
        self.operation_progress = operation_progress

    def validate(self):
        self.validate_required(self.operation_progress, 'operation_progress')
        if self.operation_progress:
            for k in self.operation_progress:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['OperationProgress'] = []
        if self.operation_progress is not None:
            for k in self.operation_progress:
                result['OperationProgress'].append(k.to_map() if k else None)
        else:
            result['OperationProgress'] = None
        return result

    def from_map(self, map={}):
        self.operation_progress = []
        if map.get('OperationProgress') is not None:
            for k in map.get('OperationProgress'):
                temp_model = DescribeTaskAttributeResponseOperationProgressSetOperationProgress()
                temp_model = temp_model.from_map(k)
                self.operation_progress.append(temp_model)
        else:
            self.operation_progress = None
        return self
class CancelTaskRequest(TeaModel):
    def __init__(self, region_id=None, task_id=None):
        self.region_id = region_id
        self.task_id = task_id

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.task_id, 'task_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['TaskId'] = self.task_id
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.task_id = map.get('TaskId')
        return self


class CancelTaskResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class DescribeInstanceTypeFamiliesRequest(TeaModel):
    def __init__(self, region_id=None, generation=None):
        self.region_id = region_id
        self.generation = generation

    def validate(self):
        self.validate_required(self.region_id, 'region_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['Generation'] = self.generation
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.generation = map.get('Generation')
        return self


class DescribeInstanceTypeFamiliesResponse(TeaModel):
    def __init__(self, request_id=None, instance_type_families=None):
        self.request_id = request_id
        self.instance_type_families = instance_type_families

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.instance_type_families, 'instance_type_families')
        if self.instance_type_families:
            self.instance_type_families.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        if self.instance_type_families is not None:
            result['InstanceTypeFamilies'] = self.instance_type_families.to_map()
        else:
            result['InstanceTypeFamilies'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        if map.get('InstanceTypeFamilies') is not None:
            temp_model = DescribeInstanceTypeFamiliesResponseInstanceTypeFamilies()
            self.instance_type_families = temp_model.from_map(map['InstanceTypeFamilies'])
        else:
            self.instance_type_families = None
        return self


class DescribeInstanceTypeFamiliesResponseInstanceTypeFamiliesInstanceTypeFamily(TeaModel):
    def __init__(self, instance_type_family_id=None, generation=None):
        self.instance_type_family_id = instance_type_family_id
        self.generation = generation

    def validate(self):
        self.validate_required(self.instance_type_family_id, 'instance_type_family_id')
        self.validate_required(self.generation, 'generation')

    def to_map(self):
        result = {}
        result['InstanceTypeFamilyId'] = self.instance_type_family_id
        result['Generation'] = self.generation
        return result

    def from_map(self, map={}):
        self.instance_type_family_id = map.get('InstanceTypeFamilyId')
        self.generation = map.get('Generation')
        return self


class DescribeInstanceTypeFamiliesResponseInstanceTypeFamilies(TeaModel):
    def __init__(self, instance_type_family=None):
        self.instance_type_family = instance_type_family

    def validate(self):
        self.validate_required(self.instance_type_family, 'instance_type_family')
        if self.instance_type_family:
            for k in self.instance_type_family:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['InstanceTypeFamily'] = []
        if self.instance_type_family is not None:
            for k in self.instance_type_family:
                result['InstanceTypeFamily'].append(k.to_map() if k else None)
        else:
            result['InstanceTypeFamily'] = None
        return result

    def from_map(self, map={}):
        self.instance_type_family = []
        if map.get('InstanceTypeFamily') is not None:
            for k in map.get('InstanceTypeFamily'):
                temp_model = DescribeInstanceTypeFamiliesResponseInstanceTypeFamiliesInstanceTypeFamily()
                temp_model = temp_model.from_map(k)
                self.instance_type_family.append(temp_model)
        else:
            self.instance_type_family = None
        return self
class ModifyRouterInterfaceSpecRequest(TeaModel):
    def __init__(self, region_id=None, router_interface_id=None, spec=None, client_token=None, user_cidr=None):
        self.region_id = region_id
        self.router_interface_id = router_interface_id
        self.spec = spec
        self.client_token = client_token
        self.user_cidr = user_cidr

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.router_interface_id, 'router_interface_id')
        self.validate_required(self.spec, 'spec')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['RouterInterfaceId'] = self.router_interface_id
        result['Spec'] = self.spec
        result['ClientToken'] = self.client_token
        result['UserCidr'] = self.user_cidr
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.router_interface_id = map.get('RouterInterfaceId')
        self.spec = map.get('Spec')
        self.client_token = map.get('ClientToken')
        self.user_cidr = map.get('UserCidr')
        return self


class ModifyRouterInterfaceSpecResponse(TeaModel):
    def __init__(self, request_id=None, spec=None):
        self.request_id = request_id
        self.spec = spec

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.spec, 'spec')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['Spec'] = self.spec
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.spec = map.get('Spec')
        return self


class ModifyRouterInterfaceAttributeRequest(TeaModel):
    def __init__(self, region_id=None, router_interface_id=None, name=None, description=None,
                 opposite_interface_id=None, opposite_router_id=None, opposite_router_type=None, opposite_interface_owner_id=None,
                 health_check_source_ip=None, health_check_target_ip=None):
        self.region_id = region_id
        self.router_interface_id = router_interface_id
        self.name = name
        self.description = description
        self.opposite_interface_id = opposite_interface_id
        self.opposite_router_id = opposite_router_id
        self.opposite_router_type = opposite_router_type
        self.opposite_interface_owner_id = opposite_interface_owner_id
        self.health_check_source_ip = health_check_source_ip
        self.health_check_target_ip = health_check_target_ip

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.router_interface_id, 'router_interface_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['RouterInterfaceId'] = self.router_interface_id
        result['Name'] = self.name
        result['Description'] = self.description
        result['OppositeInterfaceId'] = self.opposite_interface_id
        result['OppositeRouterId'] = self.opposite_router_id
        result['OppositeRouterType'] = self.opposite_router_type
        result['OppositeInterfaceOwnerId'] = self.opposite_interface_owner_id
        result['HealthCheckSourceIp'] = self.health_check_source_ip
        result['HealthCheckTargetIp'] = self.health_check_target_ip
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.router_interface_id = map.get('RouterInterfaceId')
        self.name = map.get('Name')
        self.description = map.get('Description')
        self.opposite_interface_id = map.get('OppositeInterfaceId')
        self.opposite_router_id = map.get('OppositeRouterId')
        self.opposite_router_type = map.get('OppositeRouterType')
        self.opposite_interface_owner_id = map.get('OppositeInterfaceOwnerId')
        self.health_check_source_ip = map.get('HealthCheckSourceIp')
        self.health_check_target_ip = map.get('HealthCheckTargetIp')
        return self


class ModifyRouterInterfaceAttributeResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class DescribeRouterInterfacesRequest(TeaModel):
    def __init__(self, region_id=None, page_number=None, page_size=None, filter=None):
        self.region_id = region_id
        self.page_number = page_number
        self.page_size = page_size
        self.filter = filter

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        if self.filter:
            for k in self.filter:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        result['Filter'] = []
        if self.filter is not None:
            for k in self.filter:
                result['Filter'].append(k.to_map() if k else None)
        else:
            result['Filter'] = None
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        self.filter = []
        if map.get('Filter') is not None:
            for k in map.get('Filter'):
                temp_model = DescribeRouterInterfacesRequestFilter()
                temp_model = temp_model.from_map(k)
                self.filter.append(temp_model)
        else:
            self.filter = None
        return self


class DescribeRouterInterfacesRequestFilter(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key
        self.value = value

    def validate(self):
        self.validate_required(self.key, 'key')
        self.validate_required(self.value, 'value')

    def to_map(self):
        result = {}
        result['Key'] = self.key
        result['Value'] = []
        if self.value is not None:
            for k in self.value:
                result['Value'].append(k)
        else:
            result['Value'] = None
        return result

    def from_map(self, map={}):
        self.key = map.get('Key')
        self.value = []
        if map.get('Value') is not None:
            for k in map.get('Value'):
                self.value.append(k)
        else:
            self.value = None
        return self
class DescribeRouterInterfacesResponse(TeaModel):
    def __init__(self, request_id=None, page_number=None, page_size=None, total_count=None,
                 router_interface_set=None):
        self.request_id = request_id
        self.page_number = page_number
        self.page_size = page_size
        self.total_count = total_count
        self.router_interface_set = router_interface_set

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.page_number, 'page_number')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.router_interface_set, 'router_interface_set')
        if self.router_interface_set:
            self.router_interface_set.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        result['TotalCount'] = self.total_count
        if self.router_interface_set is not None:
            result['RouterInterfaceSet'] = self.router_interface_set.to_map()
        else:
            result['RouterInterfaceSet'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        self.total_count = map.get('TotalCount')
        if map.get('RouterInterfaceSet') is not None:
            temp_model = DescribeRouterInterfacesResponseRouterInterfaceSet()
            self.router_interface_set = temp_model.from_map(map['RouterInterfaceSet'])
        else:
            self.router_interface_set = None
        return self


class DescribeRouterInterfacesResponseRouterInterfaceSetRouterInterfaceType(TeaModel):
    def __init__(self, router_interface_id=None, opposite_region_id=None, role=None, spec=None, name=None,
                 description=None, router_id=None, router_type=None, creation_time=None, end_time=None, charge_type=None,
                 status=None, business_status=None, connected_time=None, opposite_interface_id=None,
                 opposite_interface_spec=None, opposite_interface_status=None, opposite_interface_business_status=None,
                 opposite_router_id=None, opposite_router_type=None, opposite_interface_owner_id=None, access_point_id=None,
                 opposite_access_point_id=None, health_check_source_ip=None, health_check_target_ip=None):
        self.router_interface_id = router_interface_id
        self.opposite_region_id = opposite_region_id
        self.role = role
        self.spec = spec
        self.name = name
        self.description = description
        self.router_id = router_id
        self.router_type = router_type
        self.creation_time = creation_time
        self.end_time = end_time
        self.charge_type = charge_type
        self.status = status
        self.business_status = business_status
        self.connected_time = connected_time
        self.opposite_interface_id = opposite_interface_id
        self.opposite_interface_spec = opposite_interface_spec
        self.opposite_interface_status = opposite_interface_status
        self.opposite_interface_business_status = opposite_interface_business_status
        self.opposite_router_id = opposite_router_id
        self.opposite_router_type = opposite_router_type
        self.opposite_interface_owner_id = opposite_interface_owner_id
        self.access_point_id = access_point_id
        self.opposite_access_point_id = opposite_access_point_id
        self.health_check_source_ip = health_check_source_ip
        self.health_check_target_ip = health_check_target_ip

    def validate(self):
        self.validate_required(self.router_interface_id, 'router_interface_id')
        self.validate_required(self.opposite_region_id, 'opposite_region_id')
        self.validate_required(self.role, 'role')
        self.validate_required(self.spec, 'spec')
        self.validate_required(self.name, 'name')
        self.validate_required(self.description, 'description')
        self.validate_required(self.router_id, 'router_id')
        self.validate_required(self.router_type, 'router_type')
        self.validate_required(self.creation_time, 'creation_time')
        self.validate_required(self.end_time, 'end_time')
        self.validate_required(self.charge_type, 'charge_type')
        self.validate_required(self.status, 'status')
        self.validate_required(self.business_status, 'business_status')
        self.validate_required(self.connected_time, 'connected_time')
        self.validate_required(self.opposite_interface_id, 'opposite_interface_id')
        self.validate_required(self.opposite_interface_spec, 'opposite_interface_spec')
        self.validate_required(self.opposite_interface_status, 'opposite_interface_status')
        self.validate_required(self.opposite_interface_business_status, 'opposite_interface_business_status')
        self.validate_required(self.opposite_router_id, 'opposite_router_id')
        self.validate_required(self.opposite_router_type, 'opposite_router_type')
        self.validate_required(self.opposite_interface_owner_id, 'opposite_interface_owner_id')
        self.validate_required(self.access_point_id, 'access_point_id')
        self.validate_required(self.opposite_access_point_id, 'opposite_access_point_id')
        self.validate_required(self.health_check_source_ip, 'health_check_source_ip')
        self.validate_required(self.health_check_target_ip, 'health_check_target_ip')

    def to_map(self):
        result = {}
        result['RouterInterfaceId'] = self.router_interface_id
        result['OppositeRegionId'] = self.opposite_region_id
        result['Role'] = self.role
        result['Spec'] = self.spec
        result['Name'] = self.name
        result['Description'] = self.description
        result['RouterId'] = self.router_id
        result['RouterType'] = self.router_type
        result['CreationTime'] = self.creation_time
        result['EndTime'] = self.end_time
        result['ChargeType'] = self.charge_type
        result['Status'] = self.status
        result['BusinessStatus'] = self.business_status
        result['ConnectedTime'] = self.connected_time
        result['OppositeInterfaceId'] = self.opposite_interface_id
        result['OppositeInterfaceSpec'] = self.opposite_interface_spec
        result['OppositeInterfaceStatus'] = self.opposite_interface_status
        result['OppositeInterfaceBusinessStatus'] = self.opposite_interface_business_status
        result['OppositeRouterId'] = self.opposite_router_id
        result['OppositeRouterType'] = self.opposite_router_type
        result['OppositeInterfaceOwnerId'] = self.opposite_interface_owner_id
        result['AccessPointId'] = self.access_point_id
        result['OppositeAccessPointId'] = self.opposite_access_point_id
        result['HealthCheckSourceIp'] = self.health_check_source_ip
        result['HealthCheckTargetIp'] = self.health_check_target_ip
        return result

    def from_map(self, map={}):
        self.router_interface_id = map.get('RouterInterfaceId')
        self.opposite_region_id = map.get('OppositeRegionId')
        self.role = map.get('Role')
        self.spec = map.get('Spec')
        self.name = map.get('Name')
        self.description = map.get('Description')
        self.router_id = map.get('RouterId')
        self.router_type = map.get('RouterType')
        self.creation_time = map.get('CreationTime')
        self.end_time = map.get('EndTime')
        self.charge_type = map.get('ChargeType')
        self.status = map.get('Status')
        self.business_status = map.get('BusinessStatus')
        self.connected_time = map.get('ConnectedTime')
        self.opposite_interface_id = map.get('OppositeInterfaceId')
        self.opposite_interface_spec = map.get('OppositeInterfaceSpec')
        self.opposite_interface_status = map.get('OppositeInterfaceStatus')
        self.opposite_interface_business_status = map.get('OppositeInterfaceBusinessStatus')
        self.opposite_router_id = map.get('OppositeRouterId')
        self.opposite_router_type = map.get('OppositeRouterType')
        self.opposite_interface_owner_id = map.get('OppositeInterfaceOwnerId')
        self.access_point_id = map.get('AccessPointId')
        self.opposite_access_point_id = map.get('OppositeAccessPointId')
        self.health_check_source_ip = map.get('HealthCheckSourceIp')
        self.health_check_target_ip = map.get('HealthCheckTargetIp')
        return self


class DescribeRouterInterfacesResponseRouterInterfaceSet(TeaModel):
    def __init__(self, router_interface_type=None):
        self.router_interface_type = router_interface_type

    def validate(self):
        self.validate_required(self.router_interface_type, 'router_interface_type')
        if self.router_interface_type:
            for k in self.router_interface_type:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['RouterInterfaceType'] = []
        if self.router_interface_type is not None:
            for k in self.router_interface_type:
                result['RouterInterfaceType'].append(k.to_map() if k else None)
        else:
            result['RouterInterfaceType'] = None
        return result

    def from_map(self, map={}):
        self.router_interface_type = []
        if map.get('RouterInterfaceType') is not None:
            for k in map.get('RouterInterfaceType'):
                temp_model = DescribeRouterInterfacesResponseRouterInterfaceSetRouterInterfaceType()
                temp_model = temp_model.from_map(k)
                self.router_interface_type.append(temp_model)
        else:
            self.router_interface_type = None
        return self
class DeleteRouterInterfaceRequest(TeaModel):
    def __init__(self, region_id=None, router_interface_id=None, client_token=None, user_cidr=None):
        self.region_id = region_id
        self.router_interface_id = router_interface_id
        self.client_token = client_token
        self.user_cidr = user_cidr

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.router_interface_id, 'router_interface_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['RouterInterfaceId'] = self.router_interface_id
        result['ClientToken'] = self.client_token
        result['UserCidr'] = self.user_cidr
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.router_interface_id = map.get('RouterInterfaceId')
        self.client_token = map.get('ClientToken')
        self.user_cidr = map.get('UserCidr')
        return self


class DeleteRouterInterfaceResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class DeactivateRouterInterfaceRequest(TeaModel):
    def __init__(self, region_id=None, router_interface_id=None):
        self.region_id = region_id
        self.router_interface_id = router_interface_id

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.router_interface_id, 'router_interface_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['RouterInterfaceId'] = self.router_interface_id
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.router_interface_id = map.get('RouterInterfaceId')
        return self


class DeactivateRouterInterfaceResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class CreateRouterInterfaceRequest(TeaModel):
    def __init__(self, region_id=None, role=None, opposite_region_id=None, spec=None, router_type=None,
                 router_id=None, opposite_interface_id=None, opposite_router_id=None, opposite_router_type=None,
                 opposite_interface_owner_id=None, health_check_source_ip=None, health_check_target_ip=None, access_point_id=None,
                 opposite_access_point_id=None, description=None, name=None, period=None, instance_charge_type=None, auto_pay=None,
                 pricing_cycle=None, client_token=None, user_cidr=None):
        self.region_id = region_id
        self.role = role
        self.opposite_region_id = opposite_region_id
        self.spec = spec
        self.router_type = router_type
        self.router_id = router_id
        self.opposite_interface_id = opposite_interface_id
        self.opposite_router_id = opposite_router_id
        self.opposite_router_type = opposite_router_type
        self.opposite_interface_owner_id = opposite_interface_owner_id
        self.health_check_source_ip = health_check_source_ip
        self.health_check_target_ip = health_check_target_ip
        self.access_point_id = access_point_id
        self.opposite_access_point_id = opposite_access_point_id
        self.description = description
        self.name = name
        self.period = period
        self.instance_charge_type = instance_charge_type
        self.auto_pay = auto_pay
        self.pricing_cycle = pricing_cycle
        self.client_token = client_token
        self.user_cidr = user_cidr

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.role, 'role')
        self.validate_required(self.opposite_region_id, 'opposite_region_id')
        self.validate_required(self.spec, 'spec')
        self.validate_required(self.router_type, 'router_type')
        self.validate_required(self.router_id, 'router_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['Role'] = self.role
        result['OppositeRegionId'] = self.opposite_region_id
        result['Spec'] = self.spec
        result['RouterType'] = self.router_type
        result['RouterId'] = self.router_id
        result['OppositeInterfaceId'] = self.opposite_interface_id
        result['OppositeRouterId'] = self.opposite_router_id
        result['OppositeRouterType'] = self.opposite_router_type
        result['OppositeInterfaceOwnerId'] = self.opposite_interface_owner_id
        result['HealthCheckSourceIp'] = self.health_check_source_ip
        result['HealthCheckTargetIp'] = self.health_check_target_ip
        result['AccessPointId'] = self.access_point_id
        result['OppositeAccessPointId'] = self.opposite_access_point_id
        result['Description'] = self.description
        result['Name'] = self.name
        result['Period'] = self.period
        result['InstanceChargeType'] = self.instance_charge_type
        result['AutoPay'] = self.auto_pay
        result['PricingCycle'] = self.pricing_cycle
        result['ClientToken'] = self.client_token
        result['UserCidr'] = self.user_cidr
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.role = map.get('Role')
        self.opposite_region_id = map.get('OppositeRegionId')
        self.spec = map.get('Spec')
        self.router_type = map.get('RouterType')
        self.router_id = map.get('RouterId')
        self.opposite_interface_id = map.get('OppositeInterfaceId')
        self.opposite_router_id = map.get('OppositeRouterId')
        self.opposite_router_type = map.get('OppositeRouterType')
        self.opposite_interface_owner_id = map.get('OppositeInterfaceOwnerId')
        self.health_check_source_ip = map.get('HealthCheckSourceIp')
        self.health_check_target_ip = map.get('HealthCheckTargetIp')
        self.access_point_id = map.get('AccessPointId')
        self.opposite_access_point_id = map.get('OppositeAccessPointId')
        self.description = map.get('Description')
        self.name = map.get('Name')
        self.period = map.get('Period')
        self.instance_charge_type = map.get('InstanceChargeType')
        self.auto_pay = map.get('AutoPay')
        self.pricing_cycle = map.get('PricingCycle')
        self.client_token = map.get('ClientToken')
        self.user_cidr = map.get('UserCidr')
        return self


class CreateRouterInterfaceResponse(TeaModel):
    def __init__(self, request_id=None, router_interface_id=None, order_id=None):
        self.request_id = request_id
        self.router_interface_id = router_interface_id
        self.order_id = order_id

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.router_interface_id, 'router_interface_id')
        self.validate_required(self.order_id, 'order_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['RouterInterfaceId'] = self.router_interface_id
        result['OrderId'] = self.order_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.router_interface_id = map.get('RouterInterfaceId')
        self.order_id = map.get('OrderId')
        return self


class ConnectRouterInterfaceRequest(TeaModel):
    def __init__(self, region_id=None, router_interface_id=None):
        self.region_id = region_id
        self.router_interface_id = router_interface_id

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.router_interface_id, 'router_interface_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['RouterInterfaceId'] = self.router_interface_id
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.router_interface_id = map.get('RouterInterfaceId')
        return self


class ConnectRouterInterfaceResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class ActivateRouterInterfaceRequest(TeaModel):
    def __init__(self, region_id=None, router_interface_id=None):
        self.region_id = region_id
        self.router_interface_id = router_interface_id

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.router_interface_id, 'router_interface_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['RouterInterfaceId'] = self.router_interface_id
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.router_interface_id = map.get('RouterInterfaceId')
        return self


class ActivateRouterInterfaceResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class UnassociateHaVipRequest(TeaModel):
    def __init__(self, client_token=None, region_id=None, ha_vip_id=None, instance_id=None, force=None):
        self.client_token = client_token
        self.region_id = region_id
        self.ha_vip_id = ha_vip_id
        self.instance_id = instance_id
        self.force = force

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.ha_vip_id, 'ha_vip_id')
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = {}
        result['ClientToken'] = self.client_token
        result['RegionId'] = self.region_id
        result['HaVipId'] = self.ha_vip_id
        result['InstanceId'] = self.instance_id
        result['Force'] = self.force
        return result

    def from_map(self, map={}):
        self.client_token = map.get('ClientToken')
        self.region_id = map.get('RegionId')
        self.ha_vip_id = map.get('HaVipId')
        self.instance_id = map.get('InstanceId')
        self.force = map.get('Force')
        return self


class UnassociateHaVipResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class ModifyHaVipAttributeRequest(TeaModel):
    def __init__(self, client_token=None, region_id=None, ha_vip_id=None, description=None):
        self.client_token = client_token
        self.region_id = region_id
        self.ha_vip_id = ha_vip_id
        self.description = description

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.ha_vip_id, 'ha_vip_id')

    def to_map(self):
        result = {}
        result['ClientToken'] = self.client_token
        result['RegionId'] = self.region_id
        result['HaVipId'] = self.ha_vip_id
        result['Description'] = self.description
        return result

    def from_map(self, map={}):
        self.client_token = map.get('ClientToken')
        self.region_id = map.get('RegionId')
        self.ha_vip_id = map.get('HaVipId')
        self.description = map.get('Description')
        return self


class ModifyHaVipAttributeResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class DescribeHaVipsRequest(TeaModel):
    def __init__(self, region_id=None, page_number=None, page_size=None, filter=None):
        self.region_id = region_id
        self.page_number = page_number
        self.page_size = page_size
        self.filter = filter

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.filter, 'filter')
        if self.filter:
            for k in self.filter:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        result['Filter'] = []
        if self.filter is not None:
            for k in self.filter:
                result['Filter'].append(k.to_map() if k else None)
        else:
            result['Filter'] = None
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        self.filter = []
        if map.get('Filter') is not None:
            for k in map.get('Filter'):
                temp_model = DescribeHaVipsRequestFilter()
                temp_model = temp_model.from_map(k)
                self.filter.append(temp_model)
        else:
            self.filter = None
        return self


class DescribeHaVipsRequestFilter(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key
        self.value = value

    def validate(self):
        self.validate_required(self.key, 'key')
        self.validate_required(self.value, 'value')

    def to_map(self):
        result = {}
        result['Key'] = self.key
        result['Value'] = []
        if self.value is not None:
            for k in self.value:
                result['Value'].append(k)
        else:
            result['Value'] = None
        return result

    def from_map(self, map={}):
        self.key = map.get('Key')
        self.value = []
        if map.get('Value') is not None:
            for k in map.get('Value'):
                self.value.append(k)
        else:
            self.value = None
        return self
class DescribeHaVipsResponse(TeaModel):
    def __init__(self, request_id=None, total_count=None, page_number=None, page_size=None, ha_vips=None):
        self.request_id = request_id
        self.total_count = total_count
        self.page_number = page_number
        self.page_size = page_size
        self.ha_vips = ha_vips

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.page_number, 'page_number')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.ha_vips, 'ha_vips')
        if self.ha_vips:
            self.ha_vips.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['TotalCount'] = self.total_count
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        if self.ha_vips is not None:
            result['HaVips'] = self.ha_vips.to_map()
        else:
            result['HaVips'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.total_count = map.get('TotalCount')
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        if map.get('HaVips') is not None:
            temp_model = DescribeHaVipsResponseHaVips()
            self.ha_vips = temp_model.from_map(map['HaVips'])
        else:
            self.ha_vips = None
        return self


class DescribeHaVipsResponseHaVipsHaVipAssociatedInstances(TeaModel):
    def __init__(self, associated_instance=None):
        # associatedInstance
        self.associated_instance = associated_instance

    def validate(self):
        self.validate_required(self.associated_instance, 'associated_instance')

    def to_map(self):
        result = {}
        result['associatedInstance'] = []
        if self.associated_instance is not None:
            for k in self.associated_instance:
                result['associatedInstance'].append(k)
        else:
            result['associatedInstance'] = None
        return result

    def from_map(self, map={}):
        self.associated_instance = []
        if map.get('associatedInstance') is not None:
            for k in map.get('associatedInstance'):
                self.associated_instance.append(k)
        else:
            self.associated_instance = None
        return self


class DescribeHaVipsResponseHaVipsHaVipAssociatedEipAddresses(TeaModel):
    def __init__(self, associated_eip_addresse=None):
        # associatedEipAddresse
        self.associated_eip_addresse = associated_eip_addresse

    def validate(self):
        self.validate_required(self.associated_eip_addresse, 'associated_eip_addresse')

    def to_map(self):
        result = {}
        result['associatedEipAddresse'] = []
        if self.associated_eip_addresse is not None:
            for k in self.associated_eip_addresse:
                result['associatedEipAddresse'].append(k)
        else:
            result['associatedEipAddresse'] = None
        return result

    def from_map(self, map={}):
        self.associated_eip_addresse = []
        if map.get('associatedEipAddresse') is not None:
            for k in map.get('associatedEipAddresse'):
                self.associated_eip_addresse.append(k)
        else:
            self.associated_eip_addresse = None
        return self


class DescribeHaVipsResponseHaVipsHaVip(TeaModel):
    def __init__(self, ha_vip_id=None, region_id=None, vpc_id=None, v_switch_id=None, ip_address=None, status=None,
                 master_instance_id=None, description=None, create_time=None, associated_instances=None,
                 associated_eip_addresses=None):
        self.ha_vip_id = ha_vip_id
        self.region_id = region_id
        self.vpc_id = vpc_id
        self.v_switch_id = v_switch_id
        self.ip_address = ip_address
        self.status = status
        self.master_instance_id = master_instance_id
        self.description = description
        self.create_time = create_time
        self.associated_instances = associated_instances
        self.associated_eip_addresses = associated_eip_addresses

    def validate(self):
        self.validate_required(self.ha_vip_id, 'ha_vip_id')
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.vpc_id, 'vpc_id')
        self.validate_required(self.v_switch_id, 'v_switch_id')
        self.validate_required(self.ip_address, 'ip_address')
        self.validate_required(self.status, 'status')
        self.validate_required(self.master_instance_id, 'master_instance_id')
        self.validate_required(self.description, 'description')
        self.validate_required(self.create_time, 'create_time')
        self.validate_required(self.associated_instances, 'associated_instances')
        if self.associated_instances:
            self.associated_instances.validate()
        self.validate_required(self.associated_eip_addresses, 'associated_eip_addresses')
        if self.associated_eip_addresses:
            self.associated_eip_addresses.validate()

    def to_map(self):
        result = {}
        result['HaVipId'] = self.ha_vip_id
        result['RegionId'] = self.region_id
        result['VpcId'] = self.vpc_id
        result['VSwitchId'] = self.v_switch_id
        result['IpAddress'] = self.ip_address
        result['Status'] = self.status
        result['MasterInstanceId'] = self.master_instance_id
        result['Description'] = self.description
        result['CreateTime'] = self.create_time
        if self.associated_instances is not None:
            result['AssociatedInstances'] = self.associated_instances.to_map()
        else:
            result['AssociatedInstances'] = None
        if self.associated_eip_addresses is not None:
            result['AssociatedEipAddresses'] = self.associated_eip_addresses.to_map()
        else:
            result['AssociatedEipAddresses'] = None
        return result

    def from_map(self, map={}):
        self.ha_vip_id = map.get('HaVipId')
        self.region_id = map.get('RegionId')
        self.vpc_id = map.get('VpcId')
        self.v_switch_id = map.get('VSwitchId')
        self.ip_address = map.get('IpAddress')
        self.status = map.get('Status')
        self.master_instance_id = map.get('MasterInstanceId')
        self.description = map.get('Description')
        self.create_time = map.get('CreateTime')
        if map.get('AssociatedInstances') is not None:
            temp_model = DescribeHaVipsResponseHaVipsHaVipAssociatedInstances()
            self.associated_instances = temp_model.from_map(map['AssociatedInstances'])
        else:
            self.associated_instances = None
        if map.get('AssociatedEipAddresses') is not None:
            temp_model = DescribeHaVipsResponseHaVipsHaVipAssociatedEipAddresses()
            self.associated_eip_addresses = temp_model.from_map(map['AssociatedEipAddresses'])
        else:
            self.associated_eip_addresses = None
        return self


class DescribeHaVipsResponseHaVips(TeaModel):
    def __init__(self, ha_vip=None):
        self.ha_vip = ha_vip

    def validate(self):
        self.validate_required(self.ha_vip, 'ha_vip')
        if self.ha_vip:
            for k in self.ha_vip:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['HaVip'] = []
        if self.ha_vip is not None:
            for k in self.ha_vip:
                result['HaVip'].append(k.to_map() if k else None)
        else:
            result['HaVip'] = None
        return result

    def from_map(self, map={}):
        self.ha_vip = []
        if map.get('HaVip') is not None:
            for k in map.get('HaVip'):
                temp_model = DescribeHaVipsResponseHaVipsHaVip()
                temp_model = temp_model.from_map(k)
                self.ha_vip.append(temp_model)
        else:
            self.ha_vip = None
        return self
class DeleteHaVipRequest(TeaModel):
    def __init__(self, client_token=None, region_id=None, ha_vip_id=None):
        self.client_token = client_token
        self.region_id = region_id
        self.ha_vip_id = ha_vip_id

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.ha_vip_id, 'ha_vip_id')

    def to_map(self):
        result = {}
        result['ClientToken'] = self.client_token
        result['RegionId'] = self.region_id
        result['HaVipId'] = self.ha_vip_id
        return result

    def from_map(self, map={}):
        self.client_token = map.get('ClientToken')
        self.region_id = map.get('RegionId')
        self.ha_vip_id = map.get('HaVipId')
        return self


class DeleteHaVipResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.reque