"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MutualTlsCertificate = exports.TlsCertificate = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Represents a TLS certificate
 */
class TlsCertificate {
    /**
     * Returns an File TLS Certificate
     */
    static file(certificateChainPath, privateKeyPath) {
        return new FileTlsCertificate(certificateChainPath, privateKeyPath);
    }
    /**
     * Returns an ACM TLS Certificate
     */
    static acm(certificate) {
        return new AcmTlsCertificate(certificate);
    }
    /**
     * Returns an SDS TLS Certificate
     */
    static sds(secretName) {
        return new SdsTlsCertificate(secretName);
    }
}
exports.TlsCertificate = TlsCertificate;
_a = JSII_RTTI_SYMBOL_1;
TlsCertificate[_a] = { fqn: "@aws-cdk/aws-appmesh.TlsCertificate", version: "1.191.0" };
/**
 * Represents a TLS certificate that is supported for mutual TLS authentication.
 */
class MutualTlsCertificate extends TlsCertificate {
    constructor() {
        super(...arguments);
        // TypeScript uses structural typing, so we need a property different from TlsCertificate
        this.differentiator = false;
    }
}
exports.MutualTlsCertificate = MutualTlsCertificate;
_b = JSII_RTTI_SYMBOL_1;
MutualTlsCertificate[_b] = { fqn: "@aws-cdk/aws-appmesh.MutualTlsCertificate", version: "1.191.0" };
/**
 * Represents a ACM provided TLS certificate
 */
class AcmTlsCertificate extends TlsCertificate {
    constructor(certificate) {
        super();
        this.acmCertificate = certificate;
    }
    bind(_scope) {
        return {
            tlsCertificate: {
                acm: {
                    certificateArn: this.acmCertificate.certificateArn,
                },
            },
        };
    }
}
/**
 * Represents a file provided TLS certificate
 */
class FileTlsCertificate extends MutualTlsCertificate {
    constructor(certificateChainPath, privateKeyPath) {
        super();
        this.certificateChain = certificateChainPath;
        this.privateKey = privateKeyPath;
    }
    bind(_scope) {
        return {
            tlsCertificate: {
                file: {
                    certificateChain: this.certificateChain,
                    privateKey: this.privateKey,
                },
            },
        };
    }
}
/**
 * Represents a SDS provided TLS certificate
 */
class SdsTlsCertificate extends MutualTlsCertificate {
    constructor(secretName) {
        super();
        this.secretName = secretName;
    }
    bind(_scope) {
        return {
            tlsCertificate: {
                sds: {
                    secretName: this.secretName,
                },
            },
        };
    }
}
//# sourceMappingURL=data:application/json;base64,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