[![aiida-core](https://img.shields.io/badge/AiiDA->=v1.6.4,<3.0.0-1f425f.svg?logo=data%3Aimage%2Fpng%3Bbase64%2CiVBORw0KGgoAAAANSUhEUgAAACMAAAAhCAYAAABTERJSAAAABHNCSVQICAgIfAhkiAAAAAlwSFlzAAAFhgAABYYBG6Yz4AAAABl0RVh0U29mdHdhcmUAd3d3Lmlua3NjYXBlLm9yZ5vuPBoAAAUbSURBVFiFzZhrbFRVEMd%2Fc%2B5uu6UUbIFC%2FUAUVEQCLbQJBIiBDyiImJiIhmohYNCkqJAQxASLF8tDgYRHBLXRhIcKNtFEhVDgAxBJqgmVh4JEKg3EIn2QYqBlt917xg%2BFss%2ByaDHOtzsz5z%2B%2FuZl7ztmF%2F5HJvxVQN6cPYX8%2FPLnOmsvNAvqfwuib%2FbNIk9cQeQnLcKRL5xLIV%2Fic9eJeunjPYbRs4FjQSpTB3aS1IpRKeeOOewajy%2FKKEO8Q0DuVdKy8IqsbPulxGHUfCBBu%2BwUYGuFuBTK7wQnht6PEbf4tlRomVRjCbXNjQEB0AyrFQOL5ENIJm7dTLZE6DPJCnEtFZVXDLny%2B4Sjv0PmmYu1ZdUek9RiMgoDmJ8V0L7XJqsZ3UW8YsBOwEeHeeFce7jEYXBy0m9m4BbXqSj2%2Bxnkg26MCVrN6DEZcwggtd8pTFx%2Fh3B9B50YLaFOPwXQKUt0tBLegtSomfBlfY13PwijbEnhztGzgJsK5h9W9qeWwBqjvyhB2iBs1Qz0AU974DciRGO8CVN8AJhAeMAdA3KbrKEtvxhsI%2B9emWiJlGBEU680Cfk%2BSsVqXZvcFYGXjF8ABVJ%2BTNfVXehyms1zzn1gmIOxLEB6E31%2FWBe5rnCarmo7elf7dJEeaLh80GasliI5F6Q9cAz1GY1OJVNDxTzQTw7iY%2FHEZRQY7xqJ9RU2LFe%2FYqakdP911ha0XhjjiTVAkDwgatWfCGeYocx8M3glG8g8EXhSrLrHnEFJ5Ymow%2FkhIYv6ttYUW1iFmEqqxdVoUs9FmsDYSqmtmJh3Cl1%2BVtl2s7owDUdocR5bceiyoSivGTT5vzpbzL1uoBpmcAAQgW7ArnKD9ng9rc%2BNgrobSNwpSkkhcRN%2BvmXLjIsDovYHHEfmsYFygPAnIDEQrQPzJYCOaLHLUfIt7Oq0LJn9fxkSgNCb1qEIQ5UKgT%2Fs6gJmVOOroJhQBXVqw118QtWLdyUxEP45sUpSzqP7RDdFYMyB9UReMiF1MzPwoUqHt8hjGFFeP5wZAbZ%2F0%2BcAtAAcji6LeSq%2FMYiAvSsdw3GtrfVSVFUBbIhwRWYR7yOcr%2FBi%2FB1MSJZ16JlgH1AGM3EO2QnmMyrSbTSiACgFBv4yCUapZkt9qwWVL7aeOyHvArJjm8%2Fz9BhdI4XcZgz2%2FvRALosjsk1ODOyMcJn9%2FYI6IrkS5vxMGdUwou2YKfyVqJpn5t9aNs3gbQMbdbkxnGdsr4bTHm2AxWo9yNZK4PXR3uzhAh%2BM0AZejnCrGdy0UvJxl0oMKgWSLR%2B1LH2aE9ViejiFs%2BXn6bTjng3MlIhJ1I1TkuLdg6OcAbD7Xx%2Bc3y9TrWAiSHqVkbZ2v9ilCo6s4AjwZCzFyD9mOL305nV9aonvsQeT2L0gVk4OwOJqXXVRW7naaxswDKVdlYLyMXAnntteYmws2xcVVZzq%2BtHPAooQggmJkc6TLSusOiL4RKgwzzYU1iFQgiUBA1H7E8yPau%2BZl9P7AblVNebtHqTgxLfRqrNvZWjsHZFuqMqKcDWdlFjF7UGvX8Jn24DyEAykJwNcdg0OvJ4p5pQ9tV6SMlP4A0PNh8aYze1ArROyUNTNouy8tNF3Rt0CSXb6bRFl4%2FIfQzNMjaE9WwpYOWQnOdEF%2BTdJNO0iFh7%2BI0kfORzQZb6P2kymS9oTxzBiM9rUqLWr1WE5G6ODhycQd%2FUnNVeMbcH68hYkGycNoUNWc8fxaxfwhDbHpfwM5oeTY7rUX8QAAAABJRU5ErkJggg%3D%3D)](https://www.aiida.net/)
[![Documentation Status](https://readthedocs.org/projects/aiida-kkr/badge/?version=latest)](https://aiida-kkr.readthedocs.io/en/latest/?badge=latest)
[![Build status](https://github.com/JuDFTteam/aiida-kkr/actions/workflows/ci.yml/badge.svg)](https://github.com/JuDFTteam/aiida-kkr/actions)
[![codecov](https://codecov.io/gh/JuDFTteam/aiida-kkr/branch/develop/graph/badge.svg)](https://codecov.io/gh/JuDFTteam/aiida-kkr)
[![MIT license](http://img.shields.io/badge/license-MIT-brightgreen.svg)](http://opensource.org/licenses/MIT)
[![GitHub version](https://badge.fury.io/gh/JuDFTteam%2Faiida-kkr.svg)](https://badge.fury.io/gh/JuDFTteam%2Faiida-kkr)
[![PyPI version](https://badge.fury.io/py/aiida-kkr.svg)](https://badge.fury.io/py/aiida-kkr)
[![DOI](https://zenodo.org/badge/DOI/10.5281/zenodo.3628251.svg)](https://doi.org/10.5281/zenodo.3628251)



# aiida-kkr

[AiiDA](https://aiida.net) plugin for the [Jülich KKR codes](https://jukkr.fz-juelich.de) plus workflows and utility.

## Features

* KKR calculations for bulk and interfaces
* treatment of alloys using VCA or CPA
* self-consistency, DOS and bandstructure calculations
* extraction of magnetic exchange coupling parameters (*J_ij*, *D_ij*)
* impurity embedding solving the Dyson equation


## How to cite

If you use this plugin please cite:
> [Rüßmann, P., Bertoldo, F. & Blügel, S. The AiiDA-KKR plugin and its application to high-throughput impurity embedding into a topological insulator. *npj Comput Mater* **7**, 13 (2021). https://doi.org/10.1038/s41524-020-00482-5](https://doi.org/10.1038/s41524-020-00482-5)

The ArXiv preprint can be found here:
> [Philipp Rüßmann, Fabian Bertoldo and Stefan Blügel, *The AiiDA-KKR plugin and its application to high-throughput impurity embedding into a topological insulator*, arXiv:2003.08315 [cond-mat.mtrl-sci] (2020)](https://arxiv.org/abs/2003.08315)


# Installation

```shell
$ pip install aiida-kkr  # install latest version of aiida-kkr (published on pypi.org)
$ reentry scan -r aiida  # update entry points, needed in order to find kkr.* entrypoints in aiida

# setupt aiida if this was not done already:
$ verdi quicksetup  # better to set up a new profile
$ verdi calculation plugins  # should now show kkr.* entrypoints
```

To install the developer version download the repository and install the downloaded version (see `setup.json` for a list of optional packages that are installed with the extras given in `[]`)

```shell
$ git clone https://github.com/JuDFTteam/aiida-kkr.git
$ pip install -e aiida-kkr[testing,devtools,docs]
$ reentry scan -r aiida
```

## Remarks about dependencies and extras

- The `aiida-kkr` plugin uses the `ase` and `pymatgen` packages for structure conversions.
- For `aiida-core>=1.5,<1.6` make sure to use the requirements specified in `requirements_aiida-core_1.5.txt` (use `pip install -r requirements_aiida-core_1.5.txt aiida-kkr` for the installation to overwrite the aiida-core dependency).
- Other extras that can be optionally installed with `aiida-kkr` are
  * `pre-commit` which installes the pre-commit hooks that allow style (`yapf`) and static code checking (`pylint`)
  * `testing` which installs `pytest` and all extension used in the tests
  * `docs` which installs `Sphinx` to build the documentation
  * `devtools` which installs tools that might be helpful during development


# Usage and Documentation

* see http://aiida-kkr.readthedocs.io for user's guide and API reference.
* check out http://judft.de and https://jukkr.fz-juelich.de for information of the KKR codes used by the plugin

# Contributing

Thank you for your interest in contributing to aiida-kkr.
Check out our [contributing guide](CONTRIBUTING.md) for some information.
