# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['autorequests', 'autorequests.classes', 'autorequests.utilities']

package_data = \
{'': ['*']}

install_requires = \
['rich>=10.0.0,<11.0.0']

entry_points = \
{'console_scripts': ['autorequests = autorequests:main']}

setup_kwargs = {
    'name': 'autorequests',
    'version': '1.1.0',
    'description': 'Automatically create a simple API wrapper from request data generated by your browser.',
    'long_description': "# AutoRequests\n\nAutoRequests provides an easy way to create a simple API wrapper from request data generated by your browser.\n\n![BUILT WITH SWAG](https://forthebadge.com/images/badges/built-with-swag.svg)\n![NOT A BUG A FEATURE](https://forthebadge.com/images/badges/not-a-bug-a-feature.svg)\n![IT WORKS. WHY?](https://forthebadge.com/images/badges/it-works-why.svg)\n\n### 📺 Demo\n\n** the website shown in this example is [imperialb.in](https://imperialb.in)\n![example showcase gif](https://i.imgur.com/75tMMIW.gif)\n\n### 💼 Example Use Cases\n\n* Creating a foundation for an API wrapper\n* Recreating a request outside the browser\n* Testing what cookies or headers are required for a server to understand your request\n\n### ✂️ How to Copy\n\n1.  Inspect Element\n2.  Go to `Network` tab\n3.  Find web request\n4.  Right-Click\n5.  Copy\n6.  Choose one of the following:\n     1. Powershell \n     2. Node.JS fetch\n\n## 📦 Installation\n\ninstall the package with pip\n\n```\n$ pip install autorequests\n```\n\nor download the latest development build from GitHub\n\n```\n$ pip install -U git+https://github.com/Hexiro/autorequests\n```\n\n## 🖥️ Command Line\n\n```console\n$ autorequests --help\n```\n\ndirectory options\n\n```console\n  -i, --input           Input Directory\n  -o, --output          Output Directory\n```\n\ngeneration options\n\n```\n  --return-text         Makes the generated method's responses return .text instead of .json()\n  --no-headers          Removes all headers from the operation\n  --no-cookies          Removes all cookies from the operation\n  --parameters          Replaces hardcoded params, json, data, etc with parameters that have default values\n```\n\n## 🚩 Known Issues\n\n* Method names are parsed from the url, but if the URL doesn't have any paths with a valid method name, an invalid\n  method name will be used.\n* Sometimes when copying from the browser, important headers aren't included which causes the resulting API\n  wrapper to fail requests.\n* Parsing multipart/form-data when copying with the powershell mode isn't supported\n\n## 🐞 Contributing\n\nsee [CONTRIBUTING.md](./CONTRIBUTING.md)\n\n\n## 📅 # TODO\n* unit tests w/ pytest\n* clean up cli\n* replace ***--compare*** with ***--diff*** which shows diffs in console\n* better output w/ rich\n* possibly decouple method & class ?",
    'author': 'Hexiro',
    'author_email': None,
    'maintainer': None,
    'maintainer_email': None,
    'url': None,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
