import { Test } from 'nodeunit';
declare const _default: {
    'can declare a manifest with a token from a different stack than the cluster that depends on the cluster stack'(test: Test): void;
    'can declare a chart with a token from a different stack than the cluster that depends on the cluster stack'(test: Test): void;
    'can declare a HelmChart in a different stack than the cluster'(test: Test): void;
    'throws when declaring an ASG role in a different stack than the cluster'(test: Test): void;
    'can declare a ServiceAccount in a different stack than the cluster'(test: Test): void;
    'a default cluster spans all subnets'(test: Test): void;
    'create custom cluster correctly in any aws region'(test: Test): void;
    'create custom cluster correctly in any aws region in china'(test: Test): void;
    'if "vpc" is not specified, vpc with default configuration will be created'(test: Test): void;
    'default capacity': {
        'x2 m5.large by default'(test: Test): void;
        'quantity and type can be customized'(test: Test): void;
        'defaultCapacity=0 will not allocate at all'(test: Test): void;
    };
    'creating a cluster tags the private VPC subnets'(test: Test): void;
    'creating a cluster tags the public VPC subnets'(test: Test): void;
    'adding capacity creates an ASG without a rolling update policy'(test: Test): void;
    'adding capacity creates an ASG with tags'(test: Test): void;
    'create nodegroup with existing role'(test: Test): void;
    'adding bottlerocket capacity creates an ASG with tags'(test: Test): void;
    'adding bottlerocket capacity with bootstrapOptions throws error'(test: Test): void;
    'exercise export/import'(test: Test): void;
    'mastersRole can be used to map an IAM role to "system:masters"'(test: Test): void;
    'addManifest can be used to apply k8s manifests on this cluster'(test: Test): void;
    'kubectl resources can be created in a separate stack'(test: Test): void;
    'adding capacity will automatically map its IAM role'(test: Test): void;
    'addCapacity will *not* map the IAM role if mapRole is false'(test: Test): void;
    outputs: {
        'aws eks update-kubeconfig is the only output synthesized by default'(test: Test): void;
        'if masters role is defined, it should be included in the config command'(test: Test): void;
        'if `outputConfigCommand=false` will disabled the output'(test: Test): void;
        '`outputClusterName` can be used to synthesize an output with the cluster name'(test: Test): void;
        '`outputMastersRoleArn` can be used to synthesize an output with the arn of the masters role if defined'(test: Test): void;
        'boostrap user-data': {
            'rendered by default for ASGs'(test: Test): void;
            'not rendered if bootstrap is disabled'(test: Test): void;
            'bootstrap options'(test: Test): void;
            'spot instances': {
                'nodes labeled an tainted accordingly'(test: Test): void;
                'interrupt handler is added'(test: Test): void;
                'its possible to add two capacities with spot instances and only one stop handler will be installed'(test: Test): void;
            };
        };
        'if bootstrap is disabled cannot specify options'(test: Test): void;
        'EksOptimizedImage() with no nodeType always uses STANDARD with LATEST_KUBERNETES_VERSION'(test: Test): void;
        'EksOptimizedImage() with specific kubernetesVersion return correct AMI'(test: Test): void;
        'EKS-Optimized AMI with GPU support when addCapacity'(test: Test): void;
        'when using custom resource a creation role & policy is defined'(test: Test): void;
        'if an explicit cluster name is not provided, the creation role policy is wider (allows interacting with all clusters)'(test: Test): void;
        'if helm charts are used, the provider role is allowed to assume the creation role'(test: Test): void;
        'coreDnsComputeType will patch the coreDNS configuration to use a "fargate" compute type and restore to "ec2" upon removal'(test: Test): void;
        'if openIDConnectProvider a new OpenIDConnectProvider resource is created and exposed'(test: Test): void;
        'inference instances are supported'(test: Test): void;
        'kubectl resources are always created after all fargate profiles'(test: Test): void;
        'kubectl provider role can assume creation role'(test: Test): void;
    };
    'kubectl provider passes environment to lambda'(test: Test): void;
    'endpoint access': {
        'private endpoint access fails if selected subnets are empty'(test: Test): void;
        'private endpoint access selects only private subnets from looked up vpc'(test: Test): void;
        'private endpoint access considers specific subnet selection'(test: Test): void;
        'can configure private endpoint access'(test: Test): void;
        'can configure cidr blocks in public endpoint access'(test: Test): void;
        'kubectl provider chooses only private subnets'(test: Test): void;
        'kubectl provider limits number of subnets to 16'(test: Test): void;
        'kubectl provider considers vpc subnet selection'(test: Test): void;
        'throw when private access is configured without dns support enabled for the VPC'(test: Test): void;
        'throw when private access is configured without dns hostnames enabled for the VPC'(test: Test): void;
        'throw when cidrs are configured without public access endpoint'(test: Test): void;
    };
    getServiceLoadBalancerAddress(test: Test): void;
    'custom kubectl layer can be provided'(test: Test): void;
    'SAR-based kubectl layer can be customized'(test: Test): void;
    'create a cluster using custom resource with secrets encryption using KMS CMK'(test: Test): void;
};
export = _default;
