"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.KubernetesObjectValue = void 0;
const core_1 = require("@aws-cdk/core");
const kubectl_provider_1 = require("./kubectl-provider");
/**
 * Represents a value of a specific object deployed in the cluster.
 * Use this to fetch any information available by the `kubectl get` command.
 */
class KubernetesObjectValue extends core_1.Construct {
    constructor(scope, id, props) {
        var _a, _b;
        super(scope, id);
        const provider = kubectl_provider_1.KubectlProvider.getOrCreate(this, props.cluster);
        this._resource = new core_1.CustomResource(this, 'Resource', {
            resourceType: KubernetesObjectValue.RESOURCE_TYPE,
            serviceToken: provider.serviceToken,
            properties: {
                ClusterName: props.cluster.clusterName,
                RoleArn: provider.roleArn,
                ObjectType: props.objectType,
                ObjectName: props.objectName,
                ObjectNamespace: (_a = props.objectNamespace) !== null && _a !== void 0 ? _a : 'default',
                JsonPath: props.jsonPath,
                TimeoutSeconds: ((_b = props === null || props === void 0 ? void 0 : props.timeout) !== null && _b !== void 0 ? _b : core_1.Duration.minutes(5)).toSeconds(),
            },
        });
    }
    /**
     * The value as a string token.
     */
    get value() {
        return core_1.Token.asString(this._resource.getAtt('Value'));
    }
}
exports.KubernetesObjectValue = KubernetesObjectValue;
/**
 * The CloudFormation reosurce type.
 */
KubernetesObjectValue.RESOURCE_TYPE = 'Custom::AWSCDK-EKS-KubernetesObjectValue';
//# sourceMappingURL=data:application/json;base64,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