"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.HelmChart = void 0;
const core_1 = require("@aws-cdk/core");
const kubectl_provider_1 = require("./kubectl-provider");
/**
 * Represents a helm chart within the Kubernetes system.
 *
 * Applies/deletes the resources using `kubectl` in sync with the resource.
 */
class HelmChart extends core_1.Construct {
    constructor(scope, id, props) {
        var _a, _b, _c, _d, _e;
        super(scope, id);
        const stack = core_1.Stack.of(this);
        const provider = kubectl_provider_1.KubectlProvider.getOrCreate(this, props.cluster);
        const timeout = (_a = props.timeout) === null || _a === void 0 ? void 0 : _a.toSeconds();
        if (timeout && timeout > 900) {
            throw new Error('Helm chart timeout cannot be higher than 15 minutes.');
        }
        // default not to wait
        const wait = (_b = props.wait) !== null && _b !== void 0 ? _b : false;
        // default to create new namespace
        const createNamespace = (_c = props.createNamespace) !== null && _c !== void 0 ? _c : true;
        new core_1.CustomResource(this, 'Resource', {
            serviceToken: provider.serviceToken,
            resourceType: HelmChart.RESOURCE_TYPE,
            properties: {
                ClusterName: props.cluster.clusterName,
                RoleArn: provider.roleArn,
                Release: (_d = props.release) !== null && _d !== void 0 ? _d : this.node.uniqueId.slice(-53).toLowerCase(),
                Chart: props.chart,
                Version: props.version,
                Wait: wait || undefined,
                Timeout: timeout ? `${timeout.toString()}s` : undefined,
                Values: (props.values ? stack.toJsonString(props.values) : undefined),
                Namespace: (_e = props.namespace) !== null && _e !== void 0 ? _e : 'default',
                Repository: props.repository,
                CreateNamespace: createNamespace || undefined,
            },
        });
    }
}
exports.HelmChart = HelmChart;
/**
 * The CloudFormation resource type.
 */
HelmChart.RESOURCE_TYPE = 'Custom::AWSCDK-EKS-HelmChart';
//# sourceMappingURL=data:application/json;base64,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