# Generated by Django 2.1.7 on 2019-02-20 20:52

# Changes to the file generated automatically "by Django 2.1.7 on 2019-02-20 20:52"
#   - Reorder fields (PostgreSQL does not support columns reordering after they are created).
#   - Whitespace changes for readability.
#   - Add '# noqa' declarations to comply with flake8 rules.

from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import uuid


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='User',
            fields=[
                (
                    'id',
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False
                    )
                ),
                (
                    'email_address',
                    models.EmailField(
                        error_messages={
                            'unique': 'A user with that email address already exists.'
                        },
                        max_length=254,
                        unique=True
                    )
                ),
                (
                    'password',
                    models.CharField(
                        max_length=128,
                        verbose_name='password'
                    )
                ),
                (
                    'is_superuser',
                    models.BooleanField(
                        default=False,
                        help_text='Designates that this user has all permissions without explicitly assigning them.'  # noqa: E501
                    )
                ),
                (
                    'is_staff',
                    models.BooleanField(
                        default=False,
                        help_text='Designates whether the user can log into this admin site.'
                    )
                ),
                (
                    'is_active',
                    models.BooleanField(
                        default=True,
                        help_text='Whether this user should be treated as enabled. Deactivate a user account instead of deleting it.'  # noqa: E501
                    )
                ),
                (
                    'deactivated_at',
                    models.DateTimeField(
                        blank=True,
                        null=True
                    )
                ),
                (
                    'created_at',
                    models.DateTimeField(
                        default=django.utils.timezone.now
                    )
                ),
                (
                    'created_by',
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name='users_created',
                        to='fd_dj_accounts.User'
                    )
                ),
                (
                    'last_login',
                    models.DateTimeField(
                        blank=True,
                        null=True,
                        verbose_name='last login'
                    )
                ),
            ],
            options={
                'verbose_name': 'user',
                'verbose_name_plural': 'users',
                'abstract': False,
            },
        ),
    ]
