from collections.abc import Mapping
from typing import Any, TypeVar

from attrs import define as _attrs_define
from attrs import field as _attrs_field

T = TypeVar("T", bound="FilterInfoResponseFlatWizardFilterSettingsBinning")


@_attrs_define
class FilterInfoResponseFlatWizardFilterSettingsBinning:
    """
    Attributes:
        name (str):
        x (int):
        y (int):
    """

    name: str
    x: int
    y: int
    additional_properties: dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> dict[str, Any]:
        name = self.name

        x = self.x

        y = self.y

        field_dict: dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update(
            {
                "Name": name,
                "X": x,
                "Y": y,
            }
        )

        return field_dict

    @classmethod
    def from_dict(cls: type[T], src_dict: Mapping[str, Any]) -> T:
        d = dict(src_dict)
        name = d.pop("Name")

        x = d.pop("X")

        y = d.pop("Y")

        filter_info_response_flat_wizard_filter_settings_binning = cls(
            name=name,
            x=x,
            y=y,
        )

        filter_info_response_flat_wizard_filter_settings_binning.additional_properties = d
        return filter_info_response_flat_wizard_filter_settings_binning

    @property
    def additional_keys(self) -> list[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
