"""Contains all the data models used in inputs/outputs"""

from .camera_info import CameraInfo
from .camera_info_response import CameraInfoResponse
from .camera_info_response_binning_modes_item import CameraInfoResponseBinningModesItem
from .camera_info_response_camera_state import CameraInfoResponseCameraState
from .camera_info_response_sensor_type import CameraInfoResponseSensorType
from .device_list import DeviceList
from .device_list_response_item import DeviceListResponseItem
from .dome_info import DomeInfo
from .dome_info_response import DomeInfoResponse
from .dome_info_response_shutter_status import DomeInfoResponseShutterStatus
from .filter_info import FilterInfo
from .filter_info_response import FilterInfoResponse
from .filter_info_response_auto_focus_binning import FilterInfoResponseAutoFocusBinning
from .filter_info_response_flat_wizard_filter_settings import FilterInfoResponseFlatWizardFilterSettings
from .filter_info_response_flat_wizard_filter_settings_binning import FilterInfoResponseFlatWizardFilterSettingsBinning
from .flat_device_info import FlatDeviceInfo
from .flat_device_info_response import FlatDeviceInfoResponse
from .flat_device_info_response_cover_state import FlatDeviceInfoResponseCoverState
from .focuser_info import FocuserInfo
from .focuser_info_response import FocuserInfoResponse
from .focuser_last_af import FocuserLastAF
from .focuser_last_af_response import FocuserLastAFResponse
from .focuser_last_af_response_backlash_compensation import FocuserLastAFResponseBacklashCompensation
from .focuser_last_af_response_calculated_focus_point import FocuserLastAFResponseCalculatedFocusPoint
from .focuser_last_af_response_fittings import FocuserLastAFResponseFittings
from .focuser_last_af_response_initial_focus_point import FocuserLastAFResponseInitialFocusPoint
from .focuser_last_af_response_intersections import FocuserLastAFResponseIntersections
from .focuser_last_af_response_intersections_hyperbolic_minimum import (
    FocuserLastAFResponseIntersectionsHyperbolicMinimum,
)
from .focuser_last_af_response_intersections_trend_line_intersection import (
    FocuserLastAFResponseIntersectionsTrendLineIntersection,
)
from .focuser_last_af_response_measure_points_item import FocuserLastAFResponseMeasurePointsItem
from .focuser_last_af_response_previous_focus_point import FocuserLastAFResponsePreviousFocusPoint
from .focuser_last_af_response_r_squares import FocuserLastAFResponseRSquares
from .framing_assistant_info import FramingAssistantInfo
from .framing_assistant_info_response import FramingAssistantInfoResponse
from .framing_assistant_info_response_rectangle import FramingAssistantInfoResponseRectangle
from .fw_info import FWInfo
from .fw_info_response import FWInfoResponse
from .fw_info_response_available_filters_item import FWInfoResponseAvailableFiltersItem
from .fw_info_response_selected_filter import FWInfoResponseSelectedFilter
from .get_application_get_tab_response_200 import GetApplicationGetTabResponse200
from .get_application_get_tab_response_200_response import GetApplicationGetTabResponse200Response
from .get_application_get_tab_response_400 import GetApplicationGetTabResponse400
from .get_application_screenshot_response_200 import GetApplicationScreenshotResponse200
from .get_application_switch_tab_response_200 import GetApplicationSwitchTabResponse200
from .get_application_switch_tab_response_400 import GetApplicationSwitchTabResponse400
from .get_application_switch_tab_tab import GetApplicationSwitchTabTab
from .get_equipment_camera_abort_exposure_response_200 import GetEquipmentCameraAbortExposureResponse200
from .get_equipment_camera_abort_exposure_response_200_response import (
    GetEquipmentCameraAbortExposureResponse200Response,
)
from .get_equipment_camera_abort_exposure_response_409 import GetEquipmentCameraAbortExposureResponse409
from .get_equipment_camera_abort_exposure_response_409_error import GetEquipmentCameraAbortExposureResponse409Error
from .get_equipment_camera_capture_response_200 import GetEquipmentCameraCaptureResponse200
from .get_equipment_camera_capture_response_200_response_type_0 import GetEquipmentCameraCaptureResponse200ResponseType0
from .get_equipment_camera_capture_response_200_response_type_1 import GetEquipmentCameraCaptureResponse200ResponseType1
from .get_equipment_camera_capture_response_200_response_type_1_plate_solve_result import (
    GetEquipmentCameraCaptureResponse200ResponseType1PlateSolveResult,
)
from .get_equipment_camera_capture_response_200_response_type_1_plate_solve_result_coordinates import (
    GetEquipmentCameraCaptureResponse200ResponseType1PlateSolveResultCoordinates,
)
from .get_equipment_camera_capture_response_409 import GetEquipmentCameraCaptureResponse409
from .get_equipment_camera_capture_response_409_response import GetEquipmentCameraCaptureResponse409Response
from .get_equipment_camera_capture_statistics_response_200 import GetEquipmentCameraCaptureStatisticsResponse200
from .get_equipment_camera_capture_statistics_response_200_response import (
    GetEquipmentCameraCaptureStatisticsResponse200Response,
)
from .get_equipment_camera_capture_statistics_response_400 import GetEquipmentCameraCaptureStatisticsResponse400
from .get_equipment_camera_connect_response_200 import GetEquipmentCameraConnectResponse200
from .get_equipment_camera_cool_response_200 import GetEquipmentCameraCoolResponse200
from .get_equipment_camera_cool_response_200_response import GetEquipmentCameraCoolResponse200Response
from .get_equipment_camera_cool_response_409 import GetEquipmentCameraCoolResponse409
from .get_equipment_camera_cool_response_409_error import GetEquipmentCameraCoolResponse409Error
from .get_equipment_camera_dew_heater_response_200 import GetEquipmentCameraDewHeaterResponse200
from .get_equipment_camera_dew_heater_response_409 import GetEquipmentCameraDewHeaterResponse409
from .get_equipment_camera_dew_heater_response_409_error import GetEquipmentCameraDewHeaterResponse409Error
from .get_equipment_camera_disconnect_response_200 import GetEquipmentCameraDisconnectResponse200
from .get_equipment_camera_set_binning_response_200 import GetEquipmentCameraSetBinningResponse200
from .get_equipment_camera_set_binning_response_409 import GetEquipmentCameraSetBinningResponse409
from .get_equipment_camera_set_binning_response_409_error import GetEquipmentCameraSetBinningResponse409Error
from .get_equipment_camera_set_readout_response_200 import GetEquipmentCameraSetReadoutResponse200
from .get_equipment_camera_set_readout_response_400 import GetEquipmentCameraSetReadoutResponse400
from .get_equipment_camera_warm_response_200 import GetEquipmentCameraWarmResponse200
from .get_equipment_camera_warm_response_200_response import GetEquipmentCameraWarmResponse200Response
from .get_equipment_camera_warm_response_409 import GetEquipmentCameraWarmResponse409
from .get_equipment_camera_warm_response_409_error import GetEquipmentCameraWarmResponse409Error
from .get_equipment_dome_close_response_200 import GetEquipmentDomeCloseResponse200
from .get_equipment_dome_close_response_200_response import GetEquipmentDomeCloseResponse200Response
from .get_equipment_dome_close_response_409 import GetEquipmentDomeCloseResponse409
from .get_equipment_dome_connect_response_200 import GetEquipmentDomeConnectResponse200
from .get_equipment_dome_disconnect_response_200 import GetEquipmentDomeDisconnectResponse200
from .get_equipment_dome_home_response_200 import GetEquipmentDomeHomeResponse200
from .get_equipment_dome_home_response_200_response import GetEquipmentDomeHomeResponse200Response
from .get_equipment_dome_home_response_400 import GetEquipmentDomeHomeResponse400
from .get_equipment_dome_open_response_200 import GetEquipmentDomeOpenResponse200
from .get_equipment_dome_open_response_200_response import GetEquipmentDomeOpenResponse200Response
from .get_equipment_dome_open_response_409 import GetEquipmentDomeOpenResponse409
from .get_equipment_dome_park_response_200 import GetEquipmentDomeParkResponse200
from .get_equipment_dome_park_response_200_response import GetEquipmentDomeParkResponse200Response
from .get_equipment_dome_park_response_400 import GetEquipmentDomeParkResponse400
from .get_equipment_dome_set_follow_response_200 import GetEquipmentDomeSetFollowResponse200
from .get_equipment_dome_set_follow_response_200_response import GetEquipmentDomeSetFollowResponse200Response
from .get_equipment_dome_set_follow_response_409 import GetEquipmentDomeSetFollowResponse409
from .get_equipment_dome_set_follow_response_409_error import GetEquipmentDomeSetFollowResponse409Error
from .get_equipment_dome_set_park_position_response_200 import GetEquipmentDomeSetParkPositionResponse200
from .get_equipment_dome_set_park_position_response_400 import GetEquipmentDomeSetParkPositionResponse400
from .get_equipment_dome_set_park_position_response_400_error import GetEquipmentDomeSetParkPositionResponse400Error
from .get_equipment_dome_slew_response_200 import GetEquipmentDomeSlewResponse200
from .get_equipment_dome_slew_response_200_response import GetEquipmentDomeSlewResponse200Response
from .get_equipment_dome_slew_response_409 import GetEquipmentDomeSlewResponse409
from .get_equipment_dome_slew_response_409_error import GetEquipmentDomeSlewResponse409Error
from .get_equipment_dome_stop_response_200 import GetEquipmentDomeStopResponse200
from .get_equipment_dome_stop_response_409 import GetEquipmentDomeStopResponse409
from .get_equipment_dome_sync_response_200 import GetEquipmentDomeSyncResponse200
from .get_equipment_dome_sync_response_409 import GetEquipmentDomeSyncResponse409
from .get_equipment_filterwheel_change_filter_response_200 import GetEquipmentFilterwheelChangeFilterResponse200
from .get_equipment_filterwheel_change_filter_response_409 import GetEquipmentFilterwheelChangeFilterResponse409
from .get_equipment_filterwheel_change_filter_response_409_error import (
    GetEquipmentFilterwheelChangeFilterResponse409Error,
)
from .get_equipment_filterwheel_connect_response_200 import GetEquipmentFilterwheelConnectResponse200
from .get_equipment_filterwheel_disconnect_response_200 import GetEquipmentFilterwheelDisconnectResponse200
from .get_equipment_filterwheel_filter_info_response_409 import GetEquipmentFilterwheelFilterInfoResponse409
from .get_equipment_filterwheel_filter_info_response_409_error import GetEquipmentFilterwheelFilterInfoResponse409Error
from .get_equipment_flatdevice_connect_response_200 import GetEquipmentFlatdeviceConnectResponse200
from .get_equipment_flatdevice_disconnect_response_200 import GetEquipmentFlatdeviceDisconnectResponse200
from .get_equipment_flatdevice_set_brightness_response_200 import GetEquipmentFlatdeviceSetBrightnessResponse200
from .get_equipment_flatdevice_set_brightness_response_409 import GetEquipmentFlatdeviceSetBrightnessResponse409
from .get_equipment_flatdevice_set_cover_response_200 import GetEquipmentFlatdeviceSetCoverResponse200
from .get_equipment_flatdevice_set_cover_response_409 import GetEquipmentFlatdeviceSetCoverResponse409
from .get_equipment_flatdevice_set_light_response_200 import GetEquipmentFlatdeviceSetLightResponse200
from .get_equipment_flatdevice_set_light_response_409 import GetEquipmentFlatdeviceSetLightResponse409
from .get_equipment_focuser_auto_focus_response_200 import GetEquipmentFocuserAutoFocusResponse200
from .get_equipment_focuser_auto_focus_response_200_response import GetEquipmentFocuserAutoFocusResponse200Response
from .get_equipment_focuser_auto_focus_response_409 import GetEquipmentFocuserAutoFocusResponse409
from .get_equipment_focuser_connect_response_200 import GetEquipmentFocuserConnectResponse200
from .get_equipment_focuser_disconnect_response_200 import GetEquipmentFocuserDisconnectResponse200
from .get_equipment_focuser_move_response_200 import GetEquipmentFocuserMoveResponse200
from .get_equipment_guider_clear_calibration_response_200 import GetEquipmentGuiderClearCalibrationResponse200
from .get_equipment_guider_clear_calibration_response_409 import GetEquipmentGuiderClearCalibrationResponse409
from .get_equipment_guider_connect_response_200 import GetEquipmentGuiderConnectResponse200
from .get_equipment_guider_disconnect_response_200 import GetEquipmentGuiderDisconnectResponse200
from .get_equipment_guider_start_response_200 import GetEquipmentGuiderStartResponse200
from .get_equipment_guider_start_response_409 import GetEquipmentGuiderStartResponse409
from .get_equipment_guider_stop_response_200 import GetEquipmentGuiderStopResponse200
from .get_equipment_guider_stop_response_409 import GetEquipmentGuiderStopResponse409
from .get_equipment_mount_connect_response_200 import GetEquipmentMountConnectResponse200
from .get_equipment_mount_disconnect_response_200 import GetEquipmentMountDisconnectResponse200
from .get_equipment_mount_flip_response_200 import GetEquipmentMountFlipResponse200
from .get_equipment_mount_flip_response_409 import GetEquipmentMountFlipResponse409
from .get_equipment_mount_flip_response_409_error import GetEquipmentMountFlipResponse409Error
from .get_equipment_mount_home_response_200 import GetEquipmentMountHomeResponse200
from .get_equipment_mount_home_response_200_response import GetEquipmentMountHomeResponse200Response
from .get_equipment_mount_home_response_409 import GetEquipmentMountHomeResponse409
from .get_equipment_mount_home_response_409_error import GetEquipmentMountHomeResponse409Error
from .get_equipment_mount_park_response_200 import GetEquipmentMountParkResponse200
from .get_equipment_mount_park_response_200_response import GetEquipmentMountParkResponse200Response
from .get_equipment_mount_park_response_409 import GetEquipmentMountParkResponse409
from .get_equipment_mount_set_park_position_response_200 import GetEquipmentMountSetParkPositionResponse200
from .get_equipment_mount_set_park_position_response_400 import GetEquipmentMountSetParkPositionResponse400
from .get_equipment_mount_set_park_position_response_400_error import GetEquipmentMountSetParkPositionResponse400Error
from .get_equipment_mount_slew_response_200 import GetEquipmentMountSlewResponse200
from .get_equipment_mount_slew_response_200_response import GetEquipmentMountSlewResponse200Response
from .get_equipment_mount_slew_response_409 import GetEquipmentMountSlewResponse409
from .get_equipment_mount_slew_response_409_error import GetEquipmentMountSlewResponse409Error
from .get_equipment_mount_slew_stop_response_200 import GetEquipmentMountSlewStopResponse200
from .get_equipment_mount_slew_stop_response_409 import GetEquipmentMountSlewStopResponse409
from .get_equipment_mount_slew_stop_response_409_error import GetEquipmentMountSlewStopResponse409Error
from .get_equipment_mount_tracking_response_200 import GetEquipmentMountTrackingResponse200
from .get_equipment_mount_tracking_response_409 import GetEquipmentMountTrackingResponse409
from .get_equipment_mount_tracking_response_409_error import GetEquipmentMountTrackingResponse409Error
from .get_equipment_mount_unpark_response_200 import GetEquipmentMountUnparkResponse200
from .get_equipment_mount_unpark_response_200_response import GetEquipmentMountUnparkResponse200Response
from .get_equipment_mount_unpark_response_409 import GetEquipmentMountUnparkResponse409
from .get_equipment_rotator_connect_response_200 import GetEquipmentRotatorConnectResponse200
from .get_equipment_rotator_disconnect_response_200 import GetEquipmentRotatorDisconnectResponse200
from .get_equipment_rotator_move_mechanical_response_200 import GetEquipmentRotatorMoveMechanicalResponse200
from .get_equipment_rotator_move_mechanical_response_409 import GetEquipmentRotatorMoveMechanicalResponse409
from .get_equipment_rotator_move_response_200 import GetEquipmentRotatorMoveResponse200
from .get_equipment_rotator_move_response_409 import GetEquipmentRotatorMoveResponse409
from .get_equipment_safetymonitor_connect_response_200 import GetEquipmentSafetymonitorConnectResponse200
from .get_equipment_safetymonitor_disconnect_response_200 import GetEquipmentSafetymonitorDisconnectResponse200
from .get_equipment_switch_connect_response_200 import GetEquipmentSwitchConnectResponse200
from .get_equipment_switch_disconnect_response_200 import GetEquipmentSwitchDisconnectResponse200
from .get_equipment_switch_set_response_200 import GetEquipmentSwitchSetResponse200
from .get_equipment_switch_set_response_409 import GetEquipmentSwitchSetResponse409
from .get_equipment_weather_connect_response_200 import GetEquipmentWeatherConnectResponse200
from .get_equipment_weather_disconnect_response_200 import GetEquipmentWeatherDisconnectResponse200
from .get_event_history_response_200 import GetEventHistoryResponse200
from .get_event_history_response_200_response_item import GetEventHistoryResponse200ResponseItem
from .get_flats_auto_brightness_response_200 import GetFlatsAutoBrightnessResponse200
from .get_flats_auto_brightness_response_400 import GetFlatsAutoBrightnessResponse400
from .get_flats_auto_brightness_response_400_error import GetFlatsAutoBrightnessResponse400Error
from .get_flats_auto_exposure_response_200 import GetFlatsAutoExposureResponse200
from .get_flats_auto_exposure_response_400 import GetFlatsAutoExposureResponse400
from .get_flats_auto_exposure_response_400_error import GetFlatsAutoExposureResponse400Error
from .get_flats_skyflat_response_200 import GetFlatsSkyflatResponse200
from .get_flats_skyflat_response_400 import GetFlatsSkyflatResponse400
from .get_flats_skyflat_response_400_error import GetFlatsSkyflatResponse400Error
from .get_flats_status_response_200 import GetFlatsStatusResponse200
from .get_flats_status_response_200_response import GetFlatsStatusResponse200Response
from .get_flats_status_response_200_response_state import GetFlatsStatusResponse200ResponseState
from .get_flats_stop_response_200 import GetFlatsStopResponse200
from .get_flats_stop_response_400 import GetFlatsStopResponse400
from .get_flats_trained_dark_flat_response_200 import GetFlatsTrainedDarkFlatResponse200
from .get_flats_trained_dark_flat_response_400 import GetFlatsTrainedDarkFlatResponse400
from .get_flats_trained_dark_flat_response_400_error import GetFlatsTrainedDarkFlatResponse400Error
from .get_flats_trained_flat_response_200 import GetFlatsTrainedFlatResponse200
from .get_flats_trained_flat_response_400 import GetFlatsTrainedFlatResponse400
from .get_flats_trained_flat_response_400_error import GetFlatsTrainedFlatResponse400Error
from .get_framing_determine_rotation_response_200_type_0 import GetFramingDetermineRotationResponse200Type0
from .get_framing_determine_rotation_response_400 import GetFramingDetermineRotationResponse400
from .get_framing_set_coordinates_response_200 import GetFramingSetCoordinatesResponse200
from .get_framing_set_rotation_response_200 import GetFramingSetRotationResponse200
from .get_framing_set_source_response_200 import GetFramingSetSourceResponse200
from .get_framing_set_source_response_400 import GetFramingSetSourceResponse400
from .get_framing_set_source_source import GetFramingSetSourceSource
from .get_framing_slew_response_200 import GetFramingSlewResponse200
from .get_framing_slew_response_200_response import GetFramingSlewResponse200Response
from .get_framing_slew_slew_option import GetFramingSlewSlewOption
from .get_image_history_image_type import GetImageHistoryImageType
from .get_image_history_response_200 import GetImageHistoryResponse200
from .get_image_history_response_200_response_type_0_item import GetImageHistoryResponse200ResponseType0Item
from .get_image_history_response_200_response_type_0_item_image_type import (
    GetImageHistoryResponse200ResponseType0ItemImageType,
)
from .get_image_history_response_400 import GetImageHistoryResponse400
from .get_image_index_bayer_pattern import GetImageIndexBayerPattern
from .get_image_index_image_type import GetImageIndexImageType
from .get_image_index_response_200 import GetImageIndexResponse200
from .get_image_index_response_400 import GetImageIndexResponse400
from .get_image_index_response_400_error import GetImageIndexResponse400Error
from .get_image_thumbnail_index_image_type import GetImageThumbnailIndexImageType
from .get_image_thumbnail_index_response_400 import GetImageThumbnailIndexResponse400
from .get_livestack_start_response_200 import GetLivestackStartResponse200
from .get_livestack_stop_response_200 import GetLivestackStopResponse200
from .get_livestack_target_filter_response_200 import GetLivestackTargetFilterResponse200
from .get_profile_change_value_new_value import GetProfileChangeValueNewValue
from .get_profile_change_value_response_200 import GetProfileChangeValueResponse200
from .get_profile_change_value_response_400 import GetProfileChangeValueResponse400
from .get_profile_change_value_response_400_error import GetProfileChangeValueResponse400Error
from .get_profile_switch_response_200 import GetProfileSwitchResponse200
from .get_profile_switch_response_409 import GetProfileSwitchResponse409
from .get_sequence_edit_response_200 import GetSequenceEditResponse200
from .get_sequence_edit_response_400 import GetSequenceEditResponse400
from .get_sequence_edit_response_400_error import GetSequenceEditResponse400Error
from .get_sequence_json_response_409 import GetSequenceJsonResponse409
from .get_sequence_json_response_409_error import GetSequenceJsonResponse409Error
from .get_sequence_list_available_response_200 import GetSequenceListAvailableResponse200
from .get_sequence_list_available_response_200_response_item import GetSequenceListAvailableResponse200ResponseItem
from .get_sequence_reset_response_200 import GetSequenceResetResponse200
from .get_sequence_reset_response_409 import GetSequenceResetResponse409
from .get_sequence_reset_response_409_error import GetSequenceResetResponse409Error
from .get_sequence_set_target_response_200 import GetSequenceSetTargetResponse200
from .get_sequence_set_target_response_400 import GetSequenceSetTargetResponse400
from .get_sequence_set_target_response_409 import GetSequenceSetTargetResponse409
from .get_sequence_start_response_200 import GetSequenceStartResponse200
from .get_sequence_start_response_409 import GetSequenceStartResponse409
from .get_sequence_start_response_409_error import GetSequenceStartResponse409Error
from .get_sequence_state_response_409 import GetSequenceStateResponse409
from .get_sequence_state_response_409_error import GetSequenceStateResponse409Error
from .get_sequence_stop_response_200 import GetSequenceStopResponse200
from .get_sequence_stop_response_409 import GetSequenceStopResponse409
from .get_version_response_200 import GetVersionResponse200
from .guide_steps_history import GuideStepsHistory
from .guide_steps_history_response import GuideStepsHistoryResponse
from .guide_steps_history_response_guide_steps_item import GuideStepsHistoryResponseGuideStepsItem
from .guide_steps_history_response_rms import GuideStepsHistoryResponseRMS
from .guider_info import GuiderInfo
from .guider_info_response import GuiderInfoResponse
from .guider_info_response_last_guide_step import GuiderInfoResponseLastGuideStep
from .guider_info_response_rms_error import GuiderInfoResponseRMSError
from .guider_info_response_rms_error_dec import GuiderInfoResponseRMSErrorDec
from .guider_info_response_rms_error_peak_dec import GuiderInfoResponseRMSErrorPeakDec
from .guider_info_response_rms_error_peak_ra import GuiderInfoResponseRMSErrorPeakRA
from .guider_info_response_rms_error_ra import GuiderInfoResponseRMSErrorRA
from .guider_info_response_rms_error_total import GuiderInfoResponseRMSErrorTotal
from .guider_info_response_state import GuiderInfoResponseState
from .mount_info import MountInfo
from .mount_info_response import MountInfoResponse
from .mount_info_response_alignment_mode import MountInfoResponseAlignmentMode
from .mount_info_response_coordinates import MountInfoResponseCoordinates
from .mount_info_response_coordinates_date_time import MountInfoResponseCoordinatesDateTime
from .mount_info_response_coordinates_epoch import MountInfoResponseCoordinatesEpoch
from .mount_info_response_equatorial_system import MountInfoResponseEquatorialSystem
from .mount_info_response_primary_axis_rates_item import MountInfoResponsePrimaryAxisRatesItem
from .mount_info_response_secondary_axis_rates_item import MountInfoResponseSecondaryAxisRatesItem
from .mount_info_response_side_of_pier import MountInfoResponseSideOfPier
from .mount_info_response_tracking_modes_item import MountInfoResponseTrackingModesItem
from .mount_info_response_tracking_rate import MountInfoResponseTrackingRate
from .profile_info import ProfileInfo
from .profile_info_response import ProfileInfoResponse
from .profile_info_response_alpaca_settings import ProfileInfoResponseAlpacaSettings
from .profile_info_response_application_settings import ProfileInfoResponseApplicationSettings
from .profile_info_response_application_settings_log_level import ProfileInfoResponseApplicationSettingsLogLevel
from .profile_info_response_astrometry_settings import ProfileInfoResponseAstrometrySettings
from .profile_info_response_camera_settings import ProfileInfoResponseCameraSettings
from .profile_info_response_camera_settings_bayer_pattern import ProfileInfoResponseCameraSettingsBayerPattern
from .profile_info_response_camera_settings_bulb_mode import ProfileInfoResponseCameraSettingsBulbMode
from .profile_info_response_camera_settings_raw_converter import ProfileInfoResponseCameraSettingsRawConverter
from .profile_info_response_color_schema_settings import ProfileInfoResponseColorSchemaSettings
from .profile_info_response_dome_settings import ProfileInfoResponseDomeSettings
from .profile_info_response_dome_settings_mount_type import ProfileInfoResponseDomeSettingsMountType
from .profile_info_response_filter_wheel_settings import ProfileInfoResponseFilterWheelSettings
from .profile_info_response_filter_wheel_settings_filter_wheel_filters_item import (
    ProfileInfoResponseFilterWheelSettingsFilterWheelFiltersItem,
)
from .profile_info_response_filter_wheel_settings_filter_wheel_filters_item_auto_focus_binning import (
    ProfileInfoResponseFilterWheelSettingsFilterWheelFiltersItemAutoFocusBinning,
)
from .profile_info_response_filter_wheel_settings_filter_wheel_filters_item_flat_wizard_filter_settings import (
    ProfileInfoResponseFilterWheelSettingsFilterWheelFiltersItemFlatWizardFilterSettings,
)
from .profile_info_response_filter_wheel_settings_filter_wheel_filters_item_flat_wizard_filter_settings_binning import (
    ProfileInfoResponseFilterWheelSettingsFilterWheelFiltersItemFlatWizardFilterSettingsBinning,
)
from .profile_info_response_filter_wheel_settings_filter_wheel_filters_item_flat_wizard_filter_settings_flat_wizard_mode import (
    ProfileInfoResponseFilterWheelSettingsFilterWheelFiltersItemFlatWizardFilterSettingsFlatWizardMode,
)
from .profile_info_response_flat_device_settings import ProfileInfoResponseFlatDeviceSettings
from .profile_info_response_flat_wizard_settings import ProfileInfoResponseFlatWizardSettings
from .profile_info_response_flat_wizard_settings_flat_wizard_mode import (
    ProfileInfoResponseFlatWizardSettingsFlatWizardMode,
)
from .profile_info_response_focuser_settings import ProfileInfoResponseFocuserSettings
from .profile_info_response_focuser_settings_auto_focus_curve_fitting import (
    ProfileInfoResponseFocuserSettingsAutoFocusCurveFitting,
)
from .profile_info_response_focuser_settings_auto_focus_method import ProfileInfoResponseFocuserSettingsAutoFocusMethod
from .profile_info_response_focuser_settings_backlash_compensation_model import (
    ProfileInfoResponseFocuserSettingsBacklashCompensationModel,
)
from .profile_info_response_focuser_settings_contrast_detection_method import (
    ProfileInfoResponseFocuserSettingsContrastDetectionMethod,
)
from .profile_info_response_framing_assistant_settings import ProfileInfoResponseFramingAssistantSettings
from .profile_info_response_framing_assistant_settings_last_selected_image_source import (
    ProfileInfoResponseFramingAssistantSettingsLastSelectedImageSource,
)
from .profile_info_response_guider_settings import ProfileInfoResponseGuiderSettings
from .profile_info_response_guider_settings_guide_chart_declination_color import (
    ProfileInfoResponseGuiderSettingsGuideChartDeclinationColor,
)
from .profile_info_response_guider_settings_guide_chart_right_ascension_color import (
    ProfileInfoResponseGuiderSettingsGuideChartRightAscensionColor,
)
from .profile_info_response_guider_settings_phd2_guider_scale import ProfileInfoResponseGuiderSettingsPHD2GuiderScale
from .profile_info_response_image_file_settings import ProfileInfoResponseImageFileSettings
from .profile_info_response_image_file_settings_file_type import ProfileInfoResponseImageFileSettingsFileType
from .profile_info_response_image_file_settings_fits_compression_type import (
    ProfileInfoResponseImageFileSettingsFITSCompressionType,
)
from .profile_info_response_image_file_settings_tiff_compression_type import (
    ProfileInfoResponseImageFileSettingsTIFFCompressionType,
)
from .profile_info_response_image_file_settings_xisf_checksum_type import (
    ProfileInfoResponseImageFileSettingsXISFChecksumType,
)
from .profile_info_response_image_file_settings_xisf_compression_type import (
    ProfileInfoResponseImageFileSettingsXISFCompressionType,
)
from .profile_info_response_image_history_settings import ProfileInfoResponseImageHistorySettings
from .profile_info_response_image_history_settings_image_history_left_selected import (
    ProfileInfoResponseImageHistorySettingsImageHistoryLeftSelected,
)
from .profile_info_response_image_history_settings_image_history_right_selected import (
    ProfileInfoResponseImageHistorySettingsImageHistoryRightSelected,
)
from .profile_info_response_image_settings import ProfileInfoResponseImageSettings
from .profile_info_response_image_settings_noise_reduction import ProfileInfoResponseImageSettingsNoiseReduction
from .profile_info_response_image_settings_star_sensitivity import ProfileInfoResponseImageSettingsStarSensitivity
from .profile_info_response_meridian_flip_settings import ProfileInfoResponseMeridianFlipSettings
from .profile_info_response_planetarium_settings import ProfileInfoResponsePlanetariumSettings
from .profile_info_response_planetarium_settings_preferred_planetarium import (
    ProfileInfoResponsePlanetariumSettingsPreferredPlanetarium,
)
from .profile_info_response_plate_solve_settings import ProfileInfoResponsePlateSolveSettings
from .profile_info_response_plate_solve_settings_blind_solver_type import (
    ProfileInfoResponsePlateSolveSettingsBlindSolverType,
)
from .profile_info_response_plate_solve_settings_pin_point_catalog_type import (
    ProfileInfoResponsePlateSolveSettingsPinPointCatalogType,
)
from .profile_info_response_plate_solve_settings_plate_solver_type import (
    ProfileInfoResponsePlateSolveSettingsPlateSolverType,
)
from .profile_info_response_rotator_settings import ProfileInfoResponseRotatorSettings
from .profile_info_response_rotator_settings_range_type import ProfileInfoResponseRotatorSettingsRangeType
from .profile_info_response_safety_monitor_settings import ProfileInfoResponseSafetyMonitorSettings
from .profile_info_response_sequence_settings import ProfileInfoResponseSequenceSettings
from .profile_info_response_snap_shot_control_settings import ProfileInfoResponseSnapShotControlSettings
from .profile_info_response_switch_settings import ProfileInfoResponseSwitchSettings
from .profile_info_response_telescope_settings import ProfileInfoResponseTelescopeSettings
from .profile_info_response_telescope_settings_telescope_location_sync_direction import (
    ProfileInfoResponseTelescopeSettingsTelescopeLocationSyncDirection,
)
from .profile_info_response_weather_data_settings import ProfileInfoResponseWeatherDataSettings
from .rotator_info import RotatorInfo
from .rotator_info_response import RotatorInfoResponse
from .safety_monitor_info import SafetyMonitorInfo
from .safety_monitor_info_response import SafetyMonitorInfoResponse
from .sequence_base_json import SequenceBaseJson
from .sequence_base_json_response_item_type_0 import SequenceBaseJsonResponseItemType0
from .sequence_base_json_response_item_type_1 import SequenceBaseJsonResponseItemType1
from .switch_info import SwitchInfo
from .switch_info_response import SwitchInfoResponse
from .switch_info_response_readonly_switches_item import SwitchInfoResponseReadonlySwitchesItem
from .switch_info_response_writable_switches_item import SwitchInfoResponseWritableSwitchesItem
from .unknown_error import UnknownError
from .weather_info import WeatherInfo
from .weather_info_response import WeatherInfoResponse

__all__ = (
    "CameraInfo",
    "CameraInfoResponse",
    "CameraInfoResponseBinningModesItem",
    "CameraInfoResponseCameraState",
    "CameraInfoResponseSensorType",
    "DeviceList",
    "DeviceListResponseItem",
    "DomeInfo",
    "DomeInfoResponse",
    "DomeInfoResponseShutterStatus",
    "FilterInfo",
    "FilterInfoResponse",
    "FilterInfoResponseAutoFocusBinning",
    "FilterInfoResponseFlatWizardFilterSettings",
    "FilterInfoResponseFlatWizardFilterSettingsBinning",
    "FlatDeviceInfo",
    "FlatDeviceInfoResponse",
    "FlatDeviceInfoResponseCoverState",
    "FocuserInfo",
    "FocuserInfoResponse",
    "FocuserLastAF",
    "FocuserLastAFResponse",
    "FocuserLastAFResponseBacklashCompensation",
    "FocuserLastAFResponseCalculatedFocusPoint",
    "FocuserLastAFResponseFittings",
    "FocuserLastAFResponseInitialFocusPoint",
    "FocuserLastAFResponseIntersections",
    "FocuserLastAFResponseIntersectionsHyperbolicMinimum",
    "FocuserLastAFResponseIntersectionsTrendLineIntersection",
    "FocuserLastAFResponseMeasurePointsItem",
    "FocuserLastAFResponsePreviousFocusPoint",
    "FocuserLastAFResponseRSquares",
    "FramingAssistantInfo",
    "FramingAssistantInfoResponse",
    "FramingAssistantInfoResponseRectangle",
    "FWInfo",
    "FWInfoResponse",
    "FWInfoResponseAvailableFiltersItem",
    "FWInfoResponseSelectedFilter",
    "GetApplicationGetTabResponse200",
    "GetApplicationGetTabResponse200Response",
    "GetApplicationGetTabResponse400",
    "GetApplicationScreenshotResponse200",
    "GetApplicationSwitchTabResponse200",
    "GetApplicationSwitchTabResponse400",
    "GetApplicationSwitchTabTab",
    "GetEquipmentCameraAbortExposureResponse200",
    "GetEquipmentCameraAbortExposureResponse200Response",
    "GetEquipmentCameraAbortExposureResponse409",
    "GetEquipmentCameraAbortExposureResponse409Error",
    "GetEquipmentCameraCaptureResponse200",
    "GetEquipmentCameraCaptureResponse200ResponseType0",
    "GetEquipmentCameraCaptureResponse200ResponseType1",
    "GetEquipmentCameraCaptureResponse200ResponseType1PlateSolveResult",
    "GetEquipmentCameraCaptureResponse200ResponseType1PlateSolveResultCoordinates",
    "GetEquipmentCameraCaptureResponse409",
    "GetEquipmentCameraCaptureResponse409Response",
    "GetEquipmentCameraCaptureStatisticsResponse200",
    "GetEquipmentCameraCaptureStatisticsResponse200Response",
    "GetEquipmentCameraCaptureStatisticsResponse400",
    "GetEquipmentCameraConnectResponse200",
    "GetEquipmentCameraCoolResponse200",
    "GetEquipmentCameraCoolResponse200Response",
    "GetEquipmentCameraCoolResponse409",
    "GetEquipmentCameraCoolResponse409Error",
    "GetEquipmentCameraDewHeaterResponse200",
    "GetEquipmentCameraDewHeaterResponse409",
    "GetEquipmentCameraDewHeaterResponse409Error",
    "GetEquipmentCameraDisconnectResponse200",
    "GetEquipmentCameraSetBinningResponse200",
    "GetEquipmentCameraSetBinningResponse409",
    "GetEquipmentCameraSetBinningResponse409Error",
    "GetEquipmentCameraSetReadoutResponse200",
    "GetEquipmentCameraSetReadoutResponse400",
    "GetEquipmentCameraWarmResponse200",
    "GetEquipmentCameraWarmResponse200Response",
    "GetEquipmentCameraWarmResponse409",
    "GetEquipmentCameraWarmResponse409Error",
    "GetEquipmentDomeCloseResponse200",
    "GetEquipmentDomeCloseResponse200Response",
    "GetEquipmentDomeCloseResponse409",
    "GetEquipmentDomeConnectResponse200",
    "GetEquipmentDomeDisconnectResponse200",
    "GetEquipmentDomeHomeResponse200",
    "GetEquipmentDomeHomeResponse200Response",
    "GetEquipmentDomeHomeResponse400",
    "GetEquipmentDomeOpenResponse200",
    "GetEquipmentDomeOpenResponse200Response",
    "GetEquipmentDomeOpenResponse409",
    "GetEquipmentDomeParkResponse200",
    "GetEquipmentDomeParkResponse200Response",
    "GetEquipmentDomeParkResponse400",
    "GetEquipmentDomeSetFollowResponse200",
    "GetEquipmentDomeSetFollowResponse200Response",
    "GetEquipmentDomeSetFollowResponse409",
    "GetEquipmentDomeSetFollowResponse409Error",
    "GetEquipmentDomeSetParkPositionResponse200",
    "GetEquipmentDomeSetParkPositionResponse400",
    "GetEquipmentDomeSetParkPositionResponse400Error",
    "GetEquipmentDomeSlewResponse200",
    "GetEquipmentDomeSlewResponse200Response",
    "GetEquipmentDomeSlewResponse409",
    "GetEquipmentDomeSlewResponse409Error",
    "GetEquipmentDomeStopResponse200",
    "GetEquipmentDomeStopResponse409",
    "GetEquipmentDomeSyncResponse200",
    "GetEquipmentDomeSyncResponse409",
    "GetEquipmentFilterwheelChangeFilterResponse200",
    "GetEquipmentFilterwheelChangeFilterResponse409",
    "GetEquipmentFilterwheelChangeFilterResponse409Error",
    "GetEquipmentFilterwheelConnectResponse200",
    "GetEquipmentFilterwheelDisconnectResponse200",
    "GetEquipmentFilterwheelFilterInfoResponse409",
    "GetEquipmentFilterwheelFilterInfoResponse409Error",
    "GetEquipmentFlatdeviceConnectResponse200",
    "GetEquipmentFlatdeviceDisconnectResponse200",
    "GetEquipmentFlatdeviceSetBrightnessResponse200",
    "GetEquipmentFlatdeviceSetBrightnessResponse409",
    "GetEquipmentFlatdeviceSetCoverResponse200",
    "GetEquipmentFlatdeviceSetCoverResponse409",
    "GetEquipmentFlatdeviceSetLightResponse200",
    "GetEquipmentFlatdeviceSetLightResponse409",
    "GetEquipmentFocuserAutoFocusResponse200",
    "GetEquipmentFocuserAutoFocusResponse200Response",
    "GetEquipmentFocuserAutoFocusResponse409",
    "GetEquipmentFocuserConnectResponse200",
    "GetEquipmentFocuserDisconnectResponse200",
    "GetEquipmentFocuserMoveResponse200",
    "GetEquipmentGuiderClearCalibrationResponse200",
    "GetEquipmentGuiderClearCalibrationResponse409",
    "GetEquipmentGuiderConnectResponse200",
    "GetEquipmentGuiderDisconnectResponse200",
    "GetEquipmentGuiderStartResponse200",
    "GetEquipmentGuiderStartResponse409",
    "GetEquipmentGuiderStopResponse200",
    "GetEquipmentGuiderStopResponse409",
    "GetEquipmentMountConnectResponse200",
    "GetEquipmentMountDisconnectResponse200",
    "GetEquipmentMountFlipResponse200",
    "GetEquipmentMountFlipResponse409",
    "GetEquipmentMountFlipResponse409Error",
    "GetEquipmentMountHomeResponse200",
    "GetEquipmentMountHomeResponse200Response",
    "GetEquipmentMountHomeResponse409",
    "GetEquipmentMountHomeResponse409Error",
    "GetEquipmentMountParkResponse200",
    "GetEquipmentMountParkResponse200Response",
    "GetEquipmentMountParkResponse409",
    "GetEquipmentMountSetParkPositionResponse200",
    "GetEquipmentMountSetParkPositionResponse400",
    "GetEquipmentMountSetParkPositionResponse400Error",
    "GetEquipmentMountSlewResponse200",
    "GetEquipmentMountSlewResponse200Response",
    "GetEquipmentMountSlewResponse409",
    "GetEquipmentMountSlewResponse409Error",
    "GetEquipmentMountSlewStopResponse200",
    "GetEquipmentMountSlewStopResponse409",
    "GetEquipmentMountSlewStopResponse409Error",
    "GetEquipmentMountTrackingResponse200",
    "GetEquipmentMountTrackingResponse409",
    "GetEquipmentMountTrackingResponse409Error",
    "GetEquipmentMountUnparkResponse200",
    "GetEquipmentMountUnparkResponse200Response",
    "GetEquipmentMountUnparkResponse409",
    "GetEquipmentRotatorConnectResponse200",
    "GetEquipmentRotatorDisconnectResponse200",
    "GetEquipmentRotatorMoveMechanicalResponse200",
    "GetEquipmentRotatorMoveMechanicalResponse409",
    "GetEquipmentRotatorMoveResponse200",
    "GetEquipmentRotatorMoveResponse409",
    "GetEquipmentSafetymonitorConnectResponse200",
    "GetEquipmentSafetymonitorDisconnectResponse200",
    "GetEquipmentSwitchConnectResponse200",
    "GetEquipmentSwitchDisconnectResponse200",
    "GetEquipmentSwitchSetResponse200",
    "GetEquipmentSwitchSetResponse409",
    "GetEquipmentWeatherConnectResponse200",
    "GetEquipmentWeatherDisconnectResponse200",
    "GetEventHistoryResponse200",
    "GetEventHistoryResponse200ResponseItem",
    "GetFlatsAutoBrightnessResponse200",
    "GetFlatsAutoBrightnessResponse400",
    "GetFlatsAutoBrightnessResponse400Error",
    "GetFlatsAutoExposureResponse200",
    "GetFlatsAutoExposureResponse400",
    "GetFlatsAutoExposureResponse400Error",
    "GetFlatsSkyflatResponse200",
    "GetFlatsSkyflatResponse400",
    "GetFlatsSkyflatResponse400Error",
    "GetFlatsStatusResponse200",
    "GetFlatsStatusResponse200Response",
    "GetFlatsStatusResponse200ResponseState",
    "GetFlatsStopResponse200",
    "GetFlatsStopResponse400",
    "GetFlatsTrainedDarkFlatResponse200",
    "GetFlatsTrainedDarkFlatResponse400",
    "GetFlatsTrainedDarkFlatResponse400Error",
    "GetFlatsTrainedFlatResponse200",
    "GetFlatsTrainedFlatResponse400",
    "GetFlatsTrainedFlatResponse400Error",
    "GetFramingDetermineRotationResponse200Type0",
    "GetFramingDetermineRotationResponse400",
    "GetFramingSetCoordinatesResponse200",
    "GetFramingSetRotationResponse200",
    "GetFramingSetSourceResponse200",
    "GetFramingSetSourceResponse400",
    "GetFramingSetSourceSource",
    "GetFramingSlewResponse200",
    "GetFramingSlewResponse200Response",
    "GetFramingSlewSlewOption",
    "GetImageHistoryImageType",
    "GetImageHistoryResponse200",
    "GetImageHistoryResponse200ResponseType0Item",
    "GetImageHistoryResponse200ResponseType0ItemImageType",
    "GetImageHistoryResponse400",
    "GetImageIndexBayerPattern",
    "GetImageIndexImageType",
    "GetImageIndexResponse200",
    "GetImageIndexResponse400",
    "GetImageIndexResponse400Error",
    "GetImageThumbnailIndexImageType",
    "GetImageThumbnailIndexResponse400",
    "GetLivestackStartResponse200",
    "GetLivestackStopResponse200",
    "GetLivestackTargetFilterResponse200",
    "GetProfileChangeValueNewValue",
    "GetProfileChangeValueResponse200",
    "GetProfileChangeValueResponse400",
    "GetProfileChangeValueResponse400Error",
    "GetProfileSwitchResponse200",
    "GetProfileSwitchResponse409",
    "GetSequenceEditResponse200",
    "GetSequenceEditResponse400",
    "GetSequenceEditResponse400Error",
    "GetSequenceJsonResponse409",
    "GetSequenceJsonResponse409Error",
    "GetSequenceListAvailableResponse200",
    "GetSequenceListAvailableResponse200ResponseItem",
    "GetSequenceResetResponse200",
    "GetSequenceResetResponse409",
    "GetSequenceResetResponse409Error",
    "GetSequenceSetTargetResponse200",
    "GetSequenceSetTargetResponse400",
    "GetSequenceSetTargetResponse409",
    "GetSequenceStartResponse200",
    "GetSequenceStartResponse409",
    "GetSequenceStartResponse409Error",
    "GetSequenceStateResponse409",
    "GetSequenceStateResponse409Error",
    "GetSequenceStopResponse200",
    "GetSequenceStopResponse409",
    "GetVersionResponse200",
    "GuiderInfo",
    "GuiderInfoResponse",
    "GuiderInfoResponseLastGuideStep",
    "GuiderInfoResponseRMSError",
    "GuiderInfoResponseRMSErrorDec",
    "GuiderInfoResponseRMSErrorPeakDec",
    "GuiderInfoResponseRMSErrorPeakRA",
    "GuiderInfoResponseRMSErrorRA",
    "GuiderInfoResponseRMSErrorTotal",
    "GuiderInfoResponseState",
    "GuideStepsHistory",
    "GuideStepsHistoryResponse",
    "GuideStepsHistoryResponseGuideStepsItem",
    "GuideStepsHistoryResponseRMS",
    "MountInfo",
    "MountInfoResponse",
    "MountInfoResponseAlignmentMode",
    "MountInfoResponseCoordinates",
    "MountInfoResponseCoordinatesDateTime",
    "MountInfoResponseCoordinatesEpoch",
    "MountInfoResponseEquatorialSystem",
    "MountInfoResponsePrimaryAxisRatesItem",
    "MountInfoResponseSecondaryAxisRatesItem",
    "MountInfoResponseSideOfPier",
    "MountInfoResponseTrackingModesItem",
    "MountInfoResponseTrackingRate",
    "ProfileInfo",
    "ProfileInfoResponse",
    "ProfileInfoResponseAlpacaSettings",
    "ProfileInfoResponseApplicationSettings",
    "ProfileInfoResponseApplicationSettingsLogLevel",
    "ProfileInfoResponseAstrometrySettings",
    "ProfileInfoResponseCameraSettings",
    "ProfileInfoResponseCameraSettingsBayerPattern",
    "ProfileInfoResponseCameraSettingsBulbMode",
    "ProfileInfoResponseCameraSettingsRawConverter",
    "ProfileInfoResponseColorSchemaSettings",
    "ProfileInfoResponseDomeSettings",
    "ProfileInfoResponseDomeSettingsMountType",
    "ProfileInfoResponseFilterWheelSettings",
    "ProfileInfoResponseFilterWheelSettingsFilterWheelFiltersItem",
    "ProfileInfoResponseFilterWheelSettingsFilterWheelFiltersItemAutoFocusBinning",
    "ProfileInfoResponseFilterWheelSettingsFilterWheelFiltersItemFlatWizardFilterSettings",
    "ProfileInfoResponseFilterWheelSettingsFilterWheelFiltersItemFlatWizardFilterSettingsBinning",
    "ProfileInfoResponseFilterWheelSettingsFilterWheelFiltersItemFlatWizardFilterSettingsFlatWizardMode",
    "ProfileInfoResponseFlatDeviceSettings",
    "ProfileInfoResponseFlatWizardSettings",
    "ProfileInfoResponseFlatWizardSettingsFlatWizardMode",
    "ProfileInfoResponseFocuserSettings",
    "ProfileInfoResponseFocuserSettingsAutoFocusCurveFitting",
    "ProfileInfoResponseFocuserSettingsAutoFocusMethod",
    "ProfileInfoResponseFocuserSettingsBacklashCompensationModel",
    "ProfileInfoResponseFocuserSettingsContrastDetectionMethod",
    "ProfileInfoResponseFramingAssistantSettings",
    "ProfileInfoResponseFramingAssistantSettingsLastSelectedImageSource",
    "ProfileInfoResponseGuiderSettings",
    "ProfileInfoResponseGuiderSettingsGuideChartDeclinationColor",
    "ProfileInfoResponseGuiderSettingsGuideChartRightAscensionColor",
    "ProfileInfoResponseGuiderSettingsPHD2GuiderScale",
    "ProfileInfoResponseImageFileSettings",
    "ProfileInfoResponseImageFileSettingsFileType",
    "ProfileInfoResponseImageFileSettingsFITSCompressionType",
    "ProfileInfoResponseImageFileSettingsTIFFCompressionType",
    "ProfileInfoResponseImageFileSettingsXISFChecksumType",
    "ProfileInfoResponseImageFileSettingsXISFCompressionType",
    "ProfileInfoResponseImageHistorySettings",
    "ProfileInfoResponseImageHistorySettingsImageHistoryLeftSelected",
    "ProfileInfoResponseImageHistorySettingsImageHistoryRightSelected",
    "ProfileInfoResponseImageSettings",
    "ProfileInfoResponseImageSettingsNoiseReduction",
    "ProfileInfoResponseImageSettingsStarSensitivity",
    "ProfileInfoResponseMeridianFlipSettings",
    "ProfileInfoResponsePlanetariumSettings",
    "ProfileInfoResponsePlanetariumSettingsPreferredPlanetarium",
    "ProfileInfoResponsePlateSolveSettings",
    "ProfileInfoResponsePlateSolveSettingsBlindSolverType",
    "ProfileInfoResponsePlateSolveSettingsPinPointCatalogType",
    "ProfileInfoResponsePlateSolveSettingsPlateSolverType",
    "ProfileInfoResponseRotatorSettings",
    "ProfileInfoResponseRotatorSettingsRangeType",
    "ProfileInfoResponseSafetyMonitorSettings",
    "ProfileInfoResponseSequenceSettings",
    "ProfileInfoResponseSnapShotControlSettings",
    "ProfileInfoResponseSwitchSettings",
    "ProfileInfoResponseTelescopeSettings",
    "ProfileInfoResponseTelescopeSettingsTelescopeLocationSyncDirection",
    "ProfileInfoResponseWeatherDataSettings",
    "RotatorInfo",
    "RotatorInfoResponse",
    "SafetyMonitorInfo",
    "SafetyMonitorInfoResponse",
    "SequenceBaseJson",
    "SequenceBaseJsonResponseItemType0",
    "SequenceBaseJsonResponseItemType1",
    "SwitchInfo",
    "SwitchInfoResponse",
    "SwitchInfoResponseReadonlySwitchesItem",
    "SwitchInfoResponseWritableSwitchesItem",
    "UnknownError",
    "WeatherInfo",
    "WeatherInfoResponse",
)
