import { Construct } from 'constructs';
import * as cloud9 from 'aws-cdk-lib/aws-cloud9';
import * as ssm from 'aws-cdk-lib/aws-ssm';
import * as iam from 'aws-cdk-lib/aws-iam';
/**
 * @experimental
 */
export interface CustomCloud9SsmProps {
    /**
     * (experimental) Optional configuration for the SSM Document.
     *
     * @default : none
     * @experimental
     */
    readonly ssmDocumentProps?: ssm.CfnDocumentProps;
    /**
     * (experimental) Optional configuration for the Cloud9 EC2 environment.
     *
     * @default : none
     * @experimental
     */
    readonly cloud9Ec2Props?: cloud9.CfnEnvironmentEC2Props;
}
/**
 * @experimental
 */
export declare class CustomCloud9Ssm extends Construct {
    private static readonly DEFAULT_EBS_SIZE;
    private static readonly DEFAULT_DOCUMENT_FILE_NAME;
    private static readonly RESIZE_STEP_FILE_NAME;
    private static readonly ATTACH_PROFILE_FILE_NAME;
    private static readonly DEFAULT_DOCUMENT_NAME;
    private readonly document;
    /**
     * (experimental) The IAM Role that is attached to the EC2 instance launched with the Cloud9 environment to grant it permissions to execute the statements in the SSM Document.
     *
     * @experimental
     */
    readonly ec2Role: iam.Role;
    /**
     * (experimental) Adds one or more steps to the content of the SSM Document.
     *
     * @param steps : YAML formatted string containing one or more steps to be added to the mainSteps section of the SSM Document.
     * @experimental
     */
    addDocumentSteps(steps: string): void;
    /**
     * (experimental) Adds one or more parameters to the content of the SSM Document.
     *
     * @param parameters : YAML formatted string containing one or more parameters to be added to the parameters section of the SSM Document.
     * @experimental
     */
    addDocumentParameters(parameters: string): void;
    /**
     * (experimental) Adds a step to the SSM Document content that resizes the EBS volume of the EC2 instance.
     *
     * Attaches the required policies to ec2Role.
     *
     * @param size : size in GiB to resize the EBS volume to.
     * @experimental
     */
    resizeEBSTo(size: number): void;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props?: CustomCloud9SsmProps);
}
