# generated by datamodel-codegen:
#   filename:  webGlLayer.json
#   timestamp: 2025-01-13T08:27:22+00:00

from __future__ import annotations

from enum import Enum
from typing import List, Optional, Union

from pydantic import BaseModel, ConfigDict, Field, confloat


class Interpolation(Enum):
    discrete = 'discrete'
    linear = 'linear'
    exact = 'exact'


class Mode(Enum):
    continuous = 'continuous'
    equal_interval = 'equal interval'
    quantile = 'quantile'


class SymbologyState(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    renderType: str
    band: float
    interpolation: Interpolation
    colorRamp: str
    nClasses: str
    mode: Mode


class IWebGlLayer(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    source: str = Field(..., description='The id of the source')
    opacity: Optional[confloat(ge=0.0, le=1.0, multiple_of=0.1)] = Field(
        1, description='The opacity of the source'
    )
    color: Optional[
        Union[
            str,
            float,
            List[Union[str, float, List[Union[float, str, List[Union[float, str]]]]]],
        ]
    ] = Field(None, description='The color of the the object')
    symbologyState: Optional[SymbologyState] = Field(
        None, description='The state of the symbology panel options'
    )
