# generated by datamodel-codegen:
#   filename:  vectorlayer.json
#   timestamp: 2025-01-13T08:27:22+00:00

from __future__ import annotations

from enum import Enum
from typing import Any, Dict, Optional

from pydantic import BaseModel, ConfigDict, Field, confloat


class Type(Enum):
    circle = 'circle'
    fill = 'fill'
    line = 'line'


class RenderType(Enum):
    Single_Symbol = 'Single Symbol'
    Graduated = 'Graduated'
    Categorized = 'Categorized'


class Method(Enum):
    color = 'color'
    radius = 'radius'


class Mode(Enum):
    quantile = 'quantile'
    equal_interval = 'equal interval'
    jenks = 'jenks'
    pretty = 'pretty'
    logarithmic = 'logarithmic'


class SymbologyState(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    renderType: RenderType
    value: Optional[str] = None
    method: Optional[Method] = None
    colorRamp: Optional[str] = 'cool'
    nClasses: Optional[str] = '9'
    mode: Optional[Mode] = 'equal interval'


class IVectorLayer(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    source: str = Field(..., description='The id of the source')
    type: Type = Field(..., description='The type of vector layer')
    sourceLayer: Optional[str] = Field(None, description='The source layer to use')
    color: Optional[Dict[str, Any]] = Field(
        None, description='The color of the the object'
    )
    opacity: Optional[confloat(ge=0.0, le=1.0, multiple_of=0.1)] = Field(
        1, description='The opacity of the the object'
    )
    symbologyState: Optional[SymbologyState] = Field(
        None, description='The state of the symbology panel options'
    )
