# generated by datamodel-codegen:
#   filename:  rastersource.json
#   timestamp: 2025-01-13T08:27:22+00:00

from __future__ import annotations

from typing import Dict, List, Optional

from pydantic import BaseModel, ConfigDict, Field, confloat


class IRasterSource(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    url: str = Field(..., description='The url to the tile provider')
    minZoom: confloat(ge=0.0, le=24.0) = Field(
        ..., description='The minimum zoom level for the raster source'
    )
    maxZoom: confloat(ge=0.0, le=24.0) = Field(
        ..., description='The maximum zoom level for the raster source'
    )
    attribution: Optional[str] = Field(
        '', description='The attribution for the raster source'
    )
    htmlAttribution: Optional[str] = Field(
        '', description='The html attribution for the raster source'
    )
    provider: Optional[str] = Field('', description='The map provider')
    bounds: Optional[List[List[float]]] = Field(
        [], description='The bounds of the source'
    )
    urlParameters: Optional[Dict[str, str]] = {}
