# generated by datamodel-codegen:
#   filename:  jgis.json
#   timestamp: 2025-01-13T08:27:22+00:00

from __future__ import annotations

from enum import Enum
from typing import Any, Dict, List, Optional, Union

from pydantic import BaseModel, ConfigDict, Field, RootModel, constr


class LayerType(Enum):
    RasterLayer = 'RasterLayer'
    VectorLayer = 'VectorLayer'
    VectorTileLayer = 'VectorTileLayer'
    HillshadeLayer = 'HillshadeLayer'
    WebGlLayer = 'WebGlLayer'
    ImageLayer = 'ImageLayer'


class SourceType(Enum):
    RasterSource = 'RasterSource'
    VectorTileSource = 'VectorTileSource'
    GeoJSONSource = 'GeoJSONSource'
    RasterDemSource = 'RasterDemSource'
    VideoSource = 'VideoSource'
    ImageSource = 'ImageSource'
    ShapefileSource = 'ShapefileSource'
    GeoTiffSource = 'GeoTiffSource'


class JGISSource(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str
    type: SourceType
    parameters: Optional[Dict[str, Any]] = None


class JGISSources(RootModel[Optional[Dict[str, JGISSource]]]):
    root: Optional[Dict[str, JGISSource]] = None


class JGISOptions(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    latitude: Optional[float] = 0
    longitude: Optional[float] = 0
    zoom: Optional[float] = 0
    bearing: Optional[float] = 0
    pitch: Optional[float] = 0
    extent: Optional[List[float]] = None
    projection: Optional[str] = 'EPSG:3857'
    useExtent: Optional[bool] = False


class Operator(Enum):
    field__ = '=='
    field___1 = '!='
    field_ = '>'
    field__1 = '<'
    field___2 = '>='
    field___3 = '<='


class JGISFilterItem(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    operator: Operator
    feature: str
    value: Union[str, float]


class JGISFilter(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    logicalOp: str
    appliedFilters: List[JGISFilterItem]


class JGISLayer(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str
    type: LayerType
    visible: bool
    parameters: Optional[Dict[str, Any]] = None
    filters: Optional[JGISFilter] = None


class JGISLayers(RootModel[Optional[Dict[str, JGISLayer]]]):
    root: Optional[Dict[str, JGISLayer]] = None


class IJGISContent(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    layers: JGISLayers
    sources: JGISSources
    layerTree: Optional[JGISLayerTree] = None
    options: Optional[JGISOptions] = None
    metadata: Optional[Dict[constr(pattern=r'^.*$'), str]] = None


class JGISLayerGroup(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str
    layers: List[JGISLayerItem]
    visible: Optional[bool] = True
    parameters: Optional[Dict[str, Any]] = None


class JGISLayerItem(RootModel[Union[str, JGISLayerGroup]]):
    root: Union[str, JGISLayerGroup] = Field(..., title='IJGISLayerItem')


class JGISLayerTree(RootModel[List[JGISLayerItem]]):
    root: List[JGISLayerItem] = Field(..., title='IJGISLayerTree')


IJGISContent.model_rebuild()
JGISLayerGroup.model_rebuild()
