"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnServiceAccount = exports.toJson_ConfluentCloudApiSecrets = exports.toJson_CfnServiceAccountProps = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Generated by cdk-import
const cdk = require("aws-cdk-lib");
/**
 * Converts an object of type 'CfnServiceAccountProps' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_CfnServiceAccountProps(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'Description': obj.description,
        'Name': obj.name,
        'ConfluentCloudCredentials': toJson_ConfluentCloudApiSecrets(obj.confluentCloudCredentials),
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_CfnServiceAccountProps = toJson_CfnServiceAccountProps;
/**
 * Converts an object of type 'ConfluentCloudApiSecrets' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_ConfluentCloudApiSecrets(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'ApiKey': obj.apiKey,
        'ApiSecret': obj.apiSecret,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_ConfluentCloudApiSecrets = toJson_ConfluentCloudApiSecrets;
/* eslint-enable max-len, quote-props */
/**
 * A CloudFormation `ConfluentCloud::IAM::ServiceAccount`
 *
 * @cloudformationResource ConfluentCloud::IAM::ServiceAccount
 * @stability external
 * @link https://github.com/JohnPreston/aws-cfn-confluentcloud-iam-serviceaccount
 */
class CfnServiceAccount extends cdk.CfnResource {
    /**
     * Create a new `ConfluentCloud::IAM::ServiceAccount`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnServiceAccount.CFN_RESOURCE_TYPE_NAME, properties: toJson_CfnServiceAccountProps(props) });
        this.props = props;
        this.attrServiceAccountId = cdk.Token.asString(this.getAtt('ServiceAccountId'));
    }
}
exports.CfnServiceAccount = CfnServiceAccount;
_a = JSII_RTTI_SYMBOL_1;
CfnServiceAccount[_a] = { fqn: "@cdk-cloudformation/confluentcloud-iam-serviceaccount.CfnServiceAccount", version: "1.0.0-alpha.6" };
/**
* The CloudFormation resource type name for this resource class.
*/
CfnServiceAccount.CFN_RESOURCE_TYPE_NAME = "ConfluentCloud::IAM::ServiceAccount";
//# sourceMappingURL=data:application/json;base64,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