"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ScheduledEc2Task = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_ecs_1 = require("@aws-cdk/aws-ecs");
const scheduled_task_base_1 = require("../base/scheduled-task-base");
/**
 * A scheduled EC2 task that will be initiated off of CloudWatch Events.
 */
class ScheduledEc2Task extends scheduled_task_base_1.ScheduledTaskBase {
    /**
     * Constructs a new instance of the ScheduledEc2Task class.
     */
    constructor(scope, id, props) {
        var _b;
        super(scope, id, props);
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_ecs_patterns_ScheduledEc2TaskProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        if (props.scheduledEc2TaskDefinitionOptions && props.scheduledEc2TaskImageOptions) {
            throw new Error('You must specify either a scheduledEc2TaskDefinitionOptions or scheduledEc2TaskOptions, not both.');
        }
        else if (props.scheduledEc2TaskDefinitionOptions) {
            this.taskDefinition = props.scheduledEc2TaskDefinitionOptions.taskDefinition;
        }
        else if (props.scheduledEc2TaskImageOptions) {
            const taskImageOptions = props.scheduledEc2TaskImageOptions;
            // Create a Task Definition for the container to start, also creates a log driver
            this.taskDefinition = new aws_ecs_1.Ec2TaskDefinition(this, 'ScheduledTaskDef');
            this.taskDefinition.addContainer('ScheduledContainer', {
                image: taskImageOptions.image,
                memoryLimitMiB: taskImageOptions.memoryLimitMiB,
                memoryReservationMiB: taskImageOptions.memoryReservationMiB,
                cpu: taskImageOptions.cpu,
                command: taskImageOptions.command,
                environment: taskImageOptions.environment,
                secrets: taskImageOptions.secrets,
                logging: (_b = taskImageOptions.logDriver) !== null && _b !== void 0 ? _b : this.createAWSLogDriver(this.node.id),
            });
        }
        else {
            throw new Error('You must specify a taskDefinition or image');
        }
        this.task = this.addTaskDefinitionToEventTarget(this.taskDefinition);
    }
}
exports.ScheduledEc2Task = ScheduledEc2Task;
_a = JSII_RTTI_SYMBOL_1;
ScheduledEc2Task[_a] = { fqn: "@aws-cdk/aws-ecs-patterns.ScheduledEc2Task", version: "1.154.0" };
//# sourceMappingURL=data:application/json;base64,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