"""Tests for creating dataset examples from trace spans via the SDK."""

from cat_cafe.sdk import CATCafeClient, DatasetImport


def test_add_example_from_trace(memory_client):
    """Ensures add_example_from_trace hits the expected API and returns updated metadata."""

    client = CATCafeClient(base_url="http://test", session=memory_client)

    # Seed a dataset the same way the notebook does.
    import_result = client.import_dataset(DatasetImport(name="Trace Derived Dataset"))
    dataset_id = import_result["dataset"]["id"]

    result = client.add_example_from_trace(
        dataset_id=dataset_id,
        trace_id="trace-123",
        node_id="node-abc",
        tags=["from-trace"],
        metadata={"source": "tempo"},
    )

    assert result["dataset"]["id"] == dataset_id
    assert result["dataset"]["example_count"] == 1

    example = result["example"]
    assert example["metadata"]["trace_id"] == "trace-123"
    assert example["metadata"]["node_id"] == "node-abc"
    assert example["metadata"]["source"] == "tempo"
    assert example["tags"] == ["from-trace"]
