"""Example of using experiment result management features in CAT-Cafe SDK."""

from cat_cafe.sdk import CATCafeClient

# Create client
client = CATCafeClient()

# List all experiments
print("Listing all experiments:")
experiments = client.list_experiments()
for exp in experiments:
    print(f"  - {exp['experiment_id']}: {exp['name']} (status: {exp['status']})")
print()

# List experiments for a specific dataset
dataset_id = "dataset-123"  # Replace with your dataset ID
print(f"Experiments for dataset {dataset_id}:")
dataset_experiments = client.list_experiments_by_dataset(dataset_id)
for exp in dataset_experiments:
    print(f"  - {exp['experiment_id']}: {exp['name']}")
print()

# Get detailed information about an experiment (includes results)
if experiments:
    exp_id = experiments[0]["experiment_id"]
    print(f"Getting details for experiment {exp_id}:")
    detail = client.get_experiment_detail(exp_id)
    print(f"  Name: {detail['experiment']['name']}")
    print(f"  Status: {detail['experiment']['status']}")
    print(f"  Results count: {len(detail['results'])}")
    if detail["results"]:
        first_result = detail["results"][0]
        print(f"  First result - Example ID: {first_result['example_id']}")
        print(f"  Evaluation scores: {first_result['evaluation_scores']}")
print()

# Compare two experiments
if len(experiments) >= 2:
    exp_a = experiments[0]["experiment_id"]
    exp_b = experiments[1]["experiment_id"]
    print(f"Comparing experiments {exp_a} vs {exp_b}:")

    try:
        comparison = client.compare_experiments(exp_a, exp_b)
        summary = comparison["summary"]
        print(f"  Total examples: {summary['total_examples']}")
        print(f"  A better: {summary['a_better']}")
        print(f"  B better: {summary['b_better']}")
        print(f"  Equal: {summary['equal']}")
        print(f"  Metric improvements: {summary['metric_improvements']}")
    except Exception as e:
        print(f"  Error comparing: {e}")
print()

# Get experiment timeline for a dataset
if dataset_experiments:
    print(f"Timeline for dataset {dataset_id}:")
    timeline = client.get_experiment_timeline(dataset_id)
    print(f"  Metric types: {timeline['metric_types']}")
    for exp in timeline["experiments"]:
        print(f"  - {exp['name']} ({exp['created_at']})")
        print(f"    Metrics: {exp['metrics']}")
        print(f"    Examples: {exp['example_count']}")
