#! usr/bin/python3.6
"""
    Module initially auto generated using V5Automation files from CATIA V5 R28 on 2020-06-11 12:40:47.360445

    .. warning::
        The notes denoted "CAA V5 Visual Basic Help" are to be used as reference only.
        They are there as a guide as to how the visual basic / catscript functions work
        and thus help debugging in pycatia.
        
"""
from pycatia.knowledge_interfaces.free_parameter import FreeParameter
from pycatia.system_interfaces.collection import Collection


class FreeParameters(Collection):
    """
        .. note::
            CAA V5 Visual Basic Help (2020-06-11 12:40:47.360445)

                | System.IUnknown
                |     System.IDispatch
                |         System.CATBaseUnknown
                |             System.CATBaseDispatch
                |                 System.Collection
                |                     FreeParameters
                | 
                | Interface to access a CATIAFreeParameters.
    
    """

    def __init__(self, com_object):
        super().__init__(com_object, child_object=FreeParameter)
        self.free_parameters = com_object

    def add_free_parameter(self, parameter):
        """
        .. note::
            CAA V5 Visual Basic Help (2020-06-11 12:40:47.360445))
                | o Func AddFreeParameter(RealParam parameter) As
                | FreeParameter
                | 
                |     Adds a free parameter. This parameter must not be read only.

        :param RealParam parameter:
        :return: FreeParameter
        """
        return FreeParameter(self.free_parameters.AddFreeParameter(parameter.com_object))

    def item(self, i_index):
        """
        .. note::
            CAA V5 Visual Basic Help (2020-06-11 12:40:47.360445))
                | o Func Item(CATVariant iIndex) As FreeParameter
                | 
                |     Retrieves an optimization using its index or its name from the Free
                |     Parameters collection.
                | 
                |     Parameters:
                | 
                |         iIndex
                |             The index or the name of the free parameter to retrieve from the
                |             collection of free parameters. As a numerics, this index is the rank of the
                |             free parameter in the collection. The index of the first free parameter in the
                |             collection is 1, and the index of the last free parameter is Count. As a
                |             string, it is the name you assigned to the free parameter using the
                |             
                | 
                |         AnyObject.Name property or when changing the free parameter name by the
                |         property panel. 
                |     Returns:
                |         The retrieved free parameter 
                |     Example:
                |         This example retrieves the last free parameter in the free parameters
                |         collection.
                | 
                |          Set lastFreeParameter = freeParameters.Item(freeParameters.Count)

        :param CATVariant i_index:
        :return: FreeParameter
        """
        return FreeParameter(self.free_parameters.Item(i_index))

    def remove_free_parameter(self, i_index):
        """
        .. note::
            CAA V5 Visual Basic Help (2020-06-11 12:40:47.360445))
                | o Sub RemoveFreeParameter(CATVariant iIndex)
                | 
                |     Removes a free parameter.

        :param CATVariant i_index:
        :return: None
        """
        return self.free_parameters.RemoveFreeParameter(i_index)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'remove_free_parameter'
        # # vba_code = """
        # # Public Function remove_free_parameter(free_parameters)
        # #     Dim iIndex (2)
        # #     free_parameters.RemoveFreeParameter iIndex
        # #     remove_free_parameter = iIndex
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def __repr__(self):
        return f'FreeParameters(name="{self.name}")'
