/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.data;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.dcm4che3.data.VR;
import org.dcm4che3.data.Value;
import org.dcm4che3.io.DicomEncodingOptions;
import org.dcm4che3.io.DicomOutputStream;
import org.dcm4che3.util.ByteUtils;
import org.dcm4che3.util.StreamUtils;
import org.dcm4che3.util.StringUtils;

public class BulkData
implements Value {
    public static final int MAGIC_LEN = 64507;
    private final String uuid;
    private String uri;
    private int uriPathEnd;
    private final boolean bigEndian;
    private long offset = 0L;
    private int length = -1;

    public BulkData(String uuid, String uri, boolean bigEndian) {
        this.uuid = uuid;
        this.setURI(uri);
        this.bigEndian = bigEndian;
    }

    public BulkData(String uri, long offset, int length, boolean bigEndian) {
        this.uuid = null;
        this.uriPathEnd = uri.length();
        this.uri = uri + "?offset=" + offset + "&length=" + length;
        this.offset = offset;
        this.length = length;
        this.bigEndian = bigEndian;
    }

    public String getUUID() {
        return this.uuid;
    }

    public String getURI() {
        return this.uri;
    }

    public void setURI(String uri) {
        this.uri = uri;
        this.uriPathEnd = uri.length();
        this.offset = 0L;
        this.length = -1;
        int pathEnd = uri.indexOf(63);
        if (pathEnd < 0) {
            return;
        }
        this.uriPathEnd = pathEnd;
        for (String qparam : StringUtils.split(uri.substring(pathEnd + 1), '&')) {
            try {
                if (qparam.startsWith("offset=")) {
                    this.offset = Integer.parseInt(qparam.substring(7));
                    continue;
                }
                if (!qparam.startsWith("length=")) continue;
                this.length = Integer.parseInt(qparam.substring(7));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public boolean bigEndian() {
        return this.bigEndian;
    }

    public int length() {
        return this.length;
    }

    public long offset() {
        return this.offset;
    }

    @Override
    public boolean isEmpty() {
        return this.length == 0;
    }

    public String toString() {
        return "BulkData[uuid=" + this.uuid + ", uri=" + this.uri + ", bigEndian=" + this.bigEndian + "]";
    }

    public File getFile() {
        try {
            return new File(new URI(this.uriWithoutOffsetAndLength()));
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("uri: " + this.uri);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException("uri: " + this.uri);
        }
    }

    public String uriWithoutOffsetAndLength() {
        if (this.uri == null) {
            throw new IllegalStateException("uri: null");
        }
        return this.uri.substring(0, this.uriPathEnd);
    }

    public InputStream openStream() throws IOException {
        if (this.uri == null) {
            throw new IllegalStateException("uri: null");
        }
        if (!this.uri.startsWith("file:")) {
            return new URL(this.uri).openStream();
        }
        FileInputStream in = new FileInputStream(this.getFile());
        StreamUtils.skipFully(in, this.offset);
        return in;
    }

    @Override
    public int calcLength(DicomEncodingOptions encOpts, boolean explicitVR, VR vr) {
        if (this.length == -1) {
            throw new UnsupportedOperationException();
        }
        return this.length + 1 & 0xFFFFFFFE;
    }

    @Override
    public int getEncodedLength(DicomEncodingOptions encOpts, boolean explicitVR, VR vr) {
        return this.length == -1 ? -1 : this.length + 1 & 0xFFFFFFFE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] toBytes(VR vr, boolean bigEndian) throws IOException {
        if (this.length == -1) {
            throw new UnsupportedOperationException();
        }
        if (this.length == 0) {
            return ByteUtils.EMPTY_BYTES;
        }
        try (InputStream in = this.openStream();){
            byte[] b = new byte[this.length];
            StreamUtils.readFully(in, b, 0, b.length);
            if (this.bigEndian != bigEndian) {
                vr.toggleEndian(b, false);
            }
            byte[] byArray = b;
            return byArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeTo(DicomOutputStream out, VR vr) throws IOException {
        try (InputStream in = this.openStream();){
            if (this.bigEndian != out.isBigEndian()) {
                StreamUtils.copy(in, (OutputStream)out, this.length, vr.numEndianBytes());
            } else {
                StreamUtils.copy(in, (OutputStream)out, this.length);
            }
            if ((this.length & 1) != 0) {
                out.write(vr.paddingByte());
            }
        }
    }

    public void serializeTo(ObjectOutputStream oos) throws IOException {
        oos.writeUTF(StringUtils.maskNull(this.uuid, ""));
        oos.writeUTF(StringUtils.maskNull(this.uri, ""));
        oos.writeBoolean(this.bigEndian);
    }

    public static Value deserializeFrom(ObjectInputStream ois) throws IOException {
        return new BulkData(StringUtils.maskEmpty(ois.readUTF(), null), StringUtils.maskEmpty(ois.readUTF(), null), ois.readBoolean());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BulkData other = (BulkData)obj;
        if (this.bigEndian != other.bigEndian) {
            return false;
        }
        if (this.uri == null ? other.uri != null : !this.uri.equals(other.uri)) {
            return false;
        }
        return !(this.uuid == null ? other.uuid != null : !this.uuid.equals(other.uuid));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.bigEndian ? 1231 : 1237);
        result = 31 * result + (this.uri == null ? 0 : this.uri.hashCode());
        result = 31 * result + (this.uuid == null ? 0 : this.uuid.hashCode());
        return result;
    }

    public long getSegmentEnd() {
        if (this.length == -1) {
            return -1L;
        }
        return this.offset() + this.longLength();
    }

    public long longLength() {
        if (this.length == -1) {
            return -1L;
        }
        return (long)this.length & 0xFFFFFFFFL;
    }

    public void setOffset(long offset) {
        this.offset = offset;
        this.uri = this.uri.substring(0, this.uriPathEnd) + "?offset=" + offset + "&length=" + this.length;
    }

    public void setLength(long longLength) {
        if (longLength < -1L || longLength > 0xFFFFFFF0L) {
            throw new IllegalArgumentException("BulkData length limited to -1..2^32-16 but was " + longLength);
        }
        this.length = (int)longLength;
        this.uri = this.uri.substring(0, this.uriPathEnd) + "?offset=" + this.offset + "&length=" + this.length;
    }
}

