"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.handler = void 0;
const aws_sdk_1 = require("aws-sdk");
const calendar_1 = require("./calendar");
exports.handler = async (event) => {
    console.log('Event: %j', { ...event, ResponseURL: '...' });
    const bucketName = event.ResourceProperties.bucketName;
    const calendarName = event.ResourceProperties.calendarName;
    const roleArn = event.ResourceProperties.roleArn;
    let calendar;
    if (event.ResourceProperties.sourceType === calendar_1.CalendarSourceType.PATH) {
        calendar = event.ResourceProperties.calendarBody;
    }
    else {
        const s3 = roleArn ? await getSession(roleArn) : new aws_sdk_1.S3();
        calendar = (await s3
            .getObject({
            Bucket: bucketName,
            Key: calendarName,
        })
            .promise()).Body.toString();
    }
    const ssm = new aws_sdk_1.SSM();
    if (event.RequestType === 'Create') {
        const createDocumentRepsonse = await ssm
            .createDocument({
            Name: calendarName,
            Content: calendar,
            DocumentType: 'ChangeCalendar',
            DocumentFormat: 'TEXT',
        })
            .promise();
        console.log('Create document: %j', createDocumentRepsonse);
    }
    if (event.RequestType === 'Update') {
        const updateDocumentResponse = await ssm
            .updateDocument({
            Name: calendarName,
            Content: calendar,
            DocumentVersion: '$LATEST',
        })
            .promise();
        console.log('Update document: %j', updateDocumentResponse);
    }
    if (event.RequestType === 'Delete') {
        const deleteDocumentResponse = await ssm
            .deleteDocument({
            Name: calendarName,
        })
            .promise();
        console.log('Delete document: %j', deleteDocumentResponse);
    }
    return {};
};
const getSession = async (roleArn) => {
    const sts = new aws_sdk_1.STS();
    const crentials = await sts
        .assumeRole({
        RoleArn: roleArn,
        RoleSessionName: 'Calendar-Setup-Role',
    })
        .promise();
    return new aws_sdk_1.S3({
        credentials: {
            accessKeyId: crentials.Credentials.AccessKeyId,
            secretAccessKey: crentials.Credentials.SecretAccessKey,
            sessionToken: crentials.Credentials?.SessionToken,
        },
    });
};
//# sourceMappingURL=data:application/json;base64,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