<p align="center">
  <img src="https://user-images.githubusercontent.com/65981382/166214135-47ecd327-cba8-47c0-a034-9f6f14b777ce.png" alt="Motion Tracker Beta"/>
</p>

# Motion Tracker Beta
An easy-to-use, standalone and open source motion tracking application aimed at researchers and engineers, written in Python.

## Features
- Intutitive graphical user interface
- Capable of handling the most common video formats
- Capable of tracking various properties of multiple objects simultaneously
- Diverse set of built in tracking algorithms, based on the `OpenCV` libary
- Rich selection of numerical differentiation algorithms powered by the `PyNumDiff` libary
- Built in plotting an exporting features


For the complete list of features please check the [documentation](docs/DOCUMENTATION.pdf).

## Dependencies
The Graphical user interface was created with the [PyQt5](https://www.riverbankcomputing.com/software/pyqt/) framework. For the handling of video files and to do the actual tracking the [OpenCV](https://opencv.org/) library was used with its built in tracking algorithms. Numerical differentiations are carried out using the [PyNumDiff](https://github.com/florisvb/PyNumDiff). Plots and figures are generated by [matplotlib](https://matplotlib.org/). For the complete list of required packages check [requirements.txt](src/requirements.txt)

## Installation
### Download & install via PyPI
```
$ pip install MotionTrackerBeta
```
- Run the application
```
$ MotionTrackerBeta
```
### Download & install the wheel file
- Download the `.whl` file from the lattest release
- Execute
```
$ pip install <path-to-wheel-file.whl>
```
- Run the application
```
$ MotionTrackerBeta
```
> Note: If you would like to use Chebysev filters in the post processing of tracked data, run `pip install pychebfun`!

### Download binaries (Windows)
- Download the binaries from the latest release
- Extract it to your specified location
- Open application with `Motion Tracker Beta.exe`
### Download the installer (Windows)
- Download the installer from the latest release
- Run the installer and follow the instructions
- After successfull installation the software is accessible under the name `Motion Tracker Beta`
###
# Usage
For a detailed guide about the software check out the [documentation](docs/DOCUMENTATION.pdf).
# License
Motion Tracker Beta is released under the `GNU General Public License v3.0`.
# Author
The software was developed by Kristof Floch at the Department of Applied Mechanics, Faculty of Mechanical Engineering, Budapest University of Technology and Economics.
### Contact
- E-mail: kristof.floch@gmail.com