"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AwsLoadBalancerPolicy = exports.VersionsLists = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("@aws-cdk/aws-iam");
var VersionsLists;
(function (VersionsLists) {
    VersionsLists["AWS_LOAD_BALANCER_CONTROLLER_POLICY_V2"] = "v2";
})(VersionsLists = exports.VersionsLists || (exports.VersionsLists = {}));
const awsLoadBalancerControllerPolicyV2 = [
    {
        Effect: 'Allow',
        Action: [
            'iam:CreateServiceLinkedRole',
            'ec2:DescribeAccountAttributes',
            'ec2:DescribeAddresses',
            'ec2:DescribeInternetGateways',
            'ec2:DescribeVpcs',
            'ec2:DescribeSubnets',
            'ec2:DescribeSecurityGroups',
            'ec2:DescribeInstances',
            'ec2:DescribeNetworkInterfaces',
            'ec2:DescribeTags',
            'elasticloadbalancing:DescribeLoadBalancers',
            'elasticloadbalancing:DescribeLoadBalancerAttributes',
            'elasticloadbalancing:DescribeListeners',
            'elasticloadbalancing:DescribeListenerCertificates',
            'elasticloadbalancing:DescribeSSLPolicies',
            'elasticloadbalancing:DescribeRules',
            'elasticloadbalancing:DescribeTargetGroups',
            'elasticloadbalancing:DescribeTargetGroupAttributes',
            'elasticloadbalancing:DescribeTargetHealth',
            'elasticloadbalancing:DescribeTags',
        ],
        Resource: '*',
    },
    {
        Effect: 'Allow',
        Action: [
            'cognito-idp:DescribeUserPoolClient',
            'acm:ListCertificates',
            'acm:DescribeCertificate',
            'iam:ListServerCertificates',
            'iam:GetServerCertificate',
            'waf-regional:GetWebACL',
            'waf-regional:GetWebACLForResource',
            'waf-regional:AssociateWebACL',
            'waf-regional:DisassociateWebACL',
            'wafv2:GetWebACL',
            'wafv2:GetWebACLForResource',
            'wafv2:AssociateWebACL',
            'wafv2:DisassociateWebACL',
            'shield:GetSubscriptionState',
            'shield:DescribeProtection',
            'shield:CreateProtection',
            'shield:DeleteProtection',
        ],
        Resource: '*',
    },
    {
        Effect: 'Allow',
        Action: [
            'ec2:AuthorizeSecurityGroupIngress',
            'ec2:RevokeSecurityGroupIngress',
        ],
        Resource: '*',
    },
    {
        Effect: 'Allow',
        Action: [
            'ec2:CreateSecurityGroup',
        ],
        Resource: '*',
    },
    {
        Effect: 'Allow',
        Action: [
            'ec2:CreateTags',
        ],
        Resource: 'arn:aws:ec2:*:*:security-group/*',
        Condition: {
            StringEquals: {
                'ec2:CreateAction': 'CreateSecurityGroup',
            },
            Null: {
                'aws:RequestTag/elbv2.k8s.aws/cluster': 'false',
            },
        },
    },
    {
        Effect: 'Allow',
        Action: [
            'ec2:CreateTags',
            'ec2:DeleteTags',
        ],
        Resource: 'arn:aws:ec2:*:*:security-group/*',
        Condition: {
            Null: {
                'aws:RequestTag/elbv2.k8s.aws/cluster': 'true',
                'aws:ResourceTag/elbv2.k8s.aws/cluster': 'false',
            },
        },
    },
    {
        Effect: 'Allow',
        Action: [
            'ec2:AuthorizeSecurityGroupIngress',
            'ec2:RevokeSecurityGroupIngress',
            'ec2:DeleteSecurityGroup',
        ],
        Resource: '*',
        Condition: {
            Null: {
                'aws:ResourceTag/elbv2.k8s.aws/cluster': 'false',
            },
        },
    },
    {
        Effect: 'Allow',
        Action: [
            'elasticloadbalancing:CreateLoadBalancer',
            'elasticloadbalancing:CreateTargetGroup',
        ],
        Resource: '*',
        Condition: {
            Null: {
                'aws:RequestTag/elbv2.k8s.aws/cluster': 'false',
            },
        },
    },
    {
        Effect: 'Allow',
        Action: [
            'elasticloadbalancing:CreateListener',
            'elasticloadbalancing:DeleteListener',
            'elasticloadbalancing:CreateRule',
            'elasticloadbalancing:DeleteRule',
        ],
        Resource: '*',
    },
    {
        Effect: 'Allow',
        Action: [
            'elasticloadbalancing:AddTags',
            'elasticloadbalancing:RemoveTags',
        ],
        Resource: [
            'arn:aws:elasticloadbalancing:*:*:targetgroup/*/*',
            'arn:aws:elasticloadbalancing:*:*:loadbalancer/net/*/*',
            'arn:aws:elasticloadbalancing:*:*:loadbalancer/app/*/*',
        ],
        Condition: {
            Null: {
                'aws:RequestTag/elbv2.k8s.aws/cluster': 'true',
                'aws:ResourceTag/elbv2.k8s.aws/cluster': 'false',
            },
        },
    },
    {
        Effect: 'Allow',
        Action: [
            'elasticloadbalancing:ModifyLoadBalancerAttributes',
            'elasticloadbalancing:SetIpAddressType',
            'elasticloadbalancing:SetSecurityGroups',
            'elasticloadbalancing:SetSubnets',
            'elasticloadbalancing:DeleteLoadBalancer',
            'elasticloadbalancing:ModifyTargetGroup',
            'elasticloadbalancing:ModifyTargetGroupAttributes',
            'elasticloadbalancing:DeleteTargetGroup',
        ],
        Resource: '*',
        Condition: {
            Null: {
                'aws:ResourceTag/elbv2.k8s.aws/cluster': 'false',
            },
        },
    },
    {
        Effect: 'Allow',
        Action: [
            'elasticloadbalancing:RegisterTargets',
            'elasticloadbalancing:DeregisterTargets',
        ],
        Resource: 'arn:aws:elasticloadbalancing:*:*:targetgroup/*/*',
    },
    {
        Effect: 'Allow',
        Action: [
            'elasticloadbalancing:SetWebAcl',
            'elasticloadbalancing:ModifyListener',
            'elasticloadbalancing:AddListenerCertificates',
            'elasticloadbalancing:RemoveListenerCertificates',
            'elasticloadbalancing:ModifyRule',
        ],
        Resource: '*',
    },
];
/**
 * (experimental) awsLoadBalancerPolicy class ,help you add policy to your Iam Role for service account.
 *
 * @experimental
 */
class AwsLoadBalancerPolicy {
    /**
     * @experimental
     */
    static addPolicy(version, role) {
        if (version == 'v2') {
            awsLoadBalancerControllerPolicyV2.forEach(element => {
                role.addToPolicy(iam.PolicyStatement.fromJson(element));
            });
            return role;
        }
    }
}
exports.AwsLoadBalancerPolicy = AwsLoadBalancerPolicy;
_a = JSII_RTTI_SYMBOL_1;
AwsLoadBalancerPolicy[_a] = { fqn: "@opencdk8s/cdk8s-aws-lb-controller.AwsLoadBalancerPolicy", version: "0.0.1" };
;
//# sourceMappingURL=data:application/json;base64,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