"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AwsLoadBalancerController = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk8s = require("cdk8s");
const constructs_1 = require("constructs");
const k8s = require("./imports/k8s");
/**
 * (experimental) Generate aws-load-balancer-controller config yaml.
 *
 * see https://github.com/kubernetes-sigs/aws-aws-load-balancer-controller/blob/master/docs/install/v2_0_0_full.yaml
 *
 * @experimental
 */
class AwsLoadBalancerController extends constructs_1.Construct {
    /**
     * @experimental
     */
    constructor(scope, id, options) {
        var _b, _c, _d, _e;
        super(scope, id);
        this.serviceAccountName = (_b = options.serviceAccountName) !== null && _b !== void 0 ? _b : 'aws-load-balancer-controller';
        this.deploymentName = 'aws-load-balancer-controller';
        this.clusterName = options.clusterName;
        this.namespace = (_c = options === null || options === void 0 ? void 0 : options.namespace) !== null && _c !== void 0 ? _c : 'kube-system';
        new cdk8s.ApiObject(this, 'aws-load-balancer-controller-crd', {
            apiVersion: 'apiextensions.k8s.io/v1beta1',
            kind: 'CustomResourceDefinition',
            metadata: {
                annotations: {
                    'controller-gen.kubebuilder.io/version': 'v0.4.0',
                },
                labels: {
                    'app.kubernetes.io/name': this.serviceAccountName,
                },
                name: 'targetgroupbindings.elbv2.k8s.aws',
            },
            spec: {
                additionalPrinterColumns: [
                    {
                        JSONPath: '.spec.serviceRef.name',
                        description: "The Kubernetes Service's name",
                        name: 'SERVICE-NAME',
                        type: 'string',
                    },
                    {
                        JSONPath: '.spec.serviceRef.port',
                        description: "The Kubernetes Service's port",
                        name: 'SERVICE-PORT',
                        type: 'string',
                    },
                    {
                        JSONPath: '.spec.targetType',
                        description: "The AWS TargetGroup's TargetType",
                        name: 'TARGET-TYPE',
                        type: 'string',
                    },
                    {
                        JSONPath: '.spec.targetGroupARN',
                        description: "The AWS TargetGroup's Amazon Resource Name",
                        name: 'ARN',
                        priority: 1,
                        type: 'string',
                    },
                    {
                        JSONPath: '.metadata.creationTimestamp',
                        name: 'AGE',
                        type: 'date',
                    },
                ],
                group: 'elbv2.k8s.aws',
                names: {
                    categories: [
                        'all',
                    ],
                    kind: 'TargetGroupBinding',
                    listKind: 'TargetGroupBindingList',
                    plural: 'targetgroupbindings',
                    singular: 'targetgroupbinding',
                },
                scope: 'Namespaced',
                subresources: {
                    status: {},
                },
                validation: {
                    openAPIV3Schema: {
                        description: 'TargetGroupBinding is the Schema for the TargetGroupBinding API',
                        properties: {
                            apiVersion: {
                                description: 'APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources',
                                type: 'string',
                            },
                            kind: {
                                description: 'Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
                                type: 'string',
                            },
                            metadata: {
                                type: 'object',
                            },
                            spec: {
                                description: 'TargetGroupBindingSpec defines the desired state of TargetGroupBinding',
                                properties: {
                                    networking: {
                                        description: 'networking provides the networking setup for ELBV2 LoadBalancer to access targets in TargetGroup.',
                                        properties: {
                                            ingress: {
                                                description: 'List of ingress rules to allow ELBV2 LoadBalancer to access targets in TargetGroup.',
                                                items: {
                                                    properties: {
                                                        from: {
                                                            description: 'List of peers which should be able to access the targets in TargetGroup. At least one NetworkingPeer should be specified.',
                                                            items: {
                                                                description: 'NetworkingPeer defines the source/destination peer for networking rules.',
                                                                properties: {
                                                                    ipBlock: {
                                                                        description: 'IPBlock defines an IPBlock peer. If specified, none of the other fields can be set.',
                                                                        properties: {
                                                                            cidr: {
                                                                                description: 'CIDR is the network CIDR. Both IPV4 or IPV6 CIDR are accepted.',
                                                                                type: 'string',
                                                                            },
                                                                        },
                                                                        required: [
                                                                            'cidr',
                                                                        ],
                                                                        type: 'object',
                                                                    },
                                                                    securityGroup: {
                                                                        description: 'SecurityGroup defines a SecurityGroup peer. If specified, none of the other fields can be set.',
                                                                        properties: {
                                                                            groupID: {
                                                                                description: 'GroupID is the EC2 SecurityGroupID.',
                                                                                type: 'string',
                                                                            },
                                                                        },
                                                                        required: [
                                                                            'groupID',
                                                                        ],
                                                                        type: 'object',
                                                                    },
                                                                },
                                                                type: 'object',
                                                            },
                                                            type: 'array',
                                                        },
                                                        ports: {
                                                            description: 'List of ports which should be made accessible on the targets in TargetGroup. If ports is empty or unspecified, it defaults to all ports with TCP.',
                                                            items: {
                                                                properties: {
                                                                    port: {
                                                                        'anyOf': [
                                                                            {
                                                                                type: 'integer',
                                                                            },
                                                                            {
                                                                                type: 'string',
                                                                            },
                                                                        ],
                                                                        'description': 'The port which traffic must match. When NodePort endpoints(instance TargetType) is used, this must be a numerical port. When Port endpoints(ip TargetType) is used, this can be either numerical or named port on pods. if port is unspecified, it defaults to all ports.',
                                                                        'x-kubernetes-int-or-string': true,
                                                                    },
                                                                    protocol: {
                                                                        description: 'The protocol which traffic must match. If protocol is unspecified, it defaults to TCP.',
                                                                        enum: [
                                                                            'TCP',
                                                                            'UDP',
                                                                        ],
                                                                        type: 'string',
                                                                    },
                                                                },
                                                                type: 'object',
                                                            },
                                                            type: 'array',
                                                        },
                                                    },
                                                    required: [
                                                        'from',
                                                        'ports',
                                                    ],
                                                    type: 'object',
                                                },
                                                type: 'array',
                                            },
                                        },
                                        type: 'object',
                                    },
                                    serviceRef: {
                                        description: 'serviceRef is a reference to a Kubernetes Service and ServicePort.',
                                        properties: {
                                            name: {
                                                description: 'Name is the name of the Service.',
                                                type: 'string',
                                            },
                                            port: {
                                                'anyOf': [
                                                    {
                                                        type: 'integer',
                                                    },
                                                    {
                                                        type: 'string',
                                                    },
                                                ],
                                                'description': 'Port is the port of the ServicePort.',
                                                'x-kubernetes-int-or-string': true,
                                            },
                                        },
                                        required: [
                                            'name',
                                            'port',
                                        ],
                                        type: 'object',
                                    },
                                    targetGroupARN: {
                                        description: 'targetGroupARN is the Amazon Resource Name (ARN) for the TargetGroup.',
                                        type: 'string',
                                    },
                                    targetType: {
                                        description: 'targetType is the TargetType of TargetGroup. If unspecified, it will be automatically inferred.',
                                        enum: [
                                            'instance',
                                            'ip',
                                        ],
                                        type: 'string',
                                    },
                                },
                                required: [
                                    'serviceRef',
                                    'targetGroupARN',
                                ],
                                type: 'object',
                            },
                            status: {
                                description: 'TargetGroupBindingStatus defines the observed state of TargetGroupBinding',
                                properties: {
                                    observedGeneration: {
                                        description: 'The generation observed by the TargetGroupBinding controller.',
                                        format: 'int64',
                                        type: 'integer',
                                    },
                                },
                                type: 'object',
                            },
                        },
                        type: 'object',
                    },
                },
                version: 'v1alpha1',
                versions: [
                    {
                        name: 'v1alpha1',
                        served: true,
                        storage: false,
                    },
                    {
                        name: 'v1beta1',
                        served: true,
                        storage: true,
                    },
                ],
            },
            status: {
                acceptedNames: {
                    kind: '',
                    plural: '',
                },
                conditions: [],
                storedVersions: [],
            },
        });
        new k8s.KubeMutatingWebhookConfigurationV1Beta1(this, 'aws-load-balancer-webhook', {
            metadata: {
                annotations: {
                    'cert-manager.io/inject-ca-from': 'kube-system/aws-load-balancer-serving-cert',
                },
                labels: {
                    'app.kubernetes.io/name': this.serviceAccountName,
                    ...options.labels,
                },
                name: 'aws-load-balancer-webhook',
            },
            webhooks: [
                {
                    clientConfig: {
                        caBundle: 'Cg==',
                        service: {
                            name: 'aws-load-balancer-webhook-service',
                            namespace: this.namespace,
                            path: '/mutate-v1-pod',
                        },
                    },
                    failurePolicy: 'Fail',
                    name: 'mpod.elbv2.k8s.aws',
                    namespaceSelector: {
                        matchExpressions: [
                            {
                                key: 'elbv2.k8s.aws/pod-readiness-gate-inject',
                                operator: 'In',
                                values: ['enabled'],
                            },
                        ],
                    },
                    rules: [{
                            apiGroups: [''],
                            apiVersions: ['v1'],
                            operations: [
                                'CREATE',
                            ],
                            resources: ['pods'],
                        }],
                    sideEffects: 'None',
                },
                {
                    clientConfig: {
                        caBundle: 'Cg==',
                        service: {
                            name: 'aws-load-balancer-webhook-service',
                            namespace: this.namespace,
                            path: '/mutate-elbv2-k8s-aws-v1beta1-targetgroupbinding',
                        },
                    },
                    failurePolicy: 'Fail',
                    name: 'mtargetgroupbinding.elbv2.k8s.aws',
                    rules: [{
                            apiGroups: ['elbv2.k8s.aws'],
                            apiVersions: ['v1beta1'],
                            operations: [
                                'CREATE',
                                'UPDATE',
                            ],
                            resources: ['targetgroupbindings'],
                        }],
                    sideEffects: 'None',
                },
            ],
        });
        new k8s.KubeServiceAccount(this, 'aws-load-balancer-controller-sa', {
            metadata: {
                labels: {
                    'app.kubernetes.io/component': 'controller',
                    'app.kubernetes.io/name': this.serviceAccountName,
                    ...options.labels,
                },
                name: this.serviceAccountName,
                namespace: this.namespace,
            },
        });
        new k8s.KubeRole(this, 'aws-load-balancer-controller-leader-election-role', {
            metadata: {
                labels: {
                    'app.kubernetes.io/name': this.serviceAccountName,
                    ...options.labels,
                },
                name: 'aws-load-balancer-controller-leader-election-role',
                namespace: this.namespace,
            },
            rules: [
                {
                    apiGroups: [''],
                    resources: ['configmaps'],
                    verbs: ['create'],
                }, {
                    apiGroups: [''],
                    resources: ['configmaps'],
                    resourceNames: ['aws-load-balancer-controller-leader'],
                    verbs: ['get', 'update', 'patch'],
                },
            ],
        });
        new k8s.KubeClusterRole(this, 'aws-load-balancer-controller-cluster-role', {
            metadata: {
                labels: {
                    'app.kubernetes.io/name': this.serviceAccountName,
                    ...options.labels,
                },
                name: `${this.serviceAccountName}-role`,
            },
            rules: [
                {
                    apiGroups: [''],
                    resources: ['endpoints'],
                    verbs: ['get', 'list', 'watch'],
                },
                {
                    apiGroups: [''],
                    resources: ['events'],
                    verbs: ['create', 'patch'],
                },
                {
                    apiGroups: [''],
                    resources: ['namespaces'],
                    verbs: ['get', 'list', 'watch'],
                },
                {
                    apiGroups: [''],
                    resources: ['nodes'],
                    verbs: ['get', 'list', 'watch'],
                },
                {
                    apiGroups: [''],
                    resources: ['pods'],
                    verbs: ['get', 'list', 'watch'],
                },
                {
                    apiGroups: [''],
                    resources: ['pods/status'],
                    verbs: ['patch', 'update'],
                },
                {
                    apiGroups: [''],
                    resources: ['secrets'],
                    verbs: ['get', 'list', 'watch'],
                },
                {
                    apiGroups: [''],
                    resources: ['services'],
                    verbs: ['get', 'list', 'patch', 'update', 'watch'],
                },
                {
                    apiGroups: [''],
                    resources: ['services/status'],
                    verbs: ['patch', 'update'],
                },
                {
                    apiGroups: ['elbv2.k8s.aws'],
                    resources: ['targetgroupbindings'],
                    verbs: ['create', 'delete', 'get', 'list', 'patch', 'update', 'watch'],
                },
                {
                    apiGroups: ['elbv2.k8s.aws'],
                    resources: ['targetgroupbindings/status'],
                    verbs: ['patch', 'update'],
                },
                {
                    apiGroups: ['extensions'],
                    resources: ['ingresses'],
                    verbs: ['get', 'list', 'patch', 'update', 'watch'],
                },
                {
                    apiGroups: ['extensions'],
                    resources: ['ingresses/status'],
                    verbs: ['patch', 'update'],
                },
                {
                    apiGroups: ['networking.k8s.io'],
                    resources: ['ingresses'],
                    verbs: ['get', 'list', 'patch', 'update', 'watch'],
                },
                {
                    apiGroups: ['networking.k8s.io'],
                    resources: ['ingressclasses'],
                    verbs: ['get', 'list', 'watch'],
                },
                {
                    apiGroups: ['networking.k8s.io'],
                    resources: ['ingresses/status'],
                    verbs: ['patch', 'update'],
                },
            ],
        });
        new k8s.KubeRoleBinding(this, 'aws-load-balancer-controller-leader-election-rolebinding', {
            metadata: {
                labels: {
                    'app.kubernetes.io/name': this.serviceAccountName,
                    ...options.labels,
                },
                name: 'aws-load-balancer-controller-leader-election-rolebinding',
                namespace: this.namespace,
            },
            roleRef: {
                apiGroup: 'rbac.authorization.k8s.io',
                kind: 'Role',
                name: 'aws-load-balancer-controller-leader-election-role',
            },
            subjects: [
                {
                    kind: 'ServiceAccount',
                    name: this.serviceAccountName,
                    namespace: this.namespace,
                },
            ],
        });
        new k8s.KubeClusterRoleBinding(this, 'aws-load-balancer-controller-rolebinding', {
            metadata: {
                labels: {
                    'app.kubernetes.io/name': this.serviceAccountName,
                    ...options.labels,
                },
                name: 'aws-load-balancer-controller-rolebinding',
            },
            roleRef: {
                apiGroup: 'rbac.authorization.k8s.io',
                kind: 'ClusterRole',
                name: `${this.serviceAccountName}-role`,
            },
            subjects: [
                {
                    kind: 'ServiceAccount',
                    namespace: this.namespace,
                    name: this.serviceAccountName,
                },
            ],
        });
        new k8s.KubeService(this, 'aws-load-balancer-webhook-service', {
            metadata: {
                labels: {
                    'app.kubernetes.io/name': this.serviceAccountName,
                    ...options.labels,
                },
                name: 'aws-load-balancer-webhook-service',
                namespace: this.namespace,
            },
            spec: {
                ports: [
                    {
                        port: 443,
                        targetPort: 9443,
                    },
                ],
                selector: {
                    'app.kubernetes.io/component': 'controller',
                    'app.kubernetes.io/name': this.serviceAccountName,
                },
            },
        });
        new k8s.KubeDeployment(this, 'aws-load-balancer-controller-deployment', {
            metadata: {
                labels: {
                    'app.kubernetes.io/component': 'controller',
                    'app.kubernetes.io/name': this.serviceAccountName,
                    ...options.labels,
                },
                namespace: this.namespace,
                name: this.deploymentName,
            },
            spec: {
                replicas: (_d = options === null || options === void 0 ? void 0 : options.replicas) !== null && _d !== void 0 ? _d : 1,
                selector: {
                    matchLabels: {
                        'app.kubernetes.io/component': 'controller',
                        'app.kubernetes.io/name': this.serviceAccountName,
                        ...options.labels,
                    },
                },
                template: {
                    metadata: {
                        labels: {
                            'app.kubernetes.io/component': 'controller',
                            'app.kubernetes.io/name': this.serviceAccountName,
                            ...options.labels,
                        },
                    },
                    spec: {
                        containers: [{
                                name: 'controller',
                                image: (_e = options === null || options === void 0 ? void 0 : options.image) !== null && _e !== void 0 ? _e : 'amazon/aws-alb-ingress-controller:v2.1.3',
                                args: this.argsFunc(options.args),
                                env: this.envFunc(options.env),
                                livenessProbe: {
                                    failureThreshold: 2,
                                    httpGet: {
                                        path: '/healthz',
                                        port: 61779,
                                        scheme: 'HTTP',
                                    },
                                    initialDelaySeconds: 30,
                                    timeoutSeconds: 10,
                                },
                                ports: [
                                    {
                                        containerPort: 9443,
                                        name: 'webhook-server',
                                        protocol: 'TCP',
                                    },
                                ],
                                resources: {
                                    limits: {
                                        cpu: '200m',
                                        memory: '500Mi',
                                    },
                                    requests: {
                                        cpu: '100m',
                                        memory: '200Mi',
                                    },
                                },
                                securityContext: {
                                    allowPrivilegeEscalation: false,
                                    readOnlyRootFilesystem: true,
                                    runAsNonRoot: true,
                                },
                                volumeMounts: [
                                    {
                                        mountPath: '/tmp/k8s-webhook-server/serving-certs',
                                        name: 'cert',
                                        readOnly: true,
                                    },
                                ],
                            }],
                        securityContext: {
                            fsGroup: 1337,
                        },
                        serviceAccountName: `${this.serviceAccountName}`,
                        terminationGracePeriodSeconds: 10,
                        volumes: [{
                                name: 'cert',
                                secret: {
                                    defaultMode: 420,
                                    secretName: 'aws-load-balancer-webhook-tls',
                                },
                            }],
                    },
                },
            },
        });
        new cdk8s.ApiObject(this, 'aws-load-balancer-serving-cert', {
            apiVersion: 'cert-manager.io/v1alpha2',
            kind: 'Certificate',
            metadata: {
                labels: {
                    'app.kubernetes.io/name': this.serviceAccountName,
                    ...options.labels,
                },
                name: 'aws-load-balancer-serving-cert',
                namespace: this.namespace,
            },
            spec: {
                dnsNames: [
                    'aws-load-balancer-webhook-service.kube-system.svc',
                    'aws-load-balancer-webhook-service.kube-system.svc.cluster.local',
                ],
                issuerRef: {
                    kind: 'Issuer',
                    name: 'aws-load-balancer-selfsigned-issuer',
                },
                secretName: 'aws-load-balancer-webhook-tls',
            },
        });
        new cdk8s.ApiObject(this, 'aws-load-balancer-selfsigned-issuer', {
            apiVersion: 'cert-manager.io/v1alpha2',
            kind: 'Issuer',
            metadata: {
                labels: {
                    'app.kubernetes.io/name': this.serviceAccountName,
                    ...options.labels,
                },
                name: 'aws-load-balancer-selfsigned-issuer',
                namespace: this.namespace,
            },
            spec: {
                selfSigned: {},
            },
        });
        new k8s.KubeValidatingWebhookConfigurationV1Beta1(this, 'aws-load-balancer-selfsigned-issuer-valid', {
            metadata: {
                annotations: {
                    'cert-manager.io/inject-ca-from': 'kube-system/aws-load-balancer-serving-cert',
                },
                labels: {
                    'app.kubernetes.io/name': this.serviceAccountName,
                    ...options.labels,
                },
                name: 'aws-load-balancer-webhook',
            },
            webhooks: [
                {
                    clientConfig: {
                        caBundle: 'Cg==',
                        service: {
                            name: 'aws-load-balancer-webhook-service',
                            namespace: this.namespace,
                            path: '/validate-elbv2-k8s-aws-v1beta1-targetgroupbinding',
                        },
                    },
                    failurePolicy: 'Fail',
                    name: 'vtargetgroupbinding.elbv2.k8s.aws',
                    rules: [{
                            apiGroups: ['elbv2.k8s.aws'],
                            apiVersions: ['v1beta1'],
                            operations: [
                                'CREATE',
                                'UPDATE',
                            ],
                            resources: ['targetgroupbindings'],
                        }],
                    sideEffects: 'None',
                },
            ],
        });
    }
    argsFunc(args) {
        const defaultArgs = ['--ingress-class=alb', `--cluster-name=${this.clusterName}`];
        if (args) {
            args.forEach(e => defaultArgs.push(e));
        }
        return defaultArgs;
    }
    envFunc(envSet) {
        return envSet;
    }
}
exports.AwsLoadBalancerController = AwsLoadBalancerController;
_a = JSII_RTTI_SYMBOL_1;
AwsLoadBalancerController[_a] = { fqn: "@opencdk8s/cdk8s-aws-lb-controller.AwsLoadBalancerController", version: "0.0.1" };
//# sourceMappingURL=data:application/json;base64,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