"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RouteEntry = exports.RouteEntryProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const cen_generated_1 = require("./cen.generated");
Object.defineProperty(exports, "RouteEntryProperty", { enumerable: true, get: function () { return cen_generated_1.RosRouteEntry; } });
/**
 * A ROS resource type:  `ALIYUN::CEN::RouteEntry`
 */
class RouteEntry extends ros.Resource {
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the properties of this ROS resource, which will be assigned to ROS resource.
     */
    /**
     * Create a new `ALIYUN::CEN::RouteEntry`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosRouteEntry = new cen_generated_1.RosRouteEntry(this, id, {
            childInstanceType: props.childInstanceType,
            cenId: props.cenId,
            destinationCidrBlock: props.destinationCidrBlock,
            childInstanceRouteTableId: props.childInstanceRouteTableId,
            childInstanceId: props.childInstanceId,
            childInstanceRegionId: props.childInstanceRegionId,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosRouteEntry;
    }
}
exports.RouteEntry = RouteEntry;
//# sourceMappingURL=data:application/json;base64,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