"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CenInstanceAttachment = exports.CenInstanceAttachmentProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const cen_generated_1 = require("./cen.generated");
Object.defineProperty(exports, "CenInstanceAttachmentProperty", { enumerable: true, get: function () { return cen_generated_1.RosCenInstanceAttachment; } });
/**
 * A ROS resource type:  `ALIYUN::CEN::CenInstanceAttachment`
 */
class CenInstanceAttachment extends ros.Resource {
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the properties of this ROS resource, which will be assigned to ROS resource.
     */
    /**
     * Create a new `ALIYUN::CEN::CenInstanceAttachment`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosCenInstanceAttachment = new cen_generated_1.RosCenInstanceAttachment(this, id, {
            childInstanceType: props.childInstanceType,
            cenId: props.cenId,
            childInstanceOwnerId: props.childInstanceOwnerId,
            childInstanceId: props.childInstanceId,
            childInstanceRegionId: props.childInstanceRegionId,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosCenInstanceAttachment;
    }
}
exports.CenInstanceAttachment = CenInstanceAttachment;
//# sourceMappingURL=data:application/json;base64,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