"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CenInstance = exports.CenInstanceProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const cen_generated_1 = require("./cen.generated");
Object.defineProperty(exports, "CenInstanceProperty", { enumerable: true, get: function () { return cen_generated_1.RosCenInstance; } });
/**
 * A ROS resource type:  `ALIYUN::CEN::CenInstance`
 */
class CenInstance extends ros.Resource {
    /**
     * Create a new `ALIYUN::CEN::CenInstance`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props = {}, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosCenInstance = new cen_generated_1.RosCenInstance(this, id, {
            description: props.description,
            name: props.name,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosCenInstance;
        this.attrCenId = rosCenInstance.attrCenId;
    }
}
exports.CenInstance = CenInstance;
//# sourceMappingURL=data:application/json;base64,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