"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CenBandwidthPackage = exports.CenBandwidthPackageProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const cen_generated_1 = require("./cen.generated");
Object.defineProperty(exports, "CenBandwidthPackageProperty", { enumerable: true, get: function () { return cen_generated_1.RosCenBandwidthPackage; } });
/**
 * A ROS resource type:  `ALIYUN::CEN::CenBandwidthPackage`
 */
class CenBandwidthPackage extends ros.Resource {
    /**
     * Create a new `ALIYUN::CEN::CenBandwidthPackage`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosCenBandwidthPackage = new cen_generated_1.RosCenBandwidthPackage(this, id, {
            description: props.description,
            bandwidthPackageChargeType: props.bandwidthPackageChargeType,
            geographicRegionBId: props.geographicRegionBId,
            geographicRegionAId: props.geographicRegionAId,
            pricingCycle: props.pricingCycle ? props.pricingCycle : 'Month',
            autoRenew: props.autoRenew,
            bandwidth: props.bandwidth,
            period: props.period ? props.period : 1,
            autoPay: props.autoPay ? props.autoPay : false,
            autoRenewDuration: props.autoRenewDuration,
            name: props.name,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosCenBandwidthPackage;
        this.attrCenBandwidthPackageId = rosCenBandwidthPackage.attrCenBandwidthPackageId;
    }
}
exports.CenBandwidthPackage = CenBandwidthPackage;
//# sourceMappingURL=data:application/json;base64,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