"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CenBandwidthLimit = exports.CenBandwidthLimitProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const cen_generated_1 = require("./cen.generated");
Object.defineProperty(exports, "CenBandwidthLimitProperty", { enumerable: true, get: function () { return cen_generated_1.RosCenBandwidthLimit; } });
/**
 * A ROS resource type:  `ALIYUN::CEN::CenBandwidthLimit`
 */
class CenBandwidthLimit extends ros.Resource {
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the properties of this ROS resource, which will be assigned to ROS resource.
     */
    /**
     * Create a new `ALIYUN::CEN::CenBandwidthLimit`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosCenBandwidthLimit = new cen_generated_1.RosCenBandwidthLimit(this, id, {
            oppositeRegionId: props.oppositeRegionId,
            cenId: props.cenId,
            bandwidthLimit: props.bandwidthLimit,
            localRegionId: props.localRegionId,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosCenBandwidthLimit;
    }
}
exports.CenBandwidthLimit = CenBandwidthLimit;
//# sourceMappingURL=data:application/json;base64,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