# coding: utf-8

"""
    FINBOURNE Insights API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Any, Dict, List, Optional, Union
from pydantic.v1 import BaseModel, Field, StrictFloat, StrictInt, conlist, constr
from finbourne_insights.models.link import Link

class VendorLog(BaseModel):
    """
    Holds logged information about a request made to an external vendor.  # noqa: E501
    """
    id: constr(strict=True, min_length=1) = Field(..., description="The identifier of a log entry.")
    provider: constr(strict=True, min_length=1) = Field(..., description="The provider or service name.")
    timestamp: datetime = Field(..., description="Timestamp of when the log was generated.")
    type: constr(strict=True, min_length=1) = Field(..., description="Type of log. Possible values: HttpResponse.")
    destination_url: constr(strict=True, min_length=1) = Field(..., alias="destinationUrl", description="The destination URL of the task.")
    operation: constr(strict=True, min_length=1) = Field(..., description="The operation performed. Possible values: Evaluate.")
    outcome: constr(strict=True, min_length=1) = Field(..., description="The outcome of the operation. Possible values: Success, Failure.")
    duration: Union[StrictFloat, StrictInt] = Field(..., description="The duration of the operation in ms.")
    http_status_code: StrictInt = Field(..., alias="httpStatusCode", description="The status code of the operation.")
    user_id: constr(strict=True, min_length=1) = Field(..., alias="userId", description="The user that made the request to LUSID.")
    request_id: constr(strict=True, min_length=1) = Field(..., alias="requestId", description="The ID of the request to LUSID.")
    links: Optional[conlist(Link)] = None
    __properties = ["id", "provider", "timestamp", "type", "destinationUrl", "operation", "outcome", "duration", "httpStatusCode", "userId", "requestId", "links"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> VendorLog:
        """Create an instance of VendorLog from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in links (list)
        _items = []
        if self.links:
            for _item in self.links:
                if _item:
                    _items.append(_item.to_dict())
            _dict['links'] = _items
        # set to None if links (nullable) is None
        # and __fields_set__ contains the field
        if self.links is None and "links" in self.__fields_set__:
            _dict['links'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> VendorLog:
        """Create an instance of VendorLog from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return VendorLog.parse_obj(obj)

        _obj = VendorLog.parse_obj({
            "id": obj.get("id"),
            "provider": obj.get("provider"),
            "timestamp": obj.get("timestamp"),
            "type": obj.get("type"),
            "destination_url": obj.get("destinationUrl"),
            "operation": obj.get("operation"),
            "outcome": obj.get("outcome"),
            "duration": obj.get("duration"),
            "http_status_code": obj.get("httpStatusCode"),
            "user_id": obj.get("userId"),
            "request_id": obj.get("requestId"),
            "links": [Link.from_dict(_item) for _item in obj.get("links")] if obj.get("links") is not None else None
        })
        return _obj
