# coding: utf-8

"""
    FINBOURNE Insights API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Any, Dict, List, Optional, Union
from pydantic.v1 import BaseModel, Field, StrictFloat, StrictInt, StrictStr, conlist, constr, validator
from finbourne_insights.models.link import Link

class AccessEvaluationLog(BaseModel):
    """
    Holds logged information about an access check performed on an API.  # noqa: E501
    """
    timestamp: datetime = Field(..., description="The timestamp of the access evaluation.")
    application: constr(strict=True, min_length=1) = Field(..., description="The name of the application that the request was made from.")
    id: constr(strict=True, min_length=1) = Field(..., description="The ID of the access evaluation.")
    request_id: Optional[StrictStr] = Field(None, alias="requestId", description="The identifier of the request.")
    session_id: Optional[StrictStr] = Field(None, alias="sessionId", description="The identifier of the session that the request was made in.")
    user: constr(strict=True, min_length=1) = Field(..., description="The user who made the request.")
    user_type: Optional[StrictStr] = Field(None, alias="userType", description="The type of the user who made the request.")
    duration: Union[StrictFloat, StrictInt] = Field(..., description="The duration of the access evaluation.")
    result: Optional[StrictStr] = Field(None, description="The result of the access evaluation.")
    authoritative_role_id: Optional[StrictStr] = Field(None, alias="authoritativeRoleId", description="The role that matched the access evaluation to provide a result.")
    authoritative_policy_id: Optional[StrictStr] = Field(None, alias="authoritativePolicyId", description="The policy that matched the access evaluation to provide a result.")
    authoritative_selector: Optional[StrictStr] = Field(None, alias="authoritativeSelector", description="The selector that matched the access evaluation to provide a result.")
    resource_type: Optional[StrictStr] = Field(None, alias="resourceType", description="The type of the resource that the access evaluation is for.")
    action: Optional[StrictStr] = Field(None, description="The action key of the access evaluation.")
    resource: Optional[Dict[str, StrictStr]] = Field(None, description="The ID of the resource that the access evaluation is for. If the ResourceID could not be converted to a dictionary, it will return a single-value dictionary with the key \"resourceId\".")
    resource_from_effective_date: Optional[StrictStr] = Field(None, alias="resourceFromEffectiveDate", description="The From effective date of the resource.")
    resource_to_effective_date: Optional[StrictStr] = Field(None, alias="resourceToEffectiveDate", description="The To effective date of the resource.")
    resource_from_as_at: Optional[StrictStr] = Field(None, alias="resourceFromAsAt", description="The From AsAt date of the resource.")
    resource_to_as_at: Optional[StrictStr] = Field(None, alias="resourceToAsAt", description="The To AsAt date of the resource.")
    access_execution_time: Optional[StrictStr] = Field(None, alias="accessExecutionTime", description="The execution time of the entitlement.")
    access_as_at_time: Optional[StrictStr] = Field(None, alias="accessAsAtTime", description="The AsAt time of the entitlement.")
    required_licence_policy_id: Optional[constr(strict=True, max_length=64, min_length=1)] = Field(None, alias="requiredLicencePolicyId", description="ID of the required licence policy.")
    links: Optional[conlist(Link)] = None
    __properties = ["timestamp", "application", "id", "requestId", "sessionId", "user", "userType", "duration", "result", "authoritativeRoleId", "authoritativePolicyId", "authoritativeSelector", "resourceType", "action", "resource", "resourceFromEffectiveDate", "resourceToEffectiveDate", "resourceFromAsAt", "resourceToAsAt", "accessExecutionTime", "accessAsAtTime", "requiredLicencePolicyId", "links"]

    @validator('required_licence_policy_id')
    def required_licence_policy_id_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^[a-zA-Z0-9\-_:\+]+$", value):
            raise ValueError(r"must validate the regular expression /^[a-zA-Z0-9\-_:\+]+$/")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> AccessEvaluationLog:
        """Create an instance of AccessEvaluationLog from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in links (list)
        _items = []
        if self.links:
            for _item in self.links:
                if _item:
                    _items.append(_item.to_dict())
            _dict['links'] = _items
        # set to None if request_id (nullable) is None
        # and __fields_set__ contains the field
        if self.request_id is None and "request_id" in self.__fields_set__:
            _dict['requestId'] = None

        # set to None if session_id (nullable) is None
        # and __fields_set__ contains the field
        if self.session_id is None and "session_id" in self.__fields_set__:
            _dict['sessionId'] = None

        # set to None if user_type (nullable) is None
        # and __fields_set__ contains the field
        if self.user_type is None and "user_type" in self.__fields_set__:
            _dict['userType'] = None

        # set to None if result (nullable) is None
        # and __fields_set__ contains the field
        if self.result is None and "result" in self.__fields_set__:
            _dict['result'] = None

        # set to None if authoritative_role_id (nullable) is None
        # and __fields_set__ contains the field
        if self.authoritative_role_id is None and "authoritative_role_id" in self.__fields_set__:
            _dict['authoritativeRoleId'] = None

        # set to None if authoritative_policy_id (nullable) is None
        # and __fields_set__ contains the field
        if self.authoritative_policy_id is None and "authoritative_policy_id" in self.__fields_set__:
            _dict['authoritativePolicyId'] = None

        # set to None if authoritative_selector (nullable) is None
        # and __fields_set__ contains the field
        if self.authoritative_selector is None and "authoritative_selector" in self.__fields_set__:
            _dict['authoritativeSelector'] = None

        # set to None if resource_type (nullable) is None
        # and __fields_set__ contains the field
        if self.resource_type is None and "resource_type" in self.__fields_set__:
            _dict['resourceType'] = None

        # set to None if action (nullable) is None
        # and __fields_set__ contains the field
        if self.action is None and "action" in self.__fields_set__:
            _dict['action'] = None

        # set to None if resource (nullable) is None
        # and __fields_set__ contains the field
        if self.resource is None and "resource" in self.__fields_set__:
            _dict['resource'] = None

        # set to None if resource_from_effective_date (nullable) is None
        # and __fields_set__ contains the field
        if self.resource_from_effective_date is None and "resource_from_effective_date" in self.__fields_set__:
            _dict['resourceFromEffectiveDate'] = None

        # set to None if resource_to_effective_date (nullable) is None
        # and __fields_set__ contains the field
        if self.resource_to_effective_date is None and "resource_to_effective_date" in self.__fields_set__:
            _dict['resourceToEffectiveDate'] = None

        # set to None if resource_from_as_at (nullable) is None
        # and __fields_set__ contains the field
        if self.resource_from_as_at is None and "resource_from_as_at" in self.__fields_set__:
            _dict['resourceFromAsAt'] = None

        # set to None if resource_to_as_at (nullable) is None
        # and __fields_set__ contains the field
        if self.resource_to_as_at is None and "resource_to_as_at" in self.__fields_set__:
            _dict['resourceToAsAt'] = None

        # set to None if access_execution_time (nullable) is None
        # and __fields_set__ contains the field
        if self.access_execution_time is None and "access_execution_time" in self.__fields_set__:
            _dict['accessExecutionTime'] = None

        # set to None if access_as_at_time (nullable) is None
        # and __fields_set__ contains the field
        if self.access_as_at_time is None and "access_as_at_time" in self.__fields_set__:
            _dict['accessAsAtTime'] = None

        # set to None if required_licence_policy_id (nullable) is None
        # and __fields_set__ contains the field
        if self.required_licence_policy_id is None and "required_licence_policy_id" in self.__fields_set__:
            _dict['requiredLicencePolicyId'] = None

        # set to None if links (nullable) is None
        # and __fields_set__ contains the field
        if self.links is None and "links" in self.__fields_set__:
            _dict['links'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> AccessEvaluationLog:
        """Create an instance of AccessEvaluationLog from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return AccessEvaluationLog.parse_obj(obj)

        _obj = AccessEvaluationLog.parse_obj({
            "timestamp": obj.get("timestamp"),
            "application": obj.get("application"),
            "id": obj.get("id"),
            "request_id": obj.get("requestId"),
            "session_id": obj.get("sessionId"),
            "user": obj.get("user"),
            "user_type": obj.get("userType"),
            "duration": obj.get("duration"),
            "result": obj.get("result"),
            "authoritative_role_id": obj.get("authoritativeRoleId"),
            "authoritative_policy_id": obj.get("authoritativePolicyId"),
            "authoritative_selector": obj.get("authoritativeSelector"),
            "resource_type": obj.get("resourceType"),
            "action": obj.get("action"),
            "resource": obj.get("resource"),
            "resource_from_effective_date": obj.get("resourceFromEffectiveDate"),
            "resource_to_effective_date": obj.get("resourceToEffectiveDate"),
            "resource_from_as_at": obj.get("resourceFromAsAt"),
            "resource_to_as_at": obj.get("resourceToAsAt"),
            "access_execution_time": obj.get("accessExecutionTime"),
            "access_as_at_time": obj.get("accessAsAtTime"),
            "required_licence_policy_id": obj.get("requiredLicencePolicyId"),
            "links": [Link.from_dict(_item) for _item in obj.get("links")] if obj.get("links") is not None else None
        })
        return _obj
