# spawny

*Spawn python code in a separate python interpreter and communicate with it easily.*

[![Python versions](https://img.shields.io/pypi/pyversions/spawny.svg)](https://pypi.python.org/pypi/spawny/) [![Build Status](https://travis-ci.org/smarie/python-spawny.svg?branch=master)](https://travis-ci.org/smarie/python-spawny) [![Tests Status](https://smarie.github.io/python-spawny/junit/junit-badge.svg?dummy=8484744)](https://smarie.github.io/python-spawny/junit/report.html) [![codecov](https://codecov.io/gh/smarie/python-spawny/branch/master/graph/badge.svg)](https://codecov.io/gh/smarie/python-spawny)

[![Documentation](https://img.shields.io/badge/doc-latest-blue.svg)](https://smarie.github.io/python-spawny/) [![PyPI](https://img.shields.io/pypi/v/spawny.svg)](https://pypi.python.org/pypi/spawny/) [![Downloads](https://pepy.tech/badge/spawny)](https://pepy.tech/project/spawny) [![Downloads per week](https://pepy.tech/badge/spawny/week)](https://pepy.tech/project/spawny) [![GitHub stars](https://img.shields.io/github/stars/smarie/python-spawny.svg)](https://github.com/smarie/python-spawny/stargazers)

**This is the readme for developers.** The documentation for users is available here: [https://smarie.github.io/python-spawny/](https://smarie.github.io/python-spawny/)

## Want to contribute ?

Contributions are welcome ! Simply fork this project on github, commit your contributions, and create pull requests.

Here is a non-exhaustive list of interesting open topics: [https://github.com/smarie/python-spawny/issues](https://github.com/smarie/python-spawny/issues)

## Running the tests

This project uses `pytest`.

```bash
pytest -v spawny/tests/
```

You may need to install requirements for setup beforehand, using 

```bash
pip install -r ci_tools/requirements-test.txt
```

## Packaging

This project uses `setuptools_scm` to synchronise the version number. Therefore the following command should be used for development snapshots as well as official releases: 

```bash
python setup.py egg_info bdist_wheel rotate -m.whl -k3
```

You may need to install requirements for setup beforehand, using 

```bash
pip install -r ci_tools/requirements-setup.txt
```

## Generating the documentation page

This project uses `mkdocs` to generate its documentation page. Therefore building a local copy of the doc page may be done using:

```bash
mkdocs build -f docs/mkdocs.yml
```

You may need to install requirements for doc beforehand, using 

```bash
pip install -r ci_tools/requirements-doc.txt
```

## Generating the test reports

The following commands generate the html test report and the associated badge. 

```bash
pytest --junitxml=junit.xml -v spawny/tests/
ant -f ci_tools/generate-junit-html.xml
python ci_tools/generate-junit-badge.py
```

### PyPI Releasing memo

This project is now automatically deployed to PyPI when a tag is created. Anyway, for manual deployment we can use:

```bash
twine upload dist/* -r pypitest
twine upload dist/*
```
