"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
//import { expect as expectCDK, haveResource, SynthUtils } from '@aws-cdk/assert';
require("@aws-cdk/assert/jest");
const cdk = require("@aws-cdk/core");
const index_1 = require("../lib/index");
const CdkApexCnameProps = {
    apexName: 'apex.com',
    recordName: 'cname.example.com',
    hostedZoneId: 'ZONE1234',
    apexCnameRuleCron: "cron(0 * ? * * *)"
};
test('Lambda Function Created', () => {
    const app = new cdk.App();
    const stack = new cdk.Stack(app, "TestStack");
    // WHEN
    new index_1.CdkApexCname(stack, 'MyTestConstruct', CdkApexCnameProps);
    // THEN
    expect(stack).toHaveResource("AWS::Lambda::Function");
});
test('Event Rule Created', () => {
    const app = new cdk.App();
    const stack = new cdk.Stack(app, "TestStack");
    // WHEN
    new index_1.CdkApexCname(stack, 'MyTestConstruct', CdkApexCnameProps);
    // THEN
    expect(stack).toHaveResource("AWS::Events::Rule", {
        "ScheduleExpression": CdkApexCnameProps.apexCnameRuleCron
    });
});
//# sourceMappingURL=data:application/json;base64,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