"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cdk = require("@aws-cdk/core");
const lambda = require("@aws-cdk/aws-lambda");
const events = require("@aws-cdk/aws-events");
const targets = require("@aws-cdk/aws-events-targets");
const iam = require("@aws-cdk/aws-iam");
const fs = require("fs");
class CdkApexCname extends cdk.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const lambdaPolicyChangeResourceRecordSets = new iam.PolicyStatement({
            actions: [
                "route53:ChangeResourceRecordSets"
            ],
            resources: [`arn:aws:route53:::hostedzone/${props.hostedZoneId}`]
        });
        const apexCnameLambda = new lambda.Function(this, 'apexCnameLambda', {
            code: new lambda.InlineCode(fs.readFileSync(`lib/lambda.js`, { encoding: 'utf-8' })),
            handler: 'index.handler',
            runtime: lambda.Runtime.NODEJS_12_X,
            environment: {
                APEXNAME: props.apexName,
                RECORDNAME: props.recordName,
                HOSTEDZONEID: props.hostedZoneId,
            },
            initialPolicy: [lambdaPolicyChangeResourceRecordSets]
        });
        const apexCnameRule = new events.Rule(this, 'apexCnameRule', {
            schedule: events.Schedule.expression(props.apexCnameRuleCron)
        });
        apexCnameRule.addTarget(new targets.LambdaFunction(apexCnameLambda));
        this.functionArn = apexCnameLambda.functionArn;
    }
}
exports.CdkApexCname = CdkApexCname;
//# sourceMappingURL=data:application/json;base64,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