#!/usr/bin/env python3
# -*- coding: utf-8 -*-
#
# This file is execfile()d with the current directory set to its
# containing dir.
#
# Note that not all possible configuration values are present in this
# autogenerated file.
#
# All configuration values have a default; values that are commented out
# serve to show the default.

import sys

# If extensions (or modules to document with autodoc) are in another directory,
# add these directories to sys.path here. If the directory is relative to the
# documentation root, use os.path.abspath to make it absolute, like shown here.
from pathlib import Path

from docutils.nodes import Text
from sphinx.ext.intersphinx import missing_reference

import vivarium_inputs

base_dir = Path(vivarium_inputs.__file__).parent

about = {}
with (base_dir / "__about__.py").open() as f:
    exec(f.read(), about)

sys.path.insert(0, str(Path("..").resolve()))

# -- Project information -----------------------------------------------------

project = about["__title__"]
copyright = f'2021, {about["__author__"]}'
author = about["__author__"]

# The short X.Y version.
version = about["__version__"]
# The full version, including alpha/beta/rc tags.
release = about["__version__"]


# -- General configuration ------------------------------------------------

# If your documentation needs a minimal Sphinx version, state it here.

needs_sphinx = "4.0"

# Add any Sphinx extension module names here, as strings. They can be
# extensions coming with Sphinx (named 'sphinx.ext.*') or your custom
# ones.
extensions = [
    "sphinx.ext.autodoc",
    "sphinx.ext.intersphinx",
    "sphinx.ext.doctest",
    "sphinx.ext.todo",
    "sphinx.ext.coverage",
    "sphinx.ext.mathjax",
    "sphinx.ext.napoleon",
    "sphinx.ext.viewcode",
]

# Add any paths that contain templates here, relative to this directory.
templates_path = ["_templates"]

# The suffix(es) of source filenames.
# You can specify multiple suffix as a list of string:
#
# source_suffix = ['.rst', '.md']
source_suffix = ".rst"

# The master toctree document.
master_doc = "index"

# General information about the project.


# The language for content autogenerated by Sphinx. Refer to documentation
# for a list of supported languages.
#
# This is also used if you do content translation via gettext catalogs.
# Usually you set "language" from the command line for these cases.
language = None

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
# This patterns also effect to html_static_path and html_extra_path
exclude_patterns = []

# The name of the Pygments (syntax highlighting) style to use.
pygments_style = "sphinx"

# If true, `todo` and `todoList` produce output, else they produce nothing.
todo_include_todos = True


# -- Options for HTML output ----------------------------------------------

# The theme to use for HTML and HTML Help pages.  See the documentation for
# a list of builtin themes.

html_theme_path = ["_theme"]
html_theme = "sphinx_rtd_theme"

# Theme options are theme-specific and customize the look and feel of a theme
# further.  For a list of options available for each theme, see the
# documentation.
#
# html_theme_options = {}

# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css".
html_static_path = ["_static"]

# Custom sidebar templates, must be a dictionary that maps document names
# to template names.
#
# This is required for the alabaster theme
# refs: http://alabaster.readthedocs.io/en/latest/installation.html#sidebars
html_sidebars = {
    "**": [
        "globaltoc.html",  # needs 'show_related': True theme option to display
        "searchbox.html",
    ]
}


# -- Options for HTMLHelp output ------------------------------------------

# Output file base name for HTML help builder.
htmlhelp_basename = f'{about["__title__"]}doc'


# -- Options for LaTeX output ---------------------------------------------

latex_elements = {
    # The paper size ('letterpaper' or 'a4paper').
    #
    # 'papersize': 'letterpaper',
    # The font size ('10pt', '11pt' or '12pt').
    #
    # 'pointsize': '10pt',
    # Additional stuff for the LaTeX preamble.
    #
    # 'preamble': '',
    # Latex figure (float) alignment
    #
    # 'figure_align': 'htbp',
}

# Grouping the document tree into LaTeX files. List of tuples
# (source start file, target name, title,
#  author, documentclass [howto, manual, or own class]).
latex_documents = [
    (
        master_doc,
        f'{about["__title__"]}.tex',
        f'{about["__title__"]} Documentation',
        about["__author__"],
        "manual",
    ),
]


# -- Options for manual page output ---------------------------------------

# One entry per manual page. List of tuples
# (source start file, name, description, authors, manual section).
man_pages = [
    (master_doc, f'{about["__title__"]}', f'{about["__title__"]} Documentation', [author], 1)
]


# -- Options for Texinfo output -------------------------------------------

# Grouping the document tree into Texinfo files. List of tuples
# (source start file, target name, title, author,
#  dir menu entry, description, category)
texinfo_documents = [
    (
        master_doc,
        f'{about["__title__"]}',
        f'{about["__title__"]} Documentation',
        author,
        f'{about["__title__"]}',
        about["__summary__"],
        "Miscellaneous",
    ),
]

# Other docs we can link to
intersphinx_mapping = {
    "python": ("https://docs.python.org/3.8", None),
    "pandas": ("https://pandas.pydata.org/pandas-docs/stable/", None),
    "tables": ("https://www.pytables.org/", None),
    "numpy": ("https://numpy.org/doc/stable/", None),
    "networkx": ("https://networkx.org/documentation/stable/", None),
    'vivarium': ('https://vivarium.readthedocs.io/en/latest/', None),
    'gbd_mapping': ('https://gbd_mapping.readthedocs.io/en/latest/', None),
}


# -- Autodoc configuration ------------------------------------------------

autodoc_default_options = {
    # Automatically document members (e.g. classes in a module,
    # methods in a class, etc.)
    "members": True,
    # Order of items documented is determined by the order
    # of appearance in the source code
    "member-order": "bysource",
    # Generate docs even if an item has no docstring.
    "undoc-members": True,
    # Don't document things with a leading underscore.
    "private-members": False,
}
# Display type hints in the description instead of the signature.
autodoc_typehints = "description"


# -- nitpicky mode --------------------------------------------------------
# Ensures that all references in the docs resolve.

nitpicky = True

nitpick_ignore = []
for line in open("../nitpick-exceptions"):
    if line.strip() == "" or line.startswith("#"):
        continue
    dtype, target = line.split(None, 1)
    target = target.strip()
    nitpick_ignore.append((dtype, target))


# Fix sphinx warnings when for literal Ellipses in type hints.
def setup(app):
    app.connect("missing-reference", __sphinx_issue_8127)


def __sphinx_issue_8127(app, env, node, contnode):
    reftarget = node.get("reftarget", None)
    if reftarget == "..":
        node["reftype"] = "data"
        node["reftarget"] = "Ellipsis"
        text_node = next(iter(contnode.traverse(lambda n: n.tagname == "#text")))
        replacement_node = Text("...", "")
        if text_node.parent is not None:
            text_node.parent.replace(text_node, replacement_node)
        else:  # e.g. happens in rtype fields
            contnode = replacement_node
        return missing_reference(app, env, node, contnode)
