# multiSyncPy
multiSyncPy is a Python package for quantifying multivariate synchrony. Our package supports the burgeoning field of research into synchrony, making accessible a set of methods for studying group-level rather than dyadic constructs of synchrony and/or coordination. We offer a range of metrics for estimating mulivariate synchrony based on a collection of those used in recent literature.

The main methods of this package are functions to calculate:

 * symbolic entropy, 
 * multidimensional recurrence quantification, 
 * coherence (and a related 'sum-normalized CSD' metric),
 * the cluster-phase 'Rho' metric, and 
 * a statistical test based on the Kuramoto order parameter

We also include functions for two surrogation techniques to compare the observed coordination dynamics with chance levels.

multiSyncPy is freely available under the LGPL license. The source code is maintained at <https://github.com/cslab-hub/multiSyncPy>, which also includes examples of usage of the package. Documentation can be accessed through `help()` or accessed at <https://cslab-hub.github.io/multiSyncPy/>. 

Further details of the package and case studies of its use on real-world data are described in our paper *multiSyncPy: A Python Package for Assessing Multivariate Coordination Dynamics*, available as a pre-print here: <https://psyarxiv.com/abquk/>. Please cite this paper if you use multiSyncPy in your research. Example citation (APA style):

Hudson, D., Wiltshire, T. J., & Atzmueller, M. (2021, April 28). multiSyncPy: A Python Package for Assessing Multivariate Coordination Dynamics. https://doi.org/10.31234/osf.io/abquk
