"""Base filesystem classes."""

from __future__ import annotations

from upathtools.filesystems.base.basefilesystem import BaseAsyncFileSystem, BaseFileSystem
from upathtools.filesystems.base.baseupath import BaseUPath
from upathtools.filesystems.base.file_objects import (
    AsyncBufferedFile,
    AsyncFile,
    AsyncReadable,
    AsyncSeekable,
    AsyncWritable,
    BufferedWriter,
    FileInfo,
)
from upathtools.filesystems.base.filefilesystem import (
    BaseAsyncFileFileSystem,
    BaseFileFileSystem,
    FileFileSystemMixin,
    ProbeResult,
)
from upathtools.filesystems.base.wrapper import WrapperFileSystem

__all__ = [
    "AsyncBufferedFile",
    "AsyncFile",
    "AsyncReadable",
    "AsyncSeekable",
    "AsyncWritable",
    "BaseAsyncFileFileSystem",
    "BaseAsyncFileSystem",
    "BaseFileFileSystem",
    "BaseFileSystem",
    "BaseUPath",
    "BufferedWriter",
    "FileFileSystemMixin",
    "FileInfo",
    "ProbeResult",
    "WrapperFileSystem",
]
